/*
 * $Id: isa_gen_vga.c,v 1.71 2012-02-22 09:27:20 siflkres Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "chip_gen_vga.h"
#include "chip_st_M27C512.h"

#include "isa_gen_vga.h"

struct cpssp {
	struct sig_cs *rom_bus_cs;
	struct sig_isa_bus_main *rom_bus_isa;

	void *rom;
	void *chip;
};

void *
isa_gen_vga_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_isa_bus *port_isa,
	struct sig_vga *port_vga
)
{
	struct cpssp *cpssp;

	system_name_push(name);

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->rom_bus_cs = sig_cs_create("rom_bus_cs");

	cpssp->rom_bus_isa = sig_isa_bus_main_create("rom_bus_isa");

	cpssp->rom = chip_st_M27C512_create("BIOS", "vgabios.rom",
			NULL,
			port_isa->p5V, cpssp->rom_bus_cs,
			cpssp->rom_bus_isa);

	cpssp->chip = chip_gen_vga_create("VGA",
			NULL,
			port_isa->p5V, port_isa->n_reset,
			port_isa->main, port_vga->video,
			cpssp->rom_bus_cs);

	system_name_pop();

	return cpssp;
}

void
isa_gen_vga_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	chip_gen_vga_destroy(cpssp->chip);
	chip_st_M27C512_destroy(cpssp->rom);

	sig_isa_bus_main_destroy(cpssp->rom_bus_isa);
	sig_cs_destroy(cpssp->rom_bus_cs);

	shm_free(cpssp);
}

void
isa_gen_vga_suspend(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_suspend(cpssp, sizeof(*cpssp), fComp);
	
	chip_st_M27C512_suspend(cpssp->rom, fComp);

	chip_gen_vga_suspend(cpssp->chip, fComp);
}

void
isa_gen_vga_resume(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;
	
	generic_resume(cpssp, sizeof(*cpssp), fComp);
	
	chip_st_M27C512_resume(cpssp->rom, fComp);

	chip_gen_vga_resume(cpssp->chip, fComp);
}
