/* $Id$
 *
 * Interpreter kernel.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __KERNEL_H_INCLUDED
#define __KERNEL_H_INCLUDED

#include "fauhdli_private.h"

extern void
fauhdli_kernel_destroy(struct fauhdli *instance);

extern void
fauhdli_kernel_init(struct fauhdli *instance, const char *top_entity);

/** resolve driving values drv_values to ret with the given resolution
 *  function.
 *
 *  @param instance fauhdli instance.
 *  @param resolver container of the pure resolution function.
 *  @param ret return value is stored there
 *  @param drv_values array of driving values.
 *  @param sz size of array.
 */
extern void
fauhdli_kernel_resolve(
	struct fauhdli *instance,
	const struct code_container *resolver, 
	union fauhdli_value *ret,
	union fauhdli_value *drv_values,
	size_t sz
);

/** Function to run the simulation cycle for the current simulation
 *  time. Should only be called by kernel itself and otherwise get
 *  registered as a callback if a foreign driver updates it's driving
 *  value.
 *
 *  @param _instance struct fauhdli instance pointer.
 */
void
fauhdli_kernel_simulation_cycle(void *_instance);

#endif /* __KERNEL_H_INCLUDED */

