/* $Id: fauhdlstring.c 5105 2012-02-17 21:08:43Z potyra $
 *
 * Helper functions for strings.
 *
 * Copyright (C) 2012 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "fauhdlstring.h"
#include <assert.h>
#include <string.h>

char *
fauhdlstrdup(const char *src, void *(allocator)(size_t))
{
	char *ret = NULL;
	size_t len = strlen(src) + 1;
	
	ret = allocator(len);
	assert(ret != NULL);

	memcpy(ret, src, len);

	return ret;
}
