/* $Id: AstNode.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/ast/AstNode.hpp"

namespace ast {

std::ostream&
operator<<(std::ostream &stream, const AstNode &node) {
	node.put(stream);
	return stream;
}

std::ostream&
operator<<(std::ostream &stream, const AstNode *node) {
	if (node != NULL) {
		node->put(stream);
	} else {
		stream << "(null)";
	}
	return stream;
}


}; /* namespace ast */
