// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file map_struct.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__MAP_STRUCT_HPP
#define FAST_DDS_GENERATED__MAP_STRUCT_HPP

#include <cstdint>
#include <map>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(MAP_STRUCT_SOURCE)
#define MAP_STRUCT_DllAPI __declspec( dllexport )
#else
#define MAP_STRUCT_DllAPI __declspec( dllimport )
#endif // MAP_STRUCT_SOURCE
#else
#define MAP_STRUCT_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define MAP_STRUCT_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure ValueStruct defined by the user in the IDL file.
 * @ingroup map_struct
 */
class ValueStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport ValueStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~ValueStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object ValueStruct that will be copied.
     */
    eProsima_user_DllExport ValueStruct(
            const ValueStruct& x)
    {
                    m_value = x.m_value;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object ValueStruct that will be copied.
     */
    eProsima_user_DllExport ValueStruct(
            ValueStruct&& x) noexcept
    {
        m_value = x.m_value;
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object ValueStruct that will be copied.
     */
    eProsima_user_DllExport ValueStruct& operator =(
            const ValueStruct& x)
    {

                    m_value = x.m_value;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object ValueStruct that will be copied.
     */
    eProsima_user_DllExport ValueStruct& operator =(
            ValueStruct&& x) noexcept
    {

        m_value = x.m_value;
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x ValueStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const ValueStruct& x) const
    {
        return (m_value == x.m_value);
    }

    /*!
     * @brief Comparison operator.
     * @param x ValueStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const ValueStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function sets a value in member value
     * @param _value New value for member value
     */
    eProsima_user_DllExport void value(
            bool _value)
    {
        m_value = _value;
    }

    /*!
     * @brief This function returns the value of member value
     * @return Value of member value
     */
    eProsima_user_DllExport bool value() const
    {
        return m_value;
    }

    /*!
     * @brief This function returns a reference to member value
     * @return Reference to member value
     */
    eProsima_user_DllExport bool& value()
    {
        return m_value;
    }



private:

    bool m_value{false};

};
/*!
 * @brief This class represents the structure MapStruct defined by the user in the IDL file.
 * @ingroup map_struct
 */
class MapStruct
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport MapStruct()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~MapStruct()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object MapStruct that will be copied.
     */
    eProsima_user_DllExport MapStruct(
            const MapStruct& x)
    {
                    m_my_basic_map = x.m_my_basic_map;

                    m_my_complex_map = x.m_my_complex_map;

                    m_my_basic_bounded_map = x.m_my_basic_bounded_map;

                    m_my_complex_bounded_map = x.m_my_complex_bounded_map;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object MapStruct that will be copied.
     */
    eProsima_user_DllExport MapStruct(
            MapStruct&& x) noexcept
    {
        m_my_basic_map = std::move(x.m_my_basic_map);
        m_my_complex_map = std::move(x.m_my_complex_map);
        m_my_basic_bounded_map = std::move(x.m_my_basic_bounded_map);
        m_my_complex_bounded_map = std::move(x.m_my_complex_bounded_map);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object MapStruct that will be copied.
     */
    eProsima_user_DllExport MapStruct& operator =(
            const MapStruct& x)
    {

                    m_my_basic_map = x.m_my_basic_map;

                    m_my_complex_map = x.m_my_complex_map;

                    m_my_basic_bounded_map = x.m_my_basic_bounded_map;

                    m_my_complex_bounded_map = x.m_my_complex_bounded_map;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object MapStruct that will be copied.
     */
    eProsima_user_DllExport MapStruct& operator =(
            MapStruct&& x) noexcept
    {

        m_my_basic_map = std::move(x.m_my_basic_map);
        m_my_complex_map = std::move(x.m_my_complex_map);
        m_my_basic_bounded_map = std::move(x.m_my_basic_bounded_map);
        m_my_complex_bounded_map = std::move(x.m_my_complex_bounded_map);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStruct object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const MapStruct& x) const
    {
        return (m_my_basic_map == x.m_my_basic_map &&
           m_my_complex_map == x.m_my_complex_map &&
           m_my_basic_bounded_map == x.m_my_basic_bounded_map &&
           m_my_complex_bounded_map == x.m_my_complex_bounded_map);
    }

    /*!
     * @brief Comparison operator.
     * @param x MapStruct object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const MapStruct& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member my_basic_map
     * @param _my_basic_map New value to be copied in member my_basic_map
     */
    eProsima_user_DllExport void my_basic_map(
            const std::map<std::string, bool>& _my_basic_map)
    {
        m_my_basic_map = _my_basic_map;
    }

    /*!
     * @brief This function moves the value in member my_basic_map
     * @param _my_basic_map New value to be moved in member my_basic_map
     */
    eProsima_user_DllExport void my_basic_map(
            std::map<std::string, bool>&& _my_basic_map)
    {
        m_my_basic_map = std::move(_my_basic_map);
    }

    /*!
     * @brief This function returns a constant reference to member my_basic_map
     * @return Constant reference to member my_basic_map
     */
    eProsima_user_DllExport const std::map<std::string, bool>& my_basic_map() const
    {
        return m_my_basic_map;
    }

    /*!
     * @brief This function returns a reference to member my_basic_map
     * @return Reference to member my_basic_map
     */
    eProsima_user_DllExport std::map<std::string, bool>& my_basic_map()
    {
        return m_my_basic_map;
    }


    /*!
     * @brief This function copies the value in member my_complex_map
     * @param _my_complex_map New value to be copied in member my_complex_map
     */
    eProsima_user_DllExport void my_complex_map(
            const std::map<std::string, ValueStruct>& _my_complex_map)
    {
        m_my_complex_map = _my_complex_map;
    }

    /*!
     * @brief This function moves the value in member my_complex_map
     * @param _my_complex_map New value to be moved in member my_complex_map
     */
    eProsima_user_DllExport void my_complex_map(
            std::map<std::string, ValueStruct>&& _my_complex_map)
    {
        m_my_complex_map = std::move(_my_complex_map);
    }

    /*!
     * @brief This function returns a constant reference to member my_complex_map
     * @return Constant reference to member my_complex_map
     */
    eProsima_user_DllExport const std::map<std::string, ValueStruct>& my_complex_map() const
    {
        return m_my_complex_map;
    }

    /*!
     * @brief This function returns a reference to member my_complex_map
     * @return Reference to member my_complex_map
     */
    eProsima_user_DllExport std::map<std::string, ValueStruct>& my_complex_map()
    {
        return m_my_complex_map;
    }


    /*!
     * @brief This function copies the value in member my_basic_bounded_map
     * @param _my_basic_bounded_map New value to be copied in member my_basic_bounded_map
     */
    eProsima_user_DllExport void my_basic_bounded_map(
            const std::map<int32_t, std::string>& _my_basic_bounded_map)
    {
        m_my_basic_bounded_map = _my_basic_bounded_map;
    }

    /*!
     * @brief This function moves the value in member my_basic_bounded_map
     * @param _my_basic_bounded_map New value to be moved in member my_basic_bounded_map
     */
    eProsima_user_DllExport void my_basic_bounded_map(
            std::map<int32_t, std::string>&& _my_basic_bounded_map)
    {
        m_my_basic_bounded_map = std::move(_my_basic_bounded_map);
    }

    /*!
     * @brief This function returns a constant reference to member my_basic_bounded_map
     * @return Constant reference to member my_basic_bounded_map
     */
    eProsima_user_DllExport const std::map<int32_t, std::string>& my_basic_bounded_map() const
    {
        return m_my_basic_bounded_map;
    }

    /*!
     * @brief This function returns a reference to member my_basic_bounded_map
     * @return Reference to member my_basic_bounded_map
     */
    eProsima_user_DllExport std::map<int32_t, std::string>& my_basic_bounded_map()
    {
        return m_my_basic_bounded_map;
    }


    /*!
     * @brief This function copies the value in member my_complex_bounded_map
     * @param _my_complex_bounded_map New value to be copied in member my_complex_bounded_map
     */
    eProsima_user_DllExport void my_complex_bounded_map(
            const std::map<int16_t, ValueStruct>& _my_complex_bounded_map)
    {
        m_my_complex_bounded_map = _my_complex_bounded_map;
    }

    /*!
     * @brief This function moves the value in member my_complex_bounded_map
     * @param _my_complex_bounded_map New value to be moved in member my_complex_bounded_map
     */
    eProsima_user_DllExport void my_complex_bounded_map(
            std::map<int16_t, ValueStruct>&& _my_complex_bounded_map)
    {
        m_my_complex_bounded_map = std::move(_my_complex_bounded_map);
    }

    /*!
     * @brief This function returns a constant reference to member my_complex_bounded_map
     * @return Constant reference to member my_complex_bounded_map
     */
    eProsima_user_DllExport const std::map<int16_t, ValueStruct>& my_complex_bounded_map() const
    {
        return m_my_complex_bounded_map;
    }

    /*!
     * @brief This function returns a reference to member my_complex_bounded_map
     * @return Reference to member my_complex_bounded_map
     */
    eProsima_user_DllExport std::map<int16_t, ValueStruct>& my_complex_bounded_map()
    {
        return m_my_complex_bounded_map;
    }



private:

    std::map<std::string, bool> m_my_basic_map;
    std::map<std::string, ValueStruct> m_my_complex_map;
    std::map<int32_t, std::string> m_my_basic_bounded_map;
    std::map<int16_t, ValueStruct> m_my_complex_bounded_map;

};

#endif // _FAST_DDS_GENERATED_MAP_STRUCT_HPP_


