/* Evoution RSS Reader Plugin
 * Copyright (C) 2007-2010 Lucian Langa <cooly@gnome.eu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA
 */

#ifndef RSS_CACHE_H
#define RSS_CACHE_H

#if (DATASERVER_VERSION >= 2031001)
#include <camel/camel.h>
#else
#include <camel/camel-data-cache.h>
#endif

#if (DATASERVER_VERSION >= 3011002)
#define RssCacheStream GIOStream
#else
#define RssCacheStream CamelStream
#endif

void rss_cache_init(void);
gchar *rss_cache_get_filename(gchar *url);
char* rss_cache_get_path(int create, const char *path);
RssCacheStream *rss_cache_add(gchar *url);

#endif /* RSS_CACHE_H */
