/***************************************************************************
 *   Copyright (C) 2008 by Hanna K.                                        *
 *   hanna_k@fmgirl.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "budget.h"
#include <kuniqueapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kconfig.h>
#include <kglobal.h>
#include "eqonomize.h"

QString emptystr = "";

int main(int argc, char **argv) {

	KAboutData about("eqonomize", 0, ki18n("Eqonomize!"), "0.6", ki18n("A personal accounting program"), KAboutData::License_GPL, ki18n("(C) 2008 Hanna K."), KLocalizedString(), "http://eqonomize.sourceforge.net/", "hanna_k@users.sourceforge.net");
	about.addAuthor(ki18n("Hanna K."), KLocalizedString(), "hanna_k@fmgirl.com");
	KCmdLineArgs::init(argc, argv, &about);
	KCmdLineOptions options;
	options.add("e");
	options.add("expenses", ki18n("Start with expenses list displayed"));
	options.add("i");
	options.add("incomes", ki18n("Start with incomes list displayed"));
	options.add("t");
	options.add("transfers", ki18n("Start with transfers list displayed"));
	options.add("+[URL]", ki18n("Document to open"));
	KCmdLineArgs::addCmdLineOptions(options);
	KUniqueApplication::addCmdLineOptions();
		
	if(!KUniqueApplication::start()) {
		RESTORE(Eqonomize)
 		return 0;
	}
	KUniqueApplication app;

	if(kapp->isSessionRestored()) {
		RESTORE(Eqonomize)
	} else {
		KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
		Eqonomize *win = new Eqonomize();
		kapp->setTopWidget(win);
		if(args->isSet("expenses")) {
			win->showExpenses();
		} else if(args->isSet("incomes")) {
			win->showIncomes();
		} else if(args->isSet("transfers")) {
			win->showTransfers();
		}
		win->show();
		qApp->processEvents();
		QString url = KGlobal::config()->group("General Options").readPathEntry("lastURL", QString());
		if(args->count() > 0) {
			win->openURL(args->url(0));
		} else if(!url.isEmpty()) {
			win->openURL(KUrl(url));
			win->readFileDependentOptions();
		} else {
			if(!win->crashRecovery(KUrl())) {
				win->createDefaultBudget();
			}
		}
		args->clear();
	}
	
	return app.exec();

}
