package de.lmu.ifi.dbs.elki.math.statistics.distribution;

/*
 This file is part of ELKI:
 Environment for Developing KDD-Applications Supported by Index-Structures

 Copyright (C) 2012
 Ludwig-Maximilians-Universität München
 Lehr- und Forschungseinheit für Datenbanksysteme
 ELKI Development Team

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU Affero General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU Affero General Public License for more details.

 You should have received a copy of the GNU Affero General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
import org.junit.Test;

import de.lmu.ifi.dbs.elki.JUnit4Test;

/**
 * Unit test for the exponential distribution in ELKI.
 * 
 * The reference values were computed using GNU R and SciPy.
 * 
 * @author Erich Schubert
 */
public class TestExponentialDistribution extends AbstractDistributionTest implements JUnit4Test {
  public static final double[] P_CDFPDF = { //
  1e-10, 1e-05, 0.1, 0.1234567, 0.2, 0.271828182846, 0.3, 0.314159265359, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 2.71828182846, 3.14159265359 //
  };

  public static final double[] SCIPY_EXP_CDF_01 = { //
  9.99999999995000020434998363876935860601602445996150e-12, // 0.000000
  9.99999500000166912315989475867894498151144944131374e-07, // 0.000010
  9.95016625083194709844303105228391359560191631317139e-03, // 0.100000
  1.22697748626232703422767045253749529365450143814087e-02, // 0.123457
  1.98013266932446987955707129458460258319973945617676e-02, // 0.200000
  2.68166904430214188270742425856951740570366382598877e-02, // 0.271828
  2.95544664514918210829197420252967276610434055328369e-02, // 0.300000
  3.09275736951893608084329656549016362987458705902100e-02, // 0.314159
  3.92105608476767883430191830029798438772559165954590e-02, // 0.400000
  4.87705754992859910612601481716410489752888679504395e-02, // 0.500000
  5.82354664157512871835997714242694200947880744934082e-02, // 0.600000
  6.76061800940517682034780477806634735316038131713867e-02, // 0.700000
  7.68836536133642167722967997178784571588039398193359e-02, // 0.800000
  8.60688147287718141598134025116451084613800048828125e-02, // 0.900000
  9.51625819640404269073030718573136255145072937011719e-02, // 1.000000
  1.04165864703471763852427045549120521172881126403809e-01, // 1.100000
  1.13079563282842479599032969872496323660016059875488e-01, // 1.200000
  1.21904569079438682144278516261692857369780540466309e-01, // 1.300000
  1.30641764601194171335762916896783281117677688598633e-01, // 1.400000
  1.39292023574942191999070928432047367095947265625000e-01, // 1.500000
  1.47856211033788653708143101539462804794311523437500e-01, // 1.600000
  1.56335183403616295727545093541266396641731262207031e-01, // 1.700000
  1.64729788588727971143654826846614014357328414916992e-01, // 1.800000
  1.73040866056637682168783953784441109746694564819336e-01, // 1.900000
  1.81269246922018151257915974383649881929159164428711e-01, // 2.000000
  2.38014828033141334628908225568011403083801269531250e-01, // 2.718282
  2.69597308951354364126018481329083442687988281250000e-01, // 3.141593
  };

  public static final double[] SCIPY_EXP_PDF_01 = { //
  9.99999999989999999172596290009096264839172363281250e-02, // 0.000000
  9.99999000000500043450202269923465792089700698852539e-02, // 0.000010
  9.90049833749168106677984724228736013174057006835938e-02, // 0.100000
  9.87730225137376793842491906616487540304660797119141e-02, // 0.123457
  9.80198673306755252632171959703555330634117126464844e-02, // 0.200000
  9.73183309556978626275736132811289280652999877929688e-02, // 0.271828
  9.70445533548508210142102825557230971753597259521484e-02, // 0.300000
  9.69072426304810607966544466762570664286613464355469e-02, // 0.314159
  9.60789439152323204718086913089791778475046157836914e-02, // 0.400000
  9.51229424500713988122058140106673818081617355346680e-02, // 0.500000
  9.41764533584248664244142901225131936371326446533203e-02, // 0.600000
  9.32393819905948245674309760033793281763792037963867e-02, // 0.700000
  9.23116346386635699960976353395381011068820953369141e-02, // 0.800000
  9.13931185271228130329035366230527870357036590576172e-02, // 0.900000
  9.04837418035959462070394465627032332122325897216797e-02, // 1.000000
  8.95834135296528222269785146636422723531723022460938e-02, // 1.100000
  8.86920436717157506523179222313046921044588088989258e-02, // 1.200000
  8.78095430920561303977933675923850387334823608398438e-02, // 1.300000
  8.69358235398805800908661467474303208291530609130859e-02, // 1.400000
  8.60707976425057752489777840310125611722469329833984e-02, // 1.500000
  8.52143788966211318536281282831623684614896774291992e-02, // 1.600000
  8.43664816596383648761303675200906582176685333251953e-02, // 1.700000
  8.35270211411272001100769557524472475051879882812500e-02, // 1.800000
  8.26959133943362262320064814957731869071722030639648e-02, // 1.900000
  8.18730753077981793230932794358523096889257431030273e-02, // 2.000000
  7.61985171966858693126667390060902107506990432739258e-02, // 2.718282
  7.30402691048645663629557134299830067902803421020508e-02, // 3.141593
  };

  public static final double[] GNUR_EXP_CDF_01 = { //
  9.99999999995000020434998363876935860601602445996150e-12, // 0.000000
  9.99999500000166912315989475867894498151144944131374e-07, // 0.000010
  9.95016625083194709844303105228391359560191631317139e-03, // 0.100000
  1.22697748626232703422767045253749529365450143814087e-02, // 0.123457
  1.98013266932446987955707129458460258319973945617676e-02, // 0.200000
  2.68166904430307134754585263181070331484079360961914e-02, // 0.271828
  2.95544664514918210829197420252967276610434055328369e-02, // 0.300000
  3.09275736951913661487711948439027764834463596343994e-02, // 0.314159
  3.92105608476767883430191830029798438772559165954590e-02, // 0.400000
  4.87705754992859910612601481716410489752888679504395e-02, // 0.500000
  5.82354664157512871835997714242694200947880744934082e-02, // 0.600000
  6.76061800940517682034780477806634735316038131713867e-02, // 0.700000
  7.68836536133642167722967997178784571588039398193359e-02, // 0.800000
  8.60688147287718141598134025116451084613800048828125e-02, // 0.900000
  9.51625819640404269073030718573136255145072937011719e-02, // 1.000000
  1.04165864703471763852427045549120521172881126403809e-01, // 1.100000
  1.13079563282842479599032969872496323660016059875488e-01, // 1.200000
  1.21904569079438682144278516261692857369780540466309e-01, // 1.300000
  1.30641764601194171335762916896783281117677688598633e-01, // 1.400000
  1.39292023574942191999070928432047367095947265625000e-01, // 1.500000
  1.47856211033788653708143101539462804794311523437500e-01, // 1.600000
  1.56335183403616295727545093541266396641731262207031e-01, // 1.700000
  1.64729788588727971143654826846614014357328414916992e-01, // 1.800000
  1.73040866056637682168783953784441109746694564819336e-01, // 1.900000
  1.81269246922018151257915974383649881929159164428711e-01, // 2.000000
  2.38014828033214109748172404579236172139644622802734e-01, // 2.718282
  2.69597308951369518670304614715860225260257720947266e-01, // 3.141593
  };

  public static final double[] GNUR_EXP_PDF_01 = { //
  9.99999999989999999172596290009096264839172363281250e-02, // 0.000000
  9.99999000000500043450202269923465792089700698852539e-02, // 0.000010
  9.90049833749168106677984724228736013174057006835938e-02, // 0.100000
  9.87730225137376793842491906616487540304660797119141e-02, // 0.123457
  9.80198673306755252632171959703555330634117126464844e-02, // 0.200000
  9.73183309556969328157904897125263232737779617309570e-02, // 0.271828
  9.70445533548508210142102825557230971753597259521484e-02, // 0.300000
  9.69072426304808665076251372738624922931194305419922e-02, // 0.314159
  9.60789439152323204718086913089791778475046157836914e-02, // 0.400000
  9.51229424500713988122058140106673818081617355346680e-02, // 0.500000
  9.41764533584248664244142901225131936371326446533203e-02, // 0.600000
  9.32393819905948245674309760033793281763792037963867e-02, // 0.700000
  9.23116346386635699960976353395381011068820953369141e-02, // 0.800000
  9.13931185271228130329035366230527870357036590576172e-02, // 0.900000
  9.04837418035959462070394465627032332122325897216797e-02, // 1.000000
  8.95834135296528222269785146636422723531723022460938e-02, // 1.100000
  8.86920436717157506523179222313046921044588088989258e-02, // 1.200000
  8.78095430920561303977933675923850387334823608398438e-02, // 1.300000
  8.69358235398805800908661467474303208291530609130859e-02, // 1.400000
  8.60707976425057752489777840310125611722469329833984e-02, // 1.500000
  8.52143788966211318536281282831623684614896774291992e-02, // 1.600000
  8.43664816596383648761303675200906582176685333251953e-02, // 1.700000
  8.35270211411272001100769557524472475051879882812500e-02, // 1.800000
  8.26959133943362262320064814957731869071722030639648e-02, // 1.900000
  8.18730753077981793230932794358523096889257431030273e-02, // 2.000000
  7.61985171966785973518554442307504359632730484008789e-02, // 2.718282
  7.30402691048630536840846616541966795921325683593750e-02, // 3.141593
  };

  public static final double[] SCIPY_EXP_CDF_05 = { //
  4.99999999987500026690715295475821817669515034765482e-11, // 0.000000
  4.99998750002083400397704521234132357676571700721979e-06, // 0.000010
  4.87705754992859910612601481716410489752888679504395e-02, // 0.100000
  5.98617593408454357062353778928809333592653274536133e-02, // 0.123457
  9.51625819640404269073030718573136255145072937011719e-02, // 0.200000
  1.27082379621731633712045095307985320687294006347656e-01, // 0.271828
  1.39292023574942191999070928432047367095947265625000e-01, // 0.300000
  1.45364000846766566743539783601590897887945175170898e-01, // 0.314159
  1.81269246922018151257915974383649881929159164428711e-01, // 0.400000
  2.21199216928595121522960198490181937813758850097656e-01, // 0.500000
  2.59181779318282123902861258102348074316978454589844e-01, // 0.600000
  2.95311910281286560397973062208620831370353698730469e-01, // 0.700000
  3.29679953964360727969307163220946677029132843017578e-01, // 0.800000
  3.62371848378226724118889023884548805654048919677734e-01, // 0.900000
  3.93469340287366575736882623459678143262863159179688e-01, // 1.000000
  4.23050189619513350436363907647319138050079345703125e-01, // 1.100000
  4.51188363905973555123551932410919107496738433837891e-01, // 1.200000
  4.77954223238983955113212687138002365827560424804688e-01, // 1.300000
  5.03414696208590473069932613725541159510612487792969e-01, // 1.400000
  5.27633447258985310845957883429946377873420715332031e-01, // 1.500000
  5.50671035882778436842954761232249438762664794921875e-01, // 1.600000
  5.72585068051273293754377391451271250844001770019531e-01, // 1.700000
  5.93430340259400890268182138242991641163825988769531e-01, // 1.800000
  6.13258976545498768473407835699617862701416015625000e-01, // 1.900000
  6.32120558828557665975722557050175964832305908203125e-01, // 2.000000
  7.43118634686529722088721428008284419775009155273438e-01, // 2.718282
  7.92120423649238070140654599526897072792053222656250e-01, // 3.141593
  };

  public static final double[] SCIPY_EXP_PDF_05 = { //
  4.99999999974999997931490725022740662097930908203125e-01, // 0.000000
  4.99997500006249984139117259474005550146102905273438e-01, // 0.000010
  4.75614712250357007938816877867793664336204528808594e-01, // 0.100000
  4.70069120329577261330200599331874400377273559570312e-01, // 0.123457
  4.52418709017979758790772848442429676651954650878906e-01, // 0.200000
  4.36458810189134183143977452346007339656352996826172e-01, // 0.271828
  4.30353988212528904000464535783976316452026367187500e-01, // 0.300000
  4.27317999576616702750442300384747795760631561279297e-01, // 0.314159
  4.09365376538990910493254204993718303740024566650391e-01, // 0.400000
  3.89400391535702439238519900754909031093120574951172e-01, // 0.500000
  3.70409110340858938048569370948825962841510772705078e-01, // 0.600000
  3.52344044859356719801013468895689584314823150634766e-01, // 0.700000
  3.35160023017819663770922034018440172076225280761719e-01, // 0.800000
  3.18814075810886665696131103686639107763767242431641e-01, // 0.900000
  3.03265329856316712131558688270160928368568420410156e-01, // 1.000000
  2.88474905190243324781818046176340430974960327148438e-01, // 1.100000
  2.74405818047013194682648418165626935660839080810547e-01, // 1.200000
  2.61022888380508022443393656430998817086219787597656e-01, // 1.300000
  2.48292651895704763465033693137229420244693756103516e-01, // 1.400000
  2.36183276370507344577021058285026811063289642333984e-01, // 1.500000
  2.24664482058610781578522619383875280618667602539062e-01, // 1.600000
  2.13707465974363353122811304274364374577999114990234e-01, // 1.700000
  2.03284829870299554865908930878504179418087005615234e-01, // 1.800000
  1.93370511727250615763296082150191068649291992187500e-01, // 1.900000
  1.83939720585721167012138721474912017583847045898438e-01, // 2.000000
  1.28440682656735111200063670366944279521703720092773e-01, // 2.718282
  1.03939788175380964929672700236551463603973388671875e-01, // 3.141593
  };

  public static final double[] GNUR_EXP_CDF_05 = { //
  4.99999999987500026690715295475821817669515034765482e-11, // 0.000000
  4.99998750002083400397704521234132357676571700721979e-06, // 0.000010
  4.87705754992859910612601481716410489752888679504395e-02, // 0.100000
  5.98617593408454357062353778928809333592653274536133e-02, // 0.123457
  9.51625819640404269073030718573136255145072937011719e-02, // 0.200000
  1.27082379621773322586619769936078228056430816650391e-01, // 0.271828
  1.39292023574942191999070928432047367095947265625000e-01, // 0.300000
  1.45364000846775420772161169225000776350498199462891e-01, // 0.314159
  1.81269246922018151257915974383649881929159164428711e-01, // 0.400000
  2.21199216928595121522960198490181937813758850097656e-01, // 0.500000
  2.59181779318282123902861258102348074316978454589844e-01, // 0.600000
  2.95311910281286560397973062208620831370353698730469e-01, // 0.700000
  3.29679953964360727969307163220946677029132843017578e-01, // 0.800000
  3.62371848378226724118889023884548805654048919677734e-01, // 0.900000
  3.93469340287366575736882623459678143262863159179688e-01, // 1.000000
  4.23050189619513350436363907647319138050079345703125e-01, // 1.100000
  4.51188363905973555123551932410919107496738433837891e-01, // 1.200000
  4.77954223238983955113212687138002365827560424804688e-01, // 1.300000
  5.03414696208590473069932613725541159510612487792969e-01, // 1.400000
  5.27633447258985310845957883429946377873420715332031e-01, // 1.500000
  5.50671035882778436842954761232249438762664794921875e-01, // 1.600000
  5.72585068051273293754377391451271250844001770019531e-01, // 1.700000
  5.93430340259400890268182138242991641163825988769531e-01, // 1.800000
  6.13258976545498768473407835699617862701416015625000e-01, // 1.900000
  6.32120558828557665975722557050175964832305908203125e-01, // 2.000000
  7.43118634686652401732942507806001231074333190917969e-01, // 2.718282
  7.92120423649259608467332327563781291246414184570312e-01, // 3.141593
  };

  public static final double[] GNUR_EXP_PDF_05 = { //
  4.99999999974999997931490725022740662097930908203125e-01, // 0.000000
  4.99997500006249984139117259474005550146102905273438e-01, // 0.000010
  4.75614712250357007938816877867793664336204528808594e-01, // 0.100000
  4.70069120329577261330200599331874400377273559570312e-01, // 0.123457
  4.52418709017979758790772848442429676651954650878906e-01, // 0.200000
  4.36458810189113310951114499403047375380992889404297e-01, // 0.271828
  4.30353988212528904000464535783976316452026367187500e-01, // 0.300000
  4.27317999576612317369495031016413122415542602539062e-01, // 0.314159
  4.09365376538990910493254204993718303740024566650391e-01, // 0.400000
  3.89400391535702439238519900754909031093120574951172e-01, // 0.500000
  3.70409110340858938048569370948825962841510772705078e-01, // 0.600000
  3.52344044859356719801013468895689584314823150634766e-01, // 0.700000
  3.35160023017819663770922034018440172076225280761719e-01, // 0.800000
  3.18814075810886665696131103686639107763767242431641e-01, // 0.900000
  3.03265329856316712131558688270160928368568420410156e-01, // 1.000000
  2.88474905190243324781818046176340430974960327148438e-01, // 1.100000
  2.74405818047013194682648418165626935660839080810547e-01, // 1.200000
  2.61022888380508022443393656430998817086219787597656e-01, // 1.300000
  2.48292651895704763465033693137229420244693756103516e-01, // 1.400000
  2.36183276370507344577021058285026811063289642333984e-01, // 1.500000
  2.24664482058610781578522619383875280618667602539062e-01, // 1.600000
  2.13707465974363353122811304274364374577999114990234e-01, // 1.700000
  2.03284829870299554865908930878504179418087005615234e-01, // 1.800000
  1.93370511727250615763296082150191068649291992187500e-01, // 1.900000
  1.83939720585721167012138721474912017583847045898438e-01, // 2.000000
  1.28440682656673799133528746096999384462833404541016e-01, // 2.718282
  1.03939788175370209644121644032566109672188758850098e-01, // 3.141593
  };

  public static final double[] SCIPY_EXP_CDF_1 = { //
  9.99999999950000070330663866405545691512513073462287e-11, // 0.000000
  9.99995000016666629922851977640974041605659294873476e-06, // 0.000010
  9.51625819640404269073030718573136255145072937011719e-02, // 0.100000
  1.16140088450309583723019102308171568438410758972168e-01, // 0.123457
  1.81269246922018151257915974383649881929159164428711e-01, // 0.200000
  2.38014828033141334628908225568011403083801269531250e-01, // 0.271828
  2.59181779318282123902861258102348074316978454589844e-01, // 0.300000
  2.69597308951354364126018481329083442687988281250000e-01, // 0.314159
  3.29679953964360727969307163220946677029132843017578e-01, // 0.400000
  3.93469340287366575736882623459678143262863159179688e-01, // 0.500000
  4.51188363905973555123551932410919107496738433837891e-01, // 0.600000
  5.03414696208590473069932613725541159510612487792969e-01, // 0.700000
  5.50671035882778436842954761232249438762664794921875e-01, // 0.800000
  5.93430340259400890268182138242991641163825988769531e-01, // 0.900000
  6.32120558828557665975722557050175964832305908203125e-01, // 1.000000
  6.67128916301920504849931603530421853065490722656250e-01, // 1.100000
  6.98805788087797918883836700842948630452156066894531e-01, // 1.200000
  7.27468206965987462808698182925581932067871093750000e-01, // 1.300000
  7.53403036058393538176858328370144590735435485839844e-01, // 1.400000
  7.76869839851570209710018843907164409756660461425781e-01, // 1.500000
  7.98103482005344644356625849468400701880455017089844e-01, // 1.600000
  8.17316475947265308477085454796906560659408569335938e-01, // 1.700000
  8.34701111778413440411839019361650571227073669433594e-01, // 1.800000
  8.50431380777364909206994525447953492403030395507812e-01, // 1.900000
  8.64664716763387297682186272140825167298316955566406e-01, // 2.000000
  9.34011964154687457373427150741918012499809265136719e-01, // 2.718282
  9.56786081736227700389463279861956834793090820312500e-01, // 3.141593
  };

  public static final double[] SCIPY_EXP_PDF_1 = { //
  9.99999999899999991725962900090962648391723632812500e-01, // 0.000000
  9.99990000049999827602675850357627496123313903808594e-01, // 0.000010
  9.04837418035959517581545696884859353303909301757812e-01, // 0.100000
  8.83859911549690457910344321135198697447776794433594e-01, // 0.123457
  8.18730753077981820986508409987436607480049133300781e-01, // 0.200000
  7.61985171966858665371091774431988596916198730468750e-01, // 0.271828
  7.40818220681717876097138741897651925683021545410156e-01, // 0.300000
  7.30402691048645635873981518670916557312011718750000e-01, // 0.314159
  6.70320046035639327541844068036880344152450561523438e-01, // 0.400000
  6.06530659712633424263117376540321856737136840820312e-01, // 0.500000
  5.48811636094026389365296836331253871321678161621094e-01, // 0.600000
  4.96585303791409526930067386274458840489387512207031e-01, // 0.700000
  4.49328964117221563157045238767750561237335205078125e-01, // 0.800000
  4.06569659740599109731817861757008358836174011230469e-01, // 0.900000
  3.67879441171442334024277442949824035167694091796875e-01, // 1.000000
  3.32871083698079550661219627727405168116092681884766e-01, // 1.100000
  3.01194211912202136627314530414878390729427337646484e-01, // 1.200000
  2.72531793034012592702453048332245089113712310791016e-01, // 1.300000
  2.46596963941606489578717287258768919855356216430664e-01, // 1.400000
  2.23130160148429818045556771721749100834131240844727e-01, // 1.500000
  2.01896517994655383398949766160512808710336685180664e-01, // 1.600000
  1.82683524052734663767338929574179928749799728393555e-01, // 1.700000
  1.65298888221586531832585365009435918182134628295898e-01, // 1.800000
  1.49568619222635063037429858923132997006177902221680e-01, // 1.900000
  1.35335283236612702317813727859174832701683044433594e-01, // 2.000000
  6.59880358453125426265728492580819875001907348632812e-02, // 2.718282
  4.32139182637722579771732966946728993207216262817383e-02, // 3.141593
  };

  public static final double[] GNUR_EXP_CDF_1 = { //
  9.99999999950000070330663866405545691512513073462287e-11, // 0.000000
  9.99995000016666629922851977640974041605659294873476e-06, // 0.000010
  9.51625819640404269073030718573136255145072937011719e-02, // 0.100000
  1.16140088450309583723019102308171568438410758972168e-01, // 0.123457
  1.81269246922018151257915974383649881929159164428711e-01, // 0.200000
  2.38014828033214137503748020208149682730436325073242e-01, // 0.271828
  2.59181779318282123902861258102348074316978454589844e-01, // 0.300000
  2.69597308951369518670304614715860225260257720947266e-01, // 0.314159
  3.29679953964360727969307163220946677029132843017578e-01, // 0.400000
  3.93469340287366575736882623459678143262863159179688e-01, // 0.500000
  4.51188363905973555123551932410919107496738433837891e-01, // 0.600000
  5.03414696208590473069932613725541159510612487792969e-01, // 0.700000
  5.50671035882778436842954761232249438762664794921875e-01, // 0.800000
  5.93430340259400890268182138242991641163825988769531e-01, // 0.900000
  6.32120558828557665975722557050175964832305908203125e-01, // 1.000000
  6.67128916301920504849931603530421853065490722656250e-01, // 1.100000
  6.98805788087797918883836700842948630452156066894531e-01, // 1.200000
  7.27468206965987462808698182925581932067871093750000e-01, // 1.300000
  7.53403036058393538176858328370144590735435485839844e-01, // 1.400000
  7.76869839851570209710018843907164409756660461425781e-01, // 1.500000
  7.98103482005344644356625849468400701880455017089844e-01, // 1.600000
  8.17316475947265308477085454796906560659408569335938e-01, // 1.700000
  8.34701111778413440411839019361650571227073669433594e-01, // 1.800000
  8.50431380777364909206994525447953492403030395507812e-01, // 1.900000
  8.64664716763387297682186272140825167298316955566406e-01, // 2.000000
  9.34011964154750407018923397117760032415390014648438e-01, // 2.718282
  9.56786081736236693195962743629934266209602355957031e-01, // 3.141593
  };

  public static final double[] GNUR_EXP_PDF_1 = { //
  9.99999999899999991725962900090962648391723632812500e-01, // 0.000000
  9.99990000049999827602675850357627496123313903808594e-01, // 0.000010
  9.04837418035959517581545696884859353303909301757812e-01, // 0.100000
  8.83859911549690457910344321135198697447776794433594e-01, // 0.123457
  8.18730753077981820986508409987436607480049133300781e-01, // 0.200000
  7.61985171966785834740676364162936806678771972656250e-01, // 0.271828
  7.40818220681717876097138741897651925683021545410156e-01, // 0.300000
  7.30402691048630536840846616541966795921325683593750e-01, // 0.314159
  6.70320046035639327541844068036880344152450561523438e-01, // 0.400000
  6.06530659712633424263117376540321856737136840820312e-01, // 0.500000
  5.48811636094026389365296836331253871321678161621094e-01, // 0.600000
  4.96585303791409526930067386274458840489387512207031e-01, // 0.700000
  4.49328964117221563157045238767750561237335205078125e-01, // 0.800000
  4.06569659740599109731817861757008358836174011230469e-01, // 0.900000
  3.67879441171442334024277442949824035167694091796875e-01, // 1.000000
  3.32871083698079550661219627727405168116092681884766e-01, // 1.100000
  3.01194211912202136627314530414878390729427337646484e-01, // 1.200000
  2.72531793034012592702453048332245089113712310791016e-01, // 1.300000
  2.46596963941606489578717287258768919855356216430664e-01, // 1.400000
  2.23130160148429818045556771721749100834131240844727e-01, // 1.500000
  2.01896517994655383398949766160512808710336685180664e-01, // 1.600000
  1.82683524052734663767338929574179928749799728393555e-01, // 1.700000
  1.65298888221586531832585365009435918182134628295898e-01, // 1.800000
  1.49568619222635063037429858923132997006177902221680e-01, // 1.900000
  1.35335283236612702317813727859174832701683044433594e-01, // 2.000000
  6.59880358452495374699253716244129464030265808105469e-02, // 2.718282
  4.32139182637633137429311602772941114380955696105957e-02, // 3.141593
  };

  public static final double[] SCIPY_EXP_CDF_2 = { //
  1.99999999979999994996431941180555121040374189078648e-10, // 0.000000
  1.99998000013333293123189704498798846543650142848492e-05, // 0.000010
  1.81269246922018151257915974383649881929159164428711e-01, // 0.100000
  2.18791656755373431497702085835044272243976593017578e-01, // 0.123457
  3.29679953964360727969307163220946677029132843017578e-01, // 0.200000
  4.19378597702636857214031351759331300854682922363281e-01, // 0.271828
  4.51188363905973555123551932410919107496738433837891e-01, // 0.300000
  4.66511908908896710812541641644202172756195068359375e-01, // 0.314159
  5.50671035882778436842954761232249438762664794921875e-01, // 0.400000
  6.32120558828557665975722557050175964832305908203125e-01, // 0.500000
  6.98805788087797918883836700842948630452156066894531e-01, // 0.600000
  7.53403036058393538176858328370144590735435485839844e-01, // 0.700000
  7.98103482005344644356625849468400701880455017089844e-01, // 0.800000
  8.34701111778413440411839019361650571227073669433594e-01, // 0.900000
  8.64664716763387297682186272140825167298316955566406e-01, // 1.000000
  8.89196841637666102187154137936886399984359741210938e-01, // 1.100000
  9.09282046710587543714154890039935708045959472656250e-01, // 1.200000
  9.25726421785666109265378054260509088635444641113281e-01, // 1.300000
  9.39189937374782068957301817135885357856750488281250e-01, // 1.400000
  9.50212931632136048598624711303273215889930725097656e-01, // 1.500000
  9.59237796021633837284525725408457219600677490234375e-01, // 1.600000
  9.66626730039673920380494109849678352475166320800781e-01, // 1.700000
  9.72676277552707468920800693013006821274757385253906e-01, // 1.800000
  9.77629228143834350106544661684893071651458740234375e-01, // 1.900000
  9.81684361111265779697987454710528254508972167968750e-01, // 2.000000
  9.95645579125277735421661873260745778679847717285156e-01, // 2.718282
  9.98132557268291975560714490711688995361328125000000e-01, // 3.141593
  };

  public static final double[] SCIPY_EXP_PDF_2 = { //
  1.99999999959999996690385160036385059356689453125000e+00, // 0.000000
  1.99996000039999732855733327596681192517280578613281e+00, // 0.000010
  1.63746150615596364197301681997487321496009826660156e+00, // 0.100000
  1.56241668648925324802689829084556549787521362304688e+00, // 0.123457
  1.34064009207127865508368813607376068830490112304688e+00, // 0.200000
  1.16124280459472628557193729648133739829063415527344e+00, // 0.271828
  1.09762327218805277873059367266250774264335632324219e+00, // 0.300000
  1.06697618218220657837491671671159565448760986328125e+00, // 0.314159
  8.98657928234443126314090477535501122474670410156250e-01, // 0.400000
  7.35758882342884668048554885899648070335388183593750e-01, // 0.500000
  6.02388423824404273254629060829756781458854675292969e-01, // 0.600000
  4.93193927883212979157434574517537839710712432861328e-01, // 0.700000
  4.03793035989310766797899532321025617420673370361328e-01, // 0.800000
  3.30597776443173063665170730018871836364269256591797e-01, // 0.900000
  2.70670566473225404635627455718349665403366088867188e-01, // 1.000000
  2.21606316724667740114540492868400178849697113037109e-01, // 1.100000
  1.81435906578825023593992682435782626271247863769531e-01, // 1.200000
  1.48547156428667753713668275850068312138319015502930e-01, // 1.300000
  1.21620125250435945352123212614969816058874130249023e-01, // 1.400000
  9.95741367357278889249627695789968129247426986694336e-02, // 1.500000
  8.15244079567324225754632038842828478664159774780273e-02, // 1.600000
  6.67465399206521592390117803006432950496673583984375e-02, // 1.700000
  5.46474448945851176695498452318133786320686340332031e-02, // 1.800000
  4.47415437123312026423960219290165696293115615844727e-02, // 1.900000
  3.66312777774683573372982436922029592096805572509766e-02, // 2.000000
  8.70884174944450660527106578001621528528630733489990e-03, // 2.718282
  3.73488546341597862227024151593468559440225362777710e-03, // 3.141593
  };

  public static final double[] GNUR_EXP_CDF_2 = { //
  1.99999999979999994996431941180555121040374189078648e-10, // 0.000000
  1.99998000013333293123189704498798846543650142848492e-05, // 0.000010
  1.81269246922018151257915974383649881929159164428711e-01, // 0.100000
  2.18791656755373431497702085835044272243976593017578e-01, // 0.123457
  3.29679953964360727969307163220946677029132843017578e-01, // 0.200000
  4.19378597702747768494191404897719621658325195312500e-01, // 0.271828
  4.51188363905973555123551932410919107496738433837891e-01, // 0.300000
  4.66511908908918804250731682259356603026390075683594e-01, // 0.314159
  5.50671035882778436842954761232249438762664794921875e-01, // 0.400000
  6.32120558828557665975722557050175964832305908203125e-01, // 0.500000
  6.98805788087797918883836700842948630452156066894531e-01, // 0.600000
  7.53403036058393538176858328370144590735435485839844e-01, // 0.700000
  7.98103482005344644356625849468400701880455017089844e-01, // 0.800000
  8.34701111778413440411839019361650571227073669433594e-01, // 0.900000
  8.64664716763387297682186272140825167298316955566406e-01, // 1.000000
  8.89196841637666102187154137936886399984359741210938e-01, // 1.100000
  9.09282046710587543714154890039935708045959472656250e-01, // 1.200000
  9.25726421785666109265378054260509088635444641113281e-01, // 1.300000
  9.39189937374782068957301817135885357856750488281250e-01, // 1.400000
  9.50212931632136048598624711303273215889930725097656e-01, // 1.500000
  9.59237796021633837284525725408457219600677490234375e-01, // 1.600000
  9.66626730039673920380494109849678352475166320800781e-01, // 1.700000
  9.72676277552707468920800693013006821274757385253906e-01, // 1.800000
  9.77629228143834350106544661684893071651458740234375e-01, // 1.900000
  9.81684361111265779697987454710528254508972167968750e-01, // 2.000000
  9.95645579125286062094346561934798955917358398437500e-01, // 2.718282
  9.98132557268292752716831728321267291903495788574219e-01, // 3.141593
  };

  public static final double[] GNUR_EXP_PDF_2 = { //
  1.99999999959999996690385160036385059356689453125000e+00, // 0.000000
  1.99996000039999732855733327596681192517280578613281e+00, // 0.000010
  1.63746150615596364197301681997487321496009826660156e+00, // 0.100000
  1.56241668648925324802689829084556549787521362304688e+00, // 0.123457
  1.34064009207127865508368813607376068830490112304688e+00, // 0.200000
  1.16124280459450446301161719020456075668334960937500e+00, // 0.271828
  1.09762327218805277873059367266250774264335632324219e+00, // 0.300000
  1.06697618218216239149853663548128679394721984863281e+00, // 0.314159
  8.98657928234443126314090477535501122474670410156250e-01, // 0.400000
  7.35758882342884668048554885899648070335388183593750e-01, // 0.500000
  6.02388423824404273254629060829756781458854675292969e-01, // 0.600000
  4.93193927883212979157434574517537839710712432861328e-01, // 0.700000
  4.03793035989310766797899532321025617420673370361328e-01, // 0.800000
  3.30597776443173063665170730018871836364269256591797e-01, // 0.900000
  2.70670566473225404635627455718349665403366088867188e-01, // 1.000000
  2.21606316724667740114540492868400178849697113037109e-01, // 1.100000
  1.81435906578825023593992682435782626271247863769531e-01, // 1.200000
  1.48547156428667753713668275850068312138319015502930e-01, // 1.300000
  1.21620125250435945352123212614969816058874130249023e-01, // 1.400000
  9.95741367357278889249627695789968129247426986694336e-02, // 1.500000
  8.15244079567324225754632038842828478664159774780273e-02, // 1.600000
  6.67465399206521592390117803006432950496673583984375e-02, // 1.700000
  5.46474448945851176695498452318133786320686340332031e-02, // 1.800000
  4.47415437123312026423960219290165696293115615844727e-02, // 1.900000
  3.66312777774683573372982436922029592096805572509766e-02, // 2.000000
  8.70884174942787754603035210720918257720768451690674e-03, // 2.718282
  3.73488546341443254997227718661179096670821309089661e-03, // 3.141593
  };

  public static final double[] SCIPY_EXP_CDF_4 = { //
  3.99999999920000017111637123087353531958321184447414e-10, // 0.000000
  3.99992000106665654499821238587742300296667963266373e-05, // 0.000010
  3.29679953964360727969307163220946677029132843017578e-01, // 0.100000
  3.89713524444985692785081710098893381655216217041016e-01, // 0.123457
  5.50671035882778436842954761232249438762664794921875e-01, // 0.200000
  6.62878787194243646041513784439302980899810791015625e-01, // 0.271828
  6.98805788087797918883836700842948630452156066894531e-01, // 0.300000
  7.15390456663970719652922980458242818713188171386719e-01, // 0.314159
  7.98103482005344644356625849468400701880455017089844e-01, // 0.400000
  8.64664716763387297682186272140825167298316955566406e-01, // 0.500000
  9.09282046710587543714154890039935708045959472656250e-01, // 0.600000
  9.39189937374782068957301817135885357856750488281250e-01, // 0.700000
  9.59237796021633837284525725408457219600677490234375e-01, // 0.800000
  9.72676277552707468920800693013006821274757385253906e-01, // 0.900000
  9.81684361111265779697987454710528254508972167968750e-01, // 1.000000
  9.87722660096931548423526692204177379608154296875000e-01, // 1.100000
  9.91770252950979980255397094879299402236938476562500e-01, // 1.200000
  9.94483435579239238855109306314261630177497863769531e-01, // 1.300000
  9.96302136283517048020996753621147945523262023925781e-01, // 1.400000
  9.97521247823333623294672634074231609702110290527344e-01, // 1.500000
  9.98338442726826036377474338223692029714584350585938e-01, // 1.600000
  9.98886224852155168996148404403356835246086120605469e-01, // 1.700000
  9.99253414191623279272391755512217059731483459472656e-01, // 1.800000
  9.99499548566559425921695947181433439254760742187500e-01, // 1.900000
  9.99664537372097483647337412548949941992759704589844e-01, // 2.000000
  9.99981039018845829779991163377417251467704772949219e-01, // 2.718282
  9.99996512657643776833538140635937452316284179687500e-01, // 3.141593
  };

  public static final double[] SCIPY_EXP_PDF_4 = { //
  3.99999999839999986761540640145540237426757812500000e+00, // 0.000000
  3.99984000319995747219081749790348112583160400390625e+00, // 0.000010
  2.68128018414255731016737627214752137660980224609375e+00, // 0.100000
  2.44114590222005700681506823457311838865280151367188e+00, // 0.123457
  1.79731585646888625262818095507100224494934082031250e+00, // 0.200000
  1.34848485122302563787854978727409616112709045410156e+00, // 0.271828
  1.20477684764880854650925812165951356291770935058594e+00, // 0.300000
  1.13843817334411712138830807816702872514724731445312e+00, // 0.314159
  8.07586071978621533595799064642051234841346740722656e-01, // 0.400000
  5.41341132946450809271254911436699330806732177734375e-01, // 0.500000
  3.62871813157650047187985364871565252542495727539062e-01, // 0.600000
  2.43240250500871890704246425229939632117748260498047e-01, // 0.700000
  1.63048815913464845150926407768565695732831954956055e-01, // 0.800000
  1.09294889789170235339099690463626757264137268066406e-01, // 0.900000
  7.32625555549367146745964873844059184193611145019531e-02, // 1.000000
  4.91093596122737438558480960182350827381014823913574e-02, // 1.100000
  3.29189881960801206117750439261726569384336471557617e-02, // 1.200000
  2.20662576830430862129261981863237451761960983276367e-02, // 1.300000
  1.47914548659317281187330905822818749584257602691650e-02, // 1.400000
  9.91500870666543396292347267717559589073061943054199e-03, // 1.500000
  6.64622909269573566154454269394591392483562231063843e-03, // 1.600000
  4.45510059137921299310391987091861665248870849609375e-03, // 1.700000
  2.98634323350671681066015317185247113229706883430481e-03, // 1.800000
  2.00180573376244333103080030866749439155682921409607e-03, // 1.900000
  1.34185051161004741289428654482662750524468719959259e-03, // 2.000000
  7.58439246168676609646114306073627631121780723333359e-05, // 2.718282
  1.39493694248359891788707765059029952681157737970352e-05, // 3.141593
  };

  public static final double[] GNUR_EXP_CDF_4 = { //
  3.99999999920000017111637123087353531958321184447414e-10, // 0.000000
  3.99992000106665654499821238587742300296667963266373e-05, // 0.000010
  3.29679953964360727969307163220946677029132843017578e-01, // 0.100000
  3.89713524444985692785081710098893381655216217041016e-01, // 0.123457
  5.50671035882778436842954761232249438762664794921875e-01, // 0.200000
  6.62878787194372431912370302597992122173309326171875e-01, // 0.271828
  6.98805788087797918883836700842948630452156066894531e-01, // 0.300000
  7.15390456663994256381045033776899799704551696777344e-01, // 0.314159
  7.98103482005344644356625849468400701880455017089844e-01, // 0.400000
  8.64664716763387297682186272140825167298316955566406e-01, // 0.500000
  9.09282046710587543714154890039935708045959472656250e-01, // 0.600000
  9.39189937374782068957301817135885357856750488281250e-01, // 0.700000
  9.59237796021633837284525725408457219600677490234375e-01, // 0.800000
  9.72676277552707468920800693013006821274757385253906e-01, // 0.900000
  9.81684361111265779697987454710528254508972167968750e-01, // 1.000000
  9.87722660096931548423526692204177379608154296875000e-01, // 1.100000
  9.91770252950979980255397094879299402236938476562500e-01, // 1.200000
  9.94483435579239238855109306314261630177497863769531e-01, // 1.300000
  9.96302136283517048020996753621147945523262023925781e-01, // 1.400000
  9.97521247823333623294672634074231609702110290527344e-01, // 1.500000
  9.98338442726826036377474338223692029714584350585938e-01, // 1.600000
  9.98886224852155168996148404403356835246086120605469e-01, // 1.700000
  9.99253414191623279272391755512217059731483459472656e-01, // 1.800000
  9.99499548566559425921695947181433439254760742187500e-01, // 1.900000
  9.99664537372097483647337412548949941992759704589844e-01, // 2.000000
  9.99981039018845829779991163377417251467704772949219e-01, // 2.718282
  9.99996512657643776833538140635937452316284179687500e-01, // 3.141593
  };

  public static final double[] GNUR_EXP_PDF_4 = { //
  3.99999999839999986761540640145540237426757812500000e+00, // 0.000000
  3.99984000319995747219081749790348112583160400390625e+00, // 0.000010
  2.68128018414255731016737627214752137660980224609375e+00, // 0.100000
  2.44114590222005700681506823457311838865280151367188e+00, // 0.123457
  1.79731585646888625262818095507100224494934082031250e+00, // 0.200000
  1.34848485122251049439512371463933959603309631347656e+00, // 0.271828
  1.20477684764880854650925812165951356291770935058594e+00, // 0.300000
  1.13843817334402297447581986489240080118179321289062e+00, // 0.314159
  8.07586071978621533595799064642051234841346740722656e-01, // 0.400000
  5.41341132946450809271254911436699330806732177734375e-01, // 0.500000
  3.62871813157650047187985364871565252542495727539062e-01, // 0.600000
  2.43240250500871890704246425229939632117748260498047e-01, // 0.700000
  1.63048815913464845150926407768565695732831954956055e-01, // 0.800000
  1.09294889789170235339099690463626757264137268066406e-01, // 0.900000
  7.32625555549367146745964873844059184193611145019531e-02, // 1.000000
  4.91093596122737438558480960182350827381014823913574e-02, // 1.100000
  3.29189881960801206117750439261726569384336471557617e-02, // 1.200000
  2.20662576830430862129261981863237451761960983276367e-02, // 1.300000
  1.47914548659317281187330905822818749584257602691650e-02, // 1.400000
  9.91500870666543396292347267717559589073061943054199e-03, // 1.500000
  6.64622909269573566154454269394591392483562231063843e-03, // 1.600000
  4.45510059137921299310391987091861665248870849609375e-03, // 1.700000
  2.98634323350671681066015317185247113229706883430481e-03, // 1.800000
  2.00180573376244333103080030866749439155682921409607e-03, // 1.900000
  1.34185051161004741289428654482662750524468719959259e-03, // 2.000000
  7.58439246165780028017047720290122470032656565308571e-05, // 2.718282
  1.39493694248244424257338058836808158957865089178085e-05, // 3.141593
  };

  public static final double[] P_QUANT = { //
  0.0001, 0.001, 0.01, 0.1, 0.25, 0.5, 0.75, 0.9, 0.99, 0.999, 0.9999 //
  };

  public static final double[] SCIPY_EXP_QUANT_01 = { //
  1.00005000333358335003197669976771067013032734394073e-03, // 0.000100
  1.00050033358353353957204134871972200926393270492554e-02, // 0.001000
  1.00503358535014422625586405501962872222065925598145e-01, // 0.010000
  1.05360515657826314672718126530526205897331237792969e+00, // 0.100000
  2.87682072451780879163152349065057933330535888671875e+00, // 0.250000
  6.93147180559945308431224475498311221599578857421875e+00, // 0.500000
  1.38629436111989061686244895099662244319915771484375e+01, // 0.750000
  2.30258509299404607872929773293435573577880859375000e+01, // 0.900000
  4.60517018598809002583038818556815385818481445312500e+01, // 0.990000
  6.90775527898213539401695015840232372283935546875000e+01, // 0.999000
  9.21034037197629373849849798716604709625244140625000e+01, // 0.999900
  };

  public static final double[] GNUR_EXP_QUANT_01 = { //
  1.00005000333358335003197669976771067013032734394073e-03, // 0.000100
  1.00050033358353353957204134871972200926393270492554e-02, // 0.001000
  1.00503358535014422625586405501962872222065925598145e-01, // 0.010000
  1.05360515657826314672718126530526205897331237792969e+00, // 0.100000
  2.87682072451780879163152349065057933330535888671875e+00, // 0.250000
  6.93147180559945308431224475498311221599578857421875e+00, // 0.500000
  1.38629436111989061686244895099662244319915771484375e+01, // 0.750000
  2.30258509299404607872929773293435573577880859375000e+01, // 0.900000
  4.60517018598809002583038818556815385818481445312500e+01, // 0.990000
  6.90775527898213539401695015840232372283935546875000e+01, // 0.999000
  9.21034037197629373849849798716604709625244140625000e+01, // 0.999900
  };

  public static final double[] SCIPY_EXP_QUANT_05 = { //
  2.00010000666716686269427927236108644137857481837273e-04, // 0.000100
  2.00100066716706699240790889859908929793164134025574e-03, // 0.001000
  2.01006717070028838312278907096697366796433925628662e-02, // 0.010000
  2.10721031315652618243206006809487007558345794677734e-01, // 0.100000
  5.75364144903561802735225683136377483606338500976562e-01, // 0.250000
  1.38629436111989057245352796599036082625389099121094e+00, // 0.500000
  2.77258872223978114490705593198072165250778198242188e+00, // 0.750000
  4.60517018598809180218722758581861853599548339843750e+00, // 0.900000
  9.21034037197618005166077637113630771636962890625000e+00, // 0.990000
  1.38155105579642718538480039569549262523651123046875e+01, // 0.999000
  1.84206807439525874769969959743320941925048828125000e+01, // 0.999900
  };

  public static final double[] GNUR_EXP_QUANT_05 = { //
  2.00010000666716686269427927236108644137857481837273e-04, // 0.000100
  2.00100066716706699240790889859908929793164134025574e-03, // 0.001000
  2.01006717070028838312278907096697366796433925628662e-02, // 0.010000
  2.10721031315652618243206006809487007558345794677734e-01, // 0.100000
  5.75364144903561802735225683136377483606338500976562e-01, // 0.250000
  1.38629436111989057245352796599036082625389099121094e+00, // 0.500000
  2.77258872223978114490705593198072165250778198242188e+00, // 0.750000
  4.60517018598809180218722758581861853599548339843750e+00, // 0.900000
  9.21034037197618005166077637113630771636962890625000e+00, // 0.990000
  1.38155105579642718538480039569549262523651123046875e+01, // 0.999000
  1.84206807439525874769969959743320941925048828125000e+01, // 0.999900
  };

  public static final double[] SCIPY_EXP_QUANT_1 = { //
  1.00005000333358343134713963618054322068928740918636e-04, // 0.000100
  1.00050033358353349620395444929954464896582067012787e-03, // 0.001000
  1.00503358535014419156139453548348683398216962814331e-02, // 0.010000
  1.05360515657826309121603003404743503779172897338867e-01, // 0.100000
  2.87682072451780901367612841568188741803169250488281e-01, // 0.250000
  6.93147180559945286226763982995180413126945495605469e-01, // 0.500000
  1.38629436111989057245352796599036082625389099121094e+00, // 0.750000
  2.30258509299404590109361379290930926799774169921875e+00, // 0.900000
  4.60517018598809002583038818556815385818481445312500e+00, // 0.990000
  6.90775527898213592692400197847746312618255615234375e+00, // 0.999000
  9.21034037197629373849849798716604709625244140625000e+00, // 0.999900
  };

  public static final double[] GNUR_EXP_QUANT_1 = { //
  1.00005000333358343134713963618054322068928740918636e-04, // 0.000100
  1.00050033358353349620395444929954464896582067012787e-03, // 0.001000
  1.00503358535014419156139453548348683398216962814331e-02, // 0.010000
  1.05360515657826309121603003404743503779172897338867e-01, // 0.100000
  2.87682072451780901367612841568188741803169250488281e-01, // 0.250000
  6.93147180559945286226763982995180413126945495605469e-01, // 0.500000
  1.38629436111989057245352796599036082625389099121094e+00, // 0.750000
  2.30258509299404590109361379290930926799774169921875e+00, // 0.900000
  4.60517018598809002583038818556815385818481445312500e+00, // 0.990000
  6.90775527898213592692400197847746312618255615234375e+00, // 0.999000
  9.21034037197629373849849798716604709625244140625000e+00, // 0.999900
  };

  public static final double[] SCIPY_EXP_QUANT_2 = { //
  5.00025001666791715673569818090271610344643704593182e-05, // 0.000100
  5.00250166791766748101977224649772324482910335063934e-04, // 0.001000
  5.02516792675072095780697267741743416991084814071655e-03, // 0.010000
  5.26802578289131545608015017023717518895864486694336e-02, // 0.100000
  1.43841036225890450683806420784094370901584625244141e-01, // 0.250000
  3.46573590279972643113381991497590206563472747802734e-01, // 0.500000
  6.93147180559945286226763982995180413126945495605469e-01, // 0.750000
  1.15129254649702295054680689645465463399887084960938e+00, // 0.900000
  2.30258509299404501291519409278407692909240722656250e+00, // 0.990000
  3.45387763949106796346200098923873156309127807617188e+00, // 0.999000
  4.60517018598814686924924899358302354812622070312500e+00, // 0.999900
  };

  public static final double[] GNUR_EXP_QUANT_2 = { //
  5.00025001666791715673569818090271610344643704593182e-05, // 0.000100
  5.00250166791766748101977224649772324482910335063934e-04, // 0.001000
  5.02516792675072095780697267741743416991084814071655e-03, // 0.010000
  5.26802578289131545608015017023717518895864486694336e-02, // 0.100000
  1.43841036225890450683806420784094370901584625244141e-01, // 0.250000
  3.46573590279972643113381991497590206563472747802734e-01, // 0.500000
  6.93147180559945286226763982995180413126945495605469e-01, // 0.750000
  1.15129254649702295054680689645465463399887084960938e+00, // 0.900000
  2.30258509299404501291519409278407692909240722656250e+00, // 0.990000
  3.45387763949106796346200098923873156309127807617188e+00, // 0.999000
  4.60517018598814686924924899358302354812622070312500e+00, // 0.999900
  };

  public static final double[] SCIPY_EXP_QUANT_4 = { //
  2.50012500833395857836784909045135805172321852296591e-05, // 0.000100
  2.50125083395883374050988612324886162241455167531967e-04, // 0.001000
  2.51258396337536047890348633870871708495542407035828e-03, // 0.010000
  2.63401289144565772804007508511858759447932243347168e-02, // 0.100000
  7.19205181129452253419032103920471854507923126220703e-02, // 0.250000
  1.73286795139986321556690995748795103281736373901367e-01, // 0.500000
  3.46573590279972643113381991497590206563472747802734e-01, // 0.750000
  5.75646273248511475273403448227327316999435424804688e-01, // 0.900000
  1.15129254649702250645759704639203846454620361328125e+00, // 0.990000
  1.72693881974553398173100049461936578154563903808594e+00, // 0.999000
  2.30258509299407343462462449679151177406311035156250e+00, // 0.999900
  };

  public static final double[] GNUR_EXP_QUANT_4 = { //
  2.50012500833395857836784909045135805172321852296591e-05, // 0.000100
  2.50125083395883374050988612324886162241455167531967e-04, // 0.001000
  2.51258396337536047890348633870871708495542407035828e-03, // 0.010000
  2.63401289144565772804007508511858759447932243347168e-02, // 0.100000
  7.19205181129452253419032103920471854507923126220703e-02, // 0.250000
  1.73286795139986321556690995748795103281736373901367e-01, // 0.500000
  3.46573590279972643113381991497590206563472747802734e-01, // 0.750000
  5.75646273248511475273403448227327316999435424804688e-01, // 0.900000
  1.15129254649702250645759704639203846454620361328125e+00, // 0.990000
  1.72693881974553398173100049461936578154563903808594e+00, // 0.999000
  2.30258509299407343462462449679151177406311035156250e+00, // 0.999900
  };

  @Test
  public void testPDF() {
    checkPDF(new ExponentialDistribution(.1), P_CDFPDF, SCIPY_EXP_PDF_01, 1e-13);
    checkPDF(new ExponentialDistribution(.5), P_CDFPDF, SCIPY_EXP_PDF_05, 1e-13);
    checkPDF(new ExponentialDistribution(1.), P_CDFPDF, SCIPY_EXP_PDF_1, 1e-13);
    checkPDF(new ExponentialDistribution(2.), P_CDFPDF, SCIPY_EXP_PDF_2, 1e-12);
    checkPDF(new ExponentialDistribution(4.), P_CDFPDF, SCIPY_EXP_PDF_4, 1e-12);
    checkPDF(new ExponentialDistribution(.1), P_CDFPDF, GNUR_EXP_PDF_01, 1e-15);
    checkPDF(new ExponentialDistribution(.5), P_CDFPDF, GNUR_EXP_PDF_05, 1e-15);
    checkPDF(new ExponentialDistribution(1.), P_CDFPDF, GNUR_EXP_PDF_1, 1e-15);
    checkPDF(new ExponentialDistribution(2.), P_CDFPDF, GNUR_EXP_PDF_2, 1e-15);
    checkPDF(new ExponentialDistribution(4.), P_CDFPDF, GNUR_EXP_PDF_4, 1e-15);
  }

  @Test
  public void testCDF() {
    checkCDF(new ExponentialDistribution(.1), P_CDFPDF, SCIPY_EXP_CDF_01, 1e-12);
    checkCDF(new ExponentialDistribution(.5), P_CDFPDF, SCIPY_EXP_CDF_05, 1e-12);
    checkCDF(new ExponentialDistribution(1.), P_CDFPDF, SCIPY_EXP_CDF_1, 1e-12);
    checkCDF(new ExponentialDistribution(2.), P_CDFPDF, SCIPY_EXP_CDF_2, 1e-12);
    checkCDF(new ExponentialDistribution(4.), P_CDFPDF, SCIPY_EXP_CDF_4, 1e-12);
    checkCDF(new ExponentialDistribution(.1), P_CDFPDF, GNUR_EXP_CDF_01, 1e-15);
    checkCDF(new ExponentialDistribution(.5), P_CDFPDF, GNUR_EXP_CDF_05, 1e-15);
    checkCDF(new ExponentialDistribution(1.), P_CDFPDF, GNUR_EXP_CDF_1, 1e-15);
    checkCDF(new ExponentialDistribution(2.), P_CDFPDF, GNUR_EXP_CDF_2, 1e-15);
    checkCDF(new ExponentialDistribution(4.), P_CDFPDF, GNUR_EXP_CDF_4, 1e-15);
  }

  @Test
  public void testProbit() {
    checkQuantile(new ExponentialDistribution(.1), P_QUANT, GNUR_EXP_QUANT_01, 1e-15);
    checkQuantile(new ExponentialDistribution(.5), P_QUANT, GNUR_EXP_QUANT_05, 1e-15);
    checkQuantile(new ExponentialDistribution(1.), P_QUANT, GNUR_EXP_QUANT_1, 1e-15);
    checkQuantile(new ExponentialDistribution(2.), P_QUANT, GNUR_EXP_QUANT_2, 1e-15);
    checkQuantile(new ExponentialDistribution(4.), P_QUANT, GNUR_EXP_QUANT_4, 1e-15);
    checkQuantile(new ExponentialDistribution(.1), P_QUANT, SCIPY_EXP_QUANT_01, 1e-15);
    checkQuantile(new ExponentialDistribution(.5), P_QUANT, SCIPY_EXP_QUANT_05, 1e-15);
    checkQuantile(new ExponentialDistribution(1.), P_QUANT, SCIPY_EXP_QUANT_1, 1e-15);
    checkQuantile(new ExponentialDistribution(2.), P_QUANT, SCIPY_EXP_QUANT_2, 1e-15);
    checkQuantile(new ExponentialDistribution(4.), P_QUANT, SCIPY_EXP_QUANT_4, 1e-15);
  }
}