/*==========================[ (c) ALPHA SOFT ]==================================

FICHIER     : [badsect.c]

DATE        : 2007/08/0020 23:07:10

CREATEUR    : [Linux!jef]

COMMENTAIRE :

================================================================================
	Handle bad sector list : for dev purpose only
==============================================================================*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BADSECT_FILE	"badsector.txt"

#define MAX_BAD_SECTORS			10000

static unsigned int BadSectors[MAX_BAD_SECTORS];
static int NbBadSectors = 0;

/*------------------------------------------------------------------------------
	LOADBADSECTORS-
Linux!jef 2007/08/20 23:09:07
------------------------------------------------------------------------------*/

void LoadBadSectors()
{
	FILE * fp = fopen( BADSECT_FILE, "r" );

	if( fp ) {
		while( 1 ) {
			char line[100];

			if( !fgets( line, sizeof(line), fp ) )	break;
			line[strlen(line)-1] = 0;
			BadSectors[NbBadSectors++] = atoi( line );
		}
		fclose( fp );
		fprintf(stderr,"%d BadSectors loaded\n", NbBadSectors );
	}
}

/*------------------------------------------------------------------------------
	SAVEBADSECTORS-
Linux!jef 2007/08/20 23:10:51
------------------------------------------------------------------------------*/

void SaveBadSectors()
{
	FILE * fp = fopen( BADSECT_FILE, "w" );

	if( fp ) {
		int i;

		for( i = 0; i < NbBadSectors; i++ ) {
			fprintf( fp, "%u\n", BadSectors[i] );
		}
		fclose( fp );
	}
}

/*------------------------------------------------------------------------------
	NOTEBADSECTOR-
Linux!jef 2007/08/20 23:11:49
------------------------------------------------------------------------------*/

void NoteBadSector( unsigned int sector )
{
	int i;

	for( i = 0; i < NbBadSectors; i++ ) {
		if( BadSectors[i] == sector )	return;
	}
	if( NbBadSectors == MAX_BAD_SECTORS ) {
		fprintf(stderr, "MAX_BAD_SECTORS: too low\n");
		return;
	}
	BadSectors[NbBadSectors++] =  sector;
}

/*------------------------------------------------------------------------------
	ISBADSECTOR-
Linux!jef 2007/08/20 23:13:14
------------------------------------------------------------------------------*/

int IsBadSector( unsigned int sector )
{
	int i;

	for( i = 0; i < NbBadSectors; i++ ) {
		if( BadSectors[i] == sector ) {
			fprintf(stderr,"%s: sector %u is bad!\n", __FUNCTION__, sector );
			return( 1 );
		}
	}
	return( 0 );
}

