/**
 *
 *  Users.cc
 *  DO NOT EDIT. This file is generated by drogon_ctl
 *
 */

#include "Users.h"
#include <drogon/utils/Utilities.h>
#include <string>

using namespace drogon;
using namespace drogon_model::postgres;

const std::string Users::Cols::_user_id = "user_id";
const std::string Users::Cols::_user_name = "user_name";
const std::string Users::Cols::_password = "password";
const std::string Users::Cols::_org_name = "org_name";
const std::string Users::Cols::_signature = "signature";
const std::string Users::Cols::_avatar_id = "avatar_id";
const std::string Users::Cols::_id = "id";
const std::string Users::Cols::_salt = "salt";
const std::string Users::Cols::_admin = "admin";
const std::string Users::primaryKeyName = "id";
const bool Users::hasPrimaryKey = true;
const std::string Users::tableName = "users";

const std::vector<typename Users::MetaData> Users::metaData_ = {
    {"user_id", "std::string", "character varying", 32, 0, 0, 0},
    {"user_name", "std::string", "character varying", 64, 0, 0, 0},
    {"password", "std::string", "character varying", 64, 0, 0, 0},
    {"org_name", "std::string", "character varying", 20, 0, 0, 0},
    {"signature", "std::string", "character varying", 50, 0, 0, 0},
    {"avatar_id", "std::string", "character varying", 32, 0, 0, 0},
    {"id", "int32_t", "integer", 4, 1, 1, 1},
    {"salt", "std::string", "character varying", 20, 0, 0, 0},
    {"admin", "bool", "boolean", 1, 0, 0, 0}};
const std::string &Users::getColumnName(size_t index) noexcept(false)
{
    assert(index < metaData_.size());
    return metaData_[index].colName_;
}
Users::Users(const Row &r, const ssize_t indexOffset) noexcept
{
    if (indexOffset < 0)
    {
        if (!r["user_id"].isNull())
        {
            userId_ =
                std::make_shared<std::string>(r["user_id"].as<std::string>());
        }
        if (!r["user_name"].isNull())
        {
            userName_ =
                std::make_shared<std::string>(r["user_name"].as<std::string>());
        }
        if (!r["password"].isNull())
        {
            password_ =
                std::make_shared<std::string>(r["password"].as<std::string>());
        }
        if (!r["org_name"].isNull())
        {
            orgName_ =
                std::make_shared<std::string>(r["org_name"].as<std::string>());
        }
        if (!r["signature"].isNull())
        {
            signature_ =
                std::make_shared<std::string>(r["signature"].as<std::string>());
        }
        if (!r["avatar_id"].isNull())
        {
            avatarId_ =
                std::make_shared<std::string>(r["avatar_id"].as<std::string>());
        }
        if (!r["id"].isNull())
        {
            id_ = std::make_shared<int32_t>(r["id"].as<int32_t>());
        }
        if (!r["salt"].isNull())
        {
            salt_ = std::make_shared<std::string>(r["salt"].as<std::string>());
        }
        if (!r["admin"].isNull())
        {
            admin_ = std::make_shared<bool>(r["admin"].as<bool>());
        }
    }
    else
    {
        size_t offset = (size_t)indexOffset;
        if (offset + 9 > r.size())
        {
            LOG_FATAL << "Invalid SQL result for this model";
            return;
        }
        size_t index;
        index = offset + 0;
        if (!r[index].isNull())
        {
            userId_ = std::make_shared<std::string>(r[index].as<std::string>());
        }
        index = offset + 1;
        if (!r[index].isNull())
        {
            userName_ =
                std::make_shared<std::string>(r[index].as<std::string>());
        }
        index = offset + 2;
        if (!r[index].isNull())
        {
            password_ =
                std::make_shared<std::string>(r[index].as<std::string>());
        }
        index = offset + 3;
        if (!r[index].isNull())
        {
            orgName_ =
                std::make_shared<std::string>(r[index].as<std::string>());
        }
        index = offset + 4;
        if (!r[index].isNull())
        {
            signature_ =
                std::make_shared<std::string>(r[index].as<std::string>());
        }
        index = offset + 5;
        if (!r[index].isNull())
        {
            avatarId_ =
                std::make_shared<std::string>(r[index].as<std::string>());
        }
        index = offset + 6;
        if (!r[index].isNull())
        {
            id_ = std::make_shared<int32_t>(r[index].as<int32_t>());
        }
        index = offset + 7;
        if (!r[index].isNull())
        {
            salt_ = std::make_shared<std::string>(r[index].as<std::string>());
        }
        index = offset + 8;
        if (!r[index].isNull())
        {
            admin_ = std::make_shared<bool>(r[index].as<bool>());
        }
    }
}

Users::Users(
    const Json::Value &pJson,
    const std::vector<std::string> &pMasqueradingVector) noexcept(false)
{
    if (pMasqueradingVector.size() != 9)
    {
        LOG_ERROR << "Bad masquerading vector";
        return;
    }
    if (!pMasqueradingVector[0].empty() &&
        pJson.isMember(pMasqueradingVector[0]))
    {
        dirtyFlag_[0] = true;
        if (!pJson[pMasqueradingVector[0]].isNull())
        {
            userId_ = std::make_shared<std::string>(
                pJson[pMasqueradingVector[0]].asString());
        }
    }
    if (!pMasqueradingVector[1].empty() &&
        pJson.isMember(pMasqueradingVector[1]))
    {
        dirtyFlag_[1] = true;
        if (!pJson[pMasqueradingVector[1]].isNull())
        {
            userName_ = std::make_shared<std::string>(
                pJson[pMasqueradingVector[1]].asString());
        }
    }
    if (!pMasqueradingVector[2].empty() &&
        pJson.isMember(pMasqueradingVector[2]))
    {
        dirtyFlag_[2] = true;
        if (!pJson[pMasqueradingVector[2]].isNull())
        {
            password_ = std::make_shared<std::string>(
                pJson[pMasqueradingVector[2]].asString());
        }
    }
    if (!pMasqueradingVector[3].empty() &&
        pJson.isMember(pMasqueradingVector[3]))
    {
        dirtyFlag_[3] = true;
        if (!pJson[pMasqueradingVector[3]].isNull())
        {
            orgName_ = std::make_shared<std::string>(
                pJson[pMasqueradingVector[3]].asString());
        }
    }
    if (!pMasqueradingVector[4].empty() &&
        pJson.isMember(pMasqueradingVector[4]))
    {
        dirtyFlag_[4] = true;
        if (!pJson[pMasqueradingVector[4]].isNull())
        {
            signature_ = std::make_shared<std::string>(
                pJson[pMasqueradingVector[4]].asString());
        }
    }
    if (!pMasqueradingVector[5].empty() &&
        pJson.isMember(pMasqueradingVector[5]))
    {
        dirtyFlag_[5] = true;
        if (!pJson[pMasqueradingVector[5]].isNull())
        {
            avatarId_ = std::make_shared<std::string>(
                pJson[pMasqueradingVector[5]].asString());
        }
    }
    if (!pMasqueradingVector[6].empty() &&
        pJson.isMember(pMasqueradingVector[6]))
    {
        dirtyFlag_[6] = true;
        if (!pJson[pMasqueradingVector[6]].isNull())
        {
            id_ = std::make_shared<int32_t>(
                (int32_t)pJson[pMasqueradingVector[6]].asInt64());
        }
    }
    if (!pMasqueradingVector[7].empty() &&
        pJson.isMember(pMasqueradingVector[7]))
    {
        dirtyFlag_[7] = true;
        if (!pJson[pMasqueradingVector[7]].isNull())
        {
            salt_ = std::make_shared<std::string>(
                pJson[pMasqueradingVector[7]].asString());
        }
    }
    if (!pMasqueradingVector[8].empty() &&
        pJson.isMember(pMasqueradingVector[8]))
    {
        dirtyFlag_[8] = true;
        if (!pJson[pMasqueradingVector[8]].isNull())
        {
            admin_ =
                std::make_shared<bool>(pJson[pMasqueradingVector[8]].asBool());
        }
    }
}

Users::Users(const Json::Value &pJson) noexcept(false)
{
    if (pJson.isMember("user_id"))
    {
        dirtyFlag_[0] = true;
        if (!pJson["user_id"].isNull())
        {
            userId_ =
                std::make_shared<std::string>(pJson["user_id"].asString());
        }
    }
    if (pJson.isMember("user_name"))
    {
        dirtyFlag_[1] = true;
        if (!pJson["user_name"].isNull())
        {
            userName_ =
                std::make_shared<std::string>(pJson["user_name"].asString());
        }
    }
    if (pJson.isMember("password"))
    {
        dirtyFlag_[2] = true;
        if (!pJson["password"].isNull())
        {
            password_ =
                std::make_shared<std::string>(pJson["password"].asString());
        }
    }
    if (pJson.isMember("org_name"))
    {
        dirtyFlag_[3] = true;
        if (!pJson["org_name"].isNull())
        {
            orgName_ =
                std::make_shared<std::string>(pJson["org_name"].asString());
        }
    }
    if (pJson.isMember("signature"))
    {
        dirtyFlag_[4] = true;
        if (!pJson["signature"].isNull())
        {
            signature_ =
                std::make_shared<std::string>(pJson["signature"].asString());
        }
    }
    if (pJson.isMember("avatar_id"))
    {
        dirtyFlag_[5] = true;
        if (!pJson["avatar_id"].isNull())
        {
            avatarId_ =
                std::make_shared<std::string>(pJson["avatar_id"].asString());
        }
    }
    if (pJson.isMember("id"))
    {
        dirtyFlag_[6] = true;
        if (!pJson["id"].isNull())
        {
            id_ = std::make_shared<int32_t>((int32_t)pJson["id"].asInt64());
        }
    }
    if (pJson.isMember("salt"))
    {
        dirtyFlag_[7] = true;
        if (!pJson["salt"].isNull())
        {
            salt_ = std::make_shared<std::string>(pJson["salt"].asString());
        }
    }
    if (pJson.isMember("admin"))
    {
        dirtyFlag_[8] = true;
        if (!pJson["admin"].isNull())
        {
            admin_ = std::make_shared<bool>(pJson["admin"].asBool());
        }
    }
}

void Users::updateByMasqueradedJson(
    const Json::Value &pJson,
    const std::vector<std::string> &pMasqueradingVector) noexcept(false)
{
    if (pMasqueradingVector.size() != 9)
    {
        LOG_ERROR << "Bad masquerading vector";
        return;
    }
    if (!pMasqueradingVector[0].empty() &&
        pJson.isMember(pMasqueradingVector[0]))
    {
        dirtyFlag_[0] = true;
        if (!pJson[pMasqueradingVector[0]].isNull())
        {
            userId_ = std::make_shared<std::string>(
                pJson[pMasqueradingVector[0]].asString());
        }
    }
    if (!pMasqueradingVector[1].empty() &&
        pJson.isMember(pMasqueradingVector[1]))
    {
        dirtyFlag_[1] = true;
        if (!pJson[pMasqueradingVector[1]].isNull())
        {
            userName_ = std::make_shared<std::string>(
                pJson[pMasqueradingVector[1]].asString());
        }
    }
    if (!pMasqueradingVector[2].empty() &&
        pJson.isMember(pMasqueradingVector[2]))
    {
        dirtyFlag_[2] = true;
        if (!pJson[pMasqueradingVector[2]].isNull())
        {
            password_ = std::make_shared<std::string>(
                pJson[pMasqueradingVector[2]].asString());
        }
    }
    if (!pMasqueradingVector[3].empty() &&
        pJson.isMember(pMasqueradingVector[3]))
    {
        dirtyFlag_[3] = true;
        if (!pJson[pMasqueradingVector[3]].isNull())
        {
            orgName_ = std::make_shared<std::string>(
                pJson[pMasqueradingVector[3]].asString());
        }
    }
    if (!pMasqueradingVector[4].empty() &&
        pJson.isMember(pMasqueradingVector[4]))
    {
        dirtyFlag_[4] = true;
        if (!pJson[pMasqueradingVector[4]].isNull())
        {
            signature_ = std::make_shared<std::string>(
                pJson[pMasqueradingVector[4]].asString());
        }
    }
    if (!pMasqueradingVector[5].empty() &&
        pJson.isMember(pMasqueradingVector[5]))
    {
        dirtyFlag_[5] = true;
        if (!pJson[pMasqueradingVector[5]].isNull())
        {
            avatarId_ = std::make_shared<std::string>(
                pJson[pMasqueradingVector[5]].asString());
        }
    }
    if (!pMasqueradingVector[6].empty() &&
        pJson.isMember(pMasqueradingVector[6]))
    {
        if (!pJson[pMasqueradingVector[6]].isNull())
        {
            id_ = std::make_shared<int32_t>(
                (int32_t)pJson[pMasqueradingVector[6]].asInt64());
        }
    }
    if (!pMasqueradingVector[7].empty() &&
        pJson.isMember(pMasqueradingVector[7]))
    {
        dirtyFlag_[7] = true;
        if (!pJson[pMasqueradingVector[7]].isNull())
        {
            salt_ = std::make_shared<std::string>(
                pJson[pMasqueradingVector[7]].asString());
        }
    }
    if (!pMasqueradingVector[8].empty() &&
        pJson.isMember(pMasqueradingVector[8]))
    {
        dirtyFlag_[8] = true;
        if (!pJson[pMasqueradingVector[8]].isNull())
        {
            admin_ =
                std::make_shared<bool>(pJson[pMasqueradingVector[8]].asBool());
        }
    }
}

void Users::updateByJson(const Json::Value &pJson) noexcept(false)
{
    if (pJson.isMember("user_id"))
    {
        dirtyFlag_[0] = true;
        if (!pJson["user_id"].isNull())
        {
            userId_ =
                std::make_shared<std::string>(pJson["user_id"].asString());
        }
    }
    if (pJson.isMember("user_name"))
    {
        dirtyFlag_[1] = true;
        if (!pJson["user_name"].isNull())
        {
            userName_ =
                std::make_shared<std::string>(pJson["user_name"].asString());
        }
    }
    if (pJson.isMember("password"))
    {
        dirtyFlag_[2] = true;
        if (!pJson["password"].isNull())
        {
            password_ =
                std::make_shared<std::string>(pJson["password"].asString());
        }
    }
    if (pJson.isMember("org_name"))
    {
        dirtyFlag_[3] = true;
        if (!pJson["org_name"].isNull())
        {
            orgName_ =
                std::make_shared<std::string>(pJson["org_name"].asString());
        }
    }
    if (pJson.isMember("signature"))
    {
        dirtyFlag_[4] = true;
        if (!pJson["signature"].isNull())
        {
            signature_ =
                std::make_shared<std::string>(pJson["signature"].asString());
        }
    }
    if (pJson.isMember("avatar_id"))
    {
        dirtyFlag_[5] = true;
        if (!pJson["avatar_id"].isNull())
        {
            avatarId_ =
                std::make_shared<std::string>(pJson["avatar_id"].asString());
        }
    }
    if (pJson.isMember("id"))
    {
        if (!pJson["id"].isNull())
        {
            id_ = std::make_shared<int32_t>((int32_t)pJson["id"].asInt64());
        }
    }
    if (pJson.isMember("salt"))
    {
        dirtyFlag_[7] = true;
        if (!pJson["salt"].isNull())
        {
            salt_ = std::make_shared<std::string>(pJson["salt"].asString());
        }
    }
    if (pJson.isMember("admin"))
    {
        dirtyFlag_[8] = true;
        if (!pJson["admin"].isNull())
        {
            admin_ = std::make_shared<bool>(pJson["admin"].asBool());
        }
    }
}

const std::string &Users::getValueOfUserId() const noexcept
{
    const static std::string defaultValue = std::string();
    if (userId_)
        return *userId_;
    return defaultValue;
}
const std::shared_ptr<std::string> &Users::getUserId() const noexcept
{
    return userId_;
}
void Users::setUserId(const std::string &pUserId) noexcept
{
    userId_ = std::make_shared<std::string>(pUserId);
    dirtyFlag_[0] = true;
}
void Users::setUserId(std::string &&pUserId) noexcept
{
    userId_ = std::make_shared<std::string>(std::move(pUserId));
    dirtyFlag_[0] = true;
}

void Users::setUserIdToNull() noexcept
{
    userId_.reset();
    dirtyFlag_[0] = true;
}

const std::string &Users::getValueOfUserName() const noexcept
{
    const static std::string defaultValue = std::string();
    if (userName_)
        return *userName_;
    return defaultValue;
}
const std::shared_ptr<std::string> &Users::getUserName() const noexcept
{
    return userName_;
}
void Users::setUserName(const std::string &pUserName) noexcept
{
    userName_ = std::make_shared<std::string>(pUserName);
    dirtyFlag_[1] = true;
}
void Users::setUserName(std::string &&pUserName) noexcept
{
    userName_ = std::make_shared<std::string>(std::move(pUserName));
    dirtyFlag_[1] = true;
}

void Users::setUserNameToNull() noexcept
{
    userName_.reset();
    dirtyFlag_[1] = true;
}

const std::string &Users::getValueOfPassword() const noexcept
{
    const static std::string defaultValue = std::string();
    if (password_)
        return *password_;
    return defaultValue;
}
const std::shared_ptr<std::string> &Users::getPassword() const noexcept
{
    return password_;
}
void Users::setPassword(const std::string &pPassword) noexcept
{
    password_ = std::make_shared<std::string>(pPassword);
    dirtyFlag_[2] = true;
}
void Users::setPassword(std::string &&pPassword) noexcept
{
    password_ = std::make_shared<std::string>(std::move(pPassword));
    dirtyFlag_[2] = true;
}

void Users::setPasswordToNull() noexcept
{
    password_.reset();
    dirtyFlag_[2] = true;
}

const std::string &Users::getValueOfOrgName() const noexcept
{
    const static std::string defaultValue = std::string();
    if (orgName_)
        return *orgName_;
    return defaultValue;
}
const std::shared_ptr<std::string> &Users::getOrgName() const noexcept
{
    return orgName_;
}
void Users::setOrgName(const std::string &pOrgName) noexcept
{
    orgName_ = std::make_shared<std::string>(pOrgName);
    dirtyFlag_[3] = true;
}
void Users::setOrgName(std::string &&pOrgName) noexcept
{
    orgName_ = std::make_shared<std::string>(std::move(pOrgName));
    dirtyFlag_[3] = true;
}

void Users::setOrgNameToNull() noexcept
{
    orgName_.reset();
    dirtyFlag_[3] = true;
}

const std::string &Users::getValueOfSignature() const noexcept
{
    const static std::string defaultValue = std::string();
    if (signature_)
        return *signature_;
    return defaultValue;
}
const std::shared_ptr<std::string> &Users::getSignature() const noexcept
{
    return signature_;
}
void Users::setSignature(const std::string &pSignature) noexcept
{
    signature_ = std::make_shared<std::string>(pSignature);
    dirtyFlag_[4] = true;
}
void Users::setSignature(std::string &&pSignature) noexcept
{
    signature_ = std::make_shared<std::string>(std::move(pSignature));
    dirtyFlag_[4] = true;
}

void Users::setSignatureToNull() noexcept
{
    signature_.reset();
    dirtyFlag_[4] = true;
}

const std::string &Users::getValueOfAvatarId() const noexcept
{
    const static std::string defaultValue = std::string();
    if (avatarId_)
        return *avatarId_;
    return defaultValue;
}
const std::shared_ptr<std::string> &Users::getAvatarId() const noexcept
{
    return avatarId_;
}
void Users::setAvatarId(const std::string &pAvatarId) noexcept
{
    avatarId_ = std::make_shared<std::string>(pAvatarId);
    dirtyFlag_[5] = true;
}
void Users::setAvatarId(std::string &&pAvatarId) noexcept
{
    avatarId_ = std::make_shared<std::string>(std::move(pAvatarId));
    dirtyFlag_[5] = true;
}

void Users::setAvatarIdToNull() noexcept
{
    avatarId_.reset();
    dirtyFlag_[5] = true;
}

const int32_t &Users::getValueOfId() const noexcept
{
    const static int32_t defaultValue = int32_t();
    if (id_)
        return *id_;
    return defaultValue;
}
const std::shared_ptr<int32_t> &Users::getId() const noexcept
{
    return id_;
}
void Users::setId(const int32_t &pId) noexcept
{
    id_ = std::make_shared<int32_t>(pId);
    dirtyFlag_[6] = true;
}

const typename Users::PrimaryKeyType &Users::getPrimaryKey() const
{
    assert(id_);
    return *id_;
}

const std::string &Users::getValueOfSalt() const noexcept
{
    const static std::string defaultValue = std::string();
    if (salt_)
        return *salt_;
    return defaultValue;
}
const std::shared_ptr<std::string> &Users::getSalt() const noexcept
{
    return salt_;
}
void Users::setSalt(const std::string &pSalt) noexcept
{
    salt_ = std::make_shared<std::string>(pSalt);
    dirtyFlag_[7] = true;
}
void Users::setSalt(std::string &&pSalt) noexcept
{
    salt_ = std::make_shared<std::string>(std::move(pSalt));
    dirtyFlag_[7] = true;
}

void Users::setSaltToNull() noexcept
{
    salt_.reset();
    dirtyFlag_[7] = true;
}

const bool &Users::getValueOfAdmin() const noexcept
{
    const static bool defaultValue = bool();
    if (admin_)
        return *admin_;
    return defaultValue;
}
const std::shared_ptr<bool> &Users::getAdmin() const noexcept
{
    return admin_;
}
void Users::setAdmin(const bool &pAdmin) noexcept
{
    admin_ = std::make_shared<bool>(pAdmin);
    dirtyFlag_[8] = true;
}

void Users::setAdminToNull() noexcept
{
    admin_.reset();
    dirtyFlag_[8] = true;
}

void Users::updateId(const uint64_t id)
{
}

const std::vector<std::string> &Users::insertColumns() noexcept
{
    static const std::vector<std::string> inCols = {"user_id",
                                                    "user_name",
                                                    "password",
                                                    "org_name",
                                                    "signature",
                                                    "avatar_id",
                                                    "salt",
                                                    "admin"};
    return inCols;
}

void Users::outputArgs(drogon::orm::internal::SqlBinder &binder) const
{
    if (dirtyFlag_[0])
    {
        if (getUserId())
        {
            binder << getValueOfUserId();
        }
        else
        {
            binder << nullptr;
        }
    }
    if (dirtyFlag_[1])
    {
        if (getUserName())
        {
            binder << getValueOfUserName();
        }
        else
        {
            binder << nullptr;
        }
    }
    if (dirtyFlag_[2])
    {
        if (getPassword())
        {
            binder << getValueOfPassword();
        }
        else
        {
            binder << nullptr;
        }
    }
    if (dirtyFlag_[3])
    {
        if (getOrgName())
        {
            binder << getValueOfOrgName();
        }
        else
        {
            binder << nullptr;
        }
    }
    if (dirtyFlag_[4])
    {
        if (getSignature())
        {
            binder << getValueOfSignature();
        }
        else
        {
            binder << nullptr;
        }
    }
    if (dirtyFlag_[5])
    {
        if (getAvatarId())
        {
            binder << getValueOfAvatarId();
        }
        else
        {
            binder << nullptr;
        }
    }
    if (dirtyFlag_[7])
    {
        if (getSalt())
        {
            binder << getValueOfSalt();
        }
        else
        {
            binder << nullptr;
        }
    }
    if (dirtyFlag_[8])
    {
        if (getAdmin())
        {
            binder << getValueOfAdmin();
        }
        else
        {
            binder << nullptr;
        }
    }
}

const std::vector<std::string> Users::updateColumns() const
{
    std::vector<std::string> ret;
    if (dirtyFlag_[0])
    {
        ret.push_back(getColumnName(0));
    }
    if (dirtyFlag_[1])
    {
        ret.push_back(getColumnName(1));
    }
    if (dirtyFlag_[2])
    {
        ret.push_back(getColumnName(2));
    }
    if (dirtyFlag_[3])
    {
        ret.push_back(getColumnName(3));
    }
    if (dirtyFlag_[4])
    {
        ret.push_back(getColumnName(4));
    }
    if (dirtyFlag_[5])
    {
        ret.push_back(getColumnName(5));
    }
    if (dirtyFlag_[7])
    {
        ret.push_back(getColumnName(7));
    }
    if (dirtyFlag_[8])
    {
        ret.push_back(getColumnName(8));
    }
    return ret;
}

void Users::updateArgs(drogon::orm::internal::SqlBinder &binder) const
{
    if (dirtyFlag_[0])
    {
        if (getUserId())
        {
            binder << getValueOfUserId();
        }
        else
        {
            binder << nullptr;
        }
    }
    if (dirtyFlag_[1])
    {
        if (getUserName())
        {
            binder << getValueOfUserName();
        }
        else
        {
            binder << nullptr;
        }
    }
    if (dirtyFlag_[2])
    {
        if (getPassword())
        {
            binder << getValueOfPassword();
        }
        else
        {
            binder << nullptr;
        }
    }
    if (dirtyFlag_[3])
    {
        if (getOrgName())
        {
            binder << getValueOfOrgName();
        }
        else
        {
            binder << nullptr;
        }
    }
    if (dirtyFlag_[4])
    {
        if (getSignature())
        {
            binder << getValueOfSignature();
        }
        else
        {
            binder << nullptr;
        }
    }
    if (dirtyFlag_[5])
    {
        if (getAvatarId())
        {
            binder << getValueOfAvatarId();
        }
        else
        {
            binder << nullptr;
        }
    }
    if (dirtyFlag_[7])
    {
        if (getSalt())
        {
            binder << getValueOfSalt();
        }
        else
        {
            binder << nullptr;
        }
    }
    if (dirtyFlag_[8])
    {
        if (getAdmin())
        {
            binder << getValueOfAdmin();
        }
        else
        {
            binder << nullptr;
        }
    }
}
Json::Value Users::toJson() const
{
    Json::Value ret;
    if (getUserId())
    {
        ret["user_id"] = getValueOfUserId();
    }
    else
    {
        ret["user_id"] = Json::Value();
    }
    if (getUserName())
    {
        ret["user_name"] = getValueOfUserName();
    }
    else
    {
        ret["user_name"] = Json::Value();
    }
    if (getPassword())
    {
        ret["password"] = getValueOfPassword();
    }
    else
    {
        ret["password"] = Json::Value();
    }
    if (getOrgName())
    {
        ret["org_name"] = getValueOfOrgName();
    }
    else
    {
        ret["org_name"] = Json::Value();
    }
    if (getSignature())
    {
        ret["signature"] = getValueOfSignature();
    }
    else
    {
        ret["signature"] = Json::Value();
    }
    if (getAvatarId())
    {
        ret["avatar_id"] = getValueOfAvatarId();
    }
    else
    {
        ret["avatar_id"] = Json::Value();
    }
    if (getId())
    {
        ret["id"] = getValueOfId();
    }
    else
    {
        ret["id"] = Json::Value();
    }
    if (getSalt())
    {
        ret["salt"] = getValueOfSalt();
    }
    else
    {
        ret["salt"] = Json::Value();
    }
    if (getAdmin())
    {
        ret["admin"] = getValueOfAdmin();
    }
    else
    {
        ret["admin"] = Json::Value();
    }
    return ret;
}

Json::Value Users::toMasqueradedJson(
    const std::vector<std::string> &pMasqueradingVector) const
{
    Json::Value ret;
    if (pMasqueradingVector.size() == 9)
    {
        if (!pMasqueradingVector[0].empty())
        {
            if (getUserId())
            {
                ret[pMasqueradingVector[0]] = getValueOfUserId();
            }
            else
            {
                ret[pMasqueradingVector[0]] = Json::Value();
            }
        }
        if (!pMasqueradingVector[1].empty())
        {
            if (getUserName())
            {
                ret[pMasqueradingVector[1]] = getValueOfUserName();
            }
            else
            {
                ret[pMasqueradingVector[1]] = Json::Value();
            }
        }
        if (!pMasqueradingVector[2].empty())
        {
            if (getPassword())
            {
                ret[pMasqueradingVector[2]] = getValueOfPassword();
            }
            else
            {
                ret[pMasqueradingVector[2]] = Json::Value();
            }
        }
        if (!pMasqueradingVector[3].empty())
        {
            if (getOrgName())
            {
                ret[pMasqueradingVector[3]] = getValueOfOrgName();
            }
            else
            {
                ret[pMasqueradingVector[3]] = Json::Value();
            }
        }
        if (!pMasqueradingVector[4].empty())
        {
            if (getSignature())
            {
                ret[pMasqueradingVector[4]] = getValueOfSignature();
            }
            else
            {
                ret[pMasqueradingVector[4]] = Json::Value();
            }
        }
        if (!pMasqueradingVector[5].empty())
        {
            if (getAvatarId())
            {
                ret[pMasqueradingVector[5]] = getValueOfAvatarId();
            }
            else
            {
                ret[pMasqueradingVector[5]] = Json::Value();
            }
        }
        if (!pMasqueradingVector[6].empty())
        {
            if (getId())
            {
                ret[pMasqueradingVector[6]] = getValueOfId();
            }
            else
            {
                ret[pMasqueradingVector[6]] = Json::Value();
            }
        }
        if (!pMasqueradingVector[7].empty())
        {
            if (getSalt())
            {
                ret[pMasqueradingVector[7]] = getValueOfSalt();
            }
            else
            {
                ret[pMasqueradingVector[7]] = Json::Value();
            }
        }
        if (!pMasqueradingVector[8].empty())
        {
            if (getAdmin())
            {
                ret[pMasqueradingVector[8]] = getValueOfAdmin();
            }
            else
            {
                ret[pMasqueradingVector[8]] = Json::Value();
            }
        }
        return ret;
    }
    LOG_ERROR << "Masquerade failed";
    if (getUserId())
    {
        ret["user_id"] = getValueOfUserId();
    }
    else
    {
        ret["user_id"] = Json::Value();
    }
    if (getUserName())
    {
        ret["user_name"] = getValueOfUserName();
    }
    else
    {
        ret["user_name"] = Json::Value();
    }
    if (getPassword())
    {
        ret["password"] = getValueOfPassword();
    }
    else
    {
        ret["password"] = Json::Value();
    }
    if (getOrgName())
    {
        ret["org_name"] = getValueOfOrgName();
    }
    else
    {
        ret["org_name"] = Json::Value();
    }
    if (getSignature())
    {
        ret["signature"] = getValueOfSignature();
    }
    else
    {
        ret["signature"] = Json::Value();
    }
    if (getAvatarId())
    {
        ret["avatar_id"] = getValueOfAvatarId();
    }
    else
    {
        ret["avatar_id"] = Json::Value();
    }
    if (getId())
    {
        ret["id"] = getValueOfId();
    }
    else
    {
        ret["id"] = Json::Value();
    }
    if (getSalt())
    {
        ret["salt"] = getValueOfSalt();
    }
    else
    {
        ret["salt"] = Json::Value();
    }
    if (getAdmin())
    {
        ret["admin"] = getValueOfAdmin();
    }
    else
    {
        ret["admin"] = Json::Value();
    }
    return ret;
}

bool Users::validateJsonForCreation(const Json::Value &pJson, std::string &err)
{
    if (pJson.isMember("user_id"))
    {
        if (!validJsonOfField(0, "user_id", pJson["user_id"], err, true))
            return false;
    }
    if (pJson.isMember("user_name"))
    {
        if (!validJsonOfField(1, "user_name", pJson["user_name"], err, true))
            return false;
    }
    if (pJson.isMember("password"))
    {
        if (!validJsonOfField(2, "password", pJson["password"], err, true))
            return false;
    }
    if (pJson.isMember("org_name"))
    {
        if (!validJsonOfField(3, "org_name", pJson["org_name"], err, true))
            return false;
    }
    if (pJson.isMember("signature"))
    {
        if (!validJsonOfField(4, "signature", pJson["signature"], err, true))
            return false;
    }
    if (pJson.isMember("avatar_id"))
    {
        if (!validJsonOfField(5, "avatar_id", pJson["avatar_id"], err, true))
            return false;
    }
    if (pJson.isMember("id"))
    {
        if (!validJsonOfField(6, "id", pJson["id"], err, true))
            return false;
    }
    if (pJson.isMember("salt"))
    {
        if (!validJsonOfField(7, "salt", pJson["salt"], err, true))
            return false;
    }
    if (pJson.isMember("admin"))
    {
        if (!validJsonOfField(8, "admin", pJson["admin"], err, true))
            return false;
    }
    return true;
}
bool Users::validateMasqueradedJsonForCreation(
    const Json::Value &pJson,
    const std::vector<std::string> &pMasqueradingVector,
    std::string &err)
{
    if (pMasqueradingVector.size() != 9)
    {
        err = "Bad masquerading vector";
        return false;
    }
    if (!pMasqueradingVector[0].empty())
    {
        if (pJson.isMember(pMasqueradingVector[0]))
        {
            if (!validJsonOfField(0,
                                  pMasqueradingVector[0],
                                  pJson[pMasqueradingVector[0]],
                                  err,
                                  true))
                return false;
        }
    }
    if (!pMasqueradingVector[1].empty())
    {
        if (pJson.isMember(pMasqueradingVector[1]))
        {
            if (!validJsonOfField(1,
                                  pMasqueradingVector[1],
                                  pJson[pMasqueradingVector[1]],
                                  err,
                                  true))
                return false;
        }
    }
    if (!pMasqueradingVector[2].empty())
    {
        if (pJson.isMember(pMasqueradingVector[2]))
        {
            if (!validJsonOfField(2,
                                  pMasqueradingVector[2],
                                  pJson[pMasqueradingVector[2]],
                                  err,
                                  true))
                return false;
        }
    }
    if (!pMasqueradingVector[3].empty())
    {
        if (pJson.isMember(pMasqueradingVector[3]))
        {
            if (!validJsonOfField(3,
                                  pMasqueradingVector[3],
                                  pJson[pMasqueradingVector[3]],
                                  err,
                                  true))
                return false;
        }
    }
    if (!pMasqueradingVector[4].empty())
    {
        if (pJson.isMember(pMasqueradingVector[4]))
        {
            if (!validJsonOfField(4,
                                  pMasqueradingVector[4],
                                  pJson[pMasqueradingVector[4]],
                                  err,
                                  true))
                return false;
        }
    }
    if (!pMasqueradingVector[5].empty())
    {
        if (pJson.isMember(pMasqueradingVector[5]))
        {
            if (!validJsonOfField(5,
                                  pMasqueradingVector[5],
                                  pJson[pMasqueradingVector[5]],
                                  err,
                                  true))
                return false;
        }
    }
    if (!pMasqueradingVector[6].empty())
    {
        if (pJson.isMember(pMasqueradingVector[6]))
        {
            if (!validJsonOfField(6,
                                  pMasqueradingVector[6],
                                  pJson[pMasqueradingVector[6]],
                                  err,
                                  true))
                return false;
        }
    }
    if (!pMasqueradingVector[7].empty())
    {
        if (pJson.isMember(pMasqueradingVector[7]))
        {
            if (!validJsonOfField(7,
                                  pMasqueradingVector[7],
                                  pJson[pMasqueradingVector[7]],
                                  err,
                                  true))
                return false;
        }
    }
    if (!pMasqueradingVector[8].empty())
    {
        if (pJson.isMember(pMasqueradingVector[8]))
        {
            if (!validJsonOfField(8,
                                  pMasqueradingVector[8],
                                  pJson[pMasqueradingVector[8]],
                                  err,
                                  true))
                return false;
        }
    }
    return true;
}
bool Users::validateJsonForUpdate(const Json::Value &pJson, std::string &err)
{
    if (pJson.isMember("user_id"))
    {
        if (!validJsonOfField(0, "user_id", pJson["user_id"], err, false))
            return false;
    }
    if (pJson.isMember("user_name"))
    {
        if (!validJsonOfField(1, "user_name", pJson["user_name"], err, false))
            return false;
    }
    if (pJson.isMember("password"))
    {
        if (!validJsonOfField(2, "password", pJson["password"], err, false))
            return false;
    }
    if (pJson.isMember("org_name"))
    {
        if (!validJsonOfField(3, "org_name", pJson["org_name"], err, false))
            return false;
    }
    if (pJson.isMember("signature"))
    {
        if (!validJsonOfField(4, "signature", pJson["signature"], err, false))
            return false;
    }
    if (pJson.isMember("avatar_id"))
    {
        if (!validJsonOfField(5, "avatar_id", pJson["avatar_id"], err, false))
            return false;
    }
    if (pJson.isMember("id"))
    {
        if (!validJsonOfField(6, "id", pJson["id"], err, false))
            return false;
    }
    else
    {
        err =
            "The value of primary key must be set in the json object for "
            "update";
        return false;
    }
    if (pJson.isMember("salt"))
    {
        if (!validJsonOfField(7, "salt", pJson["salt"], err, false))
            return false;
    }
    if (pJson.isMember("admin"))
    {
        if (!validJsonOfField(8, "admin", pJson["admin"], err, false))
            return false;
    }
    return true;
}
bool Users::validateMasqueradedJsonForUpdate(
    const Json::Value &pJson,
    const std::vector<std::string> &pMasqueradingVector,
    std::string &err)
{
    if (pMasqueradingVector.size() != 9)
    {
        err = "Bad masquerading vector";
        return false;
    }
    if (!pMasqueradingVector[0].empty() &&
        pJson.isMember(pMasqueradingVector[0]))
    {
        if (!validJsonOfField(0,
                              pMasqueradingVector[0],
                              pJson[pMasqueradingVector[0]],
                              err,
                              false))
            return false;
    }
    if (!pMasqueradingVector[1].empty() &&
        pJson.isMember(pMasqueradingVector[1]))
    {
        if (!validJsonOfField(1,
                              pMasqueradingVector[1],
                              pJson[pMasqueradingVector[1]],
                              err,
                              false))
            return false;
    }
    if (!pMasqueradingVector[2].empty() &&
        pJson.isMember(pMasqueradingVector[2]))
    {
        if (!validJsonOfField(2,
                              pMasqueradingVector[2],
                              pJson[pMasqueradingVector[2]],
                              err,
                              false))
            return false;
    }
    if (!pMasqueradingVector[3].empty() &&
        pJson.isMember(pMasqueradingVector[3]))
    {
        if (!validJsonOfField(3,
                              pMasqueradingVector[3],
                              pJson[pMasqueradingVector[3]],
                              err,
                              false))
            return false;
    }
    if (!pMasqueradingVector[4].empty() &&
        pJson.isMember(pMasqueradingVector[4]))
    {
        if (!validJsonOfField(4,
                              pMasqueradingVector[4],
                              pJson[pMasqueradingVector[4]],
                              err,
                              false))
            return false;
    }
    if (!pMasqueradingVector[5].empty() &&
        pJson.isMember(pMasqueradingVector[5]))
    {
        if (!validJsonOfField(5,
                              pMasqueradingVector[5],
                              pJson[pMasqueradingVector[5]],
                              err,
                              false))
            return false;
    }
    if (!pMasqueradingVector[6].empty() &&
        pJson.isMember(pMasqueradingVector[6]))
    {
        if (!validJsonOfField(6,
                              pMasqueradingVector[6],
                              pJson[pMasqueradingVector[6]],
                              err,
                              false))
            return false;
    }
    else
    {
        err =
            "The value of primary key must be set in the json object for "
            "update";
        return false;
    }
    if (!pMasqueradingVector[7].empty() &&
        pJson.isMember(pMasqueradingVector[7]))
    {
        if (!validJsonOfField(7,
                              pMasqueradingVector[7],
                              pJson[pMasqueradingVector[7]],
                              err,
                              false))
            return false;
    }
    if (!pMasqueradingVector[8].empty() &&
        pJson.isMember(pMasqueradingVector[8]))
    {
        if (!validJsonOfField(8,
                              pMasqueradingVector[8],
                              pJson[pMasqueradingVector[8]],
                              err,
                              false))
            return false;
    }
    return true;
}
bool Users::validJsonOfField(size_t index,
                             const std::string &fieldName,
                             const Json::Value &pJson,
                             std::string &err,
                             bool isForCreation)
{
    switch (index)
    {
        case 0:
            if (pJson.isNull())
            {
                return true;
            }
            if (!pJson.isString())
            {
                err = "Type error in the " + fieldName + " field";
                return false;
            }
            // asString().length() creates a string object, is there any better
            // way to validate the length?
            if (pJson.isString() && pJson.asString().length() > 32)
            {
                err = "String length exceeds limit for the " + fieldName +
                      " field (the maximum value is 32)";
                return false;
            }

            break;
        case 1:
            if (pJson.isNull())
            {
                return true;
            }
            if (!pJson.isString())
            {
                err = "Type error in the " + fieldName + " field";
                return false;
            }
            // asString().length() creates a string object, is there any better
            // way to validate the length?
            if (pJson.isString() && pJson.asString().length() > 64)
            {
                err = "String length exceeds limit for the " + fieldName +
                      " field (the maximum value is 64)";
                return false;
            }

            break;
        case 2:
            if (pJson.isNull())
            {
                return true;
            }
            if (!pJson.isString())
            {
                err = "Type error in the " + fieldName + " field";
                return false;
            }
            // asString().length() creates a string object, is there any better
            // way to validate the length?
            if (pJson.isString() && pJson.asString().length() > 64)
            {
                err = "String length exceeds limit for the " + fieldName +
                      " field (the maximum value is 64)";
                return false;
            }

            break;
        case 3:
            if (pJson.isNull())
            {
                return true;
            }
            if (!pJson.isString())
            {
                err = "Type error in the " + fieldName + " field";
                return false;
            }
            // asString().length() creates a string object, is there any better
            // way to validate the length?
            if (pJson.isString() && pJson.asString().length() > 20)
            {
                err = "String length exceeds limit for the " + fieldName +
                      " field (the maximum value is 20)";
                return false;
            }

            break;
        case 4:
            if (pJson.isNull())
            {
                return true;
            }
            if (!pJson.isString())
            {
                err = "Type error in the " + fieldName + " field";
                return false;
            }
            // asString().length() creates a string object, is there any better
            // way to validate the length?
            if (pJson.isString() && pJson.asString().length() > 50)
            {
                err = "String length exceeds limit for the " + fieldName +
                      " field (the maximum value is 50)";
                return false;
            }

            break;
        case 5:
            if (pJson.isNull())
            {
                return true;
            }
            if (!pJson.isString())
            {
                err = "Type error in the " + fieldName + " field";
                return false;
            }
            // asString().length() creates a string object, is there any better
            // way to validate the length?
            if (pJson.isString() && pJson.asString().length() > 32)
            {
                err = "String length exceeds limit for the " + fieldName +
                      " field (the maximum value is 32)";
                return false;
            }

            break;
        case 6:
            if (pJson.isNull())
            {
                err = "The " + fieldName + " column cannot be null";
                return false;
            }
            if (isForCreation)
            {
                err = "The automatic primary key cannot be set";
                return false;
            }
            if (!pJson.isInt())
            {
                err = "Type error in the " + fieldName + " field";
                return false;
            }
            break;
        case 7:
            if (pJson.isNull())
            {
                return true;
            }
            if (!pJson.isString())
            {
                err = "Type error in the " + fieldName + " field";
                return false;
            }
            // asString().length() creates a string object, is there any better
            // way to validate the length?
            if (pJson.isString() && pJson.asString().length() > 20)
            {
                err = "String length exceeds limit for the " + fieldName +
                      " field (the maximum value is 20)";
                return false;
            }

            break;
        case 8:
            if (pJson.isNull())
            {
                return true;
            }
            if (!pJson.isBool())
            {
                err = "Type error in the " + fieldName + " field";
                return false;
            }
            break;

        default:
            err = "Internal error in the server";
            return false;
            break;
    }
    return true;
}
