// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;

namespace Microsoft.DotNet.StrongName
{
    internal static class Constants
    {
        // Checksum offset in the PE header.
        internal const int ChecksumOffsetInPEHeader = 0x40;
        internal const int CheckSumSize = sizeof(uint);

        // Internal constants obtained from runtime's
        // src/libraries/System.Reflection.Metadata/src/System/Reflection/PortableExecutable/PEHeader.cs
        internal const int PEHeaderSize32Bit = 224;
        internal const int PEHeaderSize64Bit = 240;
        internal const int PESectionHeaderSize = 40;
        internal const int AuthenticodeDirectorySize = 2 * sizeof(int);
        internal const int SnPublicKeyHeaderSize = 12;

        internal const int BlobHeaderSize = sizeof(byte) + sizeof(byte) + sizeof(ushort) + sizeof(uint);
        internal const int RsaPubKeySize = sizeof(uint) + sizeof(uint) + sizeof(uint);

        internal const UInt32 RSA1 = 0x31415352;
        internal const UInt32 RSA2 = 0x32415352;

        // In wincrypt.h both public and private key blobs start with a
        // PUBLICKEYSTRUC and RSAPUBKEY and then start the key data
        internal const int OffsetToKeyData = BlobHeaderSize + RsaPubKeySize;

        // From wincrypt.h
        internal const byte PublicKeyBlobId = 0x06;
        internal const byte PrivateKeyBlobId = 0x07;

        // from winnt.h
        internal const int FlagsOffsetInCorHeader = sizeof(uint) + // cb
                                                   sizeof(ushort) + // MajorRuntimeVersion
                                                   sizeof(ushort) + // MinorRuntimeVersion
                                                   sizeof(uint) * 2; // MetaData
        internal const int CorFlagsSize = sizeof(uint);

        /// <summary>
        /// Neutral public key indicates that the ECMA key was used to strong name the binary.
        /// </summary>
        internal static readonly byte[] NeutralPublicKey = { 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0 };

        // ECMA key
        internal static readonly byte[] ECMAKey =
        {
            0x00,0x24,0x00,0x00,0x04,0x80,0x00,0x00,0x94,0x00,0x00,0x00,0x06,0x02,0x00,0x00,
            0x00,0x24,0x00,0x00,0x52,0x53,0x41,0x31,0x00,0x04,0x00,0x00,0x01,0x00,0x01,0x00,
            0x07,0xd1,0xfa,0x57,0xc4,0xae,0xd9,0xf0,0xa3,0x2e,0x84,0xaa,0x0f,0xae,0xfd,0x0d,
            0xe9,0xe8,0xfd,0x6a,0xec,0x8f,0x87,0xfb,0x03,0x76,0x6c,0x83,0x4c,0x99,0x92,0x1e,
            0xb2,0x3b,0xe7,0x9a,0xd9,0xd5,0xdc,0xc1,0xdd,0x9a,0xd2,0x36,0x13,0x21,0x02,0x90,
            0x0b,0x72,0x3c,0xf9,0x80,0x95,0x7f,0xc4,0xe1,0x77,0x10,0x8f,0xc6,0x07,0x77,0x4f,
            0x29,0xe8,0x32,0x0e,0x92,0xea,0x05,0xec,0xe4,0xe8,0x21,0xc0,0xa5,0xef,0xe8,0xf1,
            0x64,0x5c,0x4c,0x0c,0x93,0xc1,0xab,0x99,0x28,0x5d,0x62,0x2c,0xaa,0x65,0x2c,0x1d,
            0xfa,0xd6,0x3d,0x74,0x5d,0x6f,0x2d,0xe5,0xf1,0x7e,0x5e,0xaf,0x0f,0xc4,0x96,0x3d,
            0x26,0x1c,0x8a,0x12,0x43,0x65,0x18,0x20,0x6d,0xc0,0x93,0x34,0x4d,0x5a,0xd2,0x93
        };
    }
}