/*
 * Decompiled with CFR 0.152.
 */
package org.dojotoolkit.shrinksafe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dojotoolkit.shrinksafe.DebugData;
import org.dojotoolkit.shrinksafe.ReplacedTokens;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;

public class TokenMapper {
    private List functionBracePositions = new ArrayList();
    private List replacedTokens = new ArrayList();
    private List functionVarMappings = new ArrayList();
    private Map debugDataList = new HashMap();
    private int functionNum = 0;
    private int parentScope = 0;
    private int lastTokenCount = 0;

    public TokenMapper(ScriptOrFnNode scriptOrFnNode) {
        this.collectFunctionMappings(scriptOrFnNode);
    }

    public void incrementFunctionNumber() {
        ++this.functionNum;
    }

    private String getMappedToken(String string, boolean bl) {
        String string2 = null;
        Map map = null;
        String string3 = new String("");
        int n = this.functionBracePositions.size() - 1;
        String string4 = this.getPreviousTokenMapping(string, bl);
        if (!string4.equalsIgnoreCase(string3)) {
            return string4;
        }
        if (bl || this.isInScopeChain(string)) {
            string2 = new String("_" + Integer.toHexString(++this.lastTokenCount));
            if (string2.length() >= string.length() && string.charAt(0) != '_') {
                string2 = string;
                --this.lastTokenCount;
            }
            map = (Map)this.replacedTokens.get(bl ? n : this.parentScope);
            map.put(string, string2);
            return string2;
        }
        return string;
    }

    private boolean isInScopeChain(String string) {
        int n = this.functionBracePositions.size();
        Map map = (Map)this.functionVarMappings.get(this.functionNum);
        if (!map.isEmpty()) {
            for (int i = n; i > 0; --i) {
                if (!map.containsKey(new Integer(i))) continue;
                this.parentScope = i - 1;
                List<String> list = Arrays.asList((String[])map.get(new Integer(i)));
                if (list.indexOf(string) == -1) continue;
                return true;
            }
        }
        return false;
    }

    private String getPreviousTokenMapping(String string, boolean bl) {
        String string2 = new String("");
        int n = this.replacedTokens.size() - 1;
        if (n < 0) {
            return string2;
        }
        if (bl) {
            Map map = (Map)this.replacedTokens.get(n);
            if (map.containsKey(string)) {
                string2 = (String)map.get(string);
                return string2;
            }
        } else {
            for (int i = n; i > -1; --i) {
                Map map = (Map)this.replacedTokens.get(i);
                if (!map.containsKey(string)) continue;
                string2 = (String)map.get(string);
                return string2;
            }
        }
        return string2;
    }

    private void collectFunctionMappings(ScriptOrFnNode scriptOrFnNode) {
        int n = -1;
        this.collectFuncNodes(scriptOrFnNode, n, null);
    }

    private void collectFuncNodes(ScriptOrFnNode scriptOrFnNode, int n, ScriptOrFnNode scriptOrFnNode2) {
        ++n;
        DebugData debugData = new DebugData();
        debugData.start = scriptOrFnNode.getBaseLineno();
        debugData.end = scriptOrFnNode.getEndLineno();
        debugData.paramAndVarNames = scriptOrFnNode.getParamAndVarNames();
        this.debugDataList.put(new Integer(scriptOrFnNode.getEncodedSourceStart()), debugData);
        this.functionVarMappings.add(new HashMap());
        Map map = (Map)this.functionVarMappings.get(this.functionVarMappings.size() - 1);
        map.put(new Integer(n), scriptOrFnNode.getParamAndVarNames());
        if (scriptOrFnNode2 != null) {
            map.put(new Integer(n - 1), scriptOrFnNode2.getParamAndVarNames());
        }
        int n2 = scriptOrFnNode.getFunctionCount();
        for (int i = 0; i != n2; ++i) {
            this.collectFuncNodes(scriptOrFnNode.getFunctionNode(i), n, scriptOrFnNode);
            map = (Map)this.functionVarMappings.get(this.functionVarMappings.size() - 1);
            map.put(new Integer(n), scriptOrFnNode.getParamAndVarNames());
        }
    }

    public int sourceCompress(String string, int n, boolean bl, StringBuffer stringBuffer, int n2, boolean bl2, int n3, ReplacedTokens replacedTokens) {
        boolean bl3 = false;
        int n4 = string.charAt(n);
        ++n;
        if ((0x8000 & n4) != 0) {
            n4 = (Short.MAX_VALUE & n4) << 16 | string.charAt(n);
            ++n;
        }
        String string2 = string.substring(n, n + n4);
        if (n2 == 121 || bl2) {
            bl3 = true;
        }
        if (stringBuffer != null) {
            String string3 = new String(string2);
            if ((this.functionBracePositions.size() > 0 && n3 >= (Integer)this.functionBracePositions.get(this.functionBracePositions.size() - 1) || bl2) && n2 != 107) {
                string2 = replacedTokens.find(string2);
            }
            if (!bl2 && bl && (n2 == 84 || n2 == 88)) {
                string2 = string3;
            }
            if (!bl) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append('\"');
                stringBuffer.append(ScriptRuntime.escapeString(string2));
                stringBuffer.append('\"');
            }
        } else if ((this.functionBracePositions.size() > 0 && n3 >= (Integer)this.functionBracePositions.get(this.functionBracePositions.size() - 1) || bl2) && n2 != 107) {
            this.getMappedToken(string2, bl3);
        }
        return n + n4;
    }

    public void enterNestingLevel(int n) {
        this.functionBracePositions.add(new Integer(n + 1));
        this.replacedTokens.add(new HashMap());
    }

    public boolean leaveNestingLevel(int n) {
        boolean bl = false;
        Integer n2 = new Integer(n);
        if (this.functionBracePositions.contains(n2) && this.replacedTokens.size() > 0) {
            int n3 = this.replacedTokens.size();
            this.replacedTokens.remove(n3 - 1);
            this.functionBracePositions.remove(n2);
            bl = true;
        }
        return bl;
    }

    public Map getCurrentTokens() {
        Map map = null;
        if (this.replacedTokens.size() > 0) {
            map = (Map)this.replacedTokens.get(this.replacedTokens.size() - 1);
        }
        return map;
    }

    public DebugData getDebugData(Integer n) {
        return (DebugData)this.debugDataList.get(n);
    }

    public void reset() {
        this.functionNum = 0;
        this.parentScope = 0;
        this.lastTokenCount = 0;
        this.functionBracePositions = new ArrayList();
        this.replacedTokens = new ArrayList();
    }
}

