/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.pattern;

import com.icl.saxon.Context;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.Pattern;

public class UnionPattern
extends Pattern {
    protected Pattern p1;
    protected Pattern p2;
    private short nodeType = 0;

    public UnionPattern(Pattern pattern, Pattern pattern2) {
        this.p1 = pattern;
        this.p2 = pattern2;
        if (pattern.getNodeType() == pattern2.getNodeType()) {
            this.nodeType = pattern.getNodeType();
        }
    }

    public Pattern simplify() throws XPathException {
        return new UnionPattern(this.p1.simplify(), this.p2.simplify());
    }

    public void setOriginalText(String string) {
        this.originalText = string;
        this.p1.setOriginalText(string);
        this.p2.setOriginalText(string);
    }

    public boolean matches(NodeInfo nodeInfo, Context context) throws XPathException {
        return this.p1.matches(nodeInfo, context) || this.p2.matches(nodeInfo, context);
    }

    public short getNodeType() {
        return this.nodeType;
    }

    public Pattern getLHS() {
        return this.p1;
    }

    public Pattern getRHS() {
        return this.p2;
    }
}

