(let ((tag "BraceEnd")(choice 'add) (number #f))
    (define (write-brace-ends number)
        (define brace " >>%Brace End\n") 
        (d-DirectivePut-staff-data tag (number->string number))
        (d-DirectivePut-staff-display tag (_ "Brace End") )
        (d-DirectivePut-staff-postfix tag (xsubstring brace 0 (* (string-length brace) number)))
        (d-DirectivePut-staff-override tag (logior DENEMO_OVERRIDE_GRAPHIC DENEMO_OVERRIDE_AFFIX DENEMO_OVERRIDE_TAGEDIT)))
    (set! number (d-DirectiveGet-staff-data tag))   
    (if number
        (set! choice (RadioBoxMenu (cons (string-append (_ "Add an End Brace Marker") " (" number "->" (number->string (+ (string->number number) 1)) ")") 'add) 
                                (cons (string-append (_ "Delete an End Brace Marker") " (" number "->" (number->string (- (string->number number) 1)) ")") 'delete)   
                                (cons (_ "Move End Brace Marker Up") 'up) 
                                (cons (_ "Move End Brace MarkerDown") 'down) 
                                
                                (cons (_ "Cancel") #f)))
        (set! number "0"))
    (case choice
            ((delete)
                (set! number (string->number number)) 
                (if (= 1 number)
                    (d-DirectiveDelete-staff tag)
                    (write-brace-ends (- number 1))))
               ((up)
                (set! number (string->number number)) 
                (if (= 1 number)
                    (d-DirectiveDelete-staff tag)
                    (write-brace-ends (- number 1)))
                    (if (d-MoveToStaffUp)
                        (begin
                            (set! number (d-DirectiveGet-staff-data tag))     
                            (if (not number)
                                (set! number "0"))
                            (write-brace-ends (+ 1 (string->number number))))
                        (d-WarningDialog (_ "No staff above"))))
               ((down)
                (set! number (string->number number)) 
                (if (= 1 number)
                    (d-DirectiveDelete-staff tag)
                    (write-brace-ends (- number 1)))
                    (if (d-MoveToStaffDown)
                        (begin
                            (set! number (d-DirectiveGet-staff-data tag))     
                            (if (not number)
                                (set! number "0"))
                            (write-brace-ends (+ 1 (string->number number))))
                        (d-WarningDialog (_ "No staff below")))) 
            ((add)
                (if number
                    (set! number (string->number number))
                    (set! number 0))
                (write-brace-ends (+ number 1)))))
(d-CheckBraces)
(d-SetSaved #f)
