## -*- perl -*-
## ----------------------------------------------------------------------
## DebianDoc_SGML/Map/Texinfo: Texinfo output format data map
## ----------------------------------------------------------------------
## Copyright (C) 1999-2004 Ardo van Rangelrooij
##
## This is free software; see the GNU General Public Licence
## version 2 or later for copying conditions.  There is NO warranty.
## ----------------------------------------------------------------------

## ----------------------------------------------------------------------
## package interface definition
#package DebianDoc_SGML::Map::Texinfo;
#use strict;
#use vars qw( @ISA @EXPORT );
#use Exporter;
#@ISA = ( 'Exporter' );
#@EXPORT = qw ();

## ----------------------------------------------------------------------
%cdata = (
	  );

## ----------------------------------------------------------------------
%sdata = (

          ## ISO 8879:1986//ENTITIES Added Latin 1//EN
	  "[aacute]" => "\@'a",
	  "[Aacute]" => "\@'A",
	  "[acirc ]" => "\@^a",
	  "[Acirc ]" => "\@^A",
	  "[agrave]" => "\@`a",
	  "[Agrave]" => "\@`A",
	  "[aring ]" => "\@aa{}",
	  "[Aring ]" => "\@AA{}",
	  "[atilde]" => "\@~a",
	  "[Atilde]" => "\@~A",
	  "[auml  ]" => "\@\"a",
	  "[Auml  ]" => "\@\"A",
	  "[aelig ]" => "\@ae{}",
	  "[AElig ]" => "\@AE{}",
	  "[ccedil]" => "\@,{c}",
	  "[Ccedil]" => "\@,{C}",
	  "[eth   ]" => "[eth]",
	  "[ETH   ]" => "[ETH]",
	  "[eacute]" => "\@'e",
	  "[Eacute]" => "\@'E",
	  "[ecirc ]" => "\@^e",
	  "[Ecirc ]" => "\@^E",
	  "[egrave]" => "\@`e",
	  "[Egrave]" => "\@`E",
	  "[euml  ]" => "\@\"e",
	  "[Euml  ]" => "\@\"E",
	  "[iacute]" => "\@'i",
	  "[Iacute]" => "\@'I",
	  "[icirc ]" => "\@^i",
	  "[Icirc ]" => "\@^I",
	  "[igrave]" => "\@`i",
	  "[Igrave]" => "\@`I",
	  "[iuml  ]" => "\@\"i",
	  "[Iuml  ]" => "\@\"I",
	  "[ntilde]" => "\@~n",
	  "[Ntilde]" => "\@~N",
	  "[oacute]" => "\@'o",
	  "[Oacute]" => "\@'O",
	  "[ocirc ]" => "\@^o",
	  "[Ocirc ]" => "\@^O",
	  "[ograve]" => "\@`o",
	  "[Ograve]" => "\@`O",
	  "[oslash]" => "\@o{}",
	  "[Oslash]" => "\@O{}",
	  "[otilde]" => "\@~o",
	  "[Otilde]" => "\@~O",
	  "[ouml  ]" => "\@\"o",
	  "[Ouml  ]" => "\@\"O",
	  "[szlig ]" => "\@ss{}",
	  "[thorn ]" => "[thorn]",
	  "[THORN ]" => "[THORN]",
	  "[uacute]" => "\@'u",
	  "[Uacute]" => "\@'U",
	  "[ucirc ]" => "\@^u",
	  "[Ucirc ]" => "\@^U",
	  "[ugrave]" => "\@`u",
	  "[Ugrave]" => "\@`U",
	  "[uuml  ]" => "\@\"u",
	  "[Uuml  ]" => "\@\"U",
	  "[yacute]" => "\@'y",
	  "[Yacute]" => "\@'Y",
	  "[yuml  ]" => "\@\"y",

          ## ISO 8879:1986//ENTITIES Added Latin 2//EN
	  "[abreve]" => "\@u{a}",
	  "[Abreve]" => "\@u{A}",
	  "[amacr ]" => "\@=a",
	  "[Amacr ]" => "\@=A",
	  "[aogon ]" => "[aogon]",
	  "[Aogon ]" => "[Aogon]",
	  "[cacute]" => "\@'c",
	  "[Cacute]" => "\@'C",
	  "[ccaron]" => "\@v{c}",
	  "[Ccaron]" => "\@v{C}",
	  "[ccirc ]" => "\@^c",
	  "[Ccirc ]" => "\@^C",
	  "[cdot  ]" => "\@dotaccent{c}",
	  "[Cdot  ]" => "\@dotaccent{C}",
	  "[dcaron]" => "\@v{d}",
	  "[Dcaron]" => "\@v{D}",
	  "[dstrok]" => "[dstrok]",
	  "[Dstrok]" => "[Dstrok]",
	  "[ecaron]" => "\@v{e}",
	  "[Ecaron]" => "\@v{E}",
	  "[edot  ]" => "\@dotaccent{e}",
	  "[Edot  ]" => "\@dotaccent{E}",
	  "[emacr ]" => "\@=e",
	  "[Emacr ]" => "\@=E",
	  "[eogon ]" => "[eogon]",
	  "[Eogon ]" => "[Eogon]",
	  "[gacute]" => "\@'g",
	  "[gbreve]" => "\@u{g}",
	  "[Gbreve]" => "\@u{G}",
	  "[Gcedil]" => "\@,{G}",
	  "[gcirc ]" => "\@^g",
	  "[Gcirc ]" => "\@^G",
	  "[gdot  ]" => "\@dotaccent{g}",
	  "[Gdot  ]" => "\@dotaccent{G}",
	  "[hcirc ]" => "\@^h",
	  "[Hcirc ]" => "\@^H",
	  "[hstrok]" => "[hstrok]",
	  "[Hstrok]" => "[Hstrok]",
	  "[Idot  ]" => "\@dotaccent{I}",
	  "[Imacr ]" => "\@=I",
	  "[imacr ]" => "\@=i",
	  "[ijlig ]" => "ij",
	  "[IJlig ]" => "IJ",
	  "[inodot]" => "\@dotless{i}",
	  "[iogon ]" => "[iogon]",
	  "[Iogon ]" => "[Iogon]",
	  "[itilde]" => "\@~i",
	  "[Itilde]" => "\@~I",
	  "[jcirc ]" => "\@^j",
	  "[Jcirc ]" => "\@^J",
	  "[kcedil]" => "\@,{k}",
	  "[Kcedil]" => "\@,{K}",
	  "[kgreen]" => "[kgreen]",
	  "[lacute]" => "\@'l",
	  "[Lacute]" => "\@'L",
	  "[lcaron]" => "\@v{l}",
	  "[Lcaron]" => "\@v{L}",
	  "[lcedil]" => "\@,{l}",
	  "[Lcedil]" => "\@,{L}",
	  "[lmidot]" => "[lmidot]",
	  "[Lmidot]" => "[Lmidot]",
	  "[lstrok]" => "[lstrok]",
	  "[Lstrok]" => "[Lstrok]",
	  "[nacute]" => "\@'n",
	  "[Nacute]" => "\@'N",
	  "[eng   ]" => "[eng]",
	  "[ENG   ]" => "[ENG]",
	  "[napos ]" => "n'",
	  "[ncaron]" => "\@v{n}",
	  "[Ncaron]" => "\@v{N}",
	  "[ncedil]" => "\@,{n}",
	  "[Ncedil]" => "\@,{N}",
	  "[odblac]" => "\@H{o}",
	  "[Odblac]" => "\@H{O}",
	  "[omacr ]" => "\@=o",
	  "[Omacr ]" => "\@=O",
	  "[oelig ]" => "oe",
	  "[OElig ]" => "OE",
	  "[racute]" => "\@'r",
	  "[Racute]" => "\@'R",
	  "[rcaron]" => "\@v{r}",
	  "[Rcaron]" => "\@v{R}",
	  "[rcedil]" => "\@,{r}",
	  "[Rcedil]" => "\@,{R}",
	  "[sacute]" => "\@'s",
	  "[Sacute]" => "\@'S",
	  "[scaron]" => "\@v{s}",
	  "[Scaron]" => "\@v{S}",
	  "[scedil]" => "\@,{s}",
	  "[Scedil]" => "\@,{S}",
	  "[scirc ]" => "\@^s",
	  "[Scirc ]" => "\@^S",
	  "[tcaron]" => "\@v{t}",
	  "[Tcaron]" => "\@v{T}",
	  "[tcedil]" => "\@,{t}",
	  "[Tcedil]" => "\@,{T}",
	  "[tstrok]" => "[tstrok]",
	  "[Tstrok]" => "[Tstrok]",
	  "[ubreve]" => "\@u{u}",
	  "[Ubreve]" => "\@u{U}",
	  "[udblac]" => "\@H{u}",
	  "[Udblac]" => "\@H{U}",
	  "[umacr ]" => "\@=u",
	  "[Umacr ]" => "\@=U",
	  "[uogon ]" => "[uogon]",
	  "[Uogon ]" => "[Uogon]",
	  "[uring ]" => "\@ringaccent{u}",
	  "[Uring ]" => "\@ringaccent{U}",
	  "[utilde]" => "\@~u",
	  "[Utilde]" => "\@~U",
	  "[wcirc ]" => "\@^w",
	  "[Wcirc ]" => "\@^W",
	  "[ycirc ]" => "\@^y",
	  "[Ycirc ]" => "\@^Y",
	  "[Yuml  ]" => "\@\"Y",
	  "[zacute]" => "\@'z",
	  "[Zacute]" => "\@'Z",
	  "[zcaron]" => "\@v{z}",
	  "[Zcaron]" => "\@v{Z}",
	  "[zdot  ]" => "\@dotaccent{z}",
	  "[Zdot  ]" => "\@dotaccent{Z}",

          ## ISO 8879:1986//ENTITIES Greek Letters//EN
	  "[agr   ]" => "[agr]",
	  "[Agr   ]" => "[Agr]",
	  "[bgr   ]" => "[bgr]",
	  "[Bgr   ]" => "[Bgr]",
	  "[ggr   ]" => "[ggr]",
	  "[Ggr   ]" => "[Ggr]",
	  "[dgr   ]" => "[dgr]",
	  "[Dgr   ]" => "[Dgr]",
	  "[egr   ]" => "[egr]",
	  "[Egr   ]" => "[Egr]",
	  "[zgr   ]" => "[zgr]",
	  "[Zgr   ]" => "[Zgr]",
	  "[eegr  ]" => "[eegr]",
	  "[EEgr  ]" => "[EEgr]",
	  "[thgr  ]" => "[thgr]",
	  "[THgr  ]" => "[THgr]",
	  "[igr   ]" => "[igr]",
	  "[Igr   ]" => "[Igr]",
	  "[kgr   ]" => "[kgr]",
	  "[Kgr   ]" => "[Kgr]",
	  "[lgr   ]" => "[lgr]",
	  "[Lgr   ]" => "[Lgr]",
	  "[mgr   ]" => "[mgr]",
	  "[Mgr   ]" => "[Mgr]",
	  "[ngr   ]" => "[ngr]",
	  "[Ngr   ]" => "[Ngr]",
	  "[xgr   ]" => "[xgr]",
	  "[Xgr   ]" => "[Xgr]",
	  "[ogr   ]" => "[ogr]",
	  "[Ogr   ]" => "[Ogr]",
	  "[pgr   ]" => "[pgr]",
	  "[Pgr   ]" => "[Pgr]",
	  "[rgr   ]" => "[rgr]",
	  "[Rgr   ]" => "[Rgr]",
	  "[sgr   ]" => "[sgr]",
	  "[Sgr   ]" => "[Sgr]",
	  "[sfgr  ]" => "[sfgr]",
	  "[tgr   ]" => "[tgr]",
	  "[Tgr   ]" => "[Tgr]",
	  "[ugr   ]" => "[ugr]",
	  "[Ugr   ]" => "[Ugr]",
	  "[phgr  ]" => "[phgr]",
	  "[PHgr  ]" => "[PHgr]",
	  "[khgr  ]" => "[khgr]",
	  "[KHgr  ]" => "[KHgr]",
	  "[psgr  ]" => "[psgr]",
	  "[PSgr  ]" => "[PSgr]",
	  "[ohgr  ]" => "[ohgr]",
	  "[OHgr  ]" => "[OHgr]",

          ## ISO 8879:1986//ENTITIES Monotoniko Greek//EN
	  "[aacgr ]" => "[aacgr]",
	  "[Aacgr ]" => "[Aacgr]",
	  "[eacgr ]" => "[eacgr]",
	  "[Eacgr ]" => "[Eacgr]",
	  "[eeacgr]" => "[eeacgr]",
	  "[EEacgr]" => "[EEacgr]",
	  "[idigr ]" => "[idigr]",
	  "[Idigr ]" => "[Idigr]",
	  "[iacgr ]" => "[iacgr]",
	  "[Iacgr ]" => "[Iacgr]",
	  "[idiagr]" => "[idiagr]",
	  "[oacgr ]" => "[oacgr]",
	  "[Oacgr ]" => "[Oacgr]",
	  "[udigr ]" => "[udigr]",
	  "[Udigr ]" => "[Udigr]",
	  "[uacgr ]" => "[uacgr]",
	  "[Uacgr ]" => "[Uacgr]",
	  "[udiagr]" => "[udiagr]",
	  "[ohacgr]" => "[ohacgr]",
	  "[OHacgr]" => "[OHacgr]",

          ## ISO 8879:1986//ENTITIES Russian Cyrillic//EN
	  "[acy   ]" => "[acy]",
	  "[Acy   ]" => "[Acy]",
	  "[bcy   ]" => "[bcy]",
	  "[Bcy   ]" => "[Bcy]",
	  "[vcy   ]" => "[vcy]",
	  "[Vcy   ]" => "[Vcy]",
	  "[gcy   ]" => "[gcy]",
	  "[Gcy   ]" => "[Gcy]",
	  "[dcy   ]" => "[dcy]",
	  "[Dcy   ]" => "[Dcy]",
	  "[iecy  ]" => "[iecy]",
	  "[IEcy  ]" => "[IEcy]",
	  "[iocy  ]" => "[iocy]",
	  "[IOcy  ]" => "[IOcy]",
	  "[zhcy  ]" => "[zhcy]",
	  "[ZHcy  ]" => "[ZHcy]",
	  "[zcy   ]" => "[zcy]",
	  "[Zcy   ]" => "[Zcy]",
	  "[icy   ]" => "[icy]",
	  "[Icy   ]" => "[Icy]",
	  "[jcy   ]" => "[jcy]",
	  "[Jcy   ]" => "[Jcy]",
	  "[kcy   ]" => "[kcy]",
	  "[Kcy   ]" => "[Kcy]",
	  "[lcy   ]" => "[lcy]",
	  "[Lcy   ]" => "[Lcy]",
	  "[mcy   ]" => "[mcy]",
	  "[Mcy   ]" => "[Mcy]",
	  "[ncy   ]" => "[ncy]",
	  "[Ncy   ]" => "[Ncy]",
	  "[ocy   ]" => "[ocy]",
	  "[Ocy   ]" => "[Ocy]",
	  "[pcy   ]" => "[pcy]",
	  "[Pcy   ]" => "[Pcy]",
	  "[rcy   ]" => "[rcy]",
	  "[Rcy   ]" => "[Rcy]",
	  "[scy   ]" => "[scy]",
	  "[Scy   ]" => "[Scy]",
	  "[tcy   ]" => "[tcy]",
	  "[Tcy   ]" => "[Tcy]",
	  "[ucy   ]" => "[ucy]",
	  "[Ucy   ]" => "[Ucy]",
	  "[fcy   ]" => "[fcy]",
	  "[Fcy   ]" => "[Fcy]",
	  "[khcy  ]" => "[khcy]",
	  "[KHcy  ]" => "[KHcy]",
	  "[tscy  ]" => "[tscy]",
	  "[TScy  ]" => "[TScy]",
	  "[chcy  ]" => "[chcy]",
	  "[CHcy  ]" => "[CHcy]",
	  "[shcy  ]" => "[shcy]",
	  "[SHcy  ]" => "[SHcy]",
	  "[shchcy]" => "[shchcy]",
	  "[SHCHcy]" => "[SHCHcy]",
	  "[hardcy]" => "[hardcy]",
	  "[HARDcy]" => "[HARDcy]",
	  "[ycy   ]" => "[ycy]",
	  "[Ycy   ]" => "[Ycy]",
	  "[softcy]" => "[softcy]",
	  "[SOFTcy]" => "[SOFTcy]",
	  "[ecy   ]" => "[ecy]",
	  "[Ecy   ]" => "[Ecy]",
	  "[yucy  ]" => "[yucy]",
	  "[YUcy  ]" => "[YUcy]",
	  "[yacy  ]" => "[yacy]",
	  "[YAcy  ]" => "[YAcy]",
	  "[numero]" => "[numero]",

          ## ISO 8879:1986//ENTITIES Non-Russian Cyrillic//EN
	  "[djcy  ]" => "[djcy]",
	  "[DJcy  ]" => "[DJcy]",
	  "[gjcy  ]" => "[gjcy]",
	  "[GJcy  ]" => "[GJcy]",
	  "[jukcy ]" => "[jukcy]",
	  "[Jukcy ]" => "[Jukcy]",
	  "[dscy  ]" => "[dscy]",
	  "[DScy  ]" => "[DScy]",
	  "[iukcy ]" => "[iukcy]",
	  "[Iukcy ]" => "[Iukcy]",
	  "[yicy  ]" => "[yicy]",
	  "[YIcy  ]" => "[YIcy]",
	  "[jsercy]" => "[jsercy]",
	  "[Jsercy]" => "[Jsercy]",
	  "[ljcy  ]" => "[ljcy]",
	  "[LJcy  ]" => "[LJcy]",
	  "[njcy  ]" => "[njcy]",
	  "[NJcy  ]" => "[NJcy]",
	  "[tshcy ]" => "[tshcy]",
	  "[TSHcy ]" => "[TSHcy]",
	  "[kjcy  ]" => "[kjcy]",
	  "[KJcy  ]" => "[KJcy]",
	  "[ubrcy ]" => "[ubrcy]",
	  "[Ubrcy ]" => "[Ubrcy]",
	  "[dzcy  ]" => "[dzcy]",
	  "[DZcy  ]" => "[DZcy]",

          ## ISO 8879:1986//ENTITIES Numeric and Special Graphic//EN
	  "[half  ]" => "1/2",
	  "[frac12]" => "1/2",
	  "[frac14]" => "1/4",
	  "[frac34]" => "3/4",
	  "[frac18]" => "1/8",
	  "[frac38]" => "3/8",
	  "[frac58]" => "5/8",
	  "[frac78]" => "7/8",
	  "[sup1  ]" => "^1",
	  "[sup2  ]" => "^2",
	  "[sup3  ]" => "^3",
	  "[plus  ]" => "+",
	  "[plusmn]" => "+/-",
	  "[lt    ]" => "<",
	  "[equals]" => "=",
	  "[gt    ]" => ">",
	  "[divide]" => "/",
	  "[times ]" => "x",
	  "[curren]" => "[curren]",
	  "[pound ]" => "L",
	  "[dollar]" => "\$",
	  "[cent  ]" => "c",
	  "[yen   ]" => "Y",
	  "[num   ]" => "#",
	  "[percnt]" => "%",
	  "[amp   ]" => "\&",
	  "[ast   ]" => "*",
	  "[commat]" => "\@\@",
	  "[lsqb  ]" => "[",
	  "[bsol  ]" => "\\",
	  "[rsqb  ]" => "]",
	  "[lcub  ]" => "\@{",
	  "[horbar]" => "--",
	  "[verbar]" => "|",
	  "[rcub  ]" => "\@}",
	  "[micro ]" => "u",
	  "[ohm   ]" => "[ohm]",
	  "[deg   ]" => "[deg]",
	  "[ordm  ]" => "[ordm]",
	  "[ordf  ]" => "[ordf]",
	  "[sect  ]" => "S",
	  "[para  ]" => "P",
	  "[middot]" => ".",
	  "[larr  ]" => "<--",
	  "[rarr  ]" => "-->",
	  "[uarr  ]" => "[uarr]",
	  "[darr  ]" => "[darr]",
	  "[copy  ]" => "\@copyright{}",
	  "[reg   ]" => "(R)",
	  "[trade ]" => "(TM)",
	  "[brvbar]" => "|",
	  "[not   ]" => "[not]",
	  "[sung  ]" => "[sung]",
	  "[excl  ]" => "!",
	  "[iexcl ]" => "\@exclamdown{}",
	  "[quot  ]" => "\"",
	  "[apos  ]" => "'",
	  "[lpar  ]" => "(",
	  "[rpar  ]" => ")",
	  "[comma ]" => ",",
	  "[lowbar]" => "__",
	  "[hyphen]" => "-",
	  "[period]" => ".",
	  "[sol   ]" => "/",
	  "[colon ]" => ":",
	  "[semi  ]" => ";",
	  "[quest ]" => "?",
	  "[iquest]" => "\@questiondown{}",
	  "[laquo ]" => "<<",
	  "[raquo ]" => ">>",
	  "[lsquo ]" => "`",
	  "[rsquo ]" => "'",
	  "[ldquo ]" => "``",
	  "[rdquo ]" => "''",
	  "[nbsp  ]" => "\@w{ }",
	  "[shy   ]" => "-",

          ## ISO 8879:1986//ENTITIES Diacritical Marks//EN
	  "[acute ]" => "\@'",
	  "[breve ]" => "\@u{}",
	  "[caron ]" => "\@v{}",
	  "[cedil ]" => "\@,{}",
	  "[circ  ]" => "\@^",
	  "[dblac ]" => "\@H{}",
	  "[die   ]" => "\@\"",
	  "[dot   ]" => "\@dotaccent{}",
	  "[grave ]" => "\@`",
	  "[macr  ]" => "\@=",
	  "[ogon  ]" => "[ogon]",
	  "[ring  ]" => "\@ringaccent{}",
	  "[tilde ]" => "\@~",
	  "[uml   ]" => "\@\"",

          ## ISO 8879:1986//ENTITIES Publishing//EN
	  "[emsp  ]" => "[emsp]",
	  "[ensp  ]" => "[ensp]",
	  "[emsp3 ]" => "[emsp13]",
	  "[emsp4 ]" => "[emsp14]",
	  "[numsp ]" => "[numsp]",
	  "[puncsp]" => "[puncsp]",
	  "[thinsp]" => "[thinsp]",
	  "[hairsp]" => "[hairsp]",
	  "[mdash ]" => "---",
	  "[ndash ]" => "--",
	  "[dash  ]" => "-",
	  "[blank ]" => "_",
	  "[hellip]" => "\@dots{}",
	  "[nldr  ]" => "..",
	  "[frac13]" => "1/3",
	  "[frac23]" => "2/3",
	  "[frac15]" => "1/5",
	  "[frac25]" => "2/5",
	  "[frac35]" => "3/5",
	  "[frac45]" => "4/5",
	  "[frac16]" => "1/6",
	  "[frac56]" => "5/6",
	  "[incare]" => "c/o",
	  "[block ]" => "[block]",
	  "[uhblk ]" => "[uhblk]",
	  "[lhblk ]" => "[lhblk]",
	  "[blk14 ]" => "[blk14]",
	  "[blk12 ]" => "[blk12]",
	  "[blk34 ]" => "[blk34]",
	  "[marker]" => "[marker]",
	  "[cir   ]" => "o",
	  "[squ   ]" => "[squ]",
	  "[rect  ]" => "[rect]",
	  "[utri  ]" => "[utri]",
	  "[dtri  ]" => "[dtri]",
	  "[star  ]" => "[star]",
	  "[bull  ]" => "\@bullet{}",
	  "[squf  ]" => "[squf]",
	  "[utrif ]" => "[utrif]",
	  "[dtrif ]" => "[dtrif]",
	  "[ltrif ]" => "[ltrif]",
	  "[rtrif ]" => "[rtrif]",
	  "[clubs ]" => "[clubs]",
	  "[diams ]" => "[diams]",
	  "[hearts]" => "[hearts]",
	  "[spades]" => "[spades]",
	  "[malt  ]" => "[malt]",
	  "[dagger]" => "[dagger]",
	  "[Dagger]" => "[Dagger]",
	  "[check ]" => "[check]",
	  "[ballot]" => "x",
	  "[sharp ]" => "#",
	  "[flat  ]" => "[flat]",
	  "[male  ]" => "[male]",
	  "[female]" => "[female]",
	  "[phone ]" => "[phone]",
	  "[telrec]" => "[telrec]",
	  "[copysr]" => "[copysr]",
	  "[caret ]" => "^",
	  "[lsquor]" => "'",
	  "[ldquor]" => "\"",
	  "[fflig ]" => "ff",
	  "[filig ]" => "fi",
	  "[fjlig ]" => "fj",
	  "[ffilig]" => "ffi",
	  "[ffllig]" => "ffl",
	  "[fllig ]" => "fl",
	  "[mldr  ]" => "\@dots{}",
	  "[rdquor]" => "\"",
	  "[rsquor]" => "'",
	  "[vellip]" => ":",
	  "[hybull]" => "-",
	  "[loz   ]" => "[loz]",
	  "[lozf  ]" => "[lozf]",
	  "[ltri  ]" => "[ltri]",
	  "[rtri  ]" => "[rtri]",
	  "[starf ]" => "[starf]",
	  "[natur ]" => "[natur]",
	  "[rx    ]" => "[rx]",
	  "[sext  ]" => "[sext]",
	  "[target]" => "[target]",
	  "[dlcrop]" => "[dlcrop]",
	  "[drcrop]" => "[drcrop]",
	  "[ulcrop]" => "[ulcrop]",
	  "[urcrop]" => "[urcrop]",

          ## ISO 8879:1986//ENTITIES Box and Line Drawing//EN
	  "[boxh  ]" => "[boxh]",
	  "[boxv  ]" => "[boxv]",
	  "[boxur ]" => "[boxur]",
	  "[boxul ]" => "[boxul]",
	  "[boxdl ]" => "[boxdl]",
	  "[boxdr ]" => "[boxdr]",
	  "[boxvr ]" => "[boxvr]",
	  "[boxhu ]" => "[boxhu]",
	  "[boxvl ]" => "[boxvl]",
	  "[boxhd ]" => "[boxhd]",
	  "[boxvh ]" => "[boxvh]",
	  "[boxvR ]" => "[boxvR]",
	  "[boxhU ]" => "[boxhU]",
	  "[boxvL ]" => "[boxvL]",
	  "[boxhD ]" => "[boxhD]",
	  "[boxvH ]" => "[boxvH]",
	  "[boxH  ]" => "[boxH]",
	  "[boxV  ]" => "[boxV]",
	  "[boxUR ]" => "[boxUR]",
	  "[boxUL ]" => "[boxUL]",
	  "[boxDL ]" => "[boxDL]",
	  "[boxDR ]" => "[boxDR]",
	  "[boxVR ]" => "[boxVR]",
	  "[boxHU ]" => "[boxHU]",
	  "[boxVL ]" => "[boxVL]",
	  "[boxHD ]" => "[boxHD]",
	  "[boxVH ]" => "[boxVH]",
	  "[boxVr ]" => "[boxVr]",
	  "[boxHu ]" => "[boxHu]",
	  "[boxVl ]" => "[boxVl]",
	  "[boxHd ]" => "[boxHd]",
	  "[boxVh ]" => "[boxVh]",
	  "[boxuR ]" => "[boxuR]",
	  "[boxUl ]" => "[boxUl]",
	  "[boxdL ]" => "[boxdL]",
	  "[boxDr ]" => "[boxDr]",
	  "[boxUr ]" => "[boxUr]",
	  "[boxuL ]" => "[boxuL]",
	  "[boxDl ]" => "[boxDl]",
	  "[boxdR ]" => "[boxdR]",

          ## ISO 8879:1986//ENTITIES General Technical//EN
	  "[aleph ]" => "N",
	  "[and   ]" => "/\\",
	  "[ang90 ]" => "|_",
	  "[angsph]" => "[angsph]",
	  "[ap    ]" => "[ap]",
	  "[becaus]" => "[becaus]",
	  "[bottom]" => "[bottom]",
	  "[cap   ]" => "[cap]",
	  "[cong  ]" => "[cong]",
	  "[conint]" => "[conint]",
	  "[cup   ]" => "U",
	  "[equiv ]" => "[equiv]",
	  "[exist ]" => "[exist]",
	  "[forall]" => "[forall]",
	  "[fnof  ]" => "f",
	  "[ge    ]" => ">=",
	  "[iff   ]" => "<==>",
	  "[infin ]" => "[infin]",
	  "[int   ]" => "[int]",
	  "[isin  ]" => "[isin]",
	  "[lang  ]" => "<",
	  "[lArr  ]" => "<==",
	  "[le    ]" => "<=",
	  "[minus ]" => "\@minus{}",
	  "[mnplus]" => "-/+",
	  "[nabla ]" => "[nabla]",
	  "[ne    ]" => "!=",
	  "[ni    ]" => "[ni]",
	  "[or    ]" => "\\/",
	  "[par   ]" => "||",
	  "[part  ]" => "[part]",
	  "[permil]" => "[permil]",
	  "[perp  ]" => "[perp]",
	  "[prime ]" => "'",
	  "[Prime ]" => "''",
	  "[prop  ]" => "[prop]",
	  "[radic ]" => "[radic]",
	  "[rang  ]" => ">",
	  "[rArr  ]" => "==>",
	  "[sim   ]" => "[sim]",
	  "[sime  ]" => "[sime]",
	  "[square]" => "[square]",
	  "[sub   ]" => "[sub]",
	  "[sube  ]" => "[sube]",
	  "[sup   ]" => "[sup]",
	  "[supe  ]" => "[supe]",
	  "[there4]" => "[there4]",
	  "[Verbar]" => "||",
	  "[angst ]" => "\@AA{}",
	  "[bernou]" => "B",
	  "[compfn]" => "o",
	  "[Dot   ]" => "[Dot]",
	  "[DotDot]" => "[DotDot]",
	  "[hamilt]" => "H",
	  "[lagran]" => "L",
	  "[lowast]" => "*",
	  "[notin ]" => "[notin]",
	  "[order ]" => "O",
	  "[phmmat]" => "M",
	  "[tdot  ]" => "[tdot]",
	  "[tprime]" => "'''",
	  "[wedgeq]" => "[wedgeq]",

          ## ISO 8879:1986//ENTITIES Greek Symbols//EN
	  "[alpha ]" => "[alpha]",
	  "[beta  ]" => "[beta]",
	  "[gamma ]" => "[gamma]",
	  "[Gamma ]" => "[Gamma]",
	  "[gammad]" => "[gammad]",
	  "[delta ]" => "[delta]",
	  "[Delta ]" => "[Delta]",
	  "[epsi  ]" => "[epsi]",
	  "[epsiv ]" => "[epsiv]",
	  "[epsis ]" => "[epsis]",
	  "[zeta  ]" => "[zeta]",
	  "[eta   ]" => "[eta]",
	  "[thetas]" => "[thetas]",
	  "[Theta ]" => "[Theta]",
	  "[thetav]" => "[thetav]",
	  "[iota  ]" => "[iota]",
	  "[kappa ]" => "[kappa]",
	  "[kappav]" => "[kappav]",
	  "[lambda]" => "[lambda]",
	  "[Lambda]" => "[Lambda]",
	  "[mu    ]" => "[mu]",
	  "[nu    ]" => "[nu]",
	  "[xi    ]" => "[xi]",
	  "[Xi    ]" => "[Xi]",
	  "[pi    ]" => "[pi]",
	  "[piv   ]" => "[piv]",
	  "[Pi    ]" => "[Pi]",
	  "[rho   ]" => "[rho]",
	  "[rhov  ]" => "[rhov]",
	  "[sigma ]" => "[sigma]",
	  "[Sigma ]" => "[Sigma]",
	  "[sigmav]" => "[sigmav]",
	  "[tau   ]" => "[tau]",
	  "[upsi  ]" => "[upsi]",
	  "[Upsi  ]" => "[Upsi]",
	  "[phis  ]" => "[phis]",
	  "[Phi   ]" => "[Phi]",
	  "[phiv  ]" => "[phiv]",
	  "[chi   ]" => "[chi]",
	  "[psi   ]" => "[psi]",
	  "[Psi   ]" => "[Psi]",
	  "[omega ]" => "[omega]",
	  "[Omega ]" => "[Omega]",

          ## ISO 8879:1986//ENTITIES Alternative Greek Symbols//EN
	  "[b.alpha ]" => "[b.alpha]",
	  "[b.beta  ]" => "[b.beta]",
	  "[b.gamma ]" => "[b.gamma]",
	  "[b.Gamma ]" => "[b.Gamma]",
	  "[b.gammad]" => "[b.gammad]",
	  "[b.delta ]" => "[b.delta]",
	  "[b.Delta ]" => "[b.Delta]",
	  "[b.epsi  ]" => "[b.epsi]",
	  "[b.epsiv ]" => "[b.epsiv]",
	  "[b.epsis ]" => "[b.epsis]",
	  "[b.zeta  ]" => "[b.zeta]",
	  "[b.eta   ]" => "[b.eta]",
	  "[b.thetas]" => "[b.thetas]",
	  "[b.Theta ]" => "[b.Theta]",
	  "[b.thetav]" => "[b.thetav]",
	  "[b.iota  ]" => "[b.iota]",
	  "[b.kappa ]" => "[b.kappa]",
	  "[b.kappav]" => "[b.kappav]",
	  "[b.lambda]" => "[b.lambda]",
	  "[b.Lambda]" => "[b.Lambda]",
	  "[b.mu    ]" => "[b.mu]",
	  "[b.nu    ]" => "[b.nu]",
	  "[b.xi    ]" => "[b.xi]",
	  "[b.Xi    ]" => "[b.Xi]",
	  "[b.pi    ]" => "[b.pi]",
	  "[b.piv   ]" => "[b.piv]",
	  "[b.Pi    ]" => "[b.Pi]",
	  "[b.rho   ]" => "[b.rho]",
	  "[b.rhov  ]" => "[b.rhov]",
	  "[b.sigma ]" => "[b.sigma]",
	  "[b.Sigma ]" => "[b.Sigma]",
	  "[b.sigmav]" => "[b.sigmav]",
	  "[b.tau   ]" => "[b.tau]",
	  "[b.upsi  ]" => "[b.upsi]",
	  "[b.Upsi  ]" => "[b.Upsi]",
	  "[b.phis  ]" => "[b.phis]",
	  "[b.Phi   ]" => "[b.Phi]",
	  "[b.phiv  ]" => "[b.phiv]",
	  "[b.chi   ]" => "[b.chi]",
	  "[b.psi   ]" => "[b.psi]",
	  "[b.Psi   ]" => "[b.Psi]",
	  "[b.omega ]" => "[b.omega]",
	  "[b.Omega ]" => "[b.Omega]",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Ordinary//EN
	  "[ang   ]" => "[ang]",
	  "[angmsd]" => "[angmsd]",
	  "[beth  ]" => "[beth]",
	  "[bprime]" => "`",
	  "[comp  ]" => "C",
	  "[daleth]" => "[daleth]",
	  "[ell   ]" => "l",
	  "[empty ]" => "[empty]",
	  "[gimel ]" => "[gimel]",
	  "[image ]" => "[image]",
	  "[inodot]" => "\@dotless{i}",
	  "[jnodot]" => "\@dotless{j}",
	  "[nexist]" => "[nexist]",
	  "[oS    ]" => "[oS]",
	  "[planck]" => "[planck]",
	  "[real  ]" => "[real]",
	  "[sbsol ]" => "\\",
	  "[vprime]" => "'",
	  "[weierp]" => "P",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Binary Operators//EN
	  "[amalg ]" => "[amalg]",
	  "[Barwed]" => "[Barwed]",
	  "[barwed]" => "[barwed]",
	  "[Cap   ]" => "[Cap]",
	  "[Cup   ]" => "[Cup]",
	  "[cuvee ]" => "[cuvee]",
	  "[cuwed ]" => "[cuwed]",
	  "[diam  ]" => "[diam]",
	  "[divonx]" => "[divonx]",
	  "[intcal]" => "[intcal]",
	  "[lthree]" => "[lthree]",
	  "[ltimes]" => "[ltimes]",
	  "[minusb]" => "[minusb]",
	  "[oast  ]" => "[oast]",
	  "[ocir  ]" => "[ocir]",
	  "[odash ]" => "[odash]",
	  "[odot  ]" => "[odot]",
	  "[ominus]" => "[ominus]",
	  "[oplus ]" => "[oplus]",
	  "[osol  ]" => "[osol]",
	  "[otimes]" => "[otimes]",
	  "[plusb ]" => "[plusb]",
	  "[plusdo]" => "[plusdo]",
	  "[rthree]" => "[rthree]",
	  "[rtimes]" => "[rtimes]",
	  "[sdot  ]" => "[sdot]",
	  "[sdotb ]" => "[sdotb]",
	  "[setmn ]" => "[setmn]",
	  "[sqcap ]" => "[sqcap]",
	  "[sqcup ]" => "[sqcup]",
	  "[ssetmn]" => "[ssetmn]",
	  "[sstarf]" => "[sstarf]",
	  "[timesb]" => "[timesb]",
	  "[top   ]" => "[top]",
	  "[uplus ]" => "[uplus]",
	  "[wreath]" => "[wreath]",
	  "[xcirc ]" => "[xcirc]",
	  "[xdtri ]" => "[xdtri]",
	  "[xutri ]" => "[xutri]",
	  "[coprod]" => "[coprod]",
	  "[prod  ]" => "[prod]",
	  "[sum   ]" => "[sum]",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Relations//EN
	  "[ape   ]" => "[ape]",
	  "[asymp ]" => "[asymp]",
	  "[bcong ]" => "[bcong]",
	  "[bepsi ]" => "[bepsi]",
	  "[bowtie]" => "[bowtie]",
	  "[bsim  ]" => "[bsim]",
	  "[bsime ]" => "[bsime]",
	  "[bump  ]" => "[bump]",
	  "[bumpe ]" => "[bumpe]",
	  "[cire  ]" => "[cire]",
	  "[colone]" => "[colone]",
	  "[cuepr ]" => "[cuepr]",
	  "[cuesc ]" => "[cuesc]",
	  "[cupre ]" => "[cupre]",
	  "[dashv ]" => "[dashv]",
	  "[ecir  ]" => "[ecir]",
	  "[ecolon]" => "[ecolon]",
	  "[eDot  ]" => "[eDot]",
	  "[esdot ]" => "[esdot]",
	  "[efDot ]" => "[efDot]",
	  "[egs   ]" => "[egs]",
	  "[els   ]" => "[els]",
	  "[erDot ]" => "[erDot]",
	  "[fork  ]" => "[fork]",
	  "[frown ]" => "[frown]",
	  "[gap   ]" => "[gap]",
	  "[gsdot ]" => "[gsdot]",
	  "[gE    ]" => "[gE]",
	  "[gel   ]" => "[gel]",
	  "[gEl   ]" => "[gEl]",
	  "[ges   ]" => "[ges]",
	  "[Gg    ]" => "[Gg]",
	  "[gl    ]" => "[gl]",
	  "[gsim  ]" => "[gsim]",
	  "[Gt    ]" => "[Gt]",
	  "[lap   ]" => "[lap]",
	  "[ldot  ]" => "[ldot]",
	  "[lE    ]" => "[lE]",
	  "[lEg   ]" => "[lEg]",
	  "[leg   ]" => "[leg]",
	  "[les   ]" => "[les]",
	  "[lg    ]" => "[lg]",
	  "[Ll    ]" => "[Ll]",
	  "[lsim  ]" => "[lsim]",
	  "[Lt    ]" => "[Lt]",
	  "[ltrie ]" => "[ltrie]",
	  "[mid   ]" => "[mid]",
	  "[models]" => "[models]",
	  "[pr    ]" => "[pr]",
	  "[prap  ]" => "[prap]",
	  "[pre   ]" => "[pre]",
	  "[prsim ]" => "[prsim]",
	  "[rtrie ]" => "[rtrie]",
	  "[samalg]" => "[samalg]",
	  "[sc    ]" => "[sc]",
	  "[scap  ]" => "[scap]",
	  "[sccue ]" => "[sccue]",
	  "[sce   ]" => "[sce]",
	  "[scsim ]" => "[scsim]",
	  "[sfrown]" => "[sfrown]",
	  "[smid  ]" => "[smid]",
	  "[smile ]" => "[smile]",
	  "[spar  ]" => "[spar]",
	  "[sqsub ]" => "[sqsub]",
	  "[sqsube]" => "[sqsube]",
	  "[sqsup ]" => "[sqsup]",
	  "[sqsupe]" => "[sqsupe]",
	  "[ssmile]" => "[ssmile]",
	  "[Sub   ]" => "[Sub]",
	  "[subE  ]" => "[subE]",
	  "[Sup   ]" => "[Sup]",
	  "[supE  ]" => "[supE]",
	  "[thkap ]" => "[thkap]",
	  "[thksim]" => "[thksim]",
	  "[trie  ]" => "[trie]",
	  "[twixt ]" => "[twixt]",
	  "[vdash ]" => "[vdash]",
	  "[Vdash ]" => "[Vdash]",
	  "[vDash ]" => "[vDash]",
	  "[veebar]" => "[veebar]",
	  "[vltri ]" => "[vltri]",
	  "[vprop ]" => "[vprop]",
	  "[vrtri ]" => "[vrtri]",
	  "[Vvdash]" => "[Vvdash]",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Negated Relations//EN
	  "[gnap  ]" => "[gnap]",
	  "[gne   ]" => "[gne]",
	  "[gnE   ]" => "[gnE]",
	  "[gnsim ]" => "[gnsim]",
	  "[gvnE  ]" => "[gvnE]",
	  "[lnap  ]" => "[lnap]",
	  "[lnE   ]" => "[lnE]",
	  "[lne   ]" => "[lne]",
	  "[lnsim ]" => "[lnsim]",
	  "[lvnE  ]" => "[lvnE]",
	  "[nap   ]" => "[nap]",
	  "[ncong ]" => "[ncong]",
	  "[nequiv]" => "[nequiv]",
	  "[ngE   ]" => "[ngE]",
	  "[nge   ]" => "[nge]",
	  "[nges  ]" => "[nges]",
	  "[ngt   ]" => "[ngt]",
	  "[nle   ]" => "[nle]",
	  "[nlE   ]" => "[nlE]",
	  "[nles  ]" => "[nles]",
	  "[nlt   ]" => "[nlt]",
	  "[nltri ]" => "[nltri]",
	  "[nltrie]" => "[nltrie]",
	  "[nmid  ]" => "[nmid]",
	  "[npar  ]" => "[npar]",
	  "[npr   ]" => "[npr]",
	  "[npre  ]" => "[npre]",
	  "[nrtri ]" => "[nrtri]",
	  "[nrtrie]" => "[nrtrie]",
	  "[nsc   ]" => "[nsc]",
	  "[nsce  ]" => "[nsce]",
	  "[nsim  ]" => "[nsim]",
	  "[nsime ]" => "[nsime]",
	  "[nsmid ]" => "[nsmid]",
	  "[nspar ]" => "[nspar]",
	  "[nsub  ]" => "[nsub]",
	  "[nsube ]" => "[nsube]",
	  "[nsubE ]" => "[nsubE]",
	  "[nsup  ]" => "[nsup]",
	  "[nsupE ]" => "[nsupE]",
	  "[nsupe ]" => "[nsupe]",
	  "[nvdash]" => "[nvdash]",
	  "[nvDash]" => "[nvDash]",
	  "[nVDash]" => "[nVDash]",
	  "[nVdash]" => "[nVdash]",
	  "[prnap ]" => "[prnap]",
	  "[prnE  ]" => "[prnE]",
	  "[prnsim]" => "[prnsim]",
	  "[scnap ]" => "[scnap]",
	  "[scnE  ]" => "[scnE]",
	  "[scnsim]" => "[scnsim]",
	  "[subne ]" => "[subne]",
	  "[subnE ]" => "[subnE]",
	  "[supne ]" => "[supne]",
	  "[supnE ]" => "[supnE]",
	  "[vsubnE]" => "[vsubnE]",
	  "[vsubne]" => "[vsubne]",
	  "[vsupne]" => "[vsupne]",
	  "[vsupnE]" => "[vsupnE]",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Arrow Relations//EN
	  "[cularr]" => "[cularr]",
	  "[curarr]" => "[curarr]",
	  "[dArr  ]" => "[dArr]",
	  "[darr2 ]" => "[darr2]",
	  "[dharl ]" => "[dharl]",
	  "[dharr ]" => "[dharr]",
	  "[lAarr ]" => "[lAarr]",
	  "[Larr  ]" => "[Larr]",
	  "[larr2 ]" => "[larr2]",
	  "[larrhk]" => "[larrhk]",
	  "[larrlp]" => "[larrlp]",
	  "[larrtl]" => "[larrtl]",
	  "[lhard ]" => "[lhard]",
	  "[lharu ]" => "[lharu]",
	  "[hArr  ]" => "[hArr]",
	  "[harr  ]" => "[harr]",
	  "[lrarr2]" => "[lrarr2]",
	  "[rlarr2]" => "[rlarr2]",
	  "[harrw ]" => "[harrw]",
	  "[rlhar2]" => "[rlhar2]",
	  "[lrhar2]" => "[lrhar2]",
	  "[lsh   ]" => "[lsh]",
	  "[map   ]" => "[map]",
	  "[mumap ]" => "[mumap]",
	  "[nearr ]" => "[nearr]",
	  "[nlArr ]" => "[nlArr]",
	  "[nlarr ]" => "[nlarr]",
	  "[nhArr ]" => "[nhArr]",
	  "[nharr ]" => "[nharr]",
	  "[nrarr ]" => "[nrarr]",
	  "[nrArr ]" => "[nrArr]",
	  "[nwarr ]" => "[nwarr]",
	  "[olarr ]" => "[olarr]",
	  "[orarr ]" => "[orarr]",
	  "[rAarr ]" => "[rAarr]",
	  "[Rarr  ]" => "[Rarr]",
	  "[rarr2 ]" => "[rarr2]",
	  "[rarrhk]" => "[rarrhk]",
	  "[rarrlp]" => "[rarrlp]",
	  "[rarrtl]" => "[rarrtl]",
	  "[rarrw ]" => "[rarrw]",
	  "[rhard ]" => "[rhard]",
	  "[rharu ]" => "[rharu]",
	  "[rsh   ]" => "[rsh]",
	  "[drarr ]" => "[drarr]",
	  "[dlarr ]" => "[dlarr]",
	  "[uArr  ]" => "[uArr]",
	  "[uarr2 ]" => "[uarr2]",
	  "[vArr  ]" => "[vArr]",
	  "[varr  ]" => "[varr]",
	  "[uharl ]" => "[uharl]",
	  "[uharr ]" => "[uharr]",
	  "[xlArr ]" => "[xlArr]",
	  "[xhArr ]" => "[xhArr]",
	  "[xharr ]" => "[xharr]",
	  "[xrArr ]" => "[xrArr]",

          ## ISO 8879:1986//ENTITIES Added Math Symbols: Delimiters//EN
	  "[rceil ]" => "[rceil]",
	  "[rfloor]" => "[rfloor]",
	  "[rpargt]" => "[rpargt]",
	  "[urcorn]" => "[urcorn]",
	  "[drcorn]" => "[drcorn]",
	  "[lceil ]" => "[lceil]",
	  "[lfloor]" => "[lfloor]",
	  "[lpargt]" => "[lpargt]",
	  "[ulcorn]" => "[ulcorn]",
	  "[dlcorn]" => "[dlcorn]",

	  );

## ----------------------------------------------------------------------
## don't forget this
1;

## ----------------------------------------------------------------------
