#ifndef xcontrol_binary_section_h_
#define xcontrol_binary_section_h_ 1

#include "package_name.hpp"
#include "attribute.hpp"
#include "boolean_attribute.hpp"
#include "dependency_list.hpp"
#include "control_file_stream.hpp"

#include <string>

#include <ostream>

class binary_section
{
public:
	binary_section(package_name const &name);

	typedef std::string attribute_selector_type;

	typedef ::attribute<std::string> attribute;

	attribute operator[](attribute_selector_type const &);

	bool operator==(binary_section const &) const;
	bool operator!=(binary_section const &rhs) const
	{
		return !operator==(rhs);
	}

	package_name name;
	std::string section;
	dependency_list depends;
	dependency_list recommends;
	dependency_list suggests;
	dependency_list conflicts;
	dependency_list replaces;
	dependency_list provides;
	dependency_list breaks;
	std::string description;
	std::string architecture;
	dependency_list build_depends;
	dependency_list build_depends_tools;
	dependency_list build_depends_indep;
	bool optional;
	bool cross_compiling;
	bool bootstrap;
};

control_file_ostream &operator<<(control_file_ostream &, binary_section const &);

#endif
