# swagger-client
OpenAPI for https://codesearch.debian.net/

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.4.0
- Package version: 1.0.0
- Build package: io.swagger.codegen.languages.PythonClientCodegen

Do not edit or reformat the files manually

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com//.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com//.git`)

Then import the package:
```python
import swagger_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import swagger_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import swagger_client
from swagger_client.rest import ApiException
from pprint import pprint

# Configure API key authorization: api_key
configuration = swagger_client.Configuration()
configuration.api_key['x-dcs-apikey'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['x-dcs-apikey'] = 'Bearer'

# create an instance of the API class
api_instance = swagger_client.SearchApi(swagger_client.ApiClient(configuration))
query = 'query_example' # str | The search query, for example `who knows...` (literal) or `who knows\\.\\.\\.` (regular expression). See https://codesearch.debian.net/faq for more details about which keywords are supported. The regular expression flavor is RE2, see https://github.com/google/re2/blob/master/doc/syntax.txt
match_mode = 'regexp' # str | Whether the query is to be interpreted as a literal (`literal`) instead of as an RE2 regular expression (`regexp`). Literal searches are faster and do not require escaping special characters, regular expression searches are more powerful. (optional) (default to regexp)

try:
    # Searches through source code
    api_response = api_instance.search(query, match_mode=match_mode)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling SearchApi->search: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://codesearch.debian.net/api/v1*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*SearchApi* | [**search**](docs/SearchApi.md#search) | **GET** /search | Searches through source code
*SearchApi* | [**searchperpackage**](docs/SearchApi.md#searchperpackage) | **GET** /searchperpackage | Like /search, but aggregates per package


## Documentation For Models

 - [PackageSearchResult](docs/PackageSearchResult.md)
 - [SearchResult](docs/SearchResult.md)


## Documentation For Authorization


## api_key

- **Type**: API key
- **API key parameter name**: x-dcs-apikey
- **Location**: HTTP header


## Author

stapelberg@debian.org

