//
// C++ Interface: searchmanager
//
// Description:
//
//
// Author: Rikard Bjorklind <olof@users.sourceforge.net>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef SEARCHMANAGER_H
#define SEARCHMANAGER_H

#include <QObject>
#include <QDialog>
#include <QDockWidget>
#include <QPointer>
#include "searchwidget.h"
#include "backendconnection.h"

class QTabWidget;

/*!
	\brief Manages the search dialog and subwidgets.
	
	This class acts as a facade to the search interface. It receives search results and
	updates the current search widget, which it owns. It also performs searches using the
	BackendConnection that is assigned during construction.	Furthermore, it implements the
	search dialog/dockwidget switching.
*/
class SearchManager : public QObject
{
    Q_OBJECT
public:
    //! constructor
    SearchManager(boost::shared_ptr<BackendConnection> aConnection,QObject *parent = 0);

    //! destructor
    ~SearchManager();

    //! Display modes
    enum DisplayMode {
        SHOW_AS_DIALOG,
        SHOW_AS_DOCKWINDOW
    };

public slots:
    //! Called to show the search UI
    void show(QMainWindow*);

    //! Call to execute a search
    void search(int session, qint64 size, int sizeMode, int typeMode, const QString& search,SearchWidget* originator);

    //! Called when new search results arrive
    void searchResults(int,QList<SearchEntry>&);

private:
    boost::shared_ptr<BackendConnection> backendConnection;
    DisplayMode displayMode;
    QTabWidget* searchTabs;
    QPointer<QDialog> dialog;
    QPointer<QDockWidget> dock;
	
	SearchWidget* activeSearch;		//!< Search results will be sent to this widget
	int activeSearchType;			//!< Set to the search type of the last search, used for filtering
	QString activeSearchString;		//!< Set to the string of the last made search, used for filtering
	QStringList searchTokens;
	
	SearchWidget* newSearchWidget(const QString& name);
	bool isSearchForActiveWidget( const QString& searchStr ) const;
    void setupUi(QMainWindow*);
	bool dockWidgetAdded;
			
private slots:
	void onCloseCurrentSearch();		
};

#endif
