/*****************************************************************************
 *  __________________    _________  _____            _____  .__         ._.
 *  \______   \______ \  /   _____/ /     \          /  _  \ |__| ____   | |
 *   |    |  _/|    |  \ \_____  \ /  \ /  \        /  /_\  \|  _/ __ \  | |
 *   |    |   \|    `   \/        /    Y    \      /    |    |  \  ___/   \|
 *   |______  /_______  /_______  \____|__  / /\   \____|__  |__|\___ |   __
 *          \/        \/        \/        \/  )/           \/        \/   \/
 *
 * This file is part of liBDSM. Copyright © 2014-2015 VideoLabs SAS
 *
 * Author: Julien 'Lta' BALLET <contact@lta.io>
 *
 * liBDSM is released under LGPLv2.1 (or later) and is also available
 * under a commercial license.
 *****************************************************************************
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/

/*
 * Copyright (c) 2003-2017
 * Distributed Systems Software.  All rights reserved.
 *
 * $Id: netbios_utils.h 2958 2017-05-18 18:56:19Z brachman $
 */

#ifndef _LIBDSM_NETBIOS_UTILS_H_
#define _LIBDSM_NETBIOS_UTILS_H_

#include "netbios_defs.h"

#ifdef __cplusplus
extern "C" {
#endif

extern void netbios_name_level1_encode(const char *name, char *encoded_name,
									   unsigned type);
extern void netbios_name_level1_decode(const char *encoded_name, char *name);

// XXX: domain support is not implemented
extern char *netbios_name_encode(const char *name, char *domain,
								 unsigned type);
extern int netbios_name_decode(const char *encoded_name,
							   char *name, char **domain);

#ifdef __cplusplus
}
#endif

#endif
