DS(3)                    DACS Library Functions Manual                   DS(3)



[1mNAME[0m
       ds - Dynamic strings and vectors

[1mSYNOPSIS[0m
       [1m#include "dsslib.h"[0m

       [1mDs *ds_init(Ds *[4m[22mods[24m[1m);[0m

       [1mDs *ds_init_size(Ds *[4m[22mods[24m[1m, size_t [4m[22mnbytes[24m[1m);[0m

       [1mDs *ds_alloc(void);[0m

       [1mDs *ds_alloc_size(size_t [4m[22mnbytes[24m[1m);[0m

       [1mDs *ds_reinit(Ds *[4m[22mds[24m[1m);[0m

       [1mDs *ds_reinit_size(Ds *[4m[22mods[24m[1m, size_t [4m[22mnbytes[24m[1m);[0m

       [1mDs *ds_reset(Ds *[4m[22mds[24m[1m);[0m

       [1mDs *ds_reset_buf(Ds *[4m[22mds[24m[1m);[0m

       [1mDs *ds_trim(Ds *[4m[22mds[24m[1m);[0m

       [1mDs *ds_grow(Ds *[4m[22mds[24m[1m);[0m

       [1mvoid ds_free(Ds *[4m[22mds[24m[1m);[0m

       [1mint ds_appendc(Ds *[4m[22mds[24m[1m, int [4m[22mch[24m[1m);[0m

       [1mint ds_copyb(Ds *[4m[22mds[24m[1m, void *[4m[22msrc[24m[1m, size_t [4m[22mlen[24m[1m, unsigned int [4m[22moffset[24m[1m);[0m

       [1mint ds_insertb(Ds *[4m[22mds[24m[1m, void *[4m[22msrc[24m[1m, size_t [4m[22mlen[24m[1m, unsigned int [4m[22moffset[24m[1m);[0m

       [1mint ds_append(Ds *[4m[22mds[24m[1m, char *[4m[22mstr[24m[1m);[0m

       [1mint ds_concat(Ds *[4m[22mds[24m[1m, char *[4m[22mstr[24m[1m);[0m

       [1mint ds_concatc(Ds *[4m[22mds[24m[1m, int [4m[22mch[24m[1m);[0m

       [1mint ds_concatn(Ds *[4m[22mds[24m[1m, char *[4m[22mstr[24m[1m, size_t [4m[22mlen[24m[1m);[0m

       [1mDs *ds_set(Ds *[4m[22mds[24m[1m, char *[4m[22mstr[24m[1m);[0m

       [1mDs *ds_setn(Ds *[4m[22mds[24m[1m, unsigned char *[4m[22ms[24m[1m, size_t [4m[22mslen[24m[1m);[0m

       [1mDs *ds_range(Ds *[4m[22mds[24m[1m, char *[4m[22mstr[24m[1m, char *[4m[22mrange_spec[24m[1m, Range_syntax *[4m[22mors[24m[1m);[0m

       [1mint ds_getc(Ds *[4m[22mds[24m[1m, FILE *[4m[22mfp[24m[1m, int *[4m[22mch_ptr[24m[1m);[0m

       [1mDsio *dsio_set(Ds *[4m[22mds[24m[1m, FILE *[4m[22mfp[24m[1m, char *[4m[22mbuf[24m[1m, unsigned long [4m[22mlen[24m[1m,[0m
                      [1mint [4m[22mhave_length[24m[1m);[0m

       [1mint dsio_free(Ds *[4m[22mds[24m[1m);[0m

       [1mint dsio_eof(Ds *[4m[22mds[24m[1m);[0m

       [1mint dsio_nextc(Ds *[4m[22mds[24m[1m, int *[4m[22mch_ptr[24m[1m);[0m

       [1mint dsio_peekc(Ds *[4m[22mds[24m[1m, int *[4m[22mch_ptr[24m[1m);[0m

       [1mchar *dsio_agets(Ds *[4m[22mds[24m[1m);[0m

       [1mchar *dsio_gets(Ds *[4m[22mds[24m[1m);[0m

       [1mint dsio_load(Ds *[4m[22mds[24m[1m);[0m

       [1mchar *dsio_load_str(Ds *[4m[22mds[24m[1m);[0m

       [1mchar *ds_gets(Ds *[4m[22mds[24m[1m, FILE *[4m[22mfp[24m[1m);[0m

       [1mchar *ds_agets(Ds *[4m[22mds[24m[1m, FILE *[4m[22mfp[24m[1m);[0m

       [1mchar *ds_agets_buf(Ds *[4m[22mds[24m[1m, char *[4m[22mbuf[24m[1m);[0m

       [1mchar *ds_prompt(Ds *[4m[22mds[24m[1m, char *[4m[22mprompt[24m[1m, unsigned int [4m[22mflag[24m[1m);[0m

       [1mchar *ds_readline(Ds *[4m[22mds[24m[1m, char *[4m[22mprompt[24m[1m, char *[4m[22mcprompt[24m[1m);[0m

       [1mDs *ds_load_file(Ds *[4m[22mds[24m[1m, char *[4m[22mpathname[24m[1m);[0m

       [1mDs *ds_agetf(Ds *[4m[22mds[24m[1m, FILE *[4m[22mfp[24m[1m);[0m

       [1mDs *ds_getf(FILE *[4m[22mfp[24m[1m);[0m

       [1mint ds_sprintf(Ds *[4m[22mds[24m[1m, unsigned int [4m[22moffset[24m[1m, char *[4m[22mfmt[24m[1m, ...);[0m

       [1mint ds_asprintf(Ds *[4m[22mds[24m[1m, char *[4m[22mfmt[24m[1m, ...);[0m

       [1mint ds_vasprintf(Ds *[4m[22mds[24m[1m, char *[4m[22mfmt[24m[1m, va_list [4m[22map[24m[1m);[0m

       [1mchar *ds_xprintf(char *[4m[22mfmt[24m[1m, ...);[0m

       [1mchar *ds_vxprintf(char *[4m[22mfmt[24m[1m, va_list [4m[22map[24m[1m);[0m

       [1mFILE *ds_fopen_secure(const char *[4m[22mpath[24m[1m, const char *[4m[22mmode[24m[1m, size_t [4m[22msize[24m[1m);[0m

       [1mint ds_fclose(FILE *[4m[22mfp[24m[1m);[0m

       [1mint ds_fclean(FILE *[4m[22mfp[24m[1m);[0m

       [1mDsvec *dsvec_init(Dsvec *[4m[22mdsv[24m[1m, size_t [4m[22msize[24m[1m);[0m

       [1mDsvec *dsvec_alloc(size_t [4m[22msize[24m[1m);[0m

       [1mDsvec *dsvec_init_size(Dsvec *[4m[22mdsv[24m[1m, size_t [4m[22msize[24m[1m, int [4m[22mn[24m[1m);[0m

       [1mDsvec *dsvec_alloc_size(size_t [4m[22msize[24m[1m, int [4m[22mn[24m[1m);[0m

       [1mvoid dsvec_free(Dsvec *[4m[22mdsv[24m[1m);[0m

       [1mDsvec *dsvec_grow(Dsvec *[4m[22mdsv[24m[1m, unsigned int [4m[22mnew_nelements[24m[1m);[0m

       [1mDsvec *dsvec_subset(Dsvec *[4m[22mdsv[24m[1m, Dsvec *[4m[22mold_dsv[24m[1m, unsigned int [4m[22mstart[24m[1m,[0m
                           [1mint [4m[22mlen[24m[1m);[0m

       [1mDsvec *dsvec_copy(Dsvec *[4m[22mdsv[24m[1m, Dsvec *[4m[22mold_dsv[24m[1m);[0m

       [1mvoid *dsvec_ptr_index(Dsvec *[4m[22mdsv[24m[1m, unsigned int [4m[22mind[24m[1m);[0m

       [1mint dsvec_delete_ptr_index(Dsvec *[4m[22mdsv[24m[1m, unsigned int [4m[22mind[24m[1m);[0m

       [1mint dsvec_delete_ptr(Dsvec *[4m[22mdsv[24m[1m, void *[4m[22mptr[24m[1m);[0m

       [1mint dsvec_replace_ptr(Dsvec *[4m[22mdsv[24m[1m, void *[4m[22mptr[24m[1m, unsigned int [4m[22mind[24m[1m);[0m

       [1mint dsvec_streq(Dsvec *[4m[22mdsv1[24m[1m, Dsvec *[4m[22mdsv2[24m[1m);[0m

       [1mint dsvec_strneq(Dsvec *[4m[22mdsv1[24m[1m, Dsvec *[4m[22mdsv2[24m[1m, size_t [4m[22mlen[24m[1m);[0m

       [1mint dsvec_rotate(Dsvec *[4m[22mdsv[24m[1m, int [4m[22mnpos[24m[1m);[0m

       [1mDsvec *dsvec_strlist(Dsvec *[4m[22mdsv[24m[1m, char *[4m[22mstr_spec[24m[1m);[0m

       [1mDsvec *dsvec_slice(Dsvec *[4m[22mdsv[24m[1m, Dsvec *[4m[22mprimary[24m[1m, unsigned int [4m[22mind[24m[1m,[0m
                          [1munsigned int [4m[22mlen[24m[1m);[0m

       [1mDsvec *dsvec_range(Dsvec *[4m[22mdsv[24m[1m, Dsvec *[4m[22mprimary[24m[1m, char *[4m[22mrange_spec[24m[1m,[0m
                          [1mRange_syntax *[4m[22mors[24m[1m);[0m

       [1mint dsvec_replace(Dsvec *[4m[22mprimary[24m[1m, unsigned int [4m[22mind[24m[1m,[0m
                         [1munsigned int [4m[22mdelete_len[24m[1m, Dsvec *[4m[22msecondary[24m[1m);[0m

       [1mint dsvec_append(Dsvec *[4m[22mprimary[24m[1m, Dsvec *[4m[22msecondary[24m[1m);[0m

       [1mint dsvec_insert_ptr(Dsvec *[4m[22mdsv[24m[1m, unsigned int [4m[22mind[24m[1m, void *[4m[22mptr[24m[1m);[0m

       [1mint dsvec_add_ptr(Dsvec *[4m[22mdsv[24m[1m, void *[4m[22mptr[24m[1m);[0m

       [1mint dsvec_insert(Dsvec *[4m[22mprimary[24m[1m, unsigned int [4m[22mind[24m[1m, Dsvec *[4m[22msecondary[24m[1m);[0m

       [1mint dsvec_delete(Dsvec *[4m[22mdsv[24m[1m, unsigned int [4m[22mind[24m[1m, unsigned int [4m[22mndelete[24m[1m);[0m

       [1mint dsvec_add_obj(Dsvec *[4m[22mdsv[24m[1m);[0m

       [1mvoid dsvec_sort(Dsvec *[4m[22mdsv[24m[1m, int [4m[22m(*compar)(const[24m [4mvoid[24m [4m*,[24m [4mconst[24m [4mvoid[24m [4m*)[24m[1m);[0m

       [1mDsvec *dsvec_load(Ds *[4m[22mds[24m[1m, Dsvec *[4m[22mdsv[24m[1m);[0m

       [1mDsvec *ds_mkargv_add(Dsvec *[4m[22mdsv[24m[1m, char *[4m[22mel[24m[1m);[0m

       [1mDsvec *ds_mkargv_addv(Dsvec *[4m[22mdsv[24m[1m, int [4m[22margc[24m[1m, char **[4m[22margv[24m[1m);[0m

                             typedef struct Mkargv {
                               int [4mkeepq[24m;
                               int [4mkeepws[24m;
                               char *[4mifs[24m;
                               char *[4mstartq[24m;
                               char *[4mendq[24m;
                             } Mkargv;

       [1mDsvec *ds_mkargv(Dsvec *[4m[22mdsv[24m[1m, char *[4m[22mstr[24m[1m, Mkargv *[4m[22mconf[24m[1m);[0m

       [1mchar *ds_buf(Ds *[4m[22mds[24m[1m);[0m

       [1msize_t ds_len(Ds *[4m[22mds[24m[1m);[0m

       [1msize_t ds_size(Ds *[4m[22mds[24m[1m);[0m

       [1mint ds_eq(Ds *[4m[22mds1[24m[1m, Ds *[4m[22mds2[24m[1m);[0m

       [1m(TYPE) dsvec_ptr(Ds *[4m[22mDSV[24m[1m, unsigned int [4m[22mIND[24m[1m, [4m[22mTYPE[24m[1m);[0m

       [1m(TYPE) dsvec_obj(Ds *[4m[22mDSV[24m[1m, unsigned int [4m[22mIND[24m[1m, [4m[22mTYPE[24m[1m);[0m

       [1m(TYPE) dsvec_new_obj(Ds *[4m[22mDSV[24m[1m, [4m[22mTYPE[24m[1m);[0m

       [1m(TYPE) dsvec_base_type(Ds *[4m[22mDSV[24m[1m, [4m[22mTYPE[24m[1m);[0m

       [1mvoid **dsvec_base(Dsvec *[4m[22mdsv[24m[1m);[0m

       [1munsigned int dsvec_len(Dsvec *[4m[22mdsv[24m[1m);[0m

                              [4mextern[24m [4mint[24m [4mds_default_clear_flag;[0m
                              [4mextern[24m [4mint[24m [4mds_default_delnl_flag;[0m
                              [4mextern[24m [4msize_t[24m [4mds_default_len_limit;[0m
                              [4mextern[24m [4mvoid[24m [4m*(*ds_default_malloc_func)(size_t[24m [4msize);[0m
                              [4mextern[24m [4mvoid[24m [4m*(*ds_default_free_func)(void[24m [4m*ptr);[0m


[1mDESCRIPTION[0m
       The DS library is a collection of functions for creating, manipulating,
       and formatting strings of bytes. The memory used by these strings is
       dynamically allocated and released as necessary. When used correctly,
       bugs caused by buffer overruns and other programming errors can be
       avoided. There are also functions for creating and manipulating dynamic
       vectors of pointers and objects.

       ...

   [1mByte Strings[0m
       A [1mDs [22mdata structure represents a dynamic string. It must be initialized
       before it can be used. A [1mDs [22mvariable contains several fields that may
       be set after initialization but before it is first used. Default values
       for some of these fields are copied from global variables exported by
       the library.

       [1mInitialization[0m
       [1mManipulation[0m
       [1mFormatting[0m
   [1mVectors[0m
DACS 1.4.38a                      11/23/2016                             DS(3)
