DACS.CONF(5)                  DACS Formats Manual                 DACS.CONF(5)



[1mNAME[0m
       dacs.conf - [1mDACS [22mconfiguration files and directives

[1mDESCRIPTION[0m
       These files are part of the [1mDACS [22msuite.

       Nearly all [1mDACS [22mservices and utilities consult a configuration file
       when they start up. Such things as the per-jurisdiction locations of
       access control files and log files, authentication processing, error
       handling, and run-time limits are specified in the configuration file.
       The recommended name for this file is dacs.conf and the [1mDACS[0m
       documentation will generally refer to it by that name. Site-wide
       configuration, which is optional, is typically put in a file named
       site.conf. Both files are XML documents, and consist of various
       sections, clauses, and directives, not unlike the httpd.conf
       configuration file used by [1mApache[22m. Different federations and
       jurisdictions running on the same host may share these files or each
       might have its own separate configuration file; the former is more
       common since it reduces duplication and helps to prevent
       inconsistencies.

       Federations, jurisdictions, and other important concepts are discussed
       in [34m[1mdacs(1)[0m[1m[22m[1].

           [1mNote[0m
           Unlike the "passive" configuration files found in most systems, the
           [1mDACS [22mconfiguration files are "active"; that is, configuration
           directives are evaluated as expressions within a run-time context
           that includes information related to the current request, web
           server, operating system, and [1mDACS [22mitself. By specifying the value
           of a directive as an expression rather than a simple string, the
           configuration under which a request is processed can adapt to, or
           depend on, the context in which it is made. Administrators do not
           need to use this capability, but it is available when flexibility
           is needed.

           [1mNote[0m
           Each configuration file is completely read and processed once, each
           time a [1mDACS [22mweb service or utility is executed. Changes to the
           files take effect the next time the files are read; no
           recompilation or special action needs to be taken, and neither
           [1mApache [22mnor any other server needs to be restarted. It is usually
           safe to make minor updates to the configuration files while [1mDACS [22mis
           operational, but it is better to temporarily deny all access if the
           web server is busy and more complicated changes are being made.
           Because [1mDACS [22mcomponents abort if they encounter a configuration
           error (e.g., leading to all access to be denied, all authentication
           to fail, or a utility to become non-operational), temporarily
           introducing a configuration error will not usually cause any
           serious problems. Under heavy load or if complex authentication
           methods have been configured, however, it is prudent to stop the
           web server briefly while the old configuration files are replaced
           with the new ones.

           [1mTip[0m
           While it may at first seem that [1mDACS [22mis difficult to configure, in
           practice the default configuration that comes with the [1mDACS[0m
           distribution is sufficient in many cases, and leaves only a few
           straightforward, site-dependent directives to be specified. Many
           administrators will never need to use the more advanced
           configuration features.

           [1mTip[0m
           +o   The [1mDACS [22mdistribution includes a prototype version of
               site.conf, found in conf/site.conf-std, which establishes
               reasonable defaults based on [1mDACS [22mbuild-time arguments. It may
               need some customization for the local environment. By default,
               [1mDACS [22mlooks for the site configuration file in
               federations/site.conf, relative to the [1mDACS [22minstallation
               directory; conf/site.conf-std can be copied there and any
               necessary customizations made.

           +o   A command to validate and display configuration, [34m[1mdacsconf(1)[0m[1m[22m[2]
               is available, as is a simple web service, [34m[1mdacs_conf(8)[0m[1m[22m[3].
               Until you become comfortable with configuration files, consider
               running one of them after making changes. A fatal configuration
               error will prevent [1mDACS [22mfrom running and access to all
               [1mDACS[22m-wrapped resources will be denied.

   [1mLocating dacs.conf and site.conf[0m
       The locations of dacs.conf and site.conf may be specified with the web
       server configuration, in an environment variable, through a command
       line flag, or at compile time. A single configuration file can provide
       directives for multiple [1mDACS [22mjurisdictions. For example, if a machine
       is hosting more than one [1mDACS [22mjurisdiction, they can each use the same
       [1mDACS [22mbinaries.

           [1mNote[0m
           Most [1mDACS [22mcommands and web services require the dacs.conf file to
           exist; the exceptions are a few "standalone" programs, such as
           [34m[1mdacshttp(1)[0m[1m[22m[4]. The site.conf file is not required; if a location
           has been configured and the file exists, however, it must be
           readable and by convention should contain default values
           appropriate for the installed release.

       Command line flags common to many [1mDACS [22mprograms are described in
       [34m[1mdacs(1)[0m[1m[22m[5].

       So that [34m[1mdacs_acs(8)[0m[1m[22m[6] (which is invoked by the [34m[1mmod_auth_dacs[0m[1m[22m[7]
       module) can find its configuration, the location of dacs.conf can be
       specified in [1mApache's [22mhttpd.conf file using the SetDACSAuthConf
       directive. It may instead, however, be specified through the [1mDACS_CONF[0m
       environment variable, on the command line, or using a build-time
       default. Similarly, the location of site.conf can be specified in
       [1mApache's [22mhttpd.conf file using the SetDACSAuthSiteConf directive,
       through the [1mDACS_SITE_CONF [22menvironment variable, on the command line,
       or using a build-time default.

       If the location of dacs.conf (site.conf) is not given at run-time, a
       compile-time value of the symbol DACS_CONF (DACS_SITE_CONF) will be
       used if possible. This is the usual case for programs other than
       [1mdacs_acs[22m. It is a fatal error if a [1mDACS [22mservice can't locate dacs.conf.

       Regardless of how the location of dacs.conf is specified, [1mDACS [22mperforms
       string interpolation on the pathname. If interpolation fails, [1mDACS [22mwill
       encounter a fatal error because it will not be able to locate its
       configuration file.

       [1mPath Interpolation[0m
           Path interpolation is available using a syntax and method similar
           to [1mApache's [34mmod_vhost_alias[0m[1m[22m[8] module. Interpolation is always
           performed to determine the locations of several resources used by
           [1mDACS[22m, such as dacs.conf and site.conf, and with [1mDACS's [34mLOG_FILE[0m[1m[22m[9]
           directive, regardless of the manner in which the location is
           provided to [1mDACS[22m. It is applied whether the location of dacs.conf
           is specified using the [1m-u [22mcommand line flag or the [1mApache[0m
           ([1mmod_auth_dacs[22m) SetDACSAuthConf directive, for instance.

           The functionality can also be accessed using the [34m[1mpathname()[0m[1m[22m[10]
           function.

           The strings that may be interpolated into the pathname are obtained
           from the execution environment, in particular the URI authority
           information (based on [1mApache[22m's [1mSERVER_NAME [22mand [1mSERVER_PORT[0m
           environment variables), the URI service path (described below),
           build-time configuration, and the applicable Jurisdiction section's
           distinguishing URI.

           Interpolation is controlled by [1mprintf[22m-like format specifiers, as
           follows:

           %%
               Insert a literal percent character

           %a
               Insert the application name, which is obtained from the
               filename component of the program's [4margv[0][24m argument

           %bA
               Insert the absolute pathname of the root of the Apache
               installation directory, specified at build-time ([4mAPACHE_HOME[24m)

           %bD
               Insert the absolute pathname of the root of the [1mDACS[0m
               installation directory, specified at build-time ([4mDACS_HOME[24m)

           %p
               Insert the port number of the virtual host ([1mSERVER_PORT[22m)

           %[4mN[24m.[4mM[0m
               Insert one or more components of the name, or a substring of
               those subcomponents.  [4mN[24m and [4mM[24m are numbers used to select part
               of the [1mSERVER_NAME [22mstring (a domain name or IP address).  [4mN[0m
               selects from the dot-separated components of [1mSERVER_NAME[22m, while
               [4mM[24m selects characters within whatever [4mN[24m has selected.  [4mM[24m is
               optional and defaults to zero if it isn't present. The dot must
               be present if and only if [4mM[24m is also present. If [4mN[24m or [4mM[24m are
               greater than the number of parts available, a single underscore
               is interpolated. The numbers are interpreted as follows:

               0 or 1+ or -1+
                   the whole name

               1
                   the first part

               2
                   the second name

               -1
                   the last part

               -2
                   the next-to-last part

               2+
                   the second and all following parts

               -2+
                   the next-to-last and all preceding parts


           %s[[4mN[24m.[4mM[24m]
               This is a synonym for %[4mN[24m.[4mM[24m, with %s being equivalent to %0.

                   [1mNote[0m
                   In cases where the character following %s should not be
                   interpreted as part of the format, it must be escaped
                   (e.g., %s%2).

           %u[[4mN[24m.[4mM[24m]
               This functions like the %s specifier except that it is applied
               to the URI service path (described below) for the current
               request, which has slash-separated components.  %u is
               equivalent to %u0. For example, if the URI service path is
               "example.com/metalogic", %u1 would be "example.com", %u2 would
               be "metalogic", and %u0 (and %u and %u1+) would be
               "example.com/metalogic".

                   [1mNote[0m
                   In cases where the character following %u should be
                   interpolated verbatim and not interpreted as part of the
                   specifier, it must be escaped (e.g., %u%2).

           %U[[4mN[24m.[4mM[24m]
               This functions like the %u specifier except that it is applied
               to the applicable [34m[1mJurisdiction section's[0m[1m[22m[11] distinguishing URI
               (described below).  %U is equivalent to %U0.

                   [1mNote[0m
                   +o   Because the applicable Jurisdiction section is not
                       known until after configuration processing has started,
                       this specifier cannot be used to describe the location
                       of configuration files.

                   +o   In cases where the character following %U should be
                       interpolated verbatim and not interpreted as part of
                       the specifier, it must be escaped (e.g., %U%2).

               Other format specifiers
                   If a % is followed by an unrecognized specifier, that
                   character is inserted verbatim.

               Other characters
                   All other characters are inserted verbatim

               For example, if [1mSERVER_NAME [22mis dss.example.com and [1mSERVER_PORT[0m
               is 8080, then the [1mApache [22mdirective:

                   SetDACSAuthConf dacs-acs "/usr/local/apache2/conf/dacs/%2+/dacs.conf"

               will expand the path to
               /usr/local/apache2/conf/dacs/example.com/dacs.conf. The command
               line flag:

                   -c /usr/local/dacs/%1%.%p/dacs.conf

               specifies the location of the configuration file to be
               /usr/local/dacs/dss.8080/dacs.conf.

               The %u specifier interpolates the URI service path, or portions
               thereof, which is the string [1mHTTP_HOST[22m/[1mREQUEST_URI [22m(without a
               query component). When a [1mDACS [22mservice is invoked as a CGI, this
               will be the usual case; the URI service path is undefined if
               either of those environment variables is unavailable, however.

   [1mFile Format[0m
       dacs.conf is an XML document that conforms to [34m[1mConfiguration.dtd[0m[1m[22m[12].

       A dacs.conf file consists of an optional Default section followed by
       zero or more Jurisdiction sections. Either type of section consists of
       [1mDACS [22mdirectives or XML elements, called clauses, that contain [1mDACS[0m
       directives. There are three kinds of clauses: Auth clauses, Roles
       clauses, and Transfer clauses.

       Just to give its flavour, here's an incomplete dacs.conf file:

           <Configuration>
             <Default>
               LOG_FILE "${Conf::DACS_HOME}/logs/logfile"
               FEDERATION_DOMAIN "example.com"
               FEDERATION_NAME "ROOT"
               LOG_LEVEL "notice"
               SSL_PROG "/usr/local/dacs/bin/sslclient"
             </Default>

             <!-- Configuration of first jurisdiction -->
             <Jurisdiction uri="dss.example.com">
               JURISDICTION_NAME "DSS"
               <Auth id="auth_name">
                 URL "https://dss.example.com/cgi-bin/dacs/local_unix_authenticate"
                 STYLE "pass"
                 CONTROL "sufficient"
               </Auth>
              </Jurisdiction>

             <!-- Configuration of second jurisdiction -->
              <Jurisdiction uri="dss.example.com/foo">
                JURISDICTION_NAME "FOO"
              </Jurisdiction>

             <!-- Configuration of third jurisdiction -->
              <Jurisdiction uri="metalogic.example.com">
                JURISDICTION_NAME "METALOGIC"
              </Jurisdiction>
            </Configuration>

       The structure of site.conf is only slightly different. The Default
       section is mandatory in site.conf and no Jurisdiction sections are
       allowed.

           [1mNote[0m
           Because the configuration files are XML documents, characters
           special to XML must be properly escaped. In particular, an
           ampersand character must always be written as &amp; and a <
           character must be written as &lt;.

       Although the XML format of the [1mDACS [22mconfiguration files is easily
       understood and fairly readable, and they can be modified using any text
       editor, there is nothing to prevent a special-purpose tool from being
       used.

   [1mThe Default Section[0m
       The purpose of the Default section in dacs.conf is to establish default
       values for directives that tend to be shared amongst all of the
       Jurisdiction sections that appear in dacs.conf. The Default section is
       optional; if present, it must appear before any Jurisdiction section in
       dacs.conf.

       The site.conf file, if it exists, consists of only a Default section.
       Directives that are common to all of a site's dacs.conf files might be
       put in site.conf.

       Any configuration directive or clause may appear in the Default
       section.

   [1mThe Jurisdiction Section[0m
       Each Jurisdiction section contains configuration directives that are
       associated with a particular jurisdiction. These directives override
       those found anywhere else, as described below.

   [1mSection Merging and Directive Evaluation[0m
       The three types of configuration sections are merged as follows. First,
       directives and clauses that appear in the site.conf Default section are
       overridden by those that appear in the dacs.conf Default section. The
       resulting directives and clauses are in turn overridden by those that
       appear in the selected Jurisdiction section. Usually, site.conf will
       contain the standard default directives that come with the installed
       release of [1mDACS[22m, the dacs.conf Default section will contain directives
       common to all of the jurisdictions defined on the host that are in the
       same federation, and each Jurisdiction section will contain directives
       specific to that jurisdiction.

       The exception to this merging procedure is directives in the [34m[1mStack[0m
       [1m[34mcategory[0m[1m[22m[13]. Instead of overriding, these directives accumulate.

       The order in which directives (but not clauses) appear within a section
       is not significant, even with respect to references to variables in the
       [4mConf[24m [34m[1mnamespace[0m[1m[22m[14], with the exception of the [34m[1mEVAL directive[0m[1m[22m[15].

       Only after directives in the three sections are merged are their
       right-hand sides evaluated (again, with the exception of [34m[1mEVAL[0m[1m[22m[15]) to
       determine the value of each directive. Therefore, if a directive
       appears in both the Default section and the Jurisdiction section, the
       instances in the Default section will not have their directive values
       evaluated; they will simply be discarded (with the exception of the
       Stack directive category).

       [1mThe undef() directive[0m
           As a special case, if a directive is given the special value
           returned by [34m[1mundef()[0m[1m[22m[16], the instance of the directive is deleted.
           This provides a way to conditionally include or exclude a directive
           depending on the execution environment. For example, this directive
           increases the debugging level for [1mDACS [22mweb services but not for
           commands:

               LOG_LEVEL ${Env::REMOTE_ADDR:e} ? "TRACE" : undef()


               [1mNote[0m
               Because of the way configuration files are currently processed,
               the check for directive category satisfaction happens [4mbefore[0m
               right-hand side evaluation. This means that in any particular
               section only one instance of a given directive in the Required1
               category may appear (see [34m[1mDirective Categories[0m[1m[22m[13]), even if
               just one would be included after the evaluation step.

       [1mFatal errors[0m
           It is a fatal error to reference an undefined variable unless the e
           or ?  [34m[1mmodifier flag[0m[1m[22m[17] is used in the variable reference.
           Recursive variable references are detected and result in a fatal
           error. If a directive ends up not being evaluated, it does not
           matter whether its right-hand side is invalid (or would be if
           evaluated).

               [1mNote[0m
               When a fatal error occurs during configuration processing, a
               [1mDACS [22mweb service tries to terminate gracefully. But because
               directives (including error handling directives) may not have
               been processed correctly, or even at all, there is no guarantee
               that an error handler (such as one defined by the
               [34m[1mACS_ERROR_HANDLER[0m[1m[22m[18] directive) will be invoked or a requested
               output format will be honoured during abnormal termination. A
               non-zero exit process status is always returned.

       [1mAn example[0m
           Consider the following configuration excerpts:

               # In site.conf:
                 LOG_LEVEL "debug"

               # In the dacs.conf Default section:
                 LOG_LEVEL "notice"

               # In the dacs.conf Jurisdiction section:
                 LOG_LEVEL "trace"

           After configuration processing, the directive LOG_LEVEL will be set
           to "trace", and the variable [4m${Conf::LOG_LEVEL}[24m will have that
           value during configuration processing.

           Here are some excerpts from a dacs.conf file:

               # In the Default section:
                 FEDERATION_DOMAIN "example.com"
                 FEDERATION_NAME "EXAMPLE"

               # In the Jurisdiction section:
                 JURISDICTION_NAME "DEMO"
                 VFS "[abc]dacs-fs:${Conf::FEDERATIONS_ROOT}/${Conf::FEDERATION_DOMAIN}\
               /${Conf::JURISDICTION_NAME}/abc"

           When computing the VFS directive's value in the example above, the
           values of the [4mFEDERATIONS_ROOT[24m variable (determined at build-time)
           and the FEDERATION_DOMAIN and JURISDICTION_NAME configuration
           directives are interpolated. Directives in site.conf may reference
           configuration variables that are defined in dacs.conf.

           Given the configuration:

               # In site.conf:
                 VFS "[dtds]dacs-fs:/usr/local/dacs/www/dtd-xsd"

               # In the dacs.conf Default section:
                 VFS "[dtds]dacs-fs:/usr/local/dacs/dtd-xsd"

               # In the dacs.conf Jurisdiction section:
                 VFS "[dtds]dacs-fs:/export/dacs/dtd-xsd"
                 VFS "[xxx]dacs-fs:/export/dacs/xxx"

           All four VFS directives will be in effect, but they will be ordered
           such that the first one in the Jurisdiction section is at the top
           of the stack, the second one in that section is next on the stack,
           the directive in the dacs.conf Default section follows, and the one
           from site.conf is last.

   [1mJurisdiction Section Selection[0m
       [1mDACS [22mweb services and commands do not have any federation or
       jurisdiction information compiled into them, so that a single set of
       [1mDACS [22mbinaries can be shared by many jurisdictions (e.g., by multiple
       real or virtual web servers on the same host, or using NFS or some
       other file sharing mechanism). But it means that (most) web services
       and commands need a run-time mechanism to determine "who they are" -
       which federation and jurisdiction are they acting on behalf of? For web
       services, this usually depends on the server name, hostname, port,
       scheme, URI path, some other context associated with the request, or a
       combination of these things. But it is sometimes most convenient to
       specify a jurisdiction name and have [1mDACS [22mwork out what the request
       URIs to that jurisdiction look like, if it needs to.

       Most [1mDACS [22mweb services and commands need to obtain run-time
       configuration information for the jurisdiction they represent. Because
       dacs.conf may specify the configuration of more than one jurisdiction,
       how do they know which Jurisdiction section they should use? In cases
       where [1mDACS [22mdoes not know the jurisdiction name, it searches for the
       correct Jurisdiction section and then determines the name of the
       jurisdiction; in cases where it is given the jurisdiction name, it
       searches Jurisdiction sections to find one with a directive that
       identifies the jurisdiction that it was given.

       The applicable Jurisdiction section to use for a particular web service
       request or command can be determined in a variety of ways, using:

       +o   the [1m-u [22mcommand line flag to specify a [4mconfig-uri[24m that is matched
           against [34m[1meffective jurisdictional URIs[0m[1m[22m[19];

       +o   the [1m-uj [22mcommand line flag to specify a [4mjurisdiction-name[24m that is
           matched against Jurisdiction sections' JURISDICTION_NAME directive;

       +o   the [1m-us [22mcommand line flag to indicate that there is only a single
           Jurisdiction section, so that section should be selected; or

       +o   by matching a request URI against [34m[1meffective jurisdictional[0m
           [1m[34mURIs[0m[1m[22m[19].


       Command line flags are described in [34m[1mdacs(1)[0m[1m[22m[5], as is the
       [1mDEFAULT_JURISDICTION [22menvironment variable.

       These methods will be described individually shortly.

           [1mTip[0m
           Because selection of the applicable Jurisdiction section is quite
           flexible, it may seem complicated. In practice, however, it is
           often rather simple, and particularly so if only one jurisdiction
           is being configured. It may be sufficient to read this section and
           skip the detail presented in the remainder of the discussion on how
           the Jurisdiction section is selected.

       If there is only one jurisdiction, its uri attribute value can simply
       be the domain name associated with the jurisdiction. Any of the command
       line flags could then be used (or none). If the jurisdiction's domain
       name is foo.example.com, for instance, the Jurisdiction section in
       dacs.conf might look like:

           <Configuration>
             <Jurisdiction uri="foo.example.com">
               JURISDICTION_NAME "FOO"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>
            </Configuration>

       In the [1mApache [22mconfiguration file (httpd.conf), one might specify:

           AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs "-u foo.example.com"

       (which tells [1mDACS [22mthat all web service requests from the web server or
       virtual host to which this directive applies should be associated with
       the domain foo.example.com for configuration purposes), or

           AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs "-us"

       (telling [1mDACS [22mthat all web service requests from the web server or
       virtual host to which this directive applies should be associated with
       the only jurisdiction described in the configuration file, whatever
       that jurisdiction may be), or

           AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs "-uj FOO"

       (telling [1mDACS [22mthat all web service requests from the web server or
       virtual host to which this directive applies should be associated with
       jurisdiction FOO), or simply

           AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs

       In the last case, [1mDACS [22mwill match the request URI (which presumably
       looks like https://foo.example.com/...) against foo.example.com.

       Multiple jurisdictions that are identified by distinct domain names are
       also easily configured once a [1mDACS [22madministrator decides how he would
       like request URIs to identify them. This is usually done much like
       this:

           <Configuration>
             <Jurisdiction uri="foo.example.com">
               JURISDICTION_NAME "FOO"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>

             <Jurisdiction uri="baz.example.com">
               JURISDICTION_NAME "BAZ"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>
            </Configuration>

       And so that the domain name in the request URI is matched against the
       jurisdiction's effective URI, one would use:

           AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs

       Multiple jurisdictions that share a domain name but are distinguished
       by a portion of the request URI pathname component, are often
       configured something like:

           <Configuration>
             <Jurisdiction uri="example.com/foo">
               JURISDICTION_NAME "FOO"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>

             <Jurisdiction uri="example.com/baz">
               JURISDICTION_NAME "BAZ"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>
            </Configuration>

       And again using:

           AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs

       With this style of configuration, a request for
       https://example.com/foo/cgi-bin/dacs/blah would be directed to the
       configuration for the FOO jurisdiction.

       Similarly, port numbers can also be used for Jurisdiction section
       selection:

           <Configuration>
             <Jurisdiction uri="example.com:443">
               JURISDICTION_NAME "FOO"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>

             <Jurisdiction uri="example.com:8443">
               JURISDICTION_NAME "BAZ"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>
            </Configuration>

       Lastly, a hostname wildcard syntax can be useful:

           <Configuration>
             <Jurisdiction uri="*.foo.example.com">
               JURISDICTION_NAME "FOO"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>

             <Jurisdiction uri="*.baz.example.com">
               JURISDICTION_NAME "BAZ"
               FEDERATION_DOMAIN "example.com"
               # And so on...
              </Jurisdiction>
            </Configuration>


           [1mImportant[0m
           No check is made to ensure that the jurisdiction sections are
           unique. This is sometimes a useful feature but can also cause
           unexpected behaviour. It is probably best for all but the most
           advanced administrators to make sure that the same
           JURISDICTION_NAME directive doesn't appear in multiple Jurisdiction
           sections and that each section has a different effective
           jurisdictional URI.

       If your particular requirement has been covered, it is probably safe to
       skip the detail that follows.

       [1mThe Effective Jurisdictional URI[0m
           A Jurisdiction element must have either a uri attribute or a
           uri_expr attribute, but not both. If the latter is given, it
           specifies an [34m[1mexpression[0m[1m[22m[20] that is evaluated at configuration
           processing time. The effective jurisdictional URI (or the
           jurisdiction's effective URI) is either the value of the uri
           attribute or the value obtained by evaluating the uri_expr
           attribute. The effective jurisdictional URI can be matched against
           a request's URI or the [1m-u [22mflag's [4mconfig-uri[24m to find the applicable
           Jurisdiction section.

           The standard set of [34m[1mconfiguration variables[0m[1m[22m[21] in the [4mConf[24m and [4mEnv[0m
           [34m[1mnamespace[0m[1m[22m[14] (but no others) are accessible during evaluation of
           uri_expr. Consider this partial configuration:

               <Jurisdiction uri_expr="${Env::SERVER_NAME}">

           Here, the effective jurisdictional URI is the value of the
           [1mSERVER_NAME [22menvironment variable.

               [1mNote[0m
               +o   The environment established for a [1mDACS [22mweb service and the
                   environment of a [1mDACS [22mcommand are typically different, so
                   programs run from the command line may fail if uri_expr
                   references an undefined variable.

               +o   Any error that occurs during evaluation of uri_expr is
                   fatal.

               +o   One application of the uri_expr attribute is constructing a
                   generic or "template" Jurisdiction section. For example, if
                   multiple domain names need to map to the same jurisdiction,
                   a uri_expr like the following can be used:

                       <Jurisdiction uri_expr="regmatch(${Env::SERVER_NAME}, '(foo.example.com)|(baz.example.com)')">



       The effective jurisdictional URI has the following syntax:

           uri         -> [scheme-spec] [domain-spec] [":" port-spec] [path-spec]
           scheme-spec -> "http://" | "https://"
           domain-spec -> domain-name | "*." domain-name | IP-address
           port-spec   -> positive-integer | positive-integer "," port-spec
           path-spec   -> "/" path-segment | "/" path-segment path-spec


       [1mJurisdiction Selection by URI[0m
           Whether the Jurisdiction section is selected based on the [1m-u [22mflag's
           explicit [4mconfig-uri[24m or the request URI provided to [1mDACS [22mthrough
           environment variables, the effective jurisdictional URIs are
           matched against the provided URI.

           An effective jurisdictional URI has the following semantics for
           matching against the provided URI:

           +o   If uri specifies the http scheme, the provided UR must not have
               used SSL; if uri specifies the https scheme, the provided URI
               must have used SSL; if neither scheme is specified, the scheme
               is immaterial.

           +o   The optional [4mdomain-spec[24m specifies a domain name to match
               (case-insensitively) against the provided URI. If the initial
               component of [4mdomain-spec[24m is "*.", then only the components that
               follow it in [4mdomain-spec[24m need to match the domain name in the
               provided URI. For example, *.example.com matches example.com
               and foo.baz.example.com. If the [4mdomain-spec[24m is omitted, the
               domain name in the provided URI is immaterial.

                   [1mNote[0m
                   The matching algorithm does not consider domain names that
                   map to the same IP address (i.e., aliases) to be
                   equivalent.

               The [4mdomain-spec[24m can be an IP address, but in this case the
               provided URI must also use an IP address for the two to match.
               That is, no mapping between IP addresses and domain names is
               performed.

           +o   The optional [4mport-spec[24m consists of one or more port numbers,
               any one of which must match the one specified [4mexplicitly[24m (i.e.,
               not by default) in the provided URI. If the provided URI does
               not contain a port, it will not match any [4mport-spec[24m. Port
               numbers are separated by a comma (with no embedded whitespace).
               If the [4mport-spec[24m is omitted, the port number in the provided
               URI is immaterial.

           +o   The optional [4mpath-spec[24m must match the prefix of the provided
               URI's path component. Matching is case-sensitive and is
               performed on corresponding [4mpath-segment[24m elements.


       The matching algorithm first rejects any Jurisdiction section having an
       effective jurisdictional URI that does not satisfy the [4mscheme-spec[24m or
       the [4mdomain-spec[24m. It looks for the section that contains a matching
       [4mport-spec[24m and that has the longest matching [4mpath-spec[24m; the first such
       section will be selected. If no such section is found, however, it
       looks for the section that does not contain a [4mport-spec[24m and that has
       the longest matching [4mpath-spec[24m; the first such section will be
       selected. It is a fatal error if no section can be selected.

           [1mTip[0m
           While configuration of the uri attribute may appear to be complex,
           its value will typically be a simple hostname, or a simple hostname
           followed by a jurisdiction-distinguishing initial path element, as
           in the example above. The flexible syntax allows jurisdictions to
           be associated with requests based on port numbers, use of SSL, etc.
           and lets dissimilar requests map to the same jurisdiction.

       For example, given the [34m[1mexample configuration[0m[1m[22m[22] above, if the request
       URL is:

           https://dss.example.com/foo/cgi-bin/dacs_authenticate

       then the second Jurisdiction section will be used.

       If the request URL is:

           https://dss.example.com/cgi-bin/dacs_authenticate

       then the first Jurisdiction section will be used.

       If a [1mDACS [22mutility is invoked with the command line flag [1m-u[0m
       metalogic.example.com, the third Jurisdiction section will be used.

       [1mJurisdiction Selection by Jurisdiction Name[0m
           The applicable Jurisdiction section can be selected by providing
           the jurisdiction's name. The [1m-uj [22mflag's [4mjurisdiction-name[24m argument
           is compared against the [4munevaluated[24m value of each section's
           JURISDICTION_NAME directive until the first exact string match is
           found; the section containing the directive will be selected.

               [1mNote[0m
               Because the unevaluated value of the directive is used, if the
               value of a JURISDICTION_NAME is not a simple string, this
               option will not work unless [4mjurisdiction-name[24m is that
               expression, not its value. Appropriate quotes are implied
               around [4mjurisdiction-name[24m, so they should be omitted on the
               command line.

               For example, given the (partial) configuration file entry:

                   <Jurisdiction uri="demo.example.com">
                   JURISDICTION_NAME "DEMO"
                   ...
                   </Jurisdiction>


               the command line argument "[1m-uj [22mDEMO" would select that
               jurisdiction section. If instead JURISDICTION_NAME were an
               expression that [4mevaluated[24m to the string DEMO, the argument
               would not select that jurisdiction section.

       [1mJurisdiction Selection by Default[0m
           If dacs.conf contains a single Jurisdiction section, the [1m-us [22mflag
           can be used to select it without regard to the jurisdiction's name
           or effective jurisdictional URI. This can be particularly useful
           during testing.

           Should there be more than one Jurisdiction section when this flag
           is used, a fatal error will occur.

       [1mThe Distinguishing URI[0m
           Regardless of how the Jurisdiction section is selected, that
           section's effective jurisdictional URI is matched against the [1m-u[0m
           flag's [4mconfig-uri[24m, if given, or the request URI according to the
           method described for [34m[1mJurisdiction Selection by URI[0m[1m[22m[23]. The
           resulting string is called the distinguishing URI. This string is
           another way of identifying the selected Jurisdiction section and
           can be used for [34m[1mstring interpolation[0m[1m[22m[24]. It is also related to the
           shared attribute used in [34m[1maccess control rules[0m[1m[22m[25].

           For example, if the request URI is http://foo.example.com/a/b/c and
           the matching effective jurisdictional URI is *.example.com/a/b,
           then the distinguishing URI is foo.example.com/a/b.

   [1mDirectives[0m
       Each directive consists of a directive name, followed by whitespace
       (spaces and/or tabs), followed by its value. Directive names are
       case-sensitive and comprised of printable characters, except the space
       character, and are upper case.

       A directive value is an expression or sequence of expressions
       ([34m[1mdacs.exprs(5)[0m[1m[22m[20]) that is evaluated at run time during configuration
       processing. Here are some directives that are equivalent (on a
       Saturday):

           AUTH_FAIL_DELAY_SECS 2
           AUTH_FAIL_DELAY_SECS "2"
           AUTH_FAIL_DELAY_SECS 1 + 1
           AUTH_FAIL_DELAY_SECS strftime("%a") eq:i "Sat" ? 2 : 17

       Blank lines, leading white space, and lines whose first non-white space
       character is a # character (i.e., comments) are ignored.

       Any directive line may be split over physical lines by escaping the
       newline character, for example:

           ACS_ERROR_HANDLER "902 'Access denied, \
           user not authenticated'"

       An unrecognized directive name is a fatal error, as is an error
       encountered during expression evaluation.

       [1mEvaluated Directives[0m
           Some directive names end with a * character. By convention, this
           means that the directive's value will be evaluated a second time,
           in the context of a particular module or service request, but only
           if the directive value is actually needed. This allows a
           configuration directive to reference a variable that cannot be
           instantiated until normal configuration file processing has been
           performed, for instance. The values of these directives usually
           appear within single quotes so that they initially evaluate to the
           string between the quotes.

           Consider this [34m[1mINIT*[0m[1m[22m[26] directive, which might appear within an
           [34m[1mAuth clause[0m[1m[22m[27]:


                 INIT* '${Auth::CURRENT_USERNAME} = "goa\\" . ${Auth::CURRENT_USERNAME}'

           Because the directive's value appears within single quotes, the
           quoted expression is not evaluated during the first scan of the
           directive (or more accurately, it evaluates to an unquoted
           expression); this is as it should be because the value of the
           referenced variable is not known at that time, nor has it been
           determined whether the directive will even be needed. Later, if the
           Auth clause containing this directive is used, the variable's value
           is presumably known and the formerly quoted expression is
           evaluated, yielding a final value for the directive.

       [1mDirective Categories[0m
           After [34m[1msection merging[0m[1m[22m[28] is performed, some directives must be
           specified while others are optional. Some may appear at most once
           and others may be repeated. The following labels are used to
           categorize directives:

           Required1:
               Directives of this category must be defined and must appear
               only once after merging.

           Required1-C:
               Under certain conditions, these directives must be defined and
               appear only once after merging, otherwise they need not appear.
               For example, some directives are required if and only if the
               module that requires them is configured.

           Required:
               These directives must always be specified at least once after
               merging, and may be repeated.

           Optional1:
               These directives may appear at most once after merging.

           Optional:
               These directives may appear zero or more times after merging.

           Stack:
               This is like the Optional type, in that the directive may
               appear multiple times in any section, except the usual section
               merging algorithm is not used. Instead, all occurrences of the
               directive in the Jurisdiction section, then in the Default
               section of dacs.conf, and then in site.conf will be "stacked",
               in the order in which they appear in each section. Selection is
               dependent on the particular directive, which will effectively
               search the directives in the Jurisdiction section first to find
               an applicable directive, then search the directives in the
               Default section of dacs.conf if necessary, and finally search
               site.conf if necessary.

               [1mNote[0m
               A directive marked Deprecated will be removed in a future
               version and should not be used.

           Some directives have more complicated constraints on their usage;
           they might be allowed only in certain contexts or are required only
           in certain situations (e.g., directives associated with proxied
           operation are only required if that mode of operation is being
           used).

           Required directives must be present and assigned a valid value,
           although the validity of a value is only checked if the directive
           is actually used. It is okay to define directives that are not
           used; for example, directives related to InfoCards may appear in a
           configuration file even if InfoCard support is not enabled at the
           time [1mDACS [22mis built. Some configuration directives may appear
           multiple times, others only once. The order in which configuration
           directives appear within a section is not usually significant,
           although it may be in cases where the directive is repeated (e.g.,
           ACS_ERROR_HANDLER) and for clauses (e.g., the Auth clause).

               [1mNote[0m
               Directives that expect to be assigned a value of yes, no, on,
               or off recognize these keywords case-insensitively.

       [1mGeneral Directives[0m
           The following general directives are provided. If present, they
           must appear within any Default section or Jurisdiction section, but
           outside of any clauses.

           [1mDirective Index:[0m

            1. ACCEPT_ALIEN_CREDENTIALS (Optional1)

            2. ACS_ACCESS_TOKEN_ENABLE (Optional1)

            3. ACS_ACCESS_TOKEN_LIFETIME_LIMIT (Required1-C)

            4. ACS_ACCESS_TOKEN_LIFETIME_SECS (Required1-C)

            5. ACS_AUTHENTICATED_ONLY (Optional1)

            6. ACS_CREDENTIALS_LIMIT (Optional1)

            7. ACS_EMIT_APPROVAL (Optional1)

            8. ACS_ERROR_HANDLER (Stack)

            9. ACS_FAIL (Optional1)

           10. ACS_INACTIVITY_LIMIT_SECS (Optional1)

           11. ACS_POST_BUFFER_LIMIT (Optional1)

           12. ACS_POST_EXCEPTION_MODE (Optional1)

           13. ACS_PRE_AUTH (Optional)

           14. ACS_SUCCESS (Optional)

           15. ACS_TRACK_ACTIVITY (Optional1)

           16. ADMIN_IDENTITY (Optional)

           17. ALLOW_HTTP_COOKIE (Optional1)

           18. AUTH_AGENT_ALLOW_ADMIN_IDENTITY (Optional1)

           19. AUTH_CREDENTIALS_ADMIN_LIFETIME_SECS (Optional1)

           20. AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS (Required1)

           21. AUTH_ERROR_HANDLER (Stack)

           22. AUTH_FAIL (Optional1)

           23. AUTH_FAIL_DELAY_SECS (Optional1)

           24. AUTH_SINGLE_COOKIE (Optional1)

           25. AUTH_SUCCESS (Optional)

           26. AUTH_SUCCESS_HANDLER (Optional1)

           27. AUTH_TRANSFER_EXPORT (Optional)

           28. AUTH_TRANSFER_TOKEN_LIFETIME_SECS (Optional1)

           29. COMPAT_MODE (Optional1)

           30. COOKIE_HTTPONLY (Optional1)

           31. COOKIE_NO_DOMAIN (Optional1)

           32. COOKIE_PATH (Optional1)

           33. CSS_PATH (Optional1)

           34. DTD_BASE_URL (Optional1)

           35. EVAL (Optional)

           36. FEDERATION_DOMAIN (Required1)

           37. FEDERATION_NAME (Required1)

           38. HTTP_AUTH (Stack)

           39. HTTP_AUTH_ENABLE (Optional1)

           40. HTTP_PROG (Required1)

           41. INFOCARD_AUDIENCE (Optional)

           42. INFOCARD_AUDIENCE_RESTRICTION (Optional)

           43. INFOCARD_CARD_DEFS_URL (Optional1)

           44. INFOCARD_CARD_FILL_URL (Optional1)

           45. INFOCARD_CARD_IMAGE_BASE_URL (Required1-C)

           46. INFOCARD_CARD_LIFETIME_SECS (Optional1)

           47. INFOCARD_CARD_OUTPUTDIR (Optional1)

           48. INFOCARD_CARD_VERSION (Optional1)

           49. INFOCARD_CARDID_BASE_URL (Required1-C)

           50. INFOCARD_CARDID_SUFFIX (Optional1)

           51. INFOCARD_CARD_DATETIME_EXPIRES (Optional1)

           52. INFOCARD_DIGEST (Optional1)

           53. INFOCARD_IP_PRIVACY_URL (Required1-C)

           54. INFOCARD_IP_PRIVACY_VERSION (Optional1)

           55. INFOCARD_ISSUER_INFO_ENTRY (Optional)

           56. INFOCARD_MEX_URL (Required1-C)

           57. INFOCARD_REQUIRE_APPLIES_TO (Optional1)

           58. INFOCARD_STRONG_RP_IDENTITY (Optional1)

           59. INFOCARD_STS_AUTH_TYPE (Required1-C)

           60. INFOCARD_STS_CACERTFILE (Required1-C)

           61. INFOCARD_STS_CERTFILE (Required1-C)

           62. INFOCARD_STS_KEYFILE (Required1-C)

           63. INFOCARD_STS_KEYFILE_PASSWORD (Required1-C)

           64. INFOCARD_STS_PASSWORD_METHOD (Required1-C)

           65. INFOCARD_STS_RP_ENDPOINT (Optional)

           66. INFOCARD_TOKEN_DRIFT_SECS (Optional1)

           67. INFOCARD_TOKEN_ISSUER (Required1-C)

           68. INFOCARD_TOKEN_LIFETIME_SECS (Optional1)

           69. INFOCARD_TOKEN_MAX_LENGTH (Optional1)

           70. INFOCARD_USERNAME_SELECTOR (Optional1)

           71. JURISDICTION_NAME (Required1)

           72. LOGINGEN_FILE (Optional1)

           73. LOGINGEN_PROG (Optional1)

           74. LOG_FILE (Optional1)

           75. LOG_FILTER (Stack)

           76. LOG_FORMAT (Optional1)

           77. LOG_LEVEL (Optional1)

           78. LOG_SENSITIVE (Optional1)

           79. NAME_COMPARE (Optional1)

           80. NOTICES_ACCEPT_HANDLER (Optional1)

           81. NOTICES_ACK_HANDLER (Optional1)

           82. NOTICES_DECLINE_HANDLER (Optional1)

           83. NOTICES_NAT_NAME_PREFIX (Optional1)

           84. NOTICES_SECURE_HANDLER (Optional1)

           85. NOTICES_WORKFLOW_LIFETIME_SECS (Optional1)

           86. PAMD_HOST (Optional1)

           87. PAMD_PORT (Optional1)

           88. PASSWORD_CONSTRAINTS (Optional1)

           89. PASSWORD_DIGEST (Optional1)

           90. PASSWORD_OPS_NEED_PASSWORD (Optional1)

           91. PASSWORD_SALT_PREFIX (Optional1)

           92. PERMIT_CHAINING (Optional1)

           93. PROXY_EXEC_DOCUMENT_ROOT (Optional1)

           94. PROXY_EXEC_MAPPER_DEFAULT_ACTION (Optional1)

           95. PROXY_EXEC_MAPPER_LOGGING (Optional1)

           96. PROXY_EXEC_MAPPER_LOG_FILE (Optional1)

           97. PROXY_EXEC_MAPPER_RULES_FILE (Optional1)

           98. PROXY_EXEC_PROG_URI (Optional1)

           99. RLINK (Optional)

           100. ROLE_STRING_MAX_LENGTH (Optional1)

           101. SECURE_MODE (Optional1)

           102. SIGNOUT_HANDLER (Optional1)

           103. SSL_PROG (Optional1)

           104. SSL_PROG_ARGS (Optional1)

           105. SSL_PROG_CA_CRT (Optional1)

           106. SSL_PROG_CLIENT_CRT (Optional1)

           107. STATUS_LINE (Optional1)

           108. TEMP_DIRECTORY (Optional1)

           109. TOKEN_REQUIRES_PIN (Optional1)

           110. TOKEN_HOTP_ACCEPT_WINDOW (Optional1)

           111. TRACE_LEVEL (Optional1)

           112. UNAUTH_ROLES (Optional1)

           113. UPROXY_APPROVED (Stack)

           114. VERBOSE_LEVEL (Optional1)

           115. VERIFY_IP (Required1)

           116. VERIFY_UA (Optional1)

           117. VFS (Stack)

           118. XSD_BASE_URL (Optional1)

           ACCEPT_ALIEN_CREDENTIALS (Optional1)
               If "yes", [1mDACS [22mwill honour credentials imported (by any means)
               from a different federation. As a security precaution, such
               credentials are not used by default.

                   [1mSecurity[0m
                   In federations where [34m[1mdacs_auth_transfer(8)[0m[1m[22m[29] is used,
                   jurisdictions will likely enable this capability.

           ACS_ACCESS_TOKEN_ENABLE (Optional1)
               If "yes", [1mACS[22m's access token mechanism will be enabled. By
               default, this feature is disabled. Please see [34m[1mAuthorization[0m
               [1m[34mCaching[0m[1m[22m[30] for details.

           ACS_ACCESS_TOKEN_LIFETIME_LIMIT (Required1-C)
               If [1mACS[22m's access token mechanism has been enabled, this is the
               number of times that an access token may be used. It must be an
               integer greater than zero. There is no default value. This
               value, ACS_ACCESS_TOKEN_LIFETIME_SECS, or both must be
               configured properly if the mechanism is enabled. Because it
               requires updating a database entry, this method of enforcing a
               limit on the lifetime of an access token is inherently less
               efficient than using ACS_ACCESS_TOKEN_LIFETIME_SECS. Changes to
               this limit do not affect access tokens that have already been
               issued. Please see [34m[1mAuthorization Caching[0m[1m[22m[30] for details.

           ACS_ACCESS_TOKEN_LIFETIME_SECS (Required1-C)
               If [1mACS[22m's access token mechanism has been enabled, this is the
               lifetime in seconds of an access token, and must be an integer
               greater than zero. There is no default value. This value,
               ACS_ACCESS_TOKEN_LIFETIME_LIMIT, or both must be configured
               properly if the mechanism is enabled. Please see [34m[1mAuthorization[0m
               [1m[34mCaching[0m[1m[22m[30] for details.

           ACS_AUTHENTICATED_ONLY (Optional1)
               If "yes", [1mACS [22mwill deny all requests that are not accompanied
               by valid credentials, regardless of any access control rules or
               other directives.

                   [1mNote[0m
                   Since this restriction also applies to [1mDACS [22mservices, if
                   this mode is enabled an unauthenticated user will not be
                   able to access [1mDACS [22mservices by which he might authenticate
                   himself. Users must therefore have authenticated before
                   this directive is enabled, authenticate using an off-line
                   method (such as [34m[1mdacscookie(1)[0m[1m[22m[31] or [34m[1mdacsauth(1)[0m[1m[22m[32]), or
                   authenticate at some other jurisdiction.

           ACS_CREDENTIALS_LIMIT (Optional1)
               The value of this directive is either an unsigned integer
               greater than zero, or the keyword "none" (case insensitive). In
               the former case, if a request is submitted with more than this
               number of valid credentials, the request will be denied with
               the REVOKED error (equivalent to error code [1m903[22m).

               Probably the most common application of this directive is to
               limit each request to being associated with at most one
               identity. The standard site configuration sets
               ACS_CREDENTIALS_LIMIT to one. This eliminates confusion about
               which identity invoked a web service (i.e., which identity
               [1mREMOTE_USER [22mshould be set to, for instance) and ambiguity
               regarding the semantics of rules, and in some cases may
               simplify access control rules and log file audits.

               A user denied access at a jurisdiction due to this directive
               will be denied access to [34m[1mdacs_signout(8)[0m[1m[22m[33] at the
               jurisdiction. To regain access to the jurisdiction, the user
               will either need to signout from a different jurisdiction or
               delete one or more sets of credentials (cookies) from his
               browser, either using the browser's cookie manager or by
               terminating the browser session.

                   [1mNote[0m
                   It is possible for a user that is not denied access at a
                   jurisdiction due to this directive to successfully
                   authenticate, after which he will have "too many"
                   credentials and subsequently be denied access. Similarly, a
                   [1mDACS [22madministrator may reduce the limit at any time,
                   potentially causing access to be denied to users holding a
                   number of credentials in excess of the limit.

                   [1mSecurity[0m
                   This directive only limits the number of credentials
                   associated with a single request. It does not prevent the
                   same individual from sending different requests, from the
                   same browser or different browsers, each associated with a
                   different identity. Also, it does not limit the number of
                   concurrent logins of the same identity (such as by
                   different individuals sharing the same account).


                   [1mDACS [22mdoes not limit a user's number of concurrent logins or
                   the number of concurrent logins of the same identity
                   because of the inherent drawbacks of a general
                   implementation of such a feature. In simple cases, however,
                   an administrator may be able to add a custom solution to
                   [1mDACS[22m.

           ACS_EMIT_APPROVAL (Optional1)
               If "yes", [1mDACS [22mwill generate a [1mDACS_APPROVAL [22menvironment
               variable that can be inspected by an invoked program to verify
               that its use in the current context was authorized by [1mDACS[22m.
               Before this feature is enabled, additional configuration is
               necessary; see [34m[1mThe DACS_APPROVAL environment variable[0m[1m[22m[34] for
               details.

           ACS_ERROR_HANDLER (Stack)
               If [1mDACS [22mdenies a service request, the web server's [1mDACS [22mmodule
               will be so informed and will return a [1m403 [22m("Forbidden") status
               code to the web server. By using [1mApache's [22mErrorDocument
               directive, the resulting action taken by [1mApache [22mcan be
               customized.

               In some situations following denial of a request, however, it
               is desirable to initiate an action that depends on the reason
               for denial. For example, if access is denied because the user
               is not authenticated, the [1mDACS [22madministrator might want users
               to be redirected to a login page; if access is denied because
               an access control rule denies access although the user is
               authenticated, the administrator might want users to be
               redirected to a page that displays a custom error message. It
               is sometimes useful for the action to depend on the resource
               being requested.

               The ACS_ERROR_HANDLER directive defines (or overrides) [1mApache[22m's
               behaviour with respect to an ErrorDocument directive for [1m403[0m
               errors if [1mDACS [22mdenies a service request. The syntax and meaning
               of this directive are similar to that of [1mApache[22m's ErrorDocument
               directive. Please refer to the [1mApache [22mdocumentation for a
               [34m[1mdescription of the ErrorDocument directive[0m[1m[22m[35].

               Also refer to the description of the [34m[1mredirect()[0m[1m[22m[36] function.

               The syntax of the directive is:

                   [[4murl_pattern[24m] [4merror-code[24m [[4mhandler-type[24m] [[4merror-action[24m]

               The optional [4murl_pattern[24m is a URI path component that is
               matched against the request for which access was denied. It
               must begin with a '/'. It is like the [4murl_pattern[24m used in
               [34m[1maccess control rules[0m[1m[22m[37] in that it can require an exact match
               or end in "/*"; no query argument component is allowed. If it
               is absent, the [4murl_pattern[24m defaults to "/*", which matches any
               path.

               The [4merror-code[24m is either a numeric error code, an equivalent
               case-insensitive [4merror-name[24m, or the special symbol "*", which
               means the directive applies to any [1mDACS [22merror code for which
               there is no explicit directive.

               The following [4merror-name[24m and [4merror-code[24m values are defined:

               NO_RULE ([1m900[22m)
               Access denied, no applicable rule
                   All rules were examined but no rule applies to the service
                   request.

               BY_RULE ([1m901[22m)
               Access denied, forbidden by rule
                   The closest matching rule does not grant the service
                   request.

               NO_AUTH ([1m902[22m)
               Access denied, user not authenticated
                   No valid credentials were provided and either a) no rule
                   applies or b) the rule does not grant the service request.

               REVOKED ([1m903[22m)
               Access denied, user access revoked
                   Credentials were explicitly revoked.

               BY_REDIRECT ([1m904[22m)
               Access denied, redirect
                   A rule has explicitly redirected the user.

               ACK_NEEDED ([1m905[22m)
               Access denied, acknowledgement needed
                   One or more notices associated with the request must be
                   acknowledged.

               LOW_AUTH ([1m906[22m)
               Access denied, low authentication level
                   Although valid credentials were provided, they were
                   obtained by an authentication method not strong enough for
                   the requested resource.

               BY_SIMPLE_REDIRECT ([1m907[22m)
               Access denied, simple redirect
                   A rule has explicitly redirected the user; do not append
                   [1mDACS [22mquery arguments.

               CREDENTIALS_LIMIT ([1m908[22m)
               Access denied, too many credentials were submitted
                   Too many selected credentials accompanied the request.

               INACTIVITY ([1m909[22m)
               Access denied, inactivity timeout
                   No authenticated requests were made within a designated
                   time interval.

               UNKNOWN ([1m998[22m)
               Access denied, reason unknown
                   An error occurred during processing but no additional
                   information is available.

               DEFAULT (*)
               Control symbol
                   Not an error name, but a keyword used with
                   ACS_ERROR_HANDLER to configure a handler to invoke if no
                   handler is explicitly configured for the event.

               No blanks may precede the code, any number of blanks may follow
               it. The descriptive-text consists only of printable characters
               (e.g., no tabs or newlines) and may not contain a colon. The
               descriptive-text is subject to change, but the meaning of the
               code number is fixed. When [1mDACS [22mreturns a numeric error code, a
               program only needs to examine the three digit code to determine
               why access was denied. Optionally, the standard text may be
               followed by a single space, a colon, at least one space, and a
               more detailed error message.

               If a [4mhandler-type[24m keyword appears, it selects the action the
               handler should take and disables the heuristics that would
               otherwise be used to decide the type based on the syntax of the
               [4merror-action[24m. The reason and default keywords are the only
               [4mhandler-type[24m keyword that are not followed by an [4merror-action[24m.

               The following [4mhandler-type[24m keywords and [4merror-action[24m arguments
               are recognized:

                1. reason

                   [1mDACS [22mwill cause [1mApache [22mto display the [1mDACS [22merror code that
                   identifies the reason for denying access followed by the
                   corresponding textual message.  [1mApache [22mmight display
                   messages like the following:

                       900 Access denied, no applicable access control rule
                       998 Access denied, internal error: Cookie parse error


                2. default

                   This form instructs [1mDACS [22mnot to alter [1mApache's [22mbehaviour
                   (as if there was no ACS_ERROR_HANDLER specified at all).

                3. [url] [4mURL[0m

                   This form will cause [1mApache [22mto redirect the client to [4mURL[0m
                   using the GET method. If the url keyword is absent, [4mURL[0m
                   must begin with the four characters "http". An invalid [4mURL[0m
                   may be rejected by Apache and treated as a message. The [4mURL[0m
                   may contain a properly escaped query string; [1mDACS [22mwill
                   append the following parameters, in the order given, to [4mURL[0m
                   (unless the error name is BY_SIMPLE_REDIRECT, in which case
                   none of these parameters is passed):

                    1. [4mDACS_ERROR_CODE[24m, the [1mDACS [22merror code.

                    2. [4mDACS_VERSION[24m, the version number of [1mDACS [22m(e.g., "1.4").

                    3. [4mDACS_FEDERATION[24m, the federation that received the
                       service request, if available.

                    4. [4mDACS_JURISDICTION[24m, the jurisdiction that received the
                       service request, if available.

                    5. [4mDACS_HOSTNAME[24m, the domain name of the host that
                       received the service request, if available.

                    6. [4mDACS_USER_AGENT[24m, if provided by the user agent, this is
                       an identifying string, such as:

                           Mozilla/3.01 (X11; U; Linux 2.4.2 i386)


                    7. [4mDACS_REQUEST_METHOD[24m, the method used to invoke the
                       service request, if available. For example, "GET" or
                       "POST".

                    8. [4mDACS_ERROR_URL[24m, the service request URL, including any
                       query string component. The values of these parameters
                       are URL encoded.

                4. [localurl] /[4mlocal-URL[0m

                   This form is similar to the absolute URL form except that
                   redirection is to a local URL-path. The [4merror-action[24m must
                   begin with a slash. The URL may contain a properly escaped
                   query string; [1mDACS [22mwill append additional parameters as in
                   the absolute URL form.

                5. [message] \"[4ma[24m [4mmessage[24m\"

                   This form causes [1mApache [22mto emit the given string as the
                   error document. If the message keyword is absent, the
                   string must be surrounded by double quote characters (the
                   quotes do not appear in the final output message).

                       [1mNote[0m
                       Apache always sets the Content-Type for this message to
                       text/html. Although reported quite some time ago, [34m[1mBug[0m
                       [1m[34m3641[0m[1m[22m[38] is still open. There may be a bug in Apache
                       2.X that prevents the initial double quote in the
                       message from being stripped; see [34m[1mBug 42430[0m[1m[22m[39].

                6. expr [4mexpression[0m

                   The expr keyword, which cannot be omitted, indicates that
                   the [4merror-action[24m is an expression. The [4mexpression[24m is
                   evaluated and its value (a string) is used as the Apache
                   error response. If an error occurs during evaluation, the
                   Apache ErrorDocument or default behaviour will be used.

                   This directive may appear multiple times. Because these
                   directives are stacked, during handler processing
                   directives are examined "backwards", starting from the last
                   one that appears in the relevant jurisdiction section
                   through to the first one that appears in the default
                   section of dacs.conf and backwards through site.conf. The
                   first directive having a [4murl_pattern[24m [4mand[24m [4merror-code[24m that
                   match the error condition exactly is used. Otherwise, if no
                   such exact match if found, the first directive encountered
                   having the closest [4murl_pattern[24m match and exact [4merror-code[0m
                   match is used; failing that, the first directive with the
                   closest [4murl_pattern[24m match and default ("*") [4merror-code[0m
                   match is used.

                   Consider these example directives:

                       ACS_ERROR_HANDLER "* reason"
                       ACS_ERROR_HANDLER '903 "Your access has been revoked"'
                       ACS_ERROR_HANDLER "/foo/* * /cgi-bin/dacs/foohandler"
                       ACS_ERROR_HANDLER "/foo/foo.html NO_AUTH /cgi-bin/foo-login.cgi"

                   A request for /foo/foo.html that is denied because the user
                   is not authenticated will cause a redirect to
                   /cgi-bin/foo-login.cgi. If the request is denied for a
                   different reason, the third directive will be used, causing
                   a redirect to /cgi-bin/dacs/foohandler. A request for
                   something not located under /foo that is denied because
                   access is revoked will cause the message specified in the
                   second directive to be displayed to the user, while any
                   other type of error will cause an appropriate explanatory
                   message to be displayed.

                   Here is an example of the expr handler form:

                       ACS_ERROR_HANDLER "* expr '\"&lt;em>Today is&lt;/em> \" . strftime(\"%D\")'"

                   If triggered, this directive will emit a message similar to
                   the following as Apache's custom error response:

                       <em>Today is</em> 05/16/07

                   As with all such messages, Apache forces the Content-Type
                   to be text/html.

                   These two directives are equivalent:

                       ACS_ERROR_HANDLER "* message 'Hello world.'"
                       ACS_ERROR_HANDLER "* \"Hello world.\""

                   The error response returned by Apache will be:

                       Hello world.

                   Any invalid directive will result in [1mApache [22mfollowing its
                   configured behaviour. A directive with a syntactically
                   valid but undefined [4merror-code[24m is ignored, however.

                   In the case where the service request was issued by
                   [1mInternet Explorer[22m, if the length of the error response by
                   the server isn't greater than some magic value and [1mIE[22m's
                   "Show friendly HTTP error messages" is enabled, which it is
                   by default, then [1mIE [22mwill ignore the custom message. When
                   the "message" and "reason" handler types are used, [1mDACS[0m
                   adds some padding to thwart [1mIE[22m's "cleverness". For other
                   handler types, the administrator is responsible for working
                   around this problem.

                       [1mNote[0m
                       Care must be taken to avoid improper operation (such as
                       a potentially infinite regress) if a CGI program
                       invoked to handle an error is itself protected by [1mDACS[22m.
                       One example is the situation where a user's access has
                       been revoked and is therefore unable to access any
                       [1mDACS[22m-protected resource. If an error occurs while [1mDACS[0m
                       is processing a request for a handler, [1mDACS [22mwill fall
                       back to [1mApache[22m's default behaviour, ignoring any
                       normally applicable ACS_ERROR_HANDLER directives.

               ACS_FAIL (Optional1)
                   If [1mdacs_acs [22mdenies access, the given expression is
                   evaluated just before the [34m[1mACS_ERROR_HANDLER[0m[1m[22m[18] directive,
                   if any, is processed. This directive provides a hook for
                   post-authorization actions to be performed. The namespaces
                   in effect during authorization processing are accessible to
                   the expression. The value of the expression is discarded
                   and any errors are ignored.

               ACS_INACTIVITY_LIMIT_SECS (Optional1)
                   This directive enables inactivity detection if it is set to
                   a non-zero unsigned integer. Inactivity detection is
                   applicable only when valid selected credentials accompany a
                   request (i.e., at least one identity is associated with the
                   request - see [34m[1mdacs_select_credentials(8)[0m[1m[22m[40]).

                   There are two cases. If an activity tracking cookie is not
                   sent with the current request (see [34m[1mACS_TRACK_ACTIVITY[0m[1m[22m[41]),
                   the user is deemed to be inactive if the newest credentials
                   are older than ACS_INACTIVITY_LIMIT_SECS seconds. If an
                   activity tracking cookie is received, the user is deemed to
                   be inactive if the date/time that it asserts is older than
                   ACS_INACTIVITY_LIMIT_SECS seconds. If inactivity is
                   detected by [34m[1mdacs_acs(8)[0m[1m[22m[6], access is denied and an
                   INACTIVITY error ([1m909[22m) is raised; see
                   [34m[1mACS_ERROR_HANDLER[0m[1m[22m[18]. At present, the only way for a user
                   to continue after an inactivity error is to explicitly
                   delete [1mDACS [22mcookies or implicitly delete them by restarting
                   the browser. A non-[1mDACS[22m-wrapped web page or CGI program
                   might be invoked as an error handler to assist.

                   Different jurisdictions may independently configure
                   different inactivity thresholds, disable inactivity
                   detection, or disable activity tracking - the degree to
                   which this feature improves security or is annoying to
                   users depends on thoughtful cooperation amongst
                   jurisdictions and adequate clock synchronization.

               ACS_POST_BUFFER_LIMIT (Optional1)
                   This is the counterpart to the [34m[1mSetDACSAuthPostBuffer[0m[1m[22m[42]
                   directive of [1mDACS's [34mmod_auth_dacs[0m[1m[22m[7] [1mApache [22mmodule. It
                   establishes the maximum number of bytes of environment and
                   POST stream that [1mDACS [22mshould read from [34m[1mmod_auth_dacs[0m[1m[22m[7],
                   overriding the compile-time default. To allow for encoding
                   overhead when serializing the message body,
                   ACS_POST_BUFFER_LIMIT should be at least 50% larger than
                   the SetDACSAuthPostBuffer size. A value of zero imposes no
                   limit. (Ideally, only one of these values would need to be
                   configured but you must currently ensure that both of them
                   are set to reasonable values.)

               ACS_POST_EXCEPTION_MODE (Optional1)
                   In the event that the web server has not made all of the
                   request's arguments available to [1mDACS [22mfor access control
                   processing (see [34m[1mSERVICE_ARGS_TRUNCATED[0m[1m[22m[43]), this directive
                   tells [34m[1mdacs_acs(8)[0m[1m[22m[6] what to do. The following keywords are
                   recognized values:

                   abort
                       Access control processing stops and access is denied.

                   default
                       This is equivalent to discard.

                   discard
                       Processing continues, but all web service arguments are
                       ignored and none will be available to access control
                       rules.

                   proceed
                       Continue processing, even though one or more arguments
                       may be corrupted or missing. This may result in a
                       segmentation fault or other unrecoverable error.

                   query
                       Continue processing, discarding all POST arguments but
                       including any arguments that were passed in the request
                       URI's query component.


               ACS_PRE_AUTH (Optional)
                   Similar to the pre-authorization authentication feature
                   configured through the [34m[1mHTTP_AUTH[0m[1m[22m[44] directive, this
                   directive provides a way to authenticate - or identify - a
                   user at access control time. Rather than involving HTTP
                   Basic or Digest authentication, however, the value of the
                   directive is an expression that is evaluated. If the result
                   is a [34m[1msyntactically valid username[0m[1m[22m[45], credentials are
                   created that (normally) exist only for the duration of the
                   authorization check and which are associated with the
                   [34m[1mcurrent jurisdiction[0m[1m[22m[46]. This directive provides a hook
                   for associating an identity with a request [4mbased[24m [4mon[24m [4mthe[0m
                   [4mrequest[24m [4mitself[24m (such as the request URI, its arguments, and
                   other context).

                   As a simple example, the following directive checks if the
                   request includes a [4mUSERNAME[24m argument, and if so, just uses
                   it:

                       ACS_PRE_AUTH '${Args::USERNAME:e} ? ${Args::USERNAME} : ""'

                   Note the single quotes around the expression so that it is
                   evaluated at access control time instead of configuration
                   processing time.

                   The ACS_PRE_AUTH directives are processed if a request is
                   received that does not include valid credentials and if not
                   disabled by [34m[1mACS_AUTHENTICATED_ONLY[0m[1m[22m[47]. If more than one
                   ACS_PRE_AUTH directive is given, they are evaluated in the
                   order in which they appear until one returns a valid
                   username. If that expression sets the variable
                   [4m${Auth::ROLES}[24m to a valid role string, it will be included
                   in the credentials (see [34m[1mdacs_authenticate(8)[0m[1m[22m[48]).
                   Evaluation errors are ignored. If no expression returns a
                   valid username, access control processing continues.

                   These directives are processed before any HTTP_AUTH
                   directives; if a ACS_PRE_AUTH directive is successful, the
                   user will effectively be authenticated and so no HTTP_AUTH
                   directives will be processed.

                   If the request includes a [1m-rname [22mflag with the [34m[1mDACS_ACS[0m[1m[22m[49]
                   argument, its value is [4m${Args::RNAME}[24m.

                   Unlike when authentication is done through
                   [34m[1mdacs_authenticate(8)[0m[1m[22m[50], [4mcredentials[24m [4mare[24m [4mnot[24m [4mreturned[24m [4mto[0m
                   [4mthe[24m [4mclient[24m. This means that no [1mDACS [22msession state exists
                   outside of [1mdacs_acs [22mand therefore some [1mDACS [22mweb services
                   may be unavailable or may not operate in the same way they
                   would if credentials were provided by the client. This
                   mechanism may also be less efficient than one that returns
                   credentials because authentication will be performed each
                   and every time the client makes a request that triggers it.

               ACS_SUCCESS (Optional)
                   If [1mdacs_acs [22mgrants access, immediately before it terminates
                   it evaluates the given expression. This directive provides
                   a hook for post-authorization actions to be performed,
                   which can be user-specific. The namespaces in effect during
                   authorization processing are accessible to the expression.
                   The value of the expression is discarded and any errors are
                   ignored.

                   Also see the [34m[1mon_success()[0m[1m[22m[51] function.

                       [1mNote[0m
                       While it is typically true that if [1mDACS [22mgrants a
                       request, the web server will go on to process the
                       request (and eventually return a web page to the user
                       agent, execute a program, etc.), it is not necessarily
                       so. For example, access may still be denied by the web
                       server for other reasons, or an error can occur during
                       subsequent processing. This may be relevant in
                       situations where ACS_SUCCESS is used to decrement a
                       [34m[1mcounter[0m[1m[22m[52], for instance, because it is possible that
                       the user may not actually see a successful result, in
                       which case the counter value should not have been
                       changed and so corrective action would be required.

               ACS_TRACK_ACTIVITY (Optional1)
                   This directive is associated with the inactivity timeout
                   feature whereby an authenticated user is denied access (at
                   any jurisdiction where it is enabled within the [34m[1mcurrent[0m
                   [1m[34mfederation[0m[1m[22m[53]) if no web service request is made within a
                   certain time period (also at any jurisdiction where it is
                   enabled within the [34m[1mcurrent federation[0m[1m[22m[53]). See
                   [34m[1mACS_INACTIVITY_LIMIT_SECS[0m[1m[22m[54]. This feature is disabled by
                   default. It is enabled on a per-jurisdiction basis, and in
                   the usual configuration all jurisdictions within a
                   federation will enable the feature if it is required.

                   If the directive's value is "yes", [34m[1mdacs_acs(8)[0m[1m[22m[6] emits a
                   federation-wide HTTP cookie that notes the jurisdiction and
                   date/time at which each [1mDACS[22m-wrapped service request is
                   processed. The cookie is emitted regardless of whether
                   access was granted, although some error conditions may
                   prevent a cookie from being sent. No cookie is set for an
                   effectively unauthenticated request.

                   The name of the activity tracking cookie has the following
                   format:

                       DACS:[4mfederation-name[24m::::ACTIVITY

                   where [4mfederation-name[24m is the official name assigned to the
                   federation for which the cookie is valid
                   ([34m[1mFEDERATION_NAME[0m[1m[22m[55]). Activity tracking may be enabled
                   without enabling inactivity detection (via
                   [34m[1mACS_INACTIVITY_LIMIT_SECS[0m[1m[22m[54]). This feature depends on an
                   appropriate level of clock synchronization at all
                   participating jurisdictions.

               ADMIN_IDENTITY (Optional)
                   This repeatable directive specifies a [1mDACS [22midentity (group
                   names are currently not allowed) that [1mDACS [22mgrants special
                   privileges. If omitted, the [34m[1mcurrent federation and[0m
                   [1m[34mjurisdiction[0m[1m[22m[53] are implied. The usernames "unauth" and
                   "unauthenticated" are disallowed, whether qualified with a
                   jurisdiction or not. The function [34m[1mdacs_admin()[0m[1m[22m[56] tests
                   whether the user making a service request has any
                   credentials that match any ADMIN_IDENTITY. This enables
                   boilerplate access control rules to be written that need to
                   restrict access to an administrator - the rules need only
                   invoke [1mdacs_admin()[22m. Changes to the list of [1mDACS[0m
                   administrators take effect immediately. Comparison of these
                   identities with credentials is controlled by the
                   [34m[1mNAME_COMPARE[0m[1m[22m[57] directive.

                   Some [1mDACS [22mservices call an internal version of this
                   function to ensure certain operations are limited to a [1mDACS[0m
                   administrator.

                       [1mSecurity[0m
                       Consider requiring more secure authentication for
                       administrator identities, such as using a two-factor
                       authentication method or combining two different
                       authentication methods.

               ALLOW_HTTP_COOKIE (Optional1)
                   If "yes", [1mDACS [22mcomponents will allow the environment
                   variable [1mHTTP_COOKIE [22mto be used to pass [1mDACS [22mcredentials.
                   This is currently necessary when [1mDACS [22mcomponents are
                   invoked through IIS (except in conjunction with [1mDACS[0m
                   proxied operation). On secure systems, this method of
                   passing credentials may be acceptable, but in general it is
                   not secure and must not be allowed because environment
                   variables are essentially public on some systems. If
                   undefined or not "yes", [1mDACS [22mcomponents will fail if
                   [1mHTTP_COOKIE [22mis present.

               AUTH_AGENT_ALLOW_ADMIN_IDENTITY (Optional1)
                   Unless this directive has the value "yes", [1mdacs_auth_agent[0m
                   will not return credentials that have been designated as an
                   ADMIN_IDENTITY.

               AUTH_CREDENTIALS_ADMIN_LIFETIME_SECS (Optional1)
                   The lifetime, in seconds, of all credentials created by
                   this jurisdiction for internal use. These credentials are
                   used in certain internal transactions, such as when
                   [1mdacs_authenticate [22msends an HTTP request to an
                   authentication or roles module. Although they are only
                   supposed to be held by trusted components, because these
                   credentials can convey special privileges their lifetime
                   should not be much longer than required. It is sometimes
                   necessary to increase this lifetime when debugging or if a
                   recipient server is slow.

               AUTH_CREDENTIALS_DEFAULT_LIFETIME_SECS (Required1)
                   The default lifetime, in seconds, of all credentials
                   created by this jurisdiction for users. The jurisdiction's
                   authentication services may override this value on a
                   case-by-case basis, either through an authentication module
                   (see [34m[1mauth_reply.dtd[0m[1m[22m[58]) or by setting
                   [4m${Auth::CREDENTIALS_LIFETIME_SECS}[24m (see
                   [34m[1mdacs_authenticate(8)[0m[1m[22m[50]).

                       [1mSecurity[0m
                       The lifetime should be chosen such that it strikes a
                       balance between security and user convenience that is
                       appropriate for the jurisdiction and federation.

               AUTH_ERROR_HANDLER (Stack)
                   If [34m[1mdacs_authenticate(8)[0m[1m[22m[50] is not able to successfully
                   authenticate a user, the resulting action can be customized
                   in ways that depend on the reason for the failure. This
                   provides a way for the system administrator to display a
                   custom error message or redirect the user's browser.

                       [1mNote[0m
                       This feature is activated only if [1mdacs_authenticate [22mis
                       passed an [4mENABLE_AUTH_HANDLERS[24m parameter that has a
                       value of 1.
                   The following error code numbers and corresponding
                   descriptive text are defined:

                       800 Authentication failed, invalid authenticating information
                       801 Authentication failed, invalid argument
                       802 Authentication failed, internal error
                       899 Authentication failed, reason unknown

                   When this type of response is returned, a program needs to
                   only examine the three digit code to determine why access
                   was denied. No blanks may precede the code, any number of
                   blanks may follow it. The descriptive-text consists only of
                   printable characters (e.g., no tabs or newlines) and may
                   not contain a colon. The descriptive-text is subject to
                   change, but the meaning of the code number is fixed.
                   Optionally, the standard text may be followed by a single
                   space, a colon, at least one space, and a more detailed
                   error message.

                   The [1mdacs_authenticate [22mservice recognizes a [4mFORMAT[24m argument
                   that is used to select between an XML-aware user agent
                   (FORMAT=XML) and an HTML capable user agent ([4mFORMAT[24m is not
                   specified or is not XML). In the case of an XML result,
                   [34m[1mdacs_auth_reply.dtd[0m[1m[22m[59] is used. The behaviour of this
                   directive with respect to [4mFORMAT[24m is described below on a
                   case-by-case basis.

                   The following directives are supported:

                    1. AUTH_ERROR_HANDLER "[4mAUTH-error-code[24m reason"

                       [1mDACS [22mwill return an HTML (or XML, if FORMAT=XML)
                       document that describes why authentication failed, such
                       as the following:

                           800 Authentication failed, invalid authenticating information

                       This is the default behaviour.

                    2. AUTH_ERROR_HANDLER "[4mAUTH-error-code[24m [url] [4mURL[24m"

                       This form causes [1mDACS [22mto redirect the client to the
                       specified URL, which may be a relative or absolute URL.
                       If the keyword url is absent, [4mURL[24m must begin with the
                       four characters http. The GET method will be used. The
                       URL may contain a properly escaped query string; [1mDACS[0m
                       will append the following parameters, in the order
                       given, to the URL:

                        1. [4mDACS_ERROR_CODE[24m, the AUTH-error-code that
                           identifies the failure.

                        2. [4mDACS_VERSION[24m, the version number of [1mDACS [22m(e.g.,
                           "1.4").

                        3. [4mDACS_FEDERATION[24m, the federation that received the
                           service request, if available.

                        4. [4mDACS_JURISDICTION[24m The jurisdiction that received
                           the service request, if available.

                        5. [4mFORMAT[24m, the value of this parameter will be either
                           HTML or XML, as determined by the value of the
                           parameter of the same name passed to
                           [1mdacs_authenticate [22mor the default (HTML if [4mFORMAT[0m
                           was not specified).
                           The values of these parameters are URL encoded.

                        3. AUTH_ERROR_HANDLER "[4mAUTH-error-code[24m [file]
                           [4mfull-pathname[24m"

                           This form causes the contents of the file named by
                           [4mfull-pathname[24m to be returned without regard to the
                           presence of a [4mFORMAT[24m argument.

                               [1mNote[0m
                               The file must include any header lines it
                               requires, such as a Content-Type line, a
                               header-terminating blank line, and then the
                               document content. Note also that the
                               "full-pathname" usage differs from the
                               "local-URL" usage of the ACS_ERROR_HANDLER
                               directive, though both elements begin with a
                               slash character; the former specifies the
                               absolute pathname of a file, while the latter
                               specifies a URL local to the receiving web
                               server.

                        4. AUTH_ERROR_HANDLER "[4mAUTH-error-code[24m [message]
                           \"[4mmessage[24m\""

                           This form causes the given message, surrounded by
                           escaped double quote characters, to be returned as
                           HTML (or XML if FORMAT=XML).
                           The optional keywords are treated
                           case-insensitively.

                           The [4mAUTH-error-code[24m is either a defined
                           authentication error code (listed above) or the
                           special symbol "*", which means the directive
                           applies to any authentication error code for which
                           there is no explicit directive.

                           This directive may appear multiple times, although
                           multiple directives for the same [4mAUTH-error-code[0m
                           are not allowed. Any invalid directive will
                           generally be treated as a fatal error. A directive
                           with a syntactically valid but undefined
                           [4mAUTH-error-code[24m is ignored, however.

                       AUTH_FAIL (Optional1)
                           If [1mdacs_authenticate [22mfails to authenticates a user,
                           the given expression is evaluated just before the
                           [34m[1mAUTH_ERROR_HANDLER[0m[1m[22m[60] directive, if any, is
                           processed. This directive provides a hook for
                           post-authentication actions to be performed. The
                           namespaces in effect during authentication
                           processing are accessible to the expression. The
                           value of the expression is discarded and any errors
                           are ignored. Note that since authentication failed,
                           only the user's purported identity may be available
                           ([4m${Args::USERNAME}[24m), or if the user was previously
                           authenticated successfully, as [4m${Env::REMOTE_USER}[24m.

                       AUTH_FAIL_DELAY_SECS (Optional1)
                           If assigned a positive integer value, a particular
                           user (ordinarily the one identified by the [4mUSERNAME[0m
                           argument to [1mdacs_authenticate[22m) will not be allowed
                           to reauthenticate following a failed attempt within
                           this many seconds. If assigned the value of zero
                           seconds, this feature is disabled. If this
                           directive is absent or assigned an illegal value, a
                           compile-time value is used instead. Authentication
                           modules may indirectly impose their own delays
                           following unsuccessful authentication; this is
                           system dependent and not under the control of [1mDACS[22m.

                       AUTH_SINGLE_COOKIE (Optional1)
                           By default, each set of credentials that is
                           returned in an HTTP cookie is assigned a [34m[1mcookie[0m
                           [1m[34mname[0m[1m[22m[61] that corresponds to the identity
                           represented by the credentials. If a user
                           authenticates as two different identities through
                           [1mdacs_authenticate[22m, for example, he will be given
                           two cookies with different names. Because in some
                           situations multiple credentials can be problematic,
                           this directive provides a way to effectively limit
                           a request to a single set of credentials by using
                           one cookie name for all credentials. When an
                           already-authenticated user authenticates again,
                           either at the same jurisdiction or any
                           jurisdiction, the user's browser will replace the
                           previous cookie with the new one.

                           This directive also controls cookie names
                           associated with credentials generated by
                           [34m[1mdacscookie(1)[0m[1m[22m[31], [34m[1mdacs_auth_agent(8)[0m[1m[22m[62], and
                           [34m[1mdacs_auth_transfer(8)[0m[1m[22m[29]. Also see
                           [34m[1mACS_CREDENTIALS_LIMIT[0m[1m[22m[63].

                           By setting AUTH_SINGLE_COOKIE to "jurisdiction"
                           (case insensitive), the username component of an
                           authentication cookie issued by the jurisdiction is
                           suppressed. This means that every authentication
                           cookie it creates will have the same name. By
                           setting it to "federation" (case insensitive), the
                           jurisdiction and username components of an
                           authentication cookie issued by the jurisdiction
                           are suppressed. This means that every
                           authentication cookie that it creates will have the
                           same name, but also that any two jurisdictions that
                           use this configuration will create cookies with the
                           same name. Any other value results in the default
                           behaviour, which is to include both the
                           jurisdiction name and the username in the names of
                           authentication cookies. The directive has no effect
                           on the name of the identity encapsulated within an
                           HTTP cookie.

                           If an authentication cookie is received that was
                           created by the jurisdiction and has a cookie name
                           with a component that it has been configured to
                           suppress, the cookie is ignored. A cookie issued by
                           a different jurisdiction with a suppressed cookie
                           name component is acceptable regardless of how this
                           directive is configured at this jurisdiction.  [1mDACS[0m
                           will reject all credentials if a request includes
                           more than one cookie with the same cookie name.

                           In typical use, each jurisdiction that performs
                           authentication will configure this directive
                           identically. To limit each user to associating a
                           single identity with their request, simply set
                           AUTH_SINGLE_COOKIE to "federation" at each
                           jurisdiction in the federation.

                               [1mSecurity[0m
                               This directive indirectly limits the number of
                               credentials that can be associated with a
                               single request. It does not prevent the same
                               individual from sending different requests,
                               from the same browser or different browsers,
                               each associated with a different identity.
                               Also, it does not limit the number of
                               concurrent logins of the same identity (such as
                               by different individuals sharing the same
                               account).

                               Changing this directive's value may render
                               existing credentials invalid at this
                               jurisdiction. For example, after changing the
                               directive it is possible for a user to obtain
                               two authentication cookies with different names
                               for the same identity.  [1mDACS [22mdoes not allow a
                               request to include multiple credentials for the
                               same identity.

                       AUTH_SUCCESS (Optional)
                           If [1mdacs_authenticate [22msuccessfully authenticates a
                           user, the given expression is evaluated just before
                           the [34m[1mAUTH_SUCCESS_HANDLER[0m[1m[22m[64] directive, if any, is
                           processed. This directive provides a hook for
                           post-authentication actions to be performed, which
                           can be user-specific. The namespaces in effect
                           during authentication processing are accessible to
                           the expression. The value of the expression is
                           discarded and any errors are ignored.

                           Also see the [34m[1mon_success()[0m[1m[22m[51] function.

                           As an example, the following directive will run a
                           web service after every successful login:

                               AUTH_SUCCESS 'https://internal.example.com/cgi-bin/userlogin?USERNAME=${Auth::IDENTITY}'


                       AUTH_SUCCESS_HANDLER (Optional1)
                           If [1mdacs_authenticate [22msuccessfully authenticates a
                           user, the resulting action can be customized. This
                           provides a way for the [1mDACS [22madministrator to
                           redirect a user's browser after login.

                               [1mNote[0m
                               This feature is enabled only if
                               [1mdacs_authenticate [22mis passed an
                               [4mENABLE_AUTH_HANDLERS[24m parameter that has a value
                               of 1.
                           The [1mdacs_authenticate [22mservice recognizes a [4mFORMAT[0m
                           argument that is used to select between an
                           XML-aware user agent (FORMAT=XML) and an HTML
                           capable user agent ([4mFORMAT[24m is not specified or is
                           not XML). In the case of an XML result,
                           [34m[1mdacs_auth_reply.dtd[0m[1m[22m[59] is used. The behaviour of
                           this directive with respect to [4mFORMAT[24m is described
                           below on a case-by-case basis.

                           The following syntaxes are supported:

                            1. AUTH_SUCCESS_HANDLER "[url] [4mURL[24m"

                               This form causes [1mDACS [22mto redirect the client to
                               [4mURL[24m, which may be a relative or absolute URL.
                               If the keyword url is absent, [4mURL[24m must begin
                               with the four characters http. The GET method
                               will be used. The URL may contain a properly
                               escaped query string; [1mDACS [22mwill append the
                               following parameters, in the order given, to
                               the URL:

                               [4mDACS_VERSION[0m
                                   The version number of [1mDACS [22m(e.g., "1.4").

                               [4mDACS_FEDERATION[0m
                                   The federation that received the service
                                   request, if available.

                               [4mDACS_JURISDICTION[0m
                                   The jurisdiction that received the service
                                   request, if available.

                               [4mDACS_USERNAME[0m
                                   The username associated with the new
                                   credentials.

                               [4mFORMAT[0m
                                   The value of this parameter will be either
                                   HTML or XML, as determined by the value of
                                   the parameter of the same name passed to
                                   [1mdacs_authenticate [22mor the default (HTML if
                                   [4mFORMAT[24m was not specified).

                               The values of these parameters are URL encoded.

                            2. AUTH_SUCCESS_HANDLER "[file] [4mfull-pathname[24m"

                               This form causes the contents of the file named
                               by [4mfull-pathname[24m to be returned without regard
                               to the presence of a [4mFORMAT[24m argument. The file
                               must include any header lines it requires, such
                               as a Content-Type line, a header-terminating
                               blank line, and then the document content.

                                   [1mNote[0m
                                   The "full-pathname" usage differs from the
                                   "local-URL" usage of the ACS_ERROR_HANDLER
                                   directive, though both elements begin with
                                   a slash character; the former specifies the
                                   absolute pathname of a file, while the
                                   latter specifies a URL local to the
                                   receiving web server. To specify a relative
                                   URL, use the url keyword.

                            3. AUTH_SUCCESS_HANDLER "[message] \"[4mmessage[24m\""

                               This form causes the given message, surrounded
                               by escaped double quote characters, to be
                               returned as HTML (or XML if FORMAT=XML).

                            4. AUTH_SUCCESS_HANDLER "credentials"

                               This form causes the user's credentials to be
                               displayed, either as an HTML or XML (if
                               FORMAT=XML) document. This is the default
                               behaviour.
                               The optional keywords are treated
                               case-insensitively.

                           AUTH_TRANSFER_EXPORT (Optional)
                               Each use of this directive identifies a target
                               federation and the corresponding URL of a
                               program to invoke the TOKEN operation phase of
                               the protocol in that federation. The federation
                               identifier is simply a label; it must be a
                               syntactically valid federation name. Whitespace
                               separates the federation name from the URL.
                               Please refer to [34m[1mdacs_auth_transfer(8)[0m[1m[22m[29] for
                               details.

                           AUTH_TRANSFER_TOKEN_LIFETIME_SECS (Optional1)
                               This is the lifetime, in seconds, of a token
                               produced by the TOKEN operation of
                               [34m[1mdacs_auth_transfer(8)[0m[1m[22m[29] and consumed by its
                               IMPORT operation. That is, it is the time a
                               user (or middleware) has to submit the token
                               before it becomes invalid. It should be on the
                               order of a few seconds.

                           COMPAT_MODE (Optional1)
                               This indicates that, to the extent possible,
                               credentials issued by a different release of
                               [1mDACS [22mshould be accepted. At present, the only
                               supported values are off (the default, which
                               disables this mode) and 1.2.

                                   [1mImportant[0m
                                   This directive is [4mnot[24m intended to provide
                                   complete interoperability among [1mDACS[0m
                                   releases and in fact it does not in certain
                                   situations. Old releases of [1mDACS [22mmay
                                   contain security-related bugs, or may rely
                                   on third-party software that contains
                                   security-related bugs.  [1mDACS [22minstallations
                                   are urged to upgrade rather than to depend
                                   on the limited backward compatibility
                                   supplied by this directive.  [4mThere[24m [4mis[24m [4mno[0m
                                   [4mguarantee[24m [4mthat[24m [4many[24m [4mparticular[24m [4mlevel[24m [4mof[0m
                                   [4mbackward[24m [4mcompatibility[24m [4mwill[24m [4mbe[24m [4mcarried[0m
                                   [4mforward[24m [4min[24m [4msubsequent[24m [4mreleases[24m [4mof[24m [1mDACS[22m.

                           COOKIE_HTTPONLY (Optional1)
                               If "yes", the HttpOnly attribute will be
                               included with cookies produced by [1mDACS[22m. This
                               attribute is a Microsoft extension that is used
                               to "[34m[1mmitigate the risk of information disclosure[0m
                               [1m[34mwith a cross-site scripting (XSS) attack[0m[1m[22m[65]".
                               This attribute is not recognized by all
                               browsers but these browsers should ignore it.
                               The default is "no".

                                   [1mSecurity[0m
                                   Methods of defeating this attribute
                                    [34m[1mare known[0m[1m[22m[66], so administrators may need
                                   to take additional precautions against XSS
                                   attacks.

                           COOKIE_NO_DOMAIN (Optional1)
                               If "yes", no domain attribute will appear when
                               [1mDACS [22mreturns a cookie, such as after
                               authenticating successfully from a browser. The
                               browser will take the default action, which is
                               to associate the cookie with the domain name or
                               IP address of the request that returned the
                               cookie. This will obviously limit [1mDACS's [22msingle
                               sign-on feature since the cookie (credentials)
                               will only be sent with requests made to that
                               domain name or IP address.

                               This directive is sometimes useful when [1mDACS [22mis
                               deployed in an environment where fully
                               qualified domain names are not used. In this
                               case, FEDERATION_DOMAIN must still be
                               configured, although it will not be used in
                               conjunction with the domain of cookies.

                               The default is "no".

                           COOKIE_PATH (Optional1)
                               This allows the path component of a Set-Cookie
                               (and Set-Cookie2) HTTP response header to be
                               specified for the jurisdiction. These headers
                               are sent to a user agent after successful
                               authentication or signout. Refer to the
                               [34m[1mNetscape HTTP Cookies Specification[0m[1m[22m[67] and [34m[1mRFC[0m
                               [1m[34m2965[0m[1m[22m[68] for details.

                                   [1mSecurity[0m
                                   The default value is "/", which means that
                                   the cookie will be sent by a user agent
                                   along with [4mevery[24m request sent to the
                                   jurisdiction's host. The value should be
                                   set to the most specific URL path under
                                   which all [1mDACS[22m-wrapped services appear so
                                   that [1mDACS [22mcredentials will only be sent
                                   with requests to those URLs. It is critical
                                   to do this if your server runs arbitrary
                                   user CGI programs because a malicious user
                                   might be able to cause a [1mDACS[22m-authenticated
                                   user to visit a service that is not
                                   [1mDACS[22m-wrapped and capture cookies that
                                   represent [1mDACS [22midentities. For example, if
                                   a jurisdiction segregated its [1mDACS[22m-wrapped
                                   static content under /dacs/content and its
                                   [1mDACS[22m-wrapped CGI programs under
                                   /dacs/cgi-bin, then COOKIE_PATH should have
                                   the value "/dacs".

                           CSS_PATH (Optional1)
                               This path is used as the value of the href
                               attribute of the HTML link element used to
                               specify the root location of style files used
                               by HTML-producing [1mDACS [22mweb services and
                               utilities. The mapping between this path and a
                               local directory, if any, depends on [1mApache's[0m
                               configuration; for example, if its value is
                               "/css", the location of the corresponding
                               directory will depend on the location of the
                               server's document root and any applicable Alias
                               directive.

                               If this directive is not used, a compile-time
                               default of "/css" is used, which assumes that
                               an [1mApache [22mdirective like this one is used:

                                   Alias /css "/usr/local/dacs/www/css/"

                               Please refer to [34m[1mdacs.install(7)[0m[1m[22m[69] for
                               additional information about use of the Alias
                               directive.

                           DTD_BASE_URL (Optional1)
                               When [1mDACS [22mservices are asked to send an XML
                               response (FORMAT=XML) and DTD_BASE_URL is
                               configured, services will emit a DOCTYPE with
                               the keyword SYSTEM followed by a value derived
                               from DTD_BASE_URL; e.g.,

                                   <!DOCTYPE foo SYSTEM "http://example.com/dacs/dtd-xsd/foo.dtd">

                               If DTD_BASE_URL is not configured, an internal
                               DTD will be emitted. Also see the description
                               of the [34m[4mFORMAT[24m web service argument[0m[70].

                           EVAL (Optional)
                               The EVAL directive is special in that it may
                               appear in any clause and because it is [4malways[0m
                               [4mevaluated[24m [4mwhen[24m [4mit[24m [4mis[24m [4mfirst[24m [4mseen[24m during
                               processing of site.conf, the Default section of
                               dacs.conf, or the applicable Jurisdiction
                               section of dacs.conf (i.e., before any section
                               merging occurs). The purpose of the directive
                               is purely for its side effect, such as
                               initializing a configuration variable (see
                               [34m[1mAdvanced Techniques[0m[1m[22m[71]). Because these
                               directives are scanned early during
                               configuration processing, their right-hand
                               sides cannot reference directives as
                               configuration variables because those
                               directives have not yet been evaluated (so they
                               cannot reference [4m${Conf::FEDERATION_DOMAIN}[24m,
                               for example). Example:

                                   EVAL ${Conf::a_special_path} = "/my/path"


                           FEDERATION_DOMAIN (Required1)
                               The suffix of the domain name ([34m[1mRFC 1035[0m[1m[22m[72]
                               2.3.1) that is common to all jurisdictions in
                               the federation. Note that the domain name
                               associated with a jurisdiction is not
                               explicitly configured (but see dacs_url in
                               [34m[1mdacs.groups(5)[0m[1m[22m[73]), and that this is a
                               one-to-many association (see [34m[1mdacs.conf(5)[0m[1m[22m[74]).
                               Example: example.com

                           FEDERATION_NAME (Required1)
                               The name for the federation of jurisdictions.
                               The syntax is the same as for
                               [34m[1mJURISDICTION_NAME[0m[1m[22m[75]: an alphabetic followed
                               by zero or more alphanumeric characters, '-',
                               or '_'. By convention, this is in all-caps,
                               however. Please see [34m[1mdacs(1)[0m[1m[22m[76] for additional
                               information. Example: FEDROOT

                           HTTP_AUTH (Stack)
                               This directive is used to perform user
                               authentication at access control time rather
                               than in a separate step. This authentication is
                               triggered through [1mDACS's [22minternal
                               implementation of HTTP Basic or Digest
                               authentication (see [34m[1mRFC 2617[0m[1m[22m[77]). If prompting
                               is enabled, the user will be asked for his
                               username and password by the user agent's usual
                               prompting method. If prompting is disabled, the
                               user agent must know how to send an
                               Authorization request header without first
                               receiving a WWW-Authenticate response header.
                               The username and password obtained from the
                               user can be directed to any suitable [1mDACS[0m
                               authentication method for validation. The
                               resulting identity is associated with the
                               [34m[1mcurrent jurisdiction[0m[1m[22m[46].

                               Other than by placing the resource or resources
                               specified by this directive under the control
                               of [1mDACS[22m, no additional [1mApache [22mconfiguration
                               needs to be done to use this feature. Please
                               refer to the section on [34m[1mHTTP Authentication[0m[1m[22m[78]
                               for additional information about this feature
                               and how it is used. Also consult the
                               [34m[1mHTTP_AUTH_ENABLE[0m[1m[22m[79] directive.

                               Two different mechanisms are available:
                               [4mpre-authorization[24m testing and
                               [4mpost-authorization[24m testing. The
                               HTTP_AUTH_ENABLE directive is used to enable
                               one or both mechanisms.

                               The [4mpre-authorization[24m testing mechanism is used
                               if:

                                1. a request is received that does not include
                                   valid credentials;

                                2. the feature is enabled by HTTP_AUTH_ENABLE
                                   (i.e., it is set to "pre_acs_only" or
                                   "both") and not disabled by
                                   [34m[1mACS_AUTHENTICATED_ONLY[0m[1m[22m[47];

                                3. no [34m[1mACS_PRE_AUTH[0m[1m[22m[80] directive is
                                   successful;

                                4. the applicable directive includes the [1m-pre[0m
                                   flag ([34m[1msee below[0m[1m[22m[81]); and

                                5. either the request includes an
                                   Authorization request header or the return
                                   of an HTTP WWW-Authenticate response header
                                   is enabled.
                                   This mechanism can be useful with simple
                                   user agents that understand Basic
                                   authentication but cannot handle
                                   redirection or sometimes even the
                                   WWW-Authenticate response header. It may
                                   also be appropriate in situations where a
                                   user agent cannot or will not handle HTTP
                                   cookies. If [1mdacs_acs [22mis allowed to respond
                                   with a WWW-Authenticate response header,
                                   the configuration variable
                                   [4m${Conf::http_auth_401}[24m must be set to
                                   "yes".

                                   The [4mpost-authorization[24m testing mechanism is
                                   used if:

                                    1. a request is denied because the user
                                       was not authenticated;

                                    2. the feature is enabled by
                                       HTTP_AUTH_ENABLE (i.e., it is set to
                                       "post_acs_only" or "both") and not
                                       disabled by ACS_AUTHENTICATED_ONLY;

                                    3. the applicable directive does not
                                       include a [1m-pre [22mflag (see below).

                                       One important difference between the
                                       two mechanisms is that while the
                                       post-authorization mechanism works by
                                       redirecting the user to
                                       [34m[1mdacs_authenticate(8)[0m[1m[22m[50] after
                                       authorization checking denies a
                                       request, the pre-authorization
                                       mechanism does not involve any
                                       redirection and [1mdacs_authenticate [22mis
                                       not used. Instead, [1mdacs_acs [22mperforms
                                       authentication internally (by calling
                                       [1mdacsauth [22mas a function) and [4mcredentials[0m
                                       [4mare[24m [4mnot[24m [4mreturned[24m [4mto[24m [4mthe[24m [4mclient[24m;
                                       credentials are created that (normally)
                                       exist only for the duration of the
                                       authorization check, which means that
                                       no [1mDACS [22msession state exists outside of
                                       [1mdacs_acs [22mand therefore some [1mDACS [22mweb
                                       services will either be unavailable or
                                       not operate in the same way they would
                                       if credentials were provided by the
                                       client. Pre-authorization may also be
                                       less efficient than returning
                                       credentials because authentication will
                                       be performed each and every time the
                                       client makes a request that triggers
                                       it. Note that only authentication
                                       modules that implement the password or
                                       expr [34m[1mauthentication styles[0m[1m[22m[82] can be
                                       used by this mechanism, and only if no
                                       redirection of the client is necessary.
                                       Because web browsers only prompt for a
                                       username and password, if an [4mAUXILIARY[0m
                                       argument is also required it must be
                                       entered with either the username or
                                       password (i.e., combined in some way,
                                       perhaps separated by punctuation) and
                                       then parsed into an [4mAUXILIARY[24m argument
                                       using a run-time configuration
                                       directive. With pre-authorization,
                                       roles can be assigned to the temporary
                                       credentials (refer to the description
                                       of the [1m-r [22mflag and the [4mrole-module-spec[0m
                                       in [34m[1mdacsauth(1)[0m[1m[22m[32] for details).

                                           [1mSecurity[0m
                                           Like [1mdacsauth [22mand
                                           [1mdacs_authenticate[22m, if [1mdacs_acs [22muses
                                           a built-in module to perform
                                           authentication, it must run setuid
                                           or setgid ([34m[1mchmod(2)[0m[1m[22m[83]). to obtain
                                           sufficient privileges to access the
                                           required files; this is true for
                                           Unix password authentication, for
                                           example. Programs should run at the
                                           lowest level of authorization that
                                           is necessary, however, and it is
                                           generally preferable to only run
                                           authentication modules at a higher
                                           authorization level.

                                       The value of the HTTP_AUTH directive
                                       follows any one of the following three
                                       forms:

                                        1.

                                               [4mauth_scheme[24m [4mauth_realm[24m [4murl_pattern[24m+

                                        2.

                                               [4mauth_scheme[24m [4mauth_realm[24m [4murl_pattern[24m+ -pre [[-param] [4mparam-string[24m]
                                                   {-m [4mauth-module-spec[24m [[4mauth-flag[24m]*}+ {-r [4mroles-module-spec[24m}*

                                        3.

                                               except [4murl_pattern[24m+

                                           The first syntactical form is for
                                           the post-authentication mechanism:

                                           +o   [4mauth_scheme[24m is the
                                               (case-insensitive)
                                               authentication scheme to use
                                               (e.g., Basic);

                                           +o   [4mauth_realm[24m is the
                                               (case-sensitive) realm-value
                                               string associated with the
                                               resource (see [34m[1mRFC 2617[0m[1m[22m[77]);

                                           +o   [4murl_pattern[24m+ is a list of one
                                               or more URI path components
                                               that are matched against the
                                               request for which access was
                                               denied to an unauthenticated
                                               user. Each of these components
                                               is like the [4murl_pattern[0m
                                               attribute used in [34m[1maccess[0m
                                               [1m[34mcontrol rules[0m[1m[22m[37] in that it
                                               can either specify an exact
                                               match or, by ending in "/*", a
                                               wildcard match; no query
                                               argument component is allowed.
                                               Each [4murl_pattern[24m begins with a
                                               / character.

                                               The second syntactical form is
                                               for the pre-authentication
                                               mechanism. Its first three
                                               components are like those for
                                               the first form, and must appear
                                               in the order specified above.
                                               The following components are
                                               then added, and may follow the
                                               three initial components in any
                                               order:

                                               +o   [1m-pre [22mselects the
                                                   pre-authorization testing
                                                   mechanism; the default is
                                                   to use post-authorization
                                                   testing. Because each
                                                   [4murl_pattern[24m begins with a /
                                                   character, the [1m-pre [22mflag
                                                   implicitly ends the
                                                   [4murl_pattern[24m list.

                                               +o   [4mparam-string[24m is an optional
                                                   string consisting of
                                                   authentication parameters
                                                   as per RFC 2617 (note:
                                                   Basic auth does not permit
                                                   any optional parameters).
                                                   For clarity, or if
                                                   [4mparam-string[24m might be
                                                   confused with another
                                                   syntactic element, it can
                                                   be preceded by a [1m-param[0m
                                                   flag. In the absence of the
                                                   [1m-param [22mflag, any non-flag
                                                   argument is assumed to be
                                                   the [4mparam-string[24m. Only one
                                                   [4mparam-string[24m is allowed.

                                               +o   [1m-m [4m[22mauth-module-spec[0m
                                                   specifies an authentication
                                                   module using the
                                                   command-line syntax of
                                                   [34m[1mdacsauth(1)[0m[1m[22m[32]. This
                                                   argument must occur at
                                                   least once. Following the
                                                   [4mauth-module-spec[24m can be
                                                   zero or more [4mauth-flag[0m
                                                   arguments to apply to the
                                                   module's authentication
                                                   context. The
                                                   [1m-D[4m[22mdirective[24m[1m=[4m[22mvalue[24m flag, [1m-fj[0m
                                                   [4mjurname[24m flag, and the [1m-fn[0m
                                                   [4mfedname[24m flag are recognized
                                                   and have the same semantics
                                                   as when used by
                                                   [34m[1mdacsauth(1)[0m[1m[22m[32].

                                               +o   [1m-r [4m[22mroles-module_spec[0m
                                                   specifies a roles module.
                                                   This argument may occur
                                                   zero or more times.

                                                   In the third syntactical
                                                   form, the except keyword
                                                   identifies portions of the
                                                   URL space that should [4mnot[0m
                                                   trigger HTTP
                                                   authentication.

                                                   The HTTP_AUTH directives
                                                   "stack", like the
                                                   [34m[1mACS_ERROR_HANDLER[0m[1m[22m[18]
                                                   directive.  [1mDACS [22mwill
                                                   search for the first exact
                                                   [4murl_pattern[24m that matches or
                                                   will select the closest
                                                   wildcard [4murl_pattern[24m. Two
                                                   or more directives with the
                                                   same [4murl_pattern[24m should not
                                                   be configured.

                                                   The first of the two
                                                   directives in the following
                                                   example may trigger Basic
                                                   authentication for the
                                                   realm called "Info Realm"
                                                   when either
                                                   /cgi-bin/dacs/dacs_prenv or
                                                   /cgi-bin/dacs/dacs_version
                                                   (relative to the [34m[1mcurrent[0m
                                                   [1m[34mjurisdiction[0m[1m[22m[46]) is
                                                   requested. The second
                                                   directive may trigger Basic
                                                   authentication for the
                                                   realm called "CGI Realm"
                                                   for any other resource
                                                   subordinate to
                                                   /cgi-bin/dacs. The first
                                                   directive will override the
                                                   second because an exact
                                                   match overrides a wildcard
                                                   match.

                                                       HTTP_AUTH "basic \"Info Realm\" /cgi-bin/dacs/dacs_prenv /cgi-bin/dacs/dacs_version"
                                                       HTTP_AUTH "basic \"CGI Realm\"   /cgi-bin/dacs/*"

                                                   In the next example, the
                                                   two directives associate
                                                   the Basic authentication
                                                   scheme with everything
                                                   under /cgi-bin/dacs/,
                                                   except for
                                                   /cgi-bin/dacs/dacs_prenv
                                                   (because the second
                                                   directive is an exact
                                                   match, which overrides the
                                                   first directive):

                                                         HTTP_AUTH "basic \"CGI Realm\" /cgi-bin/dacs/*"
                                                         HTTP_AUTH "except /cgi-bin/dacs/dacs_prenv"


                                                       [1mTip[0m
                                                       An administrator can
                                                       take advantage of
                                                       [1mDACS's [22mactive
                                                       configuration
                                                       processing to decide at
                                                       run-time which
                                                       [4mauth_scheme[24m,
                                                       [4mauth_realm[24m, or password
                                                       file to use, for
                                                       instance, perhaps
                                                       depending on the
                                                       request's arguments.
                                                   As an example of
                                                   pre-authorization testing
                                                   authentication, consider
                                                   the following configuration
                                                   directives:

                                                       HTTP_AUTH_ENABLE "pre_acs_only"
                                                       EVAL ${Conf::http_auth_401} = "no"
                                                       HTTP_AUTH "basic \"dacs_prenv Realm\" /cgi-bin/dacs/dacs_prenv -m unix passwd suff"

                                                   The first directive above
                                                   enables this feature. The
                                                   second directive disables
                                                   responding with a
                                                   WWW-Authenticate header;
                                                   changing its value to "yes"
                                                   enables the response. The
                                                   third directive associates
                                                   the [1mDACS [34mdacs_prenv(8)[0m[1m[22m[84]
                                                   service with the built-in
                                                   Basic authentication
                                                   feature at
                                                   pre-authorization testing
                                                   time. Given this
                                                   configuration, if a client
                                                   requests [1mdacs_prenv [22mbut
                                                   does not include
                                                   credentials:

                                                   +o   if no Authorization
                                                       header was sent and
                                                       [4m${Conf::http_auth_401}[0m
                                                       is "no", then execution
                                                       will proceed as if the
                                                       feature were disabled
                                                       (i.e., the user will be
                                                       unauthenticated)

                                                   +o   if no Authorization
                                                       header was sent and
                                                       [4m${Conf::http_auth_401}[0m
                                                       is "yes", then [1mDACS[0m
                                                       will respond with a
                                                       WWW-Authenticate
                                                       response header and [1m401[0m
                                                       status code

                                                   +o   if an Authorization
                                                       header was sent, the
                                                       username and password
                                                       will be validated using
                                                       the built-in Unix
                                                       authentication module:

                                                       +o   if authentication
                                                           succeeds, temporary
                                                           credentials will be
                                                           created and used
                                                           for the request,
                                                           but will not be
                                                           returned to the
                                                           client

                                                       +o   if authentication
                                                           fails, access will
                                                           be denied

                                                               [1mTip[0m
                                                               You can create
                                                               an
                                                               Authorization
                                                               header by
                                                               constructing a
                                                               string
                                                               consisting of
                                                               an account
                                                               name, a colon,
                                                               and the
                                                               account's
                                                               password. MIME
                                                               encode the
                                                               resulting
                                                               string - you
                                                               can use
                                                               [34m[1mdacsexpr(1)[0m[1m[22m[85]
                                                               and the
                                                               [34m[1mencode()[0m[1m[22m[86]
                                                               function:

                                                                   % dacsexpr
                                                                   > encode(mime, "guest:apassword")
                                                                   "Z3Vlc3Q6YXBhc3N3b3Jk"

                                                               The header for
                                                               the example
                                                               above would
                                                               look like:

                                                                   Authorization: Basic Z3Vlc3Q6YXBhc3N3b3Jk

                                                               And using
                                                               [34m[1mdacshttp(1)[0m[1m[22m[4],
                                                               you could use
                                                               the flag:

                                                                   -header Authorization "Basic Z3Vlc3Q6YXBhc3N3b3Jk"
                                                           The example that
                                                           follows shows how
                                                           [34m[1mLDAP[0m
                                                           [1m[34mauthentication[0m[1m[22m[87]
                                                           using the direct
                                                           method might be
                                                           configured. In an
                                                           appropriate place
                                                           in dacs.conf, we
                                                           might insert these
                                                           directives:

                                                               HTTP_AUTH_ENABLE "pre_acs_only"
                                                               HTTP_AUTH "basic \"LDAP Login Using Your Common Name\" /basic/* -pre \
                                                                   -m https://example.example.com/cgi-bin/dacs/local_ldap_authenticate \
                                                                   password sufficient -Of /usr/local/dacs/ldap/ldap_auth_options_direct"

                                                           In the file
                                                           /usr/local/dacs/ldap/ldap_auth_options_direct
                                                           (which must be
                                                           readable at
                                                           run-time by
                                                           [34m[1mdacs_acs(8)[0m[1m[22m[6]), we
                                                           might put:

                                                               LDAP_BIND_METHOD=direct
                                                               LDAP_USERNAME_URL*="ldap://windex.example.com/CN=" . encode(url,${Args::USERNAME}) . ",CN=Users,DC=example,DC=com"
                                                               LDAP_USERNAME_EXPR*="${LDAP::sAMAccountName}"

                                                           Note the use of the
                                                           LDAP_USERNAME_EXPR*
                                                           directive. Because
                                                           authentication
                                                           against the
                                                           directory uses a
                                                           Common Name
                                                           attribute in the
                                                           example, and a
                                                           Common Name may not
                                                           be a valid [1mDACS[0m
                                                           username, it must
                                                           be replaced by (or
                                                           mapped to) an
                                                           acceptable [1mDACS[0m
                                                           username. The first
                                                           time a user
                                                           attempts to access
                                                           a resource that
                                                           matches the URL
                                                           pattern /basic/*,
                                                           he will prompted by
                                                           his web browser for
                                                           a username (in this
                                                           case, a Common Name
                                                           must be provided)
                                                           and password. The
                                                           directory on
                                                           windex.example.com
                                                           will be used by the
                                                           [1mlocal_ldap_authenticate[0m
                                                           module to validate
                                                           the information
                                                           provided by the
                                                           user.

                                                           To also obtain the
                                                           user's roles from
                                                           the directory, the
                                                           set_roles style
                                                           modifier and an
                                                           LDAP_ROLES_SELECTOR*
                                                           directive can be
                                                           added to the
                                                           configuration:

                                                               HTTP_AUTH_ENABLE "pre_acs_only"
                                                               HTTP_AUTH "basic \"LDAP Login Using Your Common Name\" /basic/* -pre \
                                                                   -m https://example.example.com/cgi-bin/dacs/local_ldap_authenticate \
                                                                   password,set_roles sufficient -Of /usr/local/dacs/ldap/ldap_auth_options_direct"

                                                           And to
                                                           /usr/local/dacs/ldap/ldap_auth_options_direct:

                                                               LDAP_BIND_METHOD=direct
                                                               LDAP_USERNAME_URL*="ldap://windex.example.com/CN=" . encode(url,${Args::USERNAME}) . ",CN=Users,DC=example,DC=com"
                                                               LDAP_ROLES_SELECTOR*="${LDAP::attrname}" eq "memberOf" ? strtr(ldap(rdn_attrvalu
                                                               e, ldap(dn_index, "${LDAP::attrvalue}", 1)), " ", "_") : ""
                                                               LDAP_USERNAME_EXPR*="${LDAP::sAMAccountName}"


                                                               [1mTip[0m
                                                               Since the
                                                               pre-authorization
                                                               mechanism does
                                                               not return [1mDACS[0m
                                                               credentials to
                                                               the user's web
                                                               browser, a
                                                               subsequent
                                                               invocation of
                                                               [34m[1mdacs_current_credentials(8)[0m[1m[22m[88]
                                                               will not
                                                               display
                                                               information
                                                               that resulted
                                                               from the
                                                               authentication
                                                               procedure. If
                                                               the URL that
                                                               triggers
                                                               pre-authorization
                                                               is for a script
                                                               or other
                                                               program that is
                                                               executable by
                                                               [1mApache [22mwith
                                                               access
                                                               permitted by
                                                               [1mDACS[22m, however,
                                                               the program can
                                                               display its
                                                               environment,
                                                               which will
                                                               include
                                                               [1mDACS_USERNAME[22m,
                                                               [1mDACS_ROLES[22m, and
                                                               so on. For
                                                               example,
                                                               [34m[1mdacs_prenv(8)[0m[1m[22m[84]
                                                               can be used for
                                                               this, as can
                                                               this simple PHP
                                                               script
                                                               ([1mphpinfo.php[22m):

                                                                   <html><head></head><body>
                                                                   <p>
                                                                   <?php
                                                                   phpinfo();
                                                                   ?>
                                                                   </p>
                                                                   </body>
                                                                   </html>
                                                           To authenticate
                                                           against a Unix
                                                           account and assign
                                                           the user's group
                                                           membership as
                                                           roles, this
                                                           configuration might
                                                           be used:

                                                               HTTP_AUTH_ENABLE "pre_acs_only"
                                                               HTTP_AUTH "basic \"Login Using Your Unix Account\" /basic/* -pre \
                                                                   -m https://example.example.com/cgi-bin/dacs/local_unix_authenticate \
                                                                   password sufficient -Of /usr/local/dacs/ldap/ldap_auth_options_direct \
                                                                   -r https://example.example.com/cgi-bin/dacs/local_unix_roles"

                                                           Note that
                                                           [1mlocal_unix_authenticate[0m
                                                           must run with
                                                           sufficient
                                                           privileges to
                                                           validate the
                                                           username/password
                                                           pair.

                                                       HTTP_AUTH_ENABLE
                                                       (Optional1)
                                                           This directive's
                                                           value must be one
                                                           of:

                                                           +o   "post_acs_only",
                                                               if only
                                                               post-authorization
                                                               testing [34m[1mHTTP[0m
                                                               [1m[34mAuthentication[0m[1m[22m[78]
                                                               may be used,

                                                           +o   "pre_acs_only",
                                                               if only
                                                               pre-authorization
                                                               testing HTTP
                                                               authentication
                                                               may be used, or

                                                           +o   "yes" or "both"
                                                               if either
                                                               mechanism may
                                                               be used.
                                                               Refer to
                                                               [34m[1mHTTP_AUTH[0m[1m[22m[44]
                                                               for additional
                                                               details.

                                                           HTTP_PROG
                                                           (Required1)
                                                               The full
                                                               pathname of the
                                                               executable
                                                               [34m[1mdacshttp(1)[0m[1m[22m[4]
                                                               program, a
                                                               utility
                                                               distributed
                                                               with [1mDACS[22m. This
                                                               program is used
                                                               by [1mDACS[0m
                                                               components to
                                                               invoke local
                                                               services,
                                                               optionally
                                                               using SSL.

                                                           INFOCARD_AUDIENCE
                                                           (Optional)
                                                               This directive
                                                               must be
                                                               configured for
                                                               [1mDACS [22mto
                                                               function as a
                                                               Relying Party.
                                                               When [1mDACS [22macts
                                                               as a Relying
                                                               Party, each of
                                                               these
                                                               directives is
                                                               applied to the
                                                               value of an
                                                               Audience
                                                               element (a URI)
                                                               in a secure
                                                               token's
                                                               AudienceRestrictionCondition
                                                               element until a
                                                               successful
                                                               match is found.
                                                               Several
                                                               matching
                                                               functions are
                                                               available using
                                                               the following
                                                               syntax:

                                                                   [4mfunction[24m [[4mspace[24m+ [4marg-to-match-against-Audience[24m]


                                                               [4mfunction[24m is
                                                               case
                                                               insensitive.

                                                               uri [4mmatch-URI[0m
                                                                   The
                                                                   [4mmatch-URI[0m
                                                                   is compared
                                                                   with the
                                                                   entire
                                                                   Audience
                                                                   URI for an
                                                                   exact URI
                                                                   match. URI
                                                                   matching
                                                                   syntax is
                                                                   used,
                                                                   meaning
                                                                   that only
                                                                   the scheme
                                                                   and
                                                                   hostname
                                                                   components
                                                                   are case
                                                                   insensitive.

                                                                       INFOCARD_AUDIENCE "uri http://DACS.DSS.CA/infocard-demo"


                                                               any
                                                                   Any
                                                                   Audience is
                                                                   acceptable.

                                                                       INFOCARD_AUDIENCE "any"


                                                               regex
                                                               [4mmatch-regex[0m
                                                               regex/[4mflags[0m
                                                               [4mmatch-regex[0m
                                                                   In the
                                                                   first form,
                                                                   the regular
                                                                   expression
                                                                   [4mmatch-regex[0m
                                                                   is matched
                                                                   (unanchored)
                                                                   against the
                                                                   Audience
                                                                   URI. In the
                                                                   second
                                                                   form, one
                                                                   or more
                                                                   flags can
                                                                   precede the
                                                                   regular
                                                                   expression:
                                                                   'i'
                                                                   specifies
                                                                   case-insensitive
                                                                   matching
                                                                   and 'e'
                                                                   specifies
                                                                   "extended"
                                                                   regular
                                                                   expressions
                                                                   rather than
                                                                   the default
                                                                   "basic"
                                                                   regular
                                                                   expressions.
                                                                   IEEE Std
                                                                   1003.2
                                                                   ("POSIX.2")
                                                                   regular
                                                                   expressions
                                                                   are
                                                                   supported
                                                                   ([34m[1mregex(3)[0m[1m[22m[89]).

                                                                       INFOCARD_AUDIENCE "regex/i ^https://dacs.dss.ca:8443"

                                                                   The
                                                                   following
                                                                   directives
                                                                   are
                                                                   equivalent:

                                                                       INFOCARD_AUDIENCE "regex .*"
                                                                       INFOCARD_AUDIENCE "any"


                                                               host
                                                               [4mmatch-hostname[0m
                                                                   The
                                                                   [4mmatch-hostname[24m,
                                                                   which may
                                                                   be a domain
                                                                   name or an
                                                                   IP address,
                                                                   is matched
                                                                   case-insensitively
                                                                   against the
                                                                   host name
                                                                   in the
                                                                   Audience
                                                                   URI.

                                                                       INFOCARD_AUDIENCE "host dacs.dss.ca"


                                                               prefix
                                                               [4mmatch-URI[0m
                                                                   The
                                                                   [4mmatch-URI[0m
                                                                   is matched
                                                                   against the
                                                                   Audience
                                                                   URI to test
                                                                   if the
                                                                   former is a
                                                                   prefix of
                                                                   the latter.
                                                                   The
                                                                   case-sensitivity
                                                                   rules for
                                                                   URI
                                                                   components
                                                                   is
                                                                   respected
                                                                   (e.g., the
                                                                   scheme and
                                                                   host name
                                                                   components
                                                                   are treated
                                                                   case-insensitively,
                                                                   but the
                                                                   path
                                                                   components
                                                                   are not).

                                                                       INFOCARD_AUDIENCE "prefix https://dacs.dss.ca/infocards"



                                                           INFOCARD_AUDIENCE_RESTRICTION
                                                           (Optional)
                                                               Used by
                                                               [34m[1mdacs_sts(8)[0m[1m[22m[90],
                                                               this optional
                                                               directive
                                                               specifies the
                                                               value of an
                                                               Audience
                                                               element in an
                                                               AudienceRestrictionCondition.

                                                           INFOCARD_CARD_DATETIME_EXPIRES
                                                           (Optional1)
                                                               This optional
                                                               directive
                                                               specifies the
                                                               date and time
                                                               of expiration
                                                               for a managed
                                                               InfoCard
                                                               created by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91].
                                                               The XML Schema
                                                               [1mdateTime [22mformat
                                                               must be used
                                                               (see [34m[1mXML Schema[0m
                                                               [1m[34mPart 2:[0m
                                                               [1m[34mDatatypes[0m
                                                               [1m[34mSecond[0m
                                                               [1m[34mEdition[0m[1m[22m[92]);
                                                               e.g.,

                                                                   INFOCARD_CARD_DATETIME_EXPIRES "2010-06-15T09:46:31-08:00"

                                                               Also see
                                                               [34m[1mINFOCARD_CARD_LIFETIME_SECS[0m[1m[22m[93].

                                                           INFOCARD_CARD_DEFS_URL
                                                           (Optional1)
                                                               This optional
                                                               directive is
                                                               used by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91]
                                                               to specify a
                                                               web service
                                                               that defines
                                                               the claims
                                                               supported by a
                                                               new managed
                                                               InfoCard. If it
                                                               is not defined,
                                                               the default
                                                               claim
                                                               dacs_identity
                                                               is used. To
                                                               prevent abuse,
                                                               arbitrary
                                                               compile-time
                                                               limits are
                                                               imposed on the
                                                               number of
                                                               claims (20) and
                                                               the lengths of
                                                               various claim
                                                               components:
                                                               name (32
                                                               bytes), value
                                                               (64 bytes), URI
                                                               prefix (128
                                                               bytes), label
                                                               (20 bytes), and
                                                               description (40
                                                               bytes). (These
                                                               limits should
                                                               be run-time
                                                               configurable.)
                                                               The
                                                               distribution's
                                                               infocard
                                                               directory
                                                               includes an
                                                               example
                                                               program,
                                                               [1mdemo_card_defs.php[22m,
                                                               which documents
                                                               the program's
                                                               arguments and
                                                               output syntax.

                                                           INFOCARD_CARD_FILL_URL
                                                           (Optional1)
                                                               This optional
                                                               directive is
                                                               used by
                                                               [34m[1mdacs_sts(8)[0m[1m[22m[90]
                                                               to specify a
                                                               web service
                                                               that retrieves
                                                               the values of
                                                               claims
                                                               requested by a
                                                               Relying Party.
                                                               If it is not
                                                               defined, only
                                                               the value of
                                                               the default
                                                               claim
                                                               dacs_identity
                                                               is available.
                                                               Access to this
                                                               web service
                                                               must be
                                                               appropriately
                                                               restricted and
                                                               secured,
                                                               although it
                                                               does not need
                                                               to be
                                                               [1mDACS[22m-wrapped.
                                                               It is passed
                                                               special [1mDACS[0m
                                                               credentials (as
                                                               an HTTP
                                                               cookie). The
                                                               distribution's
                                                               infocard
                                                               directory
                                                               includes an
                                                               example
                                                               program,
                                                               [1mdemo_fill_claims.php[22m,
                                                               which documents
                                                               the program's
                                                               arguments and
                                                               output syntax.

                                                           INFOCARD_CARD_IMAGE_BASE_URL
                                                           (Required1-C)
                                                               This directive
                                                               is required by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91].
                                                               It is the
                                                               initial part of
                                                               a [1mDACS [34mVFS[0m
                                                               [1m[34mURI[0m[1m[22m[94] from
                                                               which image
                                                               files for
                                                               managed
                                                               InfoCards can
                                                               be retrieved.
                                                               The general
                                                               idea is that
                                                               the particular
                                                               image
                                                               associated with
                                                               a card depends
                                                               on the STS
                                                               authentication
                                                               credential that
                                                               is used by the
                                                               card. For
                                                               example, the
                                                               configuration
                                                               variable
                                                               [4minfocard_card_image_passwd[24m,
                                                               if set,
                                                               specifies the
                                                               filename
                                                               (relative to
                                                               INFOCARD_CARD_IMAGE_BASE_URL)
                                                               of an image
                                                               associated with
                                                               InfoCards that
                                                               use the
                                                               username/password
                                                               type of
                                                               authentication
                                                               between its
                                                               owner and the
                                                               STS; if
                                                               unspecified, a
                                                               compile-time
                                                               default
                                                               (dacs_username_password_credential.png)
                                                               is used.
                                                               Similarly, the
                                                               variables
                                                               [4minfocard_card_image_cert[0m
                                                               (default value:
                                                               dacs_x509certificate_credential.png)
                                                               and
                                                               [4minfocard_card_image_card[0m
                                                               (default value:
                                                               dacs_selfissued_credential.png)
                                                               specify
                                                               filenames for
                                                               images
                                                               associated with
                                                               the X.509 V3
                                                               certificate
                                                               credential type
                                                               and the
                                                               self-issued
                                                               InfoCard
                                                               credential
                                                               type,
                                                               respectively.
                                                               The value of
                                                               INFOCARD_CARD_IMAGE_BASE_URL
                                                               is typically
                                                               the absolute
                                                               pathname of a
                                                               directory
                                                               containing the
                                                               image files or
                                                               the initial
                                                               part of a URL
                                                               to which a
                                                               final path
                                                               component will
                                                               be appended.
                                                               Also see the
                                                               [34m[1mCARD_IMAGE_URL[0m[1m[22m[95]
                                                               argument to
                                                               [1mdacs_managed_infocard[22m.

                                                               An image should
                                                               be in the range
                                                               of 60 pixels
                                                               wide by 45
                                                               pixels high and
                                                               200 pixels wide
                                                               by 150 pixels
                                                               high. Only
                                                               certain image
                                                               formats are
                                                               allowed by the
                                                               specification;
                                                               the image
                                                               format is
                                                               deduced from
                                                               the filename
                                                               extension (case
                                                               insensitively):
                                                               ".png", ".gif",
                                                               ".tiff" (or
                                                               ".tif"),
                                                               ".bmp", and
                                                               ".jpeg" (or
                                                               ".jpg"). If the
                                                               format cannot
                                                               be deduced, PNG
                                                               is assumed.

                                                           INFOCARD_CARD_LIFETIME_SECS
                                                           (Optional1)
                                                               If
                                                               INFOCARD_CARD_DATETIME_EXPIRES
                                                               is not defined,
                                                               the expiration
                                                               date and time
                                                               of a managed
                                                               InfoCard
                                                               created by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91]
                                                               can be
                                                               specified
                                                               relative to the
                                                               current time as
                                                               this many
                                                               seconds. If
                                                               neither this
                                                               directive nor
                                                               INFOCARD_CARD_DATETIME_EXPIRES
                                                               is defined, a
                                                               compile-time
                                                               default
                                                               lifetime is
                                                               used
                                                               (currently, 365
                                                               days). Also see
                                                               [34m[1mINFOCARD_CARD_DATETIME_EXPIRES[0m[1m[22m[96].

                                                           INFOCARD_CARD_OUTPUTDIR
                                                           (Optional1)
                                                               If a managed
                                                               InfoCard
                                                               generated by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91]
                                                               is stored in a
                                                               file, it is
                                                               written to this
                                                               directory. The
                                                               name of the
                                                               file is of the
                                                               form
                                                               [4musername[24m_[4mrandom[24m.crd.
                                                               See
                                                               [34m[1mINFOCARD_CARDID_BASE_URL[0m[1m[22m[97].

                                                           INFOCARD_CARD_VERSION
                                                           (Optional1)
                                                               This directive
                                                               is used by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91]
                                                               to provide a
                                                               value for the
                                                               CardVersion
                                                               element in a
                                                               managed
                                                               InfoCard. The
                                                               default is "1".

                                                           INFOCARD_CARDID_BASE_URL
                                                           (Required1-C)
                                                               This directive
                                                               is required by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91].
                                                               It is used as
                                                               the base URL
                                                               for the CardId
                                                               of a new
                                                               managed
                                                               InfoCard. If
                                                               this URL is set
                                                               so that it
                                                               points into the
                                                               directory
                                                               specified by
                                                               [34m[1mINFOCARD_CARD_OUTPUTDIR[0m[1m[22m[98],
                                                               then the
                                                               resulting
                                                               CardId URLs can
                                                               be used to
                                                               fetch the card
                                                               by its owner,
                                                               assuming
                                                               appropriate
                                                               access control
                                                               rules are also
                                                               configured.
                                                               Also see
                                                               [34m[1mINFOCARD_CARDID_SUFFIX[0m[1m[22m[99].

                                                           INFOCARD_CARDID_SUFFIX
                                                           (Optional1)
                                                               This optional
                                                               directive is
                                                               used by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91]
                                                               and specifies a
                                                               string to be
                                                               appended as a
                                                               final path
                                                               element to the
                                                               value of
                                                               [34m[1mINFOCARD_CARDID_BASE_URL[0m[1m[22m[97]
                                                               to form a new
                                                               card's CardId.
                                                               If the value of
                                                               INFOCARD_CARDID_SUFFIX
                                                               is:

                                                               identity
                                                                   The
                                                                   specified
                                                                   or implied
                                                                   identity
                                                                   assigned to
                                                                   the card is
                                                                   interpolated;
                                                                   this is the
                                                                   default.

                                                               username
                                                                   The
                                                                   specified
                                                                   or implied
                                                                   username
                                                                   assigned to
                                                                   the card is
                                                                   interpolated.

                                                               random
                                                                   A
                                                                   safely-encoded
                                                                   20-byte
                                                                   random
                                                                   string is
                                                                   interpolated.

                                                               default
                                                                   The default
                                                                   is used
                                                                   ("identity").

                                                               If the value of
                                                               INFOCARD_CARDID_SUFFIX
                                                               does not match
                                                               (case-insensitively)
                                                               any of these
                                                               strings, it is
                                                               interpolated
                                                               verbatim.
                                                               Regardless of
                                                               how it was
                                                               derived, the
                                                               result string
                                                               must be a
                                                               syntactically
                                                               valid URI path
                                                               segment ([34m[1mRFC[0m
                                                               [1m[34m2396[0m[1m[22m[100]).

                                                           INFOCARD_DIGEST
                                                           (Optional1)
                                                               The name of the
                                                               hash algorithm
                                                               to use in
                                                               account files
                                                               for self-issued
                                                               InfoCard-based
                                                               authentication
                                                               (see
                                                               [34m[1mdacs_infocard(8)[0m[1m[22m[101]).
                                                               The syntax is
                                                               the same as for
                                                               the
                                                               [34m[1mPASSWORD_DIGEST[0m[1m[22m[102]
                                                               directive. The
                                                               default is
                                                               "SHA256".

                                                           INFOCARD_IP_PRIVACY_URL
                                                           (Required1-C)
                                                               This directive
                                                               is required by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91]
                                                               and specifies
                                                               the URL of the
                                                               Identity
                                                               Provider's
                                                               PrivacyNotice.
                                                               A default
                                                               notice is
                                                               configured.

                                                           INFOCARD_IP_PRIVACY_VERSION
                                                           (Optional1)
                                                               This optional
                                                               directive is
                                                               used by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91]
                                                               and specifies
                                                               an integer
                                                               version number
                                                               (greater than
                                                               zero) of the
                                                               document
                                                               returned by the
                                                               [34m[1mINFOCARD_IP_PRIVACY_URL[0m[1m[22m[103].
                                                               If it is set to
                                                               the empty
                                                               string,
                                                               however, no
                                                               version number
                                                               will be
                                                               specified for
                                                               the
                                                               PrivacyNotice.
                                                               The default is
                                                               "1".

                                                           INFOCARD_ISSUER_INFO_ENTRY
                                                           (Optional)
                                                               This optional
                                                               directive,
                                                               which may be
                                                               repeated, is
                                                               used by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91]
                                                               to specify
                                                               arbitrary
                                                               descriptive
                                                               information to
                                                               be included in
                                                               managed
                                                               InfoCards. This
                                                               information may
                                                               be displayed by
                                                               an Identity
                                                               Selector. The
                                                               value of the
                                                               directive is a
                                                               string of the
                                                               form
                                                               "[4mEntryName[24m:[4mEntryValue[24m".

                                                           INFOCARD_MEX_URL
                                                           (Required1-C)
                                                               This directive,
                                                               used by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91],
                                                               specifies the
                                                               URL of the
                                                               WS-MetadataExchange
                                                               responder for
                                                               managed
                                                               InfoCards. Also
                                                               see
                                                               [34m[1mdacs_mex(8)[0m[1m[22m[104].

                                                           INFOCARD_REQUIRE_APPLIES_TO
                                                           (Optional1)
                                                               Used optionally
                                                               by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91],
                                                               this directive
                                                               controls a
                                                               managed
                                                               InfoCard's
                                                               RequireAppliesTo
                                                               element, which
                                                               by default is
                                                               omitted. This
                                                               element is used
                                                               to control
                                                               whether the
                                                               card's Identity
                                                               Provider (e.g.,
                                                               [34m[1mdacs_sts(8)[0m[1m[22m[90])
                                                               will be
                                                               informed as to
                                                               the identity of
                                                               the Relying
                                                               Party via the
                                                               wsp:AppliesTo
                                                               element (when
                                                               it is informed,
                                                               it is called an
                                                               [4mauditing[24m [4mcard[24m,
                                                               which is used
                                                               in [4mauditing[0m
                                                               [4mmode[24m).
                                                               Following the
                                                               Identity
                                                               Selector
                                                               Interoperability
                                                               Profile, this
                                                               directive may
                                                               have any of the
                                                               following
                                                               values:

                                                               no
                                                                   The
                                                                   RequireAppliesTo
                                                                   element is
                                                                   omitted
                                                                   (called a
                                                                   [4mnon-auditing[0m
                                                                   [4mcard[24m).

                                                               yes
                                                                   RequireAppliesTo
                                                                   is emitted,
                                                                   but with
                                                                   its
                                                                   optional
                                                                   attribute
                                                                   omitted (an
                                                                   [4mauditing[0m
                                                                   [4mcard[24m).

                                                               true
                                                                   RequireAppliesTo
                                                                   is emitted
                                                                   with the
                                                                   attribute
                                                                   Optional="true"
                                                                   (called an
                                                                   [4mauditing-optional[0m
                                                                   [4mcard[24m).

                                                               false
                                                                   RequireAppliesTo
                                                                   is emitted
                                                                   with the
                                                                   attribute
                                                                   Optional="false"
                                                                   (an
                                                                   [4mauditing[0m
                                                                   [4mcard[24m).


                                                           INFOCARD_STRONG_RP_IDENTITY
                                                           (Optional1)
                                                               Used optionally
                                                               by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91],
                                                               if the value of
                                                               this directive
                                                               is "yes"
                                                               RequireStrongRecipientIdentity
                                                               is present in
                                                               new managed
                                                               InfoCards,
                                                               which indicates
                                                               that a Relying
                                                               Party must use
                                                               a
                                                               cryptographically
                                                               protected
                                                               identity; i.e.,
                                                               an X.509 server
                                                               certificate.

                                                           INFOCARD_STS_AUTH_TYPE
                                                           (Required1-C)
                                                               This directive,
                                                               required by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91],
                                                               specifies
                                                               (case-insensitively)
                                                               the
                                                               authentication
                                                               credential
                                                               type, which
                                                               identifies an
                                                               Identity
                                                               Selector user
                                                               to an IP/STS
                                                               (see
                                                               [34m[1mdacs_sts(8)[0m[1m[22m[90]).
                                                               The value of
                                                               this directive
                                                               is consulted
                                                               when a new
                                                               managed
                                                               InfoCard is
                                                               created; the
                                                               type may be
                                                               changed without
                                                               affecting the
                                                               authentication
                                                               credential type
                                                               assigned to
                                                               InfoCards
                                                               created before
                                                               the change.
                                                               Recognized
                                                               values are:

                                                               password
                                                               passwd
                                                                   This is the
                                                                   username/password
                                                                   credential
                                                                   type. See
                                                                   [34m[1mINFOCARD_STS_PASSWORD_METHOD[0m[1m[22m[105].

                                                               cert
                                                                   This is the
                                                                   X.509 V3
                                                                   certificate
                                                                   credential
                                                                   type. An
                                                                   SSL client
                                                                   certificate
                                                                   must be
                                                                   used with
                                                                   the request
                                                                   to
                                                                   [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91]
                                                                   for a
                                                                   managed
                                                                   InfoCard,
                                                                   and the
                                                                   same
                                                                   certificate
                                                                   must be
                                                                   used when
                                                                   the managed
                                                                   InfoCard is
                                                                   submitted
                                                                   to a
                                                                   Relying
                                                                   Party. A
                                                                   self-signed
                                                                   certificate
                                                                   may be
                                                                   used.

                                                               card
                                                                   This is the
                                                                   self-issued
                                                                   credential
                                                                   type. A
                                                                   self-issued
                                                                   InfoCard
                                                                   must be
                                                                   submitted
                                                                   with the
                                                                   request to
                                                                   [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91]
                                                                   for a
                                                                   managed
                                                                   InfoCard,
                                                                   and the
                                                                   same
                                                                   self-issued
                                                                   InfoCard
                                                                   must be
                                                                   available
                                                                   to the
                                                                   user's
                                                                   Identity
                                                                   Selector
                                                                   when the
                                                                   managed
                                                                   InfoCard is
                                                                   submitted
                                                                   to a
                                                                   Relying
                                                                   Party. This
                                                                   self-issued
                                                                   InfoCard
                                                                   does not
                                                                   need to be
                                                                   separately
                                                                   registered
                                                                   using
                                                                   [34m[1mdacs_infocard(8)[0m[1m[22m[101].

                                                               kerberos
                                                                   This is the
                                                                   Kerberos V5
                                                                   credential
                                                                   type. This
                                                                   authentication
                                                                   credential
                                                                   type is
                                                                   currently
                                                                   unsupported.


                                                                   [1mNote[0m
                                                                   Although
                                                                   the
                                                                   specification
                                                                   allows an
                                                                   ordered
                                                                   list of STS
                                                                   endpoints
                                                                   to appear,
                                                                   at present
                                                                   only a
                                                                   single
                                                                   endpoint
                                                                   may be
                                                                   configured.

                                                           INFOCARD_STS_CACERTFILE
                                                           (Required1-C)
                                                               This directive,
                                                               which is
                                                               required by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91],
                                                               specifies the
                                                               filename of the
                                                               certificate
                                                               authority's
                                                               PEM-encoded
                                                               X.509
                                                               certificate for
                                                               [34m[1mINFOCARD_STS_CERTFILE[0m[1m[22m[106].

                                                                   [1mNote[0m
                                                                   File
                                                                   permissions
                                                                   and
                                                                   ownership
                                                                   must be set
                                                                   appropriately
                                                                   to allow
                                                                   run-time
                                                                   access.

                                                           INFOCARD_STS_CERTFILE
                                                           (Required1-C)
                                                               This directive,
                                                               which is
                                                               required by
                                                               [34m[1mdacsinfocard(1)[0m[1m[22m[107],
                                                               [34m[1mdacs_infocard(8)[0m[1m[22m[101],
                                                               and
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91],
                                                               specifies the
                                                               filename of the
                                                               PEM-encoded
                                                               X.509
                                                               certificate for
                                                               the Secure
                                                               Token Service
                                                               provided by
                                                               [34m[1mdacs_sts(8)[0m[1m[22m[90].

                                                                   [1mNote[0m
                                                                   File
                                                                   permissions
                                                                   and
                                                                   ownership
                                                                   must be set
                                                                   appropriately
                                                                   to allow
                                                                   run-time
                                                                   access. If
                                                                   a
                                                                   self-signed
                                                                   certificate
                                                                   is being
                                                                   used, the
                                                                   appropriate
                                                                   root
                                                                   certificate
                                                                   must be
                                                                   installed
                                                                   on the
                                                                   system that
                                                                   is running
                                                                   the
                                                                   Identity
                                                                   Selector.

                                                           INFOCARD_STS_KEYFILE
                                                           (Required1-C)
                                                               This directive,
                                                               which is
                                                               required by
                                                               [34m[1mdacsinfocard(1)[0m[1m[22m[107],
                                                               [34m[1mlocal_infocard_authenticate[0m[1m[22m[108],
                                                               [34m[1mdacs_infocard(8)[0m[1m[22m[101],
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91],
                                                               and
                                                               [34m[1mdacs_sts(8)[0m[1m[22m[90],
                                                               specifies the
                                                               filename of the
                                                               key for the
                                                               X.509
                                                               certificate
                                                               specified by
                                                               INFOCARD_STS_CERTFILE.
                                                               If this file is
                                                               password
                                                               protected,
                                                               [34m[1mINFOCARD_STS_KEYFILE_PASSWORD[0m[1m[22m[109]
                                                               must be
                                                               configured.

                                                                   [1mNote[0m
                                                                   File
                                                                   permissions
                                                                   and
                                                                   ownership
                                                                   must be set
                                                                   appropriately
                                                                   to allow
                                                                   run-time
                                                                   access.

                                                           INFOCARD_STS_KEYFILE_PASSWORD
                                                           (Required1-C)
                                                               If
                                                               [34m[1mINFOCARD_STS_KEYFILE[0m[1m[22m[110]
                                                               is encrypted,
                                                               this directive
                                                               is required to
                                                               specify the
                                                               password.

                                                           INFOCARD_STS_PASSWORD_METHOD
                                                           (Required1-C)
                                                               If the
                                                               username/password
                                                               credential type
                                                               is needed by a
                                                               managed
                                                               InfoCard,
                                                               [34m[1mdacs_sts(8)[0m[1m[22m[90]
                                                               requires this
                                                               directive to
                                                               specify how the
                                                               username and
                                                               password are to
                                                               be validated:

                                                               empty
                                                                   The
                                                                   password is
                                                                   no password
                                                                   at all
                                                                   (i.e., the
                                                                   empty
                                                                   string). If
                                                                   a password
                                                                   [4mis[24m given,
                                                                   authentication
                                                                   will fail.

                                                               ignore
                                                                   Any
                                                                   password
                                                                   string,
                                                                   including
                                                                   no password
                                                                   at all
                                                                   (i.e., the
                                                                   empty
                                                                   string), is
                                                                   acceptable.

                                                               sts
                                                                   The given
                                                                   password
                                                                   string must
                                                                   exactly
                                                                   match the
                                                                   authentication-time
                                                                   value of
                                                                   the
                                                                   configuration
                                                                   variable
                                                                   [4minfocard_sts_password[24m.

                                                               account:[4mid[0m
                                                                   The given
                                                                   username
                                                                   and
                                                                   password
                                                                   must be
                                                                   valid
                                                                   relative to
                                                                   the
                                                                   specified
                                                                   [1mDACS[0m
                                                                   authentication
                                                                   module
                                                                   identified
                                                                   by the Auth
                                                                   clause
                                                                   label [4mid[24m,
                                                                   which must
                                                                   be enabled
                                                                   and
                                                                   configured
                                                                   as per
                                                                   [34m[1mdacs_authenticate(8)[0m[1m[22m[50].
                                                                   (Note: [4mThis[0m
                                                                   [4mform[24m [4mis[0m
                                                                   [4mcurrently[0m
                                                                   [4munsupported[24m.)


                                                           INFOCARD_STS_RP_ENDPOINT
                                                           (Optional)
                                                               This directive
                                                               causes
                                                               [34m[1mdacs_sts(8)[0m[1m[22m[90]
                                                               to issue
                                                               security tokens
                                                               only to
                                                               selected
                                                               identified
                                                               Relying
                                                               Parties; if the
                                                               identity of a
                                                               Relying Party,
                                                               as provided by
                                                               the Address
                                                               endpoint
                                                               appearing in
                                                               the token
                                                               request's
                                                               AppliesTo
                                                               element
                                                               (apparently the
                                                               URL of the
                                                               Relying Party's
                                                               web page) does
                                                               not match any
                                                               instance of
                                                               this directive,
                                                               a token will
                                                               not be
                                                               returned. A
                                                               token will be
                                                               returned if
                                                               this directive
                                                               is not used or
                                                               if the Relying
                                                               Party is not
                                                               identified. Not
                                                               all Relying
                                                               Parties are
                                                               identified; see
                                                               [34m[1mINFOCARD_REQUIRE_APPLIES_TO[0m[1m[22m[111].
                                                               The syntax for
                                                               this directive
                                                               is identical to
                                                               that of
                                                               [34m[1mINFOCARD_AUDIENCE[0m[1m[22m[112].
                                                               Although the
                                                               Relying Party's
                                                               server
                                                               certificate can
                                                               be provided
                                                               with the
                                                               identification
                                                               material in the
                                                               token request,
                                                               it is not
                                                               currently
                                                               accessible to
                                                               this directive.

                                                           INFOCARD_STS_URL
                                                           (Required1-C)
                                                               This directive,
                                                               used by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91],
                                                               [34m[1mdacs_mex(8)[0m[1m[22m[104],
                                                               and
                                                               [34m[1mdacs_sts(8)[0m[1m[22m[90],
                                                               specifies the
                                                               URL of the
                                                               Secure Token
                                                               Service for
                                                               managed
                                                               InfoCards.

                                                           INFOCARD_TOKEN_DRIFT_SECS
                                                           (Optional1)
                                                               A security
                                                               token (produced
                                                               by
                                                               [34m[1mdacs_sts(8)[0m[1m[22m[90],
                                                               for instance)
                                                               bears a
                                                               validity
                                                               condition; a
                                                               relying party
                                                               may reject a
                                                               token if its
                                                               current system
                                                               date/time lies
                                                               outside of the
                                                               time window
                                                               prescribed by
                                                               the token.
                                                               Because the
                                                               clock at the
                                                               IP/STS (which
                                                               issued the
                                                               token) and the
                                                               clock at the
                                                               relying party
                                                               may not be
                                                               closely
                                                               synchronized -
                                                               the relying
                                                               party's clock
                                                               may be faster
                                                               or slower than
                                                               the IP/STS's
                                                               clock - a
                                                               relying party
                                                               may be willing
                                                               to permit a
                                                               certain amount
                                                               of "clock
                                                               drift" before
                                                               it rejects a
                                                               token. This
                                                               directive
                                                               specifies the
                                                               maximum number
                                                               of seconds that
                                                               the IP/STS's
                                                               clock may be
                                                               too fast or too
                                                               slow. If the
                                                               directive's
                                                               value is zero,
                                                               or if the
                                                               directive is
                                                               not configured,
                                                               a compile time
                                                               default value
                                                               is used
                                                               (currently, 300
                                                               seconds). If
                                                               the directive's
                                                               value is
                                                               "disable", the
                                                               validity test
                                                               is suppressed.

                                                           INFOCARD_TOKEN_ISSUER
                                                           (Required1-C)
                                                               This directive,
                                                               used by
                                                               [34m[1mdacs_managed_infocard(8)[0m[1m[22m[91]
                                                               and
                                                               [34m[1mdacs_sts(8)[0m[1m[22m[90],
                                                               specifies the
                                                               Issuer of a
                                                               managed
                                                               InfoCard as a
                                                               URI. The value
                                                               "self" can be
                                                               used to
                                                               represent the
                                                               special URI
                                                               identifying a
                                                               self-issued
                                                               InfoCard.

                                                                   [1mNote[0m
                                                                   If your
                                                                   Identity
                                                                   Selector
                                                                   does not
                                                                   let you
                                                                   choose a
                                                                   managed
                                                                   InfoCard
                                                                   when you
                                                                   think that
                                                                   it ought to
                                                                   (i.e., the
                                                                   value of
                                                                   this
                                                                   directive
                                                                   in effect
                                                                   when the
                                                                   managed
                                                                   InfoCard
                                                                   was created
                                                                   matches the
                                                                   web page's
                                                                   issuer
                                                                   parameter),
                                                                   it seems
                                                                   that the
                                                                   INFOCARD_TOKEN_ISSUER
                                                                   is ignored
                                                                   by an
                                                                   Identity
                                                                   Selector in
                                                                   preference
                                                                   to the name
                                                                   in the
                                                                   Identity
                                                                   Provider's
                                                                   SSL
                                                                   certificate.
                                                                   It has been
                                                                   noted that
                                                                   if a
                                                                   Relying
                                                                   Party uses
                                                                   a [34m[1mwildcard[0m
                                                                   [1m[34mcertificate[0m[1m[22m[113],
                                                                   an Identity
                                                                   Selector
                                                                   may have
                                                                   trouble
                                                                   matching
                                                                   the [4missuer[0m
                                                                   parameter
                                                                   in an HTML
                                                                   OBJECT
                                                                   request
                                                                   with an
                                                                   InfoCard;
                                                                   it may be
                                                                   necessary
                                                                   for the
                                                                   Relying
                                                                   Party to
                                                                   specify the
                                                                   value of
                                                                   the [4missuer[0m
                                                                   parameter
                                                                   as the
                                                                   empty
                                                                   string.

                                                           INFOCARD_TOKEN_LIFETIME_SECS
                                                           (Optional1)
                                                               This optional
                                                               directive
                                                               specifies the
                                                               lifetime, in
                                                               seconds, of a
                                                               secure token
                                                               created by
                                                               [34m[1mdacs_sts(8)[0m[1m[22m[90].
                                                               If not
                                                               provided, a
                                                               compile-time
                                                               value is used.
                                                               To reduce the
                                                               window of
                                                               vulnerability
                                                               where a token
                                                               might be
                                                               captured and
                                                               used by an
                                                               attacker, this
                                                               period should
                                                               be relatively
                                                               short (on the
                                                               order of a few
                                                               seconds). Note
                                                               that a Relying
                                                               Party is free
                                                               to account for
                                                               inadequately
                                                               synchronized
                                                               clocks when
                                                               deciding
                                                               whether it
                                                               should accept a
                                                               token, so this
                                                               lifetime is
                                                               effectively a
                                                               recommendation
                                                               for the
                                                               recipient of
                                                               the token. If
                                                               the clocks at
                                                               the Identity
                                                               Selector and
                                                               token issuer
                                                               are not
                                                               sufficiently
                                                               synchronized,
                                                               the Identity
                                                               Selector will
                                                               reject a token
                                                               if the token's
                                                               validity window
                                                               is outside of
                                                               its clock's
                                                               current value.

                                                           INFOCARD_TOKEN_MAX_LENGTH
                                                           (Optional1)
                                                               A relying party
                                                               can use this
                                                               directive to
                                                               specify the
                                                               maximum size
                                                               (in bytes) of a
                                                               security token
                                                               that it will
                                                               accept. If this
                                                               directive is
                                                               not configured
                                                               or is zero, a
                                                               compile time
                                                               default value
                                                               is used
                                                               (currently,
                                                               16384 bytes).

                                                           INFOCARD_USERNAME_SELECTOR
                                                           (Optional1)
                                                               This directive
                                                               determines how
                                                               the [1mDACS[0m
                                                               username is
                                                               selected for a
                                                               self-issued
                                                               InfoCard during
                                                               registration by
                                                               [34m[1mdacs_infocard(8)[0m[1m[22m[101].
                                                               The resulting
                                                               identity is
                                                               relative to the
                                                               [34m[1mcurrent[0m
                                                               [1m[34mjurisdiction[0m[1m[22m[46];
                                                               that is, if the
                                                               InfoCard is
                                                               used to sign on
                                                               at a
                                                               jurisdiction
                                                               where it was
                                                               registered, the
                                                               jurisdiction
                                                               will issue
                                                               credentials for
                                                               the username
                                                               that was
                                                               registered with
                                                               the InfoCard.
                                                               The following
                                                               directive
                                                               values are
                                                               recognized:

                                                               credentials
                                                                   The
                                                                   username is
                                                                   obtained
                                                                   from the
                                                                   identity in
                                                                   effect at
                                                                   registration
                                                                   time; there
                                                                   may only be
                                                                   one such
                                                                   set of
                                                                   credentials
                                                                   and they
                                                                   must have
                                                                   been issued
                                                                   by the
                                                                   jurisdiction
                                                                   at which
                                                                   registration
                                                                   is
                                                                   occurring.
                                                                   This is the
                                                                   default
                                                                   behaviour
                                                                   if the
                                                                   directive
                                                                   is not
                                                                   given.

                                                               email
                                                                   The
                                                                   username is
                                                                   obtained
                                                                   from the
                                                                   email
                                                                   address
                                                                   field of
                                                                   the
                                                                   InfoCard;
                                                                   the email
                                                                   address
                                                                   must be a
                                                                   syntactically
                                                                   valid
                                                                   username
                                                                   (see
                                                                   [34m[1mdacs(1)[0m[1m[22m[76]).

                                                               webpage
                                                                   The
                                                                   username is
                                                                   derived
                                                                   from the
                                                                   web page
                                                                   URL field
                                                                   of the
                                                                   InfoCard;
                                                                   this is not
                                                                   currently
                                                                   implemented.
                                                                   (see
                                                                   [34m[1mdacs(1)[0m[1m[22m[76]).


                                                           JURISDICTION_NAME
                                                           (Required1)
                                                               The name of the
                                                               jurisdiction.
                                                               The syntax is
                                                               the same as for
                                                               [34m[1mFEDERATION_NAME[0m[1m[22m[55]:
                                                               an alphabetic
                                                               followed by
                                                               zero or more
                                                               alphanumerics,
                                                               '-' (hyphens),
                                                               or '_'
                                                               (underscores).
                                                               Note that
                                                               periods are not
                                                               permitted. By
                                                               convention,
                                                               this name is in
                                                               all-caps,
                                                               Please see
                                                               [34m[1mdacs(1)[0m[1m[22m[76] for
                                                               additional
                                                               information.
                                                               Example:
                                                               METALOGIC

                                                           LOGINGEN_FILE
                                                           (Optional1)
                                                               Reserved for
                                                               future use.
                                                               (Used with the
                                                               [1mDACS logingen[0m
                                                               utility, this
                                                               directive gives
                                                               the full
                                                               pathname of the
                                                               template file.)

                                                           LOGINGEN_PROG
                                                           (Optional1)
                                                               Reserved for
                                                               future use.
                                                               (Used with the
                                                               [1mDACS logingen[0m
                                                               utility, this
                                                               directive
                                                               specifies a
                                                               program which
                                                               will read
                                                               LOGINGEN_FILE
                                                               on its stdin
                                                               and write the
                                                               filtered output
                                                               to stdout.)

                                                           LOG_FILE
                                                           (Optional1)
                                                               [1mDACS [22muses the
                                                               LOG_FILE
                                                               directive to
                                                               identify the
                                                               primary file to
                                                               which it should
                                                               write log
                                                               information.
                                                               [1mDACS [22mperforms
                                                               directory name
                                                               interpolation
                                                               on the pathname
                                                               string using a
                                                               syntax and
                                                               method similar
                                                               to [1mApache's[0m
                                                               [34m[1mmod_vhost_alias[0m[1m[22m[8]
                                                               module (see
                                                               [34m[1mString[0m
                                                               [1m[34mInterpolation[0m[1m[22m[24]).

                                                               The result
                                                               after
                                                               interpolation
                                                               must either be
                                                               the absolute
                                                               pathname of a
                                                               file to write
                                                               log information
                                                               to, or the word
                                                               "syslog". In
                                                               the latter
                                                               case,
                                                               [34m[1msyslog(3)[0m[1m[22m[114]
                                                               is used, with
                                                               an [4mident[0m
                                                               argument of
                                                               "dacs" and a
                                                               facility of
                                                               "user". Each
                                                               [1mDACS [22mlogging
                                                               level is mapped
                                                               to the
                                                               corresponding
                                                               [1msyslog [22mlevel,
                                                               with the trace
                                                               level mapped to
                                                               [1msyslog's [22mdebug
                                                               level.

                                                               While [1mDACS [22mis
                                                               starting and
                                                               before it reads
                                                               and processes
                                                               its
                                                               configuration
                                                               files, this
                                                               directive is
                                                               not yet
                                                               available to
                                                               it; until [1mDACS[0m
                                                               knows what
                                                               LOG_FILE is, or
                                                               should LOG_FILE
                                                               not be
                                                               writable, the
                                                               value of
                                                               LOG_FILE is
                                                               obtained from
                                                               the value of
                                                               DACS_LOG. A
                                                               compile-time
                                                               specified
                                                               value, DACS_LOG
                                                               can be
                                                               specified when
                                                               [1mDACS [22mis built
                                                               (the default is
                                                               equivalent to
                                                               ${Conf::DACS_HOME}/logs/error_log).
                                                               If DACS_LOG is
                                                               unusable,
                                                               stderr is used.

                                                           LOG_FILTER (Stack)
                                                               This directive
                                                               configures a
                                                               fine-grained
                                                               way of
                                                               specifying
                                                               which messages
                                                               will be written
                                                               compared to the
                                                               [34m[1mLOG_LEVEL[0m[1m[22m[115]
                                                               directive. The
                                                               directive,
                                                               which may be
                                                               repeated,
                                                               selects the
                                                               types of events
                                                               that [1mDACS[0m
                                                               [4mshould[24m log;
                                                               unselected
                                                               events are not
                                                               recorded in a
                                                               log file. It
                                                               also provides a
                                                               way for
                                                               different kinds
                                                               of messages to
                                                               be logged to
                                                               different
                                                               files.

                                                               Because this
                                                               directive is in
                                                               the [34m[1mStack[0m
                                                               [1m[34mcategory[0m[1m[22m[13],
                                                               "later"
                                                               directives
                                                               supercede
                                                               earlier ones.
                                                               When a
                                                               directive is
                                                               found that
                                                               allows a
                                                               message to be
                                                               logged, no
                                                               additional
                                                               directives are
                                                               examined for
                                                               the message. If
                                                               this directive
                                                               is not given,
                                                               the default
                                                               filtering is
                                                               done based on
                                                               the LOG_LEVEL
                                                               and
                                                               LOG_SENSITIVE
                                                               directives.

                                                               The syntax is
                                                               one of:

                                                                   LOG_FILTER "[4mtype[24m [4mflag[24m[,[4mflag[24m]* [4mlevel[24m [4mname[24m [[+|-][4mfile[24m]"
                                                                   LOG_FILTER "any [4mflag[24m[,[4mflag[24m]* [4mlevel[24m [[+|-][4mfile[24m]"

                                                               The [4mtype[24m, which
                                                               is one of the
                                                               keywords
                                                               program,
                                                               module,
                                                               filename, or
                                                               function (case
                                                               insensitive),
                                                               specifies the
                                                               type of the
                                                               event source to
                                                               which this
                                                               filter applies;
                                                               i.e., it
                                                               indicates what
                                                               [4mname[24m is to be
                                                               matched
                                                               against. If
                                                               [4mtype[24m is
                                                               filename, for
                                                               instance, it
                                                               means that for
                                                               this filter to
                                                               be applicable
                                                               to a particular
                                                               log message,
                                                               the [4mname[24m must
                                                               match the
                                                               filename from
                                                               which the log
                                                               message is
                                                               generated.

                                                               A list of
                                                               comma-separated,
                                                               case-insensitive
                                                               modifier flags
                                                               specifies how
                                                               matching of
                                                               [4mtype[24m is done
                                                               against [4mname[24m. A
                                                               [4mflag[24m can have
                                                               the value
                                                               exact, regex,
                                                               icase,
                                                               sensitive,
                                                               user, audit, or
                                                               normal.

                                                               The [4mname[24m is
                                                               matched against
                                                               [4mtype[24m case
                                                               sensitively,
                                                               unless the
                                                               icase flag is
                                                               present.
                                                               Matching is
                                                               performed using
                                                               [34m[1mregex(3)[0m[1m[22m[116]
                                                               regular
                                                               expression
                                                               matching if the
                                                               regex flag is
                                                               present, or
                                                               using a string
                                                               comparison if
                                                               the exact flag
                                                               is present
                                                               (these two
                                                               flags are
                                                               mutually
                                                               exclusive).

                                                               A message can
                                                               have no
                                                               attributes
                                                               associated with
                                                               it, or any
                                                               combination of
                                                               the attributes
                                                               sensitive,
                                                               user, and
                                                               audit. Messages
                                                               with the
                                                               sensitive
                                                               attribute might
                                                               include
                                                               potentially
                                                               private
                                                               information,
                                                               such as a
                                                               password.
                                                               Messages with
                                                               the audit
                                                               attribute
                                                               include
                                                               relatively
                                                               high-level
                                                               events, such as
                                                               successful and
                                                               unsuccessful
                                                               authentication
                                                               results,
                                                               signouts, and
                                                               access control
                                                               decisions. The
                                                               user attribute
                                                               is associated
                                                               with messages
                                                               produced by the
                                                               [34m[1mprint()[0m[1m[22m[117]
                                                               and
                                                               [34m[1mprintf()[0m[1m[22m[118]
                                                               functions.

                                                               Modifier flags
                                                               are used to
                                                               select (or
                                                               deselect)
                                                               messages to be
                                                               logged. By
                                                               default, only
                                                               normal messages
                                                               are logged;
                                                               these are
                                                               messages
                                                               without any
                                                               attributes. The
                                                               [34m[1mLOG_SENSITIVE[0m[1m[22m[119]
                                                               directive can
                                                               change the
                                                               default to
                                                               enable
                                                               sensitive
                                                               messages.

                                                               If the audit
                                                               flag is given,
                                                               a message is
                                                               logged only if
                                                               it has that
                                                               attribute.
                                                               Messages with
                                                               the sensitive
                                                               attribute are
                                                               not logged
                                                               unless the
                                                               sensitive flag
                                                               is given, and
                                                               messages with
                                                               the user
                                                               attribute are
                                                               not logged
                                                               unless the user
                                                               flag is given.

                                                               Assuming the
                                                               [4mtype[24m and [4mlevel[0m
                                                               do not deselect
                                                               the message,
                                                               here are some
                                                               example cases:

                                                               +o   a message
                                                                   without any
                                                                   attributes
                                                                   will be
                                                                   logged
                                                                   provided
                                                                   the audit
                                                                   flag is not
                                                                   specified

                                                               +o   a message
                                                                   with both
                                                                   the audit
                                                                   and
                                                                   sensitive
                                                                   attributes
                                                                   will be
                                                                   logged only
                                                                   if the
                                                                   filter
                                                                   specifies
                                                                   the audit
                                                                   flag, and
                                                                   either the
                                                                   sensitive
                                                                   flag is
                                                                   given or
                                                                   LOG_SENSITIVE
                                                                   is enabled

                                                                   If the
                                                                   directive's
                                                                   value
                                                                   begins with
                                                                   the keyword
                                                                   any, the
                                                                   filter
                                                                   matches any
                                                                   source, so
                                                                   there is no
                                                                   [4mname[24m and
                                                                   the
                                                                   modifier
                                                                   flags
                                                                   related to
                                                                   matching
                                                                   [4mname[24m are
                                                                   ignored.

                                                                   In order of
                                                                   increasing
                                                                   importance
                                                                   and
                                                                   decreasing
                                                                   amount of
                                                                   detail,
                                                                   [4mlevel[24m is
                                                                   one of the
                                                                   following
                                                                   case-insensitive
                                                                   keywords:

                                                                   +o    trace
                                                                       (or
                                                                       tracing,
                                                                       least
                                                                       important
                                                                       messages)

                                                                   +o    debug
                                                                       (or
                                                                       debugging)

                                                                   +o    info

                                                                   +o    notice
                                                                       (or
                                                                       notices)

                                                                   +o    warn
                                                                       (or
                                                                       warning
                                                                       or
                                                                       warnings)

                                                                   +o    error
                                                                       (or
                                                                       errors)

                                                                   +o
                                                                       critical
                                                                       (or
                                                                       crit)

                                                                   +o    alert
                                                                       (or
                                                                       alerts)

                                                                   +o    emerg
                                                                       (or
                                                                       emergency,
                                                                       most
                                                                       important
                                                                       messages)

                                                                       Any log
                                                                       message
                                                                       having
                                                                       a lower
                                                                       importance
                                                                       than
                                                                       [4mlevel[0m
                                                                       will
                                                                       not
                                                                       satisfy
                                                                       the
                                                                       filter.
                                                                       If the
                                                                       logging
                                                                       level
                                                                       is set
                                                                       to
                                                                       info,
                                                                       for
                                                                       example,
                                                                       messages
                                                                       having
                                                                       a lower
                                                                       level
                                                                       (debug
                                                                       and
                                                                       trace)
                                                                       will
                                                                       not be
                                                                       recorded.
                                                                       These
                                                                       levels
                                                                       are
                                                                       intended
                                                                       to have
                                                                       semantics
                                                                       similar
                                                                       to
                                                                       those
                                                                       of the
                                                                       logging
                                                                       levels
                                                                       used by
                                                                       [1mApache[0m
                                                                       and
                                                                       [34m[1msyslog(3)[0m[1m[22m[114].

                                                                       The
                                                                       [4mfile[0m
                                                                       field,
                                                                       which
                                                                       is
                                                                       optional,
                                                                       is used
                                                                       instead
                                                                       of (or
                                                                       in
                                                                       addition
                                                                       to)
                                                                       LOG_FILE
                                                                       and
                                                                       interpolation
                                                                       is
                                                                       performed
                                                                       in the
                                                                       same
                                                                       way. If
                                                                       [4mfile[24m is
                                                                       syslog,
                                                                       all
                                                                       messages
                                                                       matching
                                                                       the
                                                                       filter
                                                                       will be
                                                                       written
                                                                       using
                                                                       [1msyslog(3)[0m
                                                                       instead
                                                                       of to
                                                                       LOG_FILE.
                                                                       If [4mfile[0m
                                                                       is
                                                                       prefixed
                                                                       with a
                                                                       '+',
                                                                       output
                                                                       will be
                                                                       written
                                                                       to both
                                                                       LOG_FILE
                                                                       and the
                                                                       expansion
                                                                       of
                                                                       [4mfile[24m;
                                                                       if it
                                                                       is
                                                                       prefixed
                                                                       with
                                                                       nothing
                                                                       or -,
                                                                       the
                                                                       default
                                                                       behaviour
                                                                       results;
                                                                       the
                                                                       initial
                                                                       character
                                                                       can be
                                                                       escaped
                                                                       using a
                                                                       backslash.
                                                                       In some
                                                                       situations,
                                                                       using
                                                                       /dev/null
                                                                       for
                                                                       [4mfile[24m is
                                                                       useful
                                                                       to
                                                                       discard
                                                                       unhelpful
                                                                       messages.

                                                                       Without
                                                                       regard
                                                                       to how
                                                                       LOG_LEVEL
                                                                       and
                                                                       LOG_SENSITIVE
                                                                       are
                                                                       configured,
                                                                       this
                                                                       directive
                                                                       says
                                                                       that
                                                                       all
                                                                       messages
                                                                       generated
                                                                       by any
                                                                       function
                                                                       located
                                                                       within
                                                                       the
                                                                       [1mDACS[0m
                                                                       source
                                                                       file
                                                                       named
                                                                       crypto.c
                                                                       having
                                                                       a level
                                                                       of at
                                                                       least
                                                                       debug,
                                                                       should
                                                                       be
                                                                       logged,
                                                                       including
                                                                       those
                                                                       marked
                                                                       as
                                                                       sensitive:

                                                                           LOG_FILTER 'filename exact,sensitive debug crypto.c'


                                                                           [1mTip[0m
                                                                           The
                                                                           directive:

                                                                               LOG_FILTER 'any audit trace +syslog'

                                                                           causes
                                                                           all
                                                                           log
                                                                           messages
                                                                           with
                                                                           the
                                                                           audit
                                                                           modifier
                                                                           having
                                                                           level
                                                                           trace
                                                                           or
                                                                           higher
                                                                           to
                                                                           be
                                                                           written
                                                                           to
                                                                           both
                                                                           [1msyslog(3)[0m
                                                                           and
                                                                           LOG_FILE.
                                                                           If
                                                                           you
                                                                           want
                                                                           to
                                                                           use
                                                                           the
                                                                           syslog
                                                                           feature
                                                                           in
                                                                           this
                                                                           way,
                                                                           you
                                                                           will
                                                                           need
                                                                           a
                                                                           section
                                                                           in
                                                                           the
                                                                           [1msyslog(3)[0m
                                                                           configuration
                                                                           file
                                                                           (typically
                                                                           /etc/syslog.conf)
                                                                           that
                                                                           looks
                                                                           something
                                                                           like
                                                                           the
                                                                           following,
                                                                           depending
                                                                           on
                                                                           the
                                                                           flavour
                                                                           of
                                                                           [1msyslog(3)[0m
                                                                           that
                                                                           your
                                                                           system
                                                                           uses:

                                                                               !dacs
                                                                               *.*        /usr/local/dacs/logs/audit_log

                                                                           The
                                                                           following
                                                                           directive
                                                                           is
                                                                           similar
                                                                           except
                                                                           that
                                                                           it
                                                                           causes
                                                                           log
                                                                           messages
                                                                           classified
                                                                           as
                                                                           either
                                                                           audit
                                                                           or
                                                                           sensitive
                                                                           (or
                                                                           both)
                                                                           to
                                                                           be
                                                                           written
                                                                           to
                                                                           both
                                                                           LOG_FILE
                                                                           and
                                                                           the
                                                                           file
                                                                           logs/Audit_log,
                                                                           relative
                                                                           to
                                                                           the
                                                                           root
                                                                           of
                                                                           the
                                                                           [1mDACS[0m
                                                                           installation
                                                                           directory:

                                                                               LOG_FILTER 'any audit,sensitive TRACE +%bD/logs/Audit_log'

                                                                           By
                                                                           removing
                                                                           the
                                                                           '+'
                                                                           character,
                                                                           the
                                                                           log
                                                                           messages
                                                                           would
                                                                           not
                                                                           be
                                                                           written
                                                                           to
                                                                           LOG_FILE.
                                                                       Please
                                                                       refer
                                                                       to
                                                                       [34m[1mdacs(1)[0m[1m[22m[120]
                                                                       for
                                                                       general
                                                                       information
                                                                       about
                                                                       logging.

                                                                   LOG_FORMAT
                                                                   (Optional1)
                                                                       This
                                                                       directive
                                                                       is used
                                                                       to
                                                                       specify
                                                                       the
                                                                       format
                                                                       of log
                                                                       messages
                                                                       produced
                                                                       by
                                                                       [1mDACS[22m.
                                                                       Interpolation
                                                                       is
                                                                       controlled
                                                                       by
                                                                       [1mprintf[22m-like
                                                                       format
                                                                       specifiers,
                                                                       as
                                                                       follows:

                                                                       %%
                                                                           Insert
                                                                           a
                                                                           literal
                                                                           percent
                                                                           character

                                                                       %a
                                                                           Insert
                                                                           the
                                                                           application
                                                                           name,
                                                                           which
                                                                           is
                                                                           typically
                                                                           the
                                                                           basename
                                                                           of
                                                                           [4margv[0][24m.

                                                                       %c
                                                                           Insert
                                                                           the
                                                                           value
                                                                           of
                                                                           a
                                                                           per-process
                                                                           message
                                                                           counter,
                                                                           which
                                                                           is
                                                                           then
                                                                           incremented.

                                                                       %F
                                                                           Insert
                                                                           event
                                                                           descriptor
                                                                           flags,
                                                                           which
                                                                           indicate
                                                                           whether
                                                                           the
                                                                           message
                                                                           is
                                                                           an
                                                                           audit
                                                                           event
                                                                           ("A"),
                                                                           a
                                                                           potentially
                                                                           sensitive
                                                                           event
                                                                           ("S"),
                                                                           a
                                                                           user
                                                                           event
                                                                           ("U"),
                                                                           or
                                                                           a
                                                                           normal
                                                                           event
                                                                           ("-").

                                                                       %fn
                                                                           Interpolate
                                                                           the
                                                                           federation
                                                                           name.

                                                                       %fd
                                                                           Interpolate
                                                                           the
                                                                           federation
                                                                           domain.

                                                                       %j
                                                                           Interpolate
                                                                           the
                                                                           jurisdiction
                                                                           name.

                                                                       %l
                                                                           Interpolate
                                                                           the
                                                                           log
                                                                           level
                                                                           of
                                                                           the
                                                                           message.

                                                                       %p
                                                                           Interpolate
                                                                           the
                                                                           process
                                                                           id
                                                                           of
                                                                           the
                                                                           process
                                                                           generating
                                                                           the
                                                                           message.

                                                                       %sF
                                                                           Interpolate
                                                                           the
                                                                           name
                                                                           of
                                                                           the
                                                                           function
                                                                           generating
                                                                           the
                                                                           message.

                                                                       %sf
                                                                           Interpolate
                                                                           the
                                                                           name
                                                                           of
                                                                           the
                                                                           file
                                                                           generating
                                                                           the
                                                                           message.

                                                                       %sl
                                                                           Interpolate
                                                                           the
                                                                           line
                                                                           number
                                                                           within
                                                                           the
                                                                           file
                                                                           that
                                                                           is
                                                                           generating
                                                                           the
                                                                           message.

                                                                       %sm
                                                                           Interpolate
                                                                           the
                                                                           name
                                                                           of
                                                                           the
                                                                           module
                                                                           generating
                                                                           the
                                                                           message.

                                                                       %sp
                                                                           Interpolate
                                                                           the
                                                                           name
                                                                           of
                                                                           the
                                                                           program
                                                                           generating
                                                                           the
                                                                           message.

                                                                       %t
                                                                           Interpolate
                                                                           the
                                                                           current
                                                                           time
                                                                           and
                                                                           date.

                                                                       If a %
                                                                       is
                                                                       followed
                                                                       by any
                                                                       other
                                                                       character,
                                                                       that
                                                                       character
                                                                       is
                                                                       printed.
                                                                       Other
                                                                       characters
                                                                       in the
                                                                       format
                                                                       specifier
                                                                       are
                                                                       interpolated
                                                                       verbatim.
                                                                       If a
                                                                       requested
                                                                       value
                                                                       is not
                                                                       available,
                                                                       nothing
                                                                       is
                                                                       interpolated.

                                                                   LOG_LEVEL
                                                                   (Optional1)
                                                                       This
                                                                       directive
                                                                       specifies
                                                                       the
                                                                       minimum
                                                                       default
                                                                       logging
                                                                       level
                                                                       in
                                                                       effect
                                                                       - log
                                                                       messages
                                                                       less
                                                                       important
                                                                       than
                                                                       this
                                                                       will be
                                                                       discarded.
                                                                       For
                                                                       example,
                                                                       if
                                                                       LOG_LEVEL
                                                                       is
                                                                       warn,
                                                                       only
                                                                       log
                                                                       message
                                                                       of that
                                                                       level
                                                                       or more
                                                                       important
                                                                       will be
                                                                       written
                                                                       and all
                                                                       others
                                                                       will be
                                                                       discarded.
                                                                       If
                                                                       there
                                                                       is an
                                                                       applicable
                                                                       [34m[1mLOG_FILTER[0m[1m[22m[121]
                                                                       directive
                                                                       it
                                                                       overrides
                                                                       this
                                                                       behaviour,
                                                                       however.

                                                                       Briefly,
                                                                       in
                                                                       order
                                                                       of
                                                                       increasing
                                                                       importance,
                                                                       the
                                                                       names
                                                                       of the
                                                                       levels
                                                                       are:
                                                                       trace,
                                                                       debug,
                                                                       info,
                                                                       notice,
                                                                       warn,
                                                                       error,
                                                                       critical,
                                                                       alert,
                                                                       and
                                                                       emerg.
                                                                       The
                                                                       trace
                                                                       logging
                                                                       level
                                                                       emits
                                                                       the
                                                                       most
                                                                       detail
                                                                       and the
                                                                       emerg
                                                                       level
                                                                       emits
                                                                       the
                                                                       least.
                                                                       Refer
                                                                       to the
                                                                       [34m[1mLOG_FILTER[0m[1m[22m[121]
                                                                       directive
                                                                       for
                                                                       additional
                                                                       information.

                                                                       The
                                                                       LOG_LEVEL
                                                                       overrides
                                                                       the
                                                                       compile-time
                                                                       default,
                                                                       which
                                                                       is
                                                                       obtained
                                                                       using
                                                                       the
                                                                       LOG_DEFAULT_LEVEL
                                                                       symbol.

                                                                       The
                                                                       "verbose"
                                                                       command
                                                                       line
                                                                       flag
                                                                       ([1m-v[22m) or
                                                                       the
                                                                       VERBOSE_LEVEL
                                                                       directive
                                                                       overrides
                                                                       this
                                                                       directive,
                                                                       which
                                                                       are in
                                                                       turn
                                                                       overridden
                                                                       by the
                                                                       [4m-t[0m
                                                                       command
                                                                       line
                                                                       flag
                                                                       ("trace")
                                                                       or the
                                                                       TRACE_LEVEL
                                                                       directive.
                                                                       A
                                                                       verbose
                                                                       level
                                                                       of one
                                                                       is
                                                                       equivalent
                                                                       to the
                                                                       info
                                                                       level;
                                                                       a
                                                                       verbose
                                                                       level
                                                                       greater
                                                                       than
                                                                       one is
                                                                       equivalent
                                                                       to the
                                                                       debug
                                                                       level.
                                                                       Enabling
                                                                       a trace
                                                                       level,
                                                                       with
                                                                       any
                                                                       value,
                                                                       is
                                                                       equivalent
                                                                       to
                                                                       requesting
                                                                       the
                                                                       trace
                                                                       logging
                                                                       level.

                                                                       Also
                                                                       see
                                                                       [34m[1mdebug_dacs[0m[1m[22m[122].

                                                                   LOG_SENSITIVE
                                                                   (Optional1)
                                                                       This
                                                                       directive
                                                                       determines
                                                                       the
                                                                       default
                                                                       behaviour
                                                                       for
                                                                       logging
                                                                       messages
                                                                       with
                                                                       the
                                                                       sensitive
                                                                       attribute.
                                                                       It may
                                                                       have
                                                                       the
                                                                       values
                                                                       "yes"
                                                                       (to
                                                                       enable
                                                                       logging
                                                                       sensitive
                                                                       messages)
                                                                       or "no"
                                                                       (the
                                                                       default,
                                                                       which
                                                                       discards
                                                                       such
                                                                       messages).

                                                                           [1mNote[0m
                                                                           Sensitive
                                                                           messages
                                                                           may
                                                                           include
                                                                           passwords
                                                                           and
                                                                           other
                                                                           authentication
                                                                           material
                                                                           that
                                                                           should
                                                                           remain
                                                                           private.
                                                                           This
                                                                           directive
                                                                           will
                                                                           not
                                                                           suppress
                                                                           potentially
                                                                           sensitive
                                                                           messages
                                                                           generated
                                                                           by
                                                                           third-party
                                                                           support
                                                                           packages
                                                                           (e.g.,
                                                                           [1mSamba[0m
                                                                           or
                                                                           [1mOpenLDAP[22m),
                                                                           [1mApache[0m
                                                                           (including
                                                                           [1mmod_auth_dacs[22m),
                                                                           or
                                                                           the
                                                                           operating
                                                                           system.
                                                                           For
                                                                           example,
                                                                           requests
                                                                           for
                                                                           CGI
                                                                           programs
                                                                           invoked
                                                                           using
                                                                           the
                                                                           GET
                                                                           method
                                                                           will
                                                                           be
                                                                           logged
                                                                           in
                                                                           the
                                                                           [1mApache[0m
                                                                           Access
                                                                           Log,
                                                                           and
                                                                           the
                                                                           request's
                                                                           query
                                                                           string
                                                                           will
                                                                           typically
                                                                           be
                                                                           printed;
                                                                           password
                                                                           parameters
                                                                           may
                                                                           be
                                                                           present
                                                                           in
                                                                           the
                                                                           log
                                                                           (see
                                                                           [34m[1mmod_log_config[0m[1m[22m[123]
                                                                           for
                                                                           details
                                                                           of
                                                                           how
                                                                           to
                                                                           change
                                                                           the
                                                                           log
                                                                           format.
                                                                           If
                                                                           sensitive
                                                                           messages
                                                                           are
                                                                           being
                                                                           logged,
                                                                           make
                                                                           doubly-sure
                                                                           that
                                                                           log
                                                                           files
                                                                           have
                                                                           appropriate
                                                                           permissions.
                                                                           Also,
                                                                           unencrypted
                                                                           logging
                                                                           messages
                                                                           directed
                                                                           over
                                                                           a
                                                                           network
                                                                           (e.g.,
                                                                           through
                                                                           [34m[1msyslog(3)[0m[1m[22m[114])
                                                                           may
                                                                           be
                                                                           visible
                                                                           to
                                                                           an
                                                                           attacker.

                                                                   NAME_COMPARE
                                                                   (Optional1)
                                                                       This
                                                                       directive
                                                                       sets
                                                                       the
                                                                       default
                                                                       method
                                                                       used to
                                                                       compare
                                                                       [1mDACS[0m
                                                                       names
                                                                       in
                                                                       various
                                                                       contexts.
                                                                       Ordinarily,
                                                                       federation,
                                                                       jurisdiction,
                                                                       usernames,
                                                                       and
                                                                       group
                                                                       names
                                                                       are
                                                                       compared
                                                                       case-sensitively.
                                                                       If the
                                                                       value
                                                                       of this
                                                                       directive
                                                                       is
                                                                       (case-insensitively)
                                                                       case,
                                                                       then
                                                                       case-sensitive
                                                                       comparisons
                                                                       are
                                                                       used;
                                                                       if its
                                                                       value
                                                                       is
                                                                       nocase,
                                                                       case-insensitive
                                                                       comparisons
                                                                       are
                                                                       used;
                                                                       if its
                                                                       value
                                                                       is
                                                                       default,
                                                                       then
                                                                       the
                                                                       application
                                                                       default
                                                                       (either
                                                                       case or
                                                                       the
                                                                       value
                                                                       selected
                                                                       by the
                                                                       application)
                                                                       is
                                                                       used.
                                                                       This
                                                                       directive
                                                                       can be
                                                                       overridden
                                                                       on a
                                                                       case-by-case
                                                                       basis
                                                                       (pun
                                                                       intended);
                                                                       refer
                                                                       to the
                                                                       [1muser()[0m
                                                                       function
                                                                       ([34m[1mdacs.exprs(5)[0m[1m[22m[20])
                                                                       for
                                                                       details.

                                                                           [1mSecurity[0m
                                                                           The
                                                                           selected
                                                                           comparison
                                                                           method
                                                                           applies
                                                                           to
                                                                           [4mall[0m
                                                                           components
                                                                           of
                                                                           [1mDACS[0m
                                                                           names;
                                                                           if
                                                                           this
                                                                           is
                                                                           not
                                                                           desired,
                                                                           the
                                                                           [1mstrtr()[0m
                                                                           function
                                                                           might
                                                                           be
                                                                           helpful.
                                                                           Note
                                                                           that
                                                                           this
                                                                           directive
                                                                           does
                                                                           not
                                                                           alter
                                                                           the
                                                                           [1mDACS[0m
                                                                           name
                                                                           determined
                                                                           by
                                                                           authentication,
                                                                           only
                                                                           the
                                                                           way
                                                                           the
                                                                           name
                                                                           is
                                                                           compared.
                                                                           While
                                                                           it's
                                                                           unlikely
                                                                           (and
                                                                           bad
                                                                           practice)
                                                                           for
                                                                           federation
                                                                           names
                                                                           (or
                                                                           jurisdiction
                                                                           names)
                                                                           to
                                                                           differ
                                                                           only
                                                                           in
                                                                           their
                                                                           case,
                                                                           it
                                                                           is
                                                                           not
                                                                           unusual
                                                                           for
                                                                           usernames
                                                                           to
                                                                           be
                                                                           treated
                                                                           case-insensitively
                                                                           for
                                                                           authentication
                                                                           purposes
                                                                           and
                                                                           for
                                                                           this
                                                                           reason
                                                                           this
                                                                           feature
                                                                           should
                                                                           be
                                                                           used
                                                                           with
                                                                           care.
                                                                           When
                                                                           case-insensitive
                                                                           comparisons
                                                                           are
                                                                           used,
                                                                           the
                                                                           usernames
                                                                           bob
                                                                           and
                                                                           BOB
                                                                           will
                                                                           be
                                                                           considered
                                                                           to
                                                                           be
                                                                           equivalent,
                                                                           for
                                                                           example;
                                                                           sometimes
                                                                           this
                                                                           is
                                                                           useful
                                                                           but
                                                                           it
                                                                           can
                                                                           also
                                                                           be
                                                                           a
                                                                           security
                                                                           hole,
                                                                           depending
                                                                           on
                                                                           how
                                                                           authentication
                                                                           is
                                                                           configured.

                                                                           Changing
                                                                           the
                                                                           comparison
                                                                           method
                                                                           from
                                                                           case-insensitive
                                                                           back
                                                                           to
                                                                           case-sensitive
                                                                           may
                                                                           have
                                                                           undesirable
                                                                           consequences;
                                                                           identities
                                                                           that
                                                                           were
                                                                           formerly
                                                                           equivalent
                                                                           might
                                                                           suddenly
                                                                           become
                                                                           distinct,
                                                                           which
                                                                           at
                                                                           the
                                                                           very
                                                                           least
                                                                           may
                                                                           confuse
                                                                           users.

                                                                           The
                                                                           recommended
                                                                           practice
                                                                           is
                                                                           to
                                                                           not
                                                                           define
                                                                           NAME_COMPARE
                                                                           or
                                                                           set
                                                                           it
                                                                           to
                                                                           case
                                                                           because
                                                                           of
                                                                           its
                                                                           system-wide
                                                                           effects.
                                                                           When
                                                                           needed,
                                                                           use
                                                                           the
                                                                           [1muser()[0m
                                                                           function
                                                                           with
                                                                           an
                                                                           appropriate
                                                                           comparison
                                                                           method
                                                                           argument.

                                                                   NOTICES_ACCEPT_HANDLER
                                                                   (Optional1)
                                                                       This
                                                                       directive
                                                                       provides
                                                                       a URL
                                                                       (absolute
                                                                       or
                                                                       relative)
                                                                       to
                                                                       which a
                                                                       user
                                                                       agent
                                                                       will be
                                                                       redirected
                                                                       by the
                                                                       notice
                                                                       acknowledgement
                                                                       handler
                                                                       after a
                                                                       positive
                                                                       acknowledgement
                                                                       to a
                                                                       notice
                                                                       has
                                                                       been
                                                                       received
                                                                       (i.e.,
                                                                       when
                                                                       the
                                                                       notice
                                                                       or
                                                                       notices
                                                                       were
                                                                       "accepted"),
                                                                       but
                                                                       only if
                                                                       it is
                                                                       not
                                                                       possible
                                                                       to
                                                                       redirect
                                                                       the
                                                                       user
                                                                       agent
                                                                       to the
                                                                       request
                                                                       that
                                                                       initiated
                                                                       notice
                                                                       acknowledgement
                                                                       processing
                                                                       (e.g.,
                                                                       if that
                                                                       request
                                                                       used
                                                                       the
                                                                       POST
                                                                       method).
                                                                       If not
                                                                       provided,
                                                                       a
                                                                       default
                                                                       HTML
                                                                       page
                                                                       will be
                                                                       returned.

                                                                   NOTICES_ACK_HANDLER
                                                                   (Optional1)
                                                                       This
                                                                       directive
                                                                       provides
                                                                       the URL
                                                                       of the
                                                                       notice
                                                                       acknowledgement
                                                                       handler,
                                                                       which
                                                                       is the
                                                                       program
                                                                       that
                                                                       receives
                                                                       a
                                                                       user's
                                                                       response
                                                                       to a
                                                                       request
                                                                       to
                                                                       acknowledge
                                                                       one or
                                                                       more
                                                                       notices.
                                                                       If not
                                                                       provided
                                                                       or if
                                                                       it is
                                                                       the
                                                                       empty
                                                                       string,
                                                                       the
                                                                       notice
                                                                       presentation
                                                                       handler
                                                                       should
                                                                       assume
                                                                       that it
                                                                       must
                                                                       also
                                                                       act as
                                                                       the
                                                                       notice
                                                                       acknowledgement
                                                                       handler.

                                                                   NOTICES_DECLINE_HANDLER
                                                                   (Optional1)
                                                                       This
                                                                       directive
                                                                       provides
                                                                       a URL
                                                                       (absolute
                                                                       or
                                                                       relative)
                                                                       to
                                                                       which a
                                                                       user
                                                                       agent
                                                                       will be
                                                                       redirected
                                                                       by the
                                                                       notice
                                                                       acknowledgement
                                                                       handler
                                                                       after a
                                                                       negative
                                                                       acknowledgement
                                                                       to a
                                                                       notice
                                                                       has
                                                                       been
                                                                       received
                                                                       (i.e.,
                                                                       when
                                                                       the
                                                                       notice
                                                                       or
                                                                       notices
                                                                       were
                                                                       "declined").
                                                                       If not
                                                                       provided,
                                                                       a
                                                                       default
                                                                       HTML
                                                                       page
                                                                       will be
                                                                       returned.

                                                                   NOTICES_NAT_NAME_PREFIX
                                                                   (Optional1)
                                                                       The
                                                                       default
                                                                       prefix
                                                                       of the
                                                                       name of
                                                                       the
                                                                       HTTP
                                                                       cookie
                                                                       bearing
                                                                       a
                                                                       notice
                                                                       acknowledgement
                                                                       token
                                                                       is
                                                                       "NAT-DACS".
                                                                       This
                                                                       directive
                                                                       can be
                                                                       used to
                                                                       override
                                                                       the
                                                                       default.

                                                                   NOTICES_SECURE_HANDLER
                                                                   (Optional1)
                                                                       By
                                                                       default,
                                                                       [34m[1mdacs_notices(8)[0m[1m[22m[124]
                                                                       takes
                                                                       steps
                                                                       to
                                                                       prevent
                                                                       attempts
                                                                       to
                                                                       simply
                                                                       ask for
                                                                       notice
                                                                       acknowledgement
                                                                       tokens
                                                                       (NATs),
                                                                       effectively
                                                                       bypassing
                                                                       having
                                                                       to see
                                                                       notices.
                                                                       If the
                                                                       value
                                                                       of this
                                                                       directive
                                                                       is
                                                                       "no",
                                                                       however,
                                                                       these
                                                                       steps
                                                                       will be
                                                                       disabled.
                                                                       Please
                                                                       refer
                                                                       to the
                                                                       description
                                                                       of
                                                                       [1mdacs_notices[22m'
                                                                       [34m[1mSecure[0m
                                                                       [1m[34mMode[0m[1m[22m[125]
                                                                       of
                                                                       operation.

                                                                   NOTICES_WORKFLOW_LIFETIME_SECS
                                                                   (Optional1)
                                                                       By
                                                                       default,
                                                                       a
                                                                       secure
                                                                       notice
                                                                       acknowledgement
                                                                       workflow
                                                                       must
                                                                       complete
                                                                       within
                                                                       120
                                                                       seconds.
                                                                       This
                                                                       directive
                                                                       can be
                                                                       used to
                                                                       specify
                                                                       an
                                                                       unsigned
                                                                       integer
                                                                       value
                                                                       that
                                                                       will
                                                                       override
                                                                       the
                                                                       default.

                                                                   PAMD_HOST
                                                                   (Optional1)
                                                                       When
                                                                       [34m[1mlocal_pam_authenticate[0m[1m[22m[126]
                                                                       is
                                                                       used,
                                                                       this
                                                                       directive
                                                                       is
                                                                       required
                                                                       to
                                                                       specify
                                                                       the
                                                                       domain
                                                                       name or
                                                                       IP
                                                                       address
                                                                       of the
                                                                       host
                                                                       where
                                                                       [34m[1mpamd(8)[0m[1m[22m[127]
                                                                       is
                                                                       executed.

                                                                   PAMD_PORT
                                                                   (Optional1)
                                                                       When
                                                                       [34m[1mlocal_pam_authenticate[0m[1m[22m[126]
                                                                       is
                                                                       used,
                                                                       this
                                                                       may be
                                                                       used to
                                                                       specify
                                                                       the
                                                                       port
                                                                       number
                                                                       or
                                                                       service
                                                                       name on
                                                                       PAMD_HOST
                                                                       where
                                                                       the
                                                                       [34m[1mpamd(8)[0m[1m[22m[127]
                                                                       server
                                                                       accepts
                                                                       connections.
                                                                       This
                                                                       directive
                                                                       can be
                                                                       overridden
                                                                       on the
                                                                       [1mpamd[0m
                                                                       command
                                                                       line.
                                                                       If no
                                                                       value
                                                                       is
                                                                       explicitly
                                                                       specified,
                                                                       programs
                                                                       will
                                                                       use the
                                                                       compile-time
                                                                       symbol
                                                                       PAMD_SERVICE_NAME
                                                                       (by
                                                                       default,
                                                                       "dacs-pamd"),
                                                                       which
                                                                       assumes
                                                                       that
                                                                       /etc/services
                                                                       has
                                                                       been
                                                                       configured
                                                                       accordingly.

                                                                   PASSWORD_CONSTRAINTS
                                                                   (Optional1)
                                                                       This
                                                                       directive
                                                                       describes
                                                                       requirements
                                                                       that
                                                                       must be
                                                                       met by
                                                                       new
                                                                       passwords
                                                                       created
                                                                       by
                                                                       [34m[1mdacs_passwd(8)[0m[1m[22m[128],
                                                                       other
                                                                       than
                                                                       when
                                                                       used by
                                                                       a [1mDACS[0m
                                                                       administrator.
                                                                       In
                                                                       other
                                                                       situations,
                                                                       where a
                                                                       [1mDACS[0m
                                                                       administrator
                                                                       must be
                                                                       running
                                                                       the
                                                                       program
                                                                       (such
                                                                       as with
                                                                       [34m[1mdacspasswd(1)[0m[1m[22m[129]
                                                                       or
                                                                       [34m[1mdacstoken(1)[0m[1m[22m[130]),
                                                                       a
                                                                       warning
                                                                       message
                                                                       is
                                                                       produced
                                                                       if a
                                                                       new,
                                                                       non-conforming
                                                                       password
                                                                       or PIN
                                                                       is set
                                                                       but the
                                                                       password
                                                                       can
                                                                       still
                                                                       be
                                                                       used.

                                                                       This
                                                                       directive's
                                                                       syntax
                                                                       is also
                                                                       used by
                                                                       the
                                                                       [34m[1mPASSWORD_AUDIT[0m[1m[22m[131]
                                                                       directive,
                                                                       which
                                                                       may
                                                                       appear
                                                                       in an
                                                                       Auth
                                                                       clause.

                                                                       The
                                                                       format
                                                                       of the
                                                                       constraint
                                                                       string
                                                                       is a
                                                                       set of
                                                                       zero or
                                                                       more
                                                                       comma-separated
                                                                       terms.
                                                                       Each
                                                                       term
                                                                       consists
                                                                       of an
                                                                       unsigned
                                                                       integer
                                                                       (zero
                                                                       or
                                                                       greater)
                                                                       followed
                                                                       immediately
                                                                       by a
                                                                       single
                                                                       character
                                                                       (case
                                                                       sensitive)
                                                                       that
                                                                       indicates
                                                                       a
                                                                       [4mconstraint[0m
                                                                       [4mtype[24m:

                                                                       +o   L
                                                                           refers
                                                                           to
                                                                           the
                                                                           minimum
                                                                           length
                                                                           of
                                                                           a
                                                                           password,
                                                                           in
                                                                           characters;

                                                                       +o   C
                                                                           is
                                                                           the
                                                                           minimum
                                                                           number
                                                                           of
                                                                           characters
                                                                           [4mfrom[0m
                                                                           [4meach[0m
                                                                           [4mcase[0m
                                                                           that
                                                                           must
                                                                           be
                                                                           present
                                                                           (e.g.,
                                                                           3C
                                                                           means
                                                                           a
                                                                           password
                                                                           must
                                                                           have
                                                                           at
                                                                           least
                                                                           three
                                                                           upper
                                                                           case
                                                                           characters
                                                                           [4mand[0m
                                                                           three
                                                                           lower
                                                                           case
                                                                           characters);

                                                                       +o   D
                                                                           is
                                                                           the
                                                                           minimum
                                                                           number
                                                                           of
                                                                           digits
                                                                           (0-9)
                                                                           that
                                                                           must
                                                                           be
                                                                           present;

                                                                       +o   and
                                                                           P
                                                                           is
                                                                           the
                                                                           minimum
                                                                           number
                                                                           of
                                                                           punctuation
                                                                           characters
                                                                           (see
                                                                           [34m[1mispunct(3)[0m[1m[22m[132])
                                                                           that
                                                                           must
                                                                           be
                                                                           present.

                                                                           A
                                                                           constraint
                                                                           type
                                                                           may
                                                                           not
                                                                           appear
                                                                           more
                                                                           than
                                                                           once.
                                                                           Not
                                                                           all
                                                                           constraint
                                                                           types
                                                                           need
                                                                           to
                                                                           be
                                                                           specified.
                                                                           If
                                                                           this
                                                                           directive
                                                                           is
                                                                           not
                                                                           given,
                                                                           or
                                                                           is
                                                                           the
                                                                           empty
                                                                           string,
                                                                           or
                                                                           the
                                                                           word
                                                                           "none"
                                                                           (case
                                                                           insensitive),
                                                                           a
                                                                           minimum
                                                                           password
                                                                           length
                                                                           of
                                                                           any
                                                                           six
                                                                           characters
                                                                           is
                                                                           used.
                                                                           If
                                                                           a
                                                                           constraint
                                                                           type
                                                                           is
                                                                           missing,
                                                                           a
                                                                           minimum
                                                                           of
                                                                           zero
                                                                           is
                                                                           used.
                                                                           In
                                                                           no
                                                                           event
                                                                           is
                                                                           a
                                                                           password
                                                                           of
                                                                           fewer
                                                                           than
                                                                           six
                                                                           characters
                                                                           allowed
                                                                           for
                                                                           a
                                                                           non-administrator,
                                                                           however.

                                                                               [1mSecurity[0m
                                                                               No
                                                                               check
                                                                               is
                                                                               made
                                                                               for
                                                                               constraints
                                                                               that
                                                                               are
                                                                               impossible
                                                                               to
                                                                               satisfy.

                                                                           For
                                                                           example,
                                                                           the
                                                                           following
                                                                           directive
                                                                           says
                                                                           that
                                                                           passwords
                                                                           must
                                                                           be
                                                                           at
                                                                           least
                                                                           eight
                                                                           characters
                                                                           long
                                                                           and
                                                                           include
                                                                           at
                                                                           least
                                                                           one
                                                                           digit
                                                                           and
                                                                           one
                                                                           upper
                                                                           case
                                                                           and
                                                                           one
                                                                           lower
                                                                           case
                                                                           character,
                                                                           with
                                                                           no
                                                                           punctuation
                                                                           characters
                                                                           required:

                                                                               PASSWORD_CONSTRAINTS "8L,1D,1C,0P"


                                                                       PASSWORD_DIGEST
                                                                       (Optional1)
                                                                           By
                                                                           default,
                                                                           SHA-1
                                                                           is
                                                                           used
                                                                           as
                                                                           the
                                                                           secure
                                                                           hash
                                                                           function
                                                                           by
                                                                           [34m[1mdacstoken(1)[0m[1m[22m[130],
                                                                           [34m[1mdacspasswd(1)[0m[1m[22m[129],
                                                                           [34m[1mdacstoken(1)[0m[1m[22m[130],
                                                                           [34m[1mdacs_passwd(8)[0m[1m[22m[128],
                                                                           and
                                                                           [34m[1mdacs_admin(8)[0m[1m[22m[133]
                                                                           for
                                                                           computing
                                                                           password
                                                                           digests.
                                                                           The
                                                                           value
                                                                           of
                                                                           this
                                                                           directive
                                                                           can
                                                                           be
                                                                           (case
                                                                           insensitively):

                                                                           CRYPT
                                                                               for
                                                                               the
                                                                               Unix
                                                                               [34m[1mcrypt(3)[0m[1m[22m[134]
                                                                               function

                                                                           MD5
                                                                               for
                                                                               the
                                                                               [34m[1mMD5[0m
                                                                               [1m[34mfunction[0m[1m[22m[135]
                                                                               (deprecated).

                                                                           SHA1
                                                                           SHA224
                                                                           SHA256
                                                                           SHA384
                                                                           SHA512
                                                                               ,
                                                                               ,
                                                                               ,
                                                                               ,
                                                                               for
                                                                               one
                                                                               of
                                                                               the
                                                                               variants
                                                                               of
                                                                               the
                                                                               Secure
                                                                               Hash
                                                                               Standard
                                                                               ([34m[1mFIPS[0m
                                                                               [1m[34m180-3[0m[1m[22m[136]).


                                                                           The
                                                                           system
                                                                           [1mcrypt()[0m
                                                                           function
                                                                           may
                                                                           have
                                                                           platform-dependent
                                                                           limitations
                                                                           on
                                                                           the
                                                                           number
                                                                           of
                                                                           characters
                                                                           that
                                                                           are
                                                                           significant
                                                                           in
                                                                           a
                                                                           password
                                                                           or
                                                                           the
                                                                           maximum
                                                                           length
                                                                           of
                                                                           a
                                                                           password,
                                                                           but
                                                                           the
                                                                           other
                                                                           digest
                                                                           algorithms
                                                                           use
                                                                           all
                                                                           of
                                                                           the
                                                                           characters
                                                                           and
                                                                           impose
                                                                           no
                                                                           maximum
                                                                           password
                                                                           length.
                                                                           .sp
                                                                           The
                                                                           digest
                                                                           algorithm
                                                                           used
                                                                           is
                                                                           stored
                                                                           with
                                                                           the
                                                                           password
                                                                           entry,
                                                                           so
                                                                           the
                                                                           algorithm
                                                                           can
                                                                           be
                                                                           changed
                                                                           without
                                                                           voiding
                                                                           pre-existing
                                                                           passwords.

                                                                       PASSWORD_OPS_NEED_PASSWORD
                                                                       (Optional1)
                                                                           Ordinarily,
                                                                           [34m[1mdacspasswd(1)[0m[1m[22m[129]
                                                                           will
                                                                           not
                                                                           allow
                                                                           password
                                                                           maintenance
                                                                           operations
                                                                           (other
                                                                           than
                                                                           listing)
                                                                           unless
                                                                           the
                                                                           user
                                                                           has
                                                                           authenticated
                                                                           as
                                                                           an
                                                                           [34m[1mADMIN_IDENTITY[0m[1m[22m[137]
                                                                           or
                                                                           provides
                                                                           a
                                                                           valid
                                                                           password
                                                                           for
                                                                           the
                                                                           username
                                                                           being
                                                                           administered
                                                                           (one
                                                                           that
                                                                           was
                                                                           created
                                                                           by
                                                                           [34m[1mdacspasswd(1)[0m[1m[22m[129]).
                                                                           If
                                                                           this
                                                                           directive
                                                                           is
                                                                           "no",
                                                                           a
                                                                           password
                                                                           is
                                                                           not
                                                                           required
                                                                           and
                                                                           [1mdacspasswd[0m
                                                                           will
                                                                           assume
                                                                           that
                                                                           all
                                                                           necessary
                                                                           access
                                                                           control
                                                                           has
                                                                           already
                                                                           been
                                                                           performed.

                                                                       PASSWORD_SALT_PREFIX
                                                                       (Optional1)
                                                                           This
                                                                           string
                                                                           is
                                                                           prepended
                                                                           to
                                                                           a
                                                                           random
                                                                           salt
                                                                           string
                                                                           used
                                                                           when
                                                                           creating
                                                                           a
                                                                           digest
                                                                           of
                                                                           a
                                                                           password
                                                                           used
                                                                           by
                                                                           [1mDACS[0m
                                                                           in
                                                                           various
                                                                           contexts
                                                                           (e.g.,
                                                                           [34m[1mdacspasswd(1)[0m[1m[22m[129]).
                                                                           This
                                                                           may
                                                                           be
                                                                           of
                                                                           interest
                                                                           when
                                                                           [34m[1mPASSWORD_DIGEST[0m[1m[22m[102]
                                                                           is
                                                                           CRYPT
                                                                           because
                                                                           some
                                                                           versions
                                                                           of
                                                                           [34m[1mcrypt(3)[0m[1m[22m[134]
                                                                           interpret
                                                                           the
                                                                           salt
                                                                           string.

                                                                       PERMIT_CHAINING
                                                                       (Optional1)
                                                                           If
                                                                           "yes",
                                                                           credentials
                                                                           exported
                                                                           by
                                                                           [34m[1mdacs_acs(8)[0m[1m[22m[6]
                                                                           anywhere
                                                                           in
                                                                           the
                                                                           federation
                                                                           as
                                                                           a
                                                                           result
                                                                           of
                                                                           a
                                                                           rule
                                                                           having
                                                                           the
                                                                           permit_chaining
                                                                           attribute
                                                                           set
                                                                           to
                                                                           yes
                                                                           will
                                                                           be
                                                                           honoured
                                                                           at
                                                                           this
                                                                           jurisdiction
                                                                           for
                                                                           access
                                                                           control
                                                                           purposes.

                                                                               [1mSecurity[0m
                                                                               Enabling
                                                                               this
                                                                               feature
                                                                               weakens
                                                                               security
                                                                               because
                                                                               it
                                                                               may
                                                                               allow
                                                                               misappropriated
                                                                               [1mDACS[0m
                                                                               identities
                                                                               to
                                                                               be
                                                                               used
                                                                               at
                                                                               a
                                                                               jurisdiction
                                                                               that
                                                                               has
                                                                               enabled
                                                                               PERMIT_CHAINING.
                                                                               Use
                                                                               of
                                                                               this
                                                                               feature
                                                                               is
                                                                               discouraged
                                                                               but
                                                                               is
                                                                               sometimes
                                                                               necessary;
                                                                               use
                                                                               with
                                                                               care.
                                                                               Refer
                                                                               to
                                                                               the
                                                                               description
                                                                               of
                                                                               the
                                                                               permit_chaining
                                                                               attribute
                                                                               in
                                                                               [34m[1mdacs.acls(5)[0m[1m[22m[25].

                                                                       PROXY_EXEC_DOCUMENT_ROOT
                                                                       (Optional1)
                                                                           Reserved
                                                                           for
                                                                           future
                                                                           use.

                                                                       PROXY_EXEC_MAPPER_DEFAULT_ACTION
                                                                       (Optional1)
                                                                           Reserved
                                                                           for
                                                                           future
                                                                           use.

                                                                       PROXY_EXEC_MAPPER_LOGGING
                                                                       (Optional1)
                                                                           Reserved
                                                                           for
                                                                           future
                                                                           use.

                                                                       PROXY_EXEC_MAPPER_LOG_FILE
                                                                       (Optional1)
                                                                           Reserved
                                                                           for
                                                                           future
                                                                           use.

                                                                       PROXY_EXEC_MAPPER_RULES_FILE
                                                                       (Optional1)
                                                                           Reserved
                                                                           for
                                                                           future
                                                                           use.

                                                                       PROXY_EXEC_PROG_URI
                                                                       (Optional1)
                                                                           Reserved
                                                                           for
                                                                           future
                                                                           use.

                                                                       RLINK
                                                                       (Optional)
                                                                           This
                                                                           directive,
                                                                           which
                                                                           may
                                                                           be
                                                                           repeated,
                                                                           is
                                                                           used
                                                                           to
                                                                           determine
                                                                           whether
                                                                           the
                                                                           current
                                                                           request
                                                                           includes
                                                                           an
                                                                           [34m[1mRlink[0m[1m[22m[138].
                                                                           The
                                                                           RLINK
                                                                           directives
                                                                           are
                                                                           processed
                                                                           in
                                                                           the
                                                                           order
                                                                           in
                                                                           which
                                                                           they
                                                                           occur.
                                                                           The
                                                                           value
                                                                           of
                                                                           the
                                                                           directive
                                                                           is
                                                                           a
                                                                           space-separated
                                                                           pair:
                                                                           the
                                                                           first
                                                                           is
                                                                           an
                                                                           [34m[1mexpression[0m[1m[22m[20]
                                                                           that
                                                                           is
                                                                           evaluated
                                                                           at
                                                                           rule-processing
                                                                           time,
                                                                           and
                                                                           the
                                                                           second
                                                                           is
                                                                           a
                                                                           [34m[1mVFS[0m
                                                                           [1m[34mspecification[0m[1m[22m[139]
                                                                           for
                                                                           the
                                                                           location
                                                                           of
                                                                           the
                                                                           Rlinks
                                                                           (i.e.,
                                                                           a
                                                                           [1mDACS[0m
                                                                           URI,
                                                                           an
                                                                           item
                                                                           type,
                                                                           or
                                                                           an
                                                                           absolute
                                                                           pathname).
                                                                           If
                                                                           the
                                                                           expression
                                                                           evaluates
                                                                           to
                                                                           a
                                                                           non-empty
                                                                           string:

                                                                           +o   the
                                                                               string
                                                                               is
                                                                               assumed
                                                                               to
                                                                               be
                                                                               an
                                                                               [34m[1mRname[0m[1m[22m[138],
                                                                               which
                                                                               is
                                                                               relative
                                                                               to
                                                                               the
                                                                               VFS
                                                                               specification,

                                                                           +o   Rlink
                                                                               processing
                                                                               is
                                                                               enabled
                                                                               for
                                                                               the
                                                                               current
                                                                               request,
                                                                               and

                                                                           +o   no
                                                                               other
                                                                               RLINK
                                                                               directives
                                                                               are
                                                                               considered
                                                                               or
                                                                               evaluated.
                                                                               If
                                                                               the
                                                                               expression
                                                                               evaluates
                                                                               to
                                                                               the
                                                                               empty
                                                                               string
                                                                               or
                                                                               an
                                                                               error
                                                                               occurs,
                                                                               the
                                                                               directive
                                                                               is
                                                                               ignored
                                                                               and
                                                                               the
                                                                               next
                                                                               one,
                                                                               if
                                                                               any,
                                                                               is
                                                                               processed.
                                                                               Example:

                                                                                   RLINK '"${Args::RNAME:?}" /usr/local/dacs/rlinks'

                                                                               In
                                                                               the
                                                                               example
                                                                               above,
                                                                               the
                                                                               directive
                                                                               specifies
                                                                               that
                                                                               if
                                                                               the
                                                                               current
                                                                               request
                                                                               includes
                                                                               a
                                                                               non-empty
                                                                               argument
                                                                               called
                                                                               [4mRNAME[24m,
                                                                               then
                                                                               its
                                                                               value
                                                                               is
                                                                               an
                                                                               Rname,
                                                                               Rlink
                                                                               processing
                                                                               is
                                                                               enabled,
                                                                               and
                                                                               the
                                                                               Rlink
                                                                               can
                                                                               be
                                                                               found
                                                                               in
                                                                               the
                                                                               /usr/local/dacs/rlinks
                                                                               directory.

                                                                           ROLE_STRING_MAX_LENGTH
                                                                           (Optional1)
                                                                               A
                                                                               limit
                                                                               is
                                                                               imposed
                                                                               on
                                                                               the
                                                                               length
                                                                               of
                                                                               the
                                                                               role
                                                                               string
                                                                               returned
                                                                               by
                                                                               any
                                                                               authentication
                                                                               or
                                                                               roles
                                                                               service,
                                                                               the
                                                                               length
                                                                               of
                                                                               any
                                                                               intermediate
                                                                               role
                                                                               string
                                                                               formed
                                                                               by
                                                                               concatenation
                                                                               during
                                                                               determination
                                                                               of
                                                                               the
                                                                               role
                                                                               string,
                                                                               and
                                                                               the
                                                                               length
                                                                               of
                                                                               the
                                                                               final
                                                                               role
                                                                               string,
                                                                               which
                                                                               is
                                                                               used
                                                                               in
                                                                               credentials.
                                                                               A
                                                                               string
                                                                               that
                                                                               exceeds
                                                                               the
                                                                               limit
                                                                               is
                                                                               invalid
                                                                               and
                                                                               treated
                                                                               as
                                                                               an
                                                                               empty
                                                                               string.
                                                                               The
                                                                               limit
                                                                               is
                                                                               necessary
                                                                               because
                                                                               credentials
                                                                               (which
                                                                               may
                                                                               contain
                                                                               a
                                                                               role
                                                                               string)
                                                                               are
                                                                               encapsulated
                                                                               within
                                                                               an
                                                                               HTTP
                                                                               cookie
                                                                               and
                                                                               browsers
                                                                               have
                                                                               context-dependent
                                                                               and
                                                                               implementation-dependent
                                                                               restrictions
                                                                               on
                                                                               cookie
                                                                               lengths.
                                                                               This
                                                                               directive
                                                                               is
                                                                               used
                                                                               to
                                                                               set
                                                                               the
                                                                               limit,
                                                                               overriding
                                                                               a
                                                                               compile-time
                                                                               value
                                                                               of
                                                                               200
                                                                               bytes.
                                                                               Please
                                                                               refer
                                                                               to
                                                                               [34m[1mdacs_authenticate(8)[0m[1m[22m[48]
                                                                               for
                                                                               additional
                                                                               information
                                                                               about
                                                                               roles.

                                                                                   [1mWarning[0m
                                                                                   A
                                                                                   role
                                                                                   string
                                                                                   that
                                                                                   is
                                                                                   too
                                                                                   long
                                                                                   may
                                                                                   cause
                                                                                   the
                                                                                   user
                                                                                   to
                                                                                   experience
                                                                                   strange
                                                                                   and
                                                                                   possibly
                                                                                   incorrect
                                                                                   behaviour
                                                                                   from
                                                                                   [1mDACS[0m
                                                                                   because
                                                                                   the
                                                                                   browser
                                                                                   may
                                                                                   discard
                                                                                   cookies
                                                                                   produced
                                                                                   by
                                                                                   [1mDACS[22m.

                                                                           SECURE_MODE
                                                                           (Optional1)
                                                                               This
                                                                               directive
                                                                               causes
                                                                               [1mDACS[0m
                                                                               to
                                                                               operate
                                                                               "insecurely"
                                                                               only
                                                                               if
                                                                               its
                                                                               value
                                                                               is
                                                                               "no"
                                                                               or
                                                                               "off"
                                                                               (case
                                                                               insensitive),
                                                                               otherwise
                                                                               [1mDACS[0m
                                                                               will
                                                                               use
                                                                               a
                                                                               more
                                                                               secure
                                                                               mode
                                                                               of
                                                                               operation.
                                                                               In
                                                                               secure
                                                                               mode,
                                                                               [1mDACS[0m
                                                                               requires
                                                                               all
                                                                               user
                                                                               interactions
                                                                               to
                                                                               be
                                                                               through
                                                                               SSL
                                                                               (HTTPS)
                                                                               and
                                                                               cookies
                                                                               will
                                                                               have
                                                                               the
                                                                               secure
                                                                               attribute.
                                                                               The
                                                                               default
                                                                               is
                                                                               "yes".
                                                                               Odd
                                                                               behaviour
                                                                               may
                                                                               result
                                                                               if
                                                                               interactions
                                                                               between
                                                                               [1mDACS[0m
                                                                               and
                                                                               a
                                                                               particular
                                                                               client
                                                                               mix
                                                                               http
                                                                               and
                                                                               https
                                                                               requests
                                                                               (such
                                                                               as
                                                                               when
                                                                               handlers
                                                                               are
                                                                               involved).

                                                                                   [1mSecurity[0m
                                                                                   Always
                                                                                   use
                                                                                   the
                                                                                   secure
                                                                                   mode
                                                                                   of
                                                                                   operation
                                                                                   unless
                                                                                   you
                                                                                   fully
                                                                                   understand
                                                                                   the
                                                                                   consequences
                                                                                   of
                                                                                   disabling
                                                                                   it.
                                                                                   For
                                                                                   [1mDACS[0m
                                                                                   to
                                                                                   be
                                                                                   a
                                                                                   secure
                                                                                   system,
                                                                                   secure
                                                                                   mode
                                                                                   should
                                                                                   be
                                                                                   disabled
                                                                                   only
                                                                                   for
                                                                                   testing
                                                                                   purposes
                                                                                   or
                                                                                   if
                                                                                   all
                                                                                   HTTP
                                                                                   traffic
                                                                                   is
                                                                                   protected
                                                                                   by
                                                                                   some
                                                                                   secure
                                                                                   means
                                                                                   other
                                                                                   than
                                                                                   SSL.

                                                                           SIGNOUT_HANDLER
                                                                           (Optional1)
                                                                               After
                                                                               [34m[1mdacs_signout(8)[0m[1m[22m[33]
                                                                               successfully
                                                                               logs
                                                                               a
                                                                               user
                                                                               off,
                                                                               the
                                                                               subsequent
                                                                               action
                                                                               can
                                                                               be
                                                                               customized.
                                                                               In
                                                                               particular,
                                                                               this
                                                                               directive
                                                                               provides
                                                                               a
                                                                               way
                                                                               for
                                                                               the
                                                                               system
                                                                               administrator
                                                                               to
                                                                               redirect
                                                                               the
                                                                               user's
                                                                               browser,
                                                                               such
                                                                               as
                                                                               back
                                                                               to
                                                                               a
                                                                               login
                                                                               page.

                                                                               The
                                                                               following
                                                                               syntaxes
                                                                               are
                                                                               supported:


                                                                                   1. SIGNOUT_HANDLER
                                                                                   "[url]
                                                                                   [4mURL[24m"

                                                                                   This
                                                                                   form
                                                                                   will
                                                                                   cause
                                                                                   [1mDACS[0m
                                                                                   to
                                                                                   redirect
                                                                                   the
                                                                                   client
                                                                                   to
                                                                                   the
                                                                                   specified
                                                                                   URL,
                                                                                   which
                                                                                   may
                                                                                   be
                                                                                   a
                                                                                   relative
                                                                                   or
                                                                                   absolute
                                                                                   URL.
                                                                                   If
                                                                                   the
                                                                                   keyword
                                                                                   url
                                                                                   is
                                                                                   absent,
                                                                                   [4mURL[0m
                                                                                   must
                                                                                   begin
                                                                                   with
                                                                                   the
                                                                                   four
                                                                                   characters
                                                                                   http.
                                                                                   The
                                                                                   GET
                                                                                   method
                                                                                   is
                                                                                   used.
                                                                                   The
                                                                                   URL
                                                                                   may
                                                                                   contain
                                                                                   a
                                                                                   properly
                                                                                   escaped
                                                                                   query
                                                                                   string;
                                                                                   [1mDACS[0m
                                                                                   will
                                                                                   append
                                                                                   the
                                                                                   following
                                                                                   parameters,
                                                                                   in
                                                                                   the
                                                                                   order
                                                                                   given,
                                                                                   to
                                                                                   the
                                                                                   URL:

                                                                                   [4mDACS_VERSION[0m
                                                                                       The
                                                                                       version
                                                                                       number
                                                                                       of
                                                                                       [1mDACS[0m
                                                                                       (e.g.,
                                                                                       "1.4").

                                                                                   [4mDACS_FEDERATION[0m
                                                                                       The
                                                                                       federation
                                                                                       that
                                                                                       received
                                                                                       the
                                                                                       service
                                                                                       request,
                                                                                       if
                                                                                       available.

                                                                                   [4mDACS_JURISDICTION[0m
                                                                                       The
                                                                                       jurisdiction
                                                                                       that
                                                                                       received
                                                                                       the
                                                                                       service
                                                                                       request,
                                                                                       if
                                                                                       available.

                                                                                   The
                                                                                   values
                                                                                   of
                                                                                   these
                                                                                   parameters
                                                                                   are
                                                                                   URL
                                                                                   encoded.


                                                                                   2. SIGNOUT_HANDLER
                                                                                   "[file]
                                                                                   [4mfull-pathname[24m"

                                                                                   This
                                                                                   form
                                                                                   causes
                                                                                   the
                                                                                   contents
                                                                                   of
                                                                                   the
                                                                                   file
                                                                                   named
                                                                                   by
                                                                                   [4mfull-pathname[0m
                                                                                   to
                                                                                   be
                                                                                   returned.
                                                                                   The
                                                                                   file
                                                                                   must
                                                                                   include
                                                                                   any
                                                                                   header
                                                                                   lines
                                                                                   it
                                                                                   requires,
                                                                                   such
                                                                                   as
                                                                                   a
                                                                                   Content-Type
                                                                                   line,
                                                                                   a
                                                                                   header-terminating
                                                                                   blank
                                                                                   line,
                                                                                   and
                                                                                   then
                                                                                   the
                                                                                   document
                                                                                   content.

                                                                                       [1mNote[0m
                                                                                       The
                                                                                       "full-pathname"
                                                                                       usage
                                                                                       differs
                                                                                       from
                                                                                       the
                                                                                       "local-URL"
                                                                                       usage
                                                                                       of
                                                                                       the
                                                                                       ACS_ERROR_HANDLER
                                                                                       directive,
                                                                                       though
                                                                                       both
                                                                                       elements
                                                                                       begin
                                                                                       with
                                                                                       a
                                                                                       slash
                                                                                       character;
                                                                                       the
                                                                                       former
                                                                                       specifies
                                                                                       the
                                                                                       absolute
                                                                                       pathname
                                                                                       of
                                                                                       a
                                                                                       file,
                                                                                       while
                                                                                       the
                                                                                       latter
                                                                                       specifies
                                                                                       a
                                                                                       URL
                                                                                       local
                                                                                       to
                                                                                       the
                                                                                       receiving
                                                                                       web
                                                                                       server.
                                                                                       To
                                                                                       specify
                                                                                       a
                                                                                       relative
                                                                                       URL,
                                                                                       use
                                                                                       the
                                                                                       url
                                                                                       keyword.


                                                                                   3. SIGNOUT_HANDLER
                                                                                   "[message]
                                                                                   \"[4mmessage[24m\""

                                                                                   This
                                                                                   form
                                                                                   causes
                                                                                   the
                                                                                   given
                                                                                   message,
                                                                                   surrounded
                                                                                   by
                                                                                   escaped
                                                                                   double
                                                                                   quote
                                                                                   characters,
                                                                                   to
                                                                                   be
                                                                                   returned
                                                                                   as
                                                                                   HTML.


                                                                                   4. SIGNOUT_HANDLER
                                                                                   "credentials"

                                                                                   This
                                                                                   form
                                                                                   causes
                                                                                   the
                                                                                   user's
                                                                                   remaining
                                                                                   credentials
                                                                                   to
                                                                                   be
                                                                                   displayed
                                                                                   as
                                                                                   an
                                                                                   HTML
                                                                                   document.
                                                                                   This
                                                                                   is
                                                                                   the
                                                                                   default
                                                                                   behaviour.
                                                                                   The
                                                                                   optional
                                                                                   keywords
                                                                                   are
                                                                                   treated
                                                                                   case-insensitively.

                                                                               SSL_PROG
                                                                               (Optional1)
                                                                                   The
                                                                                   full
                                                                                   pathname
                                                                                   of
                                                                                   the
                                                                                   command
                                                                                   used
                                                                                   to
                                                                                   provide
                                                                                   an
                                                                                   SSL
                                                                                   connection
                                                                                   for
                                                                                   group
                                                                                   information
                                                                                   distribution.
                                                                                   Currently,
                                                                                   only
                                                                                   [34m[1msslclient(1)[0m[1m[22m[140]
                                                                                   is
                                                                                   supported
                                                                                   for
                                                                                   this
                                                                                   purpose.

                                                                               SSL_PROG_ARGS
                                                                               (Optional1)
                                                                                   Additional
                                                                                   command
                                                                                   line
                                                                                   arguments
                                                                                   to
                                                                                   be
                                                                                   passed
                                                                                   to
                                                                                   SSL_PROG.

                                                                                       [1mNote[0m
                                                                                       This
                                                                                       directive
                                                                                       is
                                                                                       "global"
                                                                                       in
                                                                                       that
                                                                                       it
                                                                                       applies
                                                                                       to
                                                                                       all
                                                                                       internal
                                                                                       invocations
                                                                                       of
                                                                                       SSL_PROG.
                                                                                       SSL
                                                                                       options
                                                                                       should
                                                                                       probably
                                                                                       be
                                                                                       more
                                                                                       flexibly
                                                                                       configurable
                                                                                       (e.g.,
                                                                                       from
                                                                                       within
                                                                                       Auth
                                                                                       and
                                                                                       Roles
                                                                                       clauses).

                                                                               SSL_PROG_CA_CRT
                                                                               (Optional1)
                                                                                   The
                                                                                   full
                                                                                   pathname
                                                                                   of
                                                                                   the
                                                                                   file
                                                                                   containing
                                                                                   the
                                                                                   CA
                                                                                   certificate
                                                                                   shared
                                                                                   by
                                                                                   this
                                                                                   [1mDACS[0m
                                                                                   federation.
                                                                                   This
                                                                                   is
                                                                                   passed
                                                                                   to
                                                                                   SSL_PROG
                                                                                   so
                                                                                   that
                                                                                   certificates
                                                                                   can
                                                                                   be
                                                                                   validated.

                                                                               SSL_PROG_CLIENT_CRT
                                                                               (Optional1)
                                                                                   This
                                                                                   provides
                                                                                   the
                                                                                   name
                                                                                   of
                                                                                   a
                                                                                   private
                                                                                   key
                                                                                   and
                                                                                   certificate
                                                                                   chain
                                                                                   PEM
                                                                                   file.
                                                                                   Please
                                                                                   refer
                                                                                   to
                                                                                   [34m[1msslclient(1)'s[0m[1m[22m[140]
                                                                                   [1m-ccf[0m
                                                                                   flag.

                                                                               STATUS_LINE
                                                                               (Optional1)
                                                                                   If
                                                                                   this
                                                                                   directive
                                                                                   is
                                                                                   set
                                                                                   to
                                                                                   "on",
                                                                                   [34m[1mdacs_acs(8)[0m[1m[22m[6]
                                                                                   will
                                                                                   emit
                                                                                   a
                                                                                   [34m[1mDACS-Status-Line[0m[1m[22m[141]
                                                                                   header
                                                                                   in
                                                                                   the
                                                                                   response
                                                                                   from
                                                                                   the
                                                                                   server.
                                                                                   The
                                                                                   default
                                                                                   value
                                                                                   is
                                                                                   "off".
                                                                                   See
                                                                                   the
                                                                                   description
                                                                                   of
                                                                                   the
                                                                                   [34m[1mDACS_ACS[0m
                                                                                   [1m[34margument[0m[1m[22m[49]
                                                                                   for
                                                                                   additional
                                                                                   details.

                                                                               TEMP_DIRECTORY
                                                                               (Optional1)
                                                                                   A
                                                                                   directory
                                                                                   where
                                                                                   [1mDACS[0m
                                                                                   can
                                                                                   create
                                                                                   temporary
                                                                                   files.
                                                                                   If
                                                                                   the
                                                                                   value
                                                                                   is
                                                                                   not
                                                                                   an
                                                                                   absolute
                                                                                   path,
                                                                                   the
                                                                                   location
                                                                                   is
                                                                                   relative
                                                                                   to
                                                                                   [34m[1mDACS_HOME[0m[1m[22m[142].
                                                                                   Lock
                                                                                   files,
                                                                                   for
                                                                                   example,
                                                                                   are
                                                                                   put
                                                                                   in
                                                                                   this
                                                                                   directory.
                                                                                   If
                                                                                   not
                                                                                   configured
                                                                                   or
                                                                                   if
                                                                                   this
                                                                                   directory
                                                                                   does
                                                                                   not
                                                                                   exist,
                                                                                   a
                                                                                   compile-time
                                                                                   path
                                                                                   (DEFAULT_TEMP_DIRECTORY)
                                                                                   is
                                                                                   used
                                                                                   (currently:
                                                                                   /tmp).
                                                                                   It
                                                                                   is
                                                                                   always
                                                                                   safe
                                                                                   to
                                                                                   delete
                                                                                   the
                                                                                   contents
                                                                                   of
                                                                                   this
                                                                                   directory
                                                                                   if
                                                                                   [1mDACS[0m
                                                                                   is
                                                                                   not
                                                                                   running.

                                                                               TOKEN_REQUIRES_PIN
                                                                               (Optional1)
                                                                                   If
                                                                                   set
                                                                                   to
                                                                                   no,
                                                                                   then
                                                                                   [34m[1mdacstoken(1)[0m[1m[22m[130]
                                                                                   does
                                                                                   not
                                                                                   require
                                                                                   created
                                                                                   or
                                                                                   imported
                                                                                   accounts
                                                                                   to
                                                                                   have
                                                                                   a
                                                                                   PIN.
                                                                                   The
                                                                                   default
                                                                                   value
                                                                                   is
                                                                                   yes,
                                                                                   and
                                                                                   a
                                                                                   PIN
                                                                                   is
                                                                                   required.

                                                                               TOKEN_HOTP_ACCEPT_WINDOW
                                                                               (Optional1)
                                                                                   When
                                                                                   validating
                                                                                   or
                                                                                   authenticating
                                                                                   against
                                                                                   a
                                                                                   given
                                                                                   one-time
                                                                                   password,
                                                                                   this
                                                                                   is
                                                                                   the
                                                                                   maximum
                                                                                   number
                                                                                   of
                                                                                   successive
                                                                                   counter
                                                                                   values
                                                                                   to
                                                                                   consider,
                                                                                   if
                                                                                   necessary,
                                                                                   after
                                                                                   the
                                                                                   expected
                                                                                   counter
                                                                                   value.
                                                                                   A
                                                                                   value
                                                                                   of
                                                                                   zero
                                                                                   disables
                                                                                   this
                                                                                   search.
                                                                                   If
                                                                                   not
                                                                                   configured,
                                                                                   a
                                                                                   compile-time
                                                                                   value
                                                                                   is
                                                                                   used
                                                                                   (currently,
                                                                                   3).

                                                                               TRACE_LEVEL
                                                                               (Optional1)
                                                                                   If
                                                                                   assigned
                                                                                   a
                                                                                   non-zero
                                                                                   value,
                                                                                   tracing
                                                                                   is
                                                                                   enabled
                                                                                   in
                                                                                   various
                                                                                   [1mDACS[0m
                                                                                   services.
                                                                                   Larger
                                                                                   values
                                                                                   will
                                                                                   cause
                                                                                   more
                                                                                   events
                                                                                   to
                                                                                   be
                                                                                   traced.
                                                                                   This
                                                                                   is
                                                                                   intended
                                                                                   to
                                                                                   give
                                                                                   an
                                                                                   indication
                                                                                   of
                                                                                   the
                                                                                   steps
                                                                                   a
                                                                                   [1mDACS[0m
                                                                                   service
                                                                                   takes
                                                                                   during
                                                                                   execution
                                                                                   for
                                                                                   debugging
                                                                                   purposes.
                                                                                   Logging
                                                                                   information
                                                                                   is
                                                                                   generally
                                                                                   written
                                                                                   to
                                                                                   the
                                                                                   web
                                                                                   server's
                                                                                   log
                                                                                   file
                                                                                   or
                                                                                   to
                                                                                   a
                                                                                   file
                                                                                   configured
                                                                                   into
                                                                                   [1mDACS[0m
                                                                                   at
                                                                                   compile
                                                                                   time.
                                                                                   Also
                                                                                   see
                                                                                   LOG_LEVEL
                                                                                   and
                                                                                   VERBOSE_LEVEL.

                                                                               UNAUTH_ROLES
                                                                               (Optional1)
                                                                                   This
                                                                                   directive
                                                                                   is
                                                                                   used
                                                                                   to
                                                                                   assign
                                                                                   a
                                                                                   [34m[1mrole[0m
                                                                                   [1m[34mdescriptor[0m
                                                                                   [1m[34mstring[0m[1m[22m[143]
                                                                                   to
                                                                                   [4munauthenticated[0m
                                                                                   users.
                                                                                   Association
                                                                                   with
                                                                                   these
                                                                                   roles
                                                                                   can
                                                                                   be
                                                                                   tested
                                                                                   using
                                                                                   the
                                                                                   [34m[1muser()[0m[1m[22m[144]
                                                                                   predicate.

                                                                                   If
                                                                                   a
                                                                                   jurisdiction
                                                                                   configures
                                                                                   this
                                                                                   directive:

                                                                                       UNAUTH_ROLES "anonymous"

                                                                                   then
                                                                                   the
                                                                                   following
                                                                                   predicates
                                                                                   would
                                                                                   both
                                                                                   return
                                                                                   [1mTrue[0m
                                                                                   when
                                                                                   applied
                                                                                   to
                                                                                   an
                                                                                   unauthenticated
                                                                                   user:


                                                                                       user("unauth")
                                                                                       user("%:anonymous")

                                                                                   A
                                                                                   useful
                                                                                   application
                                                                                   of
                                                                                   this
                                                                                   directive
                                                                                   is
                                                                                   to
                                                                                   classify
                                                                                   unauthenticated
                                                                                   users
                                                                                   based
                                                                                   on
                                                                                   contextual
                                                                                   elements.
                                                                                   Consider
                                                                                   this
                                                                                   directive:

                                                                                       UNAUTH_ROLES from("10.0.0.0/24") ? "user" : ""

                                                                                   If
                                                                                   an
                                                                                   unauthenticated
                                                                                   user
                                                                                   submits
                                                                                   a
                                                                                   request
                                                                                   from
                                                                                   a
                                                                                   local
                                                                                   IP
                                                                                   address
                                                                                   between
                                                                                   10.0.0.0
                                                                                   and
                                                                                   10.0.0.255,
                                                                                   the
                                                                                   user
                                                                                   would
                                                                                   be
                                                                                   treated
                                                                                   as
                                                                                   having
                                                                                   the
                                                                                   role
                                                                                   user,
                                                                                   otherwise
                                                                                   the
                                                                                   user
                                                                                   would
                                                                                   have
                                                                                   no
                                                                                   roles.
                                                                                   This
                                                                                   might
                                                                                   be
                                                                                   used
                                                                                   to
                                                                                   conveniently
                                                                                   grant
                                                                                   limited
                                                                                   access
                                                                                   to
                                                                                   "local"
                                                                                   users
                                                                                   without
                                                                                   them
                                                                                   having
                                                                                   to
                                                                                   authenticate.
                                                                                   A
                                                                                   rule
                                                                                   could
                                                                                   be
                                                                                   written
                                                                                   to
                                                                                   grant
                                                                                   access
                                                                                   based
                                                                                   on
                                                                                   having
                                                                                   the
                                                                                   role
                                                                                   user,
                                                                                   for
                                                                                   example,
                                                                                   without
                                                                                   needing
                                                                                   to
                                                                                   consider
                                                                                   whether
                                                                                   or
                                                                                   not
                                                                                   the
                                                                                   user
                                                                                   has
                                                                                   authenticated.

                                                                                   Unlike
                                                                                   roles
                                                                                   assigned
                                                                                   to
                                                                                   credentials,
                                                                                   roles
                                                                                   specified
                                                                                   in
                                                                                   this
                                                                                   way
                                                                                   are
                                                                                   strictly
                                                                                   local
                                                                                   to
                                                                                   the
                                                                                   jurisdiction
                                                                                   that
                                                                                   configures
                                                                                   them.
                                                                                   Some
                                                                                   form
                                                                                   of
                                                                                   coordination
                                                                                   is
                                                                                   required
                                                                                   if
                                                                                   different
                                                                                   jurisdictions
                                                                                   need
                                                                                   to
                                                                                   assign
                                                                                   the
                                                                                   same
                                                                                   roles
                                                                                   to
                                                                                   unauthenticated
                                                                                   users.
                                                                                   These
                                                                                   roles
                                                                                   are
                                                                                   not
                                                                                   reported
                                                                                   by
                                                                                   [34m[1mdacs_current_credentials(8)[0m[1m[22m[88].

                                                                               UPROXY_APPROVED
                                                                               (Stack)
                                                                                   This
                                                                                   directive
                                                                                   is
                                                                                   used
                                                                                   by
                                                                                   [34m[1mdacs_uproxy(8)[0m[1m[22m[145]
                                                                                   to
                                                                                   enable
                                                                                   proxying
                                                                                   to
                                                                                   one
                                                                                   or
                                                                                   more
                                                                                   hosts
                                                                                   and
                                                                                   to
                                                                                   configure
                                                                                   each
                                                                                   of
                                                                                   those
                                                                                   mappings.
                                                                                   Each
                                                                                   directive
                                                                                   specifies
                                                                                   a
                                                                                   member
                                                                                   of
                                                                                   the
                                                                                   "approved
                                                                                   list"
                                                                                   (i.e.,
                                                                                   a
                                                                                   host
                                                                                   that
                                                                                   may
                                                                                   be
                                                                                   proxied)
                                                                                   using
                                                                                   the
                                                                                   following
                                                                                   syntax:

                                                                                       [{'http' | 'https'} '://'] [4mhostname[24m [:[4mport[24m] [[4mpath[24m]

                                                                                   [1mdacs_uproxy[0m
                                                                                   is
                                                                                   invoked
                                                                                   with
                                                                                   a
                                                                                   URI
                                                                                   with
                                                                                   the
                                                                                   following
                                                                                   syntax:

                                                                                       .../dacs_uproxy/[4mproxied-hostname[24m[:[4mproxied-port[24m][[4mproxied-path-prefix[24m]

                                                                                   A
                                                                                   [4mproxied-hostname[0m
                                                                                   is
                                                                                   matched
                                                                                   against
                                                                                   the
                                                                                   [4mhostname[0m
                                                                                   of
                                                                                   each
                                                                                   entry
                                                                                   in
                                                                                   the
                                                                                   list,
                                                                                   according
                                                                                   to
                                                                                   the
                                                                                   stacked
                                                                                   directive
                                                                                   ordering,
                                                                                   until
                                                                                   a
                                                                                   (case
                                                                                   insensitive)
                                                                                   match
                                                                                   is
                                                                                   found.
                                                                                   If
                                                                                   the
                                                                                   [4mproxied-hostname[0m
                                                                                   is
                                                                                   followed
                                                                                   by
                                                                                   a
                                                                                   port
                                                                                   number,
                                                                                   that
                                                                                   port
                                                                                   number
                                                                                   must
                                                                                   be
                                                                                   explicitly
                                                                                   specified
                                                                                   in
                                                                                   a
                                                                                   directive
                                                                                   for
                                                                                   a
                                                                                   match
                                                                                   to
                                                                                   occur.
                                                                                   If
                                                                                   no
                                                                                   scheme
                                                                                   is
                                                                                   specified,
                                                                                   http
                                                                                   is
                                                                                   used,
                                                                                   regardless
                                                                                   of
                                                                                   what
                                                                                   protocol
                                                                                   the
                                                                                   [4mport[0m
                                                                                   may
                                                                                   imply.
                                                                                   If
                                                                                   a
                                                                                   [4mpath[0m
                                                                                   is
                                                                                   given,
                                                                                   it
                                                                                   is
                                                                                   appended
                                                                                   to
                                                                                   the
                                                                                   [4mproxied-path-prefix[24m.

                                                                                   For
                                                                                   example,
                                                                                   consider
                                                                                   the
                                                                                   directives:

                                                                                       UPROXY_APPROVED "example.com"
                                                                                       UPROXY_APPROVED "https://foo.example.com"
                                                                                       UPROXY_APPROVED "http://bar.example.com:8080"
                                                                                       UPROXY_APPROVED "https://baz.example.com:8443/some/path"

                                                                                   A
                                                                                   request
                                                                                   for
                                                                                   the
                                                                                   proxied
                                                                                   hostname
                                                                                   foo.example.com,
                                                                                   such
                                                                                   as
                                                                                   this:

                                                                                       .../dacs_uproxy/foo.example.com/a/b/c.cgi

                                                                                   will
                                                                                   be
                                                                                   forwarded
                                                                                   by
                                                                                   [1mdacs_uproxy[0m
                                                                                   as
                                                                                   the
                                                                                   URI:

                                                                                       https://foo.example.com/a/b/c.cgi

                                                                                   And
                                                                                   the
                                                                                   proxied
                                                                                   request:

                                                                                       .../dacs_uproxy/baz.example.com/a/b/c.cgi

                                                                                   will
                                                                                   be
                                                                                   forwarded
                                                                                   by
                                                                                   [1mdacs_uproxy[0m
                                                                                   as
                                                                                   the
                                                                                   URI:

                                                                                       https://baz.example.com:8443/some/path/a/b/c.cgi

                                                                                   This
                                                                                   request
                                                                                   would
                                                                                   fail
                                                                                   because
                                                                                   there
                                                                                   is
                                                                                   no
                                                                                   approved
                                                                                   entry
                                                                                   for
                                                                                   bar.example.com:80:

                                                                                       .../dacs_uproxy/bar.example.com:80/a/b/c.cgi


                                                                               VERBOSE_LEVEL
                                                                               (Optional1)
                                                                                   If
                                                                                   assigned
                                                                                   a
                                                                                   non-zero
                                                                                   value,
                                                                                   debugging
                                                                                   output
                                                                                   is
                                                                                   enabled
                                                                                   in
                                                                                   various
                                                                                   [1mDACS[0m
                                                                                   services.
                                                                                   Larger
                                                                                   values
                                                                                   will
                                                                                   cause
                                                                                   more
                                                                                   output
                                                                                   to
                                                                                   be
                                                                                   generated.
                                                                                   This
                                                                                   is
                                                                                   intended
                                                                                   to
                                                                                   display
                                                                                   input
                                                                                   arguments
                                                                                   and
                                                                                   the
                                                                                   values
                                                                                   of
                                                                                   variables
                                                                                   as
                                                                                   a
                                                                                   [1mDACS[0m
                                                                                   service
                                                                                   is
                                                                                   executed,
                                                                                   for
                                                                                   debugging
                                                                                   purposes.
                                                                                   Logging
                                                                                   information
                                                                                   is
                                                                                   generally
                                                                                   written
                                                                                   to
                                                                                   the
                                                                                   web
                                                                                   server's
                                                                                   log
                                                                                   file
                                                                                   or
                                                                                   to
                                                                                   a
                                                                                   file
                                                                                   configured
                                                                                   into
                                                                                   [1mDACS[0m
                                                                                   at
                                                                                   compile
                                                                                   time.
                                                                                   Also
                                                                                   see
                                                                                   LOG_LEVEL
                                                                                   and
                                                                                   TRACE_LEVEL.

                                                                               VERIFY_IP
                                                                               (Required1)
                                                                                   If
                                                                                   "yes",
                                                                                   then
                                                                                   the
                                                                                   IP
                                                                                   address
                                                                                   in
                                                                                   credentials
                                                                                   must
                                                                                   exactly
                                                                                   match
                                                                                   the
                                                                                   IP
                                                                                   address
                                                                                   from
                                                                                   which
                                                                                   a
                                                                                   service
                                                                                   request
                                                                                   is
                                                                                   made.
                                                                                   For
                                                                                   example,
                                                                                   if
                                                                                   [1mDACS[0m
                                                                                   issued
                                                                                   credentials
                                                                                   in
                                                                                   response
                                                                                   to
                                                                                   an
                                                                                   authentication
                                                                                   request
                                                                                   that
                                                                                   came
                                                                                   from
                                                                                   the
                                                                                   IP
                                                                                   address
                                                                                   10.0.0.123,
                                                                                   then
                                                                                   these
                                                                                   credentials
                                                                                   will
                                                                                   only
                                                                                   be
                                                                                   considered
                                                                                   valid
                                                                                   for
                                                                                   service
                                                                                   requests
                                                                                   that
                                                                                   come
                                                                                   from
                                                                                   that
                                                                                   IP
                                                                                   address.
                                                                                   If
                                                                                   the
                                                                                   directive's
                                                                                   value
                                                                                   is
                                                                                   "no",
                                                                                   this
                                                                                   verification
                                                                                   is
                                                                                   not
                                                                                   performed.
                                                                                   Any
                                                                                   other
                                                                                   value
                                                                                   is
                                                                                   assumed
                                                                                   to
                                                                                   be
                                                                                   a
                                                                                   valid
                                                                                   argument
                                                                                   to
                                                                                   the
                                                                                   [34m[1mfrom()[0m[1m[22m[146]
                                                                                   predicate:

                                                                                       # Only credentials that were issued to an address on this subnet
                                                                                       # are acceptable
                                                                                       VERIFY_IP "10.0.0.0/24"


                                                                                       [1mTip[0m
                                                                                       Verification
                                                                                       might
                                                                                       be
                                                                                       turned
                                                                                       off,
                                                                                       for
                                                                                       example,
                                                                                       in
                                                                                       an
                                                                                       environment
                                                                                       where
                                                                                       a
                                                                                       user
                                                                                       might
                                                                                       legitimately
                                                                                       submit
                                                                                       service
                                                                                       requests
                                                                                       associated
                                                                                       with
                                                                                       different
                                                                                       IP
                                                                                       addresses.
                                                                                       Refer
                                                                                       to
                                                                                       [34m[1mdacs_authenticate(8)[0m[1m[22m[61]
                                                                                       for
                                                                                       additional
                                                                                       information.

                                                                               VERIFY_UA
                                                                               (Optional1)
                                                                                   If
                                                                                   "yes",
                                                                                   then
                                                                                   the
                                                                                   user
                                                                                   agent
                                                                                   string
                                                                                   presented
                                                                                   when
                                                                                   authentication
                                                                                   occurred
                                                                                   (the
                                                                                   USER-AGENT
                                                                                   request
                                                                                   header,
                                                                                   exported
                                                                                   by
                                                                                   [1mApache[0m
                                                                                   as
                                                                                   [1mHTTP_USER_AGENT[22m)
                                                                                   must
                                                                                   match
                                                                                   the
                                                                                   user
                                                                                   agent
                                                                                   string
                                                                                   that
                                                                                   is
                                                                                   sent
                                                                                   with
                                                                                   subsequent
                                                                                   requests
                                                                                   using
                                                                                   those
                                                                                   credentials.
                                                                                   This
                                                                                   is
                                                                                   the
                                                                                   default.
                                                                                   If
                                                                                   the
                                                                                   directive's
                                                                                   value
                                                                                   is
                                                                                   "no",
                                                                                   this
                                                                                   verification
                                                                                   is
                                                                                   not
                                                                                   performed
                                                                                   at
                                                                                   this
                                                                                   jurisdiction
                                                                                   but
                                                                                   credentials
                                                                                   it
                                                                                   produces
                                                                                   can
                                                                                   still
                                                                                   be
                                                                                   verified
                                                                                   by
                                                                                   other
                                                                                   jurisdictions.
                                                                                   If
                                                                                   the
                                                                                   directive's
                                                                                   value
                                                                                   is
                                                                                   "disable",
                                                                                   the
                                                                                   feature
                                                                                   is
                                                                                   totally
                                                                                   disabled
                                                                                   at
                                                                                   this
                                                                                   jurisdiction.
                                                                                   The
                                                                                   feature
                                                                                   is
                                                                                   always
                                                                                   disabled
                                                                                   for
                                                                                   certain
                                                                                   internally-generated
                                                                                   credentials.

                                                                                       [1mSecurity[0m
                                                                                       In
                                                                                       typical
                                                                                       use
                                                                                       of
                                                                                       [1mDACS[22m,
                                                                                       this
                                                                                       feature
                                                                                       should
                                                                                       be
                                                                                       enabled
                                                                                       because
                                                                                       it
                                                                                       makes
                                                                                       it
                                                                                       somewhat
                                                                                       more
                                                                                       difficult
                                                                                       for
                                                                                       misappropriated
                                                                                       [1mDACS[0m
                                                                                       credentials
                                                                                       to
                                                                                       be
                                                                                       used.
                                                                                       It
                                                                                       is
                                                                                       not
                                                                                       a
                                                                                       foolproof
                                                                                       measure,
                                                                                       however,
                                                                                       because
                                                                                       a
                                                                                       sophisticated
                                                                                       attacker
                                                                                       may
                                                                                       be
                                                                                       able
                                                                                       to
                                                                                       obtain
                                                                                       or
                                                                                       guess
                                                                                       a
                                                                                       user
                                                                                       agent
                                                                                       string
                                                                                       and
                                                                                       use
                                                                                       it
                                                                                       with
                                                                                       stolen
                                                                                       credentials,
                                                                                       although
                                                                                       guesses
                                                                                       may
                                                                                       draw
                                                                                       attention
                                                                                       by
                                                                                       causing
                                                                                       log
                                                                                       messages
                                                                                       to
                                                                                       be
                                                                                       emitted.

                                                                                       Some
                                                                                       user
                                                                                       agents,
                                                                                       including
                                                                                       [34m[1mdacshttp(1)[0m[1m[22m[4],
                                                                                       [1mMozilla[22m,
                                                                                       [1mFirefox[22m,
                                                                                       [1mcurl[22m,
                                                                                       [1mwget[22m,
                                                                                       and
                                                                                       [1mKonqueror[22m,
                                                                                       allow
                                                                                       the
                                                                                       user
                                                                                       agent
                                                                                       string
                                                                                       to
                                                                                       be
                                                                                       set.
                                                                                       Including
                                                                                       a
                                                                                       random
                                                                                       or
                                                                                       unusual
                                                                                       component
                                                                                       in
                                                                                       the
                                                                                       string
                                                                                       will
                                                                                       strengthen
                                                                                       this
                                                                                       feature.
                                                                                       Also,
                                                                                       middleware
                                                                                       may
                                                                                       be
                                                                                       able
                                                                                       to
                                                                                       take
                                                                                       advantage
                                                                                       of
                                                                                       its
                                                                                       ability
                                                                                       to
                                                                                       send
                                                                                       a
                                                                                       string
                                                                                       of
                                                                                       its
                                                                                       choosing
                                                                                       in
                                                                                       the
                                                                                       User-Agent
                                                                                       header
                                                                                       field.

                                                                                       Verification
                                                                                       might
                                                                                       be
                                                                                       turned
                                                                                       off,
                                                                                       for
                                                                                       example,
                                                                                       in
                                                                                       proxying
                                                                                       situations
                                                                                       or
                                                                                       if
                                                                                       credentials
                                                                                       are
                                                                                       cached
                                                                                       by
                                                                                       middleware
                                                                                       and
                                                                                       then
                                                                                       legitimately
                                                                                       used
                                                                                       with
                                                                                       different
                                                                                       user
                                                                                       agents.
                                                                                       The
                                                                                       feature
                                                                                       should
                                                                                       be
                                                                                       disabled
                                                                                       for
                                                                                       backward
                                                                                       compatibility
                                                                                       with
                                                                                       releases
                                                                                       earlier
                                                                                       than
                                                                                       [1mDACS[0m
                                                                                       1.4.14.

                                                                               VFS
                                                                               (Stack)
                                                                                   These
                                                                                   directives
                                                                                   are
                                                                                   used
                                                                                   to
                                                                                   configure
                                                                                   the
                                                                                   virtual
                                                                                   filestore
                                                                                   (VFS)
                                                                                   subsystem
                                                                                   (see
                                                                                   [34m[1mdacs.vfs(5)[0m[1m[22m[147]
                                                                                   and
                                                                                   [34m[1mdacsvfs(1)[0m[1m[22m[148]
                                                                                   for
                                                                                   details).

                                                                                   The
                                                                                   value
                                                                                   of
                                                                                   this
                                                                                   directive
                                                                                   (a
                                                                                   vfs_uri)
                                                                                   has
                                                                                   the
                                                                                   following
                                                                                   syntax:

                                                                                       vfs_uri -> [ '[' [4mitem_type[24m ']' ] [4mURI[0m

                                                                                   As
                                                                                   specified
                                                                                   in
                                                                                   [34m[1mRFC[0m
                                                                                   [1m[34m2396[0m[1m[22m[100]
                                                                                   and
                                                                                   [34m[1mRFC[0m
                                                                                   [1m[34m3986[0m[1m[22m[149],
                                                                                   the
                                                                                   general
                                                                                   form
                                                                                   of
                                                                                   the
                                                                                   URI
                                                                                   syntax
                                                                                   is:

                                                                                       [4mscheme[24m : [ // [4mauthority[24m] [[4mpath[24m] [[4mquery[24m] [[4mfragment[24m]

                                                                                   The
                                                                                   [4mitem_type[0m
                                                                                   (see
                                                                                   [34m[1mdacs(1)[0m[1m[22m[150])
                                                                                   is
                                                                                   optional
                                                                                   in
                                                                                   some
                                                                                   cases
                                                                                   -
                                                                                   it
                                                                                   can
                                                                                   usually
                                                                                   be
                                                                                   omitted
                                                                                   if
                                                                                   the
                                                                                   directive
                                                                                   will
                                                                                   not
                                                                                   be
                                                                                   referenced
                                                                                   and
                                                                                   if
                                                                                   it
                                                                                   does
                                                                                   not
                                                                                   refer
                                                                                   to
                                                                                   an
                                                                                   indexed
                                                                                   object.
                                                                                   It
                                                                                   is
                                                                                   a
                                                                                   case-sensitive
                                                                                   label
                                                                                   that
                                                                                   associates
                                                                                   this
                                                                                   directive
                                                                                   with
                                                                                   a
                                                                                   class
                                                                                   of
                                                                                   objects
                                                                                   used
                                                                                   by
                                                                                   [1mDACS[22m.
                                                                                   Some
                                                                                   labels
                                                                                   are
                                                                                   reserved
                                                                                   and
                                                                                   have
                                                                                   predefined
                                                                                   meaning
                                                                                   to
                                                                                   [1mDACS[22m;
                                                                                   these
                                                                                   are
                                                                                   always
                                                                                   lowercase;
                                                                                   [34m[1mdacsconf(1)[0m[1m[22m[2]
                                                                                   can
                                                                                   list
                                                                                   them.
                                                                                   Any
                                                                                   label
                                                                                   can
                                                                                   be
                                                                                   defined
                                                                                   by
                                                                                   a
                                                                                   [1mDACS[0m
                                                                                   administrator,
                                                                                   but
                                                                                   a
                                                                                   reserved
                                                                                   item
                                                                                   type
                                                                                   should
                                                                                   only
                                                                                   be
                                                                                   defined
                                                                                   for
                                                                                   its
                                                                                   intended
                                                                                   use;
                                                                                   user-defined
                                                                                   item
                                                                                   types
                                                                                   should
                                                                                   therefore
                                                                                   include
                                                                                   at
                                                                                   least
                                                                                   one
                                                                                   uppercase
                                                                                   letter.
                                                                                   For
                                                                                   example,
                                                                                   here
                                                                                   are
                                                                                   a
                                                                                   few
                                                                                   reserved
                                                                                   item
                                                                                   types:
                                                                                   passwds
                                                                                   (used
                                                                                   by
                                                                                   [34m[1mdacspasswd(1)[0m[1m[22m[129]
                                                                                   and
                                                                                   others),
                                                                                   federation_keys
                                                                                   and
                                                                                   jurisdiction_keys
                                                                                   (used
                                                                                   by
                                                                                   [34m[1mdacskey(1)[0m[1m[22m[151]
                                                                                   and
                                                                                   others),
                                                                                   revocations
                                                                                   (used
                                                                                   by
                                                                                   [34m[1mdacs.acls(5)[0m[1m[22m[25]
                                                                                   and
                                                                                   others),
                                                                                   and
                                                                                   stdin
                                                                                   (used
                                                                                   by
                                                                                   [34m[1mget()[0m[1m[22m[152]
                                                                                   and
                                                                                   others).

                                                                                   Although
                                                                                   the
                                                                                   [4mscheme[0m
                                                                                   is
                                                                                   case-insensitive,
                                                                                   the
                                                                                   canonical
                                                                                   form
                                                                                   is
                                                                                   lowercase.
                                                                                   The
                                                                                   [4mauthority[24m,
                                                                                   [4mquery[24m,
                                                                                   and
                                                                                   [4mfragment[0m
                                                                                   URI
                                                                                   components
                                                                                   are
                                                                                   often
                                                                                   absent.
                                                                                   The
                                                                                   [4mquery[0m
                                                                                   component
                                                                                   is
                                                                                   used
                                                                                   to
                                                                                   specify
                                                                                   options.

                                                                                   The
                                                                                   [4mpath[0m
                                                                                   component
                                                                                   of
                                                                                   a
                                                                                   URI
                                                                                   has
                                                                                   the
                                                                                   format:

                                                                                       [ [4mnaming_context[24m ] [ "," [4mrel-path[24m ]

                                                                                   For
                                                                                   paths
                                                                                   that
                                                                                   have
                                                                                   a
                                                                                   separate
                                                                                   key
                                                                                   relative
                                                                                   to
                                                                                   the
                                                                                   naming
                                                                                   context,
                                                                                   its
                                                                                   start
                                                                                   is
                                                                                   delimited
                                                                                   by
                                                                                   a
                                                                                   comma.

                                                                                   The
                                                                                   [4mscheme[0m
                                                                                   may
                                                                                   be:

                                                                                   dacs-db
                                                                                       A
                                                                                       [34m[1mBerkeley[0m
                                                                                       [1m[34mDB[0m[1m[22m[153],
                                                                                       a
                                                                                       hash-based
                                                                                       database
                                                                                       that
                                                                                       manages
                                                                                       a
                                                                                       collection
                                                                                       of
                                                                                       objects
                                                                                       within
                                                                                       a
                                                                                       regular
                                                                                       file.
                                                                                       The
                                                                                       [4mitem_type[0m
                                                                                       is
                                                                                       required
                                                                                       because
                                                                                       it
                                                                                       forms
                                                                                       the
                                                                                       initial
                                                                                       part
                                                                                       of
                                                                                       the
                                                                                       key.

                                                                                   dacs-ndbm
                                                                                       The
                                                                                       Unix
                                                                                       [34m[1mdbm(3)[0m[1m[22m[154]
                                                                                       API
                                                                                       (includes
                                                                                       [34m[1mGNU[0m
                                                                                       [1m[34mgdbm[0m[1m[22m[155]),
                                                                                       which
                                                                                       is
                                                                                       similar
                                                                                       to
                                                                                       dacs-db.
                                                                                       The
                                                                                       [4mitem_type[0m
                                                                                       is
                                                                                       required
                                                                                       because
                                                                                       it
                                                                                       forms
                                                                                       the
                                                                                       initial
                                                                                       part
                                                                                       of
                                                                                       the
                                                                                       key.

                                                                                   dacs-fs
                                                                                   fs
                                                                                   file
                                                                                       Files
                                                                                       and
                                                                                       directories
                                                                                       managed
                                                                                       through
                                                                                       filesystem
                                                                                       operations.
                                                                                       Where
                                                                                       [4mpath[0m
                                                                                       names
                                                                                       a
                                                                                       directory,
                                                                                       each
                                                                                       key
                                                                                       maps
                                                                                       to
                                                                                       a
                                                                                       regular
                                                                                       file
                                                                                       within
                                                                                       that
                                                                                       directory.

                                                                                   dacs-sqlite
                                                                                       An
                                                                                       [34m[1mSQLite[0m[1m[22m[156]
                                                                                       database
                                                                                       that
                                                                                       manages
                                                                                       a
                                                                                       collection
                                                                                       of
                                                                                       objects
                                                                                       within
                                                                                       a
                                                                                       regular
                                                                                       file.
                                                                                       The
                                                                                       [4mitem_type[0m
                                                                                       is
                                                                                       required
                                                                                       because
                                                                                       it
                                                                                       is
                                                                                       used
                                                                                       as
                                                                                       the
                                                                                       SQL
                                                                                       table
                                                                                       name.

                                                                                   http
                                                                                   https
                                                                                       HTTP-based
                                                                                       object
                                                                                       access.
                                                                                       For
                                                                                       example,
                                                                                       example.com
                                                                                       might
                                                                                       configure
                                                                                       access
                                                                                       to
                                                                                       its
                                                                                       revocation
                                                                                       list
                                                                                       like
                                                                                       this
                                                                                       (with
                                                                                       appropriate
                                                                                       access
                                                                                       controls):

                                                                                           VFS "[revocations]https://example.com/dacs/revocation_list"


                                                                                   dacs-kwv
                                                                                       A
                                                                                       keyword-value
                                                                                       organization
                                                                                       that
                                                                                       is
                                                                                       managed
                                                                                       within
                                                                                       a
                                                                                       single
                                                                                       object
                                                                                       associated
                                                                                       with
                                                                                       another
                                                                                       item
                                                                                       type.
                                                                                       In
                                                                                       other
                                                                                       words,
                                                                                       it
                                                                                       says
                                                                                       that
                                                                                       another
                                                                                       object,
                                                                                       configured
                                                                                       with
                                                                                       its
                                                                                       own
                                                                                       VFS
                                                                                       directive,
                                                                                       has
                                                                                       an
                                                                                       internal
                                                                                       structure
                                                                                       where
                                                                                       each
                                                                                       line
                                                                                       of
                                                                                       the
                                                                                       object
                                                                                       represents
                                                                                       one
                                                                                       record.
                                                                                       Each
                                                                                       record
                                                                                       consists
                                                                                       of
                                                                                       a
                                                                                       keyword,
                                                                                       followed
                                                                                       by
                                                                                       a
                                                                                       separator
                                                                                       character,
                                                                                       and
                                                                                       the
                                                                                       value
                                                                                       associated
                                                                                       with
                                                                                       the
                                                                                       keyword.
                                                                                       A
                                                                                       keyword
                                                                                       consists
                                                                                       of
                                                                                       a
                                                                                       sequence
                                                                                       of
                                                                                       printable,
                                                                                       non-whitespace
                                                                                       characters.
                                                                                       By
                                                                                       default,
                                                                                       the
                                                                                       separator
                                                                                       character
                                                                                       is
                                                                                       a
                                                                                       colon.
                                                                                       (A
                                                                                       well-known
                                                                                       example
                                                                                       of
                                                                                       a
                                                                                       file
                                                                                       having
                                                                                       this
                                                                                       format
                                                                                       is
                                                                                       /etc/password.)
                                                                                       To
                                                                                       specify
                                                                                       a
                                                                                       different
                                                                                       separator,
                                                                                       the
                                                                                       vfs_uri
                                                                                       should
                                                                                       include
                                                                                       the
                                                                                       query
                                                                                       argument
                                                                                       [4mfield_sep[0m
                                                                                       whose
                                                                                       value
                                                                                       is
                                                                                       the
                                                                                       separator
                                                                                       character
                                                                                       to
                                                                                       use.
                                                                                       The
                                                                                       [4mpath[0m
                                                                                       component
                                                                                       gives
                                                                                       the
                                                                                       name
                                                                                       of
                                                                                       the
                                                                                       item_type
                                                                                       that
                                                                                       should
                                                                                       be
                                                                                       used
                                                                                       to
                                                                                       manage
                                                                                       the
                                                                                       underlying
                                                                                       objects.

                                                                                       For
                                                                                       example,
                                                                                       components
                                                                                       of
                                                                                       [1mDACS[0m
                                                                                       expect
                                                                                       the
                                                                                       passwds
                                                                                       item
                                                                                       type
                                                                                       to
                                                                                       be
                                                                                       defined.
                                                                                       Taken
                                                                                       together,
                                                                                       the
                                                                                       following
                                                                                       pair
                                                                                       of
                                                                                       directives
                                                                                       specify
                                                                                       that
                                                                                       the
                                                                                       plain
                                                                                       file
                                                                                       /usr/local/dacs/passwd
                                                                                       consists
                                                                                       of
                                                                                       keyword-value
                                                                                       pairs:

                                                                                           VFS "[password_file]dacs-fs:/usr/local/dacs/passwd"
                                                                                           VFS "[passwds]dacs-kwv:password_file"

                                                                                       To
                                                                                       specify
                                                                                       a
                                                                                       space
                                                                                       as
                                                                                       the
                                                                                       separator
                                                                                       character
                                                                                       instead
                                                                                       of
                                                                                       the
                                                                                       colon
                                                                                       (which
                                                                                       is
                                                                                       the
                                                                                       default),
                                                                                       use
                                                                                       the
                                                                                       directives:

                                                                                           VFS "[password_file]dacs-fs:/usr/local/dacs/passwd"
                                                                                           VFS "[passwds]dacs-kwv:password_file?field_sep=+"

                                                                                       Because
                                                                                       these
                                                                                       are
                                                                                       URIs,
                                                                                       they
                                                                                       must
                                                                                       be
                                                                                       properly
                                                                                       encoded
                                                                                       and
                                                                                       the
                                                                                       '+'
                                                                                       character
                                                                                       represents
                                                                                       a
                                                                                       space.
                                                                                       If
                                                                                       the
                                                                                       passwords
                                                                                       are
                                                                                       to
                                                                                       be
                                                                                       stored
                                                                                       in
                                                                                       a
                                                                                       Berkeley
                                                                                       DB
                                                                                       database,
                                                                                       the
                                                                                       directive
                                                                                       would
                                                                                       be:

                                                                                           VFS "[passwds]dacs-db:/usr/local/dacs/passwd.db"


                                                                                   dacs-kwv-[4msubscheme[0m
                                                                                       A
                                                                                       concise
                                                                                       way
                                                                                       of
                                                                                       composing
                                                                                       the
                                                                                       dacs-kwv
                                                                                       scheme
                                                                                       with
                                                                                       underlying
                                                                                       objects
                                                                                       accessed
                                                                                       using
                                                                                       [4msubscheme[24m.
                                                                                       Currently,
                                                                                       [4msubscheme[0m
                                                                                       can
                                                                                       be
                                                                                       fs
                                                                                       (for
                                                                                       dacs-fs),
                                                                                       http,
                                                                                       or
                                                                                       https.
                                                                                       For
                                                                                       fs,
                                                                                       the
                                                                                       [4mpath[0m
                                                                                       component
                                                                                       is
                                                                                       the
                                                                                       absolute
                                                                                       pathname
                                                                                       of
                                                                                       a
                                                                                       file,
                                                                                       its
                                                                                       contents
                                                                                       having
                                                                                       the
                                                                                       keyword-value
                                                                                       organization.
                                                                                       For
                                                                                       http
                                                                                       and
                                                                                       https,
                                                                                       the
                                                                                       [4mpath[0m
                                                                                       component
                                                                                       is
                                                                                       the
                                                                                       remainder
                                                                                       of
                                                                                       the
                                                                                       URL
                                                                                       (i.e.,
                                                                                       the
                                                                                       scheme
                                                                                       that
                                                                                       specifies
                                                                                       the
                                                                                       object
                                                                                       is
                                                                                       implied),
                                                                                       which
                                                                                       will
                                                                                       be
                                                                                       retrieved
                                                                                       using
                                                                                       the
                                                                                       GET
                                                                                       method,
                                                                                       stored
                                                                                       and
                                                                                       replaced
                                                                                       using
                                                                                       the
                                                                                       PUT
                                                                                       method,
                                                                                       deleted
                                                                                       using
                                                                                       the
                                                                                       DELETE
                                                                                       method,
                                                                                       and
                                                                                       tested
                                                                                       for
                                                                                       using
                                                                                       the
                                                                                       HEAD
                                                                                       method.
                                                                                       Note
                                                                                       that
                                                                                       any
                                                                                       options
                                                                                       (i.e.,
                                                                                       a
                                                                                       query
                                                                                       string)
                                                                                       bind
                                                                                       to
                                                                                       [4msubscheme[24m;
                                                                                       if
                                                                                       options
                                                                                       for
                                                                                       dacs-kwv
                                                                                       are
                                                                                       needed,
                                                                                       two
                                                                                       separate
                                                                                       URIs
                                                                                       must
                                                                                       be
                                                                                       used
                                                                                       instead
                                                                                       of
                                                                                       this
                                                                                       method.

                                                                                       This
                                                                                       configuration
                                                                                       directive
                                                                                       is
                                                                                       almost
                                                                                       equivalent
                                                                                       to
                                                                                       the
                                                                                       pair
                                                                                       of
                                                                                       directives
                                                                                       described
                                                                                       in
                                                                                       the
                                                                                       example
                                                                                       above:

                                                                                           VFS "[passwds]dacs-kwv-fs:/usr/local/dacs/passwd"

                                                                                       The
                                                                                       following
                                                                                       configuration
                                                                                       directive
                                                                                       states
                                                                                       that
                                                                                       the
                                                                                       password
                                                                                       file
                                                                                       used
                                                                                       by
                                                                                       [34m[1mdacspasswd(1)[0m[1m[22m[129]
                                                                                       is
                                                                                       to
                                                                                       be
                                                                                       accessed
                                                                                       at
                                                                                       the
                                                                                       URL
                                                                                       https://example.com/dacs/passwds
                                                                                       using
                                                                                       the
                                                                                       standard
                                                                                       HTTP
                                                                                       methods:

                                                                                           VFS "[passwds]dacs-kwv-https://example.com/dacs/passwds"


                                                                                   dacs-vfs
                                                                                       The
                                                                                       [1mDACS[0m
                                                                                       CGI-based
                                                                                       VFS
                                                                                       service,
                                                                                       [34m[1mdacs_vfs(8)[0m[1m[22m[157],
                                                                                       which
                                                                                       exports
                                                                                       VFS
                                                                                       operations
                                                                                       on
                                                                                       VFS
                                                                                       objects
                                                                                       through
                                                                                       a
                                                                                       web
                                                                                       service.
                                                                                       An
                                                                                       item
                                                                                       type
                                                                                       must
                                                                                       be
                                                                                       provided
                                                                                       and
                                                                                       must
                                                                                       be
                                                                                       configured
                                                                                       at
                                                                                       the
                                                                                       specified
                                                                                       [1mDACS[0m
                                                                                       jurisdiction
                                                                                       using
                                                                                       any
                                                                                       of
                                                                                       the
                                                                                       supported
                                                                                       store
                                                                                       types
                                                                                       (which
                                                                                       means
                                                                                       the
                                                                                       dacs-vfs
                                                                                       scheme
                                                                                       can
                                                                                       be
                                                                                       used
                                                                                       to
                                                                                       access
                                                                                       items
                                                                                       stored
                                                                                       in
                                                                                       a
                                                                                       remote
                                                                                       regular
                                                                                       file,
                                                                                       hash-based
                                                                                       database,
                                                                                       and
                                                                                       so
                                                                                       on).

                                                                                       For
                                                                                       example,
                                                                                       this
                                                                                       directive
                                                                                       causes
                                                                                       [1mDACS[0m
                                                                                       to
                                                                                       look
                                                                                       for
                                                                                       password
                                                                                       entries
                                                                                       used
                                                                                       by
                                                                                       [34m[1mlocal_passwd_authenticate[0m[1m[22m[158]
                                                                                       to
                                                                                       be
                                                                                       accessed
                                                                                       through
                                                                                       the
                                                                                       virtual
                                                                                       filestore
                                                                                       at
                                                                                       example.com:

                                                                                           VFS "[passwds]dacs-vfs:https://example.com/cgi-bin/dacs/dacs_vfs"


                                                                                   A
                                                                                   vfs-ref
                                                                                   is
                                                                                   a
                                                                                   reference
                                                                                   to
                                                                                   a
                                                                                   virtual
                                                                                   filestore
                                                                                   definition
                                                                                   and
                                                                                   can
                                                                                   be
                                                                                   a
                                                                                   vfs_uri
                                                                                   or
                                                                                   an
                                                                                   item_type
                                                                                   defined
                                                                                   by
                                                                                   a
                                                                                   VFS
                                                                                   directive.
                                                                                   In
                                                                                   some
                                                                                   situations
                                                                                   it
                                                                                   can
                                                                                   also
                                                                                   be
                                                                                   an
                                                                                   absolute
                                                                                   pathname.

                                                                                       [1mNote[0m
                                                                                       At
                                                                                       present,
                                                                                       the
                                                                                       VFS
                                                                                       does
                                                                                       not
                                                                                       implement
                                                                                       much
                                                                                       in
                                                                                       the
                                                                                       way
                                                                                       of
                                                                                       concurrency
                                                                                       control.
                                                                                       Some
                                                                                       [1mDACS[0m
                                                                                       components
                                                                                       use
                                                                                       coarse-grained
                                                                                       locking
                                                                                       to
                                                                                       ensure
                                                                                       that
                                                                                       only
                                                                                       a
                                                                                       single
                                                                                       user
                                                                                       can
                                                                                       access
                                                                                       resources,
                                                                                       however,
                                                                                       and
                                                                                       databases
                                                                                       may
                                                                                       implement
                                                                                       their
                                                                                       own
                                                                                       concurrency
                                                                                       control.
                                                                                       Only
                                                                                       a
                                                                                       few
                                                                                       of
                                                                                       these
                                                                                       resources
                                                                                       are
                                                                                       not
                                                                                       used
                                                                                       in
                                                                                       a
                                                                                       read-only
                                                                                       fashion;
                                                                                       administrators
                                                                                       should
                                                                                       adopt
                                                                                       appropriate
                                                                                       data
                                                                                       management
                                                                                       practices
                                                                                       for
                                                                                       them
                                                                                       to
                                                                                       ensure
                                                                                       concurrent
                                                                                       updates
                                                                                       cannot
                                                                                       occur.

                                                                               XSD_BASE_URL
                                                                               (Optional1)
                                                                                   When
                                                                                   [1mDACS[0m
                                                                                   services
                                                                                   are
                                                                                   asked
                                                                                   to
                                                                                   send
                                                                                   an
                                                                                   XML
                                                                                   Schema
                                                                                   response
                                                                                   (i.e.,
                                                                                   they
                                                                                   are
                                                                                   passed
                                                                                   the
                                                                                   argument
                                                                                   FORMAT=XMLSCHEMA)
                                                                                   and
                                                                                   this
                                                                                   directive
                                                                                   is
                                                                                   configured,
                                                                                   services
                                                                                   will
                                                                                   emit
                                                                                   xmlns:xsi
                                                                                   and
                                                                                   xsi:schemaLocation
                                                                                   attributes,
                                                                                   the
                                                                                   former
                                                                                   having
                                                                                   a
                                                                                   compile-time
                                                                                   value
                                                                                   (e.g.,
                                                                                   http://www.w3.org/2001/XMLSchema-instance)
                                                                                   and
                                                                                   the
                                                                                   latter
                                                                                   being
                                                                                   a
                                                                                   pair,
                                                                                   the
                                                                                   first
                                                                                   having
                                                                                   the
                                                                                   same
                                                                                   value
                                                                                   as
                                                                                   the
                                                                                   value
                                                                                   of
                                                                                   the
                                                                                   xmlns
                                                                                   attribute
                                                                                   and
                                                                                   the
                                                                                   second
                                                                                   having
                                                                                   a
                                                                                   value
                                                                                   derived
                                                                                   from
                                                                                   the
                                                                                   XSD_BASE_URL
                                                                                   directive;
                                                                                   e.g.,


                                                                                       <foo xmlns="http://example.com/dacs/v1.4"
                                                                                             xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                                                                                             xsi:schemaLocation="http://example.com/dacs/v1.4
                                                                                             http://example.com/dacs/dtd-xsd/foo.xsd">

                                                                                   If
                                                                                   XSD_BASE_URL
                                                                                   is
                                                                                   not
                                                                                   configured,
                                                                                   only
                                                                                   the
                                                                                   default
                                                                                   xmlns
                                                                                   attribute
                                                                                   is
                                                                                   emitted.

   [1mThe Auth Clause[0m
       Each Auth clause configures an authentication module. The Auth clause
       and its directives are described in [34m[1mdacs_authenticate(8)[0m[1m[22m[27].

       Note that the order of these clauses is significant - they are
       processed in the order in which they appear in the applicable
       configuration section.

   [1mThe Roles Clause[0m
       Each Roles clause configures a roles module.  Roles clause and its
       directives are described in [34m[1mdacs_authenticate(8)[0m[1m[22m[159].

       The clauses are processed in the order in which they appear.
       Authentication modules may return roles, to improve efficiency, but
       roles are usually obtained through a roles module. Roles modules are
       processed only if authentication is successful.

   [1mThe Transfer Clause[0m
       Each Transfer clause configures [34m[1mdacs_auth_transfer(8)[0m[1m[22m[29] for importing
       from one or more federations specified within the clause. The clauses
       are processed in the order in which they appear. No clause should apply
       to more than one initial federation, although this is not enforced.

       Each Transfer element has an id attribute. Its value is merely a label
       (an alphabetic followed by zero or more alphanumerics, hyphens, and
       underscores) that allows the clause to be referenced; the syntax is the
       same as that of a [34m[1mgroupname[0m[1m[22m[76]. The attribute values must be unique
       (case-sensitively).  Transfer clause directives are described in
       [34m[1mdacs_auth_transfer(8)[0m[1m[22m[29].

   [1mAdvanced Techniques[0m
       Configuration processing is ordinarily quite straightforward, but to
       accommodate more complicated situations it also supports a few advanced
       techniques.

       [1mConfiguration Variables[0m
           After configuration processing determines which directives have
           been overridden, those that are in effect have their right hand
           sides (which are expressions) evaluated. These expressions are
           usually simple strings but they can be any [1mDACS [22mexpression.

               [1mTip[0m
               When configuration processing begins, variables in the [4mDACS[24m and
               [4mArgs[24m [34m[1mnamespaces[0m[1m[22m[14] can by referenced by configuration
               directives.

               [1mSecurity[0m
               The ability to reference an argument during configuration
               processing can be useful and powerful when used carefully but
               since argument values are completely in the hands of the user
               constructing a request, it is a potential security weakness,
               particularly in [1mDACS [22mdeployments that are exposed to the
               Internet.

               For example, an argument might be missing or duplicated,
               accidentally have a problematic value (such as containing
               non-printable or otherwise invalid characters), or be
               specifically constructed in an attempt to misconfigure [1mDACS [22mto
               thwart security. For this reason, variables in the [4mArgs[0m
               namespace should be referenced in configuration files only when
               specifically indicated in the documentation, or by advanced
               [1mDACS [22madministrators in appropriate circumstances and with
               caution.

           As each expression is evaluated to determine the value of the
           directive, a variable in the [4mConf[24m namespace (see [34m[1mdacs.exprs(5)[0m[1m[22m[14])
           is created and assigned the value, and can then be referenced in
           subsequent expressions. Variables in this namespace can be
           referenced within access control rules, permitting rules to be
           written that depend on how the particular site, federation, and
           jurisdiction have been configured. In addition, during the
           remainder of the configuration processing stage, the variable's
           value can be modified, effectively changing the value associated
           with the directive. After completion of configuration processing,
           the variables in the [4mConf[24m namespace become read-only. It is these
           variables that are displayed by the [1m-vars [22moption of [34m[1mdacsconf(1)[0m[1m[22m[2].

           For example, if the directive

               FEDERATION_DOMAIN   "example.com"

           is in effect when directive evaluation begins, the variable
           [4m${Conf::FEDERATION_DOMAIN}[24m will be created and assigned the value
           "example.com".

           Variables within the [4mConf[24m [34m[1mnamespace[0m[1m[22m[14] can be created as needed
           within expressions (using the EVAL directive, for example). Care
           should be taken not to unintentionally modify the value of a [1mDACS[0m
           directive, however.

           A standard set of variables is always instantiated when available:

           [4mAPACHE_HOME[0m
               The value of the corresponding build-time symbol

           [4mCGI_SUFFIX[0m
               The file name extension for CGI executables, specified at
               build-time

           [4mDACS_CONF[0m
               The full pathname for this jurisdiction's dacs.conf file

           [4mDACS_CONF_SPEC[0m
               The pathname specification template used for this
               jurisdiction's dacs.conf file

           [4mDACS_HOME[0m
               The value of the corresponding build-time symbol, from the path
               set by the [1m--prefix [22mflag or defaulting to /usr/local/dacs

                   [1mImportant[0m
                   This directory should be writable only by an administrator.

           [4mDACS_CGIBINDIR[0m
               The value of the corresponding build-time symbol

           [4mDACS_RELEASE[0m
               The value of the the compile-time symbol DACS_VERSION_RELEASE

           [4mDACS_BINDIR[0m
               The location of the [1mDACS [22mbin directory

           [4mDACS_SBINDIR[0m
               The location of the [1mDACS [22msbin directory

           [4mDACS_SITE_CONF[0m
               The full pathname for this jurisdiction's site.conf file , if
               any
                .RE

               [4mDACS_SITE_CONF_SPEC[0m
                   The pathname specification template used for this
                   jurisdiction's site.conf file, if any

               [4mDACS_VERSION[0m
                   The value of the compile-time symbol DACS_VERSION_NUMBER

               [4mDOCUMENT_ROOT[0m
                   [1mApache[22m's [1mDOCUMENT_ROOT [22menvironment variable

               [4mEXE_SUFFIX[0m
                   The file name extension for non-CGI executables

               [4mFEDERATIONS_ROOT[0m
                   The value of the corresponding build-time symbol

               [4mHTTP_HOST[0m
                   [1mApache[22m's [1mHTTP_HOST [22menvironment variable, obtained from the
                   HTTP Host request header

               [4mJURISDICTION_URI[0m
                   The initial part of the request URI, including scheme and
                   port number, that uniquely identifies the jurisdiction
                   receiving the service request (also see
                   [4mJURISDICTION_URI_PREFIX[24m)

               [4mJURISDICTION_URI_PREFIX[0m
                   The URI prefix that uniquely identifies the jurisdiction
                   receiving the service request (also see [4mJURISDICTION_URI[24m)

               [4mOPENSSL_PROG[0m
                   The full pathname of the [1mopenssl [22mcommand, if available

               [4mSERVER_ADDR[0m
                   [1mApache[22m's [1mSERVER_ADDR [22menvironment variable

               [4mSERVER_NAME[0m
                   [1mApache[22m's [1mSERVER_NAME [22menvironment variable

               [4mSERVER_PORT[0m
                   [1mApache[22m's [1mSERVER_PORT [22menvironment variable

               [4mURI_SCHEME[0m
                   Set to https if the service request came over SSL ([1mHTTPS [22m==
                   "on"), otherwise http

           [1mAuthentication and Roles[0m
               This section unfortunately left blank.

[1mSEE ALSO[0m
       [34m[1mdacsconf(1)[0m[1m[22m[2], [34m[1mdacs_conf(8)[0m[1m[22m[3], [34m[1mdacs.exprs(5)[0m[1m[22m[20]

[1mBUGS[0m
       There's no way to turn off inherited defaults in a jurisdiction section
       or Default section; i.e., one cannot turn off all Auth or handler
       directives for just one jurisdiction section.

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mhttp://www.dss.ca[0m[1m[22m)

[1mCOPYING[0m
       Copyright (C) 2003-2013 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[160] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#key_concepts

        2. dacsconf(1)
           http://dacs.dss.ca/man/dacsconf.1.html

        3. dacs_conf(8)
           http://dacs.dss.ca/man/dacs_conf.8.html

        4. dacshttp(1)
           http://dacs.dss.ca/man/dacshttp.1.html

        5. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        6. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

        7. mod_auth_dacs
           http://dacs.dss.ca/man/mod_auth_dacs.html

        8. [1mmod_vhost_alias[0m
           http://httpd.apache.org/docs-2.2/mod/mod_vhost_alias.html

        9. LOG_FILE
           http://dacs.dss.ca/man/#LOG_FILE

       10. pathname()
           http://dacs.dss.ca/man/dacs.exprs.5.html#pathname

       11. Jurisdiction section's
           http://dacs.dss.ca/man/#jurisdiction_section

       12. Configuration.dtd
           http://dacs.dss.ca/man/../dtd-xsd/Configuration.dtd

       13. Stack category
           http://dacs.dss.ca/man/#directive_categories

       14. namespace
           http://dacs.dss.ca/man/dacs.exprs.5.html#variables

       15. EVAL directive
           http://dacs.dss.ca/man/#EVAL

       16. undef()
           http://dacs.dss.ca/man/dacs.exprs.5.html#undef

       17. modifier flag
           http://dacs.dss.ca/man/dacs.exprs.5.html#variable_modifiers

       18. ACS_ERROR_HANDLER
           http://dacs.dss.ca/man/#ACS_ERROR_HANDLER

       19. effective jurisdictional URIs
           http://dacs.dss.ca/man/#jurisdiction_section_uri

       20. expression
           http://dacs.dss.ca/man/dacs.exprs.5.html

       21. configuration variables
           http://dacs.dss.ca/man/#config-vars

       22. example configuration
           http://dacs.dss.ca/man/#example_dacs.conf

       23. Jurisdiction Selection by URI
           http://dacs.dss.ca/man/#selection_by_uri

       24. string interpolation
           http://dacs.dss.ca/man/#interpolation

       25. access control rules
           http://dacs.dss.ca/man/dacs.acls.5.html

       26. INIT*
           http://dacs.dss.ca/man/dacs_authenticate.8.html#INIT*

       27. Auth clause
           http://dacs.dss.ca/man/dacs_authenticate.8.html#auth_clause

       28. section merging
           http://dacs.dss.ca/man/#merging

       29. dacs_auth_transfer(8)
           http://dacs.dss.ca/man/dacs_auth_transfer.8.html

       30. Authorization Caching
           http://dacs.dss.ca/man/dacs_acs.8.html#authorization_caching

       31. dacscookie(1)
           http://dacs.dss.ca/man/dacscookie.1.html

       32. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

       33. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

       34. The DACS_APPROVAL environment variable
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_approval

       35. description of the ErrorDocument directive
           http://httpd.apache.org/docs-2.2/mod/core.html#errordocument

       36. redirect()
           http://dacs.dss.ca/man/dacs.exprs.5.html#redirect

       37. access control rules
           http://dacs.dss.ca/man/dacs.acls.5.html#elements

       38. Bug 3641
           http://issues.apache.org/bugzilla/show_bug.cgi?id=36411

       39. Bug 42430
           http://issues.apache.org/bugzilla/show_bug.cgi?id=42430

       40. dacs_select_credentials(8)
           http://dacs.dss.ca/man/dacs_select_credentials.8.html

       41. ACS_TRACK_ACTIVITY
           http://dacs.dss.ca/man/#ACS_TRACK_ACTIVITY

       42. SetDACSAuthPostBuffer
           http://dacs.dss.ca/man/mod_auth_dacs.html#SetDACSAuthPostBuffer

       43. SERVICE_ARGS_TRUNCATED
           http://dacs.dss.ca/man/dacs_acs.8.html#SERVICE_ARGS_TRUNCATED

       44. HTTP_AUTH
           http://dacs.dss.ca/man/#HTTP_AUTH

       45. syntactically valid username
           http://dacs.dss.ca/man/dacs.1.html#dacs_identity

       46. current jurisdiction
           http://dacs.dss.ca/man/dacs.1.html#current_jurisdiction

       47. ACS_AUTHENTICATED_ONLY
           http://dacs.dss.ca/man/#ACS_AUTHENTICATED_ONLY

       48. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#Roles

       49. DACS_ACS
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_acs_argument

       50. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       51. on_success()
           http://dacs.dss.ca/man/dacs.exprs.5.html#on_success

       52. counter
           http://dacs.dss.ca/man/dacs.exprs.5.html#counter

       53. current federation
           http://dacs.dss.ca/man/dacs.1.html#current_federation

       54. ACS_INACTIVITY_LIMIT_SECS
           http://dacs.dss.ca/man/#ACS_INACTIVITY_LIMIT_SECS

       55. FEDERATION_NAME
           http://dacs.dss.ca/man/#FEDERATION_NAME

       56. dacs_admin()
           http://dacs.dss.ca/man/dacs.exprs.5.html#dacs_admin

       57. NAME_COMPARE
           http://dacs.dss.ca/man/#NAME_COMPARE

       58. auth_reply.dtd
           http://dacs.dss.ca/man/../dtd-xsd/auth_reply.dtd

       59. dacs_auth_reply.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_auth_reply.dtd

       60. AUTH_ERROR_HANDLER
           http://dacs.dss.ca/man/#AUTH_ERROR_HANDLER

       61. cookie name
           http://dacs.dss.ca/man/dacs_authenticate.8.html#credentials

       62. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

       63. ACS_CREDENTIALS_LIMIT
           http://dacs.dss.ca/man/#ACS_CREDENTIALS_LIMIT

       64. AUTH_SUCCESS_HANDLER
           http://dacs.dss.ca/man/#AUTH_SUCCESS_HANDLER

       65. mitigate the risk of information disclosure with a cross-site
           scripting (XSS) attack
           http://msdn.microsoft.com/en-us/library/ms533046%28VS.85%29.aspx

       66. are known
           http://www.webappsec.org/lists/websecurity/archive/2006-05/msg00025.html

       67. Netscape HTTP Cookies Specification
           http://web.archive.org/web/20070805052634/http://wp.netscape.com/newsref/std/cookie_spec.html

       68. RFC 2965
           http://www.rfc-editor.org/rfc/rfc2965.txt

       69. dacs.install(7)
           http://dacs.dss.ca/man/dacs.install.7.html

       70. [4mFORMAT[24m web service argument
           http://dacs.dss.ca/man/dacs.services.8.html#FORMAT

       71. Advanced Techniques
           http://dacs.dss.ca/man/#advanced

       72. RFC 1035
           http://www.rfc-editor.org/rfc/rfc1035.txt

       73. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html#group_syntax

       74. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#jurisdiction_section_overview

       75. JURISDICTION_NAME
           http://dacs.dss.ca/man/#JURISDICTION_NAME

       76. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#naming

       77. RFC 2617
           http://www.rfc-editor.org/rfc/rfc2617.txt

       78. HTTP Authentication
           http://dacs.dss.ca/man/dacs_acs.8.html#http_authentication

       79. HTTP_AUTH_ENABLE
           http://dacs.dss.ca/man/#HTTP_AUTH_ENABLE

       80. ACS_PRE_AUTH
           http://dacs.dss.ca/man/#ACS_PRE_AUTH

       81. see below
           http://dacs.dss.ca/man/#http_auth_syn2

       82. authentication styles
           http://dacs.dss.ca/man/dacs_authenticate.8.html#STYLE

       83. chmod(2)
           http://www.freebsd.org/cgi/man.cgi?query=chmod&apropos=0&esektion=2&emanpath=FreeBSD+9.1-RELEASE&format=html

       84. dacs_prenv(8)
           http://dacs.dss.ca/man/dacs_prenv.8.html

       85. dacsexpr(1)
           http://dacs.dss.ca/man/dacsexpr.1.html

       86. encode()
           http://dacs.dss.ca/man/dacs.exprs.5.html#encode

       87. LDAP authentication
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_ldap_authenticate

       88. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

       89. regex(3)
           http://www.freebsd.org/cgi/man.cgi?query=regex&apropos=0&esektion=3&emanpath=FreeBSD+9.1-RELEASE&format=html

       90. dacs_sts(8)
           http://dacs.dss.ca/man/dacs_sts.8.html

       91. dacs_managed_infocard(8)
           http://dacs.dss.ca/man/dacs_managed_infocard.8.html

       92. XML Schema Part 2: Datatypes Second Edition
           http://www.w3.org/TR/2004/REC-xmlschema-2-20041028/datatypes.html#dateTime

       93. INFOCARD_CARD_LIFETIME_SECS
           http://dacs.dss.ca/man/#INFOCARD_CARD_LIFETIME_SECS

       94. VFS URI
           http://dacs.dss.ca/man/#VFS

       95. CARD_IMAGE_URL
           http://dacs.dss.ca/man/dacs_managed_infocard.8.html#CARD_IMAGE_URL

       96. INFOCARD_CARD_DATETIME_EXPIRES
           http://dacs.dss.ca/man/#INFOCARD_CARD_DATETIME_EXPIRES

       97. INFOCARD_CARDID_BASE_URL
           http://dacs.dss.ca/man/#INFOCARD_CARDID_BASE_URL

       98. INFOCARD_CARD_OUTPUTDIR
           http://dacs.dss.ca/man/#INFOCARD_CARD_OUTPUTDIR

       99. INFOCARD_CARDID_SUFFIX
           http://dacs.dss.ca/man/#INFOCARD_CARDID_SUFFIX

       00. RFC 2396
           http://www.rfc-editor.org/rfc/rfc2396.txt

       01. dacs_infocard(8)
           http://dacs.dss.ca/man/dacs_infocard.8.html

       02. PASSWORD_DIGEST
           http://dacs.dss.ca/man/#PASSWORD_DIGEST

       03. INFOCARD_IP_PRIVACY_URL
           http://dacs.dss.ca/man/#INFOCARD_IP_PRIVACY_URL

       04. dacs_mex(8)
           http://dacs.dss.ca/man/dacs_mex.8.html

       05. INFOCARD_STS_PASSWORD_METHOD
           http://dacs.dss.ca/man/#INFOCARD_STS_PASSWORD_METHOD

       06. INFOCARD_STS_CERTFILE
           http://dacs.dss.ca/man/#INFOCARD_STS_CERTFILE

       07. dacsinfocard(1)
           http://dacs.dss.ca/man/dacsinfocard.1.html

       08. local_infocard_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_infocard_authenticate

       09. INFOCARD_STS_KEYFILE_PASSWORD
           http://dacs.dss.ca/man/#INFOCARD_STS_KEYFILE_PASSWORD

       10. INFOCARD_STS_KEYFILE
           http://dacs.dss.ca/man/#INFOCARD_STS_KEYFILE

       11. INFOCARD_REQUIRE_APPLIES_TO
           http://dacs.dss.ca/man/#INFOCARD_REQUIRE_APPLIES_TO

       12. INFOCARD_AUDIENCE
           http://dacs.dss.ca/man/#INFOCARD_AUDIENCE

       13. wildcard certificate
           http://wiki.cacert.org/wiki/WildcardCertificates

       14. syslog(3)
           http://www.freebsd.org/cgi/man.cgi?query=syslog&apropos=0&sektion=3&manpath=FreeBSD+9.1-RELEASE&format=html

       15. LOG_LEVEL
           http://dacs.dss.ca/man/#LOG_LEVEL

       16. regex(3)
           http://www.freebsd.org/cgi/man.cgi?query=regex&apropos=0&sektion=3&manpath=FreeBSD+9.1-RELEASE&format=html

       17. print()
           http://dacs.dss.ca/man/dacs.exprs.5.html#print

       18. printf()
           http://dacs.dss.ca/man/dacs.exprs.5.html#printf

       19. LOG_SENSITIVE
           http://dacs.dss.ca/man/#LOG_SENSITIVE

       20. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#logging

       21. LOG_FILTER
           http://dacs.dss.ca/man/#LOG_FILTER

       22. debug_dacs
           http://dacs.dss.ca/man/dacs_acs.8.html#debug_dacs

       23. mod_log_config
           http://httpd.apache.org/docs/2.2/mod/mod_log_config.html

       24. dacs_notices(8)
           http://dacs.dss.ca/man/dacs_notices.8.html

       25. Secure Mode
           http://dacs.dss.ca/man/dacs_notices.8.html#secure_mode

       26. local_pam_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_pam_authenticate

       27. pamd(8)
           http://dacs.dss.ca/man/pamd.8.html

       28. dacs_passwd(8)
           http://dacs.dss.ca/man/dacs_passwd.8.html

       29. dacspasswd(1)
           http://dacs.dss.ca/man/dacspasswd.1.html

       30. dacstoken(1)
           http://dacs.dss.ca/man/dacstoken.1.html

       31. PASSWORD_AUDIT
           http://dacs.dss.ca/man/dacs_authenticate.8.html#PASSWORD_AUDIT

       32. ispunct(3)
           http://www.freebsd.org/cgi/man.cgi?query=ispunct&apropos=0&sektion=3&manpath=FreeBSD+9.1-RELEASE&format=html

       33. dacs_admin(8)
           http://dacs.dss.ca/man/dacs_admin.8.html

       34. crypt(3)
           http://www.freebsd.org/cgi/man.cgi?query=crypt&apropos=0&sektion=3&manpath=FreeBSD+9.1-RELEASE&format=html

       35. MD5 function
           http://www.rfc-editor.org/rfc/rfc1321.txt

       36. FIPS 180-3
           http://csrc.nist.gov/publications/fips/fips180-3/fips180-3_final.pdf

       37. ADMIN_IDENTITY
           http://dacs.dss.ca/man/#ADMIN_IDENTITY

       38. Rlink
           http://dacs.dss.ca/man/dacs_acs.8.html#rlinks

       39. VFS specification
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

       40. sslclient(1)
           http://dacs.dss.ca/man/sslclient.1.html

       41. DACS-Status-Line
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_status_line

       42. DACS_HOME
           http://dacs.dss.ca/man/#var_dacs_home

       43. role descriptor string
           http://dacs.dss.ca/man/dacs.1.html#roles

       44. user()
           http://dacs.dss.ca/man/dacs.exprs.5.html#user

       45. dacs_uproxy(8)
           http://dacs.dss.ca/man/dacs_uproxy.8.html

       46. from()
           http://dacs.dss.ca/man/dacs.exprs.5.html#from

       47. dacs.vfs(5)
           http://dacs.dss.ca/man/dacs.vfs.5.html

       48. dacsvfs(1)
           http://dacs.dss.ca/man/dacsvfs.1.html

       49. RFC 3986
           http://www.rfc-editor.org/rfc/rfc3986.txt

       50. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html#gloss_item_type

       51. dacskey(1)
           http://dacs.dss.ca/man/dacskey.1.html

       52. get()
           http://dacs.dss.ca/man/dacs.exprs.5.html#get

       53. Berkeley DB
           http://www.oracle.com/database/berkeley-db/db/index.html

       54. dbm(3)
           http://www.freebsd.org/cgi/man.cgi?query=dbm&apropos=0&sektion=3&manpath=FreeBSD+9.1-RELEASE&format=html

       55. GNU gdbm
           http://www.gnu.org/software/gdbm/gdbm.html

       56. SQLite
           http://www.sqlite.org

       57. dacs_vfs(8)
           http://dacs.dss.ca/man/dacs_vfs.8.html

       58. local_passwd_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_passwd_authenticate

       59. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#roles_clause

       60. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.28b                      03/01/2013                      DACS.CONF(5)
