/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"

namespace CVC4 {

template <> void Options::set(
    options::instFormatMode__option_t,
    const options::instFormatMode__option_t::type& x)
{
  d_holder->instFormatMode = x;
}
template <> const options::instFormatMode__option_t::type& Options::operator[](
    options::instFormatMode__option_t) const
{
  return d_holder->instFormatMode;
}
template <> bool Options::wasSetByUser(options::instFormatMode__option_t) const
{
  return d_holder->instFormatMode__setByUser__;
}
template <> void Options::set(
    options::modelFormatMode__option_t,
    const options::modelFormatMode__option_t::type& x)
{
  d_holder->modelFormatMode = x;
}
template <> const options::modelFormatMode__option_t::type& Options::operator[](
    options::modelFormatMode__option_t) const
{
  return d_holder->modelFormatMode;
}
template <> bool Options::wasSetByUser(options::modelFormatMode__option_t) const
{
  return d_holder->modelFormatMode__setByUser__;
}


namespace options {

struct instFormatMode__option_t instFormatMode;
struct modelFormatMode__option_t modelFormatMode;


}  // namespace options
}  // namespace CVC4
