package SPARCplug;
use strict;

sub configure {

	our @recipe_names = qw(
	  kmo_dark
	  kmo_flat
	  kmo_wave_cal
	  kmo_illumination
	  kmo_std_star
	  kmo_sci_red
	  kmo_reconstruct
	  );

	our @band_names = qw(H K HK IZ YJ ignore);
	our @rot_angles = qw(0 60 120 180 240 300 ignore);

	our %template_options = (
		kmo_dark =>
		  [ "TPL_ID_KMOS_spec_cal_dark", "DPR_TYPE_dark", "ALL_dark" ],
		kmo_flat =>
		  [ "TPL_ID_KMOS_spec_cal_calunitflat", "DPR_TYPE_flat", "ALL_flat" ],
		kmo_wave_cal =>
		  [ "TPL_ID_KMOS_spec_cal_wave", "DPR_TYPE_wave", "ALL_wave_cal" ],
		kmo_illumination =>
		  [ "TPL_ID_KMOS_spec_cal_skyflat", "DPR_TYPE_flat,sky" ],
		kmo_std_star => [
			"TPL_ID_KMOS_spec_cal_stdstar",
			"TPL_ID_KMOS_spec_cal_stdstarscipatt",
			"DPR_TYPE_object,sky,std,flux"
		],
		kmo_sci_red => [
			"TPL_ID_KMOS_spec_obs_.*",
			"TPL_ID_KMOS_spec_obs_nodtosky",
			"TPL_ID_KMOS_spec_obs_stare",
			"TPL_ID_KMOS_spec_obs_mapping8",
			"TPL_ID_KMOS_spec_obs_mapping24",
			"TPL_ID_KMOS_spec_obs_freedither",
			"DPR_TYPE_object,sky"
		], 
		kmo_reconstruct => [
			"DPR_TYPE_object,sky",
			"DPR_TYPE_object",
			"DPR_TYPE_sky",
		]
	);

	foreach my $tmp_rec_name ( keys(%template_options) ) {
		my @tmpArr = @{ $template_options{"$tmp_rec_name"} };
		push @tmpArr, "ALL";
		$template_options{"$tmp_rec_name"} = [@tmpArr];
	}

	our %cal_types = (
		kmo_dark => [],
		kmo_flat => ["BADPIXEL_DARK"],
		kmo_wave_cal =>
		  ["BADPIXEL_FLAT", "XCAL", "YCAL", "FLAT_EDGE",
		   "ARC_LIST", "REF_LINES", "WAVE_BAND" ],
		kmo_illumination =>
		  [ "MASTER_DARK", "MASTER_FLAT", "XCAL", "YCAL", "LCAL", "WAVE_BAND" ],
		kmo_std_star => [ "ILLUM_CORR", "MASTER_FLAT", "XCAL", "YCAL", "LCAL",
		    "ATMOS_MODEL", "SOLAR_SPEC", "SPEC_TYPE_LOOKUP", "WAVE_BAND" ],
		kmo_sci_red =>
		  [ "ILLUM_CORR", "TELLURIC", "MASTER_FLAT", "XCAL", "YCAL", "LCAL" , "WAVE_BAND"],
		kmo_reconstruct =>
		  [ "XCAL", "YCAL", "LCAL" , "WAVE_BAND"]
	);

	our %band_specific_cal_files = (
		BADPIXEL_DARK => 0,
		XCAL          => 1,
		YCAL          => 1,
		LCAL          => 1,
		MASTER_FLAT   => 1,
		BADPIXEL_FLAT => 1,
		FLAT_EDGE     => 1,
		WAVE_BAND     => 0,
		REF_LINES     => 0,
		ARC_LIST      => 1,
	);

	our %staticcal_types = (
		kmo_dark         => [],
		kmo_flat         => [],
		kmo_wave_cal     => [ "ARC_LIST", "REF_LINES", "WAVE_BAND" ],
		kmo_illumination => [ "WAVE_BAND" ],
		kmo_std_star     => [ "ATMOS_MODEL", "SOLAR_SPEC", "SPEC_TYPE_LOOKUP", "WAVE_BAND" ],
		kmo_sci_red      => [ "WAVE_BAND" ],
		kmo_reconstruct  => [ "WAVE_BAND" ],
	);

	our %pipeline_basic_options = (
		kmo_dark => {
			pos_bad_pix_rej => "",
			neg_bad_pix_rej => "",
			cmethod         => "",
		},
		kmo_flat => {
			surrounding_pixels => "",
			cmethod            => "",
		},
		kmo_wave_cal     => { order => "", },
		kmo_illumination => {
			imethod => "",
			range   => "",
		},
		kmo_std_star => {
			startype  => "",
			magnitude => "",
			fmethod   => "",
			imethod   => "",
			range     => "",
			"save-cubes" => "",
		},
		kmo_sci_red => {
			smethod  => "",
			imethod  => "",
		},
		kmo_reconstruct => {
			imethod  => "",
			detimg   => "",
		},
	);

	our %pipeline_advanced_options = (
		kmo_dark => {
			cpos_rej => "",
			cneg_rej => "",
			citer    => "",
			cmax     => "",
			cmin     => "",
		},
		kmo_flat => {
			cpos_rej => "",
			cneg_rej => "",
			citer    => "",
			cmax     => "",
			cmin     => "",
		},
		kmo_wave_cal => {
			b_samples => "",
			b_start   => "",
			b_end     => "",
		},
		kmo_illumination => {
			neighborhoodRange => "",
			b_samples         => "",
			b_start           => "",
			b_end             => "",
			cmethod           => "",
			cpos_rej          => "",
			cneg_rej          => "",
			citer             => "",
			cmax              => "",
			cmin              => "",
		},
		kmo_std_star => {
			flux              => "",
			neighborhoodRange => "",
			b_samples         => "",
			b_start           => "",
			b_end             => "",
			cmethod           => "",
			cpos_rej          => "",
			cneg_rej          => "",
			citer             => "",
			cmax              => "",
			cmin              => "",
		},
		kmo_sci_red => {
			flux              => "",
			neighborhoodRange => "",
			b_samples         => "",
			b_start           => "",
			b_end             => "",
			name              => "",
			ifus              => "",
			method            => "",
			fmethod           => "",
			filename          => "",
			cmethod           => "",
			cpos_rej          => "",
			cneg_rej          => "",
			citer             => "",
			cmax              => "",
			cmin              => "",
			extrapolate		  => "",
		},
		kmo_reconstruct => {
			flux              => "",
			neighborhoodRange => "",
			outputextension => "",
			b_samples => "",
			b_start   => "",
			b_end     => "",
		},
	);

	our @main_raw_window_columns = qw (filename date_obs obs_start tpl_id tpl_start dpr_type
	  filter_band lamps rot_angle exp_time );

	our %rawfitsheader = (
		filename => {    #basename of file name
			path => "",           #virtual keyword
			head => "Filename",
		},
		lamps => {    #either 'none' or combination of Ar, Ne, FF1, FF2
			path => "",        #virtual keyword
			head => "Lamps",
		},
		lamp1 => {
			path => "ins.lamp1.st",
			head => "lamp1",
		},
		lamp2 => {
			path => "ins.lamp2.st",
			head => "lamp2",
		},
		lamp3 => {
			path => "ins.lamp3.st",
			head => "lamp3",
		},
		lamp4 => {
			path => "ins.lamp4.st",
			head => "lamp4",
		},
		date_obs => {
			path => "date-obs",
			head => "Date-Obs",
		},
		obs_start => {
			path => "obs.start",
			head => "OBS.START",
		},
		tpl_id => {
			path => "tpl.id",
			head => "TPL.ID",
		},
		tpl_start => {
			path => "tpl.start",
			head => "TPL.START",
		},
		dpr_type => {
			path => "dpr.type",
			head => "DPR.TYPE",
		},
		filter_band => {
			path => "ins.filt1.name",
			head => "Filter",
		},
		grating_band => {
			path => "ins.grat1.name",
			head => "Grat",
		},
		rot_angle => {
			path => "ocs.rot.naangle",
			head => "Rot",
		},
		exp_time => {
			path => "exptime",
			head => "Exp time",
		},
	);

	foreach my $name ( keys %rawfitsheader ) {
		$rawfitsheader{$name}{maxLength} = 0;
	}

#	our @main_cal_window_columns = qw (type filename date category band band1 band2 rot_angle);
	our @main_cal_window_columns = qw (type filename date category band exp_time);
	our %calfitsheader = (
		type => {		#either current or static
			path => "",           #virtual keyword
			head => "Type"
		},
		filename => {    #basename of file name
			path => "",           #virtual keyword
			head => "Filename",
		},
		date => {    
			path => "date",
			head => "Date",
		},
		category => {
			path => "pro.catg",
			head => "category",
		},
		band => {
			path => "",           #virtual keyword
			head => "Band",
		},
		band1 => {
			path => "ins.grat1.name",
			head => "Band1",
		},
		band2 => {
			path => "filt.id",
			head => "Band2",
		},
		rot_angle => {
			path => "ocs.rot.naangle",
			head => "Rot",
		},
		exp_time => {
			path => "exptime",
			head => "Exp time",
		},
	);
	
	foreach my $name ( keys %calfitsheader ) {
		$calfitsheader{$name}{maxLength} = 0;
	}
	$calfitsheader{type}{maxLength} = 8;
}
return 1;
