/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.ApplyImports;
import net.sf.saxon.instruct.ApplyTemplates;
import net.sf.saxon.instruct.ParameterSet;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;

public class NextMatch
extends ApplyImports {
    public NextMatch(boolean bl) {
        super(bl);
    }

    public int getInstructionNameCode() {
        return 159;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        ParameterSet parameterSet = NextMatch.assembleParams(xPathContext, this.actualParams);
        ParameterSet parameterSet2 = NextMatch.assembleTunnelParams(xPathContext, this.tunnelParams);
        Rule rule = xPathContext.getCurrentTemplateRule();
        if (rule == null) {
            DynamicError dynamicError = new DynamicError("There is no current template rule");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE0560");
            throw dynamicError;
        }
        Mode mode = xPathContext.getCurrentMode();
        if (mode == null) {
            mode = controller.getRuleManager().getDefaultMode();
        }
        if (xPathContext.getCurrentIterator() == null) {
            DynamicError dynamicError = new DynamicError("There is no context item");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE0565");
            throw dynamicError;
        }
        Item item = xPathContext.getCurrentIterator().current();
        if (!(item instanceof NodeInfo)) {
            DynamicError dynamicError = new DynamicError("Cannot call xsl:next-match when context item is not a node");
            dynamicError.setXPathContext(xPathContext);
            dynamicError.setErrorCode("XTDE0565");
            throw dynamicError;
        }
        NodeInfo nodeInfo = (NodeInfo)item;
        Rule rule2 = controller.getRuleManager().getNextMatchHandler(nodeInfo, mode, rule, xPathContext);
        if (rule2 == null) {
            ApplyTemplates.defaultAction(nodeInfo, parameterSet, parameterSet2, xPathContext, false, this.getLocationId());
        } else {
            Template template = (Template)rule2.getAction();
            XPathContextMajor xPathContextMajor = xPathContext.newContext();
            xPathContextMajor.setOrigin(this);
            xPathContextMajor.openStackFrame(template.getStackFrameMap());
            xPathContextMajor.setLocalParameters(parameterSet);
            xPathContextMajor.setTunnelParameters(parameterSet2);
            template.apply(xPathContextMajor, rule2);
        }
        return null;
    }
}

