///////////////////////////////////////////////////////////////////////////////
// Name:        pdfcolourdata.inc
// Purpose:     Definition of named RGB colours
// Author:      Ulrich Telle
// Created:     2009-06-24
// Copyright:   (c) Ulrich Telle
// Licence:     wxWindows licence
///////////////////////////////////////////////////////////////////////////////

/// \file pdfcolourdata.inc Definition of named RGB colours.

static const struct wxColourDesc
{
  const wxChar *name;
  unsigned char r,g,b;
}
wxColourTable[] =
{
  { wxS("snow"),                 255,250,250 },
  { wxS("ghostwhite"),           248,248,255 },
  { wxS("whitesmoke"),           245,245,245 },
  { wxS("gainsboro"),            220,220,220 },
  { wxS("floralwhite"),          255,250,240 },
  { wxS("oldlace"),              253,245,230 },
  { wxS("linen"),                250,240,230 },
  { wxS("antiquewhite"),         250,235,215 },
  { wxS("papayawhip"),           255,239,213 },
  { wxS("blanchedalmond"),       255,235,205 },
  { wxS("bisque"),               255,228,196 },
  { wxS("peachpuff"),            255,218,185 },
  { wxS("navajowhite"),          255,222,173 },
  { wxS("moccasin"),             255,228,181 },
  { wxS("cornsilk"),             255,248,220 },
  { wxS("ivory"),                255,255,240 },
  { wxS("lemonchiffon"),         255,250,205 },
  { wxS("seashell"),             255,245,238 },
  { wxS("honeydew"),             240,255,240 },
  { wxS("mintcream"),            245,255,250 },
  { wxS("azure"),                240,255,255 },
  { wxS("aliceblue"),            240,248,255 },
  { wxS("lavender"),             230,230,250 },
  { wxS("lavenderblush"),        255,240,245 },
  { wxS("mistyrose"),            255,228,225 },
  { wxS("white"),                255,255,255 },
  { wxS("black"),                  0,  0,  0 },
  { wxS("darkslategray"),         47, 79, 79 },
  { wxS("dimgrey"),              105,105,105 },
  { wxS("slategrey"),            112,128,144 },
  { wxS("lightslategray"),       119,136,153 },
  { wxS("grey"),                 190,190,190 },
  { wxS("lightgray"),            211,211,211 },
  { wxS("midnightblue"),          25, 25,112 },
  { wxS("navyblue"),               0,  0,128 },
  { wxS("cornflowerblue"),       100,149,237 },
  { wxS("darkslateblue"),         72, 61,139 },
  { wxS("slateblue"),            106, 90,205 },
  { wxS("mediumslateblue"),      123,104,238 },
  { wxS("lightslateblue"),       132,112,255 },
  { wxS("mediumblue"),             0,  0,205 },
  { wxS("royalblue"),             65,105,225 },
  { wxS("blue"),                   0,  0,255 },
  { wxS("dodgerblue"),            30,144,255 },
  { wxS("deepskyblue"),            0,191,255 },
  { wxS("skyblue"),              135,206,235 },
  { wxS("lightskyblue"),         135,206,250 },
  { wxS("steelblue"),             70,130,180 },
  { wxS("lightsteelblue"),       176,196,222 },
  { wxS("lightblue"),            173,216,230 },
  { wxS("powderblue"),           176,224,230 },
  { wxS("paleturquoise"),        175,238,238 },
  { wxS("darkturquoise"),          0,206,209 },
  { wxS("mediumturquoise"),       72,209,204 },
  { wxS("turquoise"),             64,224,208 },
  { wxS("cyan"),                   0,255,255 },
  { wxS("lightcyan"),            224,255,255 },
  { wxS("cadetblue"),             95,158,160 },
  { wxS("mediumaquamarine"),     102,205,170 },
  { wxS("aquamarine"),           127,255,212 },
  { wxS("darkgreen"),              0,100,  0 },
  { wxS("darkolivegreen"),        85,107, 47 },
  { wxS("darkseagreen"),         143,188,143 },
  { wxS("seagreen"),              46,139, 87 },
  { wxS("mediumseagreen"),        60,179,113 },
  { wxS("lightseagreen"),         32,178,170 },
  { wxS("palegreen"),            152,251,152 },
  { wxS("springgreen"),            0,255,127 },
  { wxS("lawngreen"),            124,252,  0 },
  { wxS("green"),                  0,255,  0 },
  { wxS("chartreuse"),           127,255,  0 },
  { wxS("medspringgreen"),         0,250,154 },
  { wxS("greenyellow"),          173,255, 47 },
  { wxS("limegreen"),             50,205, 50 },
  { wxS("yellowgreen"),          154,205, 50 },
  { wxS("forestgreen"),           34,139, 34 },
  { wxS("olivedrab"),            107,142, 35 },
  { wxS("darkkhaki"),            189,183,107 },
  { wxS("palegoldenrod"),        238,232,170 },
  { wxS("ltgoldenrodyello"),     250,250,210 },
  { wxS("lightyellow"),          255,255,200 },
  { wxS("yellow"),               255,255,  0 },
  { wxS("gold"),                 255,215,  0 },
  { wxS("lightgoldenrod"),       238,221,130 },
  { wxS("goldenrod"),            218,165, 32 },
  { wxS("darkgoldenrod"),        184,134, 11 },
  { wxS("rosybrown"),            188,143,143 },
  { wxS("indianred"),            205, 92, 92 },
  { wxS("saddlebrown"),          139, 69, 19 },
  { wxS("sienna"),               160, 82, 45 },
  { wxS("peru"),                 205,133, 63 },
  { wxS("burlywood"),            222,184,135 },
  { wxS("beige"),                245,245,220 },
  { wxS("wheat"),                245,222,179 },
  { wxS("sandybrown"),           244,164, 96 },
  { wxS("tan"),                  210,180,140 },
  { wxS("chocolate"),            210,105, 30 },
  { wxS("firebrick"),            178, 34, 34 },
  { wxS("brown"),                165, 42, 42 },
  { wxS("darksalmon"),           233,150,122 },
  { wxS("salmon"),               250,128,114 },
  { wxS("lightsalmon"),          255,160,122 },
  { wxS("orange"),               255,165,  0 },
  { wxS("darkorange"),           255,140,  0 },
  { wxS("coral"),                255,127, 80 },
  { wxS("lightcoral"),           240,128,128 },
  { wxS("tomato"),               255, 99, 71 },
  { wxS("orangered"),            255, 69,  0 },
  { wxS("red"),                  255,  0,  0 },
  { wxS("hotpink"),              255,105,180 },
  { wxS("deeppink"),             255, 20,147 },
  { wxS("pink"),                 255,192,203 },
  { wxS("lightpink"),            255,182,193 },
  { wxS("palevioletred"),        219,112,147 },
  { wxS("maroon"),               176, 48, 96 },
  { wxS("mediumvioletred"),      199, 21,133 },
  { wxS("violetred"),            208, 32,144 },
  { wxS("magenta"),              255,  0,255 },
  { wxS("violet"),               238,130,238 },
  { wxS("plum"),                 221,160,221 },
  { wxS("orchid"),               218,112,214 },
  { wxS("mediumorchid"),         186, 85,211 },
  { wxS("darkorchid"),           153, 50,204 },
  { wxS("darkviolet"),           148,  0,211 },
  { wxS("blueviolet"),           138, 43,226 },
  { wxS("purple"),               160, 32,240 },
  { wxS("mediumpurple"),         147,112,219 },
  { wxS("thistle"),              216,191,216 },
  { wxS("snow1"),                255,250,250 },
  { wxS("snow2"),                238,233,233 },
  { wxS("snow3"),                205,201,201 },
  { wxS("snow4"),                139,137,137 },
  { wxS("seashell1"),            255,245,238 },
  { wxS("seashell2"),            238,229,222 },
  { wxS("seashell3"),            205,197,191 },
  { wxS("seashell4"),            139,134,130 },
  { wxS("antiquewhite1"),        255,239,219 },
  { wxS("antiquewhite2"),        238,223,204 },
  { wxS("antiquewhite3"),        205,192,176 },
  { wxS("antiquewhite4"),        139,131,120 },
  { wxS("bisque1"),              255,228,196 },
  { wxS("bisque2"),              238,213,183 },
  { wxS("bisque3"),              205,183,158 },
  { wxS("bisque4"),              139,125,107 },
  { wxS("peachpuff1"),           255,218,185 },
  { wxS("peachpuff2"),           238,203,173 },
  { wxS("peachpuff3"),           205,175,149 },
  { wxS("peachpuff4"),           139,119,101 },
  { wxS("navajowhite1"),         255,222,173 },
  { wxS("navajowhite2"),         238,207,161 },
  { wxS("navajowhite3"),         205,179,139 },
  { wxS("navajowhite4"),         139,121,94 },
  { wxS("lemonchiffon1"),        255,250,205 },
  { wxS("lemonchiffon2"),        238,233,191 },
  { wxS("lemonchiffon3"),        205,201,165 },
  { wxS("lemonchiffon4"),        139,137,112 },
  { wxS("cornsilk1"),            255,248,220 },
  { wxS("cornsilk2"),            238,232,205 },
  { wxS("cornsilk3"),            205,200,177 },
  { wxS("cornsilk4"),            139,136,120 },
  { wxS("ivory1"),               255,255,240 },
  { wxS("ivory2"),               238,238,224 },
  { wxS("ivory3"),               205,205,193 },
  { wxS("ivory4"),               139,139,131 },
  { wxS("honeydew1"),            240,255,240 },
  { wxS("honeydew2"),            224,238,224 },
  { wxS("honeydew3"),            193,205,193 },
  { wxS("honeydew4"),            131,139,131 },
  { wxS("lavenderblush1"),       255,240,245 },
  { wxS("lavenderblush2"),       238,224,229 },
  { wxS("lavenderblush3"),       205,193,197 },
  { wxS("lavenderblush4"),       139,131,134 },
  { wxS("mistyrose1"),           255,228,225 },
  { wxS("mistyrose2"),           238,213,210 },
  { wxS("mistyrose3"),           205,183,181 },
  { wxS("mistyrose4"),           139,125,123 },
  { wxS("azure1"),               240,255,255 },
  { wxS("azure2"),               224,238,238 },
  { wxS("azure3"),               193,205,205 },
  { wxS("azure4"),               131,139,139 },
  { wxS("slateblue1"),           131,111,255 },
  { wxS("slateblue2"),           122,103,238 },
  { wxS("slateblue3"),           105, 89,205 },
  { wxS("slateblue4"),            71, 60,139 },
  { wxS("royalblue1"),            72,118,255 },
  { wxS("royalblue2"),            67,110,238 },
  { wxS("royalblue3"),            58, 95,205 },
  { wxS("royalblue4"),            39, 64,139 },
  { wxS("blue1"),                  0,  0,255 },
  { wxS("blue2"),                  0,  0,238 },
  { wxS("blue3"),                  0,  0,205 },
  { wxS("blue4"),                  0,  0,139 },
  { wxS("dodgerblue1"),           30,144,255 },
  { wxS("dodgerblue2"),           28,134,238 },
  { wxS("dodgerblue3"),           24,116,205 },
  { wxS("dodgerblue4"),           16, 78,139 },
  { wxS("steelblue1"),            99,184,255 },
  { wxS("steelblue2"),            92,172,238 },
  { wxS("steelblue3"),            79,148,205 },
  { wxS("steelblue4"),            54,100,139 },
  { wxS("deepskyblue1"),           0,191,255 },
  { wxS("deepskyblue2"),           0,178,238 },
  { wxS("deepskyblue3"),           0,154,205 },
  { wxS("deepskyblue4"),           0,104,139 },
  { wxS("skyblue1"),             135,206,255 },
  { wxS("skyblue2"),             126,192,238 },
  { wxS("skyblue3"),             108,166,205 },
  { wxS("skyblue4"),              74,112,139 },
  { wxS("lightskyblue1"),        176,226,255 },
  { wxS("lightskyblue2"),        164,211,238 },
  { wxS("lightskyblue3"),        141,182,205 },
  { wxS("lightskyblue4"),         96,123,139 },
  { wxS("slategray1"),           198,226,255 },
  { wxS("slategray2"),           185,211,238 },
  { wxS("slategray3"),           159,182,205 },
  { wxS("slategray4"),           108,123,139 },
  { wxS("lightsteelblue1"),      202,225,255 },
  { wxS("lightsteelblue2"),      188,210,238 },
  { wxS("lightsteelblue3"),      162,181,205 },
  { wxS("lightsteelblue4"),      110,123,139 },
  { wxS("lightblue1"),           191,239,255 },
  { wxS("lightblue2"),           178,223,238 },
  { wxS("lightblue3"),           154,192,205 },
  { wxS("lightblue4"),           104,131,139 },
  { wxS("lightcyan1"),           224,255,255 },
  { wxS("lightcyan2"),           209,238,238 },
  { wxS("lightcyan3"),           180,205,205 },
  { wxS("lightcyan4"),           122,139,139 },
  { wxS("paleturquoise1"),       187,255,255 },
  { wxS("paleturquoise2"),       174,238,238 },
  { wxS("paleturquoise3"),       150,205,205 },
  { wxS("paleturquoise4"),       102,139,139 },
  { wxS("cadetblue1"),           152,245,255 },
  { wxS("cadetblue2"),           142,229,238 },
  { wxS("cadetblue3"),           122,197,205 },
  { wxS("cadetblue4"),            83,134,139 },
  { wxS("turquoise1"),             0,245,255 },
  { wxS("turquoise2"),             0,229,238 },
  { wxS("turquoise3"),             0,197,205 },
  { wxS("turquoise4"),             0,134,139 },
  { wxS("cyan1"),                  0,255,255 },
  { wxS("cyan2"),                  0,238,238 },
  { wxS("cyan3"),                  0,205,205 },
  { wxS("cyan4"),                  0,139,139 },
  { wxS("darkslategray1"),       151,255,255 },
  { wxS("darkslategray2"),       141,238,238 },
  { wxS("darkslategray3"),       121,205,205 },
  { wxS("darkslategray4"),        82,139,139 },
  { wxS("aquamarine1"),          127,255,212 },
  { wxS("aquamarine2"),          118,238,198 },
  { wxS("aquamarine3"),          102,205,170 },
  { wxS("aquamarine4"),           69,139,116 },
  { wxS("darkseagreen1"),        193,255,193 },
  { wxS("darkseagreen2"),        180,238,180 },
  { wxS("darkseagreen3"),        155,205,155 },
  { wxS("darkseagreen4"),        105,139,105 },
  { wxS("seagreen1"),             84,255,159 },
  { wxS("seagreen2"),             78,238,148 },
  { wxS("seagreen3"),             67,205,128 },
  { wxS("seagreen4"),             46,139, 87 },
  { wxS("palegreen1"),           154,255,154 },
  { wxS("palegreen2"),           144,238,144 },
  { wxS("palegreen3"),           124,205,124 },
  { wxS("palegreen4"),            84,139, 84 },
  { wxS("springgreen1"),           0,255,127 },
  { wxS("springgreen2"),           0,238,118 },
  { wxS("springgreen3"),           0,205,102 },
  { wxS("springgreen4"),           0,139, 69 },
  { wxS("green1"),                 0,255,  0 },
  { wxS("green2"),                 0,238,  0 },
  { wxS("green3"),                 0,205,  0 },
  { wxS("green4"),                 0,139,  0 },
  { wxS("chartreuse1"),          127,255,  0 },
  { wxS("chartreuse2"),          118,238,  0 },
  { wxS("chartreuse3"),          102,205,  0 },
  { wxS("chartreuse4"),           69,139,  0 },
  { wxS("olivedrab1"),           192,255, 62 },
  { wxS("olivedrab2"),           179,238, 58 },
  { wxS("olivedrab3"),           154,205, 50 },
  { wxS("olivedrab4"),           105,139, 34 },
  { wxS("darkolivegreen1"),      202,255,112 },
  { wxS("darkolivegreen2"),      188,238,104 },
  { wxS("darkolivegreen3"),      162,205, 90 },
  { wxS("darkolivegreen4"),      110,139, 61 },
  { wxS("khaki1"),               255,246,143 },
  { wxS("khaki2"),               238,230,133 },
  { wxS("khaki3"),               205,198,115 },
  { wxS("khaki4"),               139,134, 78 },
  { wxS("lightgoldenrod1"),      255,236,139 },
  { wxS("lightgoldenrod2"),      238,220,130 },
  { wxS("lightgoldenrod3"),      205,190,112 },
  { wxS("lightgoldenrod4"),      139,129, 76 },
  { wxS("lightyellow1"),         255,255,224 },
  { wxS("lightyellow2"),         238,238,209 },
  { wxS("lightyellow3"),         205,205,180 },
  { wxS("lightyellow4"),         139,139,122 },
  { wxS("yellow1"),              255,255,  0 },
  { wxS("yellow2"),              238,238,  0 },
  { wxS("yellow3"),              205,205,  0 },
  { wxS("yellow4"),              139,139,  0 },
  { wxS("gold1"),                255,215,  0 },
  { wxS("gold2"),                238,201,  0 },
  { wxS("gold3"),                205,173,  0 },
  { wxS("gold4"),                139,117,  0 },
  { wxS("goldenrod1"),           255,193, 37 },
  { wxS("goldenrod2"),           238,180, 34 },
  { wxS("goldenrod3"),           205,155, 29 },
  { wxS("goldenrod4"),           139,105, 20 },
  { wxS("darkgoldenrod1"),       255,185, 15 },
  { wxS("darkgoldenrod2"),       238,173, 14 },
  { wxS("darkgoldenrod3"),       205,149, 12 },
  { wxS("darkgoldenrod4"),       139,101,  8 },
  { wxS("rosybrown1"),           255,193,193 },
  { wxS("rosybrown2"),           238,180,180 },
  { wxS("rosybrown3"),           205,155,155 },
  { wxS("rosybrown4"),           139,105,105 },
  { wxS("indianred1"),           255,106,106 },
  { wxS("indianred2"),           238, 99, 99 },
  { wxS("indianred3"),           205, 85, 85 },
  { wxS("indianred4"),           139, 58, 58 },
  { wxS("sienna1"),              255,130, 71 },
  { wxS("sienna2"),              238,121, 66 },
  { wxS("sienna3"),              205,104, 57 },
  { wxS("sienna4"),              139, 71, 38 },
  { wxS("burlywood1"),           255,211,155 },
  { wxS("burlywood2"),           238,197,145 },
  { wxS("burlywood3"),           205,170,125 },
  { wxS("burlywood4"),           139,115, 85 },
  { wxS("wheat1"),               255,231,186 },
  { wxS("wheat2"),               238,216,174 },
  { wxS("wheat3"),               205,186,150 },
  { wxS("wheat4"),               139,126,102 },
  { wxS("tan1"),                 255,165, 79 },
  { wxS("tan2"),                 238,154, 73 },
  { wxS("tan3"),                 205,133, 63 },
  { wxS("tan4"),                 139, 90, 43 },
  { wxS("chocolate1"),           255,127, 36 },
  { wxS("chocolate2"),           238,118, 33 },
  { wxS("chocolate3"),           205,102, 29 },
  { wxS("chocolate4"),           139, 69, 19 },
  { wxS("firebrick1"),           255, 48, 48 },
  { wxS("firebrick2"),           238, 44, 44 },
  { wxS("firebrick3"),           205, 38, 38 },
  { wxS("firebrick4"),           139, 26, 26 },
  { wxS("brown1"),               255, 64, 64 },
  { wxS("brown2"),               238, 59, 59 },
  { wxS("brown3"),               205, 51, 51 },
  { wxS("brown4"),               139, 35, 35 },
  { wxS("salmon1"),              255,140,105 },
  { wxS("salmon2"),              238,130, 98 },
  { wxS("salmon3"),              205,112, 84 },
  { wxS("salmon4"),              139, 76, 57 },
  { wxS("lightsalmon1"),         255,160,122 },
  { wxS("lightsalmon2"),         238,149,114 },
  { wxS("lightsalmon3"),         205,129, 98 },
  { wxS("lightsalmon4"),         139, 87, 66 },
  { wxS("orange1"),              255,165,  0 },
  { wxS("orange2"),              238,154,  0 },
  { wxS("orange3"),              205,133,  0 },
  { wxS("orange4"),              139, 90,  0 },
  { wxS("darkorange1"),          255,127,  0 },
  { wxS("darkorange2"),          238,118,  0 },
  { wxS("darkorange3"),          205,102,  0 },
  { wxS("darkorange4"),          139, 69,  0 },
  { wxS("coral1"),               255,114, 86 },
  { wxS("coral2"),               238,106, 80 },
  { wxS("coral3"),               205, 91, 69 },
  { wxS("coral4"),               139, 62, 47 },
  { wxS("tomato1"),              255, 99, 71 },
  { wxS("tomato2"),              238, 92, 66 },
  { wxS("tomato3"),              205, 79, 57 },
  { wxS("tomato4"),              139, 54, 38 },
  { wxS("orangered1"),           255, 69,  0 },
  { wxS("orangered2"),           238, 64,  0 },
  { wxS("orangered3"),           205, 55,  0 },
  { wxS("orangered4"),           139, 37,  0 },
  { wxS("red1"),                 255,  0,  0 },
  { wxS("red2"),                 238,  0,  0 },
  { wxS("red3"),                 205,  0,  0 },
  { wxS("red4"),                 139,  0,  0 },
  { wxS("deeppink1"),            255, 20,147 },
  { wxS("deeppink2"),            238, 18,137 },
  { wxS("deeppink3"),            205, 16,118 },
  { wxS("deeppink4"),            139, 10, 80 },
  { wxS("hotpink1"),             255,110,180 },
  { wxS("hotpink2"),             238,106,167 },
  { wxS("hotpink3"),             205, 96,144 },
  { wxS("hotpink4"),             139, 58, 98 },
  { wxS("pink1"),                255,181,197 },
  { wxS("pink2"),                238,169,184 },
  { wxS("pink3"),                205,145,158 },
  { wxS("pink4"),                139, 99,108 },
  { wxS("lightpink1"),           255,174,185 },
  { wxS("lightpink2"),           238,162,173 },
  { wxS("lightpink3"),           205,140,149 },
  { wxS("lightpink4"),           139, 95,101 },
  { wxS("palevioletred1"),       255,130,171 },
  { wxS("palevioletred2"),       238,121,159 },
  { wxS("palevioletred3"),       205,104,137 },
  { wxS("palevioletred4"),       139, 71, 93 },
  { wxS("maroon1"),              255, 52,179 },
  { wxS("maroon2"),              238, 48,167 },
  { wxS("maroon3"),              205, 41,144 },
  { wxS("maroon4"),              139, 28, 98 },
  { wxS("violetred1"),           255, 62,150 },
  { wxS("violetred2"),           238, 58,140 },
  { wxS("violetred3"),           205, 50,120 },
  { wxS("violetred4"),           139, 34, 82 },
  { wxS("magenta1"),             255,  0,255 },
  { wxS("magenta2"),             238,  0,238 },
  { wxS("magenta3"),             205,  0,205 },
  { wxS("magenta4"),             139,  0,139 },
  { wxS("orchid1"),              255,131,250 },
  { wxS("orchid2"),              238,122,233 },
  { wxS("orchid3"),              205,105,201 },
  { wxS("orchid4"),              139, 71,137 },
  { wxS("plum1"),                255,187,255 },
  { wxS("plum2"),                238,174,238 },
  { wxS("plum3"),                205,150,205 },
  { wxS("plum4"),                139,102,139 },
  { wxS("mediumorchid1"),        224,102,255 },
  { wxS("mediumorchid2"),        209, 95,238 },
  { wxS("mediumorchid3"),        180, 82,205 },
  { wxS("mediumorchid4"),        122, 55,139 },
  { wxS("darkorchid1"),          191, 62,255 },
  { wxS("darkorchid2"),          178, 58,238 },
  { wxS("darkorchid3"),          154, 50,205 },
  { wxS("darkorchid4"),          104, 34,139 },
  { wxS("purple1"),              155, 48,255 },
  { wxS("purple2"),              145, 44,238 },
  { wxS("purple3"),              125, 38,205 },
  { wxS("purple4"),               85, 26,139 },
  { wxS("mediumpurple1"),        171,130,255 },
  { wxS("mediumpurple2"),        159,121,238 },
  { wxS("mediumpurple3"),        137,104,205 },
  { wxS("mediumpurple4"),         93, 71,139 },
  { wxS("thistle1"),             255,225,255 },
  { wxS("thistle2"),             238,210,238 },
  { wxS("thistle3"),             205,181,205 },
  { wxS("thistle4"),             139,123,139 },
  { wxS("grey11"),                28, 28, 28 },
  { wxS("grey21"),                54, 54, 54 },
  { wxS("grey31"),                79, 79, 79 },
  { wxS("grey41"),               105,105,105 },
  { wxS("grey51"),               130,130,130 },
  { wxS("grey61"),               156,156,156 },
  { wxS("grey71"),               181,181,181 },
  { wxS("gray81"),               207,207,207 },
  { wxS("gray91"),               232,232,232 },
  { wxS("darkgrey"),             169,169,169 },
  { wxS("darkblue"),               0,  0,139 },
  { wxS("darkcyan"),               0,139,139 },
  { wxS("darkmagenta"),          139,  0,139 },
  { wxS("darkred"),              139,  0,  0 },
  { wxS("lightgreen"),           144,238,144 },
  { wxS("aqua"),                   0,255,255 },
  { wxS("lime"),                   0,255,  0 },
  { wxS("teal"),                   0,128,128 },
  { wxS("dimgray"),              105,105,105 },
  { wxS("slategray"),            112,128,144 },
  { wxS("gray"),                 190,190,190 },
  { wxS("navy"),                   0,  0,128 },
  { wxS("lightred"),             211,167,168 },
  { wxS("mediumspringgreen"),      0,250,154 },
  { wxS("khaki"),                240,230,140 },
  { wxS("lightgoldenrodyellow"), 250,250,210 },
  { wxS("mediumred"),            140, 34, 34 },
  { wxS("gray1"),                 10, 10, 10 },
  { wxS("gray2"),                 40, 40, 30 },
  { wxS("gray3"),                 70, 70, 70 },
  { wxS("gray4"),                100,100,100 },
  { wxS("gray5"),                130,130,130 },
  { wxS("gray6"),                160,160,160 },
  { wxS("gray7"),                190,190,190 },
  { wxS("gray8"),                210,210,210 },
  { wxS("gray9"),                240,240,240 },
  { wxS("darkgray"),             100,100,100 },
  { wxS("silver"),               192,192,192 },
  { wxS("eggplant"),             144,176,168 },
  { wxS("crimson"),              220, 20, 60 },
  { wxS("darkslategrey"),         47, 79, 79 },
  { wxS("fuchsia"),              255,  0,255 },
  { wxS("indigo"),                75,  0,130 },
  { wxS("lightgrey"),            211,211,211 },
  { wxS("lightslategrey"),       119,136,153 },
  { wxS("olive"),                128,128,  0 }
};

