/// \file pdfcolourdata.inc Definition of named RGB colours.

static const struct wxColourDesc
{
  const wxChar *name;
  unsigned char r,g,b;
}
wxColourTable[] =
{
  { wxT("snow"),                 255,250,250 },
  { wxT("ghostwhite"),           248,248,255 },
  { wxT("whitesmoke"),           245,245,245 },
  { wxT("gainsboro"),            220,220,220 },
  { wxT("floralwhite"),          255,250,240 },
  { wxT("oldlace"),              253,245,230 },
  { wxT("linen"),                250,240,230 },
  { wxT("antiquewhite"),         250,235,215 },
  { wxT("papayawhip"),           255,239,213 },
  { wxT("blanchedalmond"),       255,235,205 },
  { wxT("bisque"),               255,228,196 },
  { wxT("peachpuff"),            255,218,185 },
  { wxT("navajowhite"),          255,222,173 },
  { wxT("moccasin"),             255,228,181 },
  { wxT("cornsilk"),             255,248,220 },
  { wxT("ivory"),                255,255,240 },
  { wxT("lemonchiffon"),         255,250,205 },
  { wxT("seashell"),             255,245,238 },
  { wxT("honeydew"),             240,255,240 },
  { wxT("mintcream"),            245,255,250 },
  { wxT("azure"),                240,255,255 },
  { wxT("aliceblue"),            240,248,255 },
  { wxT("lavender"),             230,230,250 },
  { wxT("lavenderblush"),        255,240,245 },
  { wxT("mistyrose"),            255,228,225 },
  { wxT("white"),                255,255,255 },
  { wxT("black"),                  0,  0,  0 },
  { wxT("darkslategray"),         47, 79, 79 },
  { wxT("dimgrey"),              105,105,105 },
  { wxT("slategrey"),            112,128,144 },
  { wxT("lightslategray"),       119,136,153 },
  { wxT("grey"),                 190,190,190 },
  { wxT("lightgray"),            211,211,211 },
  { wxT("midnightblue"),          25, 25,112 },
  { wxT("navyblue"),               0,  0,128 },
  { wxT("cornflowerblue"),       100,149,237 },
  { wxT("darkslateblue"),         72, 61,139 },
  { wxT("slateblue"),            106, 90,205 },
  { wxT("mediumslateblue"),      123,104,238 },
  { wxT("lightslateblue"),       132,112,255 },
  { wxT("mediumblue"),             0,  0,205 },
  { wxT("royalblue"),             65,105,225 },
  { wxT("blue"),                   0,  0,255 },
  { wxT("dodgerblue"),            30,144,255 },
  { wxT("deepskyblue"),            0,191,255 },
  { wxT("skyblue"),              135,206,235 },
  { wxT("lightskyblue"),         135,206,250 },
  { wxT("steelblue"),             70,130,180 },
  { wxT("lightsteelblue"),       176,196,222 },
  { wxT("lightblue"),            173,216,230 },
  { wxT("powderblue"),           176,224,230 },
  { wxT("paleturquoise"),        175,238,238 },
  { wxT("darkturquoise"),          0,206,209 },
  { wxT("mediumturquoise"),       72,209,204 },
  { wxT("turquoise"),             64,224,208 },
  { wxT("cyan"),                   0,255,255 },
  { wxT("lightcyan"),            224,255,255 },
  { wxT("cadetblue"),             95,158,160 },
  { wxT("mediumaquamarine"),     102,205,170 },
  { wxT("aquamarine"),           127,255,212 },
  { wxT("darkgreen"),              0,100,  0 },
  { wxT("darkolivegreen"),        85,107, 47 },
  { wxT("darkseagreen"),         143,188,143 },
  { wxT("seagreen"),              46,139, 87 },
  { wxT("mediumseagreen"),        60,179,113 },
  { wxT("lightseagreen"),         32,178,170 },
  { wxT("palegreen"),            152,251,152 },
  { wxT("springgreen"),            0,255,127 },
  { wxT("lawngreen"),            124,252,  0 },
  { wxT("green"),                  0,255,  0 },
  { wxT("chartreuse"),           127,255,  0 },
  { wxT("medspringgreen"),         0,250,154 },
  { wxT("greenyellow"),          173,255, 47 },
  { wxT("limegreen"),             50,205, 50 },
  { wxT("yellowgreen"),          154,205, 50 },
  { wxT("forestgreen"),           34,139, 34 },
  { wxT("olivedrab"),            107,142, 35 },
  { wxT("darkkhaki"),            189,183,107 },
  { wxT("palegoldenrod"),        238,232,170 },
  { wxT("ltgoldenrodyello"),     250,250,210 },
  { wxT("lightyellow"),          255,255,200 },
  { wxT("yellow"),               255,255,  0 },
  { wxT("gold"),                 255,215,  0 },
  { wxT("lightgoldenrod"),       238,221,130 },
  { wxT("goldenrod"),            218,165, 32 },
  { wxT("darkgoldenrod"),        184,134, 11 },
  { wxT("rosybrown"),            188,143,143 },
  { wxT("indianred"),            205, 92, 92 },
  { wxT("saddlebrown"),          139, 69, 19 },
  { wxT("sienna"),               160, 82, 45 },
  { wxT("peru"),                 205,133, 63 },
  { wxT("burlywood"),            222,184,135 },
  { wxT("beige"),                245,245,220 },
  { wxT("wheat"),                245,222,179 },
  { wxT("sandybrown"),           244,164, 96 },
  { wxT("tan"),                  210,180,140 },
  { wxT("chocolate"),            210,105, 30 },
  { wxT("firebrick"),            178, 34, 34 },
  { wxT("brown"),                165, 42, 42 },
  { wxT("darksalmon"),           233,150,122 },
  { wxT("salmon"),               250,128,114 },
  { wxT("lightsalmon"),          255,160,122 },
  { wxT("orange"),               255,165,  0 },
  { wxT("darkorange"),           255,140,  0 },
  { wxT("coral"),                255,127, 80 },
  { wxT("lightcoral"),           240,128,128 },
  { wxT("tomato"),               255, 99, 71 },
  { wxT("orangered"),            255, 69,  0 },
  { wxT("red"),                  255,  0,  0 },
  { wxT("hotpink"),              255,105,180 },
  { wxT("deeppink"),             255, 20,147 },
  { wxT("pink"),                 255,192,203 },
  { wxT("lightpink"),            255,182,193 },
  { wxT("palevioletred"),        219,112,147 },
  { wxT("maroon"),               176, 48, 96 },
  { wxT("mediumvioletred"),      199, 21,133 },
  { wxT("violetred"),            208, 32,144 },
  { wxT("magenta"),              255,  0,255 },
  { wxT("violet"),               238,130,238 },
  { wxT("plum"),                 221,160,221 },
  { wxT("orchid"),               218,112,214 },
  { wxT("mediumorchid"),         186, 85,211 },
  { wxT("darkorchid"),           153, 50,204 },
  { wxT("darkviolet"),           148,  0,211 },
  { wxT("blueviolet"),           138, 43,226 },
  { wxT("purple"),               160, 32,240 },
  { wxT("mediumpurple"),         147,112,219 },
  { wxT("thistle"),              216,191,216 },
  { wxT("snow1"),                255,250,250 },
  { wxT("snow2"),                238,233,233 },
  { wxT("snow3"),                205,201,201 },
  { wxT("snow4"),                139,137,137 },
  { wxT("seashell1"),            255,245,238 },
  { wxT("seashell2"),            238,229,222 },
  { wxT("seashell3"),            205,197,191 },
  { wxT("seashell4"),            139,134,130 },
  { wxT("antiquewhite1"),        255,239,219 },
  { wxT("antiquewhite2"),        238,223,204 },
  { wxT("antiquewhite3"),        205,192,176 },
  { wxT("antiquewhite4"),        139,131,120 },
  { wxT("bisque1"),              255,228,196 },
  { wxT("bisque2"),              238,213,183 },
  { wxT("bisque3"),              205,183,158 },
  { wxT("bisque4"),              139,125,107 },
  { wxT("peachpuff1"),           255,218,185 },
  { wxT("peachpuff2"),           238,203,173 },
  { wxT("peachpuff3"),           205,175,149 },
  { wxT("peachpuff4"),           139,119,101 },
  { wxT("navajowhite1"),         255,222,173 },
  { wxT("navajowhite2"),         238,207,161 },
  { wxT("navajowhite3"),         205,179,139 },
  { wxT("navajowhite4"),         139,121,94 },
  { wxT("lemonchiffon1"),        255,250,205 },
  { wxT("lemonchiffon2"),        238,233,191 },
  { wxT("lemonchiffon3"),        205,201,165 },
  { wxT("lemonchiffon4"),        139,137,112 },
  { wxT("cornsilk1"),            255,248,220 },
  { wxT("cornsilk2"),            238,232,205 },
  { wxT("cornsilk3"),            205,200,177 },
  { wxT("cornsilk4"),            139,136,120 },
  { wxT("ivory1"),               255,255,240 },
  { wxT("ivory2"),               238,238,224 },
  { wxT("ivory3"),               205,205,193 },
  { wxT("ivory4"),               139,139,131 },
  { wxT("honeydew1"),            240,255,240 },
  { wxT("honeydew2"),            224,238,224 },
  { wxT("honeydew3"),            193,205,193 },
  { wxT("honeydew4"),            131,139,131 },
  { wxT("lavenderblush1"),       255,240,245 },
  { wxT("lavenderblush2"),       238,224,229 },
  { wxT("lavenderblush3"),       205,193,197 },
  { wxT("lavenderblush4"),       139,131,134 },
  { wxT("mistyrose1"),           255,228,225 },
  { wxT("mistyrose2"),           238,213,210 },
  { wxT("mistyrose3"),           205,183,181 },
  { wxT("mistyrose4"),           139,125,123 },
  { wxT("azure1"),               240,255,255 },
  { wxT("azure2"),               224,238,238 },
  { wxT("azure3"),               193,205,205 },
  { wxT("azure4"),               131,139,139 },
  { wxT("slateblue1"),           131,111,255 },
  { wxT("slateblue2"),           122,103,238 },
  { wxT("slateblue3"),           105, 89,205 },
  { wxT("slateblue4"),            71, 60,139 },
  { wxT("royalblue1"),            72,118,255 },
  { wxT("royalblue2"),            67,110,238 },
  { wxT("royalblue3"),            58, 95,205 },
  { wxT("royalblue4"),            39, 64,139 },
  { wxT("blue1"),                  0,  0,255 },
  { wxT("blue2"),                  0,  0,238 },
  { wxT("blue3"),                  0,  0,205 },
  { wxT("blue4"),                  0,  0,139 },
  { wxT("dodgerblue1"),           30,144,255 },
  { wxT("dodgerblue2"),           28,134,238 },
  { wxT("dodgerblue3"),           24,116,205 },
  { wxT("dodgerblue4"),           16, 78,139 },
  { wxT("steelblue1"),            99,184,255 },
  { wxT("steelblue2"),            92,172,238 },
  { wxT("steelblue3"),            79,148,205 },
  { wxT("steelblue4"),            54,100,139 },
  { wxT("deepskyblue1"),           0,191,255 },
  { wxT("deepskyblue2"),           0,178,238 },
  { wxT("deepskyblue3"),           0,154,205 },
  { wxT("deepskyblue4"),           0,104,139 },
  { wxT("skyblue1"),             135,206,255 },
  { wxT("skyblue2"),             126,192,238 },
  { wxT("skyblue3"),             108,166,205 },
  { wxT("skyblue4"),              74,112,139 },
  { wxT("lightskyblue1"),        176,226,255 },
  { wxT("lightskyblue2"),        164,211,238 },
  { wxT("lightskyblue3"),        141,182,205 },
  { wxT("lightskyblue4"),         96,123,139 },
  { wxT("slategray1"),           198,226,255 },
  { wxT("slategray2"),           185,211,238 },
  { wxT("slategray3"),           159,182,205 },
  { wxT("slategray4"),           108,123,139 },
  { wxT("lightsteelblue1"),      202,225,255 },
  { wxT("lightsteelblue2"),      188,210,238 },
  { wxT("lightsteelblue3"),      162,181,205 },
  { wxT("lightsteelblue4"),      110,123,139 },
  { wxT("lightblue1"),           191,239,255 },
  { wxT("lightblue2"),           178,223,238 },
  { wxT("lightblue3"),           154,192,205 },
  { wxT("lightblue4"),           104,131,139 },
  { wxT("lightcyan1"),           224,255,255 },
  { wxT("lightcyan2"),           209,238,238 },
  { wxT("lightcyan3"),           180,205,205 },
  { wxT("lightcyan4"),           122,139,139 },
  { wxT("paleturquoise1"),       187,255,255 },
  { wxT("paleturquoise2"),       174,238,238 },
  { wxT("paleturquoise3"),       150,205,205 },
  { wxT("paleturquoise4"),       102,139,139 },
  { wxT("cadetblue1"),           152,245,255 },
  { wxT("cadetblue2"),           142,229,238 },
  { wxT("cadetblue3"),           122,197,205 },
  { wxT("cadetblue4"),            83,134,139 },
  { wxT("turquoise1"),             0,245,255 },
  { wxT("turquoise2"),             0,229,238 },
  { wxT("turquoise3"),             0,197,205 },
  { wxT("turquoise4"),             0,134,139 },
  { wxT("cyan1"),                  0,255,255 },
  { wxT("cyan2"),                  0,238,238 },
  { wxT("cyan3"),                  0,205,205 },
  { wxT("cyan4"),                  0,139,139 },
  { wxT("darkslategray1"),       151,255,255 },
  { wxT("darkslategray2"),       141,238,238 },
  { wxT("darkslategray3"),       121,205,205 },
  { wxT("darkslategray4"),        82,139,139 },
  { wxT("aquamarine1"),          127,255,212 },
  { wxT("aquamarine2"),          118,238,198 },
  { wxT("aquamarine3"),          102,205,170 },
  { wxT("aquamarine4"),           69,139,116 },
  { wxT("darkseagreen1"),        193,255,193 },
  { wxT("darkseagreen2"),        180,238,180 },
  { wxT("darkseagreen3"),        155,205,155 },
  { wxT("darkseagreen4"),        105,139,105 },
  { wxT("seagreen1"),             84,255,159 },
  { wxT("seagreen2"),             78,238,148 },
  { wxT("seagreen3"),             67,205,128 },
  { wxT("seagreen4"),             46,139, 87 },
  { wxT("palegreen1"),           154,255,154 },
  { wxT("palegreen2"),           144,238,144 },
  { wxT("palegreen3"),           124,205,124 },
  { wxT("palegreen4"),            84,139, 84 },
  { wxT("springgreen1"),           0,255,127 },
  { wxT("springgreen2"),           0,238,118 },
  { wxT("springgreen3"),           0,205,102 },
  { wxT("springgreen4"),           0,139, 69 },
  { wxT("green1"),                 0,255,  0 },
  { wxT("green2"),                 0,238,  0 },
  { wxT("green3"),                 0,205,  0 },
  { wxT("green4"),                 0,139,  0 },
  { wxT("chartreuse1"),          127,255,  0 },
  { wxT("chartreuse2"),          118,238,  0 },
  { wxT("chartreuse3"),          102,205,  0 },
  { wxT("chartreuse4"),           69,139,  0 },
  { wxT("olivedrab1"),           192,255, 62 },
  { wxT("olivedrab2"),           179,238, 58 },
  { wxT("olivedrab3"),           154,205, 50 },
  { wxT("olivedrab4"),           105,139, 34 },
  { wxT("darkolivegreen1"),      202,255,112 },
  { wxT("darkolivegreen2"),      188,238,104 },
  { wxT("darkolivegreen3"),      162,205, 90 },
  { wxT("darkolivegreen4"),      110,139, 61 },
  { wxT("khaki1"),               255,246,143 },
  { wxT("khaki2"),               238,230,133 },
  { wxT("khaki3"),               205,198,115 },
  { wxT("khaki4"),               139,134, 78 },
  { wxT("lightgoldenrod1"),      255,236,139 },
  { wxT("lightgoldenrod2"),      238,220,130 },
  { wxT("lightgoldenrod3"),      205,190,112 },
  { wxT("lightgoldenrod4"),      139,129, 76 },
  { wxT("lightyellow1"),         255,255,224 },
  { wxT("lightyellow2"),         238,238,209 },
  { wxT("lightyellow3"),         205,205,180 },
  { wxT("lightyellow4"),         139,139,122 },
  { wxT("yellow1"),              255,255,  0 },
  { wxT("yellow2"),              238,238,  0 },
  { wxT("yellow3"),              205,205,  0 },
  { wxT("yellow4"),              139,139,  0 },
  { wxT("gold1"),                255,215,  0 },
  { wxT("gold2"),                238,201,  0 },
  { wxT("gold3"),                205,173,  0 },
  { wxT("gold4"),                139,117,  0 },
  { wxT("goldenrod1"),           255,193, 37 },
  { wxT("goldenrod2"),           238,180, 34 },
  { wxT("goldenrod3"),           205,155, 29 },
  { wxT("goldenrod4"),           139,105, 20 },
  { wxT("darkgoldenrod1"),       255,185, 15 },
  { wxT("darkgoldenrod2"),       238,173, 14 },
  { wxT("darkgoldenrod3"),       205,149, 12 },
  { wxT("darkgoldenrod4"),       139,101,  8 },
  { wxT("rosybrown1"),           255,193,193 },
  { wxT("rosybrown2"),           238,180,180 },
  { wxT("rosybrown3"),           205,155,155 },
  { wxT("rosybrown4"),           139,105,105 },
  { wxT("indianred1"),           255,106,106 },
  { wxT("indianred2"),           238, 99, 99 },
  { wxT("indianred3"),           205, 85, 85 },
  { wxT("indianred4"),           139, 58, 58 },
  { wxT("sienna1"),              255,130, 71 },
  { wxT("sienna2"),              238,121, 66 },
  { wxT("sienna3"),              205,104, 57 },
  { wxT("sienna4"),              139, 71, 38 },
  { wxT("burlywood1"),           255,211,155 },
  { wxT("burlywood2"),           238,197,145 },
  { wxT("burlywood3"),           205,170,125 },
  { wxT("burlywood4"),           139,115, 85 },
  { wxT("wheat1"),               255,231,186 },
  { wxT("wheat2"),               238,216,174 },
  { wxT("wheat3"),               205,186,150 },
  { wxT("wheat4"),               139,126,102 },
  { wxT("tan1"),                 255,165, 79 },
  { wxT("tan2"),                 238,154, 73 },
  { wxT("tan3"),                 205,133, 63 },
  { wxT("tan4"),                 139, 90, 43 },
  { wxT("chocolate1"),           255,127, 36 },
  { wxT("chocolate2"),           238,118, 33 },
  { wxT("chocolate3"),           205,102, 29 },
  { wxT("chocolate4"),           139, 69, 19 },
  { wxT("firebrick1"),           255, 48, 48 },
  { wxT("firebrick2"),           238, 44, 44 },
  { wxT("firebrick3"),           205, 38, 38 },
  { wxT("firebrick4"),           139, 26, 26 },
  { wxT("brown1"),               255, 64, 64 },
  { wxT("brown2"),               238, 59, 59 },
  { wxT("brown3"),               205, 51, 51 },
  { wxT("brown4"),               139, 35, 35 },
  { wxT("salmon1"),              255,140,105 },
  { wxT("salmon2"),              238,130, 98 },
  { wxT("salmon3"),              205,112, 84 },
  { wxT("salmon4"),              139, 76, 57 },
  { wxT("lightsalmon1"),         255,160,122 },
  { wxT("lightsalmon2"),         238,149,114 },
  { wxT("lightsalmon3"),         205,129, 98 },
  { wxT("lightsalmon4"),         139, 87, 66 },
  { wxT("orange1"),              255,165,  0 },
  { wxT("orange2"),              238,154,  0 },
  { wxT("orange3"),              205,133,  0 },
  { wxT("orange4"),              139, 90,  0 },
  { wxT("darkorange1"),          255,127,  0 },
  { wxT("darkorange2"),          238,118,  0 },
  { wxT("darkorange3"),          205,102,  0 },
  { wxT("darkorange4"),          139, 69,  0 },
  { wxT("coral1"),               255,114, 86 },
  { wxT("coral2"),               238,106, 80 },
  { wxT("coral3"),               205, 91, 69 },
  { wxT("coral4"),               139, 62, 47 },
  { wxT("tomato1"),              255, 99, 71 },
  { wxT("tomato2"),              238, 92, 66 },
  { wxT("tomato3"),              205, 79, 57 },
  { wxT("tomato4"),              139, 54, 38 },
  { wxT("orangered1"),           255, 69,  0 },
  { wxT("orangered2"),           238, 64,  0 },
  { wxT("orangered3"),           205, 55,  0 },
  { wxT("orangered4"),           139, 37,  0 },
  { wxT("red1"),                 255,  0,  0 },
  { wxT("red2"),                 238,  0,  0 },
  { wxT("red3"),                 205,  0,  0 },
  { wxT("red4"),                 139,  0,  0 },
  { wxT("deeppink1"),            255, 20,147 },
  { wxT("deeppink2"),            238, 18,137 },
  { wxT("deeppink3"),            205, 16,118 },
  { wxT("deeppink4"),            139, 10, 80 },
  { wxT("hotpink1"),             255,110,180 },
  { wxT("hotpink2"),             238,106,167 },
  { wxT("hotpink3"),             205, 96,144 },
  { wxT("hotpink4"),             139, 58, 98 },
  { wxT("pink1"),                255,181,197 },
  { wxT("pink2"),                238,169,184 },
  { wxT("pink3"),                205,145,158 },
  { wxT("pink4"),                139, 99,108 },
  { wxT("lightpink1"),           255,174,185 },
  { wxT("lightpink2"),           238,162,173 },
  { wxT("lightpink3"),           205,140,149 },
  { wxT("lightpink4"),           139, 95,101 },
  { wxT("palevioletred1"),       255,130,171 },
  { wxT("palevioletred2"),       238,121,159 },
  { wxT("palevioletred3"),       205,104,137 },
  { wxT("palevioletred4"),       139, 71, 93 },
  { wxT("maroon1"),              255, 52,179 },
  { wxT("maroon2"),              238, 48,167 },
  { wxT("maroon3"),              205, 41,144 },
  { wxT("maroon4"),              139, 28, 98 },
  { wxT("violetred1"),           255, 62,150 },
  { wxT("violetred2"),           238, 58,140 },
  { wxT("violetred3"),           205, 50,120 },
  { wxT("violetred4"),           139, 34, 82 },
  { wxT("magenta1"),             255,  0,255 },
  { wxT("magenta2"),             238,  0,238 },
  { wxT("magenta3"),             205,  0,205 },
  { wxT("magenta4"),             139,  0,139 },
  { wxT("orchid1"),              255,131,250 },
  { wxT("orchid2"),              238,122,233 },
  { wxT("orchid3"),              205,105,201 },
  { wxT("orchid4"),              139, 71,137 },
  { wxT("plum1"),                255,187,255 },
  { wxT("plum2"),                238,174,238 },
  { wxT("plum3"),                205,150,205 },
  { wxT("plum4"),                139,102,139 },
  { wxT("mediumorchid1"),        224,102,255 },
  { wxT("mediumorchid2"),        209, 95,238 },
  { wxT("mediumorchid3"),        180, 82,205 },
  { wxT("mediumorchid4"),        122, 55,139 },
  { wxT("darkorchid1"),          191, 62,255 },
  { wxT("darkorchid2"),          178, 58,238 },
  { wxT("darkorchid3"),          154, 50,205 },
  { wxT("darkorchid4"),          104, 34,139 },
  { wxT("purple1"),              155, 48,255 },
  { wxT("purple2"),              145, 44,238 },
  { wxT("purple3"),              125, 38,205 },
  { wxT("purple4"),               85, 26,139 },
  { wxT("mediumpurple1"),        171,130,255 },
  { wxT("mediumpurple2"),        159,121,238 },
  { wxT("mediumpurple3"),        137,104,205 },
  { wxT("mediumpurple4"),         93, 71,139 },
  { wxT("thistle1"),             255,225,255 },
  { wxT("thistle2"),             238,210,238 },
  { wxT("thistle3"),             205,181,205 },
  { wxT("thistle4"),             139,123,139 },
  { wxT("grey11"),                28, 28, 28 },
  { wxT("grey21"),                54, 54, 54 },
  { wxT("grey31"),                79, 79, 79 },
  { wxT("grey41"),               105,105,105 },
  { wxT("grey51"),               130,130,130 },
  { wxT("grey61"),               156,156,156 },
  { wxT("grey71"),               181,181,181 },
  { wxT("gray81"),               207,207,207 },
  { wxT("gray91"),               232,232,232 },
  { wxT("darkgrey"),             169,169,169 },
  { wxT("darkblue"),               0,  0,139 },
  { wxT("darkcyan"),               0,139,139 },
  { wxT("darkmagenta"),          139,  0,139 },
  { wxT("darkred"),              139,  0,  0 },
  { wxT("lightgreen"),           144,238,144 },
  { wxT("aqua"),                   0,255,255 },
  { wxT("lime"),                   0,255,  0 },
  { wxT("teal"),                   0,128,128 },
  { wxT("dimgray"),              105,105,105 },
  { wxT("slategray"),            112,128,144 },
  { wxT("gray"),                 190,190,190 },
  { wxT("navy"),                   0,  0,128 },
  { wxT("lightred"),             211,167,168 },
  { wxT("mediumspringgreen"),      0,250,154 },
  { wxT("khaki"),                240,230,140 },
  { wxT("lightgoldenrodyellow"), 250,250,210 },
  { wxT("mediumred"),            140, 34, 34 },
  { wxT("gray1"),                 10, 10, 10 },
  { wxT("gray2"),                 40, 40, 30 },
  { wxT("gray3"),                 70, 70, 70 },
  { wxT("gray4"),                100,100,100 },
  { wxT("gray5"),                130,130,130 },
  { wxT("gray6"),                160,160,160 },
  { wxT("gray7"),                190,190,190 },
  { wxT("gray8"),                210,210,210 },
  { wxT("gray9"),                240,240,240 },
  { wxT("darkgray"),             100,100,100 },
  { wxT("silver"),               192,192,192 },
  { wxT("eggplant"),             144,176,168 },
  { wxT("crimson"),              220, 20, 60 },
  { wxT("darkslategrey"),         47, 79, 79 },
  { wxT("fuchsia"),              255,  0,255 },
  { wxT("indigo"),                75,  0,130 },
  { wxT("lightgrey"),            211,211,211 },
  { wxT("lightslategrey"),       119,136,153 },
  { wxT("olive"),                128,128,  0 }
};

