/*!  \file sfscale.h
  Header file for structure factor anisotropic scaling object
*/
//C Copyright (C) 2000-2006 Kevin Cowtan and University of York
//L
//L  This library is free software and is distributed under the terms
//L  and conditions of version 2.1 of the GNU Lesser General Public
//L  Licence (LGPL) with the following additional clause:
//L
//L     `You may also combine or link a "work that uses the Library" to
//L     produce a work containing portions of the Library, and distribute
//L     that work under terms of your choice, provided that you give
//L     prominent notice with each copy of the work that the specified
//L     version of the Library is used in it, and that you include or
//L     provide public access to the complete corresponding
//L     machine-readable source code for the Library including whatever
//L     changes were used in the work. (i.e. If you make changes to the
//L     Library you must distribute those, but you do not need to
//L     distribute source or object code to those portions of the work
//L     not covered by this licence.)'
//L
//L  Note that this clause grants an additional right and does not impose
//L  any additional restriction, and so does not affect compatibility
//L  with the GNU General Public Licence (GPL). If you wish to negotiate
//L  other terms, please contact the maintainer.
//L
//L  You can redistribute it and/or modify the library under the terms of
//L  the GNU Lesser General Public License as published by the Free Software
//L  Foundation; either version 2.1 of the License, or (at your option) any
//L  later version.
//L
//L  This library is distributed in the hope that it will be useful, but
//L  WITHOUT ANY WARRANTY; without even the implied warranty of
//L  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//L  Lesser General Public License for more details.
//L
//L  You should have received a copy of the CCP4 licence and/or GNU
//L  Lesser General Public License along with this library; if not, write
//L  to the CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
//L  The GNU Lesser General Public can also be obtained by writing to the
//L  Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
//L  MA 02111-1307 USA


#ifndef CLIPPER_SFSCALE
#define CLIPPER_SFSCALE


#include "function_object_bases.h"
#include "../core/resol_targetfn.h"


namespace clipper {


  //! Structure factor anisotropic scaling
  /*! Perform structure factor anisotropic scaling, observed to calculated,
    calculated to observed, or observed against itself.
    \ingroup g_funcobj */
  template<class T> class SFscale_aniso : public SFscale_base<T> {
  public:
    enum TYPE { F, I };  //!< type for returning U_aniso_orth
    enum MODE { NORMAL, SHARPEN, UNSHARPEN };  //!< mode for scaling 
    //! constructor: takes rejection criterion for F/sigF
    SFscale_aniso( ftype nsig = 0.0, MODE mode = NORMAL )
      : nsig_(nsig), mode_(mode) {}
    //! Scale Fo to Fc
    bool operator() ( HKL_data<datatypes::F_sigF<T> >& fo, const HKL_data<datatypes::F_phi<T> >& fc );
    //! Scale Fc to Fo
    bool operator() ( HKL_data<datatypes::F_phi<T> >& fc, const HKL_data<datatypes::F_sigF<T> >& fo );
    //! Scale Fo to isotropic (approximate)
    bool operator() ( HKL_data<datatypes::F_sigF<T> >& fo );
    //! Scale Fo to isotropic (approximate)
    bool operator() ( HKL_data<datatypes::F_sigF<T> >& fo, const ftype resfilter, const int npar_scl );
    //! Scale Io to isotropic (approximate)
    bool operator() ( HKL_data<datatypes::I_sigI<T> >& Io, const ftype resfilter, const int npar_scl );
    //! Primitive scaling functions for F and I
    template<class D, class T1, class T2, class S>
      bool scale( HKL_data<D>& fo, const ftype resfilter, const int npar_scl );
    //! return aniso correction on F or I
    const U_aniso_orth& u_aniso_orth( TYPE t ) const;
    const U_aniso_orth& u_aniso_orth() const { return u_i; }  //!< \deprecated
  private:
    const T&    obs( const datatypes::F_sigF<T>& f ) { return f.f(); }
    const T&    obs( const datatypes::I_sigI<T>& f ) { return f.I(); }
    const T& sigobs( const datatypes::F_sigF<T>& f ) { return f.sigf(); }
    const T& sigobs( const datatypes::I_sigI<T>& f ) { return f.sigI(); }
    U_aniso_orth u_i, u_f;
    ftype nsig_;
    MODE mode_;
  };


} // namespace clipper

#endif
