# Математические функции

Все функции возвращают число типа Float64. Точность результата близка к максимально возможной, но результат может не совпадать с наиболее близким к соответствующему вещественному числу машинно представимым числом.

## e()

Возвращает число типа Float64, близкое к числу e.

## pi()
Возвращает число типа Float64, близкое к числу π.

## exp(x)
Принимает числовой аргумент, возвращает число типа Float64, близкое к экспоненте от аргумента.

## log(x)
Принимает числовой аргумент, возвращает число типа Float64, близкое к натуральному логарифму от аргумента.

## exp2(x)
Принимает числовой аргумент, возвращает число типа Float64, близкое к 2 в степени x.

## log2(x)
Принимает числовой аргумент, возвращает число типа Float64, близкое к двоичному логарифму от аргумента.

## exp10(x)
Принимает числовой аргумент, возвращает число типа Float64, близкое к 10 в степени x.

## log10(x)
Принимает числовой аргумент, возвращает число типа Float64, близкое к десятичному логарифму от аргумента.

## sqrt(x)
Принимает числовой аргумент, возвращает число типа Float64, близкое к квадратному корню от аргумента.

## cbrt(x)
Принимает числовой аргумент, возвращает число типа Float64, близкое к кубическому корню от аргумента.

## erf(x)

Если x неотрицательно, то erf(x / σ√2) - вероятность того, что случайная величина, имеющая нормальное распределение со среднеквадратичным отклонением σ, принимает значение, отстоящее от мат. ожидания больше чем на x.

Пример (правило трёх сигм):

``` sql
SELECT erf(3 / sqrt(2))
```

```
┌─erf(divide(3, sqrt(2)))─┐
│      0.9973002039367398 │
└─────────────────────────┘
```

## erfc(x)
Принимает числовой аргумент, возвращает число типа Float64, близкое к 1 - erf(x), но без потери точности для больших x.

## lgamma(x)
Логарифм от гамма функции.

## tgamma(x)
Гамма функция.

## sin(x)
Синус.

## cos(x)
Косинус.

## tan(x)
Тангенс.

## asin(x)
Арксинус.

## acos(x)
Арккосинус.

## atan(x)
Арктангенс.

## pow(x, y)
Принимает два числовых аргумента x и y. Возвращает число типа Float64, близкое к x в степени y.

[Оригинальная статья](https://clickhouse.yandex/docs/ru/query_language/functions/math_functions/) <!--hide-->
