/*
 * $Id: mkdcmp.c,v 1.2 1996/03/15 15:54:00 cremel Exp $
 *
 * $Log: mkdcmp.c,v $
 * Revision 1.2  1996/03/15 15:54:00  cremel
 * In the command panels add quotes in text when they are missing (call to
 * "quote_string").
 *
 * Revision 1.1.1.1  1996/03/08 15:33:07  mclareni
 * Kuip
 *
 */
/*CMZ :  2.07/03 09/05/95  11.54.43  by  N.Cremel*/
/*-- Author :    N.Cremel   10/08/92*/
/******************************************************************************/
/*                                                                            */
/*           MOTIF-based library for KUIP - deck MKDCMP                       */
/*                                                                            */
/*           Basic Interface for any "KUIP Command Panels " (Menu "Commands") */
/*           (connected to the file //KUIP/XMCLIB/KUXCMP for building the     */
/*           panels with Architect : "create_kuipCommand").                   */
/*                                                                            */
/******************************************************************************/
#include "kuip/kuip.h"
#include "kuip/kfor.h"
#include "kuip/kmenu.h"
#include "kuip/kflag.h"

#include <stdio.h>
#include <string.h>

/* Global SEQUENCES (defined in MKCDES)                                       */
#include "mkincl.h"
#include "mkdims.h"
#include "kuip/mkutfu.h"
#include "mkutfm.h"
#include "mkutdm.h"
#define CONTEXT_MACRO_ACCESS 1
#include "mkuxcm.h"
#include "mkuxol.h"
#include "mkuxfs.h"
#undef CONTEXT_MACRO_ACCESS
#include "mksres.h"
#include "mksreg.h"

/***********************************************************************
 *                                                                     *
 *   Local datas.                                                      *
 *                                                                     *
 ***********************************************************************/

static int WM_x = 0;   /* width of Window Manager decoration */
static int WM_y = 0;   /* height of Window Manager decoration */

int kuipFilSel_width = 300; /* from kuipFilSel.c generated by Architect */
int kuipOptList_width = 200; /* from kuipOptList.c generated by Architect */

/******************************************************************************/
/*  external definition                                                       */
/******************************************************************************/
extern int do_exec;

/* structure definition */
typedef struct {
        Widget command_panel;
        Widget command_panel_form;
        KmCommand *cmd;
        int    error;
/*      int    flag; */
               } CP_str;  /* tag structure for CPCallback */

typedef struct {
        Widget command_panel;
        Widget swidget;
        KmCommand *cmd;
        int index;
               } SC_str; /* tag structure for SCale (set_cmdScale...) */


typedef struct {
        Widget command_panel;
        char *opt_val;
        int index;
               } OP_str; /* tag structure for OPtion menu (set_cmdOpt) */



#define MAX_CMD_PANEL    10
#define TEXT_PAR          0
#define SCALI_PAR         1
#define SCALR_PAR         2
#define OPT_PAR           3
#define FILE_PAR          4


/* local data */
typedef struct {
   int       swpar;                /* number of parameters */
   Widget    widget;               /* command panel dialog shell */
   Widget    form;                 /* command panel form container */
   Widget    scmenu;               /* scale option : DRAG or VALUE CHANGED */
   Widget    swtext[MAX_parm];     /* text for parameter entry */
   Widget    swspecific[MAX_parm]; /* can be scale, option-menu, ... */
   Widget    swtoggle[MAX_parm];
} CmdpanelStruct;                  /* Retrieve values with get_cp_context */

static CmdpanelStruct Str_cmdpanel[MAX_CMD_PANEL];
static int            n_cmdpanel              = 0;
static Widget CPWform, CPWscmenu;
static Widget CPWtext[MAX_parm], CPWspecific[MAX_parm], CPWtoggle[MAX_parm];
static int CPWpar ;

static Widget  opt_list = NULL;

Widget  km_fil_sel = NULL;

/***********************************************************************
 *                                                                     *
 *   Forward declarations of global functions.                         *
 *                                                                     *
 ***********************************************************************/

C_PROTO_3(void km_clFCallback,
                         Widget widget,
                         caddr_t tag,
                         XmAnyCallbackStruct   *data);


/***********************************************************************
 *                                                                     *
 *   Forward declarations of local functions.                          *
 *                                                                     *
 ***********************************************************************/

static C_PROTO_1(int  get_cp_context,
                         Widget w);
static C_PROTO_3(void okCPCallback,
                         Widget widget,
                         caddr_t tag,
                         XmAnyCallbackStruct   *data);
static C_PROTO_3(void executeCPCallback,
                         Widget widget,
                         CP_str *stag,
                         XmAnyCallbackStruct   *data);
static C_PROTO_3(void resetCPCallback,
                         Widget widget,
                         caddr_t tag,
                         XmAnyCallbackStruct   *data);
static C_PROTO_3(void cancelCPCallback,
                         Widget widget,
                         caddr_t tag,
                         XmAnyCallbackStruct   *data);
static C_PROTO_3(void helpCPCallback,
                         Widget widget,
                         caddr_t tag,
                         XmAnyCallbackStruct   *data);
static C_PROTO_3(void set_cmdScaleInt,
                         Widget widget,
                         caddr_t tag,
                         XmScaleCallbackStruct *scale);
static C_PROTO_3(void set_cmdScaleReal,
                         Widget widget,
                         caddr_t tag,
                         XmScaleCallbackStruct *scale);
static C_PROTO_3(void set_cmdOpt,
                         Widget widget,
                         caddr_t tag,
                         XmAnyCallbackStruct   *data);
static C_PROTO_3(void set_filSel,
                         Widget widget,
                         caddr_t tag,
                         XmAnyCallbackStruct   *data);
static C_PROTO_3(void set_optList,
                         Widget widget,
                         caddr_t tag,
                         XmAnyCallbackStruct   *data);
static C_PROTO_3(void okFCallback,
                         Widget widget,
                         int tag,
                         XmFileSelectionBoxCallbackStruct *data);
static C_PROTO_3(void okLCallback,
                         Widget widget,
                         caddr_t tag,
                         XmAnyCallbackStruct   *data);
static C_PROTO_3(void clLCallback,
                         Widget widget,
                         caddr_t tag,
                         XmAnyCallbackStruct   *data);
static C_PROTO_3(void reset_grab,
                         Widget widget,
                         int *grab,
                         XmAnyCallbackStruct   *data);
static C_PROTO_3(char *execute_command,
                         Widget panel,
                         Widget panel_form,
                         KmCommand *cmd);
static C_PROTO_1(void destroy_panel,
                         Widget panel);
#if 0
static C_PROTO_3(void focus_cmdpan,
                         Widget   widget,
                         caddr_t tag,
                         XEnterWindowEvent *ev);
#endif


/***********************************************************************
 *                                                                     *
 *   Forward declarations of extern functions.                         *
 *                                                                     *
 ***********************************************************************/
extern C_PROTO_0(Widget create_kuipCommand);
extern C_PROTO_0(Widget create_kuipOptList);


/******************************************************************************/
/* int km_display_cmdpan (cmd, msg, flag)                                     */
/*                                                                            */
/*      input :                                                               */
/*                                                                            */
/*               int flag :  0 ---> no grab                                   */
/*                           1 ---> grab (wait for OK or CANCEL)              */
/*                           2 ---> set/reset panel to default values         */
/******************************************************************************/
int km_display_cmdpan( cmd, msg, flag )
     KmCommand *cmd;
     char *msg;
     int flag;
{
  Widget kuipCommandPanel;
  Widget kuipCommandForm;  /* form container for ALL parameters */
  Widget parentCommandForm, BottomSep;
  Widget kuipCommand_title;
  Widget subw_form[MAX_parm+1];  /* form container for EACH parameter */
  Widget subw_id1[MAX_parm];
  Widget subw_id2[MAX_parm];
  Widget subw_id3[MAX_parm];
  Widget ScaleOpt_form;
  Widget ScaleOpt_menu_shell;
  Widget ScaleOpt_menu = 0;
  Widget ScaleOpt_menu_p;
  Widget opt_menu, opt_menu_b[MAX_opt+1], opt_menu_bhis;


  char cnam[MAX_string], cnam1[MAX_string];
  char title[MAX_string];
  char prstring[MAX_string];
  char *instring;
  char message[MAX_stringl];

  double rlow;
  double rhigh;
  double rval;

  int pcode[MAX_parm+1];
  int idef;
  int ilow;
  int ihigh;
  int decimal;
  int i;
  int j;
  int cmdpanel = 0;
  Dimension fheight, fh, fw;

  Boolean no_action;
  Boolean do_scale;

  static CP_str CP_tag[MAX_CMD_PANEL];
  static SC_str SC_tag[MAX_CMD_PANEL][MAX_parm+1];
  static OP_str OP_tag[MAX_CMD_PANEL][MAX_parm+1][MAX_opt];
  static int grab;


  no_action = False;
  if( cmd->action_F == NULL && cmd->action_C == NULL )
    no_action = True;
  if( no_action ) {
    char cval[MAX_stringl];

    /* No action routine for this command : execute Help */
    sprintf( cval, "/KUIP/HELP %s", cmd->name );
    exec_cmd_string( cval, 0, NULL );
    return 1;
  }

  if( n_cmdpanel >= MAX_CMD_PANEL ) {
    km_warn_user( km_toplevel, "Cannot Open More Command Panels !", " \n \
 Warning :\n \
 _________\n\n \
 too many command panels have been created. To continue,\n \
 first press OK in the Warning Box and then erase some \n \
 command panels (Cancel button) !" );

    return 1;
  }


  /* Create Command Panel widget (with Architect) */
  kuipCommandPanel = create_kuipCommand();


  /*
   *   find and restore the context
   *   (to get to the widgets belonging to this dialog)
   */
  UxKuipCommandPContext = (_UxCkuipCommandP *)UxGetContext( kuipCommandPanel );


  /* Loop on all parameters to set values of pcode (type) and do_scale */
  do_scale = False;
  for( i = 0; i < cmd->total; i++ ) {
    KmParameter *par   = cmd->par[i];
    KmParInt    *pint  = par->ptype;
    KmParReal   *preal = par->ptype;

    if( i > MAX_parm ) {
      sprintf( message, "Maximum number of parameters for command panel is %d",
              MAX_parm );
      km_print_box( km_toplevel, km_xcur_pos, km_ycur_pos, message, 4 );
      break;
    }

    /* for all types : if range defined then create an "option menu" */
    if( par->range_count != 0 )
      pcode[i] = OPT_PAR;
    else
      pcode[i] = TEXT_PAR;

    switch( par->type ) {

    case KmTYPE_CHAR:
      break;

    case KmTYPE_FILE:
      pcode[i] = FILE_PAR;
      break;

    case KmTYPE_OPTION:
      break;

    case KmTYPE_INT:
      if( pint != NULL
         && pint->slider_lower != NULL && pint->slider_upper != NULL ) {
        do_scale = True;
        pcode[i] = SCALI_PAR;
      }
      break;

    case KmTYPE_REAL:
      if( preal != NULL
         && preal->slider_lower != NULL && preal->slider_upper != NULL ) {
        do_scale = True;
        pcode[i] = SCALR_PAR;
      }
      break;

    }  /* end ... switch( par->type ) */

  } /* end ... for( i = 0; i < cmd->total; i++ ) */


  /* Set "Scale behavior" menu if necessary */
  if( do_scale ) {
    ScaleOpt_form = XtVaCreateManagedWidget( "ScaleOpt_form",
                        xmFormWidgetClass, kuipCommandPanel,
                        XmNrightOffset, 15,
                        XmNrightAttachment, XmATTACH_FORM,
                        XmNleftOffset, 15,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNbottomWidget, commandSep,
                        XmNbottomAttachment, XmATTACH_WIDGET,
                        XmNheight, 60,
                        XmNresizePolicy, XmRESIZE_NONE,
                        NULL );
    ScaleOpt_menu_shell = XtVaCreatePopupShell ("ScaleOpt_menu_shell",
                        xmMenuShellWidgetClass, ScaleOpt_form,
                        XmNwidth, 1,
                        XmNheight, 1,
                        XmNallowShellResize, TRUE,
                        XmNoverrideRedirect, TRUE,
                        NULL );
    ScaleOpt_menu_p = XtVaCreateWidget( "ScaleOpt_menu_p",
                        xmRowColumnWidgetClass, ScaleOpt_menu_shell,
                        XmNrowColumnType, XmMENU_PULLDOWN,
                        NULL );
    XtVaCreateManagedWidget( "ScaleOpt_menu_b1",
                        xmPushButtonGadgetClass, ScaleOpt_menu_p,
                        RES_CONVERT( XmNlabelString, "VALUE_CHANGED" ),
                        NULL );
    XtVaCreateManagedWidget( "ScaleOpt_menu_b2",
                        xmPushButtonGadgetClass, ScaleOpt_menu_p,
                        RES_CONVERT( XmNlabelString, "DRAG" ),
                        NULL );
    ScaleOpt_menu = XtVaCreateManagedWidget( "ScaleOpt_menu",
                        xmRowColumnWidgetClass, ScaleOpt_form,
                        XmNtopOffset, 0,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNmarginHeight, 20,
                        XmNleftOffset, 0,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNbottomOffset, 0,
                        XmNbottomAttachment, XmATTACH_FORM,
                        RES_CONVERT( XmNlabelString, "Scale behavior >" ),
                        XmNsubMenuId, ScaleOpt_menu_p,
                        XmNnavigationType, XmEXCLUSIVE_TAB_GROUP,
                        XmNrowColumnType, XmMENU_OPTION,
                        NULL );
   } /* end ...  if( do_scale ) */

   /* Create scrollwindow and form container for all parameters */
   if ( strncmp (srec.scrolled_cmdpanel, "always", 6) == 0 ||
        (cmd->total > 10 && strncmp (srec.scrolled_cmdpanel, "auto", 4)  == 0) )
   {
   /* if more that 10 parms. fix the height & width and put a scroll window */
   parentCommandForm =  XtVaCreateWidget( "parentCommandForm",
                             xmScrolledWindowWidgetClass,
                             kuipCommandPanel,
                             XmNwidth, 500,
                             XmNtopOffset, 20,
                             XmNtopAttachment, XmATTACH_FORM,
                             XmNrightOffset, 20,
                             XmNrightAttachment, XmATTACH_FORM,
                             XmNleftOffset, 30,
                             XmNleftAttachment, XmATTACH_FORM,
                             XmNbottomAttachment, XmATTACH_WIDGET,
                             XmNscrollingPolicy, XmAUTOMATIC,
                             NULL );
   if (cmd->total > 5) XtVaSetValues (parentCommandForm, XmNheight, 300, NULL);
   } else
   /* otherwise no scroll window */
   parentCommandForm =  XtVaCreateWidget( "parentCommandForm",
                             xmScrolledWindowWidgetClass,
                             kuipCommandPanel,
                             XmNtopOffset, 20,
                             XmNtopAttachment, XmATTACH_FORM,
                             XmNrightOffset, 20,
                             XmNrightAttachment, XmATTACH_FORM,
                             XmNleftOffset, 30,
                             XmNleftAttachment, XmATTACH_FORM,
                             XmNbottomAttachment, XmATTACH_WIDGET,
                             XmNvisualPolicy, XmVARIABLE,
                             NULL );
   kuipCommandForm = XtVaCreateWidget( "kuipCommandForm",
                        xmFormWidgetClass, parentCommandForm,
                        NULL );


  /* Fill CP_tag structure for callbacks */
  for( i = 0; i < MAX_CMD_PANEL; i++ ) {
    if( !CP_tag[i].command_panel ) {
      cmdpanel = i;
      break;
    }
  }
  CP_tag[cmdpanel].command_panel = kuipCommandPanel;
  CP_tag[cmdpanel].command_panel_form = kuipCommandForm;
  CP_tag[cmdpanel].cmd = cmd;
  CP_tag[cmdpanel].error = 0;
/*   CP_tag[cmdpanel].flag = flag; */


  /* Set various attributes */
  XtVaSetValues( kuipCommandPanel,
                 XmNautoUnmanage, False,
                 NULL );
  if( flag == 1)
    XtVaSetValues( kuipCommandPanel,
                  XmNautoUnmanage, False,
                  XmNdialogStyle, XmDIALOG_FULL_APPLICATION_MODAL,
                  NULL );
  if (srec.center_command != 1)
    XtVaSetValues( kuipCommandPanel,
                  XmNdefaultPosition, False,
                  NULL );
  else /* centerCommand: True (= 1) */
    XtVaSetValues( kuipCommandPanel,
                  XmNdefaultPosition, True,
                  NULL );


  if( cmd->total == 0 ) {

  /* Special case : cmd->total = 0 (no parameters: terminal command) */

    sprintf( message, "No parameters. Terminal Command : %s", cmd->path );
    subw_form[0] = XtVaCreateManagedWidget( "subwForm0",
                        xmFormWidgetClass, kuipCommandForm,
                        XmNtopOffset, 20,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNrightOffset, 15,
                        XmNrightAttachment, XmATTACH_FORM,
                        XmNleftOffset, 15,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNbottomOffset, 20,
                        XmNbottomAttachment, XmATTACH_FORM,
                        XmNheight, 40,
                        XmNresizePolicy, XmRESIZE_NONE,
                        NULL );
    XtVaCreateManagedWidget("subw_lab",
                        xmLabelWidgetClass, subw_form[0],
                        XmNtopOffset, 0,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNleftOffset, 0,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNbottomOffset, 0,
                        XmNbottomAttachment, XmATTACH_FORM,
                        RES_CONVERT( XmNlabelString, message ),
                        NULL );
  } else {

  /*
   * Loop on all parameters and create children of popup_dialog_box
   * by using specific widgets (according to pcode) for each parameter
   * (text, scale, option menu, ...)
   */
  for( i = 0; i < cmd->total; i++ ) {
    KmParameter *par   = cmd->par[i];
    KmParInt    *pint  = par->ptype;
    KmParReal   *preal = par->ptype;

    if( i > MAX_parm ) {
      sprintf( message, "Maximum number of parameters for command panel is %d",
              MAX_parm );
      km_print_box( km_toplevel, km_xcur_pos, km_ycur_pos, message, 4 );
      break;
    }

    /* Set prompt string for each parameters (with parameter names prstring) */
    if( i < cmd->mandatory ) {
      /* mandatory parameter */
      strcpy( prstring, par->prompt );
    } else {
      strcpy( prstring, "[" );
      strcat( prstring, par->prompt );
      strcat( prstring, "]" );
    }

    /* get initial string (to be written in text widget) */
    if (flag == 2) {
      /* Take default values if any */
      if( par->dfault != NULL )
        instring = par->dfault;
      else
        instring = "";
    } else {
      /* Take last value first (if any) to fill the corresponding field */
      if( i < cmd->argc && cmd->argv[i] != NULL )
        instring = cmd->argv[i];
      else if( par->last != NULL )
        instring = par->last;
      else if( par->dfault != NULL )
        instring = par->dfault;
      else
        instring = "";
      if (cmd->argc > cmd->total) {
      /* real number of args. in command line is greater than expected:
         take all remaining args. (rest of argline) for the last one.
         (e.g. commands SHELL ..., MESSAGE ...).
      */
        instring = cmd->argline + cmd->argoffs[i];
      }
    }


    /* Create form container for each parameter */
    switch( pcode[i] ) {
          /* Size of form depends on parameter type */
          case TEXT_PAR:
          case FILE_PAR:
          case OPT_PAR:
               fheight = 40;
          break ;

          case SCALI_PAR:
          case SCALR_PAR:
          default:
               fheight = 60;
          break ;
    } /* end ... switch( pcode[i] ) */
    sprintf( cnam, "subwForm%d", i + 1 );
    if (i == 0) {                   /* First parameter */
        subw_form[i] = XtVaCreateManagedWidget( cnam,
                        xmFormWidgetClass, kuipCommandForm,
                        XmNtopOffset, 20,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNrightOffset, 15,
                        XmNrightAttachment, XmATTACH_FORM,
                        XmNleftOffset, 15,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNheight, fheight,
                        XmNresizePolicy, XmRESIZE_NONE,
                        NULL );
    } else {
        subw_form[i] = XtVaCreateManagedWidget( cnam,
                        xmFormWidgetClass, kuipCommandForm,
                        XmNtopWidget, subw_form[i-1],
                        XmNtopAttachment, XmATTACH_WIDGET,
                        XmNrightOffset, 15,
                        XmNrightAttachment, XmATTACH_FORM,
                        XmNleftOffset, 15,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNheight, fheight,
                        XmNresizePolicy, XmRESIZE_NONE,
                        NULL );
    } /* end ... if (i == 0) */

    /* For last parameter : create dummy form for attachments */
    if (i == cmd->total-1) {
        sprintf( cnam, "subwForm%d", i + 2 );
        subw_form[i+1] = XtVaCreateManagedWidget( cnam,
                        xmFormWidgetClass, kuipCommandForm,
                        XmNtopWidget, subw_form[i],
                        XmNtopAttachment, XmATTACH_WIDGET,
                        XmNrightOffset, 15,
                        XmNrightAttachment, XmATTACH_FORM,
                        XmNleftOffset, 15,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNbottomOffset, 20,
                        XmNbottomAttachment, XmATTACH_FORM,
                        XmNresizePolicy, XmRESIZE_NONE,
                        NULL );
    } /* end ... if (i == cmd->total-1) */


    switch( pcode[i] ) {
    /* Represents each parameter type with sub_widgets */

    case TEXT_PAR: /* label + small text window for string or integer value */
    case FILE_PAR:

      strcat( prstring, " > " );
      sprintf (cnam, "cmdLab%d",i+1);
      subw_id1[i] = XtVaCreateManagedWidget(cnam,
                        xmLabelWidgetClass, subw_form[i],
                        XmNtopOffset, 0,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNleftOffset, 0,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNbottomOffset, 0,
                        XmNbottomAttachment, XmATTACH_FORM,
                        RES_CONVERT( XmNlabelString, prstring ),
                        XmNnavigationType, XmNONE,
                        NULL );
      if ( pcode[i] == FILE_PAR) { /* provide button for file selection box */
      /* Button "Select" */
           sprintf (cnam, "cmdLabSel%d",i+1);
           subw_id3[i] = XtVaCreateManagedWidget( cnam,
                        xmPushButtonGadgetClass, subw_form[i],
                        XmNtopOffset, 5,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNleftWidget, subw_id1[i],
                        XmNleftOffset, 5,
                        XmNleftAttachment, XmATTACH_WIDGET,
                        RES_CONVERT( XmNlabelString, " Select " ),
                        XmNbottomOffset, 5,
                        XmNbottomAttachment, XmATTACH_FORM,
                        NULL );
           SC_tag[cmdpanel][i].command_panel = kuipCommandPanel;
           SC_tag[cmdpanel][i].cmd = cmd;
           SC_tag[cmdpanel][i].index = i;
           XtAddCallback( subw_id3[i], XmNactivateCallback,
                    (XtCallbackProc)set_filSel, &SC_tag[cmdpanel][i] );
      }
      sprintf (cnam, "cmdText%d",i+1);
      subw_id2[i] = XtVaCreateManagedWidget( cnam,
                        xmTextWidgetClass, subw_form[i],
                        XmNtopOffset, 5,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNrightOffset, 0,
                        XmNrightAttachment, XmATTACH_FORM,
                        XmNleftAttachment, XmATTACH_WIDGET,
                        XmNbottomOffset, 5,
                        XmNbottomAttachment, XmATTACH_FORM,
                        XmNvalue, instring,
                        XmNnavigationType, XmEXCLUSIVE_TAB_GROUP,
                        XmNmarginHeight, 2,
                        NULL );

      if ( pcode[i] == FILE_PAR) {
      /* Set left attachement to "Select" button for command-text */
      XtVaSetValues( subw_id2[i], XmNleftWidget, subw_id3[i],
                                  XmNleftOffset, 5,
                                  NULL );
      } else {
      /* Set left attachement to label for command-text */
      XtVaSetValues( subw_id2[i], XmNleftWidget, subw_id1[i],
                                  NULL );
      }
#if OLD_TAB
      XmAddTabGroup( subw_id2[i] );
      XtOverrideTranslations( subw_id2[i],
                     XtParseTranslationTable( "<Key>Down:next-tab-group()" ) );
#endif

      break ;


    case SCALI_PAR: /* Scale widget for integer value + toggle + text */

      /* integer scale */
      ilow = atoi( pint->slider_lower );
      ihigh = atoi( pint->slider_upper );
      if( instring[0] == '\0' )
        idef = ilow;
      else
        idef = atoi( instring );
      sprintf( cnam, "cmdScale%d", i + 1 );
      subw_id1[i] = XtVaCreateManagedWidget( cnam,
                        xmScaleWidgetClass, subw_form[i],
                        XmNrightPosition, 60,
                        XmNrightAttachment, XmATTACH_POSITION,
                        XmNtopOffset, 0,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNleftOffset, 0,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNbottomOffset, 0,
                        XmNbottomAttachment, XmATTACH_FORM,
                        RES_CONVERT( XmNtitleString, prstring ),
                        XmNshowValue, TRUE,
                        XmNorientation, XmHORIZONTAL,
                        XmNvalue, idef,
                        XmNminimum, ilow,
                        XmNmaximum, ihigh,
                        XmNnavigationType, XmEXCLUSIVE_TAB_GROUP,
                        NULL );

      /* toggle button */
      sprintf( cnam, "cmdScaleToggle%d", i + 1 );
      subw_id3[i] = XtVaCreateManagedWidget( cnam,
                        xmToggleButtonGadgetClass, subw_form[i],
                        RES_CONVERT( XmNlabelString, "" ),
                        XmNtopOffset, 0,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNleftWidget, subw_id1[i],
                        XmNleftAttachment, XmATTACH_WIDGET,
                        XmNbottomOffset, 0,
                        XmNbottomAttachment, XmATTACH_FORM,
                        XmNnavigationType, XmEXCLUSIVE_TAB_GROUP,
                        NULL );

      /* text window */
      sprintf (cnam, "cmdText%d",i+1);
      subw_id2[i] = XtVaCreateManagedWidget( cnam,
                        xmTextWidgetClass, subw_form[i],
                        XmNleftWidget, subw_id3[i],
                        XmNleftAttachment, XmATTACH_WIDGET,
                        XmNtopOffset, 15,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNrightOffset, 0,
                        XmNrightAttachment, XmATTACH_FORM,
                        XmNbottomOffset, 15,
                        XmNbottomAttachment, XmATTACH_FORM,
                        XmNvalue, instring,
                        XmNnavigationType, XmEXCLUSIVE_TAB_GROUP,
                        NULL );

      /* Add callbacks on scale */
      SC_tag[cmdpanel][i].command_panel = kuipCommandPanel;
      SC_tag[cmdpanel][i].cmd = cmd;
      SC_tag[cmdpanel][i].index = i;
      XtAddCallback( subw_id1[i], XmNvalueChangedCallback,
                    (XtCallbackProc)set_cmdScaleInt, &SC_tag[cmdpanel][i] );
      XtAddCallback( subw_id1[i], XmNdragCallback,
                    (XtCallbackProc)set_cmdScaleInt, &SC_tag[cmdpanel][i] );
#if OLD_TAB
      XmAddTabGroup( subw_id2[i] );
      XtOverrideTranslations( subw_id2[i],
                     XtParseTranslationTable( "<Key>Down:next-tab-group()" ) );
      XmAddTabGroup( subw_id1[i] );
      XtOverrideTranslations( subw_id1[i],
          XtParseTranslationTable( "<Key>Down:ManagerGadgetNextTabGroup()" ) );
#endif

      break ;


    case SCALR_PAR: /* Scale widget for real value + toggle + text */

      /* real scale */
      rlow = atof( preal->slider_lower );
      rhigh = atof( preal->slider_upper );
      /* get value to take for decimal attribute in scale */
      if( instring[0] == '\0' )
        rval = rlow;
      else
        rval = atof( instring );
      for( decimal = 0; decimal < preal->decimals; decimal++ ) {
        rval  *= 10;
        rlow  *= 10;
        rhigh *= 10;
      }
      rval  += (rval  > 0) ? 0.5 : -0.5;
      rlow  += (rlow  > 0) ? 0.5 : -0.5;
      rhigh += (rhigh > 0) ? 0.5 : -0.5;
      sprintf( cnam, "cmdScale%d", i + 1 );
      subw_id1[i] = XtVaCreateManagedWidget( cnam,
                        xmScaleWidgetClass, subw_form[i],
                        XmNrightPosition, 60,
                        XmNrightAttachment, XmATTACH_POSITION,
                        XmNtopOffset, 0,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNleftOffset, 0,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNbottomOffset, 0,
                        XmNbottomAttachment, XmATTACH_FORM,
                        RES_CONVERT( XmNtitleString, prstring ),
                        XmNshowValue, TRUE,
                        XmNorientation, XmHORIZONTAL,
                        XmNvalue, (int)rval,
                        XmNminimum, (int)rlow,
                        XmNmaximum, (int)rhigh,
                        XmNdecimalPoints, decimal,
                        XmNnavigationType, XmEXCLUSIVE_TAB_GROUP,
                        NULL );

      /* toggle button */
      sprintf( cnam, "cmdScaleToggle%d", i + 1 );
      subw_id3[i] = XtVaCreateManagedWidget( cnam,
                        xmToggleButtonGadgetClass, subw_form[i],
                        RES_CONVERT( XmNlabelString, "" ),
                        XmNtopOffset, 0,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNleftWidget, subw_id1[i],
                        XmNleftAttachment, XmATTACH_WIDGET,
                        XmNbottomOffset, 0,
                        XmNbottomAttachment, XmATTACH_FORM,
                        XmNnavigationType, XmEXCLUSIVE_TAB_GROUP,
                        NULL );

      /* text window */
      sprintf (cnam, "cmdText%d",i+1);
      subw_id2[i] = XtVaCreateManagedWidget( cnam,
                        xmTextWidgetClass, subw_form[i],
                        XmNleftWidget, subw_id3[i],
                        XmNleftAttachment, XmATTACH_WIDGET,
                        XmNtopOffset, 15,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNrightOffset, 0,
                        XmNrightAttachment, XmATTACH_FORM,
                        XmNbottomOffset, 15,
                        XmNbottomAttachment, XmATTACH_FORM,
                        XmNvalue, instring,
                        XmNnavigationType, XmEXCLUSIVE_TAB_GROUP,
                        NULL );

      /* Add Callbacks on scale */
      SC_tag[cmdpanel][i].command_panel = kuipCommandPanel;
      SC_tag[cmdpanel][i].cmd = cmd;
      SC_tag[cmdpanel][i].index = i;
      XtAddCallback( subw_id1[i], XmNvalueChangedCallback,
                    (XtCallbackProc)set_cmdScaleReal, &SC_tag[cmdpanel][i]);
      XtAddCallback( subw_id1[i], XmNdragCallback,
                    (XtCallbackProc)set_cmdScaleReal, &SC_tag[cmdpanel][i]);

#if OLD_TAB
      XmAddTabGroup( subw_id2[i] );
      XtOverrideTranslations( subw_id2[i],
                     XtParseTranslationTable( "<Key>Down:next-tab-group()" ) );
      XmAddTabGroup( subw_id1[i] );
      XtOverrideTranslations( subw_id1[i],
          XtParseTranslationTable( "<Key>Down:ManagerGadgetNextTabGroup()" ) );
#endif

      break ;


    case OPT_PAR: /* option menu + small text window */

      /* text window */
      sprintf (cnam, "cmdText%d",i+1);
      subw_id2[i] = XtVaCreateManagedWidget( cnam,
                        xmTextWidgetClass, subw_form[i],
                        XmNtopOffset, 5,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNrightOffset, 0,
                        XmNrightAttachment, XmATTACH_FORM,
                        XmNbottomOffset, 5,
                        XmNbottomAttachment, XmATTACH_FORM,
                        XmNnavigationType, XmEXCLUSIVE_TAB_GROUP,
                        XmNvalue, instring,
                        NULL );

      /* option menu */
      opt_menu = XtVaCreatePopupShell ("opt_menu",
                        xmMenuShellWidgetClass, subw_form[i],
                        XmNwidth, 1,
                        XmNheight, 1,
                        XmNallowShellResize, TRUE,
                        XmNoverrideRedirect, TRUE,
                        NULL );
      sprintf( cnam, "cmdPMenu%d", i + 1 );
      opt_menu_b[0] = XtVaCreateWidget( cnam,
                        xmRowColumnWidgetClass, opt_menu,
                        XmNrowColumnType, XmMENU_PULLDOWN,
                        NULL );
      /* create push-buttons of the option menu */
      opt_menu_bhis = NULL;
      for( j = 0; j < par->range_count; j++ ) {
        char stext[MAX_stringl];

        if (j > MAX_opt) {
           static int ifirst = 0;

           if (ifirst == 0) {
           char cval[MAX_string];

           ifirst = 1;
           sprintf (cval,
"This is just a warning: \n \
______________________\n\n \
(N.B. display only once ...)\n\n \
Maximum number of options \n \
in an OPT parameter is : %d.\n \n \
Try to contact the application programmer,\n\
who should correct this problem.\n", MAX_opt);
           km_warn_user(km_toplevel, cval, "");
           } /* end ...(ifirst == 0) */
           break;
        }
        strcpy (stext, par->range_value[j]);

        sprintf( cnam1, "%s_b%d", cnam, j + 1 );
        opt_menu_b[j+1] = XtVaCreateManagedWidget( cnam1,
                        xmPushButtonGadgetClass, opt_menu_b[0],
                        RES_CONVERT( XmNlabelString, stext ),
                        NULL );

        /* get default push button if any */
        if( instring != NULL && par->range_value[j] != NULL) {
          char *tmp1 = km_strip( par->range_value[j] );
          char *tmp2 = km_strip( instring );

          if(  strcmp( tmp1, tmp2 ) == 0 ) {
            opt_menu_bhis = opt_menu_b[j+1];
          }
          free (tmp1);
          free (tmp2);
        } /* end ... if( instring != NULL ...) */
        /* Add Callbacks to each button */
        OP_tag[cmdpanel][i][j].command_panel = kuipCommandPanel;
        OP_tag[cmdpanel][i][j].index = i;
        OP_tag[cmdpanel][i][j].opt_val = XtMalloc( MAX_string );
        if( par->range_value[j] != NULL )
          strcpy( OP_tag[cmdpanel][i][j].opt_val, par->range_value[j]);
        else
          strcpy( OP_tag[cmdpanel][i][j].opt_val, " " );
        XtAddCallback( opt_menu_b[j+1], XmNactivateCallback,
                      (XtCallbackProc)set_cmdOpt, &OP_tag[cmdpanel][i][j] );
      } /* end ... for( j = 0; j < par->range_count; j++ ) */
      /* create option menu widget */
      sprintf( cnam, "cmdOption%d", i + 1 );
      strcat( prstring, " > " );
      if( opt_menu_bhis != NULL ) {
          subw_id1[i] = XtVaCreateManagedWidget( cnam,
                        xmRowColumnWidgetClass, subw_form[i],
                        XmNmarginHeight, 5,
                        XmNtopOffset, 0,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNleftOffset, 0,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNbottomOffset, 0,
                        XmNbottomAttachment, XmATTACH_FORM,
                        RES_CONVERT( XmNlabelString, prstring ),
                        XmNsubMenuId, opt_menu_b[0],
                        XmNrowColumnType, XmMENU_OPTION,
                        XmNmenuHistory, opt_menu_bhis,
                        XmNnavigationType, XmEXCLUSIVE_TAB_GROUP,
                        NULL );
      } else {
          subw_id1[i] = XtVaCreateManagedWidget( cnam,
                        xmRowColumnWidgetClass, subw_form[i],
                        XmNmarginHeight, 5,
                        XmNtopOffset, 0,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNleftOffset, 0,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNbottomOffset, 0,
                        XmNbottomAttachment, XmATTACH_FORM,
                        RES_CONVERT( XmNlabelString, prstring ),
                        XmNsubMenuId, opt_menu_b[0],
                        XmNrowColumnType, XmMENU_OPTION,
                        XmNnavigationType, XmEXCLUSIVE_TAB_GROUP,
                        NULL );
      } /* end ... if( idbhis != NULL ) */

      /* Button "List" */
      sprintf (cnam, "optList%d",i+1);
      subw_id3[i] = XtVaCreateManagedWidget( cnam,
                        xmPushButtonGadgetClass, subw_form[i],
                        XmNtopOffset, 5,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNheight, 30,
                        XmNleftWidget, subw_id1[i],
                        XmNleftOffset, 5,
                        XmNleftAttachment, XmATTACH_WIDGET,
                        RES_CONVERT( XmNlabelString, " List " ),
                        XmNbottomOffset, 5,
                        XmNbottomAttachment, XmATTACH_FORM,
                        NULL );
      SC_tag[cmdpanel][i].command_panel = kuipCommandPanel;
      SC_tag[cmdpanel][i].cmd = cmd;
      SC_tag[cmdpanel][i].index = i;
      XtAddCallback( subw_id3[i], XmNactivateCallback,
                    (XtCallbackProc)set_optList, &SC_tag[cmdpanel][i] );


      /* Set left attachement to "List" button for command-text */
      XtVaSetValues( subw_id2[i], XmNleftAttachment, XmATTACH_WIDGET,
                                  XmNleftOffset, 5,
                                  XmNleftWidget, subw_id3[i],
                                  NULL );

#if OLD_TAB
      XmAddTabGroup( subw_id2[i] );
      XtOverrideTranslations( subw_id2[i],
                     XtParseTranslationTable( "<Key>Down:next-tab-group()" ) );
      XmAddTabGroup( subw_id1[i] );
      XtOverrideTranslations( subw_id1[i],
          XtParseTranslationTable( "<Key>Down:ManagerGadgetNextTabGroup()" ) );
#endif

      break ;

    } /* end ... switch( pcode[i] ) */

  } /* end ... for( i = 0; i < cmd->total; i++ ) */

  } /* end ... if( cmd->total == 0 ) */

  /* Layout with label "Command Parameters" */
  kuipCommand_title = XtVaCreateManagedWidget( "kuipCommand_title",
                        xmLabelGadgetClass, kuipCommandPanel,
                        XmNtopOffset, 0,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNmarginWidth, 0,
                        XmNrecomputeSize, TRUE,
                        RES_CONVERT( XmNlabelString, " Command Parameters " ),
                        XmNheight, 20,
                        XmNy, 0,
                        XmNx, 10,
                        NULL );

  XtVaCreateManagedWidget( "UpperLeftSep",
                        xmSeparatorGadgetClass, kuipCommandPanel,
                        XmNtopOffset, 10,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNrightWidget, kuipCommand_title,
                        XmNrightOffset, 0,
                        XmNrightAttachment, XmATTACH_WIDGET,
                        XmNleftOffset, 10,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNheight, 2,
                        NULL );

  XtVaCreateManagedWidget( "UpperRightSep",
                        xmSeparatorGadgetClass, kuipCommandPanel,
                        XmNtopOffset, 10,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNrightOffset, 10,
                        XmNrightAttachment, XmATTACH_FORM,
                        XmNleftWidget, kuipCommand_title,
                        XmNleftOffset, 0,
                        XmNleftAttachment, XmATTACH_WIDGET,
                        XmNheight, 2,
                        NULL );

  if (do_scale)
  BottomSep = XtVaCreateManagedWidget( "BottomSep",
                        xmSeparatorGadgetClass, kuipCommandPanel,
                        XmNrightOffset, 10,
                        XmNrightAttachment, XmATTACH_FORM,
                        XmNleftOffset, 10,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNbottomAttachment, XmATTACH_WIDGET,
                        XmNbottomWidget, ScaleOpt_form,
                        XmNheight, 2,
                        NULL );
  else
  BottomSep = XtVaCreateManagedWidget( "BottomSep",
                        xmSeparatorGadgetClass, kuipCommandPanel,
                        XmNrightOffset, 10,
                        XmNrightAttachment, XmATTACH_FORM,
                        XmNleftOffset, 10,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNbottomAttachment, XmATTACH_WIDGET,
                        XmNbottomWidget, commandSep,
                        XmNheight, 2,
                        NULL );
  XtVaSetValues ( parentCommandForm, XmNbottomWidget, BottomSep,
                                     XmNbottomOffset, 10, NULL );

  if (do_scale)
  XtVaCreateManagedWidget( "LeftSep",
                        xmSeparatorGadgetClass, kuipCommandPanel,
                        XmNwidth, 2,
                        XmNtopOffset, 11,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNleftOffset, 10,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNbottomAttachment, XmATTACH_WIDGET,
                        XmNbottomWidget, ScaleOpt_form,
                        XmNorientation, XmVERTICAL,
                        NULL );
  else
  XtVaCreateManagedWidget( "LeftSep",
                        xmSeparatorGadgetClass, kuipCommandPanel,
                        XmNwidth, 2,
                        XmNtopOffset, 11,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNleftOffset, 10,
                        XmNleftAttachment, XmATTACH_FORM,
                        XmNbottomAttachment, XmATTACH_WIDGET,
                        XmNbottomWidget, commandSep,
                        XmNorientation, XmVERTICAL,
                        NULL );


  if (do_scale)
  XtVaCreateManagedWidget( "RightSep",
                        xmSeparatorGadgetClass, kuipCommandPanel,
                        XmNwidth, 2,
                        XmNtopOffset, 11,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNrightOffset, 10,
                        XmNrightAttachment, XmATTACH_FORM,
                        XmNbottomAttachment, XmATTACH_WIDGET,
                        XmNbottomWidget, ScaleOpt_form,
                        XmNorientation, XmVERTICAL,
                        NULL );
  else
  XtVaCreateManagedWidget( "RightSep",
                        xmSeparatorGadgetClass, kuipCommandPanel,
                        XmNwidth, 2,
                        XmNtopOffset, 11,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNrightOffset, 10,
                        XmNrightAttachment, XmATTACH_FORM,
                        XmNbottomAttachment, XmATTACH_WIDGET,
                        XmNbottomWidget, commandSep,
                        XmNorientation, XmVERTICAL,
                        NULL );


  /* Set default button (for CR) */
  if( do_exec )
      XtVaSetValues( kuipCommandPanel, XmNdefaultButton, km_cmdOK, NULL );


  /* Set button sensitivity */
  if( flag == 1) {
    XtSetSensitive( km_cmdEX, False );
    XtSetSensitive( km_cmdRE, False );
    XtSetSensitive( km_cmdHE, False );
  }


  /*
   *   install callbacks on command panel buttons
   */
  grab = 0;
  XtAddCallback( km_cmdOK, XmNactivateCallback,
                (XtCallbackProc)okCPCallback, &CP_tag[cmdpanel] );
  XtAddCallback( km_cmdOK, XmNactivateCallback,
                (XtCallbackProc)reset_grab, &grab );
  XtAddCallback( km_cmdEX, XmNactivateCallback,
                (XtCallbackProc)executeCPCallback, &CP_tag[cmdpanel] );
  XtAddCallback( km_cmdRE, XmNactivateCallback,
                (XtCallbackProc)resetCPCallback, &CP_tag[cmdpanel] );
  XtAddCallback( km_cmdCA, XmNactivateCallback,
                (XtCallbackProc)cancelCPCallback, &CP_tag[cmdpanel] );
  XtAddCallback( km_cmdCA, XmNactivateCallback,
                (XtCallbackProc)reset_grab, &grab );
  XtAddCallback( km_cmdHE, XmNactivateCallback,
                (XtCallbackProc)helpCPCallback, &CP_tag[cmdpanel] );

#if 0
  XtAddEventHandler(kuipCommandPanel, FocusChangeMask, False,
                      (XtEventHandler)focus_cmdpan, NULL);
#endif

  km_MwmCloseCallback( XtParent( kuipCommandPanel ),
                      (XtCallbackProc)cancelCPCallback,
                      (XtPointer)&CP_tag[cmdpanel] );


  /* Set position and title */
  sprintf( title, "%s Command %s", class_name, cmd->path );
  XtVaSetValues(XtParent(kuipCommandPanel),
                XmNtitle, title,
                XmNkeyboardFocusPolicy, XmEXPLICIT,
                NULL);
  if (srec.center_command == 0)
      XtVaSetValues(XtParent(kuipCommandPanel),
                XmNx, km_xcur_pos, XmNy, km_ycur_pos,
                NULL);
  else if (srec.center_command == -1) /* position (0,0) */
      XtVaSetValues(XtParent(kuipCommandPanel), XmNx, 0, XmNy, 0, NULL);


  km_store_appShell (kuipCommandPanel, title);

  /* Display command panel */
  XtManageChild ( kuipCommandForm );
  XtManageChild ( parentCommandForm );
  UxPopupInterface( kuipCommandPanel, XtGrabNone );

  /* Reset position if it goes outside the screen */
  XtVaGetValues( XtParent( kuipCommandPanel ),
                 XmNwidth, &fw, XmNheight, &fh,
                 NULL);
  if( (int) (km_xcur_pos + fw + 5) > UxScreenWidth )
    km_xcur_pos = UxScreenWidth - fw -5;
  if( (int) (km_ycur_pos + fh + 30) > UxScreenHeight )
    km_ycur_pos = UxScreenHeight - fh - 30;
  if (srec.center_command == 0)
      XtVaSetValues(XtParent(kuipCommandPanel),
                    XmNx, km_xcur_pos, XmNy, km_ycur_pos,
                    NULL);
  else if (srec.center_command == -1) /* position (0,0) */
      XtVaSetValues(XtParent(kuipCommandPanel), XmNx, 0, XmNy, 0, NULL);


  /* Store values for get_cp_context */
  n_cmdpanel++;
  for (i = 0; i < MAX_CMD_PANEL; i++) {
     if (!Str_cmdpanel[i].widget) {
        Str_cmdpanel[i].widget     = kuipCommandPanel;
        Str_cmdpanel[i].form       = kuipCommandForm;
        Str_cmdpanel[i].swpar      = cmd->total;
        if (do_scale) Str_cmdpanel[i].scmenu   = ScaleOpt_menu;
        for (j = 0; j < cmd->total; j++) {
             Str_cmdpanel[i].swtext[j]     = subw_id2[j];
             Str_cmdpanel[i].swspecific[j]   = subw_id1[j];
             Str_cmdpanel[i].swtoggle[j]   = subw_id3[j];
        }
        break;
     }
  }



  if( flag == 1 ) {
    /* Grab interface */
    while( grab == 0 ) {
      XtAppProcessEvent( UxAppContext, XtIMAll );
      XSync( XtDisplay( kuipCommandPanel ), 0 );
    }
  }

  /*
   * CP_tag.error can be modified by OK callback (when grabbing)
   * cancel --> return NULL
   */
  return CP_tag[cmdpanel].error;
}

/***********************************************************************
 *                                                                     *
 *   Get the context for kuipCommandPanel widget.                      *
 *                                                                     *
 ***********************************************************************/
static int get_cp_context(w)
    Widget w;
{
   int           i, j;

   if (!w) return -2;

   /*
    *   find and restore the context
    *   (to get to the widgets belonging to this dialog)
    */
   UxKuipCommandPContext = (_UxCkuipCommandP *)UxGetContext( w );


   /* restore the other widgets by hand (not in Architect context) */
   for (i = 0; i < MAX_CMD_PANEL; i++) {
      if (Str_cmdpanel[i].widget == w) {
       CPWpar = Str_cmdpanel[i].swpar;
       CPWform = Str_cmdpanel[i].form;
       CPWscmenu = Str_cmdpanel[i].scmenu;
       for (j = 0; j < CPWpar; j++) {
            CPWtext[j] = Str_cmdpanel[i].swtext[j];
            CPWspecific[j] = Str_cmdpanel[i].swspecific[j];
            CPWtoggle[j] = Str_cmdpanel[i].swtoggle[j];
       }
       return i;
      }
   }
   return -1;
}


static void okCPCallback( widget, tag, data )
      Widget          widget;
      caddr_t         tag;
      XmAnyCallbackStruct   *data;
{
    CP_str *stag = (CP_str *) tag;
    KmCommand *cmd = stag->cmd;
    char *cmd_string = execute_command
                       ( stag->command_panel, stag->command_panel_form, cmd );

    destroy_panel (stag->command_panel);
    stag->command_panel = NULL;

    if (opt_list != NULL) XtDestroyWidget (XtParent(opt_list));
    opt_list = NULL;

    if (km_fil_sel != NULL) XtDestroyWidget (XtParent(km_fil_sel));
    km_fil_sel = NULL;

    ku_exec( cmd_string );
    free( cmd_string );

    /* Set flag for updating browsers */
    km_reset_allbrowser(True);
}

static void executeCPCallback( widget, stag, data )
      Widget          widget;
      CP_str          *stag;
      XmAnyCallbackStruct   *data;
{
    KmCommand *cmd = stag->cmd;
    char *cmd_string = execute_command
                       ( stag->command_panel, stag->command_panel_form, cmd );

    ku_exec( cmd_string );
    free( cmd_string );

    /* Set flag for updating browsers */
    km_reset_allbrowser(True);
}

static void resetCPCallback( widget, tag, data )
      Widget          widget;
      caddr_t         tag;
      XmAnyCallbackStruct   *data;
{
     CP_str *stag = (CP_str *) tag;
     KmCommand *cmd = stag->cmd;
     Widget cpanel = stag->command_panel;
     int irep;

     char *select[] = {
          "... last execution values",
          "... default value",
          NULL };


     irep = km_toggle_selection ("Reset to ...", select, 1);
     if (irep <= 0) return;

     XtVaGetValues( XtParent(cpanel),
                    XmNx, &km_xcur_pos, XmNy, &km_ycur_pos,
                    NULL);
     destroy_panel (stag->command_panel);
     stag->command_panel = NULL;
     if (irep == 1) {
         reset_arg_list( cmd );
         km_display_cmdpan (cmd, NULL, 0 );
     } else if (irep == 2) {
         km_display_cmdpan (cmd, NULL, 2 );
     }
}

static void cancelCPCallback( widget, tag, data )
      Widget          widget;
      caddr_t         tag;
      XmAnyCallbackStruct   *data;
{
    CP_str *stag = (CP_str *) tag;

    destroy_panel (stag->command_panel);
    stag->command_panel = NULL;
    stag->error = 1;

    if (opt_list != NULL) XtDestroyWidget (XtParent(opt_list));
    opt_list = NULL;

    if (km_fil_sel != NULL) XtDestroyWidget (XtParent(km_fil_sel));
    km_fil_sel = NULL;
}

static void helpCPCallback( widget, tag, data )
      Widget          widget;
      caddr_t         tag;
      XmAnyCallbackStruct   *data;
{
      Position xr, yr;

      CP_str *stag = (CP_str *) tag;

      char *helptext = fmt_cmd_help( stag->cmd, 0 );
      km_get_curpos (data->event,&xr,&yr);
      km_display_sctext (stag->cmd->path, helptext, xr, yr, 1);
      free( helptext );
}

/*
 *      Set scale value (integer) for "valueChanged"
 */
static void set_cmdScaleInt( widget, tag, scale )
      Widget          widget;
      caddr_t         tag;
      XmScaleCallbackStruct *scale;
{
    int scale_reason = scale->reason;
    int scale_value = scale->value;
    char     *text_data = NULL;
    char cval[MAX_string];
    Boolean do_exec;
    Widget pbhis;
    XmString string_data;

    SC_str *stag = (SC_str *) tag;
    Widget cpanel = stag->command_panel;
    KmCommand *cmd = stag->cmd;
    int npar = stag->index;

    get_cp_context ( cpanel );


/*  Get value for scale behavior : VALUE_CHANGED or DRAG                      */
    XtVaGetValues( CPWscmenu, XmNmenuHistory, &pbhis, NULL);
    XtVaGetValues( pbhis, XmNlabelString, &string_data, NULL);
    XmStringGetLtoR(string_data, km_charset, &text_data);
    XmStringFree (string_data);
    if (text_data == NULL) {
        XtFree (text_data);
        return; }
    /* If callback reason is DRAG but flag set to VALUE_CHANGED do nothing */
    if (scale_reason == XmCR_DRAG)
        if (strcmp(text_data,"VALUE_CHANGED") == 0) {
            XtFree (text_data);
            return; }

/*  Set text in small text window associated to scale                         */
    sprintf (cval, "%d", scale_value);
    XmTextSetString(CPWtext[npar], cval);

    do_exec = XmToggleButtonGetState (CPWtoggle[npar]);
    if (do_exec) {
        char *cmd_string = execute_command ( cpanel, CPWform, cmd );

        ku_exec( cmd_string );
        free( cmd_string );
        km_reset_allbrowser(True);
   }

}

/*
 *      Set scale value (real) for "valueChanged"
 */
static void set_cmdScaleReal( widget, tag, scale )
      Widget          widget;
      caddr_t         tag;
      XmScaleCallbackStruct *scale;
{
    int scale_reason = scale->reason;
    int scale_value = scale->value;
    char     *text_data = NULL;
    double scale_fvalue;
    short scale_decimal;
    Boolean do_exec;
    int k;
    Widget pbhis;
    XmString string_data;

    SC_str *stag = (SC_str *) tag;
    Widget cpanel = stag->command_panel;
    KmCommand *cmd = stag->cmd;
    int npar = stag->index;

    get_cp_context ( cpanel );


/*  Get value for scale behavior : VALUE_CHANGED or DRAG                      */
    XtVaGetValues( CPWscmenu, XmNmenuHistory, &pbhis, NULL);
    XtVaGetValues( pbhis, XmNlabelString, &string_data, NULL);
    XmStringGetLtoR(string_data, km_charset, &text_data);
    XmStringFree (string_data);
    if (text_data == NULL) {
        XtFree (text_data);
        return; }
    /* If callback reason is DRAG but flag set to VALUE_CHANGED do nothing */
    if (scale_reason == XmCR_DRAG)
        if (strcmp(text_data,"VALUE_CHANGED") == 0) {
            XtFree (text_data);
            return; }

    scale_fvalue = scale_value;

    XtVaGetValues( widget, XmNdecimalPoints, &scale_decimal, NULL);
    for (k = 0; k < scale_decimal; k++)
         scale_fvalue *= 0.1;


/*  Set text in small text window associated to scale                        */
    XmTextSetString(CPWtext[npar], strfromd( scale_fvalue, 6 ) );

    do_exec = XmToggleButtonGetState (CPWtoggle[npar]);
    if (do_exec) {
        char *cmd_string = execute_command ( cpanel, CPWform, cmd );

        ku_exec( cmd_string );
        free( cmd_string );
        km_reset_allbrowser(True);
   }
}

/*
 *      Set option value (char) for "activate"
 */
static void set_cmdOpt( widget, tag, data )
      Widget          widget;
      caddr_t         tag;
      XmAnyCallbackStruct   *data;
{
    OP_str *stag = (OP_str *) tag;
    Widget cpanel = stag->command_panel;
    int npar = stag->index;

    get_cp_context ( cpanel );

/*  Set text in small text window associated to option menu                   */
    XmTextSetString(CPWtext[npar],stag->opt_val);
}

/*
 *      Show file selection box
 */
static void set_filSel( widget, tag, data )
      Widget          widget;
      caddr_t         tag;
      XmAnyCallbackStruct   *data;
{
   SC_str *stag = (SC_str *) tag;

   Widget cpanel = stag->command_panel;
   KmCommand *cmd = stag->cmd;
   int ipar = stag->index;
   KmParameter *par   = cmd->par[ipar];
   KmParFile   *pfil  = par->ptype;

   char title[MAX_stringl];
   char *filter = NULL;
   Position xp, yp;
   Dimension wp;

   char *help = (char *) "File Selection Box : \n\
\n\
Select a file and press the \"OK\" button. \n\
\n\
You can change the \"Filter\" entry. (This \n\
can be done either by selecting a sub-directory\n\
in the list \"Directories\" or by entering\n\
a new directory path in the \"Filter\" text\n\
field. In both cases the operation is validated\n\
by pressing the button \"Filter\"). \n\
\n\
Then, you can select a new file name\n\
in that new directory (just select the \n\
correcponding item in list \"Files\") \n\
\n\
To validate your selection you have to press the \n\
\"OK\" button. By pressing \"Cancel\" you can destroy \n\
(erase from the screen) the FileSelectionBox without\n\
making any selection.";

   get_cp_context ( cpanel );

   if (km_fil_sel != NULL) XtDestroyWidget (XtParent(km_fil_sel));
   km_fil_sel = NULL;

   km_fil_sel = create_kuipFilSel (NULL);
   sprintf( title, "%s : %s >", cmd->path, par->prompt );
   XtVaSetValues ( XtParent(km_fil_sel),
                            XmNtitle, title,
                            XmNdefaultPosition, False,
                            XmNautoUnmanage, False, NULL);

   /*
    *   find and restore the context
    *   (to get to the widgets belonging to this dialog)
    */
   UxKuipFilSelContext = (_UxCkuipFilSel *)UxGetContext( km_fil_sel );

   /* set filter and directory */
   if (pfil->filter_default != NULL) {
       char *p;

       filter = strdup (pfil->filter_default);
       XtVaSetValues ( km_FilSel,
                       RES_CONVERT( XmNpattern, filter ),
                       NULL);
       p = strrchr (filter, '/');
       if (p != NULL) {
           p[1] = '\0';
           XtVaSetValues ( km_FilSel,
                       RES_CONVERT( XmNdirectory, filter ),
                       NULL);
       }
   }

   if (par->dfault != NULL) {
       Widget listw;
       XmStringTable xmstr_list;
       int nc, l;

       filter = mstrcat (filter, par->dfault);
       listw = XmSelectionBoxGetChild( km_FilSel, XmDIALOG_LIST);
       XtVaGetValues ( listw, XmNitems, &xmstr_list,
                              XmNitemCount, &nc,
                              NULL);
       for (l = 0; l< nc; l++) {
            char *item;

            XmStringGetLtoR(xmstr_list[l], km_charset, &item);
            if (strcmp (item, filter) == 0) {
                XmListSelectItem ( listw, xmstr_list[l], True);
            }
            XtFree (item);
       }
   }
   if (filter != NULL) free (filter);

   /* calculate position */
   XtVaGetValues( XtParent(cpanel), XmNx, &xp, XmNy, &yp, XmNwidth, &wp, NULL);

   if ( (int) (xp+wp+kuipFilSel_width+10) < UxScreenWidth )
       XtVaSetValues ( XtParent(km_fil_sel),
                         XmNx, xp+wp+10, XmNy, yp - WM_y, NULL);
   else
       XtVaSetValues ( XtParent(km_fil_sel),
                         XmNx, xp-kuipFilSel_width-20, XmNy, yp - WM_y, NULL);

   /* Display FileSelectionBox */
   UxPopupInterface( km_fil_sel, XtGrabNone );

   XtAddCallback( km_FilSel, XmNhelpCallback,
                  (XtCallbackProc)km_help_activate, (XtPointer)help );

   XtAddCallback( km_FilSel, XmNokCallback,
                 (XtCallbackProc)okFCallback, (XtPointer)ipar );
   XtAddCallback( km_FilSel, XmNcancelCallback,
                 (XtCallbackProc)km_clFCallback, NULL );

}

/*
 *      Show list of options
 */
static void set_optList( widget, tag, data )
      Widget          widget;
      caddr_t         tag;
      XmAnyCallbackStruct   *data;
{
   SC_str *stag = (SC_str *) tag;
   Widget cpanel = stag->command_panel;
   KmCommand *cmd = stag->cmd;
   int ipar = stag->index;
   KmParameter *par   = cmd->par[ipar];
   KmParOption *popt  = par->ptype;

   char title[MAX_stringl];
   Position xp, yp;
   Dimension wp;
   int j;

   static SC_str OL_tag;

   get_cp_context ( cpanel );


   if (opt_list != NULL) XtDestroyWidget (XtParent(opt_list));
   opt_list = NULL;

   opt_list = create_kuipOptList();
   sprintf( title, "%s : %s >", cmd->path, par->prompt );
   XtVaSetValues ( XtParent(opt_list),
                            XmNtitle, title,
                            XmNdefaultPosition, False,
                            XmNautoUnmanage, False, NULL);

   /*
    *   find and restore the context
    *   (to get to the widgets belonging to this dialog)
    */
   UxKuipOptListContext = (_UxCkuipOptList *)UxGetContext( opt_list );

   for( j = 0; j < par->range_count; j++ ) {
       XmString   xmstr;
       char *sopt = NULL;
       if( popt != NULL && popt->text[j] != NULL ) {
          if (par->range_value[j] != NULL ) {
             sopt = str3dup (par->range_value[j], " : ", popt->text[j]);
             xmstr = XmStringCreate(sopt, XmSTRING_DEFAULT_CHARSET);
          } else
             xmstr = XmStringCreate(popt->text[j], XmSTRING_DEFAULT_CHARSET);
       } else if (par->range_value[j] != NULL )
          xmstr = XmStringCreate(par->range_value[j], XmSTRING_DEFAULT_CHARSET);
       else
          xmstr = XmStringCreate(" ", XmSTRING_DEFAULT_CHARSET);
       XmListAddItem(OptList, xmstr, 0);
       XmStringFree(xmstr);
       if (sopt != NULL) free (sopt);
   } /* end for ... */

   /* calculate position */
   XtVaGetValues( XtParent(cpanel), XmNx, &xp, XmNy, &yp, XmNwidth, &wp, NULL);

   if ( (int) (xp+wp+kuipOptList_width+10) < UxScreenWidth )
       XtVaSetValues ( XtParent(opt_list),
                                XmNx, xp+wp+10, XmNy, yp - WM_y, NULL);
   else
       XtVaSetValues ( XtParent(opt_list),
                       XmNx, xp-kuipOptList_width-20, XmNy, yp - WM_y, NULL);

   /* Display list */
   UxPopupInterface( opt_list, XtGrabNone );

   OL_tag.command_panel = cpanel;
   OL_tag.swidget = OptList;
   OL_tag.cmd = cmd;
   OL_tag.index = ipar;
   XtAddCallback( OKButton, XmNactivateCallback,
                 (XtCallbackProc)okLCallback, &OL_tag );
   XtAddCallback( CCLButton, XmNactivateCallback,
                 (XtCallbackProc)clLCallback, NULL);

}

static void okFCallback( widget, tag, data )
      Widget          widget;
      int             tag;
      XmFileSelectionBoxCallbackStruct *data;
{
   int ipar = tag;
   char *file;

   /*
    *   find and restore the context
    *   (to get to the widgets belonging to this dialog)
    */
   UxKuipFilSelContext = (_UxCkuipFilSel *)UxGetContext( widget );

   XmStringGetLtoR(data->value, km_charset, &file);

   /* Set text in small text window associated to parameter file */
   XmTextSetString(CPWtext[ipar], file);

   XtFree (file);

   if (km_fil_sel != NULL) XtDestroyWidget (XtParent(km_fil_sel));
   km_fil_sel = NULL;
}

static void okLCallback( widget, tag, data )
      Widget          widget;
      caddr_t         tag;
      XmAnyCallbackStruct   *data;
{
   SC_str *ltag = (SC_str *) tag;
   Widget cpanel = ltag->command_panel;
   Widget list = ltag->swidget;
   KmCommand *cmd = ltag->cmd;
   int ipar = ltag->index;
   KmParameter *par   = cmd->par[ipar];

   char *cval;
   int *pos;
   int i;

   int npos = 0;

   get_cp_context ( cpanel );

   cval = strdup("");
   XmListGetSelectedPos (list , &pos, &npos);
   for (i = 0; i < npos; i++) {
       int j = pos[i] - 1;
       if (par->range_value[j] != NULL )
           cval = mstrcat (cval, par->range_value[j]);
   }

   /* Set text in small text window associated to option menu */
   XmTextSetString(CPWtext[ipar], cval);

   if (opt_list != NULL) XtDestroyWidget (XtParent(opt_list));
   opt_list = NULL;
}


void km_clFCallback( widget, tag, data )
      Widget          widget;
      caddr_t         tag;
      XmAnyCallbackStruct   *data;
{
   if (km_fil_sel != NULL) XtDestroyWidget (XtParent(km_fil_sel));
   km_fil_sel = NULL;
}

static void clLCallback( widget, tag, data )
      Widget          widget;
      caddr_t         tag;
      XmAnyCallbackStruct   *data;
{
   if (opt_list != NULL) XtDestroyWidget (XtParent(opt_list));
   opt_list = NULL;
}

/*
 *      Reset grab flag
 */
static void reset_grab( widget, grab, data )
      Widget          widget;
      int             *grab;
      XmAnyCallbackStruct   *data;
{
      *grab = 1;
}

static char *execute_command (panel, panel_form, cmd)
    Widget panel, panel_form;
    KmCommand *cmd;
{
    Cardinal numc, snumc;
    WidgetList child, schild;
    Boolean last = False;
    int i, j, ilen = 0;

    char *cmd_string = strdup( cmd->path );
    int argc = 0;


   /*
    *   find and restore the context
    *   (to get to the widgets belonging to this dialog)
    */
    get_cp_context ( panel );


    /* Get all children from Form widget (container for all parameters) */
    XtVaGetValues( panel_form, XmNnumChildren, &numc,
                               XmNchildren,&child,
                               NULL);

    /* Get values of all sub-form widgets subwForm */
    for (i = 0; i < numc; i++) {
        Widget sform = child[i];
        String sform_name = XtName (sform);

        if (sform_name != NULL && strncmp(sform_name, "subwForm", 8) == 0) {

           /* Get all children from sub-form (container for 1 parameter) */
           XtVaGetValues( sform, XmNnumChildren, &snumc,
                                 XmNchildren,&schild,
                                 NULL);
           /* Get values of text widget cmdText (1 for each parameter) */
           for (j = 0; j < snumc; j++) {
                String name = XtName (schild[j]);

                if (name != NULL && strncmp(name, "cmdText", 7) == 0) {
                   char *text_data = strtrim( XmTextGetString (schild[j]) );

                   argc++;
                   /* if( text_data[0] == '\0' && argc <= cmd->mandatory ) { */
                   if( text_data[0] == '\0' ) {
                       /* if empty string inside command replace it by ' ' */
                       if (!last) {
                           last = True;
                           ilen = strlen(cmd_string);
                       }
                       cmd_string = mstrcat( cmd_string, " ' '" );
                   } else if( cmd->par[argc-1]->flags & KmFLAG_SEPARATE ) {
                       cmd_string = mstr2cat( cmd_string, " ", text_data );
                   } else {
                       char *p = strdup( text_data );
                       char *s = quote_string( p, 1 );
                       last = False;
                       cmd_string = mstr2cat( cmd_string, " ", s );
                       /* cmd_string = mstr2cat( cmd_string, " ", p ); */
                       /* free( s ); */
                   }
                   XtFree (text_data);
                } /* end ... if (name != NULL && strncmp... */

           } /* end ... for (j = 0; j < snumc; j++) */

        } /* end ... if (sform_name != NULL && strncmp...) */

    } /* end ... for (i = 0; i < numc; i++) */

    if (last && ilen > 0) cmd_string[ilen] = '\0';
    return cmd_string;
}


static void destroy_panel (panel)
      Widget          panel;
{
  int i;

  UxDestroyInterface (panel);
  km_reset_appShell (panel);

  n_cmdpanel--;
  for (i = 0; i < MAX_CMD_PANEL; i++) {
     if (Str_cmdpanel[i].widget == panel) {
        Str_cmdpanel[i].widget     = (Widget) NULL;
        Str_cmdpanel[i].form       = (Widget) NULL;
        Str_cmdpanel[i].swpar      = 0;
        Str_cmdpanel[i].scmenu     = (Widget) NULL;
        break;
     }
  }
}

#if 0
static void focus_cmdpan(widget, tag, ev)
      Widget widget;
      caddr_t tag;
      XEnterWindowEvent *ev;
{
    char *new_geometry;
    Position xpos, ypos;
    Dimension dh, dw;
    int ih, iw, ix, iy;

    static int ifirst = 0;

    if (ifirst == 0) {
        /* First time only we get WM decoration size */
        ifirst = 1;
        XtVaGetValues(XtParent(widget), XmNgeometry, &new_geometry,
                                        XmNx, &xpos, XmNy, &ypos,
                                        XmNheight, &dh, XmNwidth, &dw,
                                        NULL);
        sscanf (new_geometry, "%dx%d+%d+%d", &iw, &ih, &ix, &iy);
        WM_x = xpos - ix;
        WM_y = ypos - iy;
    }
}
#endif
