/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifdef BL_LANG_FORT
#  define FORT_RHSHG       rhshg
#  define FORT_RESIDUAL    reshg
#  define FORT_RELAX       relax
#  define FORT_GRADHG      gradhg
#  define FORT_INITSIG     initsigb
#  define FORT_MKCOEFF     mkcoeff
#  define FORT_COARSIG     coarsigb
#  define FORT_RESTRICT    coarsresb
#  define FORT_INTERP      interphg
#  define FORT_PROJUHG     projuhg
#  define FORT_PROJHGD     projhgd
#  define FORT_SOLVEHG     solvehg
#  define FORT_MAKESUM     makesum
#else
#if defined (BL_FORT_USE_UNDERSCORE)
#  define FORT_RHSHG       rhshg_
#  define FORT_RESIDUAL    reshg_
#  define FORT_RELAX       relax_
#  define FORT_GRADHG      gradhg_
#  define FORT_INITSIG     initsigb_
#  define FORT_MKCOEFF     mkcoeff_
#  define FORT_COARSIG     coarsigb_
#  define FORT_RESTRICT    coarsresb_
#  define FORT_INTERP      interphg_
#  define FORT_PROJUHG     projuhg_
#  define FORT_PROJHGD     projhgd_
#  define FORT_SOLVEHG     solvehg_
#  define FORT_MAKESUM     makesum_
#elif defined(BL_FORT_USE_UPPERCASE)
#  define FORT_RHSHG       RHSHG
#  define FORT_RESIDUAL    RESHG
#  define FORT_RELAX       RELAX
#  define FORT_GRADHG      GRADHG
#  define FORT_INITSIG     INITSIGB
#  define FORT_MKCOEFF     MKCOEFF
#  define FORT_COARSIG     COARSIGB
#  define FORT_RESTRICT    COARSRESB
#  define FORT_INTERP      INTERPHG
#  define FORT_PROJUHG     PROJUHG
#  define FORT_PROJHGD     PROJHGD
#  define FORT_SOLVEHG     SOLVEHG
#  define FORT_MAKESUM     MAKESUM
#elif defined(BL_FORT_USE_LOWERCASE)
#  define FORT_RHSHG       rhshg
#  define FORT_RESIDUAL    reshg
#  define FORT_RELAX       relax
#  define FORT_GRADHG      gradhg
#  define FORT_INITSIG     initsigb
#  define FORT_MKCOEFF     mkcoeff
#  define FORT_COARSIG     coarsigb
#  define FORT_RESTRICT    coarsresb
#  define FORT_INTERP      interphg
#  define FORT_PROJUHG     projuhg
#  define FORT_PROJHGD     projhgd
#  define FORT_SOLVEHG     solvehg
#  define FORT_MAKESUM     makesum
#endif

extern "C" {

  void FORT_INITSIG(Real * sigma, Real * rho, 
                    const int& lo_1, const int& lo_2, const int& lo_3,
                    const int& hi_1, const int& hi_2, const int& hi_3,
		    int * bcx_lo, int * bcx_hi,
		    int * bcy_lo, int * bcy_hi,
		    int * bcz_lo, int * bcz_hi);

  void FORT_MKCOEFF(Real * coeff, Real * sigma, 
                    const int& lo_1, const int& lo_2, const int& lo_3,
                    const int& hi_1, const int& hi_2, const int& hi_3);

  void FORT_RHSHG(Real * source, Real * state, Real * divu_src,
                  const int& lo_1, const int& lo_2, const int& lo_3,
                  const int& hi_1, const int& hi_2, const int& hi_3,
                  Real * _hx, Real * _hy, Real * _hz,
		  int * bcx_lo, int * bcx_hi,
		  int * bcy_lo, int * bcy_hi,
		  int * bcz_lo, int * bcz_hi,
                  Real * rhsnorm, Real * time, Real * dt,  
                  Real * utemp1, Real * utemp2);

  void FORT_GRADHG(Real * gradp, 
                   const int& glo_1, const int& glo_2, const int& glo_3,
                   const int& ghi_1, const int& ghi_2, const int& ghi_3,
                   Real * pressure, 
                   const int& plo_1, const int& plo_2, const int& plo_3,
                   const int& phi_1, const int& phi_2, const int& phi_3,
                   const int& lo_1, const int& lo_2, const int& lo_3,
                   const int& hi_1, const int& hi_2, const int& hi_3,
                   Real * _hx, Real * _hy, Real * _hz,
		   int * bcx_lo, int* bcx_hi, int* bcy_lo, int* bcy_hi,
		   int * bcz_lo, int* bcz_hi);

  void FORT_RESIDUAL(Real * resid, Real * phi, Real * source, 
                     Real * coeff, Real * dgphi,
                     const int& lo_1, const int& lo_2, const int& lo_3,
                     const int& hi_1, const int& hi_2, const int& hi_3,
		     Real * _hx, Real * _hy, Real * _hz, Real * rnorm, 
		     int * bcx_lo, int * bcx_hi,
 		     int * bcy_lo, int * bcy_hi,
 		     int * bcz_lo, int * bcz_hi);

  void FORT_RELAX(Real * phi, Real * source, 
                  Real * coeff, Real * dgphi, 
                  const int& lo_1, const int& lo_2, const int& lo_3,
                  const int& hi_1, const int& hi_2, const int& hi_3,
		  Real * _hx, Real * _hy, Real * _hz,  
		  int * bcx_lo, int * bcx_hi,
 		  int * bcy_lo, int * bcy_hi,
 		  int * bcz_lo, int * bcz_hi, int * nngsrb);

  void FORT_RESTRICT(Real * resid, Real * resid_crse, 
                     const int& lo_1, const int& lo_2, const int& lo_3,
                     const int& hi_1, const int& hi_2, const int& hi_3,
                     const int& loc_1, const int& loc_2, const int& loc_3,
                     const int& hic_1, const int& hic_2, const int& hic_3,
		     int * bcx_lo, int * bcx_hi,
 		     int * bcy_lo, int * bcy_hi,
 		     int * bcz_lo, int * bcz_hi);

  void FORT_COARSIG(Real * sigma, Real * sigmac, 
                    const int& lo_1, const int& lo_2, const int& lo_3,
                    const int& hi_1, const int& hi_2, const int& hi_3,
                    const int& loc_1, const int& loc_2, const int& loc_3,
                    const int& hic_1, const int& hic_2, const int& hic_3,
		    int * bcx_lo, int * bcx_hi,
 		    int * bcy_lo, int * bcy_hi,
 		    int * bcz_lo, int * bcz_hi);

  void FORT_INTERP(Real * temp, Real * phi_crse, 
                   const int& lo_1, const int& lo_2, const int& lo_3,
                   const int& hi_1, const int& hi_2, const int& hi_3,
                   const int& loc_1, const int& loc_2, const int& loc_3,
                   const int& hic_1, const int& hic_2, const int& hic_3);

  void FORT_PROJUHG(Real * state, Real * pressure, Real * phi, 
                    Real * gradphi, Real * rho,
                    const int& lo_1, const int& lo_2, const int& lo_3,
                    const int& hi_1, const int& hi_2, const int& hi_3);

  void FORT_SOLVEHG(Real * dest, Real * dest0, Real * source, 
                    Real * coeff, Real * sum, 
		    Real * r, Real * w, Real * z, Real * work, 
                    const int& lo_1, const int& lo_2, const int& lo_3,
                    const int& hi_1, const int& hi_2, const int& hi_3,
		    Real * _hx,  Real * _hy, Real * _hz, 
		    int * bcx_lo, int * bcx_hi,
 		    int * bcy_lo, int * bcy_hi,
 		    int * bcz_lo, int * bcz_hi, 
                    int * maxiter, Real * norm, Real * norm0);

  void FORT_MAKESUM(Real * sum, Real * coeff, 
                    const int& lo_mg_1, const int& lo_mg_2, const int& lo_mg_3,
                    const int& hi_mg_1, const int& hi_mg_2, const int& hi_mg_3,
		    Real * _hx,  Real * _hy, Real * _hz, 
		    int * bcx_lo, int * bcx_hi,
 		    int * bcy_lo, int * bcy_hi,
 		    int * bcz_lo, int * bcz_hi);
};
#endif
