/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


//
// $Id: Point.cpp,v 1.9 2002/02/19 20:39:41 vince Exp $
//

// ---------------------------------------------------------------
// Point.cpp
// ---------------------------------------------------------------
#include <cmath>

#include "Point.H"

Real scale = 1.0;


// ---------------------------------------------------------------
AmrVector::AmrVector(Real X, Real Y, Real Z)
          : x(X), y(Y), z(Z)
{
}


// ---------------------------------------------------------------
AmrVector::AmrVector(const AmrSpherePoint &S)
          : x(S.x), y(S.y), z(S.z)
{
}


// ---------------------------------------------------------------
AmrSpherePoint::AmrSpherePoint(Real X, Real Y, Real Z) {
    Real m(X * X + Y * Y + Z * Z);
    if(m == 0.0) {
      x = y = z = 0.0;
      return;
    }
    Real oneOverSqrtM(1.0 / sqrt(m));
    x = X * oneOverSqrtM;
    y = Y * oneOverSqrtM;
    z = Z * oneOverSqrtM;
}


// ---------------------------------------------------------------
AmrSpherePoint::AmrSpherePoint(const AmrVector &v) {
    Real m(v.x * v.x + v.y * v.y + v.z * v.z);
    if(m == 0.0) {
      x = y = z = 0.0;
      return;
    }
    Real oneOverSqrtM(1.0 / sqrt(m));
    x = v.x * oneOverSqrtM;
    y = v.y * oneOverSqrtM;
    z = v.z * oneOverSqrtM;
}


// ---------------------------------------------------------------
AmrVector AmrVector::applyMatrix(Real m[4][4]) {
  Real X(x * m[0][0] + m[1][0] * y + z * m[2][0]);
  Real Y(x * m[0][1] + m[1][1] * y + z * m[2][1]);
  Real Z(x * m[0][2] + m[1][2] * y + z * m[2][2]);

  return AmrVector(X, Y, Z);
}


// ---------------------------------------------------------------
AmrSpherePoint AmrSpherePoint::applyMatrix(Real m[4][4]) {
  Real X(x * m[0][0] + m[1][0] * y + z * m[2][0]);
  Real Y(x * m[0][1] + m[1][1] * y + z * m[2][1]);
  Real Z(x * m[0][2] + m[1][2] * y + z * m[2][2]);

  return AmrSpherePoint(X, Y, Z);
}
// ---------------------------------------------------------------
// ---------------------------------------------------------------
