/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifndef _SLABSTAT_F_H_
#define _SLABSTAT_F_H_

/*
** $Id: SLABSTAT_F.H,v 1.3 2002/04/26 22:10:02 lijewski Exp $
*/

#ifdef BL_LANG_FORT
#    define FORT_REYNAVG_FIRST4MOMS    reynavg_first4moms
#    define FORT_FAVREAVG_FIRST4MOMS   favreavg_first4moms
#else
#  ifdef BL_FORT_USE_UPPERCASE
#    define FORT_REYNAVG_FIRST4MOMS    REYNAVG_FIRST4MOMS
#    define FORT_FAVREAVG_FIRST4MOMS   FAVREAVG_FIRST4MOMS
#  else
#  ifdef BL_FORT_USE_LOWERCASE
#    define FORT_REYNAVG_FIRST4MOMS    reynavg_first4moms
#    define FORT_FAVREAVG_FIRST4MOMS   favreavg_first4moms
#  else
#    define FORT_REYNAVG_FIRST4MOMS    reynavg_first4moms_
#    define FORT_FAVREAVG_FIRST4MOMS   favreavg_first4moms_
#  endif
#  endif

extern "C"
{

     void FORT_REYNAVG_FIRST4MOMS (const Real* src, 
                                     ARLIM_P(src_lo), ARLIM_P(src_hi),
                                   const int* nsrc,
                                   Real* dst, ARLIM_P(dst_lo), ARLIM_P(dst_hi),
                                   const int* ndst,
                                   const Real* dt,
                                   const Real* dx);

     void FORT_FAVREAVG_FIRST4MOMS (const Real* src, 
                                      ARLIM_P(src_lo), ARLIM_P(src_hi),
                                    const int* nsrc,
                                    Real* dst, ARLIM_P(dst_lo), ARLIM_P(dst_hi),
                                    const int* ndst,
                                    const Real* dt,
                                    const Real* dx);
}

#endif

#endif /*_SLABSTAT_F_H_*/
