/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2016 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/


#include "ComponentDC.h"

//-- CamiTK
#include <Geometry.h>
using namespace camitk;

//-- VTK
#include <vtkUnstructuredGrid.h>
#include <vtkPoints.h>

// -------------------- default constructor --------------------
ComponentDC::ComponentDC(camitk::Component *parent, PMManagerDC * pmManagerDC, ::Component *c) : MeshComponent(parent, NULL, "default PML component") {
    myPMManagerDC = pmManagerDC;
    myComponent = c;

    // set up Qt properties
    Properties *componentProp = c->getProperties();

    std::string propName;

    for (unsigned int i = 0; i < componentProp->numberOfFields(); i++) {
        propName = componentProp->getField(i);

        if (propName != "") {
            setProperty(propName.c_str(), QVariant(componentProp->getString(propName).c_str()));
        }
    }

}

// -------------------- setOpacity --------------------
void ComponentDC::setOpacity(const double a) {
    if (myGeometry)
        myGeometry->setOpacity(a);

    foreach(camitk::Component *dc, childrenComponent) {
        dc->setOpacity(a);
    }
}

// -------------------- getEnhancedModes --------------------
const InterfaceGeometry::EnhancedModes ComponentDC::getEnhancedModes() const {
    InterfaceGeometry::EnhancedModes mode = Normal;
    int i = 0;

    // get the default enhanced mode
    if (myGeometry) {
        mode = myGeometry->getEnhancedModes();
    } else {
        if (childrenComponent.size()>0) {
            mode = childrenComponent[i]->getEnhancedModes();
            i++;
        }
    }

    bool allTheSame = true;
    while (i<childrenComponent.size() && allTheSame) {
        allTheSame = allTheSame && (childrenComponent[i]->getEnhancedModes() == mode);
        i++;
    }

    if (allTheSame)
        return mode;
    else
        return Normal;
}

// -------------------- getRenderingModes --------------------
const InterfaceGeometry::RenderingModes ComponentDC::getRenderingModes() const {
    InterfaceGeometry::RenderingModes mode = None;
    int i = 0;

    // get the default enhanced mode
    if (myGeometry) {
        mode = myGeometry->getRenderingModes();
    } else {
        if (childrenComponent.size()>0) {
            mode = childrenComponent[i]->getRenderingModes();
            i++;
        }
    }

    bool allTheSame = true;
    while (i<childrenComponent.size() && allTheSame) {
        allTheSame = allTheSame && (childrenComponent[i]->getRenderingModes() == mode);
        i++;
    }

    if (allTheSame)
        return mode;
    else
        return None;
}


// -------------------- createPointData --------------------
void ComponentDC::createPointData() {
    foreach(camitk::Component *dc, childrenComponent) {
        // test validity
        if (dc->isInstanceOf("MultiComponentDC") || dc->isInstanceOf("StructuralComponentDC") || dc->isInstanceOf("CellDC")) {
            dynamic_cast<ComponentDC *>(dc)->createPointData();
        }
    }
}

// -------------------- destroyPointData --------------------
void ComponentDC::destroyPointData() {
    foreach(camitk::Component *dc, childrenComponent) {
        // test validity
        if (dc->isInstanceOf("MultiComponentDC") || dc->isInstanceOf("StructuralComponentDC") || dc->isInstanceOf("CellDC")) {
            dynamic_cast<ComponentDC *>(dc)->destroyPointData();
        }
    }
}

// -------------------- updateProperty --------------------
void ComponentDC::updateProperty(QString name, QVariant value) {
    // modify existing properties
    Properties *componentProp = myComponent->getProperties();

    if (componentProp->isAField(name.toStdString()))
        // set the corresponding property (field)
        componentProp->set(name.toStdString(), value.toString().toStdString());
    else
        // this was not a property, check inherited class
        Component::updateProperty(name, value);
}

// -------------------- getPointSet --------------------
vtkSmartPointer< vtkPointSet > ComponentDC::getPointSet() {
    vtkSmartPointer<vtkPointSet> firstNonNullPointSet = NULL;
    unsigned int i=0;

    while(i<getChildren().size() && firstNonNullPointSet==NULL) {
        firstNonNullPointSet = getChildren().at(i)->getPointSet();
        i++;
    }

    return firstNonNullPointSet;
}
