

#include "SimulationDialog.h"

#include <QString>
#include <QMessageBox>
#include <QTextStream>
#include <Application.h>
#include <QFrame>
#include <MonitoringDialog.h>
#include <MonitoringGuiManager.h>
#include <Log.h>


using namespace camitk;


// --------------- Constructor -------------------
SimulationDialog::SimulationDialog(ActionExtension * extension) : Action(extension) {
    // Setting name, description and input component
    setName("Simulation Dialog");
    setDescription("Show MML Simulation Dialog");
    setComponent("MMLComponent");

    // Setting classification family and tags
    setFamily("Modeling");
}

// --------------- destructor -------------------
SimulationDialog::~SimulationDialog() {
}

// --------------- getWidget -------------------
QWidget* SimulationDialog::getWidget() {
    MMLComponent * input = dynamic_cast<MMLComponent *> (getTargets().last());
    QWidget * myWidget = NULL;

    if( input ) {
        myWidget = input->getMonitoringGuiManager()->getDialog();
        // show the widget
        myWidget->show();
    } else {
        CAMITK_ERROR("SimulationDialog", "getWidget", "MMLComponent not valid: no simulation tab can be shown");
    }


    return myWidget;
}

// --------------- apply -------------------
Action::ApplyStatus SimulationDialog::apply() {
    return SUCCESS;
}


