//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Import/RealDataMaskWidget.h
//! @brief     Defines class RealDataMaskWidget
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_IMPORT_REALDATAMASKWIDGET_H
#define BORNAGAIN_GUI_VIEW_IMPORT_REALDATAMASKWIDGET_H

#include "GUI/View/Common/DataAccessWidget.h"

class MaskEditorActions;
class MaskEditorCanvas;
class MaskEditorPropertyPanel;
class MaskEditorToolbar;

//! Mask editing for RealItem on ImportDataView.

class RealDataMaskWidget : public DataAccessWidget {
    Q_OBJECT
public:
    RealDataMaskWidget(QWidget* parent = nullptr);

    void setJobOrRealItem(QObject* job_or_real_item) override;

    QList<QAction*> actionList() override;

private:
    void setContext();
    void resetContext();
    void showEvent(QShowEvent*) override;
    void hideEvent(QHideEvent*) override;

    void setup_connections();
    void onPropertyPanelRequest();

    MaskEditorActions* m_editorActions;
    MaskEditorToolbar* m_toolbar;
    MaskEditorPropertyPanel* m_editorPropertyPanel;
    MaskEditorCanvas* m_editorCanvas;
};

#endif // BORNAGAIN_GUI_VIEW_IMPORT_REALDATAMASKWIDGET_H
