//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Import/ImportDataView.h
//! @brief     Defines class ImportDataView
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_IMPORT_IMPORTDATAVIEW_H
#define BORNAGAIN_GUI_VIEW_IMPORT_IMPORTDATAVIEW_H

#include "GUI/View/Import/RealDataPresenter.h"
#include "GUI/View/Item/ItemStackPresenter.h"

class RealDataSelectorWidget;
class ProjectDocument;

//! The ImportDataView class is a main view for importing experimental data.

class ImportDataView : public QWidget {
    Q_OBJECT

public:
    ImportDataView(QWidget* parent, ProjectDocument* document);

public slots:
    void onSelectionChanged(RealItem* realItem);

private:
    //! Show/hide UI elements according to settings in current project
    void updateFunctionalityNarrowing();

    RealDataSelectorWidget* m_selectorWidget;
    ItemStackPresenter<RealDataPresenter>* m_stackedWidget;
    ProjectDocument* m_document;
};

#endif // BORNAGAIN_GUI_VIEW_IMPORT_IMPORTDATAVIEW_H
