#define XERR "memorybuf"
#include "memorybuf.ih"

// overrides
ios::pos_type MemoryBuf::seekoff(
                ios::off_type step, ios::seekdir way, ios::openmode mode)
{
    off_type offset;

    switch (way)
    {
        default:                        // ios::beg: buffOffset is step
            offset = step;
        break;

        case ios::cur:
            switch (d_last)
            {
                                        // default: case SEEK
                default:                // no read/write used so far
                    offset = d_bridge.offset();
                break;                  // add step to bufOffset (below)

                case READ:              // setg was used, set bufOffset to
                                        // the abs offset of gptr()
                    offset = d_bridge.blockBegin() + gptr() - eback();
                break;

                case WRITE:             // setp was used, set bufOffset to
                                        // the abs offset of pptr()
                    offset =  d_bridge.blockBegin() + pptr() - pbase();
                    d_bridge.writtenUntil(offset);
                break;
            }

            offset += step;          // add the step
        break;

        case ios::end:                  // shift from the last write position
            offset = d_bridge.writtenUntil() + step;  
        break;
    }

    if (offset < 0)
        offset = 0;                     // offset always >= 0

    d_last = SEEK;

    noBuffers();

    d_bridge.offset(offset);
    return offset;                      // the updated offset
}


