# THIS FILE IS AUTOMATICALLY GENERATED.  EDIT THE SOURCE FILE NOT THIS ONE

"""Various descriptions of data specific to LG VX11000"""

# groups     - same as VX-8700 (added group wallpaper bit)
# phonebook  - LG Phonebook v1.0 (same as VX-8550)
# schedule   - same as VX-8550
# memos      - same as VX-8550
# sms        - same as VX-9100
# index file - same as VX-9700
# favorites  - same as VX-9600
from p_lgvx9600 import *

# SMS index files
inbox_index     = "dload/inbox.dat"
outbox_index    = "dload/outbox.dat"
drafts_index    = "dload/drafts.dat"

# Phonebook addresses
pa_file_name = "pim/pbaddress.dat"
pb_group_filename = "pim/pbgroup.dat"

#Group Picture ID Path Index File
GroupWPPathIndexFile='pim/pbGroupPixIdSetAsPath.dat'

# Phonebook favorites
favorites_file_name  = "pim/pbFavorite.dat"
NUMFAVORITES=10

#verified these constants specific to VX11000
PHONEBOOKENTRYSIZE=512
NUMSPEEDDIALS=1000
FIRSTSPEEDDIAL=1
LASTSPEEDDIAL=999
NUMEMERGENCYCONTACTS=3
NUMPHONEBOOKENTRIES=1000
NUMEMAILS=2
NUMPHONENUMBERS=5
MAXCALENDARDESCRIPTION=32
MAX_PHONEBOOK_GROUPS=30
MEMOLENGTH=300
SMS_CANNED_MAX_ITEMS=30
SMS_CANNED_MAX_LENGTH=100
NUMCALENDARENTRIES=300 #TODO: need to verify this number

PA_ENTRY_SOR = "<PA>"

class call(BaseProtogenClass):
    __fields=['GPStime', 'unk0', 'duration', 'number', 'name', 'numberlength', 'status', 'pbnumbertype', 'unk1', 'pbentrynum', 'number_location']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(call,self).__init__(**dict)
        if self.__class__ is call:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(call,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(call,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_GPStime.writetobuffer(buf)
        self.__field_unk0.writetobuffer(buf)
        self.__field_duration.writetobuffer(buf)
        self.__field_number.writetobuffer(buf)
        self.__field_name.writetobuffer(buf)
        self.__field_numberlength.writetobuffer(buf)
        self.__field_status.writetobuffer(buf)
        self.__field_pbnumbertype.writetobuffer(buf)
        self.__field_unk1.writetobuffer(buf)
        self.__field_pbentrynum.writetobuffer(buf)
        self.__field_number_location.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_GPStime=GPSDATE(**{'sizeinbytes': 4})
        self.__field_GPStime.readfrombuffer(buf)
        self.__field_unk0=UINT(**{'sizeinbytes': 4})
        self.__field_unk0.readfrombuffer(buf)
        self.__field_duration=UINT(**{'sizeinbytes': 4})
        self.__field_duration.readfrombuffer(buf)
        self.__field_number=USTRING(**{'sizeinbytes': 49, 'raiseonunterminatedread': False})
        self.__field_number.readfrombuffer(buf)
        self.__field_name=USTRING(**{'sizeinbytes': 36, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False})
        self.__field_name.readfrombuffer(buf)
        self.__field_numberlength=UINT(**{'sizeinbytes': 1})
        self.__field_numberlength.readfrombuffer(buf)
        self.__field_status=UINT(**{'sizeinbytes': 1})
        self.__field_status.readfrombuffer(buf)
        self.__field_pbnumbertype=UINT(**{'sizeinbytes': 1})
        self.__field_pbnumbertype.readfrombuffer(buf)
        self.__field_unk1=UINT(**{'sizeinbytes': 4})
        self.__field_unk1.readfrombuffer(buf)
        self.__field_pbentrynum=UINT(**{'sizeinbytes': 2})
        self.__field_pbentrynum.readfrombuffer(buf)
        self.__field_number_location=DATA(**{'sizeinbytes': 76})
        self.__field_number_location.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_GPStime(self):
        return self.__field_GPStime.getvalue()

    def __setfield_GPStime(self, value):
        if isinstance(value,GPSDATE):
            self.__field_GPStime=value
        else:
            self.__field_GPStime=GPSDATE(value,**{'sizeinbytes': 4})

    def __delfield_GPStime(self): del self.__field_GPStime

    GPStime=property(__getfield_GPStime, __setfield_GPStime, __delfield_GPStime, None)

    def __getfield_unk0(self):
        return self.__field_unk0.getvalue()

    def __setfield_unk0(self, value):
        if isinstance(value,UINT):
            self.__field_unk0=value
        else:
            self.__field_unk0=UINT(value,**{'sizeinbytes': 4})

    def __delfield_unk0(self): del self.__field_unk0

    unk0=property(__getfield_unk0, __setfield_unk0, __delfield_unk0, None)

    def __getfield_duration(self):
        return self.__field_duration.getvalue()

    def __setfield_duration(self, value):
        if isinstance(value,UINT):
            self.__field_duration=value
        else:
            self.__field_duration=UINT(value,**{'sizeinbytes': 4})

    def __delfield_duration(self): del self.__field_duration

    duration=property(__getfield_duration, __setfield_duration, __delfield_duration, None)

    def __getfield_number(self):
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,USTRING):
            self.__field_number=value
        else:
            self.__field_number=USTRING(value,**{'sizeinbytes': 49, 'raiseonunterminatedread': False})

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 36, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False})

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_numberlength(self):
        return self.__field_numberlength.getvalue()

    def __setfield_numberlength(self, value):
        if isinstance(value,UINT):
            self.__field_numberlength=value
        else:
            self.__field_numberlength=UINT(value,**{'sizeinbytes': 1})

    def __delfield_numberlength(self): del self.__field_numberlength

    numberlength=property(__getfield_numberlength, __setfield_numberlength, __delfield_numberlength, None)

    def __getfield_status(self):
        return self.__field_status.getvalue()

    def __setfield_status(self, value):
        if isinstance(value,UINT):
            self.__field_status=value
        else:
            self.__field_status=UINT(value,**{'sizeinbytes': 1})

    def __delfield_status(self): del self.__field_status

    status=property(__getfield_status, __setfield_status, __delfield_status, None)

    def __getfield_pbnumbertype(self):
        return self.__field_pbnumbertype.getvalue()

    def __setfield_pbnumbertype(self, value):
        if isinstance(value,UINT):
            self.__field_pbnumbertype=value
        else:
            self.__field_pbnumbertype=UINT(value,**{'sizeinbytes': 1})

    def __delfield_pbnumbertype(self): del self.__field_pbnumbertype

    pbnumbertype=property(__getfield_pbnumbertype, __setfield_pbnumbertype, __delfield_pbnumbertype, None)

    def __getfield_unk1(self):
        return self.__field_unk1.getvalue()

    def __setfield_unk1(self, value):
        if isinstance(value,UINT):
            self.__field_unk1=value
        else:
            self.__field_unk1=UINT(value,**{'sizeinbytes': 4})

    def __delfield_unk1(self): del self.__field_unk1

    unk1=property(__getfield_unk1, __setfield_unk1, __delfield_unk1, None)

    def __getfield_pbentrynum(self):
        return self.__field_pbentrynum.getvalue()

    def __setfield_pbentrynum(self, value):
        if isinstance(value,UINT):
            self.__field_pbentrynum=value
        else:
            self.__field_pbentrynum=UINT(value,**{'sizeinbytes': 2})

    def __delfield_pbentrynum(self): del self.__field_pbentrynum

    pbentrynum=property(__getfield_pbentrynum, __setfield_pbentrynum, __delfield_pbentrynum, None)

    def __getfield_number_location(self):
        return self.__field_number_location.getvalue()

    def __setfield_number_location(self, value):
        if isinstance(value,DATA):
            self.__field_number_location=value
        else:
            self.__field_number_location=DATA(value,**{'sizeinbytes': 76})

    def __delfield_number_location(self): del self.__field_number_location

    number_location=property(__getfield_number_location, __setfield_number_location, __delfield_number_location, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('GPStime', self.__field_GPStime, None)
        yield ('unk0', self.__field_unk0, None)
        yield ('duration', self.__field_duration, None)
        yield ('number', self.__field_number, None)
        yield ('name', self.__field_name, None)
        yield ('numberlength', self.__field_numberlength, None)
        yield ('status', self.__field_status, None)
        yield ('pbnumbertype', self.__field_pbnumbertype, None)
        yield ('unk1', self.__field_unk1, None)
        yield ('pbentrynum', self.__field_pbentrynum, None)
        yield ('number_location', self.__field_number_location, None)




class callhistory(BaseProtogenClass):
    __fields=['numcalls', 'unk1', 'calls']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(callhistory,self).__init__(**dict)
        if self.__class__ is callhistory:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(callhistory,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(callhistory,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_numcalls.writetobuffer(buf)
        self.__field_unk1.writetobuffer(buf)
        try: self.__field_calls
        except:
            self.__field_calls=LIST(**{'elementclass': call, 'length': self.numcalls})
        self.__field_calls.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_numcalls=UINT(**{'sizeinbytes': 4})
        self.__field_numcalls.readfrombuffer(buf)
        self.__field_unk1=UINT(**{'sizeinbytes': 1})
        self.__field_unk1.readfrombuffer(buf)
        self.__field_calls=LIST(**{'elementclass': call, 'length': self.numcalls})
        self.__field_calls.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numcalls(self):
        return self.__field_numcalls.getvalue()

    def __setfield_numcalls(self, value):
        if isinstance(value,UINT):
            self.__field_numcalls=value
        else:
            self.__field_numcalls=UINT(value,**{'sizeinbytes': 4})

    def __delfield_numcalls(self): del self.__field_numcalls

    numcalls=property(__getfield_numcalls, __setfield_numcalls, __delfield_numcalls, None)

    def __getfield_unk1(self):
        return self.__field_unk1.getvalue()

    def __setfield_unk1(self, value):
        if isinstance(value,UINT):
            self.__field_unk1=value
        else:
            self.__field_unk1=UINT(value,**{'sizeinbytes': 1})

    def __delfield_unk1(self): del self.__field_unk1

    unk1=property(__getfield_unk1, __setfield_unk1, __delfield_unk1, None)

    def __getfield_calls(self):
        try: self.__field_calls
        except:
            self.__field_calls=LIST(**{'elementclass': call, 'length': self.numcalls})
        return self.__field_calls.getvalue()

    def __setfield_calls(self, value):
        if isinstance(value,LIST):
            self.__field_calls=value
        else:
            self.__field_calls=LIST(value,**{'elementclass': call, 'length': self.numcalls})

    def __delfield_calls(self): del self.__field_calls

    calls=property(__getfield_calls, __setfield_calls, __delfield_calls, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numcalls', self.__field_numcalls, None)
        yield ('unk1', self.__field_unk1, None)
        yield ('calls', self.__field_calls, None)




class speeddial(BaseProtogenClass):
    __fields=['entry', 'number']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(speeddial,self).__init__(**dict)
        if self.__class__ is speeddial:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(speeddial,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(speeddial,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_entry
        except:
            self.__field_entry=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_entry.writetobuffer(buf)
        try: self.__field_number
        except:
            self.__field_number=UINT(**{'sizeinbytes': 1, 'default': 0xff})
        self.__field_number.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_entry=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_entry.readfrombuffer(buf)
        self.__field_number=UINT(**{'sizeinbytes': 1, 'default': 0xff})
        self.__field_number.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_entry(self):
        try: self.__field_entry
        except:
            self.__field_entry=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,UINT):
            self.__field_entry=value
        else:
            self.__field_entry=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, "0-based entry number")

    def __getfield_number(self):
        try: self.__field_number
        except:
            self.__field_number=UINT(**{'sizeinbytes': 1, 'default': 0xff})
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,UINT):
            self.__field_number=value
        else:
            self.__field_number=UINT(value,**{'sizeinbytes': 1, 'default': 0xff})

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, "number type")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('entry', self.__field_entry, "0-based entry number")
        yield ('number', self.__field_number, "number type")

    def valid(self):
        return self.entry!=0xffff




class speeddials(BaseProtogenClass):
    __fields=['speeddials']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(speeddials,self).__init__(**dict)
        if self.__class__ is speeddials:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(speeddials,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(speeddials,kwargs)
        if len(args):
            dict2={'length': NUMSPEEDDIALS, 'elementclass': speeddial}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_speeddials=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_speeddials
        except:
            self.__field_speeddials=LIST(**{'length': NUMSPEEDDIALS, 'elementclass': speeddial})
        self.__field_speeddials.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_speeddials=LIST(**{'length': NUMSPEEDDIALS, 'elementclass': speeddial})
        self.__field_speeddials.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_speeddials(self):
        try: self.__field_speeddials
        except:
            self.__field_speeddials=LIST(**{'length': NUMSPEEDDIALS, 'elementclass': speeddial})
        return self.__field_speeddials.getvalue()

    def __setfield_speeddials(self, value):
        if isinstance(value,LIST):
            self.__field_speeddials=value
        else:
            self.__field_speeddials=LIST(value,**{'length': NUMSPEEDDIALS, 'elementclass': speeddial})

    def __delfield_speeddials(self): del self.__field_speeddials

    speeddials=property(__getfield_speeddials, __setfield_speeddials, __delfield_speeddials, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('speeddials', self.__field_speeddials, None)




class pbfileentry(BaseProtogenClass):
    __fields=['entry_tag', 'unk4', 'mod_date', 'unk0', 'entry_number1', 'entry_number0', 'name', 'group', 'unk1', 'emails', 'ringtone', 'wallpaper', 'numbertypes', 'unk2', 'numberindices', 'addressindex', 'unk3', 'memo', 'exit_tag', 'dontcare']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbfileentry,self).__init__(**dict)
        if self.__class__ is pbfileentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbfileentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbfileentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_entry_tag
        except:
            self.__field_entry_tag=STRING(**{'sizeinbytes': 5,  'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '\xff\xff\xff\xff\xff' })
        self.__field_entry_tag.writetobuffer(buf)
        if self.entry_tag==PB_ENTRY_SOR:
            try: self.__field_unk4
            except:
                self.__field_unk4=UINT(**{'sizeinbytes': 1,  'default': 0xff })
            self.__field_unk4.writetobuffer(buf)
            try: self.__field_mod_date
            except:
                self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
            self.__field_mod_date.writetobuffer(buf)
            try: self.__field_unk0
            except:
                self.__field_unk0=STRING(**{'sizeinbytes': 6,  'terminator': None, 'default': '\xff\xff\xff\xff\xff\xff' })
            self.__field_unk0.writetobuffer(buf)
            self.__field_entry_number1.writetobuffer(buf)
            self.__field_entry_number0.writetobuffer(buf)
            try: self.__field_name
            except:
                self.__field_name=USTRING(**{'sizeinbytes': 34,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })
            self.__field_name.writetobuffer(buf)
            try: self.__field_group
            except:
                self.__field_group=UINT(**{'sizeinbytes': 2,  'default': 0 })
            self.__field_group.writetobuffer(buf)
            try: self.__field_unk1
            except:
                self.__field_unk1=UNKNOWN(**{'sizeinbytes': 58})
            self.__field_unk1.writetobuffer(buf)
            try: self.__field_emails
            except:
                self.__field_emails=LIST(**{'elementclass': _gen_p_lgvx11000_105, 'length': NUMEMAILS})
            self.__field_emails.writetobuffer(buf)
            try: self.__field_ringtone
            except:
                self.__field_ringtone=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
            self.__field_ringtone.writetobuffer(buf)
            try: self.__field_wallpaper
            except:
                self.__field_wallpaper=UINT(**{'sizeinbytes': 2,  'default': 0 })
            self.__field_wallpaper.writetobuffer(buf)
            try: self.__field_numbertypes
            except:
                self.__field_numbertypes=LIST(**{'elementclass': _gen_p_lgvx11000_109, 'length': NUMPHONENUMBERS})
            self.__field_numbertypes.writetobuffer(buf)
            try: self.__field_unk2
            except:
                self.__field_unk2=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_unk2.writetobuffer(buf)
            try: self.__field_numberindices
            except:
                self.__field_numberindices=LIST(**{'elementclass': _gen_p_lgvx11000_112, 'length': NUMPHONENUMBERS})
            self.__field_numberindices.writetobuffer(buf)
            try: self.__field_addressindex
            except:
                self.__field_addressindex=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
            self.__field_addressindex.writetobuffer(buf)
            try: self.__field_unk3
            except:
                self.__field_unk3=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
            self.__field_unk3.writetobuffer(buf)
            try: self.__field_memo
            except:
                self.__field_memo=USTRING(**{'sizeinbytes': 260,  'raiseonunterminatedread': False, 'default': '', 'encoding': PHONE_ENCODING })
            self.__field_memo.writetobuffer(buf)
            try: self.__field_exit_tag
            except:
                self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PE>'})
            self.__field_exit_tag.writetobuffer(buf)
        else:
            try: self.__field_dontcare
            except:
                self.__field_dontcare=DATA(**{'sizeinbytes': 507,  'default': '\xff'*507 })
            self.__field_dontcare.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_entry_tag=STRING(**{'sizeinbytes': 5,  'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '\xff\xff\xff\xff\xff' })
        self.__field_entry_tag.readfrombuffer(buf)
        if self.entry_tag==PB_ENTRY_SOR:
            self.__field_unk4=UINT(**{'sizeinbytes': 1,  'default': 0xff })
            self.__field_unk4.readfrombuffer(buf)
            self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
            self.__field_mod_date.readfrombuffer(buf)
            self.__field_unk0=STRING(**{'sizeinbytes': 6,  'terminator': None, 'default': '\xff\xff\xff\xff\xff\xff' })
            self.__field_unk0.readfrombuffer(buf)
            self.__field_entry_number1=UINT(**{'sizeinbytes': 4})
            self.__field_entry_number1.readfrombuffer(buf)
            self.__field_entry_number0=UINT(**{'sizeinbytes': 2})
            self.__field_entry_number0.readfrombuffer(buf)
            self.__field_name=USTRING(**{'sizeinbytes': 34,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })
            self.__field_name.readfrombuffer(buf)
            self.__field_group=UINT(**{'sizeinbytes': 2,  'default': 0 })
            self.__field_group.readfrombuffer(buf)
            self.__field_unk1=UNKNOWN(**{'sizeinbytes': 58})
            self.__field_unk1.readfrombuffer(buf)
            self.__field_emails=LIST(**{'elementclass': _gen_p_lgvx11000_105, 'length': NUMEMAILS})
            self.__field_emails.readfrombuffer(buf)
            self.__field_ringtone=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
            self.__field_ringtone.readfrombuffer(buf)
            self.__field_wallpaper=UINT(**{'sizeinbytes': 2,  'default': 0 })
            self.__field_wallpaper.readfrombuffer(buf)
            self.__field_numbertypes=LIST(**{'elementclass': _gen_p_lgvx11000_109, 'length': NUMPHONENUMBERS})
            self.__field_numbertypes.readfrombuffer(buf)
            self.__field_unk2=UINT(**{'sizeinbytes': 1,  'default': 0 })
            self.__field_unk2.readfrombuffer(buf)
            self.__field_numberindices=LIST(**{'elementclass': _gen_p_lgvx11000_112, 'length': NUMPHONENUMBERS})
            self.__field_numberindices.readfrombuffer(buf)
            self.__field_addressindex=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
            self.__field_addressindex.readfrombuffer(buf)
            self.__field_unk3=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
            self.__field_unk3.readfrombuffer(buf)
            self.__field_memo=USTRING(**{'sizeinbytes': 260,  'raiseonunterminatedread': False, 'default': '', 'encoding': PHONE_ENCODING })
            self.__field_memo.readfrombuffer(buf)
            self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PE>'})
            self.__field_exit_tag.readfrombuffer(buf)
        else:
            self.__field_dontcare=DATA(**{'sizeinbytes': 507,  'default': '\xff'*507 })
            self.__field_dontcare.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_entry_tag(self):
        try: self.__field_entry_tag
        except:
            self.__field_entry_tag=STRING(**{'sizeinbytes': 5,  'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '\xff\xff\xff\xff\xff' })
        return self.__field_entry_tag.getvalue()

    def __setfield_entry_tag(self, value):
        if isinstance(value,STRING):
            self.__field_entry_tag=value
        else:
            self.__field_entry_tag=STRING(value,**{'sizeinbytes': 5,  'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '\xff\xff\xff\xff\xff' })

    def __delfield_entry_tag(self): del self.__field_entry_tag

    entry_tag=property(__getfield_entry_tag, __setfield_entry_tag, __delfield_entry_tag, None)

    def __getfield_unk4(self):
        try: self.__field_unk4
        except:
            self.__field_unk4=UINT(**{'sizeinbytes': 1,  'default': 0xff })
        return self.__field_unk4.getvalue()

    def __setfield_unk4(self, value):
        if isinstance(value,UINT):
            self.__field_unk4=value
        else:
            self.__field_unk4=UINT(value,**{'sizeinbytes': 1,  'default': 0xff })

    def __delfield_unk4(self): del self.__field_unk4

    unk4=property(__getfield_unk4, __setfield_unk4, __delfield_unk4, None)

    def __getfield_mod_date(self):
        try: self.__field_mod_date
        except:
            self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
        return self.__field_mod_date.getvalue()

    def __setfield_mod_date(self, value):
        if isinstance(value,PBDateTime):
            self.__field_mod_date=value
        else:
            self.__field_mod_date=PBDateTime(value,**{ 'defaulttocurrenttime': True })

    def __delfield_mod_date(self): del self.__field_mod_date

    mod_date=property(__getfield_mod_date, __setfield_mod_date, __delfield_mod_date, None)

    def __getfield_unk0(self):
        try: self.__field_unk0
        except:
            self.__field_unk0=STRING(**{'sizeinbytes': 6,  'terminator': None, 'default': '\xff\xff\xff\xff\xff\xff' })
        return self.__field_unk0.getvalue()

    def __setfield_unk0(self, value):
        if isinstance(value,STRING):
            self.__field_unk0=value
        else:
            self.__field_unk0=STRING(value,**{'sizeinbytes': 6,  'terminator': None, 'default': '\xff\xff\xff\xff\xff\xff' })

    def __delfield_unk0(self): del self.__field_unk0

    unk0=property(__getfield_unk0, __setfield_unk0, __delfield_unk0, None)

    def __getfield_entry_number1(self):
        return self.__field_entry_number1.getvalue()

    def __setfield_entry_number1(self, value):
        if isinstance(value,UINT):
            self.__field_entry_number1=value
        else:
            self.__field_entry_number1=UINT(value,**{'sizeinbytes': 4})

    def __delfield_entry_number1(self): del self.__field_entry_number1

    entry_number1=property(__getfield_entry_number1, __setfield_entry_number1, __delfield_entry_number1, None)

    def __getfield_entry_number0(self):
        return self.__field_entry_number0.getvalue()

    def __setfield_entry_number0(self, value):
        if isinstance(value,UINT):
            self.__field_entry_number0=value
        else:
            self.__field_entry_number0=UINT(value,**{'sizeinbytes': 2})

    def __delfield_entry_number0(self): del self.__field_entry_number0

    entry_number0=property(__getfield_entry_number0, __setfield_entry_number0, __delfield_entry_number0, None)

    def __getfield_name(self):
        try: self.__field_name
        except:
            self.__field_name=USTRING(**{'sizeinbytes': 34,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 34,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False })

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_group(self):
        try: self.__field_group
        except:
            self.__field_group=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_group.getvalue()

    def __setfield_group(self, value):
        if isinstance(value,UINT):
            self.__field_group=value
        else:
            self.__field_group=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_group(self): del self.__field_group

    group=property(__getfield_group, __setfield_group, __delfield_group, None)

    def __getfield_unk1(self):
        try: self.__field_unk1
        except:
            self.__field_unk1=UNKNOWN(**{'sizeinbytes': 58})
        return self.__field_unk1.getvalue()

    def __setfield_unk1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unk1=value
        else:
            self.__field_unk1=UNKNOWN(value,**{'sizeinbytes': 58})

    def __delfield_unk1(self): del self.__field_unk1

    unk1=property(__getfield_unk1, __setfield_unk1, __delfield_unk1, None)

    def __getfield_emails(self):
        try: self.__field_emails
        except:
            self.__field_emails=LIST(**{'elementclass': _gen_p_lgvx11000_105, 'length': NUMEMAILS})
        return self.__field_emails.getvalue()

    def __setfield_emails(self, value):
        if isinstance(value,LIST):
            self.__field_emails=value
        else:
            self.__field_emails=LIST(value,**{'elementclass': _gen_p_lgvx11000_105, 'length': NUMEMAILS})

    def __delfield_emails(self): del self.__field_emails

    emails=property(__getfield_emails, __setfield_emails, __delfield_emails, None)

    def __getfield_ringtone(self):
        try: self.__field_ringtone
        except:
            self.__field_ringtone=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,UINT):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=UINT(value,**{'sizeinbytes': 2,  'default': 0xffff })

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def __getfield_wallpaper(self):
        try: self.__field_wallpaper
        except:
            self.__field_wallpaper=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_wallpaper.getvalue()

    def __setfield_wallpaper(self, value):
        if isinstance(value,UINT):
            self.__field_wallpaper=value
        else:
            self.__field_wallpaper=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_wallpaper(self): del self.__field_wallpaper

    wallpaper=property(__getfield_wallpaper, __setfield_wallpaper, __delfield_wallpaper, None)

    def __getfield_numbertypes(self):
        try: self.__field_numbertypes
        except:
            self.__field_numbertypes=LIST(**{'elementclass': _gen_p_lgvx11000_109, 'length': NUMPHONENUMBERS})
        return self.__field_numbertypes.getvalue()

    def __setfield_numbertypes(self, value):
        if isinstance(value,LIST):
            self.__field_numbertypes=value
        else:
            self.__field_numbertypes=LIST(value,**{'elementclass': _gen_p_lgvx11000_109, 'length': NUMPHONENUMBERS})

    def __delfield_numbertypes(self): del self.__field_numbertypes

    numbertypes=property(__getfield_numbertypes, __setfield_numbertypes, __delfield_numbertypes, None)

    def __getfield_unk2(self):
        try: self.__field_unk2
        except:
            self.__field_unk2=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_unk2.getvalue()

    def __setfield_unk2(self, value):
        if isinstance(value,UINT):
            self.__field_unk2=value
        else:
            self.__field_unk2=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_unk2(self): del self.__field_unk2

    unk2=property(__getfield_unk2, __setfield_unk2, __delfield_unk2, None)

    def __getfield_numberindices(self):
        try: self.__field_numberindices
        except:
            self.__field_numberindices=LIST(**{'elementclass': _gen_p_lgvx11000_112, 'length': NUMPHONENUMBERS})
        return self.__field_numberindices.getvalue()

    def __setfield_numberindices(self, value):
        if isinstance(value,LIST):
            self.__field_numberindices=value
        else:
            self.__field_numberindices=LIST(value,**{'elementclass': _gen_p_lgvx11000_112, 'length': NUMPHONENUMBERS})

    def __delfield_numberindices(self): del self.__field_numberindices

    numberindices=property(__getfield_numberindices, __setfield_numberindices, __delfield_numberindices, None)

    def __getfield_addressindex(self):
        try: self.__field_addressindex
        except:
            self.__field_addressindex=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
        return self.__field_addressindex.getvalue()

    def __setfield_addressindex(self, value):
        if isinstance(value,UINT):
            self.__field_addressindex=value
        else:
            self.__field_addressindex=UINT(value,**{'sizeinbytes': 2,  'default': 0xffff })

    def __delfield_addressindex(self): del self.__field_addressindex

    addressindex=property(__getfield_addressindex, __setfield_addressindex, __delfield_addressindex, None)

    def __getfield_unk3(self):
        try: self.__field_unk3
        except:
            self.__field_unk3=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
        return self.__field_unk3.getvalue()

    def __setfield_unk3(self, value):
        if isinstance(value,UINT):
            self.__field_unk3=value
        else:
            self.__field_unk3=UINT(value,**{'sizeinbytes': 2,  'default': 0xffff })

    def __delfield_unk3(self): del self.__field_unk3

    unk3=property(__getfield_unk3, __setfield_unk3, __delfield_unk3, None)

    def __getfield_memo(self):
        try: self.__field_memo
        except:
            self.__field_memo=USTRING(**{'sizeinbytes': 260,  'raiseonunterminatedread': False, 'default': '', 'encoding': PHONE_ENCODING })
        return self.__field_memo.getvalue()

    def __setfield_memo(self, value):
        if isinstance(value,USTRING):
            self.__field_memo=value
        else:
            self.__field_memo=USTRING(value,**{'sizeinbytes': 260,  'raiseonunterminatedread': False, 'default': '', 'encoding': PHONE_ENCODING })

    def __delfield_memo(self): del self.__field_memo

    memo=property(__getfield_memo, __setfield_memo, __delfield_memo, None)

    def __getfield_exit_tag(self):
        try: self.__field_exit_tag
        except:
            self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PE>'})
        return self.__field_exit_tag.getvalue()

    def __setfield_exit_tag(self, value):
        if isinstance(value,USTRING):
            self.__field_exit_tag=value
        else:
            self.__field_exit_tag=USTRING(value,**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PE>'})

    def __delfield_exit_tag(self): del self.__field_exit_tag

    exit_tag=property(__getfield_exit_tag, __setfield_exit_tag, __delfield_exit_tag, None)

    def __getfield_dontcare(self):
        try: self.__field_dontcare
        except:
            self.__field_dontcare=DATA(**{'sizeinbytes': 507,  'default': '\xff'*507 })
        return self.__field_dontcare.getvalue()

    def __setfield_dontcare(self, value):
        if isinstance(value,DATA):
            self.__field_dontcare=value
        else:
            self.__field_dontcare=DATA(value,**{'sizeinbytes': 507,  'default': '\xff'*507 })

    def __delfield_dontcare(self): del self.__field_dontcare

    dontcare=property(__getfield_dontcare, __setfield_dontcare, __delfield_dontcare, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('entry_tag', self.__field_entry_tag, None)
        if self.entry_tag==PB_ENTRY_SOR:
            yield ('unk4', self.__field_unk4, None)
            yield ('mod_date', self.__field_mod_date, None)
            yield ('unk0', self.__field_unk0, None)
            yield ('entry_number1', self.__field_entry_number1, None)
            yield ('entry_number0', self.__field_entry_number0, None)
            yield ('name', self.__field_name, None)
            yield ('group', self.__field_group, None)
            yield ('unk1', self.__field_unk1, None)
            yield ('emails', self.__field_emails, None)
            yield ('ringtone', self.__field_ringtone, None)
            yield ('wallpaper', self.__field_wallpaper, None)
            yield ('numbertypes', self.__field_numbertypes, None)
            yield ('unk2', self.__field_unk2, None)
            yield ('numberindices', self.__field_numberindices, None)
            yield ('addressindex', self.__field_addressindex, None)
            yield ('unk3', self.__field_unk3, None)
            yield ('memo', self.__field_memo, None)
            yield ('exit_tag', self.__field_exit_tag, None)
        else:
            yield ('dontcare', self.__field_dontcare, None)

    def valid(self):
        global PB_ENTRY_SOR
        return self.entry_tag==PB_ENTRY_SOR and ord(self.name[0]) != 0xff




class _gen_p_lgvx11000_105(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['email']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx11000_105,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx11000_105:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx11000_105,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx11000_105,kwargs)
        if len(args):
            dict2={'sizeinbytes': 49, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_email=USTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_email.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_email=USTRING(**{'sizeinbytes': 49, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False})
        self.__field_email.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_email(self):
        return self.__field_email.getvalue()

    def __setfield_email(self, value):
        if isinstance(value,USTRING):
            self.__field_email=value
        else:
            self.__field_email=USTRING(value,**{'sizeinbytes': 49, 'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False})

    def __delfield_email(self): del self.__field_email

    email=property(__getfield_email, __setfield_email, __delfield_email, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('email', self.__field_email, None)




class _gen_p_lgvx11000_109(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['numbertype']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx11000_109,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx11000_109:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx11000_109,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx11000_109,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1,  'default': 0 }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_numbertype=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_numbertype.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_numbertype=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_numbertype.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numbertype(self):
        return self.__field_numbertype.getvalue()

    def __setfield_numbertype(self, value):
        if isinstance(value,UINT):
            self.__field_numbertype=value
        else:
            self.__field_numbertype=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_numbertype(self): del self.__field_numbertype

    numbertype=property(__getfield_numbertype, __setfield_numbertype, __delfield_numbertype, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numbertype', self.__field_numbertype, None)




class _gen_p_lgvx11000_112(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['numberindex']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_lgvx11000_112,self).__init__(**dict)
        if self.__class__ is _gen_p_lgvx11000_112:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_lgvx11000_112,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_lgvx11000_112,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2,  'default': 0xffff }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_numberindex=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_numberindex.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_numberindex=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
        self.__field_numberindex.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numberindex(self):
        return self.__field_numberindex.getvalue()

    def __setfield_numberindex(self, value):
        if isinstance(value,UINT):
            self.__field_numberindex=value
        else:
            self.__field_numberindex=UINT(value,**{'sizeinbytes': 2,  'default': 0xffff })

    def __delfield_numberindex(self): del self.__field_numberindex

    numberindex=property(__getfield_numberindex, __setfield_numberindex, __delfield_numberindex, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numberindex', self.__field_numberindex, None)




class pbfile(BaseProtogenClass):
    __fields=['items', 'eof_tag', 'model_name', 'mod_date', 'blanks', 'eof_close_tag']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbfile,self).__init__(**dict)
        if self.__class__ is pbfile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbfile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbfile,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': pbfileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True})
        self.__field_items.writetobuffer(buf)
        try: self.__field_eof_tag
        except:
            self.__field_eof_tag=STRING(**{'sizeinbytes': 6,  'default': '<HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False })
        self.__field_eof_tag.writetobuffer(buf)
        try: self.__field_model_name
        except:
            self.__field_model_name=STRING(**{'sizeinbytes': 10,  'raiseonunterminatedread': False,                'raiseontruncate': False })
        self.__field_model_name.writetobuffer(buf)
        try: self.__field_mod_date
        except:
            self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
        self.__field_mod_date.writetobuffer(buf)
        try: self.__field_blanks
        except:
            self.__field_blanks=DATA(**{'sizeinbytes': 477,  'default': '\x00'*221 })
        self.__field_blanks.writetobuffer(buf)
        try: self.__field_eof_close_tag
        except:
            self.__field_eof_close_tag=STRING(**{'sizeinbytes': 7,  'default': '</HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False  })
        self.__field_eof_close_tag.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': pbfileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True})
        self.__field_items.readfrombuffer(buf)
        self.__field_eof_tag=STRING(**{'sizeinbytes': 6,  'default': '<HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False })
        self.__field_eof_tag.readfrombuffer(buf)
        self.__field_model_name=STRING(**{'sizeinbytes': 10,  'raiseonunterminatedread': False,                'raiseontruncate': False })
        self.__field_model_name.readfrombuffer(buf)
        self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
        self.__field_mod_date.readfrombuffer(buf)
        self.__field_blanks=DATA(**{'sizeinbytes': 477,  'default': '\x00'*221 })
        self.__field_blanks.readfrombuffer(buf)
        self.__field_eof_close_tag=STRING(**{'sizeinbytes': 7,  'default': '</HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False  })
        self.__field_eof_close_tag.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': pbfileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True})
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': pbfileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True})

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def __getfield_eof_tag(self):
        try: self.__field_eof_tag
        except:
            self.__field_eof_tag=STRING(**{'sizeinbytes': 6,  'default': '<HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False })
        return self.__field_eof_tag.getvalue()

    def __setfield_eof_tag(self, value):
        if isinstance(value,STRING):
            self.__field_eof_tag=value
        else:
            self.__field_eof_tag=STRING(value,**{'sizeinbytes': 6,  'default': '<HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False })

    def __delfield_eof_tag(self): del self.__field_eof_tag

    eof_tag=property(__getfield_eof_tag, __setfield_eof_tag, __delfield_eof_tag, None)

    def __getfield_model_name(self):
        try: self.__field_model_name
        except:
            self.__field_model_name=STRING(**{'sizeinbytes': 10,  'raiseonunterminatedread': False,                'raiseontruncate': False })
        return self.__field_model_name.getvalue()

    def __setfield_model_name(self, value):
        if isinstance(value,STRING):
            self.__field_model_name=value
        else:
            self.__field_model_name=STRING(value,**{'sizeinbytes': 10,  'raiseonunterminatedread': False,                'raiseontruncate': False })

    def __delfield_model_name(self): del self.__field_model_name

    model_name=property(__getfield_model_name, __setfield_model_name, __delfield_model_name, None)

    def __getfield_mod_date(self):
        try: self.__field_mod_date
        except:
            self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
        return self.__field_mod_date.getvalue()

    def __setfield_mod_date(self, value):
        if isinstance(value,PBDateTime):
            self.__field_mod_date=value
        else:
            self.__field_mod_date=PBDateTime(value,**{ 'defaulttocurrenttime': True })

    def __delfield_mod_date(self): del self.__field_mod_date

    mod_date=property(__getfield_mod_date, __setfield_mod_date, __delfield_mod_date, None)

    def __getfield_blanks(self):
        try: self.__field_blanks
        except:
            self.__field_blanks=DATA(**{'sizeinbytes': 477,  'default': '\x00'*221 })
        return self.__field_blanks.getvalue()

    def __setfield_blanks(self, value):
        if isinstance(value,DATA):
            self.__field_blanks=value
        else:
            self.__field_blanks=DATA(value,**{'sizeinbytes': 477,  'default': '\x00'*221 })

    def __delfield_blanks(self): del self.__field_blanks

    blanks=property(__getfield_blanks, __setfield_blanks, __delfield_blanks, None)

    def __getfield_eof_close_tag(self):
        try: self.__field_eof_close_tag
        except:
            self.__field_eof_close_tag=STRING(**{'sizeinbytes': 7,  'default': '</HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False  })
        return self.__field_eof_close_tag.getvalue()

    def __setfield_eof_close_tag(self, value):
        if isinstance(value,STRING):
            self.__field_eof_close_tag=value
        else:
            self.__field_eof_close_tag=STRING(value,**{'sizeinbytes': 7,  'default': '</HPE>',               'raiseonunterminatedread': False,               'raiseontruncate': False  })

    def __delfield_eof_close_tag(self): del self.__field_eof_close_tag

    eof_close_tag=property(__getfield_eof_close_tag, __setfield_eof_close_tag, __delfield_eof_close_tag, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)
        yield ('eof_tag', self.__field_eof_tag, None)
        yield ('model_name', self.__field_model_name, None)
        yield ('mod_date', self.__field_mod_date, None)
        yield ('blanks', self.__field_blanks, None)
        yield ('eof_close_tag', self.__field_eof_close_tag, None)




class pafileentry(BaseProtogenClass):
    __fields=['entry_tag', 'pad', 'mod_date', 'zeros', 'index', 'pb_entry', 'street', 'city', 'state', 'zip_code', 'country', 'exit_tag', 'dontcare']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pafileentry,self).__init__(**dict)
        if self.__class__ is pafileentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pafileentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pafileentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_entry_tag
        except:
            self.__field_entry_tag=STRING(**{'sizeinbytes': 5,  'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '\xff\xff\xff\xff\xff' })
        self.__field_entry_tag.writetobuffer(buf)
        if self.entry_tag==PA_ENTRY_SOR:
            try: self.__field_pad
            except:
                self.__field_pad=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
            self.__field_pad.writetobuffer(buf)
            try: self.__field_mod_date
            except:
                self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
            self.__field_mod_date.writetobuffer(buf)
            try: self.__field_zeros
            except:
                self.__field_zeros=UNKNOWN(**{'sizeinbytes': 6})
            self.__field_zeros.writetobuffer(buf)
            try: self.__field_index
            except:
                self.__field_index=UINT(**{'sizeinbytes': 2})
            self.__field_index.writetobuffer(buf)
            try: self.__field_pb_entry
            except:
                self.__field_pb_entry=UINT(**{'sizeinbytes': 2})
            self.__field_pb_entry.writetobuffer(buf)
            try: self.__field_street
            except:
                self.__field_street=USTRING(**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
            self.__field_street.writetobuffer(buf)
            try: self.__field_city
            except:
                self.__field_city=USTRING(**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
            self.__field_city.writetobuffer(buf)
            try: self.__field_state
            except:
                self.__field_state=USTRING(**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
            self.__field_state.writetobuffer(buf)
            try: self.__field_zip_code
            except:
                self.__field_zip_code=USTRING(**{'sizeinbytes': 13,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
            self.__field_zip_code.writetobuffer(buf)
            try: self.__field_country
            except:
                self.__field_country=USTRING(**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
            self.__field_country.writetobuffer(buf)
            try: self.__field_exit_tag
            except:
                self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PA>'})
            self.__field_exit_tag.writetobuffer(buf)
        else:
            try: self.__field_dontcare
            except:
                self.__field_dontcare=DATA(**{'sizeinbytes': 250,  'default': '\xff'*250 })
            self.__field_dontcare.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_entry_tag=STRING(**{'sizeinbytes': 5,  'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '\xff\xff\xff\xff\xff' })
        self.__field_entry_tag.readfrombuffer(buf)
        if self.entry_tag==PA_ENTRY_SOR:
            self.__field_pad=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
            self.__field_pad.readfrombuffer(buf)
            self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
            self.__field_mod_date.readfrombuffer(buf)
            self.__field_zeros=UNKNOWN(**{'sizeinbytes': 6})
            self.__field_zeros.readfrombuffer(buf)
            self.__field_index=UINT(**{'sizeinbytes': 2})
            self.__field_index.readfrombuffer(buf)
            self.__field_pb_entry=UINT(**{'sizeinbytes': 2})
            self.__field_pb_entry.readfrombuffer(buf)
            self.__field_street=USTRING(**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
            self.__field_street.readfrombuffer(buf)
            self.__field_city=USTRING(**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
            self.__field_city.readfrombuffer(buf)
            self.__field_state=USTRING(**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
            self.__field_state.readfrombuffer(buf)
            self.__field_zip_code=USTRING(**{'sizeinbytes': 13,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
            self.__field_zip_code.readfrombuffer(buf)
            self.__field_country=USTRING(**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
            self.__field_country.readfrombuffer(buf)
            self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PA>'})
            self.__field_exit_tag.readfrombuffer(buf)
        else:
            self.__field_dontcare=DATA(**{'sizeinbytes': 250,  'default': '\xff'*250 })
            self.__field_dontcare.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_entry_tag(self):
        try: self.__field_entry_tag
        except:
            self.__field_entry_tag=STRING(**{'sizeinbytes': 5,  'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '\xff\xff\xff\xff\xff' })
        return self.__field_entry_tag.getvalue()

    def __setfield_entry_tag(self, value):
        if isinstance(value,STRING):
            self.__field_entry_tag=value
        else:
            self.__field_entry_tag=STRING(value,**{'sizeinbytes': 5,  'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '\xff\xff\xff\xff\xff' })

    def __delfield_entry_tag(self): del self.__field_entry_tag

    entry_tag=property(__getfield_entry_tag, __setfield_entry_tag, __delfield_entry_tag, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UINT(**{'sizeinbytes': 1,  'default': 0x00 })
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UINT):
            self.__field_pad=value
        else:
            self.__field_pad=UINT(value,**{'sizeinbytes': 1,  'default': 0x00 })

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def __getfield_mod_date(self):
        try: self.__field_mod_date
        except:
            self.__field_mod_date=PBDateTime(**{ 'defaulttocurrenttime': True })
        return self.__field_mod_date.getvalue()

    def __setfield_mod_date(self, value):
        if isinstance(value,PBDateTime):
            self.__field_mod_date=value
        else:
            self.__field_mod_date=PBDateTime(value,**{ 'defaulttocurrenttime': True })

    def __delfield_mod_date(self): del self.__field_mod_date

    mod_date=property(__getfield_mod_date, __setfield_mod_date, __delfield_mod_date, None)

    def __getfield_zeros(self):
        try: self.__field_zeros
        except:
            self.__field_zeros=UNKNOWN(**{'sizeinbytes': 6})
        return self.__field_zeros.getvalue()

    def __setfield_zeros(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_zeros=value
        else:
            self.__field_zeros=UNKNOWN(value,**{'sizeinbytes': 6})

    def __delfield_zeros(self): del self.__field_zeros

    zeros=property(__getfield_zeros, __setfield_zeros, __delfield_zeros, None)

    def __getfield_index(self):
        try: self.__field_index
        except:
            self.__field_index=UINT(**{'sizeinbytes': 2})
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 2})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_pb_entry(self):
        try: self.__field_pb_entry
        except:
            self.__field_pb_entry=UINT(**{'sizeinbytes': 2})
        return self.__field_pb_entry.getvalue()

    def __setfield_pb_entry(self, value):
        if isinstance(value,UINT):
            self.__field_pb_entry=value
        else:
            self.__field_pb_entry=UINT(value,**{'sizeinbytes': 2})

    def __delfield_pb_entry(self): del self.__field_pb_entry

    pb_entry=property(__getfield_pb_entry, __setfield_pb_entry, __delfield_pb_entry, None)

    def __getfield_street(self):
        try: self.__field_street
        except:
            self.__field_street=USTRING(**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
        return self.__field_street.getvalue()

    def __setfield_street(self, value):
        if isinstance(value,USTRING):
            self.__field_street=value
        else:
            self.__field_street=USTRING(value,**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })

    def __delfield_street(self): del self.__field_street

    street=property(__getfield_street, __setfield_street, __delfield_street, None)

    def __getfield_city(self):
        try: self.__field_city
        except:
            self.__field_city=USTRING(**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
        return self.__field_city.getvalue()

    def __setfield_city(self, value):
        if isinstance(value,USTRING):
            self.__field_city=value
        else:
            self.__field_city=USTRING(value,**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })

    def __delfield_city(self): del self.__field_city

    city=property(__getfield_city, __setfield_city, __delfield_city, None)

    def __getfield_state(self):
        try: self.__field_state
        except:
            self.__field_state=USTRING(**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
        return self.__field_state.getvalue()

    def __setfield_state(self, value):
        if isinstance(value,USTRING):
            self.__field_state=value
        else:
            self.__field_state=USTRING(value,**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })

    def __delfield_state(self): del self.__field_state

    state=property(__getfield_state, __setfield_state, __delfield_state, None)

    def __getfield_zip_code(self):
        try: self.__field_zip_code
        except:
            self.__field_zip_code=USTRING(**{'sizeinbytes': 13,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
        return self.__field_zip_code.getvalue()

    def __setfield_zip_code(self, value):
        if isinstance(value,USTRING):
            self.__field_zip_code=value
        else:
            self.__field_zip_code=USTRING(value,**{'sizeinbytes': 13,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })

    def __delfield_zip_code(self): del self.__field_zip_code

    zip_code=property(__getfield_zip_code, __setfield_zip_code, __delfield_zip_code, None)

    def __getfield_country(self):
        try: self.__field_country
        except:
            self.__field_country=USTRING(**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })
        return self.__field_country.getvalue()

    def __setfield_country(self, value):
        if isinstance(value,USTRING):
            self.__field_country=value
        else:
            self.__field_country=USTRING(value,**{'sizeinbytes': 52,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '' })

    def __delfield_country(self): del self.__field_country

    country=property(__getfield_country, __setfield_country, __delfield_country, None)

    def __getfield_exit_tag(self):
        try: self.__field_exit_tag
        except:
            self.__field_exit_tag=USTRING(**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PA>'})
        return self.__field_exit_tag.getvalue()

    def __setfield_exit_tag(self, value):
        if isinstance(value,USTRING):
            self.__field_exit_tag=value
        else:
            self.__field_exit_tag=USTRING(value,**{'sizeinbytes': 6,  'encoding': PHONE_ENCODING, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': '</PA>'})

    def __delfield_exit_tag(self): del self.__field_exit_tag

    exit_tag=property(__getfield_exit_tag, __setfield_exit_tag, __delfield_exit_tag, None)

    def __getfield_dontcare(self):
        try: self.__field_dontcare
        except:
            self.__field_dontcare=DATA(**{'sizeinbytes': 250,  'default': '\xff'*250 })
        return self.__field_dontcare.getvalue()

    def __setfield_dontcare(self, value):
        if isinstance(value,DATA):
            self.__field_dontcare=value
        else:
            self.__field_dontcare=DATA(value,**{'sizeinbytes': 250,  'default': '\xff'*250 })

    def __delfield_dontcare(self): del self.__field_dontcare

    dontcare=property(__getfield_dontcare, __setfield_dontcare, __delfield_dontcare, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('entry_tag', self.__field_entry_tag, None)
        if self.entry_tag==PA_ENTRY_SOR:
            yield ('pad', self.__field_pad, None)
            yield ('mod_date', self.__field_mod_date, None)
            yield ('zeros', self.__field_zeros, None)
            yield ('index', self.__field_index, None)
            yield ('pb_entry', self.__field_pb_entry, None)
            yield ('street', self.__field_street, None)
            yield ('city', self.__field_city, None)
            yield ('state', self.__field_state, None)
            yield ('zip_code', self.__field_zip_code, None)
            yield ('country', self.__field_country, None)
            yield ('exit_tag', self.__field_exit_tag, None)
        else:
            yield ('dontcare', self.__field_dontcare, None)

    def valid(self):
        global PA_ENTRY_SOR
        return self.entry_tag==PA_ENTRY_SOR




class pafile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pafile,self).__init__(**dict)
        if self.__class__ is pafile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pafile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pafile,kwargs)
        if len(args):
            dict2={ 'elementclass': pafileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': pafileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': pafileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': pafileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': pafileentry,             'length': NUMPHONEBOOKENTRIES,             'createdefault': True })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




class pbgroup(BaseProtogenClass):
    __fields=['name', 'groupid', 'user_added', 'wallpaper']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbgroup,self).__init__(**dict)
        if self.__class__ is pbgroup:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbgroup,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbgroup,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_name
        except:
            self.__field_name=USTRING(**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False,                'raiseontruncate': False,                'default': '' })
        self.__field_name.writetobuffer(buf)
        try: self.__field_groupid
        except:
            self.__field_groupid=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_groupid.writetobuffer(buf)
        try: self.__field_user_added
        except:
            self.__field_user_added=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_user_added.writetobuffer(buf)
        try: self.__field_wallpaper
        except:
            self.__field_wallpaper=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_wallpaper.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_name=USTRING(**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False,                'raiseontruncate': False,                'default': '' })
        self.__field_name.readfrombuffer(buf)
        self.__field_groupid=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_groupid.readfrombuffer(buf)
        self.__field_user_added=UINT(**{'sizeinbytes': 1,  'default': 0 })
        self.__field_user_added.readfrombuffer(buf)
        self.__field_wallpaper=UINT(**{'sizeinbytes': 2,  'default': 0 })
        self.__field_wallpaper.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_name(self):
        try: self.__field_name
        except:
            self.__field_name=USTRING(**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False,                'raiseontruncate': False,                'default': '' })
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 33, 'encoding': PHONE_ENCODING,                'raiseonunterminatedread': False,                'raiseontruncate': False,                'default': '' })

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_groupid(self):
        try: self.__field_groupid
        except:
            self.__field_groupid=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_groupid.getvalue()

    def __setfield_groupid(self, value):
        if isinstance(value,UINT):
            self.__field_groupid=value
        else:
            self.__field_groupid=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_groupid(self): del self.__field_groupid

    groupid=property(__getfield_groupid, __setfield_groupid, __delfield_groupid, None)

    def __getfield_user_added(self):
        try: self.__field_user_added
        except:
            self.__field_user_added=UINT(**{'sizeinbytes': 1,  'default': 0 })
        return self.__field_user_added.getvalue()

    def __setfield_user_added(self, value):
        if isinstance(value,UINT):
            self.__field_user_added=value
        else:
            self.__field_user_added=UINT(value,**{'sizeinbytes': 1,  'default': 0 })

    def __delfield_user_added(self): del self.__field_user_added

    user_added=property(__getfield_user_added, __setfield_user_added, __delfield_user_added, "=1 when was added by user")

    def __getfield_wallpaper(self):
        try: self.__field_wallpaper
        except:
            self.__field_wallpaper=UINT(**{'sizeinbytes': 2,  'default': 0 })
        return self.__field_wallpaper.getvalue()

    def __setfield_wallpaper(self, value):
        if isinstance(value,UINT):
            self.__field_wallpaper=value
        else:
            self.__field_wallpaper=UINT(value,**{'sizeinbytes': 2,  'default': 0 })

    def __delfield_wallpaper(self): del self.__field_wallpaper

    wallpaper=property(__getfield_wallpaper, __setfield_wallpaper, __delfield_wallpaper, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('name', self.__field_name, None)
        yield ('groupid', self.__field_groupid, None)
        yield ('user_added', self.__field_user_added, "=1 when was added by user")
        yield ('wallpaper', self.__field_wallpaper, None)




class pbgroups(BaseProtogenClass):
    "Phonebook groups"
    __fields=['groups']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbgroups,self).__init__(**dict)
        if self.__class__ is pbgroups:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbgroups,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbgroups,kwargs)
        if len(args):
            dict2={'elementclass': pbgroup,            'raiseonincompleteread': False,            'length': MAX_PHONEBOOK_GROUPS,            'createdefault': True}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_groups=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_groups
        except:
            self.__field_groups=LIST(**{'elementclass': pbgroup,            'raiseonincompleteread': False,            'length': MAX_PHONEBOOK_GROUPS,            'createdefault': True})
        self.__field_groups.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_groups=LIST(**{'elementclass': pbgroup,            'raiseonincompleteread': False,            'length': MAX_PHONEBOOK_GROUPS,            'createdefault': True})
        self.__field_groups.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_groups(self):
        try: self.__field_groups
        except:
            self.__field_groups=LIST(**{'elementclass': pbgroup,            'raiseonincompleteread': False,            'length': MAX_PHONEBOOK_GROUPS,            'createdefault': True})
        return self.__field_groups.getvalue()

    def __setfield_groups(self, value):
        if isinstance(value,LIST):
            self.__field_groups=value
        else:
            self.__field_groups=LIST(value,**{'elementclass': pbgroup,            'raiseonincompleteread': False,            'length': MAX_PHONEBOOK_GROUPS,            'createdefault': True})

    def __delfield_groups(self): del self.__field_groups

    groups=property(__getfield_groups, __setfield_groups, __delfield_groups, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('groups', self.__field_groups, None)




class favorite(BaseProtogenClass):
    __fields=['pb_index', 'fav_type']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(favorite,self).__init__(**dict)
        if self.__class__ is favorite:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(favorite,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(favorite,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_pb_index
        except:
            self.__field_pb_index=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
        self.__field_pb_index.writetobuffer(buf)
        try: self.__field_fav_type
        except:
            self.__field_fav_type=UINT(**{'sizeinbytes': 1,  'default': 0xff })
        self.__field_fav_type.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pb_index=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
        self.__field_pb_index.readfrombuffer(buf)
        self.__field_fav_type=UINT(**{'sizeinbytes': 1,  'default': 0xff })
        self.__field_fav_type.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pb_index(self):
        try: self.__field_pb_index
        except:
            self.__field_pb_index=UINT(**{'sizeinbytes': 2,  'default': 0xffff })
        return self.__field_pb_index.getvalue()

    def __setfield_pb_index(self, value):
        if isinstance(value,UINT):
            self.__field_pb_index=value
        else:
            self.__field_pb_index=UINT(value,**{'sizeinbytes': 2,  'default': 0xffff })

    def __delfield_pb_index(self): del self.__field_pb_index

    pb_index=property(__getfield_pb_index, __setfield_pb_index, __delfield_pb_index, None)

    def __getfield_fav_type(self):
        try: self.__field_fav_type
        except:
            self.__field_fav_type=UINT(**{'sizeinbytes': 1,  'default': 0xff })
        return self.__field_fav_type.getvalue()

    def __setfield_fav_type(self, value):
        if isinstance(value,UINT):
            self.__field_fav_type=value
        else:
            self.__field_fav_type=UINT(value,**{'sizeinbytes': 1,  'default': 0xff })

    def __delfield_fav_type(self): del self.__field_fav_type

    fav_type=property(__getfield_fav_type, __setfield_fav_type, __delfield_fav_type, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pb_index', self.__field_pb_index, None)
        yield ('fav_type', self.__field_fav_type, None)

    def has_pbentry(self):
        return self.pb_index != 0xffff and self.fav_type == 1




class favorites(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(favorites,self).__init__(**dict)
        if self.__class__ is favorites:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(favorites,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(favorites,kwargs)
        if len(args):
            dict2={ 'elementclass': favorite, 'length': NUMFAVORITES }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': favorite, 'length': NUMFAVORITES })
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': favorite, 'length': NUMFAVORITES })
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': favorite, 'length': NUMFAVORITES })
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': favorite, 'length': NUMFAVORITES })

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)

    def set_favorite(self, index, entity_index, ispbentry):
        if index < NUMFAVORITES:
            self.items[index].pb_index = entity_index
            if ispbentry:
                self.items[index].fav_type = 1
            else:
                self.items[index].fav_type = 2




class GroupPicID_PathIndexEntry(BaseProtogenClass):
    __fields=['pathname']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(GroupPicID_PathIndexEntry,self).__init__(**dict)
        if self.__class__ is GroupPicID_PathIndexEntry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(GroupPicID_PathIndexEntry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(GroupPicID_PathIndexEntry,kwargs)
        if len(args):
            dict2={'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' }
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pathname=USTRING(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_pathname
        except:
            self.__field_pathname=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })
        self.__field_pathname.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pathname=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })
        self.__field_pathname.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pathname(self):
        try: self.__field_pathname
        except:
            self.__field_pathname=USTRING(**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })
        return self.__field_pathname.getvalue()

    def __setfield_pathname(self, value):
        if isinstance(value,USTRING):
            self.__field_pathname=value
        else:
            self.__field_pathname=USTRING(value,**{'sizeinbytes': 255,  'encoding': PHONE_ENCODING,                  'default': '' })

    def __delfield_pathname(self): del self.__field_pathname

    pathname=property(__getfield_pathname, __setfield_pathname, __delfield_pathname, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pathname', self.__field_pathname, None)




class GroupPicID_PathIndexFile(BaseProtogenClass):
    __fields=['items']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(GroupPicID_PathIndexFile,self).__init__(**dict)
        if self.__class__ is GroupPicID_PathIndexFile:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(GroupPicID_PathIndexFile,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(GroupPicID_PathIndexFile,kwargs)
        if len(args):
            dict2={ 'elementclass': GroupPicID_PathIndexEntry,             'raiseonincompleteread': False,             'createdefault': True}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_items=LIST(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': GroupPicID_PathIndexEntry,             'raiseonincompleteread': False,             'createdefault': True})
        self.__field_items.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_items=LIST(**{ 'elementclass': GroupPicID_PathIndexEntry,             'raiseonincompleteread': False,             'createdefault': True})
        self.__field_items.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{ 'elementclass': GroupPicID_PathIndexEntry,             'raiseonincompleteread': False,             'createdefault': True})
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{ 'elementclass': GroupPicID_PathIndexEntry,             'raiseonincompleteread': False,             'createdefault': True})

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('items', self.__field_items, None)




