;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.

;; RUN: foreach %s %t wasm-opt -O2 --skip-pass=coalesce-locals --skip-pass=simplify-locals --skip-pass=simplify-locals-nostructure -S -o - 2>&1 | filecheck %s

;; Check that we can skip several passes. Note that no local.tee is introduced.

(module
 ;; CHECK:      (import "a" "b" (func $log (param i32 i32)))
 (import "a" "b" (func $log (param i32 i32)))

 ;; CHECK:      (func $foo (param $p i32)
 ;; CHECK-NEXT:  (local $x i32)
 ;; CHECK-NEXT:  (local $y i32)
 ;; CHECK-NEXT:  (local.set $x
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (local.get $p)
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call $log
 ;; CHECK-NEXT:   (local.get $x)
 ;; CHECK-NEXT:   (local.get $x)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (local.set $y
 ;; CHECK-NEXT:   (i32.add
 ;; CHECK-NEXT:    (local.get $p)
 ;; CHECK-NEXT:    (i32.const 1)
 ;; CHECK-NEXT:   )
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call $log
 ;; CHECK-NEXT:   (local.get $y)
 ;; CHECK-NEXT:   (local.get $y)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $foo (export "foo") (param $p i32)
  ;; The locals $x and $y can be coalesced into a single local, but as
  ;; we do not run that pass, they will not be. They could be
  ;; initialized using a tee but the passes that introduce tees are
  ;; not run either.
  (local $x i32)
  (local $y i32)

  (local.set $x
   (i32.add
    (local.get $p)
    (i32.const 1)
   )
  )
  (call $log
   (local.get $x)
   (local.get $x)
  )

  (local.set $y
   (i32.add
    (local.get $p)
    (i32.const 1)
   )
  )
  (call $log
   (local.get $y)
   (local.get $y)
  )
 )
)
