# Beangulp Example

This directory contains an example for how to organize yourself and your files
to automate your Beancount ledger update. See
http://furius.ca/beancount/doc/beangulp for a fuller documentation and
discussion of these files.

## Example Files Organization - Sophisticated

There are five directories demonstrated here:

* `ledger`: This is a directory, typically a repository under source
  control, containing your Beancount ledger files.

* `documents`: This is a directory containing archived imported files.
  The directory hierarchy mirrors the structure of the accounts in the
  ledger and is constructed by the "archive" command which can also
  automatically date and rename the files and place them in the
  correct location after you have finished updating your Beancount
  ledger.

* `importers`: This is a directory, typically a repository under
  source control, containing your custom importers implementation.
  Note that in the most general case this does not include examples of
  your downloaded files nor any personal account-specific information,
  because you may want to share your importers with others.

* `tests`: This directory contains examples of real downloaded files
  from your institutions which will serve as regression tests.  Next
  to each downloaded file is a `.beancount` golden file with the
  correct contents extracted by the importer.  Those should be
  generated by the "generate" command from the importer and eyeballed
  for correctness.  Running the "test" after a change of your importer
  code will verify the importer's updated output agains the existing
  golden files.  This is a really fast way to add some testing and
  regression detection around your custom importer code.

* `Downloads`: This is the location where your browser might drop the
  files dowloaded from your statement sources.


## Example Files Organization - Simpler

Note that you could further simplify and merge some of these together for your
convenience. The example above shows that in the most general case you could
store all of these things separately. In fact, the first four directories could
all be stored to a single repository, if you wanted to keep things really
simple. We recommend you start that way, especially if all the information is
overwhelming.

Here's an example for how you could start with all your files in one directory:

    ledger/
    ├── import.py
    ├── ledger.beancount
    ├── importers
    │   ├── acme
    │   │   ├── acmebank1.pdf
    │   │   ├── acmebank1.pdf.beancount
    │   │   └── acme.py
    │   └── utrade
    │       ├── UTrade20140713.csv
    │       ├── UTrade20140713.csv.beancount
    │       ├── UTrade20150225.csv
    │       ├── UTrade20150225.csv.beancount
    │       ├── UTrade20150720.csv
    │       ├── UTrade20150720.csv.beancount
    │       └── utrade.py
    └── documents
        ├── Assets
        │   └── US
        │       ├── AcmeBank
        │       └── UTrade
        │           └── ...
        ├── Expenses
        ├── Income
        └── Liabilities
            └── US
                └── CreditCard
                    └── ...

## How to run this example

The below steps have been tested with Linux and Windows Subsystem for Linux (WSL1/2).

Clone the example from beangulp and cd into the folder:

```bash
git clone git@github.com:beancount/beangulp.git
cd beangulp/examples
```

Install beangulp and beancount in a `.venv`.

```bash
apt-get install python3-venv # required for virtual env
python3 -m venv .venv # create in subfolder called ".venv"
source ./.venv/bin/activate
pip install beangulp beancount
```

At this stage, make sure you are not installing fava (`pip install beangulp beancount 
fava`) because this still has beancount v2.3.6 pinned (if you need fava, install 
in a different venv).

Also, if you want to run the example folder fully, including pdf2text extraction, 
install the following dependencies for pdftotext:

```bash
apt-get install poppler-utils
```

Now run beancount with the beangulp importer:

```bash
python import.py extract ./Downloads > tmp.beancount
```