------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--                         G N A T P P . S T A C S                          --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                     Copyright (C) 2001-2013, AdaCore                     --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write to the Free Software Foundation,  51 Franklin Street, Fifth Floor, --
-- Boston, MA 02110-1301, USA.                                              --
--                                                                          --
-- GNATPP is maintained by AdaCore (http://www.adacore.com)                 --
--                                                                          --
------------------------------------------------------------------------------

--  Defines the general unlimited stack abstraction to be used in
--  pretty-printer

generic

   type Element_Type is private;

   No_Element : Element_Type;

package GNATPP.Stacs is

   --  Element_Type is the type of the stack elements

   --  No_Element is the special value to be returned in case if the state of
   --  the stack does not allow the given operation to return any meaningful
   --  result
   --  ??? Do we need this

   --  We do not define the stack type - at least now, when we do not need
   --  different stacks for the same element type

   procedure Push (Elem : Element_Type);
   --  Places Elem on the top of the stack

   function Pop return Element_Type;
   --  Returns the top element of the stack and removes this element from
   --  the stack. Returns No_Element if the stack is empty

   procedure Pop;
   --  Removes the top element from the stack. Does nothing if the stack
   --  is empty

   function Top (Step_Down : Natural := 0) return Element_Type;
   --  Returns the top element of the stack without removing this element from
   --  the stack. Returns No_Element if the stack is empty. If Step_Down is
   --  not 0, returns the Element which is Step_Down steps to the bottom of the
   --  stack, except if the stack depth is less than Step_Down, otherwise
   --  No_Element is returned

   function Size return Natural;
   --  Returns the number of elements in the stack

   function Is_Empty return Boolean;
   --  Same as Size = 0

end GNATPP.Stacs;
