/* antimicrox Gamepad to KB+M event mapper
 * Copyright (C) 2015 Travis Nickles <nickles.travis@gmail.com>
 * Copyright (C) 2020 Jagoda Górska <juliagoda.pl@protonmail>
 * Copyright (C) 2020 Paweł Kotiuk <kotiuk@zohomail.eu>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "qkeydisplaydialog.h"

#include <QtTest/QtTest>

/*

label->text() cannot be empty
buttonBox->Close cannot be disabled
nativeTitleLabel->text() == tr("Native Key Value:")
qtKeyTitleLabel->text() == tr("Qt Key Value:")
antiTitleLabel->text() == tr("AntiMicroX Key Value:")
label->text() is all visible
label->text() contains <a href="http://doc.qt.io/qt-5/qt.html#Key-enum">
label->text() contains <a href="https://github.com/AntiMicroX/antimicrox/">
nativeKeyLabel->text() at the start is 0x00000000 or empty
qtKeyLabel->text() at the start is 0x00000000 or empty
antimicroKeyLabel->text() at the start is 0x00000000 or empty



run keyReleaseEvent(QKeyEvent *event) for all keys, that are physically present:

// qnamespace.h -> enum Key { contains all adresses of keys in Qt
// keysymdef.h and XF86keysym.h contain adresses of keys in X11
// input-event-codes.h contains addresses of keys in uinput

if int virtualkey = event->nativeVirtualKey() is != 0

if it's X11
if X11Extras::getInstance()->getGroup1KeySym(virtualkey) > 0 then check out if

if it's uinput
QtKeyMapperBase *nativeKeyMapper = AntKeyMapper::getInstance()->getNativeKeyMapper();
int tempalias = nativeKeyMapper->returnQtKey(virtualkey);
if AntKeyMapper::getInstance()->returnVirtualKey(tempalias) > 0 then check out if

ui->nativeKeyLabel->text() == QString("0x%1").arg(finalvirtual, 0, 16)
ui->qtKeyLabel->text() == QString("0x%1").arg(event->key(), 0, 16)
ui->antimicroKeyLabel->text() == QString("0x%1").arg(AntKeyMapper::getInstance()->returnQtKey(finalvirtual), 0, 16)

*/

class TestQKeyDisplayDialog: public QObject
{
    Q_OBJECT

public:
    TestQKeyDisplayDialog(QObject* parent = 0);

private slots:

private:
    QKeyDisplayDialog qkeydisplaydialog;
};

TestQKeyDisplayDialog::TestQKeyDisplayDialog(QObject* parent) :
    QObject(parent),
    QKeyDisplayDialog()
{
    QTestEventLoop::instance().enterLoop(1);
}

// QTEST_MAIN(TestQKeyDisplayDialog)
#include "testqkeydisplaydialog.moc"

