/*************************************************************************************
 *  Copyright (C) 2014 by Percy Camilo T. Aucahuasi <percy.camilo.ta@gmail.com>      *
 *                                                                                   *
 *  This program is free software; you can redistribute it and/or                    *
 *  modify it under the terms of the GNU General Public License                      *
 *  as published by the Free Software Foundation; either version 2                   *
 *  of the License, or (at your option) any later version.                           *
 *                                                                                   *
 *  This program is distributed in the hope that it will be useful,                  *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of                   *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                    *
 *  GNU General Public License for more details.                                     *
 *                                                                                   *
 *  You should have received a copy of the GNU General Public License                *
 *  along with this program; if not, write to the Free Software                      *
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA   *
 *************************************************************************************/

#ifndef ADDITIONCHAINS_H
#define ADDITIONCHAINS_H

//NOTE this code generates the whole thing ... 
// see seq function in 
// https://rosettacode.org/wiki/Addition-chain_exponentiation/Achain.c or
// https://www-cs-faculty.stanford.edu/~knuth/programs/achain4.w
// int main(int argc, char *argv[])
// {
//   const int MAX_N = 2048;
//   const int MAX_LEN = 15;
//   const int MAX_COL = MAX_LEN+1;
//   // seq len of max(1,2,...,MAX_N) is MAX_LEN but we need one additional slot for len (length) info (at 0) so we need MAX_COL cols
//   int buffer[MAX_N+1] = {0};
//   
//   printf("static const int additionChains[%d][%d] = {\n", MAX_N+1, MAX_COL+1);
//   for (int k = 0; k <= MAX_N; ++k) {
//     int l = k==0? 0 : k==1? 0 : seq(k, 0, buffer);
//     printf("{%d,", l);
//     
//     for (int i = 0; i < MAX_COL; ++i) {
//       if (i <= l)
//         printf("%d%s", buffer[i], i == MAX_COL-1 ? "},\n" : ",");
//       else {
//         if (k != MAX_N)
//           printf("%d%s", 0, i == MAX_COL-1 ? "},\n" : ",");
//         else
//           printf("%d%s", 0, i == MAX_COL-1 ? "}};\n" : ",");
//       }
//     }
//   }
//   
//   return 0;
// }

//NOTE we have cached 2049 sequences of addition chains (2048 plus a slot for zero)
// e.g. additionChains[124][0] is the length of a valid sequence (without 
// trailing zeros) for the number 124

const int MAX_EXPONENT = 2048;

static const int additionChains[MAX_EXPONENT+1][17] = {
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{1,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
{2,1,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0},
{2,1,2,4,0,0,0,0,0,0,0,0,0,0,0,0,0},
{3,1,2,4,5,0,0,0,0,0,0,0,0,0,0,0,0},
{3,1,2,4,6,0,0,0,0,0,0,0,0,0,0,0,0},
{4,1,2,4,6,7,0,0,0,0,0,0,0,0,0,0,0},
{3,1,2,4,8,0,0,0,0,0,0,0,0,0,0,0,0},
{4,1,2,4,8,9,0,0,0,0,0,0,0,0,0,0,0},
{4,1,2,4,8,10,0,0,0,0,0,0,0,0,0,0,0},
{5,1,2,4,8,10,11,0,0,0,0,0,0,0,0,0,0},
{4,1,2,4,8,12,0,0,0,0,0,0,0,0,0,0,0},
{5,1,2,4,8,12,13,0,0,0,0,0,0,0,0,0,0},
{5,1,2,4,8,12,14,0,0,0,0,0,0,0,0,0,0},
{5,1,2,3,6,12,15,0,0,0,0,0,0,0,0,0,0},
{4,1,2,4,8,16,0,0,0,0,0,0,0,0,0,0,0},
{5,1,2,4,8,16,17,0,0,0,0,0,0,0,0,0,0},
{5,1,2,4,8,16,18,0,0,0,0,0,0,0,0,0,0},
{6,1,2,4,8,16,18,19,0,0,0,0,0,0,0,0,0},
{5,1,2,4,8,16,20,0,0,0,0,0,0,0,0,0,0},
{6,1,2,4,8,16,20,21,0,0,0,0,0,0,0,0,0},
{6,1,2,4,8,16,20,22,0,0,0,0,0,0,0,0,0},
{6,1,2,3,5,10,20,23,0,0,0,0,0,0,0,0,0},
{5,1,2,4,8,16,24,0,0,0,0,0,0,0,0,0,0},
{6,1,2,4,8,16,24,25,0,0,0,0,0,0,0,0,0},
{6,1,2,4,8,16,24,26,0,0,0,0,0,0,0,0,0},
{6,1,2,3,6,12,24,27,0,0,0,0,0,0,0,0,0},
{6,1,2,4,8,16,24,28,0,0,0,0,0,0,0,0,0},
{7,1,2,4,8,16,24,28,29,0,0,0,0,0,0,0,0},
{6,1,2,4,6,12,24,30,0,0,0,0,0,0,0,0,0},
{7,1,2,4,6,12,24,30,31,0,0,0,0,0,0,0,0},
{5,1,2,4,8,16,32,0,0,0,0,0,0,0,0,0,0},
{6,1,2,4,8,16,32,33,0,0,0,0,0,0,0,0,0},
{6,1,2,4,8,16,32,34,0,0,0,0,0,0,0,0,0},
{7,1,2,4,8,16,32,34,35,0,0,0,0,0,0,0,0},
{6,1,2,4,8,16,32,36,0,0,0,0,0,0,0,0,0},
{7,1,2,4,8,16,32,36,37,0,0,0,0,0,0,0,0},
{7,1,2,4,8,16,32,36,38,0,0,0,0,0,0,0,0},
{7,1,2,3,6,12,24,36,39,0,0,0,0,0,0,0,0},
{6,1,2,4,8,16,32,40,0,0,0,0,0,0,0,0,0},
{7,1,2,4,8,16,32,40,41,0,0,0,0,0,0,0,0},
{7,1,2,4,8,16,32,40,42,0,0,0,0,0,0,0,0},
{7,1,2,3,5,10,20,40,43,0,0,0,0,0,0,0,0},
{7,1,2,4,8,16,32,40,44,0,0,0,0,0,0,0,0},
{7,1,2,4,5,10,20,40,45,0,0,0,0,0,0,0,0},
{7,1,2,4,6,10,20,40,46,0,0,0,0,0,0,0,0},
{8,1,2,4,6,10,20,40,46,47,0,0,0,0,0,0,0},
{6,1,2,4,8,16,32,48,0,0,0,0,0,0,0,0,0},
{7,1,2,4,8,16,32,48,49,0,0,0,0,0,0,0,0},
{7,1,2,4,8,16,32,48,50,0,0,0,0,0,0,0,0},
{7,1,2,3,6,12,24,48,51,0,0,0,0,0,0,0,0},
{7,1,2,4,8,16,32,48,52,0,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,48,52,53,0,0,0,0,0,0,0},
{7,1,2,4,6,12,24,48,54,0,0,0,0,0,0,0,0},
{8,1,2,4,6,12,24,48,54,55,0,0,0,0,0,0,0},
{7,1,2,4,8,16,32,48,56,0,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,48,56,57,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,48,56,58,0,0,0,0,0,0,0},
{8,1,2,3,6,12,14,28,56,59,0,0,0,0,0,0,0},
{7,1,2,4,8,12,24,48,60,0,0,0,0,0,0,0,0},
{8,1,2,4,8,12,24,48,60,61,0,0,0,0,0,0,0},
{8,1,2,4,8,12,24,48,60,62,0,0,0,0,0,0,0},
{8,1,2,3,6,12,24,48,60,63,0,0,0,0,0,0,0},
{6,1,2,4,8,16,32,64,0,0,0,0,0,0,0,0,0},
{7,1,2,4,8,16,32,64,65,0,0,0,0,0,0,0,0},
{7,1,2,4,8,16,32,64,66,0,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,66,67,0,0,0,0,0,0,0},
{7,1,2,4,8,16,32,64,68,0,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,68,69,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,68,70,0,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,68,70,71,0,0,0,0,0,0},
{7,1,2,4,8,16,32,64,72,0,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,72,73,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,72,74,0,0,0,0,0,0,0},
{8,1,2,3,6,12,24,48,72,75,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,72,76,0,0,0,0,0,0,0},
{8,1,2,4,5,9,18,36,72,77,0,0,0,0,0,0,0},
{8,1,2,4,6,12,24,48,72,78,0,0,0,0,0,0,0},
{9,1,2,4,6,12,24,48,72,78,79,0,0,0,0,0,0},
{7,1,2,4,8,16,32,64,80,0,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,80,81,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,80,82,0,0,0,0,0,0,0},
{8,1,2,3,5,10,20,40,80,83,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,80,84,0,0,0,0,0,0,0},
{8,1,2,4,5,10,20,40,80,85,0,0,0,0,0,0,0},
{8,1,2,4,6,10,20,40,80,86,0,0,0,0,0,0,0},
{9,1,2,4,6,10,20,40,80,86,87,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,80,88,0,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,80,88,89,0,0,0,0,0,0},
{8,1,2,4,8,10,20,40,80,90,0,0,0,0,0,0,0},
{9,1,2,4,8,10,20,40,80,90,91,0,0,0,0,0,0},
{8,1,2,4,8,12,20,40,80,92,0,0,0,0,0,0,0},
{9,1,2,4,8,12,20,40,80,92,93,0,0,0,0,0,0},
{9,1,2,4,8,12,20,40,80,92,94,0,0,0,0,0,0},
{9,1,2,3,5,10,20,23,46,92,95,0,0,0,0,0,0},
{7,1,2,4,8,16,32,64,96,0,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,96,97,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,96,98,0,0,0,0,0,0,0},
{8,1,2,3,6,12,24,48,96,99,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,96,100,0,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,96,100,101,0,0,0,0,0,0},
{8,1,2,4,6,12,24,48,96,102,0,0,0,0,0,0,0},
{9,1,2,4,6,12,24,48,96,102,103,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,96,104,0,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,96,104,105,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,96,104,106,0,0,0,0,0,0},
{9,1,2,3,6,12,24,26,52,104,107,0,0,0,0,0,0},
{8,1,2,4,8,12,24,48,96,108,0,0,0,0,0,0,0},
{9,1,2,4,8,12,24,48,96,108,109,0,0,0,0,0,0},
{9,1,2,4,8,12,24,48,96,108,110,0,0,0,0,0,0},
{9,1,2,3,6,12,24,48,96,108,111,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,96,112,0,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,96,112,113,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,96,112,114,0,0,0,0,0,0},
{9,1,2,3,6,12,14,28,56,112,115,0,0,0,0,0,0},
{9,1,2,3,4,7,14,28,56,112,116,0,0,0,0,0,0},
{9,1,2,4,5,10,14,28,56,112,117,0,0,0,0,0,0},
{9,1,2,4,6,12,24,28,56,112,118,0,0,0,0,0,0},
{9,1,2,4,6,7,14,28,56,112,119,0,0,0,0,0,0},
{8,1,2,4,8,16,24,48,96,120,0,0,0,0,0,0,0},
{9,1,2,4,8,16,24,48,96,120,121,0,0,0,0,0,0},
{9,1,2,4,8,16,24,48,96,120,122,0,0,0,0,0,0},
{9,1,2,3,6,12,24,48,96,120,123,0,0,0,0,0,0},
{9,1,2,4,8,16,24,48,96,120,124,0,0,0,0,0,0},
{9,1,2,4,5,10,20,40,80,120,125,0,0,0,0,0,0},
{9,1,2,4,6,12,24,48,96,120,126,0,0,0,0,0,0},
{10,1,2,4,6,12,24,48,96,120,126,127,0,0,0,0,0},
{7,1,2,4,8,16,32,64,128,0,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,128,129,0,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,128,130,0,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,130,131,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,128,132,0,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,132,133,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,132,134,0,0,0,0,0,0},
{9,1,2,3,6,12,15,30,60,120,135,0,0,0,0,0,0},
{8,1,2,4,8,16,32,64,128,136,0,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,136,137,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,136,138,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,136,138,139,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,136,140,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,136,140,141,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,136,140,142,0,0,0,0,0},
{10,1,2,3,5,10,20,40,80,120,140,143,0,0,0,0,0},
{8,1,2,4,8,16,32,64,128,144,0,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,144,145,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,144,146,0,0,0,0,0,0},
{9,1,2,3,6,12,24,48,96,144,147,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,144,148,0,0,0,0,0,0},
{9,1,2,4,5,9,18,36,72,144,149,0,0,0,0,0,0},
{9,1,2,4,6,12,24,48,96,144,150,0,0,0,0,0,0},
{10,1,2,4,6,12,24,48,96,144,150,151,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,144,152,0,0,0,0,0,0},
{9,1,2,4,8,9,18,36,72,144,153,0,0,0,0,0,0},
{9,1,2,4,8,10,18,36,72,144,154,0,0,0,0,0,0},
{10,1,2,4,8,10,18,36,72,144,154,155,0,0,0,0,0},
{9,1,2,4,8,12,24,48,96,144,156,0,0,0,0,0,0},
{10,1,2,4,8,12,24,48,96,144,156,157,0,0,0,0,0},
{10,1,2,4,8,12,24,48,96,144,156,158,0,0,0,0,0},
{10,1,2,3,6,12,24,48,96,144,156,159,0,0,0,0,0},
{8,1,2,4,8,16,32,64,128,160,0,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,160,161,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,160,162,0,0,0,0,0,0},
{9,1,2,3,5,10,20,40,80,160,163,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,160,164,0,0,0,0,0,0},
{9,1,2,4,5,10,20,40,80,160,165,0,0,0,0,0,0},
{9,1,2,4,6,10,20,40,80,160,166,0,0,0,0,0,0},
{10,1,2,4,6,10,20,40,80,160,166,167,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,160,168,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,160,168,169,0,0,0,0,0},
{9,1,2,4,8,10,20,40,80,160,170,0,0,0,0,0,0},
{10,1,2,4,8,10,20,40,80,160,170,171,0,0,0,0,0},
{9,1,2,4,8,12,20,40,80,160,172,0,0,0,0,0,0},
{10,1,2,4,8,12,20,40,80,160,172,173,0,0,0,0,0},
{10,1,2,4,8,12,20,40,80,160,172,174,0,0,0,0,0},
{10,1,2,3,5,10,20,40,43,86,172,175,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,160,176,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,160,176,177,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,160,176,178,0,0,0,0,0},
{10,1,2,3,5,10,20,22,44,88,176,179,0,0,0,0,0},
{9,1,2,4,8,16,20,40,80,160,180,0,0,0,0,0,0},
{10,1,2,4,8,16,20,40,80,160,180,181,0,0,0,0,0},
{10,1,2,4,8,16,20,40,80,160,180,182,0,0,0,0,0},
{10,1,2,3,5,10,20,40,80,160,180,183,0,0,0,0,0},
{9,1,2,4,8,16,24,40,80,160,184,0,0,0,0,0,0},
{10,1,2,4,8,16,24,40,80,160,184,185,0,0,0,0,0},
{10,1,2,4,8,16,24,40,80,160,184,186,0,0,0,0,0},
{10,1,2,3,5,10,20,23,46,92,184,187,0,0,0,0,0},
{10,1,2,4,8,16,24,40,80,160,184,188,0,0,0,0,0},
{10,1,2,3,5,10,20,23,46,92,184,189,0,0,0,0,0},
{10,1,2,4,6,10,20,40,46,92,184,190,0,0,0,0,0},
{11,1,2,4,6,10,20,40,46,92,184,190,191,0,0,0,0},
{8,1,2,4,8,16,32,64,128,192,0,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,192,193,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,192,194,0,0,0,0,0,0},
{9,1,2,3,6,12,24,48,96,192,195,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,192,196,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,192,196,197,0,0,0,0,0},
{9,1,2,4,6,12,24,48,96,192,198,0,0,0,0,0,0},
{10,1,2,4,6,12,24,48,96,192,198,199,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,192,200,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,192,200,201,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,192,200,202,0,0,0,0,0},
{10,1,2,3,5,10,20,40,80,160,200,203,0,0,0,0,0},
{9,1,2,4,8,12,24,48,96,192,204,0,0,0,0,0,0},
{10,1,2,4,8,12,24,48,96,192,204,205,0,0,0,0,0},
{10,1,2,4,8,12,24,48,96,192,204,206,0,0,0,0,0},
{10,1,2,3,6,12,24,48,96,192,204,207,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,192,208,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,192,208,209,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,192,208,210,0,0,0,0,0},
{10,1,2,3,6,12,24,26,52,104,208,211,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,192,208,212,0,0,0,0,0},
{10,1,2,3,5,10,13,26,52,104,208,213,0,0,0,0,0},
{10,1,2,4,6,12,24,48,52,104,208,214,0,0,0,0,0},
{10,1,2,4,6,7,13,26,52,104,208,215,0,0,0,0,0},
{9,1,2,4,8,16,24,48,96,192,216,0,0,0,0,0,0},
{10,1,2,4,8,16,24,48,96,192,216,217,0,0,0,0,0},
{10,1,2,4,8,16,24,48,96,192,216,218,0,0,0,0,0},
{10,1,2,3,6,12,24,48,96,192,216,219,0,0,0,0,0},
{10,1,2,4,8,16,24,48,96,192,216,220,0,0,0,0,0},
{10,1,2,4,5,9,18,36,72,144,216,221,0,0,0,0,0},
{10,1,2,4,6,12,24,48,96,192,216,222,0,0,0,0,0},
{11,1,2,4,6,12,24,48,96,192,216,222,223,0,0,0,0},
{9,1,2,4,8,16,32,64,128,192,224,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,192,224,225,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,192,224,226,0,0,0,0,0},
{10,1,2,3,6,12,14,28,56,112,224,227,0,0,0,0,0},
{10,1,2,3,4,7,14,28,56,112,224,228,0,0,0,0,0},
{10,1,2,4,5,10,14,28,56,112,224,229,0,0,0,0,0},
{10,1,2,4,6,12,24,28,56,112,224,230,0,0,0,0,0},
{10,1,2,4,6,7,14,28,56,112,224,231,0,0,0,0,0},
{10,1,2,4,6,8,14,28,56,112,224,232,0,0,0,0,0},
{10,1,2,4,5,9,14,28,56,112,224,233,0,0,0,0,0},
{10,1,2,4,8,10,20,28,56,112,224,234,0,0,0,0,0},
{11,1,2,4,8,10,20,28,56,112,224,234,235,0,0,0,0},
{10,1,2,4,8,12,24,48,56,112,224,236,0,0,0,0,0},
{11,1,2,4,8,12,24,48,56,112,224,236,237,0,0,0,0},
{10,1,2,4,8,12,14,28,56,112,224,238,0,0,0,0,0},
{11,1,2,4,8,12,14,28,56,112,224,238,239,0,0,0,0},
{9,1,2,4,8,16,32,48,96,192,240,0,0,0,0,0,0},
{10,1,2,4,8,16,32,48,96,192,240,241,0,0,0,0,0},
{10,1,2,4,8,16,32,48,96,192,240,242,0,0,0,0,0},
{10,1,2,3,6,12,24,48,96,192,240,243,0,0,0,0,0},
{10,1,2,4,8,16,32,48,96,192,240,244,0,0,0,0,0},
{10,1,2,4,5,10,20,40,80,160,240,245,0,0,0,0,0},
{10,1,2,4,6,12,24,48,96,192,240,246,0,0,0,0,0},
{11,1,2,4,6,12,24,48,96,192,240,246,247,0,0,0,0},
{10,1,2,4,8,16,32,48,96,192,240,248,0,0,0,0,0},
{10,1,2,3,6,9,15,30,60,120,240,249,0,0,0,0,0},
{10,1,2,4,8,10,20,40,80,160,240,250,0,0,0,0,0},
{11,1,2,4,8,10,20,40,80,160,240,250,251,0,0,0,0},
{10,1,2,4,8,12,24,48,96,192,240,252,0,0,0,0,0},
{11,1,2,4,8,12,24,48,96,192,240,252,253,0,0,0,0},
{11,1,2,4,8,12,24,48,96,192,240,252,254,0,0,0,0},
{10,1,2,3,6,12,15,30,60,120,240,255,0,0,0,0,0},
{8,1,2,4,8,16,32,64,128,256,0,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,256,257,0,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,256,258,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,258,259,0,0,0,0,0},
{9,1,2,4,8,16,32,64,128,256,260,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,260,261,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,260,262,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,260,262,263,0,0,0,0},
{9,1,2,4,8,16,32,64,128,256,264,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,264,265,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,264,266,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,264,266,267,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,264,268,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,264,268,269,0,0,0,0},
{10,1,2,4,6,12,24,30,60,120,240,270,0,0,0,0,0},
{11,1,2,4,6,12,24,30,60,120,240,270,271,0,0,0,0},
{9,1,2,4,8,16,32,64,128,256,272,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,272,273,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,272,274,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,272,274,275,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,272,276,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,272,276,277,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,272,276,278,0,0,0,0},
{11,1,2,3,6,12,24,36,60,120,240,276,279,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,272,280,0,0,0,0,0},
{10,1,2,4,8,9,17,34,68,136,272,281,0,0,0,0,0},
{11,1,2,4,8,9,17,34,68,136,272,281,282,0,0,0,0},
{11,1,2,4,8,9,17,34,68,136,272,281,283,0,0,0,0},
{11,1,2,3,4,7,14,28,56,112,224,280,284,0,0,0,0},
{11,1,2,4,8,9,17,34,68,136,272,281,285,0,0,0,0},
{11,1,2,4,6,10,20,40,80,160,240,280,286,0,0,0,0},
{11,1,2,4,6,7,14,28,56,112,224,280,287,0,0,0,0},
{9,1,2,4,8,16,32,64,128,256,288,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,288,289,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,288,290,0,0,0,0,0},
{10,1,2,3,6,12,24,48,96,192,288,291,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,288,292,0,0,0,0,0},
{10,1,2,4,5,9,18,36,72,144,288,293,0,0,0,0,0},
{10,1,2,4,6,12,24,48,96,192,288,294,0,0,0,0,0},
{11,1,2,4,6,12,24,48,96,192,288,294,295,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,288,296,0,0,0,0,0},
{10,1,2,4,8,9,18,36,72,144,288,297,0,0,0,0,0},
{10,1,2,4,8,10,18,36,72,144,288,298,0,0,0,0,0},
{11,1,2,4,8,10,18,36,72,144,288,298,299,0,0,0,0},
{10,1,2,4,8,12,24,48,96,192,288,300,0,0,0,0,0},
{11,1,2,4,8,12,24,48,96,192,288,300,301,0,0,0,0},
{11,1,2,4,8,12,24,48,96,192,288,300,302,0,0,0,0},
{11,1,2,3,6,12,24,48,96,192,288,300,303,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,288,304,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,288,304,305,0,0,0,0},
{10,1,2,4,8,16,18,36,72,144,288,306,0,0,0,0,0},
{11,1,2,4,8,16,18,36,72,144,288,306,307,0,0,0,0},
{10,1,2,4,8,16,20,36,72,144,288,308,0,0,0,0,0},
{11,1,2,4,8,16,20,36,72,144,288,308,309,0,0,0,0},
{11,1,2,4,8,16,20,36,72,144,288,308,310,0,0,0,0},
{11,1,2,4,5,9,18,36,72,144,288,306,311,0,0,0,0},
{10,1,2,4,8,16,24,48,96,192,288,312,0,0,0,0,0},
{11,1,2,4,8,16,24,48,96,192,288,312,313,0,0,0,0},
{11,1,2,4,8,16,24,48,96,192,288,312,314,0,0,0,0},
{11,1,2,3,6,12,24,48,96,192,288,312,315,0,0,0,0},
{11,1,2,4,8,16,24,48,96,192,288,312,316,0,0,0,0},
{11,1,2,3,5,10,13,26,52,104,208,312,317,0,0,0,0},
{11,1,2,4,6,12,24,48,96,192,288,312,318,0,0,0,0},
{11,1,2,4,6,7,13,26,52,104,208,312,319,0,0,0,0},
{9,1,2,4,8,16,32,64,128,256,320,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,320,321,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,320,322,0,0,0,0,0},
{10,1,2,3,5,10,20,40,80,160,320,323,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,320,324,0,0,0,0,0},
{10,1,2,4,5,10,20,40,80,160,320,325,0,0,0,0,0},
{10,1,2,4,6,10,20,40,80,160,320,326,0,0,0,0,0},
{11,1,2,4,6,10,20,40,80,160,320,326,327,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,320,328,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,320,328,329,0,0,0,0},
{10,1,2,4,8,10,20,40,80,160,320,330,0,0,0,0,0},
{11,1,2,4,8,10,20,40,80,160,320,330,331,0,0,0,0},
{10,1,2,4,8,12,20,40,80,160,320,332,0,0,0,0,0},
{11,1,2,4,8,12,20,40,80,160,320,332,333,0,0,0,0},
{11,1,2,4,8,12,20,40,80,160,320,332,334,0,0,0,0},
{11,1,2,3,5,10,20,40,80,83,166,332,335,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,320,336,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,320,336,337,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,320,336,338,0,0,0,0},
{11,1,2,3,6,12,24,48,96,192,288,336,339,0,0,0,0},
{10,1,2,4,8,16,20,40,80,160,320,340,0,0,0,0,0},
{11,1,2,4,8,16,20,40,80,160,320,340,341,0,0,0,0},
{11,1,2,4,8,16,20,40,80,160,320,340,342,0,0,0,0},
{11,1,2,3,5,10,20,40,80,160,320,340,343,0,0,0,0},
{10,1,2,4,8,16,24,40,80,160,320,344,0,0,0,0,0},
{11,1,2,4,8,16,24,40,80,160,320,344,345,0,0,0,0},
{11,1,2,4,8,16,24,40,80,160,320,344,346,0,0,0,0},
{11,1,2,3,5,10,20,40,43,86,172,344,347,0,0,0,0},
{11,1,2,4,8,16,24,40,80,160,320,344,348,0,0,0,0},
{11,1,2,3,5,10,20,40,43,86,172,344,349,0,0,0,0},
{11,1,2,4,6,10,20,40,80,86,172,344,350,0,0,0,0},
{11,1,2,3,6,12,15,30,42,84,168,336,351,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,320,352,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,320,352,353,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,320,352,354,0,0,0,0},
{11,1,2,3,5,10,20,22,44,88,176,352,355,0,0,0,0},
{11,1,2,3,4,8,11,22,44,88,176,352,356,0,0,0,0},
{11,1,2,4,5,10,20,40,44,88,176,352,357,0,0,0,0},
{11,1,2,4,5,6,11,22,44,88,176,352,358,0,0,0,0},
{11,1,2,3,4,7,11,22,44,88,176,352,359,0,0,0,0},
{10,1,2,4,8,16,32,40,80,160,320,360,0,0,0,0,0},
{11,1,2,4,8,16,32,40,80,160,320,360,361,0,0,0,0},
{11,1,2,4,8,16,32,40,80,160,320,360,362,0,0,0,0},
{11,1,2,3,5,10,20,40,80,160,320,360,363,0,0,0,0},
{11,1,2,4,8,16,32,40,80,160,320,360,364,0,0,0,0},
{11,1,2,4,5,10,20,40,80,160,320,360,365,0,0,0,0},
{11,1,2,4,6,10,20,40,80,160,320,360,366,0,0,0,0},
{11,1,2,3,5,10,20,23,43,86,172,344,367,0,0,0,0},
{10,1,2,4,8,16,32,48,80,160,320,368,0,0,0,0,0},
{11,1,2,4,8,16,32,48,80,160,320,368,369,0,0,0,0},
{11,1,2,4,8,16,32,48,80,160,320,368,370,0,0,0,0},
{11,1,2,3,5,10,20,23,46,92,184,368,371,0,0,0,0},
{11,1,2,4,8,16,32,48,80,160,320,368,372,0,0,0,0},
{11,1,2,3,5,10,20,23,46,92,184,368,373,0,0,0,0},
{11,1,2,4,6,10,20,40,46,92,184,368,374,0,0,0,0},
{11,1,2,3,6,12,15,30,60,120,240,360,375,0,0,0,0},
{11,1,2,4,8,16,32,48,80,160,320,368,376,0,0,0,0},
{11,1,2,4,5,9,18,23,46,92,184,368,377,0,0,0,0},
{11,1,2,4,6,10,20,40,46,92,184,368,378,0,0,0,0},
{12,1,2,4,6,10,20,40,46,92,184,368,378,379,0,0,0},
{11,1,2,4,8,12,20,40,80,92,184,368,380,0,0,0,0},
{11,1,2,3,5,10,13,23,46,92,184,368,381,0,0,0,0},
{11,1,2,4,5,9,14,23,46,92,184,368,382,0,0,0,0},
{12,1,2,4,5,9,14,23,46,92,184,368,382,383,0,0,0},
{9,1,2,4,8,16,32,64,128,256,384,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,384,385,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,384,386,0,0,0,0,0},
{10,1,2,3,6,12,24,48,96,192,384,387,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,384,388,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,384,388,389,0,0,0,0},
{10,1,2,4,6,12,24,48,96,192,384,390,0,0,0,0,0},
{11,1,2,4,6,12,24,48,96,192,384,390,391,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,384,392,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,384,392,393,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,384,392,394,0,0,0,0},
{11,1,2,3,6,12,24,48,96,98,196,392,395,0,0,0,0},
{10,1,2,4,8,12,24,48,96,192,384,396,0,0,0,0,0},
{11,1,2,4,8,12,24,48,96,192,384,396,397,0,0,0,0},
{11,1,2,4,8,12,24,48,96,192,384,396,398,0,0,0,0},
{11,1,2,3,6,12,24,48,96,192,384,396,399,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,384,400,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,384,400,401,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,384,400,402,0,0,0,0},
{11,1,2,3,5,10,20,40,80,160,320,400,403,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,384,400,404,0,0,0,0},
{11,1,2,4,5,10,20,40,80,160,320,400,405,0,0,0,0},
{11,1,2,4,6,10,20,40,80,160,320,400,406,0,0,0,0},
{12,1,2,4,6,10,20,40,80,160,320,400,406,407,0,0,0},
{10,1,2,4,8,16,24,48,96,192,384,408,0,0,0,0,0},
{11,1,2,4,8,16,24,48,96,192,384,408,409,0,0,0,0},
{11,1,2,4,8,16,24,48,96,192,384,408,410,0,0,0,0},
{11,1,2,3,6,12,24,48,96,192,384,408,411,0,0,0,0},
{11,1,2,4,8,16,24,48,96,192,384,408,412,0,0,0,0},
{11,1,2,4,8,12,13,25,50,100,200,400,413,0,0,0,0},
{11,1,2,4,6,12,24,48,96,192,384,408,414,0,0,0,0},
{11,1,2,4,5,10,15,25,50,100,200,400,415,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,384,416,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,384,416,417,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,384,416,418,0,0,0,0},
{11,1,2,3,6,12,24,26,52,104,208,416,419,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,384,416,420,0,0,0,0},
{11,1,2,3,5,10,13,26,52,104,208,416,421,0,0,0,0},
{11,1,2,4,6,12,24,48,52,104,208,416,422,0,0,0,0},
{11,1,2,4,6,7,13,26,52,104,208,416,423,0,0,0,0},
{11,1,2,3,5,8,13,26,52,104,208,416,424,0,0,0,0},
{11,1,2,4,8,9,18,26,52,104,208,416,425,0,0,0,0},
{11,1,2,4,6,10,20,26,52,104,208,416,426,0,0,0,0},
{12,1,2,4,6,10,20,26,52,104,208,416,426,427,0,0,0},
{11,1,2,4,8,12,24,48,96,104,208,416,428,0,0,0,0},
{11,1,2,4,8,12,13,26,52,104,208,416,429,0,0,0,0},
{11,1,2,4,8,12,14,26,52,104,208,416,430,0,0,0,0},
{12,1,2,4,8,12,14,26,52,104,208,416,430,431,0,0,0},
{10,1,2,4,8,16,32,48,96,192,384,432,0,0,0,0,0},
{11,1,2,4,8,16,32,48,96,192,384,432,433,0,0,0,0},
{11,1,2,4,8,16,32,48,96,192,384,432,434,0,0,0,0},
{11,1,2,3,6,12,24,48,96,192,384,432,435,0,0,0,0},
{11,1,2,4,8,16,32,48,96,192,384,432,436,0,0,0,0},
{11,1,2,4,5,9,18,36,72,144,288,432,437,0,0,0,0},
{11,1,2,4,6,12,24,48,96,192,384,432,438,0,0,0,0},
{12,1,2,4,6,12,24,48,96,192,384,432,438,439,0,0,0},
{11,1,2,4,8,16,32,48,96,192,384,432,440,0,0,0,0},
{11,1,2,4,8,9,18,36,72,144,288,432,441,0,0,0,0},
{11,1,2,4,8,10,18,36,72,144,288,432,442,0,0,0,0},
{12,1,2,4,8,10,18,36,72,144,288,432,442,443,0,0,0},
{11,1,2,4,8,12,24,48,96,192,384,432,444,0,0,0,0},
{12,1,2,4,8,12,24,48,96,192,384,432,444,445,0,0,0},
{12,1,2,4,8,12,24,48,96,192,384,432,444,446,0,0,0},
{11,1,2,3,6,12,15,27,54,108,216,432,447,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,384,448,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,384,448,449,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,384,448,450,0,0,0,0},
{11,1,2,3,6,12,14,28,56,112,224,448,451,0,0,0,0},
{11,1,2,3,4,7,14,28,56,112,224,448,452,0,0,0,0},
{11,1,2,4,5,10,14,28,56,112,224,448,453,0,0,0,0},
{11,1,2,4,6,12,24,28,56,112,224,448,454,0,0,0,0},
{11,1,2,4,6,7,14,28,56,112,224,448,455,0,0,0,0},
{11,1,2,4,6,8,14,28,56,112,224,448,456,0,0,0,0},
{11,1,2,4,5,9,14,28,56,112,224,448,457,0,0,0,0},
{11,1,2,4,8,10,20,28,56,112,224,448,458,0,0,0,0},
{11,1,2,3,6,12,24,27,54,108,216,432,459,0,0,0,0},
{11,1,2,4,8,12,24,48,56,112,224,448,460,0,0,0,0},
{12,1,2,4,8,12,24,48,56,112,224,448,460,461,0,0,0},
{11,1,2,4,8,12,14,28,56,112,224,448,462,0,0,0,0},
{12,1,2,4,8,12,14,28,56,112,224,448,462,463,0,0,0},
{11,1,2,4,8,12,16,28,56,112,224,448,464,0,0,0,0},
{12,1,2,4,8,12,16,28,56,112,224,448,464,465,0,0,0},
{11,1,2,4,8,10,18,28,56,112,224,448,466,0,0,0,0},
{12,1,2,4,8,10,18,28,56,112,224,448,466,467,0,0,0},
{11,1,2,4,8,16,20,40,56,112,224,448,468,0,0,0,0},
{12,1,2,4,8,16,20,40,56,112,224,448,468,469,0,0,0},
{12,1,2,4,8,16,20,40,56,112,224,448,468,470,0,0,0},
{12,1,2,3,6,12,24,36,72,144,288,432,468,471,0,0,0},
{11,1,2,4,8,16,24,48,96,112,224,448,472,0,0,0,0},
{12,1,2,4,8,16,24,48,96,112,224,448,472,473,0,0,0},
{12,1,2,4,8,16,24,48,96,112,224,448,472,474,0,0,0},
{12,1,2,3,6,12,14,28,56,112,224,236,472,475,0,0,0},
{11,1,2,4,8,16,24,28,56,112,224,448,476,0,0,0,0},
{12,1,2,4,8,16,24,28,56,112,224,448,476,477,0,0,0},
{12,1,2,4,8,16,24,28,56,112,224,448,476,478,0,0,0},
{12,1,2,3,6,12,14,28,56,112,224,448,476,479,0,0,0},
{10,1,2,4,8,16,32,64,96,192,384,480,0,0,0,0,0},
{11,1,2,4,8,16,32,64,96,192,384,480,481,0,0,0,0},
{11,1,2,4,8,16,32,64,96,192,384,480,482,0,0,0,0},
{11,1,2,3,6,12,24,48,96,192,384,480,483,0,0,0,0},
{11,1,2,4,8,16,32,64,96,192,384,480,484,0,0,0,0},
{11,1,2,4,5,10,20,40,80,160,320,480,485,0,0,0,0},
{11,1,2,4,6,12,24,48,96,192,384,480,486,0,0,0,0},
{12,1,2,4,6,12,24,48,96,192,384,480,486,487,0,0,0},
{11,1,2,4,8,16,32,64,96,192,384,480,488,0,0,0,0},
{11,1,2,3,6,9,15,30,60,120,240,480,489,0,0,0,0},
{11,1,2,4,8,10,20,40,80,160,320,480,490,0,0,0,0},
{12,1,2,4,8,10,20,40,80,160,320,480,490,491,0,0,0},
{11,1,2,4,8,12,24,48,96,192,384,480,492,0,0,0,0},
{12,1,2,4,8,12,24,48,96,192,384,480,492,493,0,0,0},
{12,1,2,4,8,12,24,48,96,192,384,480,492,494,0,0,0},
{11,1,2,3,6,12,15,30,60,120,240,480,495,0,0,0,0},
{11,1,2,4,8,16,32,64,96,192,384,480,496,0,0,0,0},
{12,1,2,4,8,16,32,64,96,192,384,480,496,497,0,0,0},
{11,1,2,4,6,12,18,30,60,120,240,480,498,0,0,0,0},
{12,1,2,4,6,12,18,30,60,120,240,480,498,499,0,0,0},
{11,1,2,4,8,16,20,40,80,160,320,480,500,0,0,0,0},
{12,1,2,4,8,16,20,40,80,160,320,480,500,501,0,0,0},
{12,1,2,4,8,16,20,40,80,160,320,480,500,502,0,0,0},
{12,1,2,3,5,10,20,40,80,160,320,480,500,503,0,0,0},
{11,1,2,4,8,16,24,48,96,192,384,480,504,0,0,0,0},
{12,1,2,4,8,16,24,48,96,192,384,480,504,505,0,0,0},
{12,1,2,4,8,16,24,48,96,192,384,480,504,506,0,0,0},
{12,1,2,3,6,12,24,48,96,192,384,480,504,507,0,0,0},
{12,1,2,3,4,7,14,28,56,112,224,448,504,508,0,0,0},
{12,1,2,4,5,10,14,28,56,112,224,448,504,509,0,0,0},
{11,1,2,4,6,12,24,30,60,120,240,480,510,0,0,0,0},
{12,1,2,4,6,12,24,30,60,120,240,480,510,511,0,0,0},
{9,1,2,4,8,16,32,64,128,256,512,0,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,512,513,0,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,512,514,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,514,515,0,0,0,0},
{10,1,2,4,8,16,32,64,128,256,512,516,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,516,517,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,516,518,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,516,518,519,0,0,0},
{10,1,2,4,8,16,32,64,128,256,512,520,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,520,521,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,520,522,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,520,522,523,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,520,524,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,520,524,525,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,520,524,526,0,0,0},
{12,1,2,3,6,8,16,32,64,128,256,262,524,527,0,0,0},
{10,1,2,4,8,16,32,64,128,256,512,528,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,528,529,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,528,530,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,528,530,531,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,528,532,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,528,532,533,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,528,532,534,0,0,0},
{12,1,2,3,5,8,16,32,64,128,133,266,532,535,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,528,536,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,528,536,537,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,528,536,538,0,0,0},
{12,1,2,3,6,8,16,32,64,128,134,268,536,539,0,0,0},
{11,1,2,4,8,12,24,48,60,120,240,480,540,0,0,0,0},
{12,1,2,4,8,12,24,48,60,120,240,480,540,541,0,0,0},
{12,1,2,4,8,12,24,48,60,120,240,480,540,542,0,0,0},
{12,1,2,3,6,12,24,48,60,120,240,480,540,543,0,0,0},
{10,1,2,4,8,16,32,64,128,256,512,544,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,544,545,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,544,546,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,544,546,547,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,544,548,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,544,548,549,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,544,548,550,0,0,0},
{12,1,2,4,6,7,14,28,34,68,136,272,544,551,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,544,552,0,0,0,0},
{11,1,2,4,8,9,17,34,68,136,272,544,553,0,0,0,0},
{12,1,2,4,8,9,17,34,68,136,272,544,553,554,0,0,0},
{12,1,2,4,8,9,17,34,68,136,272,544,553,555,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,544,552,556,0,0,0},
{12,1,2,4,8,9,17,34,68,136,272,544,553,557,0,0,0},
{12,1,2,4,6,12,24,48,72,120,240,480,552,558,0,0,0},
{12,1,2,4,5,10,15,30,34,68,136,272,544,559,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,544,560,0,0,0,0},
{11,1,2,4,8,16,17,34,68,136,272,544,561,0,0,0,0},
{11,1,2,4,8,16,18,34,68,136,272,544,562,0,0,0,0},
{12,1,2,4,8,16,18,34,68,136,272,544,562,563,0,0,0},
{12,1,2,4,8,16,18,34,68,136,272,544,562,564,0,0,0},
{12,1,2,4,8,16,17,34,68,136,272,544,561,565,0,0,0},
{12,1,2,4,8,16,18,34,68,136,272,544,562,566,0,0,0},
{12,1,2,4,6,7,14,28,56,112,224,448,560,567,0,0,0},
{12,1,2,4,6,8,14,28,56,112,224,448,560,568,0,0,0},
{12,1,2,4,8,16,17,34,68,136,272,544,561,569,0,0,0},
{12,1,2,4,8,16,18,34,68,136,272,544,562,570,0,0,0},
{12,1,2,4,8,9,17,34,68,136,272,281,562,571,0,0,0},
{12,1,2,4,8,12,20,40,80,160,320,480,560,572,0,0,0},
{12,1,2,4,8,9,13,26,35,70,140,280,560,573,0,0,0},
{12,1,2,4,8,12,14,28,56,112,224,448,560,574,0,0,0},
{12,1,2,4,5,10,15,30,60,70,140,280,560,575,0,0,0},
{10,1,2,4,8,16,32,64,128,256,512,576,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,576,577,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,576,578,0,0,0,0},
{11,1,2,3,6,12,24,48,96,192,384,576,579,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,576,580,0,0,0,0},
{11,1,2,4,5,9,18,36,72,144,288,576,581,0,0,0,0},
{11,1,2,4,6,12,24,48,96,192,384,576,582,0,0,0,0},
{12,1,2,4,6,12,24,48,96,192,384,576,582,583,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,576,584,0,0,0,0},
{11,1,2,4,8,9,18,36,72,144,288,576,585,0,0,0,0},
{11,1,2,4,8,10,18,36,72,144,288,576,586,0,0,0,0},
{12,1,2,4,8,10,18,36,72,144,288,576,586,587,0,0,0},
{11,1,2,4,8,12,24,48,96,192,384,576,588,0,0,0,0},
{12,1,2,4,8,12,24,48,96,192,384,576,588,589,0,0,0},
{12,1,2,4,8,12,24,48,96,192,384,576,588,590,0,0,0},
{12,1,2,3,6,12,24,48,96,192,384,576,588,591,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,576,592,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,576,592,593,0,0,0},
{11,1,2,4,8,16,18,36,72,144,288,576,594,0,0,0,0},
{12,1,2,4,8,16,18,36,72,144,288,576,594,595,0,0,0},
{11,1,2,4,8,16,20,36,72,144,288,576,596,0,0,0,0},
{12,1,2,4,8,16,20,36,72,144,288,576,596,597,0,0,0},
{12,1,2,4,8,16,20,36,72,144,288,576,596,598,0,0,0},
{12,1,2,4,5,9,18,36,72,144,288,576,594,599,0,0,0},
{11,1,2,4,8,16,24,48,96,192,384,576,600,0,0,0,0},
{12,1,2,4,8,16,24,48,96,192,384,576,600,601,0,0,0},
{12,1,2,4,8,16,24,48,96,192,384,576,600,602,0,0,0},
{12,1,2,3,6,12,24,48,96,192,384,576,600,603,0,0,0},
{12,1,2,4,8,16,24,48,96,192,384,576,600,604,0,0,0},
{12,1,2,4,5,10,20,40,80,120,240,480,600,605,0,0,0},
{12,1,2,4,6,12,24,48,96,192,384,576,600,606,0,0,0},
{13,1,2,4,6,12,24,48,96,192,384,576,600,606,607,0,0},
{11,1,2,4,8,16,32,64,128,256,512,576,608,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,576,608,609,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,576,608,610,0,0,0},
{12,1,2,3,6,12,24,26,52,76,152,304,608,611,0,0,0},
{11,1,2,4,8,16,32,36,72,144,288,576,612,0,0,0,0},
{12,1,2,4,8,16,32,36,72,144,288,576,612,613,0,0,0},
{12,1,2,4,8,16,32,36,72,144,288,576,612,614,0,0,0},
{12,1,2,3,6,12,24,36,72,144,288,576,612,615,0,0,0},
{11,1,2,4,8,16,32,40,72,144,288,576,616,0,0,0,0},
{12,1,2,4,8,16,32,40,72,144,288,576,616,617,0,0,0},
{12,1,2,4,8,16,32,40,72,144,288,576,616,618,0,0,0},
{12,1,2,3,6,8,11,19,38,76,152,304,608,619,0,0,0},
{12,1,2,4,8,16,32,40,72,144,288,576,616,620,0,0,0},
{12,1,2,4,5,9,18,36,72,77,154,308,616,621,0,0,0},
{12,1,2,4,8,10,18,36,72,144,288,576,612,622,0,0,0},
{12,1,2,4,5,10,15,19,38,76,152,304,608,623,0,0,0},
{11,1,2,4,8,16,32,48,96,192,384,576,624,0,0,0,0},
{12,1,2,4,8,16,32,48,96,192,384,576,624,625,0,0,0},
{12,1,2,4,8,16,32,48,96,192,384,576,624,626,0,0,0},
{12,1,2,3,6,12,24,48,96,192,384,576,624,627,0,0,0},
{12,1,2,4,8,16,32,48,96,192,384,576,624,628,0,0,0},
{12,1,2,3,5,10,13,26,52,104,208,416,624,629,0,0,0},
{12,1,2,4,6,12,24,48,96,192,384,576,624,630,0,0,0},
{12,1,2,4,6,7,13,26,52,104,208,416,624,631,0,0,0},
{12,1,2,3,5,8,13,26,52,104,208,416,624,632,0,0,0},
{12,1,2,4,8,9,18,26,52,104,208,416,624,633,0,0,0},
{12,1,2,4,6,10,20,26,52,104,208,416,624,634,0,0,0},
{13,1,2,4,6,10,20,26,52,104,208,416,624,634,635,0,0},
{12,1,2,4,8,12,24,48,96,192,384,576,624,636,0,0,0},
{12,1,2,4,8,12,13,26,52,104,208,416,624,637,0,0,0},
{12,1,2,4,8,12,14,26,52,104,208,416,624,638,0,0,0},
{12,1,2,3,6,9,15,30,39,78,156,312,624,639,0,0,0},
{10,1,2,4,8,16,32,64,128,256,512,640,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,640,641,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,640,642,0,0,0,0},
{11,1,2,3,5,10,20,40,80,160,320,640,643,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,640,644,0,0,0,0},
{11,1,2,4,5,10,20,40,80,160,320,640,645,0,0,0,0},
{11,1,2,4,6,10,20,40,80,160,320,640,646,0,0,0,0},
{12,1,2,4,6,10,20,40,80,160,320,640,646,647,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,640,648,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,640,648,649,0,0,0},
{11,1,2,4,8,10,20,40,80,160,320,640,650,0,0,0,0},
{12,1,2,4,8,10,20,40,80,160,320,640,650,651,0,0,0},
{11,1,2,4,8,12,20,40,80,160,320,640,652,0,0,0,0},
{12,1,2,4,8,12,20,40,80,160,320,640,652,653,0,0,0},
{12,1,2,4,8,12,20,40,80,160,320,640,652,654,0,0,0},
{12,1,2,3,5,10,20,40,80,160,163,326,652,655,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,640,656,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,640,656,657,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,640,656,658,0,0,0},
{12,1,2,3,5,10,20,40,80,82,164,328,656,659,0,0,0},
{11,1,2,4,8,16,20,40,80,160,320,640,660,0,0,0,0},
{12,1,2,4,8,16,20,40,80,160,320,640,660,661,0,0,0},
{12,1,2,4,8,16,20,40,80,160,320,640,660,662,0,0,0},
{12,1,2,3,5,10,20,40,80,160,320,640,660,663,0,0,0},
{11,1,2,4,8,16,24,40,80,160,320,640,664,0,0,0,0},
{12,1,2,4,8,16,24,40,80,160,320,640,664,665,0,0,0},
{12,1,2,4,8,16,24,40,80,160,320,640,664,666,0,0,0},
{12,1,2,3,5,10,20,40,80,83,166,332,664,667,0,0,0},
{12,1,2,4,8,16,24,40,80,160,320,640,664,668,0,0,0},
{12,1,2,3,5,10,20,40,80,83,166,332,664,669,0,0,0},
{12,1,2,4,6,10,20,40,80,160,166,332,664,670,0,0,0},
{13,1,2,4,6,10,20,40,80,160,166,332,664,670,671,0,0},
{11,1,2,4,8,16,32,64,128,256,512,640,672,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,640,672,673,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,640,672,674,0,0,0},
{12,1,2,3,6,12,24,48,96,192,384,576,672,675,0,0,0},
{12,1,2,3,4,7,14,28,56,112,224,448,672,676,0,0,0},
{12,1,2,4,5,10,14,28,56,112,224,448,672,677,0,0,0},
{12,1,2,4,6,12,24,48,96,192,384,576,672,678,0,0,0},
{12,1,2,4,6,7,14,28,56,112,224,448,672,679,0,0,0},
{11,1,2,4,8,16,32,40,80,160,320,640,680,0,0,0,0},
{12,1,2,4,8,16,32,40,80,160,320,640,680,681,0,0,0},
{12,1,2,4,8,16,32,40,80,160,320,640,680,682,0,0,0},
{12,1,2,3,5,10,20,40,80,160,320,640,680,683,0,0,0},
{12,1,2,4,8,16,32,40,80,160,320,640,680,684,0,0,0},
{12,1,2,4,5,10,20,40,80,160,320,640,680,685,0,0,0},
{12,1,2,4,6,10,20,40,80,160,320,640,680,686,0,0,0},
{12,1,2,3,6,12,15,30,42,84,168,336,672,687,0,0,0},
{11,1,2,4,8,16,32,48,80,160,320,640,688,0,0,0,0},
{12,1,2,4,8,16,32,48,80,160,320,640,688,689,0,0,0},
{12,1,2,4,8,16,32,48,80,160,320,640,688,690,0,0,0},
{12,1,2,3,5,10,20,40,43,86,172,344,688,691,0,0,0},
{12,1,2,4,8,16,32,48,80,160,320,640,688,692,0,0,0},
{12,1,2,3,5,10,20,40,43,86,172,344,688,693,0,0,0},
{12,1,2,4,6,10,20,40,80,86,172,344,688,694,0,0,0},
{13,1,2,4,6,10,20,40,80,86,172,344,688,694,695,0,0},
{12,1,2,4,8,16,32,48,80,160,320,640,688,696,0,0,0},
{12,1,2,4,8,9,17,34,43,86,172,344,688,697,0,0,0},
{12,1,2,4,6,10,20,40,80,86,172,344,688,698,0,0,0},
{12,1,2,3,6,12,15,27,42,84,168,336,672,699,0,0,0},
{12,1,2,4,8,12,20,40,80,160,172,344,688,700,0,0,0},
{13,1,2,4,8,12,20,40,80,160,172,344,688,700,701,0,0},
{12,1,2,4,6,12,24,30,60,84,168,336,672,702,0,0,0},
{13,1,2,4,6,12,24,30,60,84,168,336,672,702,703,0,0},
{11,1,2,4,8,16,32,64,128,256,512,640,704,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,640,704,705,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,640,704,706,0,0,0},
{12,1,2,3,5,10,20,22,44,88,176,352,704,707,0,0,0},
{12,1,2,3,4,8,11,22,44,88,176,352,704,708,0,0,0},
{12,1,2,4,5,10,20,40,44,88,176,352,704,709,0,0,0},
{12,1,2,4,5,6,11,22,44,88,176,352,704,710,0,0,0},
{12,1,2,3,4,7,11,22,44,88,176,352,704,711,0,0,0},
{12,1,2,4,6,8,16,22,44,88,176,352,704,712,0,0,0},
{12,1,2,4,8,9,18,36,44,88,176,352,704,713,0,0,0},
{12,1,2,4,8,10,20,40,80,88,176,352,704,714,0,0,0},
{12,1,2,4,8,10,11,22,44,88,176,352,704,715,0,0,0},
{12,1,2,4,8,10,12,22,44,88,176,352,704,716,0,0,0},
{12,1,2,4,8,9,13,22,44,88,176,352,704,717,0,0,0},
{12,1,2,4,6,8,14,22,44,88,176,352,704,718,0,0,0},
{13,1,2,4,6,8,14,22,44,88,176,352,704,718,719,0,0},
{11,1,2,4,8,16,32,64,80,160,320,640,720,0,0,0,0},
{12,1,2,4,8,16,32,64,80,160,320,640,720,721,0,0,0},
{12,1,2,4,8,16,32,64,80,160,320,640,720,722,0,0,0},
{12,1,2,3,5,10,20,40,80,160,320,640,720,723,0,0,0},
{12,1,2,4,8,16,32,64,80,160,320,640,720,724,0,0,0},
{12,1,2,4,5,10,20,40,80,160,320,640,720,725,0,0,0},
{12,1,2,4,6,10,20,40,80,160,320,640,720,726,0,0,0},
{13,1,2,4,6,10,20,40,80,160,320,640,720,726,727,0,0},
{12,1,2,4,8,16,32,64,80,160,320,640,720,728,0,0,0},
{12,1,2,4,8,9,18,36,72,144,288,576,720,729,0,0,0},
{12,1,2,4,8,10,20,40,80,160,320,640,720,730,0,0,0},
{12,1,2,3,5,10,20,40,43,86,172,344,688,731,0,0,0},
{12,1,2,4,8,12,20,40,80,160,320,640,720,732,0,0,0},
{13,1,2,4,8,12,20,40,80,160,320,640,720,732,733,0,0},
{12,1,2,4,6,10,20,40,46,86,172,344,688,734,0,0,0},
{12,1,2,3,6,12,15,30,60,120,240,480,720,735,0,0,0},
{11,1,2,4,8,16,32,64,96,160,320,640,736,0,0,0,0},
{12,1,2,4,8,16,32,64,96,160,320,640,736,737,0,0,0},
{12,1,2,4,8,16,32,64,96,160,320,640,736,738,0,0,0},
{12,1,2,3,5,10,20,23,46,92,184,368,736,739,0,0,0},
{12,1,2,4,8,16,32,64,96,160,320,640,736,740,0,0,0},
{12,1,2,3,5,10,20,23,46,92,184,368,736,741,0,0,0},
{12,1,2,4,6,10,20,40,46,92,184,368,736,742,0,0,0},
{13,1,2,4,6,10,20,40,46,92,184,368,736,742,743,0,0},
{12,1,2,4,8,16,32,64,96,160,320,640,736,744,0,0,0},
{12,1,2,4,5,9,18,23,46,92,184,368,736,745,0,0,0},
{12,1,2,4,6,10,20,40,46,92,184,368,736,746,0,0,0},
{12,1,2,4,8,9,18,27,45,90,180,360,720,747,0,0,0},
{12,1,2,4,8,12,20,40,80,92,184,368,736,748,0,0,0},
{12,1,2,3,5,10,13,23,46,92,184,368,736,749,0,0,0},
{12,1,2,4,5,9,14,23,46,92,184,368,736,750,0,0,0},
{13,1,2,4,5,9,14,23,46,92,184,368,736,750,751,0,0},
{12,1,2,4,8,16,32,64,96,160,320,640,736,752,0,0,0},
{13,1,2,4,8,16,32,64,96,160,320,640,736,752,753,0,0},
{12,1,2,4,8,10,18,36,46,92,184,368,736,754,0,0,0},
{13,1,2,4,8,10,18,36,46,92,184,368,736,754,755,0,0},
{12,1,2,4,8,12,20,40,80,92,184,368,736,756,0,0,0},
{13,1,2,4,8,12,20,40,80,92,184,368,736,756,757,0,0},
{13,1,2,4,8,12,20,40,80,92,184,368,736,756,758,0,0},
{12,1,2,3,5,10,20,23,46,92,184,368,736,759,0,0,0},
{12,1,2,4,8,16,24,40,80,160,184,368,736,760,0,0,0},
{13,1,2,4,8,16,24,40,80,160,184,368,736,760,761,0,0},
{12,1,2,4,6,10,20,26,46,92,184,368,736,762,0,0,0},
{13,1,2,4,6,10,20,26,46,92,184,368,736,762,763,0,0},
{12,1,2,4,8,10,18,28,46,92,184,368,736,764,0,0,0},
{12,1,2,4,5,10,20,40,45,90,180,360,720,765,0,0,0},
{13,1,2,4,5,10,20,40,45,90,180,360,720,765,766,0,0},
{13,1,2,4,5,10,20,40,45,90,180,360,720,765,767,0,0},
{10,1,2,4,8,16,32,64,128,256,512,768,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,768,769,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,768,770,0,0,0,0},
{11,1,2,3,6,12,24,48,96,192,384,768,771,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,768,772,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,768,772,773,0,0,0},
{11,1,2,4,6,12,24,48,96,192,384,768,774,0,0,0,0},
{12,1,2,4,6,12,24,48,96,192,384,768,774,775,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,768,776,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,768,776,777,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,768,776,778,0,0,0},
{12,1,2,3,6,12,24,48,96,192,194,388,776,779,0,0,0},
{11,1,2,4,8,12,24,48,96,192,384,768,780,0,0,0,0},
{12,1,2,4,8,12,24,48,96,192,384,768,780,781,0,0,0},
{12,1,2,4,8,12,24,48,96,192,384,768,780,782,0,0,0},
{12,1,2,3,6,12,24,48,96,192,384,768,780,783,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,768,784,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,768,784,785,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,768,784,786,0,0,0},
{12,1,2,3,6,12,24,48,96,98,196,392,784,787,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,768,784,788,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,768,784,788,789,0,0},
{12,1,2,4,6,12,24,48,96,192,196,392,784,790,0,0,0},
{13,1,2,4,6,12,24,48,96,192,196,392,784,790,791,0,0},
{11,1,2,4,8,16,24,48,96,192,384,768,792,0,0,0,0},
{12,1,2,4,8,16,24,48,96,192,384,768,792,793,0,0,0},
{12,1,2,4,8,16,24,48,96,192,384,768,792,794,0,0,0},
{12,1,2,3,6,12,24,48,96,192,384,768,792,795,0,0,0},
{12,1,2,4,8,16,24,48,96,192,384,768,792,796,0,0,0},
{13,1,2,4,8,16,24,48,96,192,384,768,792,796,797,0,0},
{12,1,2,4,6,12,24,48,96,192,384,768,792,798,0,0,0},
{13,1,2,4,6,12,24,48,96,192,384,768,792,798,799,0,0},
{11,1,2,4,8,16,32,64,128,256,512,768,800,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,768,800,801,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,768,800,802,0,0,0},
{12,1,2,3,5,10,20,40,80,160,320,640,800,803,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,768,800,804,0,0,0},
{12,1,2,4,5,10,20,40,80,160,320,640,800,805,0,0,0},
{12,1,2,4,6,10,20,40,80,160,320,640,800,806,0,0,0},
{13,1,2,4,6,10,20,40,80,160,320,640,800,806,807,0,0},
{12,1,2,4,8,16,32,64,128,256,512,768,800,808,0,0,0},
{12,1,2,4,8,9,17,25,50,100,200,400,800,809,0,0,0},
{12,1,2,4,8,10,20,40,80,160,320,640,800,810,0,0,0},
{13,1,2,4,8,10,20,40,80,160,320,640,800,810,811,0,0},
{12,1,2,4,8,12,20,40,80,160,320,640,800,812,0,0,0},
{12,1,2,4,8,12,13,25,50,100,200,400,800,813,0,0,0},
{13,1,2,4,8,12,13,25,50,100,200,400,800,813,814,0,0},
{12,1,2,4,5,10,15,25,50,100,200,400,800,815,0,0,0},
{11,1,2,4,8,16,32,48,96,192,384,768,816,0,0,0,0},
{12,1,2,4,8,16,32,48,96,192,384,768,816,817,0,0,0},
{12,1,2,4,8,16,32,48,96,192,384,768,816,818,0,0,0},
{12,1,2,3,6,12,24,48,96,192,384,768,816,819,0,0,0},
{12,1,2,4,8,16,32,48,96,192,384,768,816,820,0,0,0},
{13,1,2,4,8,16,32,48,96,192,384,768,816,820,821,0,0},
{12,1,2,4,6,12,24,48,96,192,384,768,816,822,0,0,0},
{13,1,2,4,6,12,24,48,96,192,384,768,816,822,823,0,0},
{12,1,2,4,8,16,32,48,96,192,384,768,816,824,0,0,0},
{12,1,2,4,8,9,17,34,68,136,272,544,816,825,0,0,0},
{12,1,2,4,8,16,24,26,50,100,200,400,800,826,0,0,0},
{13,1,2,4,8,16,24,26,50,100,200,400,800,826,827,0,0},
{12,1,2,4,8,12,24,48,96,192,384,768,816,828,0,0,0},
{13,1,2,4,8,12,24,48,96,192,384,768,816,828,829,0,0},
{12,1,2,4,8,10,20,30,50,100,200,400,800,830,0,0,0},
{13,1,2,4,8,10,20,30,50,100,200,400,800,830,831,0,0},
{11,1,2,4,8,16,32,64,128,256,512,768,832,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,768,832,833,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,768,832,834,0,0,0},
{12,1,2,3,6,12,24,26,52,104,208,416,832,835,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,768,832,836,0,0,0},
{12,1,2,3,5,10,13,26,52,104,208,416,832,837,0,0,0},
{12,1,2,4,6,12,24,48,52,104,208,416,832,838,0,0,0},
{12,1,2,4,6,7,13,26,52,104,208,416,832,839,0,0,0},
{12,1,2,3,5,8,13,26,52,104,208,416,832,840,0,0,0},
{12,1,2,4,8,9,18,26,52,104,208,416,832,841,0,0,0},
{12,1,2,4,6,10,20,26,52,104,208,416,832,842,0,0,0},
{12,1,2,3,6,12,24,27,51,102,204,408,816,843,0,0,0},
{12,1,2,4,8,12,24,48,96,104,208,416,832,844,0,0,0},
{12,1,2,4,8,12,13,26,52,104,208,416,832,845,0,0,0},
{12,1,2,4,8,12,14,26,52,104,208,416,832,846,0,0,0},
{13,1,2,4,8,12,14,26,52,104,208,416,832,846,847,0,0},
{12,1,2,4,6,10,16,26,52,104,208,416,832,848,0,0,0},
{12,1,2,4,8,9,17,26,52,104,208,416,832,849,0,0,0},
{12,1,2,4,8,16,18,36,52,104,208,416,832,850,0,0,0},
{13,1,2,4,8,16,18,36,52,104,208,416,832,850,851,0,0},
{12,1,2,4,8,12,20,40,52,104,208,416,832,852,0,0,0},
{13,1,2,4,8,12,20,40,52,104,208,416,832,852,853,0,0},
{13,1,2,4,8,12,20,40,52,104,208,416,832,852,854,0,0},
{13,1,2,3,5,10,13,26,52,104,208,416,426,852,855,0,0},
{12,1,2,4,8,16,24,48,96,192,208,416,832,856,0,0,0},
{13,1,2,4,8,16,24,48,96,192,208,416,832,856,857,0,0},
{12,1,2,4,8,16,24,26,52,104,208,416,832,858,0,0,0},
{13,1,2,4,8,16,24,26,52,104,208,416,832,858,859,0,0},
{12,1,2,4,8,16,24,28,52,104,208,416,832,860,0,0,0},
{13,1,2,4,8,16,24,28,52,104,208,416,832,860,861,0,0},
{13,1,2,4,8,16,24,28,52,104,208,416,832,860,862,0,0},
{13,1,2,3,5,10,20,40,60,100,200,400,800,860,863,0,0},
{11,1,2,4,8,16,32,64,96,192,384,768,864,0,0,0,0},
{12,1,2,4,8,16,32,64,96,192,384,768,864,865,0,0,0},
{12,1,2,4,8,16,32,64,96,192,384,768,864,866,0,0,0},
{12,1,2,3,6,12,24,48,96,192,384,768,864,867,0,0,0},
{12,1,2,4,8,16,32,64,96,192,384,768,864,868,0,0,0},
{12,1,2,4,5,9,18,36,72,144,288,576,864,869,0,0,0},
{12,1,2,4,6,12,24,48,96,192,384,768,864,870,0,0,0},
{13,1,2,4,6,12,24,48,96,192,384,768,864,870,871,0,0},
{12,1,2,4,8,16,32,64,96,192,384,768,864,872,0,0,0},
{12,1,2,4,8,9,18,36,72,144,288,576,864,873,0,0,0},
{12,1,2,4,8,10,18,36,72,144,288,576,864,874,0,0,0},
{13,1,2,4,8,10,18,36,72,144,288,576,864,874,875,0,0},
{12,1,2,4,8,12,24,48,96,192,384,768,864,876,0,0,0},
{13,1,2,4,8,12,24,48,96,192,384,768,864,876,877,0,0},
{13,1,2,4,8,12,24,48,96,192,384,768,864,876,878,0,0},
{12,1,2,3,6,12,15,27,54,108,216,432,864,879,0,0,0},
{12,1,2,4,8,16,32,64,96,192,384,768,864,880,0,0,0},
{13,1,2,4,8,16,32,64,96,192,384,768,864,880,881,0,0},
{12,1,2,4,8,16,18,36,72,144,288,576,864,882,0,0,0},
{13,1,2,4,8,16,18,36,72,144,288,576,864,882,883,0,0},
{12,1,2,4,8,16,20,36,72,144,288,576,864,884,0,0,0},
{13,1,2,4,8,16,20,36,72,144,288,576,864,884,885,0,0},
{13,1,2,4,8,16,20,36,72,144,288,576,864,884,886,0,0},
{13,1,2,3,6,12,24,26,52,104,208,416,832,884,887,0,0},
{12,1,2,4,8,16,24,48,96,192,384,768,864,888,0,0,0},
{13,1,2,4,8,16,24,48,96,192,384,768,864,888,889,0,0},
{13,1,2,4,8,16,24,48,96,192,384,768,864,888,890,0,0},
{12,1,2,3,6,12,24,27,54,108,216,432,864,891,0,0,0},
{13,1,2,3,6,12,24,27,54,108,216,432,864,891,892,0,0},
{13,1,2,3,6,12,24,27,54,108,216,432,864,891,893,0,0},
{12,1,2,4,6,12,24,30,54,108,216,432,864,894,0,0,0},
{13,1,2,4,6,12,24,30,54,108,216,432,864,894,895,0,0},
{11,1,2,4,8,16,32,64,128,256,512,768,896,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,768,896,897,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,768,896,898,0,0,0},
{12,1,2,3,6,12,14,28,56,112,224,448,896,899,0,0,0},
{12,1,2,3,4,7,14,28,56,112,224,448,896,900,0,0,0},
{12,1,2,4,5,10,14,28,56,112,224,448,896,901,0,0,0},
{12,1,2,4,6,12,24,28,56,112,224,448,896,902,0,0,0},
{12,1,2,4,6,7,14,28,56,112,224,448,896,903,0,0,0},
{12,1,2,4,6,8,14,28,56,112,224,448,896,904,0,0,0},
{12,1,2,4,5,9,14,28,56,112,224,448,896,905,0,0,0},
{12,1,2,4,8,10,20,28,56,112,224,448,896,906,0,0,0},
{13,1,2,4,8,10,20,28,56,112,224,448,896,906,907,0,0},
{12,1,2,4,8,12,24,48,56,112,224,448,896,908,0,0,0},
{13,1,2,4,8,12,24,48,56,112,224,448,896,908,909,0,0},
{12,1,2,4,8,12,14,28,56,112,224,448,896,910,0,0,0},
{13,1,2,4,8,12,14,28,56,112,224,448,896,910,911,0,0},
{12,1,2,4,8,12,16,28,56,112,224,448,896,912,0,0,0},
{13,1,2,4,8,12,16,28,56,112,224,448,896,912,913,0,0},
{12,1,2,4,8,10,18,28,56,112,224,448,896,914,0,0,0},
{13,1,2,4,8,10,18,28,56,112,224,448,896,914,915,0,0},
{12,1,2,4,8,16,20,40,56,112,224,448,896,916,0,0,0},
{13,1,2,4,8,16,20,40,56,112,224,448,896,916,917,0,0},
{12,1,2,4,6,12,24,48,54,108,216,432,864,918,0,0,0},
{13,1,2,4,6,12,24,48,54,108,216,432,864,918,919,0,0},
{12,1,2,4,8,16,24,48,96,112,224,448,896,920,0,0,0},
{13,1,2,4,8,16,24,48,96,112,224,448,896,920,921,0,0},
{13,1,2,4,8,16,24,48,96,112,224,448,896,920,922,0,0},
{13,1,2,3,5,10,20,40,80,120,200,400,800,920,923,0,0},
{12,1,2,4,8,16,24,28,56,112,224,448,896,924,0,0,0},
{13,1,2,4,8,16,24,28,56,112,224,448,896,924,925,0,0},
{13,1,2,4,8,16,24,28,56,112,224,448,896,924,926,0,0},
{13,1,2,3,6,12,14,28,56,112,224,448,896,924,927,0,0},
{12,1,2,4,8,16,24,32,56,112,224,448,896,928,0,0,0},
{13,1,2,4,8,16,24,32,56,112,224,448,896,928,929,0,0},
{13,1,2,4,8,16,24,32,56,112,224,448,896,928,930,0,0},
{13,1,2,3,6,8,14,28,56,112,224,232,464,928,931,0,0},
{12,1,2,4,8,16,20,36,56,112,224,448,896,932,0,0,0},
{13,1,2,4,8,16,20,36,56,112,224,448,896,932,933,0,0},
{13,1,2,4,8,16,20,36,56,112,224,448,896,932,934,0,0},
{13,1,2,3,4,7,14,28,56,112,116,232,464,928,935,0,0},
{12,1,2,4,8,16,32,40,80,112,224,448,896,936,0,0,0},
{13,1,2,4,8,16,32,40,80,112,224,448,896,936,937,0,0},
{13,1,2,4,8,16,32,40,80,112,224,448,896,936,938,0,0},
{13,1,2,3,6,12,24,48,72,144,288,576,864,936,939,0,0},
{13,1,2,4,8,16,32,40,80,112,224,448,896,936,940,0,0},
{13,1,2,4,5,9,18,36,72,144,288,576,864,936,941,0,0},
{13,1,2,4,6,12,24,48,72,144,288,576,864,936,942,0,0},
{13,1,2,4,6,7,13,26,52,104,208,416,832,936,943,0,0},
{12,1,2,4,8,16,32,48,96,192,224,448,896,944,0,0,0},
{13,1,2,4,8,16,32,48,96,192,224,448,896,944,945,0,0},
{13,1,2,4,8,16,32,48,96,192,224,448,896,944,946,0,0},
{13,1,2,3,6,12,14,28,56,112,224,236,472,944,947,0,0},
{13,1,2,3,4,7,14,28,56,59,118,236,472,944,948,0,0},
{13,1,2,4,5,9,18,36,41,82,118,236,472,944,949,0,0},
{13,1,2,4,6,12,24,28,56,112,224,448,472,944,950,0,0},
{13,1,2,4,6,7,14,28,56,112,118,236,472,944,951,0,0},
{12,1,2,4,8,16,32,48,56,112,224,448,896,952,0,0,0},
{13,1,2,4,8,16,32,48,56,112,224,448,896,952,953,0,0},
{13,1,2,4,8,16,32,48,56,112,224,448,896,952,954,0,0},
{13,1,2,3,6,12,14,28,56,112,224,448,896,952,955,0,0},
{13,1,2,3,4,7,14,28,56,112,224,448,896,952,956,0,0},
{13,1,2,4,5,10,14,28,56,112,224,448,896,952,957,0,0},
{13,1,2,4,6,12,24,28,56,112,224,448,896,952,958,0,0},
{13,1,2,4,6,7,14,28,56,112,224,448,896,952,959,0,0},
{11,1,2,4,8,16,32,64,128,192,384,768,960,0,0,0,0},
{12,1,2,4,8,16,32,64,128,192,384,768,960,961,0,0,0},
{12,1,2,4,8,16,32,64,128,192,384,768,960,962,0,0,0},
{12,1,2,3,6,12,24,48,96,192,384,768,960,963,0,0,0},
{12,1,2,4,8,16,32,64,128,192,384,768,960,964,0,0,0},
{12,1,2,4,5,10,20,40,80,160,320,640,960,965,0,0,0},
{12,1,2,4,6,12,24,48,96,192,384,768,960,966,0,0,0},
{13,1,2,4,6,12,24,48,96,192,384,768,960,966,967,0,0},
{12,1,2,4,8,16,32,64,128,192,384,768,960,968,0,0,0},
{12,1,2,3,6,9,15,30,60,120,240,480,960,969,0,0,0},
{12,1,2,4,8,10,20,40,80,160,320,640,960,970,0,0,0},
{13,1,2,4,8,10,20,40,80,160,320,640,960,970,971,0,0},
{12,1,2,4,8,12,24,48,96,192,384,768,960,972,0,0,0},
{13,1,2,4,8,12,24,48,96,192,384,768,960,972,973,0,0},
{13,1,2,4,8,12,24,48,96,192,384,768,960,972,974,0,0},
{12,1,2,3,6,12,15,30,60,120,240,480,960,975,0,0,0},
{12,1,2,4,8,16,32,64,128,192,384,768,960,976,0,0,0},
{13,1,2,4,8,16,32,64,128,192,384,768,960,976,977,0,0},
{12,1,2,4,6,12,18,30,60,120,240,480,960,978,0,0,0},
{13,1,2,4,6,12,18,30,60,120,240,480,960,978,979,0,0},
{12,1,2,4,8,16,20,40,80,160,320,640,960,980,0,0,0},
{13,1,2,4,8,16,20,40,80,160,320,640,960,980,981,0,0},
{13,1,2,4,8,16,20,40,80,160,320,640,960,980,982,0,0},
{13,1,2,3,5,10,20,40,80,160,320,640,960,980,983,0,0},
{12,1,2,4,8,16,24,48,96,192,384,768,960,984,0,0,0},
{13,1,2,4,8,16,24,48,96,192,384,768,960,984,985,0,0},
{13,1,2,4,8,16,24,48,96,192,384,768,960,984,986,0,0},
{13,1,2,3,6,12,24,48,96,192,384,768,960,984,987,0,0},
{13,1,2,4,8,16,24,48,96,192,384,768,960,984,988,0,0},
{13,1,2,4,5,10,20,40,80,160,164,328,656,984,989,0,0},
{12,1,2,4,6,12,24,30,60,120,240,480,960,990,0,0,0},
{13,1,2,4,6,12,24,30,60,120,240,480,960,990,991,0,0},
{12,1,2,4,8,16,32,64,128,192,384,768,960,992,0,0,0},
{13,1,2,4,8,16,32,64,128,192,384,768,960,992,993,0,0},
{13,1,2,4,8,16,32,64,128,192,384,768,960,992,994,0,0},
{13,1,2,3,6,12,24,48,50,100,200,248,496,992,995,0,0},
{12,1,2,4,8,12,24,36,60,120,240,480,960,996,0,0,0},
{13,1,2,4,8,12,24,36,60,120,240,480,960,996,997,0,0},
{13,1,2,4,8,12,24,36,60,120,240,480,960,996,998,0,0},
{13,1,2,3,6,12,24,36,60,120,240,480,960,996,999,0,0},
{12,1,2,4,8,16,32,40,80,160,320,640,960,1000,0,0,0},
{13,1,2,4,8,16,32,40,80,160,320,640,960,1000,1001,0,0},
{13,1,2,4,8,16,32,40,80,160,320,640,960,1000,1002,0,0},
{13,1,2,3,5,10,20,40,80,160,320,640,960,1000,1003,0,0},
{13,1,2,4,8,16,32,40,80,160,320,640,960,1000,1004,0,0},
{13,1,2,4,5,10,20,40,80,160,320,640,960,1000,1005,0,0},
{13,1,2,4,6,10,20,40,80,160,320,640,960,1000,1006,0,0},
{13,1,2,4,5,10,15,30,60,120,124,248,496,992,1007,0,0},
{12,1,2,4,8,16,32,48,96,192,384,768,960,1008,0,0,0},
{13,1,2,4,8,16,32,48,96,192,384,768,960,1008,1009,0,0},
{13,1,2,4,8,16,32,48,96,192,384,768,960,1008,1010,0,0},
{13,1,2,3,6,12,24,48,96,192,384,768,960,1008,1011,0,0},
{13,1,2,3,4,7,14,28,56,112,224,448,896,1008,1012,0,0},
{13,1,2,4,5,10,14,28,56,112,224,448,896,1008,1013,0,0},
{13,1,2,4,6,12,24,48,96,192,384,768,960,1008,1014,0,0},
{13,1,2,4,6,7,14,28,56,112,224,448,896,1008,1015,0,0},
{13,1,2,4,6,8,14,28,56,112,224,448,896,1008,1016,0,0},
{13,1,2,4,5,9,14,28,56,112,224,448,896,1008,1017,0,0},
{13,1,2,4,8,10,20,28,56,112,224,448,896,1008,1018,0,0},
{13,1,2,4,8,10,11,21,42,84,168,336,672,1008,1019,0,0},
{12,1,2,4,8,12,24,48,60,120,240,480,960,1020,0,0,0},
{13,1,2,4,8,12,24,48,60,120,240,480,960,1020,1021,0,0},
{13,1,2,4,8,12,24,48,60,120,240,480,960,1020,1022,0,0},
{13,1,2,3,6,12,24,48,60,120,240,480,960,1020,1023,0,0},
{10,1,2,4,8,16,32,64,128,256,512,1024,0,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,1024,1025,0,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,1024,1026,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1026,1027,0,0,0},
{11,1,2,4,8,16,32,64,128,256,512,1024,1028,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1028,1029,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1028,1030,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1028,1030,1031,0,0},
{11,1,2,4,8,16,32,64,128,256,512,1024,1032,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1032,1033,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1032,1034,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1032,1034,1035,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1032,1036,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1032,1036,1037,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1032,1036,1038,0,0},
{13,1,2,3,6,8,16,32,64,128,256,512,518,1036,1039,0,0},
{11,1,2,4,8,16,32,64,128,256,512,1024,1040,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1040,1041,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1040,1042,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1040,1042,1043,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1040,1044,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1040,1044,1045,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1040,1044,1046,0,0},
{13,1,2,3,5,8,16,32,64,128,256,261,522,1044,1047,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1040,1048,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1040,1048,1049,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1040,1048,1050,0,0},
{13,1,2,3,6,8,16,32,64,128,256,262,524,1048,1051,0,0},
{13,1,2,3,4,8,16,32,64,128,131,262,524,1048,1052,0,0},
{13,1,2,3,5,8,16,32,64,128,131,262,524,1048,1053,0,0},
{13,1,2,4,6,12,16,32,64,128,256,512,524,1048,1054,0,0},
{13,1,2,4,5,10,15,30,60,120,130,260,520,1040,1055,0,0},
{11,1,2,4,8,16,32,64,128,256,512,1024,1056,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1056,1057,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1056,1058,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1056,1058,1059,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1056,1060,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1056,1060,1061,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1056,1060,1062,0,0},
{13,1,2,3,4,7,11,22,44,88,176,352,704,1056,1063,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1056,1064,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1056,1064,1065,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1056,1064,1066,0,0},
{13,1,2,3,5,8,16,32,64,128,133,266,532,1064,1067,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1056,1064,1068,0,0},
{13,1,2,3,5,8,16,32,64,128,133,266,532,1064,1069,0,0},
{13,1,2,4,6,10,16,32,64,128,256,266,532,1064,1070,0,0},
{13,1,2,3,6,12,15,30,60,120,132,264,528,1056,1071,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1056,1072,0,0,0},
{12,1,2,4,8,16,17,33,66,132,264,528,1056,1073,0,0,0},
{13,1,2,4,8,16,17,33,66,132,264,528,1056,1073,1074,0,0},
{13,1,2,4,8,16,17,33,66,132,264,528,1056,1073,1075,0,0},
{13,1,2,3,4,8,16,32,64,67,134,268,536,1072,1076,0,0},
{13,1,2,4,8,16,17,33,66,132,264,528,1056,1073,1077,0,0},
{13,1,2,4,6,12,16,32,64,128,256,268,536,1072,1078,0,0},
{13,1,2,3,5,10,20,23,46,66,132,264,528,1056,1079,0,0},
{12,1,2,4,8,16,24,48,96,120,240,480,960,1080,0,0,0},
{13,1,2,4,8,16,24,48,96,120,240,480,960,1080,1081,0,0},
{13,1,2,4,8,16,24,48,96,120,240,480,960,1080,1082,0,0},
{13,1,2,3,6,12,24,48,96,120,240,480,960,1080,1083,0,0},
{13,1,2,4,8,16,24,48,96,120,240,480,960,1080,1084,0,0},
{13,1,2,4,5,10,20,40,80,120,240,480,960,1080,1085,0,0},
{13,1,2,4,6,12,24,48,96,120,240,480,960,1080,1086,0,0},
{14,1,2,4,6,12,24,48,96,120,240,480,960,1080,1086,1087,0},
{11,1,2,4,8,16,32,64,128,256,512,1024,1088,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1088,1089,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1088,1090,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1088,1090,1091,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1088,1092,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1088,1092,1093,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1088,1092,1094,0,0},
{13,1,2,4,6,7,14,28,34,68,136,272,544,1088,1095,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1088,1096,0,0,0},
{12,1,2,4,8,9,17,34,68,136,272,544,1088,1097,0,0,0},
{13,1,2,4,8,9,17,34,68,136,272,544,1088,1097,1098,0,0},
{13,1,2,4,8,9,17,34,68,136,272,544,1088,1097,1099,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1088,1096,1100,0,0},
{13,1,2,4,8,9,17,34,68,136,272,544,1088,1097,1101,0,0},
{13,1,2,4,8,12,14,28,56,68,136,272,544,1088,1102,0,0},
{13,1,2,4,5,10,15,30,34,68,136,272,544,1088,1103,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1088,1104,0,0,0},
{12,1,2,4,8,16,17,34,68,136,272,544,1088,1105,0,0,0},
{12,1,2,4,8,16,18,34,68,136,272,544,1088,1106,0,0,0},
{13,1,2,4,8,16,18,34,68,136,272,544,1088,1106,1107,0,0},
{13,1,2,4,8,16,18,34,68,136,272,544,1088,1106,1108,0,0},
{13,1,2,4,8,16,17,34,68,136,272,544,1088,1105,1109,0,0},
{13,1,2,4,8,16,18,34,68,136,272,544,1088,1106,1110,0,0},
{14,1,2,4,8,16,18,34,68,136,272,544,1088,1106,1110,1111,0},
{13,1,2,3,5,8,16,32,64,69,138,276,552,1104,1112,0,0},
{13,1,2,4,8,16,17,34,68,136,272,544,1088,1105,1113,0,0},
{13,1,2,4,8,16,18,34,68,136,272,544,1088,1106,1114,0,0},
{13,1,2,4,8,9,17,34,68,136,272,544,553,1106,1115,0,0},
{13,1,2,4,8,12,24,48,96,144,240,480,960,1104,1116,0,0},
{13,1,2,3,5,10,13,23,46,92,184,368,736,1104,1117,0,0},
{13,1,2,4,5,9,14,23,46,92,184,368,736,1104,1118,0,0},
{13,1,2,3,6,9,15,30,60,69,138,276,552,1104,1119,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1088,1120,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1088,1120,1121,0,0},
{12,1,2,4,8,16,32,34,68,136,272,544,1088,1122,0,0,0},
{13,1,2,4,8,16,32,34,68,136,272,544,1088,1122,1123,0,0},
{12,1,2,4,8,16,32,36,68,136,272,544,1088,1124,0,0,0},
{13,1,2,4,8,16,32,36,68,136,272,544,1088,1124,1125,0,0},
{13,1,2,4,8,16,32,36,68,136,272,544,1088,1124,1126,0,0},
{13,1,2,4,6,7,14,28,56,112,224,448,896,1120,1127,0,0},
{13,1,2,4,8,16,32,36,68,136,272,544,1088,1124,1128,0,0},
{13,1,2,4,5,9,14,28,56,112,224,448,896,1120,1129,0,0},
{13,1,2,4,8,16,32,34,68,136,272,544,1088,1122,1130,0,0},
{13,1,2,4,8,9,17,34,68,136,272,544,1088,1122,1131,0,0},
{13,1,2,4,8,16,32,36,68,136,272,544,1088,1124,1132,0,0},
{13,1,2,4,8,9,17,34,68,136,272,281,562,1124,1133,0,0},
{13,1,2,4,8,12,14,28,56,112,224,448,896,1120,1134,0,0},
{13,1,2,4,5,10,15,30,60,70,140,280,560,1120,1135,0,0},
{13,1,2,4,8,12,16,28,56,112,224,448,896,1120,1136,0,0},
{13,1,2,4,8,16,17,34,68,136,272,544,560,1120,1137,0,0},
{13,1,2,4,8,16,32,34,68,136,272,544,1088,1122,1138,0,0},
{13,1,2,4,8,16,17,34,68,136,272,544,1088,1122,1139,0,0},
{13,1,2,4,8,16,32,36,68,136,272,544,1088,1124,1140,0,0},
{13,1,2,4,8,9,17,34,68,136,272,281,562,1124,1141,0,0},
{13,1,2,4,8,16,18,34,68,136,272,544,562,1124,1142,0,0},
{13,1,2,3,6,9,15,30,39,69,138,276,552,1104,1143,0,0},
{13,1,2,4,8,16,24,40,80,160,320,640,960,1120,1144,0,0},
{13,1,2,4,5,10,20,25,50,70,140,280,560,1120,1145,0,0},
{13,1,2,4,8,16,18,26,52,70,140,280,560,1120,1146,0,0},
{13,1,2,4,8,9,18,27,35,70,140,280,560,1120,1147,0,0},
{13,1,2,4,8,16,24,28,56,112,224,448,896,1120,1148,0,0},
{14,1,2,4,8,16,24,28,56,112,224,448,896,1120,1148,1149,0},
{13,1,2,4,8,10,20,30,60,120,140,280,560,1120,1150,0,0},
{14,1,2,4,8,10,20,30,60,120,140,280,560,1120,1150,1151,0},
{11,1,2,4,8,16,32,64,128,256,512,1024,1152,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1152,1153,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1152,1154,0,0,0},
{12,1,2,3,6,12,24,48,96,192,384,768,1152,1155,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1152,1156,0,0,0},
{12,1,2,4,5,9,18,36,72,144,288,576,1152,1157,0,0,0},
{12,1,2,4,6,12,24,48,96,192,384,768,1152,1158,0,0,0},
{13,1,2,4,6,12,24,48,96,192,384,768,1152,1158,1159,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1152,1160,0,0,0},
{12,1,2,4,8,9,18,36,72,144,288,576,1152,1161,0,0,0},
{12,1,2,4,8,10,18,36,72,144,288,576,1152,1162,0,0,0},
{13,1,2,4,8,10,18,36,72,144,288,576,1152,1162,1163,0,0},
{12,1,2,4,8,12,24,48,96,192,384,768,1152,1164,0,0,0},
{13,1,2,4,8,12,24,48,96,192,384,768,1152,1164,1165,0,0},
{13,1,2,4,8,12,24,48,96,192,384,768,1152,1164,1166,0,0},
{13,1,2,3,6,12,24,48,96,192,384,768,1152,1164,1167,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1152,1168,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1152,1168,1169,0,0},
{12,1,2,4,8,16,18,36,72,144,288,576,1152,1170,0,0,0},
{13,1,2,4,8,16,18,36,72,144,288,576,1152,1170,1171,0,0},
{12,1,2,4,8,16,20,36,72,144,288,576,1152,1172,0,0,0},
{13,1,2,4,8,16,20,36,72,144,288,576,1152,1172,1173,0,0},
{13,1,2,4,8,16,20,36,72,144,288,576,1152,1172,1174,0,0},
{13,1,2,4,5,9,18,36,72,144,288,576,1152,1170,1175,0,0},
{12,1,2,4,8,16,24,48,96,192,384,768,1152,1176,0,0,0},
{13,1,2,4,8,16,24,48,96,192,384,768,1152,1176,1177,0,0},
{13,1,2,4,8,16,24,48,96,192,384,768,1152,1176,1178,0,0},
{13,1,2,3,6,12,24,48,96,192,384,768,1152,1176,1179,0,0},
{13,1,2,4,8,16,24,48,96,192,384,768,1152,1176,1180,0,0},
{13,1,2,4,5,9,18,36,72,144,288,293,586,1172,1181,0,0},
{13,1,2,4,6,12,24,48,96,192,384,768,1152,1176,1182,0,0},
{14,1,2,4,6,12,24,48,96,192,384,768,1152,1176,1182,1183,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1152,1184,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1152,1184,1185,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1152,1184,1186,0,0},
{13,1,2,3,6,12,24,48,50,100,148,296,592,1184,1187,0,0},
{12,1,2,4,8,16,32,36,72,144,288,576,1152,1188,0,0,0},
{13,1,2,4,8,16,32,36,72,144,288,576,1152,1188,1189,0,0},
{13,1,2,4,8,16,32,36,72,144,288,576,1152,1188,1190,0,0},
{13,1,2,3,6,12,24,36,72,144,288,576,1152,1188,1191,0,0},
{12,1,2,4,8,16,32,40,72,144,288,576,1152,1192,0,0,0},
{13,1,2,4,8,16,32,40,72,144,288,576,1152,1192,1193,0,0},
{13,1,2,4,8,16,32,40,72,144,288,576,1152,1192,1194,0,0},
{14,1,2,4,8,16,32,40,72,144,288,576,1152,1192,1194,1195,0},
{13,1,2,4,8,16,32,40,72,144,288,576,1152,1192,1196,0,0},
{13,1,2,4,5,9,18,36,72,144,149,298,596,1192,1197,0,0},
{13,1,2,4,8,10,18,36,72,144,288,576,1152,1188,1198,0,0},
{14,1,2,4,8,10,18,36,72,144,288,576,1152,1188,1198,1199,0},
{12,1,2,4,8,16,32,48,96,192,384,768,1152,1200,0,0,0},
{13,1,2,4,8,16,32,48,96,192,384,768,1152,1200,1201,0,0},
{13,1,2,4,8,16,32,48,96,192,384,768,1152,1200,1202,0,0},
{13,1,2,3,6,12,24,48,96,192,384,768,1152,1200,1203,0,0},
{13,1,2,4,8,16,32,48,96,192,384,768,1152,1200,1204,0,0},
{13,1,2,4,5,10,20,40,80,160,240,480,960,1200,1205,0,0},
{13,1,2,4,6,12,24,48,96,192,384,768,1152,1200,1206,0,0},
{13,1,2,4,5,9,14,23,37,74,148,296,592,1184,1207,0,0},
{13,1,2,4,8,16,32,48,96,192,384,768,1152,1200,1208,0,0},
{13,1,2,3,6,9,15,30,60,120,240,480,960,1200,1209,0,0},
{13,1,2,4,8,10,20,40,80,160,240,480,960,1200,1210,0,0},
{14,1,2,4,8,10,20,40,80,160,240,480,960,1200,1210,1211,0},
{13,1,2,4,8,12,24,48,96,192,384,768,1152,1200,1212,0,0},
{13,1,2,4,8,12,13,25,50,100,200,400,800,1200,1213,0,0},
{14,1,2,4,8,12,13,25,50,100,200,400,800,1200,1213,1214,0},
{13,1,2,3,6,12,15,30,60,120,240,480,960,1200,1215,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1152,1216,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1152,1216,1217,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1152,1216,1218,0,0},
{13,1,2,3,6,12,24,26,52,76,152,304,608,1216,1219,0,0},
{13,1,2,3,4,8,16,19,38,76,152,304,608,1216,1220,0,0},
{13,1,2,4,5,9,18,36,72,76,152,304,608,1216,1221,0,0},
{13,1,2,4,6,12,24,48,52,104,152,304,608,1216,1222,0,0},
{13,1,2,4,5,7,14,19,38,76,152,304,608,1216,1223,0,0},
{12,1,2,4,8,16,32,64,72,144,288,576,1152,1224,0,0,0},
{13,1,2,4,8,16,32,64,72,144,288,576,1152,1224,1225,0,0},
{13,1,2,4,8,16,32,64,72,144,288,576,1152,1224,1226,0,0},
{13,1,2,3,6,12,24,48,72,144,288,576,1152,1224,1227,0,0},
{13,1,2,4,8,16,32,64,72,144,288,576,1152,1224,1228,0,0},
{13,1,2,4,5,9,18,36,72,144,288,576,1152,1224,1229,0,0},
{13,1,2,4,6,12,24,48,72,144,288,576,1152,1224,1230,0,0},
{13,1,2,4,5,10,15,19,38,76,152,304,608,1216,1231,0,0},
{12,1,2,4,8,16,32,64,80,144,288,576,1152,1232,0,0,0},
{13,1,2,4,8,16,32,64,80,144,288,576,1152,1232,1233,0,0},
{13,1,2,4,8,16,32,64,80,144,288,576,1152,1232,1234,0,0},
{13,1,2,4,8,16,18,19,38,76,152,304,608,1216,1235,0,0},
{13,1,2,4,8,16,32,64,80,144,288,576,1152,1232,1236,0,0},
{13,1,2,4,5,9,18,36,72,77,154,308,616,1232,1237,0,0},
{13,1,2,4,6,12,16,22,38,76,152,304,608,1216,1238,0,0},
{13,1,2,3,6,12,24,36,39,75,150,300,600,1200,1239,0,0},
{13,1,2,4,8,16,32,64,80,144,288,576,1152,1232,1240,0,0},
{13,1,2,4,5,9,18,36,72,77,154,308,616,1232,1241,0,0},
{13,1,2,4,8,10,18,36,72,144,154,308,616,1232,1242,0,0},
{14,1,2,4,8,10,18,36,72,144,154,308,616,1232,1242,1243,0},
{13,1,2,4,8,16,20,36,72,144,288,576,1152,1224,1244,0,0},
{13,1,2,3,6,12,15,30,45,75,150,300,600,1200,1245,0,0},
{13,1,2,4,8,10,20,30,38,76,152,304,608,1216,1246,0,0},
{14,1,2,4,8,10,20,30,38,76,152,304,608,1216,1246,1247,0},
{12,1,2,4,8,16,32,64,96,192,384,768,1152,1248,0,0,0},
{13,1,2,4,8,16,32,64,96,192,384,768,1152,1248,1249,0,0},
{13,1,2,4,8,16,32,64,96,192,384,768,1152,1248,1250,0,0},
{13,1,2,3,6,12,24,48,96,192,384,768,1152,1248,1251,0,0},
{13,1,2,4,8,16,32,64,96,192,384,768,1152,1248,1252,0,0},
{13,1,2,3,5,10,13,26,52,104,208,416,832,1248,1253,0,0},
{13,1,2,4,6,12,24,48,96,192,384,768,1152,1248,1254,0,0},
{13,1,2,4,6,7,13,26,52,104,208,416,832,1248,1255,0,0},
{13,1,2,3,5,8,13,26,52,104,208,416,832,1248,1256,0,0},
{13,1,2,4,8,9,18,26,52,104,208,416,832,1248,1257,0,0},
{13,1,2,4,6,10,20,26,52,104,208,416,832,1248,1258,0,0},
{14,1,2,4,6,10,20,26,52,104,208,416,832,1248,1258,1259,0},
{13,1,2,4,8,12,24,48,96,192,384,768,1152,1248,1260,0,0},
{13,1,2,4,8,12,13,26,52,104,208,416,832,1248,1261,0,0},
{13,1,2,4,8,12,14,26,52,104,208,416,832,1248,1262,0,0},
{13,1,2,3,6,9,15,30,39,78,156,312,624,1248,1263,0,0},
{13,1,2,4,6,10,16,26,52,104,208,416,832,1248,1264,0,0},
{13,1,2,4,8,9,17,26,52,104,208,416,832,1248,1265,0,0},
{13,1,2,4,8,16,18,36,52,104,208,416,832,1248,1266,0,0},
{14,1,2,4,8,16,18,36,52,104,208,416,832,1248,1266,1267,0},
{13,1,2,4,8,12,20,40,52,104,208,416,832,1248,1268,0,0},
{13,1,2,3,6,12,18,21,39,78,156,312,624,1248,1269,0,0},
{14,1,2,3,6,12,18,21,39,78,156,312,624,1248,1269,1270,0},
{14,1,2,3,6,12,18,21,39,78,156,312,624,1248,1269,1271,0},
{13,1,2,3,6,9,15,24,39,78,156,312,624,1248,1272,0,0},
{13,1,2,4,5,9,18,36,41,77,154,308,616,1232,1273,0,0},
{13,1,2,4,8,16,24,26,52,104,208,416,832,1248,1274,0,0},
{13,1,2,3,6,12,24,27,54,78,156,312,624,1248,1275,0,0},
{13,1,2,4,8,16,24,28,52,104,208,416,832,1248,1276,0,0},
{14,1,2,4,8,16,24,28,52,104,208,416,832,1248,1276,1277,0},
{13,1,2,4,6,12,18,30,60,78,156,312,624,1248,1278,0,0},
{14,1,2,4,6,12,18,30,60,78,156,312,624,1248,1278,1279,0},
{11,1,2,4,8,16,32,64,128,256,512,1024,1280,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1280,1281,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1280,1282,0,0,0},
{12,1,2,3,5,10,20,40,80,160,320,640,1280,1283,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1280,1284,0,0,0},
{12,1,2,4,5,10,20,40,80,160,320,640,1280,1285,0,0,0},
{12,1,2,4,6,10,20,40,80,160,320,640,1280,1286,0,0,0},
{13,1,2,4,6,10,20,40,80,160,320,640,1280,1286,1287,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1280,1288,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1280,1288,1289,0,0},
{12,1,2,4,8,10,20,40,80,160,320,640,1280,1290,0,0,0},
{13,1,2,4,8,10,20,40,80,160,320,640,1280,1290,1291,0,0},
{12,1,2,4,8,12,20,40,80,160,320,640,1280,1292,0,0,0},
{13,1,2,4,8,12,20,40,80,160,320,640,1280,1292,1293,0,0},
{13,1,2,4,8,12,20,40,80,160,320,640,1280,1292,1294,0,0},
{13,1,2,3,5,10,20,40,80,160,320,323,646,1292,1295,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1280,1296,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1280,1296,1297,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1280,1296,1298,0,0},
{13,1,2,3,6,12,24,48,96,144,288,576,1152,1296,1299,0,0},
{12,1,2,4,8,16,20,40,80,160,320,640,1280,1300,0,0,0},
{13,1,2,4,8,16,20,40,80,160,320,640,1280,1300,1301,0,0},
{13,1,2,4,8,16,20,40,80,160,320,640,1280,1300,1302,0,0},
{13,1,2,3,5,10,20,40,80,160,320,640,1280,1300,1303,0,0},
{12,1,2,4,8,16,24,40,80,160,320,640,1280,1304,0,0,0},
{13,1,2,4,8,16,24,40,80,160,320,640,1280,1304,1305,0,0},
{13,1,2,4,8,16,24,40,80,160,320,640,1280,1304,1306,0,0},
{13,1,2,3,5,10,20,40,80,160,163,326,652,1304,1307,0,0},
{13,1,2,4,8,16,24,40,80,160,320,640,1280,1304,1308,0,0},
{13,1,2,3,5,10,20,40,80,160,163,326,652,1304,1309,0,0},
{13,1,2,4,6,10,20,40,80,160,320,326,652,1304,1310,0,0},
{13,1,2,3,6,12,15,27,54,108,216,432,864,1296,1311,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1280,1312,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1280,1312,1313,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1280,1312,1314,0,0},
{13,1,2,3,5,10,20,40,80,82,164,328,656,1312,1315,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1280,1312,1316,0,0},
{13,1,2,4,5,10,20,40,80,160,164,328,656,1312,1317,0,0},
{13,1,2,4,6,10,20,40,80,160,164,328,656,1312,1318,0,0},
{14,1,2,4,6,10,20,40,80,160,164,328,656,1312,1318,1319,0},
{12,1,2,4,8,16,32,40,80,160,320,640,1280,1320,0,0,0},
{13,1,2,4,8,16,32,40,80,160,320,640,1280,1320,1321,0,0},
{13,1,2,4,8,16,32,40,80,160,320,640,1280,1320,1322,0,0},
{13,1,2,3,5,10,20,40,80,160,320,640,1280,1320,1323,0,0},
{13,1,2,4,8,16,32,40,80,160,320,640,1280,1320,1324,0,0},
{13,1,2,4,5,10,20,40,80,160,320,640,1280,1320,1325,0,0},
{13,1,2,4,6,10,20,40,80,160,320,640,1280,1320,1326,0,0},
{14,1,2,4,6,10,20,40,80,160,320,640,1280,1320,1326,1327,0},
{12,1,2,4,8,16,32,48,80,160,320,640,1280,1328,0,0,0},
{13,1,2,4,8,16,32,48,80,160,320,640,1280,1328,1329,0,0},
{13,1,2,4,8,16,32,48,80,160,320,640,1280,1328,1330,0,0},
{13,1,2,3,5,10,20,40,80,83,166,332,664,1328,1331,0,0},
{13,1,2,4,8,16,32,48,80,160,320,640,1280,1328,1332,0,0},
{13,1,2,3,5,10,20,40,80,83,166,332,664,1328,1333,0,0},
{13,1,2,4,6,10,20,40,80,160,166,332,664,1328,1334,0,0},
{13,1,2,4,5,9,18,23,41,82,164,328,656,1312,1335,0,0},
{13,1,2,4,8,16,32,48,80,160,320,640,1280,1328,1336,0,0},
{13,1,2,4,8,16,17,33,66,132,264,528,1056,1320,1337,0,0},
{13,1,2,4,6,10,20,40,80,160,166,332,664,1328,1338,0,0},
{14,1,2,4,6,10,20,40,80,160,166,332,664,1328,1338,1339,0},
{13,1,2,4,8,12,20,40,80,160,320,332,664,1328,1340,0,0},
{13,1,2,4,8,9,18,36,45,81,162,324,648,1296,1341,0,0},
{14,1,2,4,8,9,18,36,45,81,162,324,648,1296,1341,1342,0},
{14,1,2,4,8,9,18,36,45,81,162,324,648,1296,1341,1343,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1280,1344,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1280,1344,1345,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1280,1344,1346,0,0},
{13,1,2,3,6,12,24,48,96,192,384,768,1152,1344,1347,0,0},
{13,1,2,3,4,7,14,28,56,112,224,448,896,1344,1348,0,0},
{13,1,2,4,5,10,14,28,56,112,224,448,896,1344,1349,0,0},
{13,1,2,4,6,12,24,48,96,192,384,768,1152,1344,1350,0,0},
{13,1,2,4,6,7,14,28,56,112,224,448,896,1344,1351,0,0},
{13,1,2,4,6,8,14,28,56,112,224,448,896,1344,1352,0,0},
{13,1,2,4,5,9,14,28,56,112,224,448,896,1344,1353,0,0},
{13,1,2,4,8,10,20,28,56,112,224,448,896,1344,1354,0,0},
{13,1,2,4,8,10,11,21,42,84,168,336,672,1344,1355,0,0},
{13,1,2,3,6,9,12,21,42,84,168,336,672,1344,1356,0,0},
{13,1,2,3,5,8,13,21,42,84,168,336,672,1344,1357,0,0},
{13,1,2,4,8,12,14,28,56,112,224,448,896,1344,1358,0,0},
{13,1,2,3,6,12,15,30,42,84,168,336,672,1344,1359,0,0},
{12,1,2,4,8,16,32,64,80,160,320,640,1280,1360,0,0,0},
{13,1,2,4,8,16,32,64,80,160,320,640,1280,1360,1361,0,0},
{13,1,2,4,8,16,32,64,80,160,320,640,1280,1360,1362,0,0},
{13,1,2,3,5,10,20,40,80,160,320,640,1280,1360,1363,0,0},
{13,1,2,4,8,16,32,64,80,160,320,640,1280,1360,1364,0,0},
{13,1,2,4,5,10,20,40,80,160,320,640,1280,1360,1365,0,0},
{13,1,2,4,6,10,20,40,80,160,320,640,1280,1360,1366,0,0},
{14,1,2,4,6,10,20,40,80,160,320,640,1280,1360,1366,1367,0},
{13,1,2,4,8,16,32,64,80,160,320,640,1280,1360,1368,0,0},
{13,1,2,4,8,9,17,34,68,136,272,544,1088,1360,1369,0,0},
{13,1,2,4,8,10,20,40,80,160,320,640,1280,1360,1370,0,0},
{13,1,2,3,6,12,15,27,42,84,168,336,672,1344,1371,0,0},
{13,1,2,4,8,12,20,40,80,160,320,640,1280,1360,1372,0,0},
{14,1,2,4,8,12,20,40,80,160,320,640,1280,1360,1372,1373,0},
{13,1,2,4,6,12,24,30,60,84,168,336,672,1344,1374,0,0},
{14,1,2,4,6,12,24,30,60,84,168,336,672,1344,1374,1375,0},
{12,1,2,4,8,16,32,64,96,160,320,640,1280,1376,0,0,0},
{13,1,2,4,8,16,32,64,96,160,320,640,1280,1376,1377,0,0},
{13,1,2,4,8,16,32,64,96,160,320,640,1280,1376,1378,0,0},
{13,1,2,3,5,10,20,40,43,86,172,344,688,1376,1379,0,0},
{13,1,2,4,8,16,32,64,96,160,320,640,1280,1376,1380,0,0},
{13,1,2,3,5,10,20,40,43,86,172,344,688,1376,1381,0,0},
{13,1,2,4,6,10,20,40,80,86,172,344,688,1376,1382,0,0},
{14,1,2,4,6,10,20,40,80,86,172,344,688,1376,1382,1383,0},
{13,1,2,4,8,16,32,64,96,160,320,640,1280,1376,1384,0,0},
{13,1,2,4,8,9,17,34,43,86,172,344,688,1376,1385,0,0},
{13,1,2,4,6,10,20,40,80,86,172,344,688,1376,1386,0,0},
{13,1,2,3,5,10,20,40,80,83,163,326,652,1304,1387,0,0},
{13,1,2,4,8,12,20,40,80,160,172,344,688,1376,1388,0,0},
{14,1,2,4,8,12,20,40,80,160,172,344,688,1376,1388,1389,0},
{14,1,2,4,8,12,20,40,80,160,172,344,688,1376,1388,1390,0},
{14,1,2,3,5,10,20,22,42,84,168,336,672,694,1388,1391,0},
{13,1,2,4,8,16,32,64,96,160,320,640,1280,1376,1392,0,0},
{13,1,2,4,8,9,17,34,43,86,172,344,688,1376,1393,0,0},
{13,1,2,4,8,16,18,34,68,86,172,344,688,1376,1394,0,0},
{14,1,2,4,8,16,18,34,68,86,172,344,688,1376,1394,1395,0},
{13,1,2,4,8,12,20,40,80,160,172,344,688,1376,1396,0,0},
{14,1,2,4,8,12,20,40,80,160,172,344,688,1376,1396,1397,0},
{13,1,2,4,6,12,24,30,54,84,168,336,672,1344,1398,0,0},
{13,1,2,3,5,10,20,23,43,86,172,344,688,1376,1399,0,0},
{13,1,2,4,8,16,24,40,80,160,320,344,688,1376,1400,0,0},
{14,1,2,4,8,16,24,40,80,160,320,344,688,1376,1400,1401,0},
{13,1,2,4,8,9,17,26,43,86,172,344,688,1376,1402,0,0},
{14,1,2,4,8,9,17,26,43,86,172,344,688,1376,1402,1403,0},
{13,1,2,4,8,12,24,48,60,120,168,336,672,1344,1404,0,0},
{13,1,2,4,5,10,20,40,45,85,170,340,680,1360,1405,0,0},
{14,1,2,4,5,10,20,40,45,85,170,340,680,1360,1405,1406,0},
{14,1,2,4,5,10,20,40,45,85,170,340,680,1360,1405,1407,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1280,1408,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1280,1408,1409,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1280,1408,1410,0,0},
{13,1,2,3,5,10,20,22,44,88,176,352,704,1408,1411,0,0},
{13,1,2,3,4,8,11,22,44,88,176,352,704,1408,1412,0,0},
{13,1,2,4,5,10,20,40,44,88,176,352,704,1408,1413,0,0},
{13,1,2,4,5,6,11,22,44,88,176,352,704,1408,1414,0,0},
{13,1,2,3,4,7,11,22,44,88,176,352,704,1408,1415,0,0},
{13,1,2,4,6,8,16,22,44,88,176,352,704,1408,1416,0,0},
{13,1,2,4,8,9,18,36,44,88,176,352,704,1408,1417,0,0},
{13,1,2,4,8,10,20,40,80,88,176,352,704,1408,1418,0,0},
{13,1,2,4,8,10,11,22,44,88,176,352,704,1408,1419,0,0},
{13,1,2,4,8,10,12,22,44,88,176,352,704,1408,1420,0,0},
{13,1,2,4,8,9,13,22,44,88,176,352,704,1408,1421,0,0},
{13,1,2,4,6,8,14,22,44,88,176,352,704,1408,1422,0,0},
{14,1,2,4,6,8,14,22,44,88,176,352,704,1408,1422,1423,0},
{13,1,2,4,8,12,16,32,44,88,176,352,704,1408,1424,0,0},
{14,1,2,4,8,12,16,32,44,88,176,352,704,1408,1424,1425,0},
{13,1,2,4,8,16,18,36,72,88,176,352,704,1408,1426,0,0},
{14,1,2,4,8,16,18,36,72,88,176,352,704,1408,1426,1427,0},
{13,1,2,4,8,16,20,40,80,160,176,352,704,1408,1428,0,0},
{14,1,2,4,8,16,20,40,80,160,176,352,704,1408,1428,1429,0},
{13,1,2,4,8,16,20,22,44,88,176,352,704,1408,1430,0,0},
{14,1,2,4,8,16,20,22,44,88,176,352,704,1408,1430,1431,0},
{13,1,2,4,8,16,20,24,44,88,176,352,704,1408,1432,0,0},
{14,1,2,4,8,16,20,24,44,88,176,352,704,1408,1432,1433,0},
{13,1,2,4,8,16,18,26,44,88,176,352,704,1408,1434,0,0},
{14,1,2,4,8,16,18,26,44,88,176,352,704,1408,1434,1435,0},
{13,1,2,4,8,12,16,28,44,88,176,352,704,1408,1436,0,0},
{14,1,2,4,8,12,16,28,44,88,176,352,704,1408,1436,1437,0},
{14,1,2,4,8,12,16,28,44,88,176,352,704,1408,1436,1438,0},
{14,1,2,3,6,8,14,22,44,88,176,352,704,718,1436,1439,0},
{12,1,2,4,8,16,32,64,128,160,320,640,1280,1440,0,0,0},
{13,1,2,4,8,16,32,64,128,160,320,640,1280,1440,1441,0,0},
{13,1,2,4,8,16,32,64,128,160,320,640,1280,1440,1442,0,0},
{13,1,2,3,5,10,20,40,80,160,320,640,1280,1440,1443,0,0},
{13,1,2,4,8,16,32,64,128,160,320,640,1280,1440,1444,0,0},
{13,1,2,4,5,10,20,40,80,160,320,640,1280,1440,1445,0,0},
{13,1,2,4,6,10,20,40,80,160,320,640,1280,1440,1446,0,0},
{14,1,2,4,6,10,20,40,80,160,320,640,1280,1440,1446,1447,0},
{13,1,2,4,8,16,32,64,128,160,320,640,1280,1440,1448,0,0},
{13,1,2,4,8,9,18,36,72,144,288,576,1152,1440,1449,0,0},
{13,1,2,4,8,10,20,40,80,160,320,640,1280,1440,1450,0,0},
{14,1,2,4,8,10,20,40,80,160,320,640,1280,1440,1450,1451,0},
{13,1,2,4,8,12,20,40,80,160,320,640,1280,1440,1452,0,0},
{14,1,2,4,8,12,20,40,80,160,320,640,1280,1440,1452,1453,0},
{14,1,2,4,8,12,20,40,80,160,320,640,1280,1440,1452,1454,0},
{13,1,2,3,6,12,15,30,60,120,240,480,960,1440,1455,0,0},
{13,1,2,4,8,16,32,64,128,160,320,640,1280,1440,1456,0,0},
{14,1,2,4,8,16,32,64,128,160,320,640,1280,1440,1456,1457,0},
{13,1,2,4,8,16,18,36,72,144,288,576,1152,1440,1458,0,0},
{14,1,2,4,8,16,18,36,72,144,288,576,1152,1440,1458,1459,0},
{13,1,2,4,8,16,20,40,80,160,320,640,1280,1440,1460,0,0},
{14,1,2,4,8,16,20,40,80,160,320,640,1280,1440,1460,1461,0},
{13,1,2,4,6,10,20,40,80,86,172,344,688,1376,1462,0,0},
{14,1,2,4,6,10,20,40,80,86,172,344,688,1376,1462,1463,0},
{13,1,2,4,8,16,24,40,80,160,320,640,1280,1440,1464,0,0},
{13,1,2,4,5,10,20,25,45,90,180,360,720,1440,1465,0,0},
{14,1,2,4,5,10,20,25,45,90,180,360,720,1440,1465,1466,0},
{13,1,2,4,8,9,18,27,45,90,180,360,720,1440,1467,0,0},
{13,1,2,4,8,12,20,40,80,92,172,344,688,1376,1468,0,0},
{14,1,2,4,8,12,20,40,80,92,172,344,688,1376,1468,1469,0},
{13,1,2,4,6,12,24,30,60,120,240,480,960,1440,1470,0,0},
{14,1,2,4,6,12,24,30,60,120,240,480,960,1440,1470,1471,0},
{12,1,2,4,8,16,32,64,128,192,320,640,1280,1472,0,0,0},
{13,1,2,4,8,16,32,64,128,192,320,640,1280,1472,1473,0,0},
{13,1,2,4,8,16,32,64,128,192,320,640,1280,1472,1474,0,0},
{13,1,2,3,5,10,20,23,46,92,184,368,736,1472,1475,0,0},
{13,1,2,4,8,16,32,64,128,192,320,640,1280,1472,1476,0,0},
{13,1,2,3,5,10,20,23,46,92,184,368,736,1472,1477,0,0},
{13,1,2,4,6,10,20,40,46,92,184,368,736,1472,1478,0,0},
{14,1,2,4,6,10,20,40,46,92,184,368,736,1472,1478,1479,0},
{13,1,2,4,8,16,32,64,128,192,320,640,1280,1472,1480,0,0},
{13,1,2,4,5,9,18,23,46,92,184,368,736,1472,1481,0,0},
{13,1,2,4,6,10,20,40,46,92,184,368,736,1472,1482,0,0},
{14,1,2,4,6,10,20,40,46,92,184,368,736,1472,1482,1483,0},
{13,1,2,4,8,12,20,40,80,92,184,368,736,1472,1484,0,0},
{13,1,2,3,5,10,13,23,46,92,184,368,736,1472,1485,0,0},
{13,1,2,4,5,9,14,23,46,92,184,368,736,1472,1486,0,0},
{14,1,2,4,5,9,14,23,46,92,184,368,736,1472,1486,1487,0},
{13,1,2,4,8,16,32,64,128,192,320,640,1280,1472,1488,0,0},
{14,1,2,4,8,16,32,64,128,192,320,640,1280,1472,1488,1489,0},
{13,1,2,4,8,10,18,36,46,92,184,368,736,1472,1490,0,0},
{14,1,2,4,8,10,18,36,46,92,184,368,736,1472,1490,1491,0},
{13,1,2,4,8,12,20,40,80,92,184,368,736,1472,1492,0,0},
{14,1,2,4,8,12,20,40,80,92,184,368,736,1472,1492,1493,0},
{13,1,2,4,8,16,18,36,54,90,180,360,720,1440,1494,0,0},
{13,1,2,3,5,10,20,23,46,92,184,368,736,1472,1495,0,0},
{13,1,2,4,8,16,24,40,80,160,184,368,736,1472,1496,0,0},
{14,1,2,4,8,16,24,40,80,160,184,368,736,1472,1496,1497,0},
{13,1,2,4,6,10,20,26,46,92,184,368,736,1472,1498,0,0},
{14,1,2,4,6,10,20,26,46,92,184,368,736,1472,1498,1499,0},
{13,1,2,4,8,10,18,28,46,92,184,368,736,1472,1500,0,0},
{14,1,2,4,8,10,18,28,46,92,184,368,736,1472,1500,1501,0},
{14,1,2,4,8,10,18,28,46,92,184,368,736,1472,1500,1502,0},
{14,1,2,3,6,12,24,48,60,120,240,480,960,1440,1500,1503,0},
{13,1,2,4,8,16,32,64,128,192,320,640,1280,1472,1504,0,0},
{14,1,2,4,8,16,32,64,128,192,320,640,1280,1472,1504,1505,0},
{14,1,2,4,8,16,32,64,128,192,320,640,1280,1472,1504,1506,0},
{14,1,2,3,5,10,20,40,42,84,168,336,376,752,1504,1507,0},
{13,1,2,4,8,16,20,36,72,92,184,368,736,1472,1508,0,0},
{14,1,2,4,8,16,20,36,72,92,184,368,736,1472,1508,1509,0},
{14,1,2,4,8,16,20,36,72,92,184,368,736,1472,1508,1510,0},
{14,1,2,4,6,7,11,22,44,88,94,188,376,752,1504,1511,0},
{13,1,2,4,8,16,24,40,80,160,184,368,736,1472,1512,0,0},
{14,1,2,4,8,16,24,40,80,160,184,368,736,1472,1512,1513,0},
{14,1,2,4,8,16,24,40,80,160,184,368,736,1472,1512,1514,0},
{14,1,2,3,6,12,24,48,72,144,288,576,1152,1440,1512,1515,0},
{14,1,2,3,4,7,14,28,56,112,168,336,672,1344,1512,1516,0},
{14,1,2,4,5,9,18,36,72,144,288,576,1152,1440,1512,1517,0},
{13,1,2,4,6,10,20,40,46,92,184,368,736,1472,1518,0,0},
{14,1,2,4,6,10,20,40,46,92,184,368,736,1472,1518,1519,0},
{13,1,2,4,8,16,32,48,80,160,320,368,736,1472,1520,0,0},
{14,1,2,4,8,16,32,48,80,160,320,368,736,1472,1520,1521,0},
{14,1,2,4,8,16,32,48,80,160,320,368,736,1472,1520,1522,0},
{14,1,2,3,5,10,20,40,80,160,320,640,1280,1440,1520,1523,0},
{13,1,2,4,8,12,20,40,52,92,184,368,736,1472,1524,0,0},
{14,1,2,4,8,12,20,40,52,92,184,368,736,1472,1524,1525,0},
{14,1,2,4,8,12,20,40,52,92,184,368,736,1472,1524,1526,0},
{14,1,2,3,5,10,13,23,46,92,184,368,381,762,1524,1527,0},
{13,1,2,4,8,16,20,36,56,92,184,368,736,1472,1528,0,0},
{14,1,2,4,8,16,20,36,56,92,184,368,736,1472,1528,1529,0},
{13,1,2,4,8,10,20,40,80,90,180,360,720,1440,1530,0,0},
{14,1,2,4,8,10,20,40,80,90,180,360,720,1440,1530,1531,0},
{14,1,2,4,8,10,20,40,80,90,180,360,720,1440,1530,1532,0},
{14,1,2,3,5,10,20,40,80,90,180,360,720,1440,1530,1533,0},
{14,1,2,4,8,10,20,40,80,90,180,360,720,1440,1530,1534,0},
{14,1,2,4,5,10,20,40,80,90,180,360,720,1440,1530,1535,0},
{11,1,2,4,8,16,32,64,128,256,512,1024,1536,0,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1536,1537,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1536,1538,0,0,0},
{12,1,2,3,6,12,24,48,96,192,384,768,1536,1539,0,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1536,1540,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1540,1541,0,0},
{12,1,2,4,6,12,24,48,96,192,384,768,1536,1542,0,0,0},
{13,1,2,4,6,12,24,48,96,192,384,768,1536,1542,1543,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1536,1544,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1544,1545,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1544,1546,0,0},
{13,1,2,3,6,12,24,48,96,192,384,386,772,1544,1547,0,0},
{12,1,2,4,8,12,24,48,96,192,384,768,1536,1548,0,0,0},
{13,1,2,4,8,12,24,48,96,192,384,768,1536,1548,1549,0,0},
{13,1,2,4,8,12,24,48,96,192,384,768,1536,1548,1550,0,0},
{13,1,2,3,6,12,24,48,96,192,384,768,1536,1548,1551,0,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1536,1552,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1552,1553,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1552,1554,0,0},
{13,1,2,3,6,12,24,48,96,192,194,388,776,1552,1555,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1552,1556,0,0},
{14,1,2,4,8,16,32,64,128,256,512,1024,1536,1552,1556,1557,0},
{13,1,2,4,6,12,24,48,96,192,384,388,776,1552,1558,0,0},
{14,1,2,4,6,12,24,48,96,192,384,388,776,1552,1558,1559,0},
{12,1,2,4,8,16,24,48,96,192,384,768,1536,1560,0,0,0},
{13,1,2,4,8,16,24,48,96,192,384,768,1536,1560,1561,0,0},
{13,1,2,4,8,16,24,48,96,192,384,768,1536,1560,1562,0,0},
{13,1,2,3,6,12,24,48,96,192,384,768,1536,1560,1563,0,0},
{13,1,2,4,8,16,24,48,96,192,384,768,1536,1560,1564,0,0},
{14,1,2,4,8,16,24,48,96,192,384,768,1536,1560,1564,1565,0},
{13,1,2,4,6,12,24,48,96,192,384,768,1536,1560,1566,0,0},
{14,1,2,4,6,12,24,48,96,192,384,768,1536,1560,1566,1567,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1536,1568,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1568,1569,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1568,1570,0,0},
{13,1,2,3,6,12,24,48,96,98,196,392,784,1568,1571,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1568,1572,0,0},
{14,1,2,4,8,16,32,64,128,256,512,1024,1536,1568,1572,1573,0},
{13,1,2,4,6,12,24,48,96,192,196,392,784,1568,1574,0,0},
{14,1,2,4,6,12,24,48,96,192,196,392,784,1568,1574,1575,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1568,1576,0,0},
{14,1,2,4,8,16,32,64,128,256,512,1024,1536,1568,1576,1577,0},
{14,1,2,4,8,16,32,64,128,256,512,1024,1536,1568,1576,1578,0},
{14,1,2,3,6,12,24,48,96,192,194,388,776,1552,1576,1579,0},
{13,1,2,4,8,12,24,48,96,192,384,392,784,1568,1580,0,0},
{14,1,2,4,8,12,24,48,96,192,384,392,784,1568,1580,1581,0},
{14,1,2,4,8,12,24,48,96,192,384,392,784,1568,1580,1582,0},
{14,1,2,3,6,12,24,48,96,98,196,392,784,1568,1580,1583,0},
{12,1,2,4,8,16,32,48,96,192,384,768,1536,1584,0,0,0},
{13,1,2,4,8,16,32,48,96,192,384,768,1536,1584,1585,0,0},
{13,1,2,4,8,16,32,48,96,192,384,768,1536,1584,1586,0,0},
{13,1,2,3,6,12,24,48,96,192,384,768,1536,1584,1587,0,0},
{13,1,2,4,8,16,32,48,96,192,384,768,1536,1584,1588,0,0},
{14,1,2,4,8,16,32,48,96,192,384,768,1536,1584,1588,1589,0},
{13,1,2,4,6,12,24,48,96,192,384,768,1536,1584,1590,0,0},
{14,1,2,4,6,12,24,48,96,192,384,768,1536,1584,1590,1591,0},
{13,1,2,4,8,16,32,48,96,192,384,768,1536,1584,1592,0,0},
{13,1,2,4,8,16,24,25,49,98,196,392,784,1568,1593,0,0},
{14,1,2,4,8,16,24,25,49,98,196,392,784,1568,1593,1594,0},
{14,1,2,4,8,16,24,25,49,98,196,392,784,1568,1593,1595,0},
{13,1,2,4,8,12,24,48,96,192,384,768,1536,1584,1596,0,0},
{14,1,2,4,8,12,24,48,96,192,384,768,1536,1584,1596,1597,0},
{14,1,2,4,8,12,24,48,96,192,384,768,1536,1584,1596,1598,0},
{14,1,2,3,6,12,24,48,96,192,384,768,1536,1584,1596,1599,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1536,1600,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1600,1601,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1600,1602,0,0},
{13,1,2,3,5,10,20,40,80,160,320,640,1280,1600,1603,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1600,1604,0,0},
{13,1,2,4,5,10,20,40,80,160,320,640,1280,1600,1605,0,0},
{13,1,2,4,6,10,20,40,80,160,320,640,1280,1600,1606,0,0},
{14,1,2,4,6,10,20,40,80,160,320,640,1280,1600,1606,1607,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1600,1608,0,0},
{13,1,2,4,8,9,17,25,50,100,200,400,800,1600,1609,0,0},
{13,1,2,4,8,10,20,40,80,160,320,640,1280,1600,1610,0,0},
{14,1,2,4,8,10,20,40,80,160,320,640,1280,1600,1610,1611,0},
{13,1,2,4,8,12,20,40,80,160,320,640,1280,1600,1612,0,0},
{13,1,2,4,8,12,13,25,50,100,200,400,800,1600,1613,0,0},
{14,1,2,4,8,12,13,25,50,100,200,400,800,1600,1613,1614,0},
{13,1,2,4,5,10,15,25,50,100,200,400,800,1600,1615,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1600,1616,0,0},
{13,1,2,4,8,16,17,34,50,100,200,400,800,1600,1617,0,0},
{13,1,2,4,8,16,18,34,50,100,200,400,800,1600,1618,0,0},
{14,1,2,4,8,16,18,34,50,100,200,400,800,1600,1618,1619,0},
{13,1,2,4,8,16,20,40,80,160,320,640,1280,1600,1620,0,0},
{14,1,2,4,8,16,20,40,80,160,320,640,1280,1600,1620,1621,0},
{14,1,2,4,8,16,20,40,80,160,320,640,1280,1600,1620,1622,0},
{14,1,2,3,5,10,20,40,80,160,320,640,1280,1600,1620,1623,0},
{13,1,2,4,8,16,24,40,80,160,320,640,1280,1600,1624,0,0},
{13,1,2,4,8,16,24,25,50,100,200,400,800,1600,1625,0,0},
{13,1,2,4,8,16,24,26,50,100,200,400,800,1600,1626,0,0},
{14,1,2,4,8,16,24,26,50,100,200,400,800,1600,1626,1627,0},
{14,1,2,4,8,16,24,26,50,100,200,400,800,1600,1626,1628,0},
{14,1,2,3,6,12,24,26,50,100,200,400,800,1600,1626,1629,0},
{13,1,2,4,8,10,20,30,50,100,200,400,800,1600,1630,0,0},
{14,1,2,4,8,10,20,30,50,100,200,400,800,1600,1630,1631,0},
{12,1,2,4,8,16,32,64,96,192,384,768,1536,1632,0,0,0},
{13,1,2,4,8,16,32,64,96,192,384,768,1536,1632,1633,0,0},
{13,1,2,4,8,16,32,64,96,192,384,768,1536,1632,1634,0,0},
{13,1,2,3,6,12,24,48,96,192,384,768,1536,1632,1635,0,0},
{13,1,2,4,8,16,32,64,96,192,384,768,1536,1632,1636,0,0},
{14,1,2,4,8,16,32,64,96,192,384,768,1536,1632,1636,1637,0},
{13,1,2,4,6,12,24,48,96,192,384,768,1536,1632,1638,0,0},
{14,1,2,4,6,12,24,48,96,192,384,768,1536,1632,1638,1639,0},
{13,1,2,4,8,16,32,64,96,192,384,768,1536,1632,1640,0,0},
{13,1,2,4,8,9,17,34,68,136,272,544,1088,1632,1641,0,0},
{14,1,2,4,8,9,17,34,68,136,272,544,1088,1632,1641,1642,0},
{14,1,2,4,8,9,17,34,68,136,272,544,1088,1632,1641,1643,0},
{13,1,2,4,8,12,24,48,96,192,384,768,1536,1632,1644,0,0},
{14,1,2,4,8,12,24,48,96,192,384,768,1536,1632,1644,1645,0},
{14,1,2,4,8,12,24,48,96,192,384,768,1536,1632,1644,1646,0},
{14,1,2,3,6,12,24,48,96,192,384,768,1536,1632,1644,1647,0},
{13,1,2,4,8,16,32,64,96,192,384,768,1536,1632,1648,0,0},
{13,1,2,4,8,16,17,34,68,136,272,544,1088,1632,1649,0,0},
{13,1,2,4,8,16,18,34,68,136,272,544,1088,1632,1650,0,0},
{14,1,2,4,8,16,18,34,68,136,272,544,1088,1632,1650,1651,0},
{13,1,2,4,8,16,32,48,52,100,200,400,800,1600,1652,0,0},
{14,1,2,4,8,16,32,48,52,100,200,400,800,1600,1652,1653,0},
{14,1,2,4,8,16,32,48,52,100,200,400,800,1600,1652,1654,0},
{14,1,2,3,6,12,24,26,50,100,200,400,800,826,1652,1655,0},
{13,1,2,4,8,16,24,48,96,192,384,768,1536,1632,1656,0,0},
{14,1,2,4,8,16,24,48,96,192,384,768,1536,1632,1656,1657,0},
{14,1,2,4,8,16,24,48,96,192,384,768,1536,1632,1656,1658,0},
{13,1,2,3,6,12,24,27,51,102,204,408,816,1632,1659,0,0},
{13,1,2,4,8,16,20,40,60,100,200,400,800,1600,1660,0,0},
{14,1,2,4,8,16,20,40,60,100,200,400,800,1600,1660,1661,0},
{14,1,2,4,8,16,20,40,60,100,200,400,800,1600,1660,1662,0},
{14,1,2,3,5,10,20,40,60,100,200,400,800,1600,1660,1663,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1536,1664,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1664,1665,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1664,1666,0,0},
{13,1,2,3,6,12,24,26,52,104,208,416,832,1664,1667,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1664,1668,0,0},
{13,1,2,3,5,10,13,26,52,104,208,416,832,1664,1669,0,0},
{13,1,2,4,6,12,24,48,52,104,208,416,832,1664,1670,0,0},
{13,1,2,4,6,7,13,26,52,104,208,416,832,1664,1671,0,0},
{13,1,2,3,5,8,13,26,52,104,208,416,832,1664,1672,0,0},
{13,1,2,4,8,9,18,26,52,104,208,416,832,1664,1673,0,0},
{13,1,2,4,6,10,20,26,52,104,208,416,832,1664,1674,0,0},
{14,1,2,4,6,10,20,26,52,104,208,416,832,1664,1674,1675,0},
{13,1,2,4,8,12,24,48,96,104,208,416,832,1664,1676,0,0},
{13,1,2,4,8,12,13,26,52,104,208,416,832,1664,1677,0,0},
{13,1,2,4,8,12,14,26,52,104,208,416,832,1664,1678,0,0},
{14,1,2,4,8,12,14,26,52,104,208,416,832,1664,1678,1679,0},
{13,1,2,4,6,10,16,26,52,104,208,416,832,1664,1680,0,0},
{13,1,2,4,8,9,17,26,52,104,208,416,832,1664,1681,0,0},
{13,1,2,4,8,16,18,36,52,104,208,416,832,1664,1682,0,0},
{13,1,2,3,6,12,24,48,51,102,204,408,816,1632,1683,0,0},
{13,1,2,4,8,12,20,40,52,104,208,416,832,1664,1684,0,0},
{14,1,2,4,8,12,20,40,52,104,208,416,832,1664,1684,1685,0},
{13,1,2,4,6,12,24,48,54,102,204,408,816,1632,1686,0,0},
{14,1,2,4,6,12,24,48,54,102,204,408,816,1632,1686,1687,0},
{13,1,2,4,8,16,24,48,96,192,208,416,832,1664,1688,0,0},
{14,1,2,4,8,16,24,48,96,192,208,416,832,1664,1688,1689,0},
{13,1,2,4,8,16,24,26,52,104,208,416,832,1664,1690,0,0},
{14,1,2,4,8,16,24,26,52,104,208,416,832,1664,1690,1691,0},
{13,1,2,4,8,16,24,28,52,104,208,416,832,1664,1692,0,0},
{14,1,2,4,8,16,24,28,52,104,208,416,832,1664,1692,1693,0},
{14,1,2,4,8,16,24,28,52,104,208,416,832,1664,1692,1694,0},
{14,1,2,3,6,12,14,26,52,104,208,416,832,846,1692,1695,0},
{13,1,2,4,8,12,20,32,52,104,208,416,832,1664,1696,0,0},
{14,1,2,4,8,12,20,32,52,104,208,416,832,1664,1696,1697,0},
{13,1,2,4,8,16,18,34,52,104,208,416,832,1664,1698,0,0},
{14,1,2,4,8,16,18,34,52,104,208,416,832,1664,1698,1699,0},
{13,1,2,4,8,16,32,36,72,104,208,416,832,1664,1700,0,0},
{14,1,2,4,8,16,32,36,72,104,208,416,832,1664,1700,1701,0},
{14,1,2,4,8,16,32,36,72,104,208,416,832,1664,1700,1702,0},
{14,1,2,3,5,10,20,40,80,100,200,400,800,1600,1700,1703,0},
{13,1,2,4,8,16,24,40,80,104,208,416,832,1664,1704,0,0},
{14,1,2,4,8,16,24,40,80,104,208,416,832,1664,1704,1705,0},
{14,1,2,4,8,16,24,40,80,104,208,416,832,1664,1704,1706,0},
{14,1,2,3,5,10,13,26,52,104,208,416,426,852,1704,1707,0},
{14,1,2,4,8,16,24,40,80,104,208,416,832,1664,1704,1708,0},
{14,1,2,3,5,10,13,26,52,104,208,416,426,852,1704,1709,0},
{14,1,2,4,6,10,20,26,52,104,208,416,832,852,1704,1710,0},
{14,1,2,3,5,10,15,25,50,53,106,212,424,848,1696,1711,0},
{13,1,2,4,8,16,32,48,96,192,384,416,832,1664,1712,0,0},
{14,1,2,4,8,16,32,48,96,192,384,416,832,1664,1712,1713,0},
{14,1,2,4,8,16,32,48,96,192,384,416,832,1664,1712,1714,0},
{14,1,2,3,6,12,24,26,52,104,208,416,832,856,1712,1715,0},
{13,1,2,4,8,16,32,48,52,104,208,416,832,1664,1716,0,0},
{14,1,2,4,8,16,32,48,52,104,208,416,832,1664,1716,1717,0},
{14,1,2,4,8,16,32,48,52,104,208,416,832,1664,1716,1718,0},
{14,1,2,3,6,12,24,26,52,104,208,416,832,1664,1716,1719,0},
{13,1,2,4,8,16,32,48,56,104,208,416,832,1664,1720,0,0},
{14,1,2,4,8,16,32,48,56,104,208,416,832,1664,1720,1721,0},
{14,1,2,4,8,16,32,48,56,104,208,416,832,1664,1720,1722,0},
{14,1,2,3,5,10,20,40,80,120,200,400,800,1600,1720,1723,0},
{14,1,2,4,8,16,32,48,56,104,208,416,832,1664,1720,1724,0},
{14,1,2,4,5,10,20,40,80,120,200,400,800,1600,1720,1725,0},
{14,1,2,4,6,10,20,40,80,120,200,400,800,1600,1720,1726,0},
{14,1,2,4,6,7,13,26,52,104,208,215,430,860,1720,1727,0},
{12,1,2,4,8,16,32,64,128,192,384,768,1536,1728,0,0,0},
{13,1,2,4,8,16,32,64,128,192,384,768,1536,1728,1729,0,0},
{13,1,2,4,8,16,32,64,128,192,384,768,1536,1728,1730,0,0},
{13,1,2,3,6,12,24,48,96,192,384,768,1536,1728,1731,0,0},
{13,1,2,4,8,16,32,64,128,192,384,768,1536,1728,1732,0,0},
{13,1,2,4,5,9,18,36,72,144,288,576,1152,1728,1733,0,0},
{13,1,2,4,6,12,24,48,96,192,384,768,1536,1728,1734,0,0},
{14,1,2,4,6,12,24,48,96,192,384,768,1536,1728,1734,1735,0},
{13,1,2,4,8,16,32,64,128,192,384,768,1536,1728,1736,0,0},
{13,1,2,4,8,9,18,36,72,144,288,576,1152,1728,1737,0,0},
{13,1,2,4,8,10,18,36,72,144,288,576,1152,1728,1738,0,0},
{14,1,2,4,8,10,18,36,72,144,288,576,1152,1728,1738,1739,0},
{13,1,2,4,8,12,24,48,96,192,384,768,1536,1728,1740,0,0},
{14,1,2,4,8,12,24,48,96,192,384,768,1536,1728,1740,1741,0},
{14,1,2,4,8,12,24,48,96,192,384,768,1536,1728,1740,1742,0},
{13,1,2,3,6,12,15,27,54,108,216,432,864,1728,1743,0,0},
{13,1,2,4,8,16,32,64,128,192,384,768,1536,1728,1744,0,0},
{14,1,2,4,8,16,32,64,128,192,384,768,1536,1728,1744,1745,0},
{13,1,2,4,8,16,18,36,72,144,288,576,1152,1728,1746,0,0},
{14,1,2,4,8,16,18,36,72,144,288,576,1152,1728,1746,1747,0},
{13,1,2,4,8,16,20,36,72,144,288,576,1152,1728,1748,0,0},
{14,1,2,4,8,16,20,36,72,144,288,576,1152,1728,1748,1749,0},
{14,1,2,4,8,16,20,36,72,144,288,576,1152,1728,1748,1750,0},
{14,1,2,3,6,12,24,48,96,98,194,388,776,874,1748,1751,0},
{13,1,2,4,8,16,24,48,96,192,384,768,1536,1728,1752,0,0},
{14,1,2,4,8,16,24,48,96,192,384,768,1536,1728,1752,1753,0},
{14,1,2,4,8,16,24,48,96,192,384,768,1536,1728,1752,1754,0},
{13,1,2,3,6,12,24,27,54,108,216,432,864,1728,1755,0,0},
{14,1,2,3,6,12,24,27,54,108,216,432,864,1728,1755,1756,0},
{14,1,2,3,6,12,24,27,54,108,216,432,864,1728,1755,1757,0},
{13,1,2,4,6,12,24,30,54,108,216,432,864,1728,1758,0,0},
{14,1,2,4,6,12,24,30,54,108,216,432,864,1728,1758,1759,0},
{13,1,2,4,8,16,32,64,128,192,384,768,1536,1728,1760,0,0},
{14,1,2,4,8,16,32,64,128,192,384,768,1536,1728,1760,1761,0},
{14,1,2,4,8,16,32,64,128,192,384,768,1536,1728,1760,1762,0},
{14,1,2,3,5,10,20,40,80,160,320,640,1280,1600,1760,1763,0},
{13,1,2,4,8,16,32,36,72,144,288,576,1152,1728,1764,0,0},
{14,1,2,4,8,16,32,36,72,144,288,576,1152,1728,1764,1765,0},
{14,1,2,4,8,16,32,36,72,144,288,576,1152,1728,1764,1766,0},
{14,1,2,3,6,12,24,36,72,144,288,576,1152,1728,1764,1767,0},
{13,1,2,4,8,16,32,40,72,144,288,576,1152,1728,1768,0,0},
{14,1,2,4,8,16,32,40,72,144,288,576,1152,1728,1768,1769,0},
{14,1,2,4,8,16,32,40,72,144,288,576,1152,1728,1768,1770,0},
{14,1,2,3,6,12,24,26,52,104,208,416,832,1664,1768,1771,0},
{14,1,2,4,8,16,32,40,72,144,288,576,1152,1728,1768,1772,0},
{14,1,2,3,5,10,13,26,52,104,208,416,832,1664,1768,1773,0},
{14,1,2,4,6,12,24,48,52,104,208,416,832,1664,1768,1774,0},
{14,1,2,4,6,7,13,26,52,104,208,416,832,1664,1768,1775,0},
{13,1,2,4,8,16,32,48,96,192,384,768,1536,1728,1776,0,0},
{14,1,2,4,8,16,32,48,96,192,384,768,1536,1728,1776,1777,0},
{14,1,2,4,8,16,32,48,96,192,384,768,1536,1728,1776,1778,0},
{14,1,2,3,6,12,24,48,96,192,384,768,1536,1728,1776,1779,0},
{14,1,2,4,8,16,32,48,96,192,384,768,1536,1728,1776,1780,0},
{14,1,2,4,5,9,18,36,72,144,148,296,592,1184,1776,1781,0},
{13,1,2,4,6,12,24,48,54,108,216,432,864,1728,1782,0,0},
{14,1,2,4,6,12,24,48,54,108,216,432,864,1728,1782,1783,0},
{14,1,2,4,6,12,24,48,54,108,216,432,864,1728,1782,1784,0},
{14,1,2,3,6,12,24,48,54,108,216,432,864,1728,1782,1785,0},
{14,1,2,4,6,12,24,48,54,108,216,432,864,1728,1782,1786,0},
{14,1,2,4,5,9,18,36,54,108,216,432,864,1728,1782,1787,0},
{13,1,2,4,8,12,24,48,60,108,216,432,864,1728,1788,0,0},
{14,1,2,4,8,12,24,48,60,108,216,432,864,1728,1788,1789,0},
{14,1,2,4,8,12,24,48,60,108,216,432,864,1728,1788,1790,0},
{14,1,2,3,6,12,24,48,60,108,216,432,864,1728,1788,1791,0},
{12,1,2,4,8,16,32,64,128,256,512,1024,1536,1792,0,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1792,1793,0,0},
{13,1,2,4,8,16,32,64,128,256,512,1024,1536,1792,1794,0,0},
{13,1,2,3,6,12,14,28,56,112,224,448,896,1792,1795,0,0},
{13,1,2,3,4,7,14,28,56,112,224,448,896,1792,1796,0,0},
{13,1,2,4,5,10,14,28,56,112,224,448,896,1792,1797,0,0},
{13,1,2,4,6,12,24,28,56,112,224,448,896,1792,1798,0,0},
{13,1,2,4,6,7,14,28,56,112,224,448,896,1792,1799,0,0},
{13,1,2,4,6,8,14,28,56,112,224,448,896,1792,1800,0,0},
{13,1,2,4,5,9,14,28,56,112,224,448,896,1792,1801,0,0},
{13,1,2,4,8,10,20,28,56,112,224,448,896,1792,1802,0,0},
{14,1,2,4,8,10,20,28,56,112,224,448,896,1792,1802,1803,0},
{13,1,2,4,8,12,24,48,56,112,224,448,896,1792,1804,0,0},
{14,1,2,4,8,12,24,48,56,112,224,448,896,1792,1804,1805,0},
{13,1,2,4,8,12,14,28,56,112,224,448,896,1792,1806,0,0},
{14,1,2,4,8,12,14,28,56,112,224,448,896,1792,1806,1807,0},
{13,1,2,4,8,12,16,28,56,112,224,448,896,1792,1808,0,0},
{14,1,2,4,8,12,16,28,56,112,224,448,896,1792,1808,1809,0},
{13,1,2,4,8,10,18,28,56,112,224,448,896,1792,1810,0,0},
{14,1,2,4,8,10,18,28,56,112,224,448,896,1792,1810,1811,0},
{13,1,2,4,8,16,20,40,56,112,224,448,896,1792,1812,0,0},
{14,1,2,4,8,16,20,40,56,112,224,448,896,1792,1812,1813,0},
{14,1,2,4,8,16,20,40,56,112,224,448,896,1792,1812,1814,0},
{14,1,2,3,5,7,14,28,56,112,224,448,453,906,1812,1815,0},
{13,1,2,4,8,16,24,48,96,112,224,448,896,1792,1816,0,0},
{14,1,2,4,8,16,24,48,96,112,224,448,896,1792,1816,1817,0},
{14,1,2,4,8,16,24,48,96,112,224,448,896,1792,1816,1818,0},
{14,1,2,3,6,12,14,28,56,112,224,448,896,908,1816,1819,0},
{13,1,2,4,8,16,24,28,56,112,224,448,896,1792,1820,0,0},
{14,1,2,4,8,16,24,28,56,112,224,448,896,1792,1820,1821,0},
{14,1,2,4,8,16,24,28,56,112,224,448,896,1792,1820,1822,0},
{14,1,2,3,6,12,14,28,56,112,224,448,896,1792,1820,1823,0},
{13,1,2,4,8,16,24,32,56,112,224,448,896,1792,1824,0,0},
{14,1,2,4,8,16,24,32,56,112,224,448,896,1792,1824,1825,0},
{14,1,2,4,8,16,24,32,56,112,224,448,896,1792,1824,1826,0},
{14,1,2,3,6,12,24,48,96,192,384,768,1536,1728,1824,1827,0},
{13,1,2,4,8,16,20,36,56,112,224,448,896,1792,1828,0,0},
{14,1,2,4,8,16,20,36,56,112,224,448,896,1792,1828,1829,0},
{14,1,2,4,8,16,20,36,56,112,224,448,896,1792,1828,1830,0},
{14,1,2,4,5,7,14,19,38,76,152,304,608,1216,1824,1831,0},
{13,1,2,4,8,16,32,40,80,112,224,448,896,1792,1832,0,0},
{14,1,2,4,8,16,32,40,80,112,224,448,896,1792,1832,1833,0},
{14,1,2,4,8,16,32,40,80,112,224,448,896,1792,1832,1834,0},
{14,1,2,3,5,7,14,28,56,112,224,229,458,916,1832,1835,0},
{13,1,2,4,8,12,24,48,96,108,216,432,864,1728,1836,0,0},
{14,1,2,4,8,12,24,48,96,108,216,432,864,1728,1836,1837,0},
{14,1,2,4,8,12,24,48,96,108,216,432,864,1728,1836,1838,0},
{14,1,2,3,6,12,24,48,96,108,216,432,864,1728,1836,1839,0},
{13,1,2,4,8,16,32,48,96,192,224,448,896,1792,1840,0,0},
{14,1,2,4,8,16,32,48,96,192,224,448,896,1792,1840,1841,0},
{14,1,2,4,8,16,32,48,96,192,224,448,896,1792,1840,1842,0},
{14,1,2,3,5,10,20,40,80,160,240,400,800,1600,1840,1843,0},
{14,1,2,3,4,7,14,28,56,112,115,230,460,920,1840,1844,0},
{14,1,2,4,5,10,20,40,80,160,240,400,800,1600,1840,1845,0},
{14,1,2,4,6,10,20,40,80,160,240,400,800,1600,1840,1846,0},
{14,1,2,4,6,7,14,28,56,112,224,230,460,920,1840,1847,0},
{13,1,2,4,8,16,32,48,56,112,224,448,896,1792,1848,0,0},
{14,1,2,4,8,16,32,48,56,112,224,448,896,1792,1848,1849,0},
{14,1,2,4,8,16,32,48,56,112,224,448,896,1792,1848,1850,0},
{14,1,2,3,6,12,14,28,56,112,224,448,896,1792,1848,1851,0},
{14,1,2,3,4,7,14,28,56,112,224,448,896,1792,1848,1852,0},
{14,1,2,4,5,10,14,28,56,112,224,448,896,1792,1848,1853,0},
{14,1,2,4,6,12,24,28,56,112,224,448,896,1792,1848,1854,0},
{14,1,2,4,6,7,14,28,56,112,224,448,896,1792,1848,1855,0},
{13,1,2,4,8,16,32,48,64,112,224,448,896,1792,1856,0,0},
{14,1,2,4,8,16,32,48,64,112,224,448,896,1792,1856,1857,0},
{14,1,2,4,8,16,32,48,64,112,224,448,896,1792,1856,1858,0},
{14,1,2,3,6,8,14,28,56,112,224,232,464,928,1856,1859,0},
{14,1,2,3,4,7,14,28,56,112,116,232,464,928,1856,1860,0},
{14,1,2,4,5,10,14,28,56,112,116,232,464,928,1856,1861,0},
{14,1,2,4,5,6,12,24,29,58,116,232,464,928,1856,1862,0},
{14,1,2,3,4,7,14,28,56,112,116,232,464,928,1856,1863,0},
{13,1,2,4,8,16,32,40,72,112,224,448,896,1792,1864,0,0},
{14,1,2,4,8,16,32,40,72,112,224,448,896,1792,1864,1865,0},
{14,1,2,4,8,16,32,40,72,112,224,448,896,1792,1864,1866,0},
{14,1,2,3,4,7,11,22,29,58,116,232,464,928,1856,1867,0},
{14,1,2,4,8,16,32,40,72,112,224,448,896,1792,1864,1868,0},
{14,1,2,4,5,9,14,28,56,112,224,233,466,932,1864,1869,0},
{14,1,2,4,6,8,14,28,56,112,224,232,464,928,1856,1870,0},
{14,1,2,4,8,12,14,15,29,58,116,232,464,928,1856,1871,0},
{13,1,2,4,8,16,32,64,80,160,224,448,896,1792,1872,0,0},
{14,1,2,4,8,16,32,64,80,160,224,448,896,1792,1872,1873,0},
{14,1,2,4,8,16,32,64,80,160,224,448,896,1792,1872,1874,0},
{14,1,2,3,6,12,24,48,96,144,288,576,1152,1728,1872,1875,0},
{14,1,2,4,8,16,32,64,80,160,224,448,896,1792,1872,1876,0},
{14,1,2,4,5,9,18,36,72,144,288,576,1152,1728,1872,1877,0},
{14,1,2,4,6,12,24,48,96,144,288,576,1152,1728,1872,1878,0},
{14,1,2,4,6,7,13,26,52,104,208,416,832,1664,1872,1879,0},
{14,1,2,3,5,8,13,26,52,104,208,416,832,1664,1872,1880,0},
{14,1,2,4,8,9,18,36,72,144,288,576,1152,1728,1872,1881,0},
{14,1,2,4,8,10,18,36,72,144,288,576,1152,1728,1872,1882,0},
{14,1,2,4,8,9,18,27,54,108,116,232,464,928,1856,1883,0},
{14,1,2,4,8,12,24,48,96,144,288,576,1152,1728,1872,1884,0},
{14,1,2,4,8,12,13,26,52,104,208,416,832,1664,1872,1885,0},
{14,1,2,4,8,12,14,26,52,104,208,416,832,1664,1872,1886,0},
{14,1,2,3,6,9,15,30,39,78,156,312,624,1248,1872,1887,0},
{13,1,2,4,8,16,32,64,96,192,384,448,896,1792,1888,0,0},
{14,1,2,4,8,16,32,64,96,192,384,448,896,1792,1888,1889,0},
{14,1,2,4,8,16,32,64,96,192,384,448,896,1792,1888,1890,0},
{14,1,2,3,6,12,14,28,56,112,224,236,472,944,1888,1891,0},
{14,1,2,3,4,7,14,28,56,59,118,236,472,944,1888,1892,0},
{14,1,2,4,5,9,18,36,41,82,118,236,472,944,1888,1893,0},
{14,1,2,4,6,12,24,28,56,112,224,448,472,944,1888,1894,0},
{14,1,2,4,6,7,14,28,56,112,118,236,472,944,1888,1895,0},
{14,1,2,4,6,8,14,28,56,112,118,236,472,944,1888,1896,0},
{14,1,2,4,8,9,17,34,42,84,118,236,472,944,1888,1897,0},
{14,1,2,4,8,10,18,36,72,82,164,236,472,944,1888,1898,0},
{14,1,2,3,6,12,24,27,54,78,156,312,624,1248,1872,1899,0},
{14,1,2,4,8,12,24,48,56,112,224,448,896,944,1888,1900,0},
{14,1,2,4,6,7,13,26,52,59,118,236,472,944,1888,1901,0},
{14,1,2,4,8,12,14,28,56,112,224,236,472,944,1888,1902,0},
{15,1,2,4,8,12,14,28,56,112,224,236,472,944,1888,1902,1903},
{13,1,2,4,8,16,32,64,96,112,224,448,896,1792,1904,0,0},
{14,1,2,4,8,16,32,64,96,112,224,448,896,1792,1904,1905,0},
{14,1,2,4,8,16,32,64,96,112,224,448,896,1792,1904,1906,0},
{14,1,2,3,6,12,14,28,56,112,224,448,896,1792,1904,1907,0},
{14,1,2,3,4,7,14,28,56,112,224,448,896,1792,1904,1908,0},
{14,1,2,4,5,10,14,28,56,112,224,448,896,1792,1904,1909,0},
{14,1,2,4,6,12,24,28,56,112,224,448,896,1792,1904,1910,0},
{14,1,2,4,6,7,14,28,56,112,224,448,896,1792,1904,1911,0},
{14,1,2,4,6,8,14,28,56,112,224,448,896,1792,1904,1912,0},
{14,1,2,4,5,9,14,28,56,112,224,448,896,1792,1904,1913,0},
{14,1,2,4,8,10,20,28,56,112,224,448,896,1792,1904,1914,0},
{14,1,2,4,5,9,18,27,54,59,118,236,472,944,1888,1915,0},
{14,1,2,4,8,12,24,48,56,112,224,448,896,1792,1904,1916,0},
{14,1,2,4,8,9,18,27,45,90,117,234,468,936,1872,1917,0},
{14,1,2,4,8,12,14,28,56,112,224,448,896,1792,1904,1918,0},
{14,1,2,3,6,12,14,28,31,59,118,236,472,944,1888,1919,0},
{12,1,2,4,8,16,32,64,128,256,384,768,1536,1920,0,0,0},
{13,1,2,4,8,16,32,64,128,256,384,768,1536,1920,1921,0,0},
{13,1,2,4,8,16,32,64,128,256,384,768,1536,1920,1922,0,0},
{13,1,2,3,6,12,24,48,96,192,384,768,1536,1920,1923,0,0},
{13,1,2,4,8,16,32,64,128,256,384,768,1536,1920,1924,0,0},
{13,1,2,4,5,10,20,40,80,160,320,640,1280,1920,1925,0,0},
{13,1,2,4,6,12,24,48,96,192,384,768,1536,1920,1926,0,0},
{14,1,2,4,6,12,24,48,96,192,384,768,1536,1920,1926,1927,0},
{13,1,2,4,8,16,32,64,128,256,384,768,1536,1920,1928,0,0},
{13,1,2,3,6,9,15,30,60,120,240,480,960,1920,1929,0,0},
{13,1,2,4,8,10,20,40,80,160,320,640,1280,1920,1930,0,0},
{14,1,2,4,8,10,20,40,80,160,320,640,1280,1920,1930,1931,0},
{13,1,2,4,8,12,24,48,96,192,384,768,1536,1920,1932,0,0},
{14,1,2,4,8,12,24,48,96,192,384,768,1536,1920,1932,1933,0},
{14,1,2,4,8,12,24,48,96,192,384,768,1536,1920,1932,1934,0},
{13,1,2,3,6,12,15,30,60,120,240,480,960,1920,1935,0,0},
{13,1,2,4,8,16,32,64,128,256,384,768,1536,1920,1936,0,0},
{14,1,2,4,8,16,32,64,128,256,384,768,1536,1920,1936,1937,0},
{13,1,2,4,6,12,18,30,60,120,240,480,960,1920,1938,0,0},
{14,1,2,4,6,12,18,30,60,120,240,480,960,1920,1938,1939,0},
{13,1,2,4,8,16,20,40,80,160,320,640,1280,1920,1940,0,0},
{14,1,2,4,8,16,20,40,80,160,320,640,1280,1920,1940,1941,0},
{14,1,2,4,8,16,20,40,80,160,320,640,1280,1920,1940,1942,0},
{14,1,2,3,5,10,20,40,80,160,320,640,1280,1920,1940,1943,0},
{13,1,2,4,8,16,24,48,96,192,384,768,1536,1920,1944,0,0},
{14,1,2,4,8,16,24,48,96,192,384,768,1536,1920,1944,1945,0},
{14,1,2,4,8,16,24,48,96,192,384,768,1536,1920,1944,1946,0},
{14,1,2,3,6,12,24,48,96,192,384,768,1536,1920,1944,1947,0},
{14,1,2,4,8,16,24,48,96,192,384,768,1536,1920,1944,1948,0},
{14,1,2,4,5,9,18,36,72,144,216,432,864,1728,1944,1949,0},
{13,1,2,4,6,12,24,30,60,120,240,480,960,1920,1950,0,0},
{14,1,2,4,6,12,24,30,60,120,240,480,960,1920,1950,1951,0},
{13,1,2,4,8,16,32,64,128,256,384,768,1536,1920,1952,0,0},
{14,1,2,4,8,16,32,64,128,256,384,768,1536,1920,1952,1953,0},
{14,1,2,4,8,16,32,64,128,256,384,768,1536,1920,1952,1954,0},
{14,1,2,3,6,12,24,48,96,98,196,392,488,976,1952,1955,0},
{13,1,2,4,8,12,24,36,60,120,240,480,960,1920,1956,0,0},
{14,1,2,4,8,12,24,36,60,120,240,480,960,1920,1956,1957,0},
{14,1,2,4,8,12,24,36,60,120,240,480,960,1920,1956,1958,0},
{14,1,2,3,6,12,24,36,60,120,240,480,960,1920,1956,1959,0},
{13,1,2,4,8,16,32,40,80,160,320,640,1280,1920,1960,0,0},
{14,1,2,4,8,16,32,40,80,160,320,640,1280,1920,1960,1961,0},
{14,1,2,4,8,16,32,40,80,160,320,640,1280,1920,1960,1962,0},
{14,1,2,3,5,10,20,40,80,160,320,640,1280,1920,1960,1963,0},
{14,1,2,4,8,16,32,40,80,160,320,640,1280,1920,1960,1964,0},
{14,1,2,4,5,10,20,40,80,160,320,640,1280,1920,1960,1965,0},
{14,1,2,4,6,10,20,40,80,160,320,640,1280,1920,1960,1966,0},
{14,1,2,4,5,10,15,30,60,120,240,244,488,976,1952,1967,0},
{13,1,2,4,8,16,32,48,96,192,384,768,1536,1920,1968,0,0},
{14,1,2,4,8,16,32,48,96,192,384,768,1536,1920,1968,1969,0},
{14,1,2,4,8,16,32,48,96,192,384,768,1536,1920,1968,1970,0},
{14,1,2,3,6,12,24,48,96,192,384,768,1536,1920,1968,1971,0},
{14,1,2,4,8,16,32,48,96,192,384,768,1536,1920,1968,1972,0},
{14,1,2,4,5,10,20,40,80,160,164,328,656,1312,1968,1973,0},
{14,1,2,4,6,12,24,48,96,192,384,768,1536,1920,1968,1974,0},
{14,1,2,4,5,10,15,30,60,120,240,480,490,980,1960,1975,0},
{14,1,2,4,8,16,32,48,96,192,384,768,1536,1920,1968,1976,0},
{14,1,2,4,5,9,18,36,41,82,164,328,656,1312,1968,1977,0},
{14,1,2,4,8,10,20,40,80,160,320,328,656,1312,1968,1978,0},
{15,1,2,4,8,10,20,40,80,160,320,328,656,1312,1968,1978,1979},
{13,1,2,4,8,12,24,48,60,120,240,480,960,1920,1980,0,0},
{14,1,2,4,8,12,24,48,60,120,240,480,960,1920,1980,1981,0},
{14,1,2,4,8,12,24,48,60,120,240,480,960,1920,1980,1982,0},
{14,1,2,3,6,12,24,48,60,120,240,480,960,1920,1980,1983,0},
{13,1,2,4,8,16,32,64,128,256,384,768,1536,1920,1984,0,0},
{14,1,2,4,8,16,32,64,128,256,384,768,1536,1920,1984,1985,0},
{14,1,2,4,8,16,32,64,128,256,384,768,1536,1920,1984,1986,0},
{14,1,2,3,6,12,24,48,50,100,200,248,496,992,1984,1987,0},
{14,1,2,3,4,7,14,28,31,62,124,248,496,992,1984,1988,0},
{14,1,2,4,5,10,20,40,80,84,168,248,496,992,1984,1989,0},
{14,1,2,4,6,12,24,48,96,100,200,400,496,992,1984,1990,0},
{14,1,2,4,6,7,14,28,56,62,124,248,496,992,1984,1991,0},
{13,1,2,4,8,16,24,48,72,120,240,480,960,1920,1992,0,0},
{14,1,2,4,8,16,24,48,72,120,240,480,960,1920,1992,1993,0},
{14,1,2,4,8,16,24,48,72,120,240,480,960,1920,1992,1994,0},
{14,1,2,3,6,12,24,48,72,120,240,480,960,1920,1992,1995,0},
{14,1,2,4,8,16,24,48,72,120,240,480,960,1920,1992,1996,0},
{14,1,2,3,5,10,20,40,80,83,166,332,664,1328,1992,1997,0},
{14,1,2,4,6,12,24,48,72,120,240,480,960,1920,1992,1998,0},
{14,1,2,4,5,10,15,30,60,120,124,248,496,992,1984,1999,0},
{13,1,2,4,8,16,32,64,80,160,320,640,1280,1920,2000,0,0},
{14,1,2,4,8,16,32,64,80,160,320,640,1280,1920,2000,2001,0},
{14,1,2,4,8,16,32,64,80,160,320,640,1280,1920,2000,2002,0},
{14,1,2,3,5,10,20,40,80,160,320,640,1280,1920,2000,2003,0},
{14,1,2,4,8,16,32,64,80,160,320,640,1280,1920,2000,2004,0},
{14,1,2,4,5,10,20,40,80,160,320,640,1280,1920,2000,2005,0},
{14,1,2,4,6,10,20,40,80,160,320,640,1280,1920,2000,2006,0},
{14,1,2,3,6,9,15,30,60,120,240,249,498,996,1992,2007,0},
{14,1,2,4,8,16,32,64,80,160,320,640,1280,1920,2000,2008,0},
{14,1,2,4,8,9,17,25,50,100,200,400,800,1600,2000,2009,0},
{14,1,2,4,8,10,20,40,80,160,320,640,1280,1920,2000,2010,0},
{14,1,2,4,8,9,18,27,54,62,124,248,496,992,1984,2011,0},
{14,1,2,4,8,12,20,40,80,160,320,640,1280,1920,2000,2012,0},
{14,1,2,4,8,12,13,25,50,100,200,400,800,1600,2000,2013,0},
{14,1,2,4,8,10,20,30,60,120,240,248,496,992,1984,2014,0},
{14,1,2,4,5,10,15,25,50,100,200,400,800,1600,2000,2015,0},
{13,1,2,4,8,16,32,64,96,192,384,768,1536,1920,2016,0,0},
{14,1,2,4,8,16,32,64,96,192,384,768,1536,1920,2016,2017,0},
{14,1,2,4,8,16,32,64,96,192,384,768,1536,1920,2016,2018,0},
{14,1,2,3,6,12,24,48,96,192,384,768,1536,1920,2016,2019,0},
{14,1,2,3,4,7,14,28,56,112,224,448,896,1792,2016,2020,0},
{14,1,2,4,5,10,14,28,56,112,224,448,896,1792,2016,2021,0},
{14,1,2,4,6,12,24,48,96,192,384,768,1536,1920,2016,2022,0},
{14,1,2,4,6,7,14,28,56,112,224,448,896,1792,2016,2023,0},
{14,1,2,4,6,8,14,28,56,112,224,448,896,1792,2016,2024,0},
{14,1,2,4,5,9,14,28,56,112,224,448,896,1792,2016,2025,0},
{14,1,2,4,8,10,20,28,56,112,224,448,896,1792,2016,2026,0},
{14,1,2,4,8,10,11,21,42,84,168,336,672,1344,2016,2027,0},
{14,1,2,3,6,9,12,21,42,84,168,336,672,1344,2016,2028,0},
{14,1,2,3,5,8,13,21,42,84,168,336,672,1344,2016,2029,0},
{14,1,2,4,8,12,14,28,56,112,224,448,896,1792,2016,2030,0},
{14,1,2,3,6,12,15,30,42,84,168,336,672,1344,2016,2031,0},
{14,1,2,4,8,12,16,28,56,112,224,448,896,1792,2016,2032,0},
{14,1,2,4,8,16,17,34,68,84,168,336,672,1344,2016,2033,0},
{14,1,2,4,8,10,18,28,56,112,224,448,896,1792,2016,2034,0},
{14,1,2,3,5,10,20,40,43,83,166,332,664,1328,1992,2035,0},
{14,1,2,4,8,16,20,40,56,112,224,448,896,1792,2016,2036,0},
{14,1,2,4,8,16,20,21,42,84,168,336,672,1344,2016,2037,0},
{14,1,2,4,8,16,20,22,42,84,168,336,672,1344,2016,2038,0},
{14,1,2,3,5,10,20,23,43,63,126,252,504,1008,2016,2039,0},
{13,1,2,4,8,16,24,48,96,120,240,480,960,1920,2040,0,0},
{14,1,2,4,8,16,24,48,96,120,240,480,960,1920,2040,2041,0},
{14,1,2,4,8,16,24,48,96,120,240,480,960,1920,2040,2042,0},
{14,1,2,3,6,12,24,48,96,120,240,480,960,1920,2040,2043,0},
{14,1,2,4,8,16,24,48,96,120,240,480,960,1920,2040,2044,0},
{14,1,2,4,5,10,20,40,80,120,240,480,960,1920,2040,2045,0},
{14,1,2,4,6,12,24,48,96,120,240,480,960,1920,2040,2046,0},
{15,1,2,4,6,12,24,48,96,120,240,480,960,1920,2040,2046,2047},
{11,1,2,4,8,16,32,64,128,256,512,1024,2048,0,0,0,0}};

#endif // ADDITIONCHAINS_H
