//
// This file is part of the aMule AdunanzA Project (mod of official aMule)
//
// Copyright (c) 2003-2012 aMule AdunanzA Team ( http://www.adunanza.net )
//
// Any parts of this program derived from the xMule, lMule, eMule or aMule project,
// or contributed by third-party developers are copyrighted by their
// respective authors.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA
//

#if !defined(_ADUNANZA_H_)
#define _ADUNANZA_H_

#ifdef HAVE_CONFIG_H
	#include "config.h"			//   VERSION
#endif


#include <queue>   // Mr Hyde
#include "Types.h" // Mr Hyde

#include "FastwebNet.h"

//////////////////////////////////////////////////////////////////////////////////////
//
#define ADU_MOD_NAME _T("AdunanzA")

#define ADU_VER_MAJ   2012 
#define ADU_VER_MIN   1

// IMPOSTARE LA SEG. ADU_BETA_MAJ A 0 PER LE VERSIONI RILASCIATE UFFICIALMENTE 
#define ADU_BETA_MAJ 0
#define ADU_BETA_MIN
//
//////////////////////////////////////////////////////////////////////////////////////



#define V(M, m) _T(#M) _T(".") _T(#m)
#define _V(M, m) V(M,m)

// Per il momento lascio perdere _T(l)
// #define B(n, l) _T(#n) _T(l)
#define B(n, l) _T(#n)

#define _B(n, l) B(n, l)


#define ADU_VER_RL _V(ADU_VER_MAJ, ADU_VER_MIN)

#if ADU_BETA_MAJ > 0
	#define ADU_VER ADU_VER_RL _T("b") _B(ADU_BETA_MAJ, ADU_BETA_MIN)
#else
	#define ADU_VER ADU_VER_RL
#endif

#define ADU_MOD ADU_MOD_NAME _T(" ") ADU_VER

// Mr Hyde: uso la seg. per avere "aMuleAdunanzA" invece di "aMule" come nome
// di directory (es: directory per preferenze diventa ~/.aMuleAdunanzA)
#define ADU_APPNAME "aMuleAdunanzA"
#define AMULE_ADUNANZA_DIR ADU_APPNAME

// Mr Hyde: usata per gestione lingue
// deve corrispondere:
// - al file .pot e ai file .gmo generati
// - al primo argomento della macro AC_INIT (o meglio, al lowercase del primo argomento di AC_INIT, vedi file "configure.in")
#if !defined(PACKAGE_ADUNANZA)
#define PACKAGE_ADUNANZA "amuleadunanza"
#endif

// Mr Hyde: rimosse le define di MOD_VERSION_LONG perche' definite in src/include/common/ClientVersion.h
//

// Parametri e definzioni esportate dal file AdunanzA.cpp
#define ADUNANZA_ANY            0
#define ADUNANZA_EXTERN         1
#define ADUNANZA_FASTWEB        2
#define ADUNANZA_NONE           0xff
// Percentuale minima per assegnare uno slot ad un Adu
//#define ADUNANZA_MIN_ADU	5
// Definizione default del numero di slots
#define ADUNANZA_DEF_UPSL	8
// Definizione default banda Adu
#define ADUNANZA_BAND_PERC  (85) // Mr Hyde allineamento 3.16, ripartitore banda
#define ADUNANZA_DEF_BW_EXT  (6) // Mr Hyde allineamento 3.16, ripartitore banda

const uint32 ADU_MAX_RATIO_KADU_DOWN(3145728); // 3 mega * 1024 KB in mega * 1024 byte in KB
const uint32 ADUNANZA_MIN_BW_TROLLER(2);

const bool ADUNANZA_UP_EXT_CHECK(false); // il default per abilitare le impostazioni CUSTOM del ripartitore di banda deve essere false (ovvero: custom DISABILITATO)

const unsigned int ADU_EXT_FULL_WAIT_TIME(480); // 8 minuti


// Mr Hyde: per Streaming
const uint32 ADUNANZA_DEF_STREAMING_PERC_THRESHOLD = 3; 
const uint32 ADUNANZA_MIN_STREAMING_PERC_THRESHOLD = 1;   // ricorda che 1 e' ammesso, 0 no
const uint32 ADUNANZA_MAX_STREAMING_PERC_THRESHOLD = 10;  // ricorda che 10 e' ammesso, 11 no


// Definizione connessione automatica
#define ADUNANZA_AUTO_CONN	1
// Definizione forzature upload/dl ext 1:1 - Disabilitato di default
#define ADUNANZA_AUTO_EXT11	1

#define ADU_VER_CODE(M,m,o) (((M) << 12) + ((m) << 7) + (o))
#define ADU_GET_MAJ(v) ((v) >> 12)
#define ADU_GET_MIN(v) (((v) >> 7) & 0x1f)
#define ADU_GET_B(v) ((v) & 0x7f)

// ADU URLS
#define ADURM_URL              "http://update.adunanza.net/3-16/adu_remote.conf"

// Mr Hyde: cambiato su richiesta di Hammon
#define ADU_SRV_URL            "http://update.adunanza.net/servers.met"

// Mr Hyde: 29 Maggio 2008
// Sul forum di aMule ho letto di alcuni utenti che hanno avuto problemi 
// con il vecchio formato.
// Personalmente dubito che il vecchio formato possa dare problemi,
// pero' per sicurezza ho comunque aggiornato al nuovo indirizzo con KAD2
// #define ADU_NODES_DAT          "http://update.adunanza.net/amule/adu_nodes.dat"
#define ADU_NODES_DAT          "http://www.adunanza.net/files/emule/adu_nodes.dat"

// Mr Hyde per allineamento 3.15
// Remote IPFilter by Tigerjact
#define ADU_REMOTE_FILTER       "http://update.adunanza.net/adu_remoteipfilter.dat"

#define ADU_KEYWORDS_FILE "key_np.dat"


# if ADU_BETA_MAJ > 0
#	define ADU_ADUNANZANET_URL    "http://forum.adunanza.net/showthread.php?t=49167" // Mr Hyde
# else
#	define ADU_ADUNANZANET_URL    "http://www.adunanza.net" // da mettere quando non sara' piu' una beta 
# endif

// Mr Hyde: aggiunto
// notare che l'URL scritto in questo modo NON rispetta il draft per gli URL IRC
// (dovrebbe avere il carattere "#" dato come %23, ci sto studiando)
//
// Mr Hyde, 20100125, cambiato l'indirizzo su richiesta di Hammon
#define ADU_IRCHELP_URL        "irc://chat.adunanza.net:6667/#Linux"

// Mr Hyde: per default programma IRC (da sistemare per MAC)
#define ADU_DEFAULT_IRC       "xchat"
// Mr Hyde, 20100125, cambiato l'indirizzo su richiesta di Hammon
#define ADU_DEFAULT_IRC_FLAGS "--url irc://chat.adunanza.net:6667/#Linux"

// Mr Hyde: per pagina da associare a F1
// Mr Hyde, 20100125, cambiato l'indirizzo su richiesta di Hammon
#define ADU_WIKI_URL           "http://aduteca.adunanza.net/Amule_AdunanzA"

// Aggiunto test porte
#define ADU_PORTTEST_BASE_URL       "http://adutest.adunanza.net/emule_testport/adutest.php?tcp=%d&udp=%d"
class wxString;

// Funzioni esportate

#include "FastwebNet.h"

class CAdunanzAUtilities {
	public:
		static inline bool AduIsFastWebLANIP(uint32 ip)
		{
			return CFastwebNet::AduIsFastWebLANIP(ip);
		}


		static bool AduIsFastWebIP(uint32 ip)
		{
			return CFastwebNet::AduIsFastWebIP(ip);
		}


		static bool AduIsFastWebIP(const wxString& ipv4string);

		static bool	AduIsFiber(uint32 ip);
		static uint32	AduGetTypeBand();
		//extern float	AduGetPercBandwidth();
		static void	AduStartConnection();
		static void	AduUpdate(char *url);
		// KAdu
		static bool     AduIsValidKaduAddress( uint32 host );

		static wxString GetFWCityFromIP(uint32 dwUserIP);

#ifndef CLIENT_GUI
		static uint32 getAllowedUploadDataRate();

		static float calcolaStima( float input_avail, uint32& firstPublish, uint32 publishInterval, uint32 pubkRTK, bool sameIP, uint32 now );
		static float normalizzaStima( float avail, uint32 from, uint32 to );

		static int AduQ();
		static int ExtQ();
		static bool AduDebt();

		static int OLDSetSlots();
		static int SetSlots();
		static int TotSlots();
#if 0		
		static int ExtSlots();
#endif
		
		static uint32 AduNextClient(int fix = 0);
		static bool AduMaxTrans();
		static uint32 AduGetMaxUploadSlots();

		static void CalcolaRatio(bool bAtMomentNotUsed);
#endif
};


#if !defined(CLIENT_GUI)
/*
// ora cerco di sistemare un casino per amulecmd n debug...
// (vedi src/ClientRef.h dove usano wxString senza l'include giusto e in caso di debug e' un bordello...)
#if defined(__DEBUG__)
#  if !defined(DEBUG_ZOMBIE_CLIENTS)
#    define DEBUG_ZOMBIE_CLIENTS
#  endif
#include <wx/string.h>
#endif
*/
#include "ClientRef.h"

class CAduUploadSlotsManager
{
	public:
		/**
		 * Numero slot disponibili per client esterni (NON AdunanzA)
		 */ 
		uint32 m_externSlots;

		/**
		 * Numero slot disponibili per client AdunanzA
		 */ 
		uint32 m_adunanzaSlots;

		/**
		 * Numero slot "prestati" a AdunanzA
		 *
		 * Considero AdunanzA in debito verso gli esterni quando
		 * gli slot disponibili per AdunanzA sono "0" ma comunque,
		 * per qualche motivo, lo slot viene assegnato ad un client AdunanzA
		 * invece che ad un client esterno.
		 *
		 */ 
		uint32 m_adunanzaDebt;

		/**
		 * Numero slot "prestati" a esterni
		 *
		 * Considero gli esterni in debito verso AdunanzA quando
		 * gli slot disponibili per esterni sono "0" ma comunque,
		 * per qualche motivo, lo slot viene assegnato ad un client esterno
		 * invece che ad un client AdunanzA.
		 *
		 */ 
		uint32 m_externDebt;
	public:
		CAduUploadSlotsManager() :
			m_externSlots(0),
			m_adunanzaSlots(0),
       			m_adunanzaDebt(0),
			m_externDebt(0)
		{}

		~CAduUploadSlotsManager() {};

		// Mr Hyde: per ricavare l'upload rate corrente
		// (codice copiato da UploadBandwidthThrottler.cpp)
		static uint32 getAllowedUploadDataRate();


		uint32 next() const;

		// void update(CClientPtrList& uploadingList);
		void update(CClientRefList& uploadingList);

};
#endif


#endif


