/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#ifndef __GCS_SCHEME_SELECTOR_H
#define __GCS_SCHEME_SELECTOR_H

#include <gtkmm/liststore.h>
#include <gtkmm/combobox.h>
#include <libglademm/xml.h>
#include "core/gcs-scheme.h"

using namespace Gnome;

namespace gcs
{
    namespace Widgets
    {

        class SchemeSelector : public Gtk::ComboBox
        {
            public:
                SchemeSelector(GtkComboBox* cobject, Glib::RefPtr<Glade::Xml>& glade);
                virtual ~SchemeSelector(void);

                tSchemeType get_scheme_type(void);
                void set_scheme_type(tSchemeType t);

            protected:
                class ModelColumns : public Gtk::TreeModel::ColumnRecord
                {
                    public:

                        ModelColumns()
                        { add(m_columnText); add(m_columnCode); }

                        Gtk::TreeModelColumn<Glib::ustring> m_columnText;
                        Gtk::TreeModelColumn<tSchemeType> m_columnCode;
                };

                ModelColumns m_columns;
                Glib::RefPtr<Gtk::ListStore> m_refListStore;
        };

    } // namespace Widgets
} // namespace gcs

#endif // __GCS_SCHEME_SELECTOR_H
