/*
 *  Copyright (c) 1994, Riley Rainey,  riley@netcon.com
 *
 *  Permission to use, copy, modify and distribute (without charge) this
 *  software, documentation, images, etc. is granted, provided that this 
 *  comment and the author's name is retained.
 *
 *  This software is provided by the author as is, and without any expressed
 *  or implied warranties, including, but not limited to, the implied
 *  warranties of merchantability and fitness for a particular purpose.  In no
 *  event shall the author be liable for any direct, indirect, incidental, or
 *  consequential damages arising in any way out of the use of this software.
 */

#ifndef gutil_H
#define gutil_H

#include "shared.h"

#ifdef gutil_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

EXTERN void ComputePlaneEquation (polygon_t *p);

EXTERN void DisplayPoint(point_t *p);

EXTERN polygon_t * AllocPolygon (void);

EXTERN void FreePolygon (polygon_t *p);

EXTERN polygon_t * BeginPolygon (void);

EXTERN void PointXY (Widget w, view_info_t      *p, int x, int y, point_t *q);

EXTERN int PinPoint (Widget w, view_info_t      *p, polygon_t *poly, int x, int y, XPoint *pt, XPoint *opt);

EXTERN int DragPoint (Widget w, view_info_t     *p, polygon_t *poly, int delta, XPoint *pt, XPoint *opt);

EXTERN void BeginPolygonPoint (Widget w, view_info_t *p, int x, int y);

EXTERN void DragPolygonPoint(Widget w, view_info_t *p, int x, int y);

EXTERN void CompletePolygonPoint(Widget w, view_info_t *p, int x, int y);

EXTERN void CompletePolygon (Widget w, polygon_t *p);

EXTERN int PolygonProximity (view_info_t *p, polygon_t *poly, int x, int y);

EXTERN int PickObject (view_info_t      *p, int x, int y);

EXTERN void CompleteMarker(Widget w, view_info_t *p, int x, int y);

EXTERN void BeginPick (Widget w, view_info_t *p, int x, int y, Boolean extend);

EXTERN void DragSelection (Widget w, view_info_t *p, int x, int y);

EXTERN void CompleteDrag (Widget w, view_info_t *p, int x, int y);

EXTERN void SelectObject (int id);

EXTERN void DetermineObjectExtent (VPoint *extent);

EXTERN void RescaleObject (double factor);

#undef EXTERN
#endif
