/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991,1992  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#ifndef _alarm_h
#define _alarm_h

#ifdef alarm_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

typedef long alarm_id_t;

/**
 * Add a new entry into the alarm list.
 * 
 * BEWARE.
 * If any of the parameters arg1,arg2 makes reference to a data structure
 * that may be removed before the call-back procedure be called, make sure
 * to remove also any alarm that makes reference to these data.
 * @param delta Calls proc when exactly delta seconds are elapsed,
 *        then remove this alarm.
 * @param proc Call-back procedure with signature void(void *, void *).
 * @param arg1 Utility parameter for proc.
 * @param arg2 Utility parameter for proc.
 * @return Univocal alarm identifier.
 */
EXTERN alarm_id_t alarm_add(double delta, void (*proc) (void *, void *), void *arg1, void *arg2);

/**
 * Removes the alarm from the pending alarms. Does nothing if the alarm was
 * already thrown.
 * @param id
 */
EXTERN void alarm_cancel(alarm_id_t id);

/**
 * Updates the alarms list. For alarms whose delay time is elapsed, the
 * alarm entry is first removed, and then the corresponding call-back
 * function is called.
 */
EXTERN void alarm_update(void);

#undef EXTERN
#endif
