(IN-PACKAGE "RTL")

(INCLUDE-BOOK "rtl/rel11/lib/rac" :DIR :SYSTEM)

(SET-IGNORE-OK T)

(SET-IRRELEVANT-FORMALS-OK T)

(DEFUND
 ANALYZE (OP FMT FZ FLAGS)
 (LET
    ((SIGN 0)
     (EXP 0)
     (MAN 0)
     (MANMSB 0)
     (EXPISMAX 0))
    (MV-LET
         (SIGN EXP EXPISMAX MAN MANMSB)
         (CASE FMT
               (2 (LET ((SIGN (BITN OP 63))
                        (EXP (BITS OP 62 52)))
                       (MV SIGN EXP (LOG= (SI EXP 13) 2047)
                           (BITS OP 51 0)
                           (BITS 2251799813685248 51 0))))
               (1 (LET ((SIGN (BITN OP 31))
                        (EXP (BITS OP 30 23)))
                       (MV SIGN EXP (LOG= (SI EXP 13) 255)
                           (BITS OP 22 0)
                           (BITS 4194304 51 0))))
               (0 (LET ((SIGN (BITN OP 15))
                        (EXP (BITS OP 14 10)))
                       (MV SIGN EXP (LOG= (SI EXP 13) 31)
                           (BITS OP 9 0)
                           (BITS 512 51 0))))
               (T (MV SIGN EXP EXPISMAX MAN MANMSB)))
         (LET ((C 0))
              (MV-LET (FLAGS C)
                      (IF1 EXPISMAX
                           (MV FLAGS
                               (IF1 (LOG= MAN 0)
                                    1 (IF1 (LOGAND MAN MANMSB) 3 2)))
                           (IF1 (LOG= (SI EXP 13) 0)
                                (IF1 (LOG= MAN 0)
                                     (MV FLAGS 0)
                                     (MV-LET (C FLAGS)
                                             (IF1 FZ
                                                  (MV 0
                                                      (IF1 (LOG<> FMT 0)
                                                           (SETBITN FLAGS 8 7 1)
                                                           FLAGS))
                                                  (MV 5 FLAGS))
                                             (MV FLAGS C)))
                                (MV FLAGS 4)))
                      (MV SIGN (BITS (SI EXP 13) 10 0)
                          MAN C FLAGS))))))

(DEFUND CLZ53-LOOP-0 (I N K C Z)
        (DECLARE (XARGS :MEASURE (NFIX (- N I))))
        (IF (AND (INTEGERP I) (INTEGERP N) (< I N))
            (LET* ((C (AS I
                          (BITS (IF1 (AG (+ (* 2 I) 1) Z)
                                     (AG (* 2 I) C)
                                     (AG (+ (* 2 I) 1) C))
                                5 0)
                          C))
                   (C (AS I
                          (SETBITN (AG I C)
                                   6 K (AG (+ (* 2 I) 1) Z))
                          C))
                   (Z (AS I
                          (LOGAND1 (AG (+ (* 2 I) 1) Z)
                                   (AG (* 2 I) Z))
                          Z)))
                  (CLZ53-LOOP-0 (+ I 1) N K C Z))
            (MV C Z)))

(DEFUND CLZ53-LOOP-1 (K N C Z)
        (DECLARE (XARGS :MEASURE (NFIX (- 6 K))))
        (IF (AND (INTEGERP K) (< K 6))
            (LET ((N (FLOOR N 2)))
                 (MV-LET (C Z)
                         (CLZ53-LOOP-0 0 N K C Z)
                         (CLZ53-LOOP-1 (+ K 1) N C Z)))
            (MV N C Z)))

(DEFUND CLZ53-LOOP-2 (I X Z C)
        (DECLARE (XARGS :MEASURE (NFIX (- 64 I))))
        (IF (AND (INTEGERP I) (< I 64))
            (LET ((Z (AS I (LOGNOT1 (BITN X I)) Z))
                  (C (AS I (BITS 0 5 0) C)))
                 (CLZ53-LOOP-2 (+ I 1) X Z C))
            (MV Z C)))

(DEFUND CLZ53 (S)
        (LET* ((X (BITS 0 63 0))
               (X (SETBITS X 64 63 11 S))
               (Z NIL)
               (C NIL))
              (MV-LET (Z C)
                      (CLZ53-LOOP-2 0 X Z C)
                      (LET ((N 64))
                           (MV-LET (N C Z)
                                   (CLZ53-LOOP-1 0 N C Z)
                                   (AG 0 C))))))

(DEFUND COMPUTEQ
        (QUOT QUOTM1 QUOTP QUOTM1P RP RN LSBIS2)
        (LET* ((QTRUNC 0)
               (QINC 0)
               (STK 0)
               (REM (BITS (+ (+ RP (LOGNOT RN)) 1) 70 0))
               (REMSIGN (BITN REM 70))
               (REMZERO (LOG= (LOGXOR RP RN) 0))
               (QUOTLO (BITS (IF1 REMSIGN QUOTM1 QUOT) 64 0))
               (QUOTLOP (BITS (IF1 REMSIGN QUOTM1P QUOTP)
                              64 0)))
              (MV-LET (STK QTRUNC QINC)
                      (IF1 LSBIS2
                           (MV (LOGIOR1 (BITN QUOTLO 0)
                                        (LOGNOT1 REMZERO))
                               (BITS QUOTLO 53 1)
                               (BITS QUOTLOP 53 1))
                           (MV (LOGNOT1 REMZERO)
                               (BITS QUOTLO 52 0)
                               (BITS QUOTLOP 52 0)))
                      (MV QTRUNC QINC STK))))

(DEFUND RSHFT64 (X S)
        (LET ((XS (BITS (ASH X (- S)) 63 0)))
             (MV XS (LOG<> X (ASH XS S)))))

(DEFUND
 ROUNDER
 (QTRUNC QINC STK SIGN EXPQ RMODE FMT)
 (LET*
  ((LSB (BITN QTRUNC 1))
   (GRD (BITN QTRUNC 0))
   (QRND 0)
   (QRND (IF1 (LOGIOR1 (LOGIOR1 (LOGAND1 (LOGAND1 (LOG= RMODE 0) GRD)
                                         (LOGIOR1 LSB STK))
                                (LOGAND1 (LOGAND1 (LOG= RMODE 1) (LOGNOT1 SIGN))
                                         (LOGIOR1 GRD STK)))
                       (LOGAND1 (LOGAND1 (LOG= RMODE 2) SIGN)
                                (LOGIOR1 GRD STK)))
              (BITS QINC 53 1)
              (BITS QTRUNC 53 1)))
   (INX (LOGIOR1 GRD STK))
   (QDEN (BITS 0 63 0))
   (QDEN (CASE FMT
               (2 (LET ((QDEN (SETBITN QDEN 64 53 1)))
                       (SETBITS QDEN 64 52 0 (BITS QTRUNC 52 0))))
               (1 (LET ((QDEN (SETBITN QDEN 64 24 1)))
                       (SETBITS QDEN 64 23 0 (BITS QTRUNC 23 0))))
               (0 (LET ((QDEN (SETBITN QDEN 64 11 1)))
                       (SETBITS QDEN 64 10 0 (BITS QTRUNC 10 0))))
               (T QDEN)))
   (SHFT12 (BITS (- 1 (SI EXPQ 13)) 11 0))
   (SHFT (BITS (IF1 (LOG>= SHFT12 64) 63 SHFT12)
               5 0))
   (LSBDEN 0)
   (GRDDEN 0)
   (STKDEN 0)
   (QSHFT 0))
  (MV-LET
   (QSHFT STKDEN)
   (RSHFT64 QDEN SHFT)
   (LET
    ((LSBDEN (BITN QSHFT 1))
     (GRDDEN (BITN QSHFT 0))
     (STKDEN (LOGIOR1 STKDEN STK))
     (QRNDDEN 0))
    (MV
     QRND INX
     (BITS
         (IF1 (LOGIOR1 (LOGIOR1 (LOGAND1 (LOGAND1 (LOG= RMODE 0) GRDDEN)
                                         (LOGIOR1 LSBDEN STKDEN))
                                (LOGAND1 (LOGAND1 (LOG= RMODE 1) (LOGNOT1 SIGN))
                                         (LOGIOR1 GRDDEN STKDEN)))
                       (LOGAND1 (LOGAND1 (LOG= RMODE 2) SIGN)
                                (LOGIOR1 GRDDEN STKDEN)))
              (BITS (+ (BITS QSHFT 53 1) 1) 53 0)
              (BITS QSHFT 53 1))
         52 0)
     (LOGIOR1 GRDDEN STKDEN))))))

(DEFUND
 FINAL
 (QRND INX QRNDDEN
       INXDEN SIGN EXPQ RMODE FZ FMT FLAGS)
 (LET
  ((SELMAXNORM (LOGIOR1 (LOGIOR1 (LOGAND1 (LOG= RMODE 2) (LOGNOT1 SIGN))
                                 (LOGAND1 (LOG= RMODE 1) SIGN))
                        (LOG= RMODE 3)))
   (D (BITS 0 63 0)))
  (CASE
   FMT
   (2
    (LET
     ((D (SETBITN D 64 63 SIGN)))
     (IF1
         (LOG>= (SI EXPQ 13) 2047)
         (MV (IF1 SELMAXNORM
                  (LET ((D (SETBITS D 64 62 52 2046)))
                       (SETBITS D 64 51 0 4503599627370495))
                  (LET ((D (SETBITS D 64 62 52 2047)))
                       (SETBITS D 64 51 0 0)))
             (SETBITN (SETBITN FLAGS 8 2 1) 8 4 1))
         (IF1 (LOG<= (SI EXPQ 13) 0)
              (IF1 FZ (MV D (SETBITN FLAGS 8 3 1))
                   (LET* ((EXP (BITN QRNDDEN 52))
                          (D (SETBITS D 64 62 52 EXP))
                          (D (SETBITS D 64 51 0 (BITS QRNDDEN 51 0)))
                          (FLAGS (SETBITN FLAGS
                                          8 4 (LOGIOR1 (BITN FLAGS 4) INXDEN))))
                         (MV D
                             (SETBITN FLAGS
                                      8 3 (LOGIOR1 (BITN FLAGS 3) INXDEN)))))
              (MV (SETBITS (SETBITS D 64 62 52 (SI EXPQ 13))
                           64 51 0 (BITS QRND 51 0))
                  (SETBITN FLAGS
                           8 4 (LOGIOR1 (BITN FLAGS 4) INX)))))))
   (1
    (LET
     ((D (SETBITN D 64 31 SIGN)))
     (IF1
         (LOG>= (SI EXPQ 13) 255)
         (MV (IF1 SELMAXNORM
                  (LET ((D (SETBITS D 64 30 23 254)))
                       (SETBITS D 64 22 0 8388607))
                  (LET ((D (SETBITS D 64 30 23 255)))
                       (SETBITS D 64 22 0 0)))
             (SETBITN (SETBITN FLAGS 8 2 1) 8 4 1))
         (IF1 (LOG<= (SI EXPQ 13) 0)
              (IF1 FZ (MV D (SETBITN FLAGS 8 3 1))
                   (LET* ((EXP (BITN QRNDDEN 23))
                          (D (SETBITS D 64 30 23 EXP))
                          (D (SETBITS D 64 22 0 (BITS QRNDDEN 22 0)))
                          (FLAGS (SETBITN FLAGS
                                          8 4 (LOGIOR1 (BITN FLAGS 4) INXDEN))))
                         (MV D
                             (SETBITN FLAGS
                                      8 3 (LOGIOR1 (BITN FLAGS 3) INXDEN)))))
              (MV (SETBITS (SETBITS D 64 30 23 (SI EXPQ 13))
                           64 22 0 (BITS QRND 22 0))
                  (SETBITN FLAGS
                           8 4 (LOGIOR1 (BITN FLAGS 4) INX)))))))
   (0
    (LET
     ((D (SETBITN D 64 15 SIGN)))
     (IF1
         (LOG>= (SI EXPQ 13) 31)
         (MV (IF1 SELMAXNORM
                  (LET ((D (SETBITS D 64 14 10 30)))
                       (SETBITS D 64 9 0 1023))
                  (LET ((D (SETBITS D 64 14 10 31)))
                       (SETBITS D 64 9 0 0)))
             (SETBITN (SETBITN FLAGS 8 2 1) 8 4 1))
         (IF1 (LOG<= (SI EXPQ 13) 0)
              (IF1 FZ (MV D (SETBITN FLAGS 8 3 1))
                   (LET* ((EXP (BITN QRNDDEN 10))
                          (D (SETBITS D 64 14 10 EXP))
                          (D (SETBITS D 64 9 0 (BITS QRNDDEN 9 0)))
                          (FLAGS (SETBITN FLAGS
                                          8 4 (LOGIOR1 (BITN FLAGS 4) INXDEN))))
                         (MV D
                             (SETBITN FLAGS
                                      8 3 (LOGIOR1 (BITN FLAGS 3) INXDEN)))))
              (MV (SETBITS (SETBITS D 64 14 10 (SI EXPQ 13))
                           64 9 0 (BITS QRND 9 0))
                  (SETBITN FLAGS
                           8 4 (LOGIOR1 (BITN FLAGS 4) INX)))))))
   (T (MV D FLAGS)))))

(DEFUND
 SPECIALCASE
 (SIGN OPA OPB CLASSA CLASSB FMT DN FLAGS)
 (LET
  ((ISSPECIAL (FALSE$))
   (D (BITS 0 63 0))
   (ANAN 0)
   (BNAN 0)
   (MANMSB 0)
   (INFINITY 0)
   (DEFNAN 0)
   (ZERO (BITS 0 63 0)))
  (MV-LET
   (ANAN BNAN ZERO INFINITY MANMSB)
   (CASE FMT
         (2 (MV (BITS OPA 63 0)
                (BITS OPB 63 0)
                (SETBITN ZERO 64 63 SIGN)
                (BITS 9218868437227405312 63 0)
                (BITS 2251799813685248 63 0)))
         (1 (MV (BITS OPA 31 0)
                (BITS OPB 31 0)
                (SETBITN ZERO 64 31 SIGN)
                (BITS 2139095040 63 0)
                (BITS 4194304 63 0)))
         (0 (MV (BITS OPA 15 0)
                (BITS OPB 15 0)
                (SETBITN ZERO 64 15 SIGN)
                (BITS 31744 63 0)
                (BITS 512 63 0)))
         (T (MV ANAN BNAN ZERO INFINITY MANMSB)))
   (LET
    ((DEFNAN (LOGIOR INFINITY MANMSB)))
    (IF1
     (LOG= CLASSA 2)
     (MV (BITS (IF1 DN DEFNAN (LOGIOR ANAN MANMSB))
               63 0)
         (SETBITN FLAGS 8 0 1))
     (IF1
      (LOG= CLASSB 2)
      (MV (BITS (IF1 DN DEFNAN (LOGIOR BNAN MANMSB))
                63 0)
          (SETBITN FLAGS 8 0 1))
      (MV-LET
       (FLAGS D)
       (IF1
        (LOG= CLASSA 3)
        (MV FLAGS (BITS (IF1 DN DEFNAN ANAN) 63 0))
        (IF1
         (LOG= CLASSB 3)
         (MV FLAGS (BITS (IF1 DN DEFNAN BNAN) 63 0))
         (MV-LET
           (D FLAGS)
           (IF1 (LOG= CLASSA 1)
                (IF1 (LOG= CLASSB 1)
                     (MV DEFNAN (SETBITN FLAGS 8 0 1))
                     (MV (LOGIOR INFINITY ZERO) FLAGS))
                (MV-LET (FLAGS D)
                        (IF1 (LOG= CLASSB 1)
                             (MV FLAGS ZERO)
                             (MV-LET (D FLAGS)
                                     (IF1 (LOG= CLASSA 0)
                                          (IF1 (LOG= CLASSB 0)
                                               (MV DEFNAN (SETBITN FLAGS 8 0 1))
                                               (MV ZERO FLAGS))
                                          (IF1 (LOG= CLASSB 0)
                                               (MV (LOGIOR INFINITY ZERO)
                                                   (SETBITN FLAGS 8 1 1))
                                               (MV D FLAGS)))
                                     (MV FLAGS D)))
                        (MV D FLAGS)))
           (MV FLAGS D))))
       (MV D FLAGS))))))))

(DEFUND
 NORMALIZE (EXPA EXPB MANA MANB FMT)
 (LET
    ((SIGA (BITS 0 52 0))
     (SIGB (BITS 0 52 0))
     (BIAS 0))
    (MV-LET
         (SIGA SIGB BIAS)
         (CASE FMT (2 (MV MANA MANB 1023))
               (1 (MV (SETBITS SIGA 53 51 29 MANA)
                      (SETBITS SIGB 53 51 29 MANB)
                      127))
               (0 (MV (SETBITS SIGA 53 51 42 MANA)
                      (SETBITS SIGB 53 51 42 MANB)
                      15))
               (T (MV SIGA SIGB BIAS)))
         (LET ((EXPASHFT 0) (EXPBSHFT 0))
              (MV-LET (SIGA EXPASHFT)
                      (IF1 (LOG= EXPA 0)
                           (LET ((CLZ (BITS (CLZ53 SIGA) 5 0)))
                                (MV (BITS (ASH SIGA CLZ) 52 0)
                                    (BITS (- 1 CLZ) 12 0)))
                           (MV (SETBITN SIGA 53 52 1) EXPA))
                      (MV-LET (SIGB EXPBSHFT)
                              (IF1 (LOG= EXPB 0)
                                   (LET ((CLZ (BITS (CLZ53 SIGB) 5 0)))
                                        (MV (BITS (ASH SIGB CLZ) 52 0)
                                            (BITS (- 1 CLZ) 12 0)))
                                   (MV (SETBITN SIGB 53 52 1) EXPB))
                              (MV SIGA SIGB
                                  (BITS (+ (- (SI EXPASHFT 13) (SI EXPBSHFT 13))
                                           BIAS)
                                        12 0))))))))

(DEFUND COMPUTECMPCONST (DIVTOP)
        (LET ((A NIL))
             (CASE (BITS DIVTOP 5 1)
                   (0 (LET* ((A (AS 7
                                    (BITS (IF1 (BITN DIVTOP 0) 909 911) 9 0)
                                    A))
                             (A (AS 6 (BITS 942 9 0) A))
                             (A (AS 5 (BITS 974 9 0) A))
                             (A (AS 4 (BITS 1008 9 0) A))
                             (A (AS 3 (BITS 16 9 0) A))
                             (A (AS 2 (BITS 48 9 0) A))
                             (A (AS 1 (BITS 81 9 0) A)))
                            (AS 0
                                (BITS (IF1 (BITN DIVTOP 0) 114 112) 9 0)
                                A)))
                   (1 (LET* ((A (AS 7
                                    (BITS (IF1 (BITN DIVTOP 0) 906 907) 9 0)
                                    A))
                             (A (AS 6 (BITS 940 9 0) A))
                             (A (AS 5 (BITS 974 9 0) A))
                             (A (AS 4 (BITS 1008 9 0) A))
                             (A (AS 3 (BITS 16 9 0) A))
                             (A (AS 2 (BITS 50 9 0) A))
                             (A (AS 1 (BITS 83 9 0) A)))
                            (AS 0
                                (BITS (IF1 (BITN DIVTOP 0) 117 116) 9 0)
                                A)))
                   (2 (LET* ((A (AS 7 (BITS 903 9 0) A))
                             (A (AS 6 (BITS 938 9 0) A))
                             (A (AS 5 (BITS 972 9 0) A))
                             (A (AS 4 (BITS 1008 9 0) A))
                             (A (AS 3 (BITS 16 9 0) A))
                             (A (AS 2 (BITS 52 9 0) A))
                             (A (AS 1 (BITS 86 9 0) A)))
                            (AS 0 (BITS 120 9 0) A)))
                   (3 (LET* ((A (AS 7 (BITS 899 9 0) A))
                             (A (AS 6 (BITS 934 9 0) A))
                             (A (AS 5 (BITS 970 9 0) A))
                             (A (AS 4 (BITS 1006 9 0) A))
                             (A (AS 3 (BITS 18 9 0) A))
                             (A (AS 2 (BITS 54 9 0) A))
                             (A (AS 1 (BITS 88 9 0) A)))
                            (AS 0 (BITS 124 9 0) A)))
                   (4 (LET* ((A (AS 7 (BITS 896 9 0) A))
                             (A (AS 6 (BITS 932 9 0) A))
                             (A (AS 5 (BITS 970 9 0) A))
                             (A (AS 4 (BITS 1006 9 0) A))
                             (A (AS 3 (BITS 18 9 0) A))
                             (A (AS 2 (BITS 54 9 0) A))
                             (A (AS 1 (BITS 90 9 0) A)))
                            (AS 0 (BITS 127 9 0) A)))
                   (5 (LET* ((A (AS 7 (BITS 892 9 0) A))
                             (A (AS 6 (BITS 930 9 0) A))
                             (A (AS 5 (BITS 968 9 0) A))
                             (A (AS 4 (BITS 1006 9 0) A))
                             (A (AS 3 (BITS 18 9 0) A))
                             (A (AS 2 (BITS 56 9 0) A))
                             (A (AS 1 (BITS 94 9 0) A)))
                            (AS 0 (BITS 131 9 0) A)))
                   (6 (LET* ((A (AS 7 (BITS 889 9 0) A))
                             (A (AS 6 (BITS 928 9 0) A))
                             (A (AS 5 (BITS 966 9 0) A))
                             (A (AS 4 (BITS 1006 9 0) A))
                             (A (AS 3 (BITS 18 9 0) A))
                             (A (AS 2 (BITS 58 9 0) A))
                             (A (AS 1 (BITS 96 9 0) A)))
                            (AS 0 (BITS 134 9 0) A)))
                   (7 (LET* ((A (AS 7 (BITS 885 9 0) A))
                             (A (AS 6 (BITS 924 9 0) A))
                             (A (AS 5 (BITS 964 9 0) A))
                             (A (AS 4 (BITS 1004 9 0) A))
                             (A (AS 3 (BITS 20 9 0) A))
                             (A (AS 2 (BITS 60 9 0) A))
                             (A (AS 1 (BITS 98 9 0) A)))
                            (AS 0 (BITS 138 9 0) A)))
                   (8 (LET* ((A (AS 7 (BITS 882 9 0) A))
                             (A (AS 6 (BITS 922 9 0) A))
                             (A (AS 5 (BITS 964 9 0) A))
                             (A (AS 4 (BITS 1004 9 0) A))
                             (A (AS 3 (BITS 20 9 0) A))
                             (A (AS 2 (BITS 60 9 0) A))
                             (A (AS 1 (BITS 100 9 0) A)))
                            (AS 0 (BITS 141 9 0) A)))
                   (9 (LET* ((A (AS 7 (BITS 878 9 0) A))
                             (A (AS 6 (BITS 920 9 0) A))
                             (A (AS 5 (BITS 962 9 0) A))
                             (A (AS 4 (BITS 1004 9 0) A))
                             (A (AS 3 (BITS 20 9 0) A))
                             (A (AS 2 (BITS 62 9 0) A))
                             (A (AS 1 (BITS 104 9 0) A)))
                            (AS 0 (BITS 144 9 0) A)))
                   (10 (LET* ((A (AS 7 (BITS 874 9 0) A))
                              (A (AS 6 (BITS 918 9 0) A))
                              (A (AS 5 (BITS 960 9 0) A))
                              (A (AS 4 (BITS 1004 9 0) A))
                              (A (AS 3 (BITS 20 9 0) A))
                              (A (AS 2 (BITS 64 9 0) A))
                              (A (AS 1 (BITS 106 9 0) A)))
                             (AS 0 (BITS 148 9 0) A)))
                   (11 (LET* ((A (AS 7 (BITS 872 9 0) A))
                              (A (AS 6 (BITS 916 9 0) A))
                              (A (AS 5 (BITS 960 9 0) A))
                              (A (AS 4 (BITS 1004 9 0) A))
                              (A (AS 3 (BITS 20 9 0) A))
                              (A (AS 2 (BITS 64 9 0) A))
                              (A (AS 1 (BITS 108 9 0) A)))
                             (AS 0 (BITS 152 9 0) A)))
                   (12 (LET* ((A (AS 7 (BITS 868 9 0) A))
                              (A (AS 6 (BITS 912 9 0) A))
                              (A (AS 5 (BITS 958 9 0) A))
                              (A (AS 4 (BITS 1002 9 0) A))
                              (A (AS 3 (BITS 22 9 0) A))
                              (A (AS 2 (BITS 66 9 0) A))
                              (A (AS 1 (BITS 112 9 0) A)))
                             (AS 0 (BITS 156 9 0) A)))
                   (13 (LET* ((A (AS 7 (BITS 864 9 0) A))
                              (A (AS 6 (BITS 910 9 0) A))
                              (A (AS 5 (BITS 956 9 0) A))
                              (A (AS 4 (BITS 1002 9 0) A))
                              (A (AS 3 (BITS 22 9 0) A))
                              (A (AS 2 (BITS 68 9 0) A))
                              (A (AS 1 (BITS 114 9 0) A)))
                             (AS 0 (BITS 158 9 0) A)))
                   (14 (LET* ((A (AS 7 (BITS 860 9 0) A))
                              (A (AS 6 (BITS 908 9 0) A))
                              (A (AS 5 (BITS 954 9 0) A))
                              (A (AS 4 (BITS 1000 9 0) A))
                              (A (AS 3 (BITS 24 9 0) A))
                              (A (AS 2 (BITS 70 9 0) A))
                              (A (AS 1 (BITS 116 9 0) A)))
                             (AS 0 (BITS 162 9 0) A)))
                   (15 (LET* ((A (AS 7 (BITS 858 9 0) A))
                              (A (AS 6 (BITS 906 9 0) A))
                              (A (AS 5 (BITS 954 9 0) A))
                              (A (AS 4 (BITS 1000 9 0) A))
                              (A (AS 3 (BITS 24 9 0) A))
                              (A (AS 2 (BITS 70 9 0) A))
                              (A (AS 1 (BITS 118 9 0) A)))
                             (AS 0 (BITS 166 9 0) A)))
                   (16 (LET* ((A (AS 7 (BITS 854 9 0) A))
                              (A (AS 6 (BITS 904 9 0) A))
                              (A (AS 5 (BITS 952 9 0) A))
                              (A (AS 4 (BITS 1000 9 0) A))
                              (A (AS 3 (BITS 24 9 0) A))
                              (A (AS 2 (BITS 72 9 0) A))
                              (A (AS 1 (BITS 120 9 0) A)))
                             (AS 0 (BITS 170 9 0) A)))
                   (17 (LET* ((A (AS 7 (BITS 851 9 0) A))
                              (A (AS 6 (BITS 900 9 0) A))
                              (A (AS 5 (BITS 951 9 0) A))
                              (A (AS 4 (BITS 1000 9 0) A))
                              (A (AS 3 (BITS 24 9 0) A))
                              (A (AS 2 (BITS 72 9 0) A))
                              (A (AS 1 (BITS 124 9 0) A)))
                             (AS 0 (BITS 172 9 0) A)))
                   (18 (LET* ((A (AS 7 (BITS 848 9 0) A))
                              (A (AS 6 (BITS 898 9 0) A))
                              (A (AS 5 (BITS 948 9 0) A))
                              (A (AS 4 (BITS 1000 9 0) A))
                              (A (AS 3 (BITS 24 9 0) A))
                              (A (AS 2 (BITS 76 9 0) A))
                              (A (AS 1 (BITS 124 9 0) A)))
                             (AS 0 (BITS 176 9 0) A)))
                   (19 (LET* ((A (AS 7 (BITS 844 9 0) A))
                              (A (AS 6 (BITS 896 9 0) A))
                              (A (AS 5 (BITS 948 9 0) A))
                              (A (AS 4 (BITS 1000 9 0) A))
                              (A (AS 3 (BITS 24 9 0) A))
                              (A (AS 2 (BITS 76 9 0) A))
                              (A (AS 1 (BITS 128 9 0) A)))
                             (AS 0 (BITS 180 9 0) A)))
                   (20 (LET* ((A (AS 7 (BITS 840 9 0) A))
                              (A (AS 6 (BITS 892 9 0) A))
                              (A (AS 5 (BITS 946 9 0) A))
                              (A (AS 4 (BITS 1000 9 0) A))
                              (A (AS 3 (BITS 24 9 0) A))
                              (A (AS 2 (BITS 78 9 0) A))
                              (A (AS 1 (BITS 132 9 0) A)))
                             (AS 0 (BITS 184 9 0) A)))
                   (21 (LET* ((A (AS 7 (BITS 836 9 0) A))
                              (A (AS 6 (BITS 890 9 0) A))
                              (A (AS 5 (BITS 944 9 0) A))
                              (A (AS 4 (BITS 996 9 0) A))
                              (A (AS 3 (BITS 28 9 0) A))
                              (A (AS 2 (BITS 80 9 0) A))
                              (A (AS 1 (BITS 134 9 0) A)))
                             (AS 0 (BITS 188 9 0) A)))
                   (22 (LET* ((A (AS 7 (BITS 834 9 0) A))
                              (A (AS 6 (BITS 888 9 0) A))
                              (A (AS 5 (BITS 942 9 0) A))
                              (A (AS 4 (BITS 996 9 0) A))
                              (A (AS 3 (BITS 28 9 0) A))
                              (A (AS 2 (BITS 82 9 0) A))
                              (A (AS 1 (BITS 136 9 0) A)))
                             (AS 0 (BITS 190 9 0) A)))
                   (23 (LET* ((A (AS 7 (BITS 830 9 0) A))
                              (A (AS 6 (BITS 886 9 0) A))
                              (A (AS 5 (BITS 942 9 0) A))
                              (A (AS 4 (BITS 996 9 0) A))
                              (A (AS 3 (BITS 28 9 0) A))
                              (A (AS 2 (BITS 82 9 0) A))
                              (A (AS 1 (BITS 138 9 0) A)))
                             (AS 0 (BITS 194 9 0) A)))
                   (24 (LET* ((A (AS 7 (BITS 826 9 0) A))
                              (A (AS 6 (BITS 884 9 0) A))
                              (A (AS 5 (BITS 940 9 0) A))
                              (A (AS 4 (BITS 996 9 0) A))
                              (A (AS 3 (BITS 28 9 0) A))
                              (A (AS 2 (BITS 84 9 0) A))
                              (A (AS 1 (BITS 140 9 0) A)))
                             (AS 0 (BITS 198 9 0) A)))
                   (25 (LET* ((A (AS 7 (BITS 824 9 0) A))
                              (A (AS 6 (BITS 882 9 0) A))
                              (A (AS 5 (BITS 940 9 0) A))
                              (A (AS 4 (BITS 996 9 0) A))
                              (A (AS 3 (BITS 28 9 0) A))
                              (A (AS 2 (BITS 84 9 0) A))
                              (A (AS 1 (BITS 142 9 0) A)))
                             (AS 0 (BITS 200 9 0) A)))
                   (26 (LET* ((A (AS 7 (BITS 820 9 0) A))
                              (A (AS 6 (BITS 878 9 0) A))
                              (A (AS 5 (BITS 938 9 0) A))
                              (A (AS 4 (BITS 996 9 0) A))
                              (A (AS 3 (BITS 28 9 0) A))
                              (A (AS 2 (BITS 86 9 0) A))
                              (A (AS 1 (BITS 146 9 0) A)))
                             (AS 0 (BITS 204 9 0) A)))
                   (27 (LET* ((A (AS 7 (BITS 816 9 0) A))
                              (A (AS 6 (BITS 876 9 0) A))
                              (A (AS 5 (BITS 936 9 0) A))
                              (A (AS 4 (BITS 996 9 0) A))
                              (A (AS 3 (BITS 28 9 0) A))
                              (A (AS 2 (BITS 88 9 0) A))
                              (A (AS 1 (BITS 148 9 0) A)))
                             (AS 0 (BITS 208 9 0) A)))
                   (28 (LET* ((A (AS 7 (BITS 812 9 0) A))
                              (A (AS 6 (BITS 872 9 0) A))
                              (A (AS 5 (BITS 934 9 0) A))
                              (A (AS 4 (BITS 996 9 0) A))
                              (A (AS 3 (BITS 28 9 0) A))
                              (A (AS 2 (BITS 90 9 0) A))
                              (A (AS 1 (BITS 152 9 0) A)))
                             (AS 0 (BITS 212 9 0) A)))
                   (29 (LET* ((A (AS 7 (BITS 810 9 0) A))
                              (A (AS 6 (BITS 872 9 0) A))
                              (A (AS 5 (BITS 934 9 0) A))
                              (A (AS 4 (BITS 996 9 0) A))
                              (A (AS 3 (BITS 28 9 0) A))
                              (A (AS 2 (BITS 90 9 0) A))
                              (A (AS 1 (BITS 152 9 0) A)))
                             (AS 0 (BITS 214 9 0) A)))
                   (30 (LET* ((A (AS 7 (BITS 806 9 0) A))
                              (A (AS 6 (BITS 870 9 0) A))
                              (A (AS 5 (BITS 930 9 0) A))
                              (A (AS 4 (BITS 996 9 0) A))
                              (A (AS 3 (BITS 28 9 0) A))
                              (A (AS 2 (BITS 94 9 0) A))
                              (A (AS 1 (BITS 154 9 0) A)))
                             (AS 0 (BITS 218 9 0) A)))
                   (31 (LET* ((A (AS 7 (BITS 802 9 0) A))
                              (A (AS 6 (BITS 866 9 0) A))
                              (A (AS 5 (BITS 930 9 0) A))
                              (A (AS 4 (BITS 992 9 0) A))
                              (A (AS 3 (BITS 32 9 0) A))
                              (A (AS 2 (BITS 94 9 0) A))
                              (A (AS 1 (BITS 158 9 0) A)))
                             (AS 0 (BITS 222 9 0) A)))
                   (T A))))

(DEFUND
 NEXTDIGIT (RS10 CMPCONST)
 (LET
  ((GEP4 (BITS (+ RS10 (AG 7 CMPCONST)) 10 0))
   (GEP3 (BITS (+ RS10 (AG 6 CMPCONST)) 10 0))
   (GEP2 (BITS (+ RS10 (AG 5 CMPCONST)) 10 0))
   (GEP1 (BITS (+ RS10 (AG 4 CMPCONST)) 10 0))
   (GEZ0 (BITS (+ RS10 (AG 3 CMPCONST)) 10 0))
   (GEN1 (BITS (+ RS10 (AG 2 CMPCONST)) 10 0))
   (GEN2 (BITS (+ RS10 (AG 1 CMPCONST)) 10 0))
   (GEN3 (BITS (+ RS10 (AG 0 CMPCONST)) 10 0))
   (Q 0))
  (IF1 (LOGAND1 (BITN GEP4 10)
                (LOGNOT1 (BITN RS10 9)))
       4
       (IF1 (LOGAND1 (LOGNOT1 (BITN GEP4 10))
                     (BITN GEP3 10))
            3
            (IF1 (LOGAND1 (LOGNOT1 (BITN GEP3 10))
                          (BITN GEP2 10))
                 2
                 (IF1 (LOGAND1 (LOGNOT1 (BITN GEP2 10))
                               (BITN GEP1 10))
                      1
                      (IF1 (LOGIOR1 (LOGAND1 (LOGNOT1 (BITN GEP1 10))
                                             (LOGNOT1 (BITN RS10 9)))
                                    (BITN GEZ0 10))
                           0
                           (IF1 (LOGAND1 (LOGNOT1 (BITN GEZ0 10))
                                         (BITN GEN1 10))
                                -1
                                (IF1 (LOGAND1 (LOGNOT1 (BITN GEN1 10))
                                              (BITN GEN2 10))
                                     -2
                                     (IF1 (LOGAND1 (LOGNOT1 (BITN GEN2 10))
                                                   (BITN GEN3 10))
                                          -3
                                          (IF1 (LOGAND1 (LOGNOT1 (BITN GEN3 10))
                                                        (BITN RS10 9))
                                               -4 Q)))))))))))

(DEFUND
 NEXTREM
 (RP RN REMSIGN Q DIVSIGNED DIV3SIGNED FMT)
 (LET*
     ((DIVMULT 0)
      (DIVMULT (CASE Q
                     ((4 -4)
                      (LET* ((DIVMULT (BITS (ASH DIVSIGNED 2) 70 0))
                             (DIVMULT (SETBITN DIVMULT 71 0 (LOGNOT1 REMSIGN))))
                            (SETBITN DIVMULT 71 1 (LOGNOT1 REMSIGN))))
                     ((3 -3) DIV3SIGNED)
                     ((2 -2)
                      (LET ((DIVMULT (BITS (ASH DIVSIGNED 1) 70 0)))
                           (SETBITN DIVMULT 71 0 (LOGNOT1 REMSIGN))))
                     ((1 -1) DIVSIGNED)
                     (T DIVMULT)))
      (RP8 (BITS (ASH RP 3) 70 0))
      (RN8 (BITS (ASH RN 3) 70 0))
      (SUM (LOGXOR (LOGXOR RN8 RP8) DIVMULT))
      (CARRY (LOGIOR (LOGAND (BITS (LOGNOT RN8) 70 0) RP8)
                     (LOGAND (LOGIOR (BITS (LOGNOT RN8) 70 0) RP8)
                             DIVMULT))))
     (MV-LET (RP RN)
             (CASE FMT
                   (2 (MV (SETBITN (SETBITS RP 71 70 12 (BITS CARRY 69 11))
                                   71 11 (LOGNOT1 REMSIGN))
                          (SETBITS RN 71 70 11 (BITS SUM 70 11))))
                   (1 (MV (SETBITN (SETBITS RP 71 70 41 (BITS CARRY 69 40))
                                   71 40 (LOGNOT1 REMSIGN))
                          (SETBITS RN 71 70 40 (BITS SUM 70 40))))
                   (0 (MV (SETBITN (SETBITS RP 71 70 54 (BITS CARRY 69 53))
                                   71 53 (LOGNOT1 REMSIGN))
                          (SETBITS RN 71 70 53 (BITS SUM 70 53))))
                   (T (MV RP RN)))
             (IF1 (LOG= Q 0)
                  (MV RP8 RN8)
                  (MV RP RN)))))

(DEFUND NEXTQUOT (Q QUOT QUOTM1)
        (LET ((QUOTNEW 0) (QUOTM1NEW 0))
             (MV (SETBITS (BITS (IF1 (LOG>= Q 0)
                                     (ASH QUOT 3)
                                     (ASH QUOTM1 3))
                                64 0)
                          65 2 0 Q)
                 (SETBITS (BITS (IF1 (LOG> Q 0)
                                     (ASH QUOT 3)
                                     (ASH QUOTM1 3))
                                64 0)
                          65 2 0 (- Q 1)))))

(DEFUND INCQUOT
        (Q QUOT
           QUOTM1 QLAST QUOTLAST QUOTM1LAST LSBIS2)
        (LET ((QUOTP 0) (QUOTM1P 0))
             (IF1 LSBIS2
                  (IF1 (LOG= Q 4)
                       (MV (SETBITS (BITS (IF1 (LOG>= QLAST -1)
                                               (ASH QUOTLAST 6)
                                               (ASH QUOTM1LAST 6))
                                          64 0)
                                    65 5 3 (+ QLAST 1))
                           (SETBITS (SETBITS (BITS (IF1 (LOG>= QLAST 0)
                                                        (ASH QUOTLAST 6)
                                                        (ASH QUOTM1LAST 6))
                                                   64 0)
                                             65 5 3 QLAST)
                                    65 2 0 7))
                       (MV (SETBITS (BITS (ASH QUOT 3) 64 0)
                                    65 2 0 (+ Q 4))
                           (SETBITS (BITS (IF1 (LOG= Q -4)
                                               (ASH QUOTM1 3)
                                               (ASH QUOT 3))
                                          64 0)
                                    65 2 0 (+ Q 3))))
                  (MV (SETBITS (BITS (IF1 (LOG>= Q -2)
                                          (ASH QUOT 3)
                                          (ASH QUOTM1 3))
                                     64 0)
                               65 2 0 (+ Q 2))
                      (SETBITS (BITS (IF1 (LOG>= Q -1)
                                          (ASH QUOT 3)
                                          (ASH QUOTM1 3))
                                     64 0)
                               65 2 0 (+ Q 1))))))

(DEFUND COMPUTERS11
        (RP RN Q DIVSIGNED DIV3SIGNED)
        (LET* ((RP13 (BITS RP 61 49))
               (RN13 (BITS RN 61 49))
               (DIVMULT 0)
               (DIVMULT (CASE Q ((4 -4) (BITS DIVSIGNED 62 50))
                              ((3 -3) (BITS DIV3SIGNED 64 52))
                              ((2 -2) (BITS DIVSIGNED 63 51))
                              ((1 -1) (BITS DIVSIGNED 64 52))
                              (T DIVMULT)))
               (SUM (BITS (LOGXOR (LOGXOR (BITS RP13 12 1)
                                          (BITS RN13 12 1))
                                  (BITS DIVMULT 12 1))
                          11 0))
               (CARRY (BITS (LOGIOR (LOGAND (BITS RP13 11 0)
                                            (LOGNOT (BITS RN13 11 0)))
                                    (LOGAND (LOGIOR (BITS RP13 11 0)
                                                    (LOGNOT (BITS RN13 11 0)))
                                            (BITS DIVMULT 11 0)))
                            11 0))
               (SUM12 0)
               (SUM12 (IF1 (LOG= Q 0)
                           (BITS (+ (+ (BITS RP13 12 1)
                                       (LOGNOT (BITS RN13 12 1)))
                                    1)
                                 11 0)
                           (BITS (+ (+ CARRY (LOGNOT SUM)) 1)
                                 11 0))))
              (BITS SUM12 11 1)))

(DEFUND COMPUTERS10
        (DIVSIGNED DIV3SIGNED Q RS11)
        (LET* ((DIVMULT 0)
               (DIVMULT (CASE Q ((4 -4) (BITS DIVSIGNED 65 55))
                              ((3 -3) (BITS DIV3SIGNED 67 57))
                              ((2 -2) (BITS DIVSIGNED 66 56))
                              ((1 -1) (BITS DIVSIGNED 67 57))
                              (0 (BITS 0 10 0))
                              (T DIVMULT)))
               (SUM11 (BITS (+ (+ RS11 DIVMULT) 1) 10 0)))
              (BITS SUM11 10 1)))

(DEFUND
 FDIV8-LOOP-0
 (J CMPCONST DIV DIV3 FMT
    LSBIS2 Q QLAST QUOTLAST QUOTM1LAST RS11
    RP RN RS10 QUOTP QUOTM1P QUOT QUOTM1)
 (DECLARE (XARGS :MEASURE (NFIX (- (1+ 2) J))))
 (IF
  (AND (INTEGERP J) (<= J 2))
  (LET
   ((Q (NEXTDIGIT RS10 CMPCONST)))
   (MV-LET
    (QLAST QUOTLAST QUOTM1LAST)
    (IF1 (LOG= J 1)
         (MV Q QUOT QUOTM1)
         (MV QLAST QUOTLAST QUOTM1LAST))
    (LET
     ((DIVSIGNED 0) (DIV3SIGNED 0))
     (MV-LET
      (DIVSIGNED DIV3SIGNED)
      (IF1 (BITN RS10 9)
           (MV DIV DIV3)
           (MV (BITS (LOGNOT DIV) 70 0)
               (BITS (LOGNOT DIV3) 70 0)))
      (LET
       ((RS11 (IF1 (LOG= J 1)
                   (COMPUTERS11 RP RN Q DIVSIGNED DIV3SIGNED)
                   RS11)))
       (MV-LET
        (RP RN)
        (NEXTREM RP RN (BITN RS10 9)
                 Q DIVSIGNED DIV3SIGNED FMT)
        (LET
          ((RS10 (IF1 (LOG= J 1)
                      (BITS (+ (+ (BITS RP 67 58)
                                  (LOGNOT (BITS RN 67 58)))
                               1)
                            9 0)
                      (COMPUTERS10 DIVSIGNED DIV3SIGNED Q RS11))))
          (MV-LET (QUOTP QUOTM1P)
                  (IF1 (LOG= J 2)
                       (INCQUOT Q QUOT
                                QUOTM1 QLAST QUOTLAST QUOTM1LAST LSBIS2)
                       (MV QUOTP QUOTM1P))
                  (MV-LET (QUOT QUOTM1)
                          (NEXTQUOT Q QUOT QUOTM1)
                          (FDIV8-LOOP-0 (+ J 1)
                                        CMPCONST DIV DIV3 FMT LSBIS2
                                        Q QLAST QUOTLAST QUOTM1LAST RS11 RP RN
                                        RS10 QUOTP QUOTM1P QUOT QUOTM1))))))))))
  (MV Q QLAST QUOTLAST QUOTM1LAST RS11
      RP RN RS10 QUOTP QUOTM1P QUOT QUOTM1)))

(DEFUND FDIV8-LOOP-1
        (I C CMPCONST DIV DIV3 FMT
           LSBIS2 Q QLAST QUOTLAST QUOTM1LAST RS11
           RP RN RS10 QUOTP QUOTM1P QUOT QUOTM1)
        (DECLARE (XARGS :MEASURE (NFIX (- (1+ C) I))))
        (IF (AND (INTEGERP I) (INTEGERP C) (<= I C))
            (MV-LET (Q QLAST QUOTLAST QUOTM1LAST RS11
                       RP RN RS10 QUOTP QUOTM1P QUOT QUOTM1)
                    (FDIV8-LOOP-0 1 CMPCONST DIV DIV3 FMT
                                  LSBIS2 Q QLAST QUOTLAST QUOTM1LAST RS11
                                  RP RN RS10 QUOTP QUOTM1P QUOT QUOTM1)
                    (FDIV8-LOOP-1 (+ I 1)
                                  C CMPCONST DIV DIV3 FMT
                                  LSBIS2 Q QLAST QUOTLAST QUOTM1LAST RS11
                                  RP RN RS10 QUOTP QUOTM1P QUOT QUOTM1))
            (MV Q QLAST QUOTLAST QUOTM1LAST RS11
                RP RN RS10 QUOTP QUOTM1P QUOT QUOTM1)))

(DEFUND
 FDIV8 (OPA OPB FMT FZ DN RMODE)
 (LET
  ((SIGNA 0)
   (SIGNB 0)
   (EXPA 0)
   (EXPB 0)
   (MANA 0)
   (MANB 0)
   (CLASSA 0)
   (CLASSB 0)
   (FLAGS (BITS 0 7 0)))
  (MV-LET
   (SIGNA EXPA MANA CLASSA FLAGS)
   (ANALYZE OPA FMT FZ FLAGS)
   (MV-LET
    (SIGNB EXPB MANB CLASSB FLAGS)
    (ANALYZE OPB FMT FZ FLAGS)
    (LET
     ((SIGN (LOGXOR SIGNA SIGNB)))
     (IF1
      (LOGIOR1
          (LOGIOR1 (LOGIOR1 (LOGIOR1 (LOGIOR1 (LOGIOR1 (LOGIOR1 (LOG= CLASSA 0)
                                                                (LOG= CLASSA 1))
                                                       (LOG= CLASSA 2))
                                              (LOG= CLASSA 3))
                                     (LOG= CLASSB 0))
                            (LOG= CLASSB 1))
                   (LOG= CLASSB 2))
          (LOG= CLASSB 3))
      (SPECIALCASE SIGN OPA OPB CLASSA CLASSB FMT DN FLAGS)
      (LET
       ((DIVPOW2 (LOGAND1 (LOGAND1 (LOG= CLASSA 4)
                                   (LOG= CLASSB 4))
                          (LOG= MANB 0)))
        (SIGA 0)
        (SIGB 0)
        (EXPDIFF 0))
       (MV-LET
        (SIGA SIGB EXPDIFF)
        (NORMALIZE EXPA EXPB MANA MANB FMT)
        (LET*
         ((DIV (BITS (ASH SIGB 14) 70 0))
          (DIV2 (BITS (ASH DIV 1) 70 0))
          (DIV3 (BITS (+ DIV DIV2) 70 0))
          (CMPCONST (COMPUTECMPCONST (BITS DIV 65 60)))
          (RP 0)
          (RN 0)
          (Q 0)
          (QLAST 0)
          (QUOT (BITS 0 64 0))
          (QUOTM1 (BITS 0 64 0))
          (QUOTLAST 0)
          (QUOTM1LAST 0)
          (QUOTP 0)
          (QUOTM1P 0)
          (RS10 0)
          (RS11 0)
          (SIGABAR (BITS (LOGNOT SIGA) 52 0))
          (SIGCMP (BITS (+ SIGB SIGABAR) 53 0))
          (SIGALTSIGB (BITN SIGCMP 53))
          (EXPQ 0))
         (MV-LET
          (RP EXPQ)
          (IF1 SIGALTSIGB
               (MV (BITS (ASH SIGA 15) 70 0)
                   (BITS (- (SI EXPDIFF 13) 1) 12 0))
               (MV (BITS (ASH SIGA 14) 70 0) EXPDIFF))
          (LET*
           ((RS10 (BITS RP 70 61))
            (GEP2 (BITS (+ RS10 (AG 5 CMPCONST)) 10 0)))
           (MV-LET
            (Q QUOT QUOTM1 RN)
            (IF1 (BITN GEP2 10)
                 (MV 2 (BITS 2 64 0) (BITS 1 64 0) DIV2)
                 (MV 1 (BITS 1 64 0) (BITS 0 64 0) DIV))
            (LET
             ((RS10 (BITS (+ (+ (BITS RP 67 58)
                                (LOGNOT (BITS RN 67 58)))
                             1)
                          9 0))
              (QTRUNC 0)
              (QINC 0)
              (STK 0))
             (MV-LET
              (Q QLAST QUOTLAST
                 QUOTM1LAST RS11 RP RN RS10 QUOTP
                 QUOTM1P QUOT QUOTM1 QINC QTRUNC STK)
              (IF1
               DIVPOW2
               (MV Q QLAST QUOTLAST QUOTM1LAST
                   RS11 RP RN RS10 QUOTP QUOTM1P QUOT
                   QUOTM1 QINC (BITS (ASH MANA 1) 52 0)
                   0)
               (LET*
                  ((C 0)
                   (C (CASE FMT (2 (BITS 9 4 0))
                            (1 (BITS 4 4 0))
                            (0 (BITS 2 4 0))
                            (T C)))
                   (LSBIS2 (LOG<> FMT 1)))
                  (MV-LET
                       (Q QLAST QUOTLAST QUOTM1LAST RS11
                          RP RN RS10 QUOTP QUOTM1P QUOT QUOTM1)
                       (FDIV8-LOOP-1 1 C CMPCONST DIV DIV3 FMT
                                     LSBIS2 Q QLAST QUOTLAST QUOTM1LAST RS11
                                     RP RN RS10 QUOTP QUOTM1P QUOT QUOTM1)
                       (MV-LET (QTRUNC QINC STK)
                               (COMPUTEQ QUOT QUOTM1 QUOTP QUOTM1P RP RN LSBIS2)
                               (MV Q QLAST QUOTLAST
                                   QUOTM1LAST RS11 RP RN RS10 QUOTP
                                   QUOTM1P QUOT QUOTM1 QINC QTRUNC STK)))))
              (LET ((QRND 0)
                    (QRNDDEN 0)
                    (INX 0)
                    (INXDEN 0))
                   (MV-LET (QRND INX QRNDDEN INXDEN)
                           (ROUNDER QTRUNC QINC STK SIGN EXPQ RMODE FMT)
                           (FINAL QRND INX QRNDDEN INXDEN SIGN
                                  EXPQ RMODE FZ FMT FLAGS)))))))))))))))))

