; System Utilities -- World Queries
;
; Copyright (C) 2020 Kestrel Institute (http://www.kestrel.edu)
; Copyright (C) 2018 Regents of the University of Texas
;
; License: A 3-clause BSD license. See the LICENSE file distributed with ACL2.
;
; Authors:
;   Alessandro Coglio (coglio@kestrel.edu)
;   Eric Smith (eric.smith@kestrel.edu)
;   Matt Kaufmann (kaufmann@cs.utexas.edu)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "ACL2")

(include-book "xdoc/constructors" :dir :system)
(include-book "std/util/deflist" :dir :system)
(include-book "std/util/defrule" :dir :system)
(include-book "system/kestrel" :dir :system)
(include-book "system/pseudo-good-worldp" :dir :system)

(include-book "std/system/arity-plus" :dir :system)
(include-book "std/system/classes" :dir :system)
(include-book "std/system/classes-plus" :dir :system)
(include-book "std/system/definedp" :dir :system)
(include-book "std/system/definedp-plus" :dir :system)
(include-book "std/system/event-landmark-names" :dir :system)
(include-book "std/system/formals-plus" :dir :system)
(include-book "std/system/fresh-namep" :dir :system)
(include-book "std/system/function-name-listp" :dir :system)
(include-book "std/system/function-namep" :dir :system)
(include-book "std/system/function-symbol-listp" :dir :system)
(include-book "std/system/fundef-disabledp" :dir :system)
(include-book "std/system/fundef-enabledp" :dir :system)
(include-book "std/system/guard-verified-p" :dir :system)
(include-book "std/system/guard-verified-p-plus" :dir :system)
(include-book "std/system/included-books" :dir :system)
(include-book "std/system/induction-machine" :dir :system)
(include-book "std/system/induction-machine-plus" :dir :system)
(include-book "std/system/irecursivep" :dir :system)
(include-book "std/system/irecursivep-plus" :dir :system)
(include-book "std/system/known-packages" :dir :system)
(include-book "std/system/known-packages-plus" :dir :system)
(include-book "std/system/logic-function-namep" :dir :system)
(include-book "std/system/logical-name-listp" :dir :system)
(include-book "std/system/macro-args-plus" :dir :system)
(include-book "std/system/macro-keyword-args" :dir :system)
(include-book "std/system/macro-keyword-args-plus" :dir :system)
(include-book "std/system/macro-required-args" :dir :system)
(include-book "std/system/macro-required-args-plus" :dir :system)
(include-book "std/system/macro-name-listp" :dir :system)
(include-book "std/system/macro-namep" :dir :system)
(include-book "std/system/macro-symbol-listp" :dir :system)
(include-book "std/system/macro-symbolp" :dir :system)
(include-book "std/system/measure" :dir :system)
(include-book "std/system/measure-plus" :dir :system)
(include-book "std/system/measured-subset" :dir :system)
(include-book "std/system/measured-subset-plus" :dir :system)
(include-book "std/system/no-stobjs-p" :dir :system)
(include-book "std/system/no-stobjs-p-plus" :dir :system)
(include-book "std/system/non-executablep" :dir :system)
(include-book "std/system/non-executablep-plus" :dir :system)
(include-book "std/system/number-of-results" :dir :system)
(include-book "std/system/number-of-results-plus" :dir :system)
(include-book "std/system/pseudo-command-landmark-listp" :dir :system)
(include-book "std/system/pseudo-event-landmark-listp" :dir :system)
(include-book "std/system/pseudo-tests-and-callp" :dir :system)
(include-book "std/system/pseudo-tests-and-call-listp" :dir :system)
(include-book "std/system/primitivep" :dir :system)
(include-book "std/system/primitivep-plus" :dir :system)
(include-book "std/system/recursive-calls" :dir :system)
(include-book "std/system/ruler-extenders" :dir :system)
(include-book "std/system/ruler-extenders-plus" :dir :system)
(include-book "std/system/rune-disabledp" :dir :system)
(include-book "std/system/rune-enabledp" :dir :system)
(include-book "std/system/stobjs-in-plus" :dir :system)
(include-book "std/system/stobjs-out-plus" :dir :system)
(include-book "std/system/term-function-recognizers" :dir :system)
(include-book "std/system/thm-formula" :dir :system)
(include-book "std/system/thm-formula-plus" :dir :system)
(include-book "std/system/theorem-name-listp" :dir :system)
(include-book "std/system/theorem-namep" :dir :system)
(include-book "std/system/theorem-symbol-listp" :dir :system)
(include-book "std/system/theorem-symbolp" :dir :system)
(include-book "std/system/ubody" :dir :system)
(include-book "std/system/ubody-plus" :dir :system)
(include-book "std/system/uguard" :dir :system)
(include-book "std/system/uguard-plus" :dir :system)
(include-book "std/system/unwrapped-nonexec-body" :dir :system)
(include-book "std/system/unwrapped-nonexec-body-plus" :dir :system)
(include-book "std/system/well-founded-relation" :dir :system)
(include-book "std/system/well-founded-relation-plus" :dir :system)
