(* tinyScript.sml - generated by L<3> - Mon Jun 24 13:23:24 2013 *)

open HolKernel boolLib bossLib Import

val () = Import.start "tiny"

val _ = Construct[("funcT",
    [("fADD",[]), ("fSUB",[]), ("fINC",[]), ("fDEC",[]), ("fAND",[]),
     ("fOR",[]), ("fXOR",[]), ("fReserved",[])])]
;

val _ = Construct[("shiftT",
    [("noShift",[]), ("RCY1",[]), ("RCY8",[]), ("RCY16",[])])]
;

val _ = Construct[("conditionT",
    [("skipNever",[]), ("skipNeg",[]), ("skipZero",[]), ("skipInRdy",[])])]
;

val _ = Construct[("instruction",
    [("In",
      [PTy
         (CTy"funcT",
          PTy
            (CTy"shiftT",PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))]),
     ("Jump",
      [PTy(CTy"funcT",PTy(CTy"shiftT",PTy(FTy 7,PTy(FTy 7,FTy 7))))]),
     ("LoadConstant",[PTy(FTy 7,FTy 24)]),
     ("LoadDM",
      [PTy
         (CTy"funcT",
          PTy
            (CTy"shiftT",PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))]),
     ("Normal",
      [PTy
         (CTy"funcT",
          PTy
            (CTy"shiftT",PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))]),
     ("Out",
      [PTy
         (CTy"funcT",
          PTy
            (CTy"shiftT",PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))]),
     ("ReservedInstr",[]),
     ("StoreDM",
      [PTy
         (CTy"funcT",
          PTy
            (CTy"shiftT",PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))]),
     ("StoreIM",
      [PTy
         (CTy"funcT",
          PTy
            (CTy"shiftT",PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))])])]
;

val _ = Construct[("exception",[("NoException",[]), ("Reserved",[])])]
;

val _ = Record("tiny_state",
   [("DM",ATy(FTy 10,F32)), ("IM",ATy(FTy 10,F32)), ("InData",F32),
    ("InRdy",bTy), ("OutStrobe",F32), ("PC",FTy 10), ("R",ATy(FTy 7,F32)),
    ("exception",CTy"exception")])
;

val qTy = CTy "tiny_state"
;

fun qVar v = Term.mk_var (v, ParseDatatype.pretypeToType qTy)
;

val raise'exception_def = Def
  ("raise'exception",Var("e",CTy"exception"),
   Close
     (qVar"state",
      TP[LX(VTy"a"),
         ITE
           (EQ
              (Dest("exception",CTy"exception",qVar"state"),
               LC("NoException",CTy"exception")),
            Rupd("exception",TP[qVar"state", Var("e",CTy"exception")]),
            qVar"state")]))
;

val function_def = Def
  ("function",TP[Var("func",CTy"funcT"), Var("a",F32), Var("b",F32)],
   Close
     (qVar"state",
      CS
        (Var("func",CTy"funcT"),
         [(LC("fADD",CTy"funcT"),
           TP[Bop(Add,Var("a",F32),Var("b",F32)), qVar"state"]),
          (LC("fSUB",CTy"funcT"),
           TP[Bop(Sub,Var("a",F32),Var("b",F32)), qVar"state"]),
          (LC("fINC",CTy"funcT"),
           TP[Bop(Add,Var("b",F32),LW(1,32)), qVar"state"]),
          (LC("fDEC",CTy"funcT"),
           TP[Bop(Sub,Var("b",F32),LW(1,32)), qVar"state"]),
          (LC("fAND",CTy"funcT"),
           TP[Bop(BAnd,Var("a",F32),Var("b",F32)), qVar"state"]),
          (LC("fOR",CTy"funcT"),
           TP[Bop(BOr,Var("a",F32),Var("b",F32)), qVar"state"]),
          (LC("fXOR",CTy"funcT"),
           TP[Bop(BXor,Var("a",F32),Var("b",F32)), qVar"state"]),
          (AVar(CTy"funcT"),
           Apply
             (Call
                ("raise'exception",ATy(qTy,PTy(F32,qTy)),
                 LC("Reserved",CTy"exception")),qVar"state"))])))
;

val shifter_def = Def
  ("shifter",TP[Var("shift",CTy"shiftT"), Var("a",F32)],
   CS
     (Var("shift",CTy"shiftT"),
      [(LC("noShift",CTy"shiftT"),Var("a",F32)),
       (LC("RCY1",CTy"shiftT"),Bop(Ror,Var("a",F32),LN 1)),
       (LC("RCY8",CTy"shiftT"),Bop(Ror,Var("a",F32),LN 8)),
       (LC("RCY16",CTy"shiftT"),Bop(Ror,Var("a",F32),LN 16))]))
;

val ALU_def = Def
  ("ALU",
   TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"), Var("a",F32),
      Var("b",F32)],
   Close
     (qVar"state",
      Let
        (TP[Var("v",F32), qVar"s"],
         Apply
           (Call
              ("function",ATy(qTy,PTy(F32,qTy)),
               TP[Var("func",CTy"funcT"), Var("a",F32), Var("b",F32)]),
            qVar"state"),
         TP[Call("shifter",F32,TP[Var("shift",CTy"shiftT"), Var("v",F32)]),
            qVar"s"])))
;

val incPC_def = Def
  ("incPC",TP[Var("skip",CTy"conditionT"), Var("alu",F32)],
   Close
     (qVar"state",
      CS
        (Var("skip",CTy"conditionT"),
         [(LC("skipNever",CTy"conditionT"),
           TP[LU,
              Rupd
                ("PC",
                 TP[qVar"state",
                    Bop(Add,Dest("PC",FTy 10,qVar"state"),LW(1,10))])]),
          (LC("skipNeg",CTy"conditionT"),
           TP[LU,
              Rupd
                ("PC",
                 TP[qVar"state",
                    Bop
                      (Add,Dest("PC",FTy 10,qVar"state"),
                       ITE
                         (Bop(Lt,Var("alu",F32),LW(0,32)),LW(2,10),
                          LW(1,10)))])]),
          (LC("skipZero",CTy"conditionT"),
           TP[LU,
              Rupd
                ("PC",
                 TP[qVar"state",
                    Bop
                      (Add,Dest("PC",FTy 10,qVar"state"),
                       ITE(EQ(Var("alu",F32),LW(0,32)),LW(2,10),LW(1,10)))])]),
          (LC("skipInRdy",CTy"conditionT"),
           TP[LU,
              Rupd
                ("PC",
                 TP[qVar"state",
                    Bop
                      (Add,Dest("PC",FTy 10,qVar"state"),
                       ITE
                         (Dest("InRdy",bTy,qVar"state"),LW(2,10),LW(1,10)))])])])))
;

val norm_def = Def
  ("norm",
   TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
      Var("skip",CTy"conditionT"), bVar"wback", bVar"strobe",
      Var("w",FTy 7), Var("a",FTy 7), Var("b",FTy 7)],
   Close
     (qVar"state",
      Let
        (TP[Var("v",F32), qVar"s"],
         Apply
           (Call
              ("ALU",ATy(qTy,PTy(F32,qTy)),
               TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
                  Apply
                    (Dest("R",ATy(FTy 7,F32),qVar"state"),Var("a",FTy 7)),
                  Apply
                    (Dest("R",ATy(FTy 7,F32),qVar"state"),Var("b",FTy 7))]),
            qVar"state"),
         Let
           (qVar"s",
            ITE
              (bVar"wback",
               Rupd
                 ("R",
                  TP[qVar"s",
                     Fupd
                       (Dest("R",ATy(FTy 7,F32),qVar"s"),Var("w",FTy 7),
                        Var("v",F32))]),qVar"s"),
            Apply
              (Call
                 ("incPC",ATy(qTy,PTy(uTy,qTy)),
                  TP[Var("skip",CTy"conditionT"), Var("v",F32)]),
               ITE
                 (bVar"strobe",
                  Rupd("OutStrobe",TP[qVar"s", Var("v",F32)]),qVar"s"))))))
;

val dfn'Normal_def = Def
  ("dfn'Normal",
   TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
      Var("skip",CTy"conditionT"), Var("w",FTy 7), Var("a",FTy 7),
      Var("b",FTy 7)],
   Close
     (qVar"state",
      Apply
        (Call
           ("norm",ATy(qTy,PTy(uTy,qTy)),
            TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
               Var("skip",CTy"conditionT"), LT, LF, Var("w",FTy 7),
               Var("a",FTy 7), Var("b",FTy 7)]),qVar"state")))
;

val dfn'StoreDM_def = Def
  ("dfn'StoreDM",
   TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
      Var("skip",CTy"conditionT"), Var("w",FTy 7), Var("a",FTy 7),
      Var("b",FTy 7)],
   Close
     (qVar"state",
      Apply
        (Call
           ("norm",ATy(qTy,PTy(uTy,qTy)),
            TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
               Var("skip",CTy"conditionT"), LT, LF, Var("w",FTy 7),
               Var("a",FTy 7), Var("b",FTy 7)]),
         Rupd
           ("DM",
            TP[qVar"state",
               Fupd
                 (Dest("DM",ATy(FTy 10,F32),qVar"state"),
                  Mop
                    (Cast(FTy 10),
                     Apply
                       (Dest("R",ATy(FTy 7,F32),qVar"state"),
                        Var("b",FTy 7))),
                  Apply
                    (Dest("R",ATy(FTy 7,F32),qVar"state"),Var("a",FTy 7)))]))))
;

val dfn'StoreIM_def = Def
  ("dfn'StoreIM",
   TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
      Var("skip",CTy"conditionT"), Var("w",FTy 7), Var("a",FTy 7),
      Var("b",FTy 7)],
   Close
     (qVar"state",
      Apply
        (Call
           ("norm",ATy(qTy,PTy(uTy,qTy)),
            TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
               Var("skip",CTy"conditionT"), LT, LF, Var("w",FTy 7),
               Var("a",FTy 7), Var("b",FTy 7)]),
         Rupd
           ("IM",
            TP[qVar"state",
               Fupd
                 (Dest("IM",ATy(FTy 10,F32),qVar"state"),
                  Mop
                    (Cast(FTy 10),
                     Apply
                       (Dest("R",ATy(FTy 7,F32),qVar"state"),
                        Var("b",FTy 7))),
                  Apply
                    (Dest("R",ATy(FTy 7,F32),qVar"state"),Var("a",FTy 7)))]))))
;

val dfn'Out_def = Def
  ("dfn'Out",
   TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
      Var("skip",CTy"conditionT"), Var("w",FTy 7), Var("a",FTy 7),
      Var("b",FTy 7)],
   Close
     (qVar"state",
      Apply
        (Call
           ("norm",ATy(qTy,PTy(uTy,qTy)),
            TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
               Var("skip",CTy"conditionT"), LT, LT, Var("w",FTy 7),
               Var("a",FTy 7), Var("b",FTy 7)]),qVar"state")))
;

val dfn'LoadDM_def = Def
  ("dfn'LoadDM",
   TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
      Var("skip",CTy"conditionT"), Var("w",FTy 7), Var("a",FTy 7),
      Var("b",FTy 7)],
   Close
     (qVar"state",
      Apply
        (Call
           ("norm",ATy(qTy,PTy(uTy,qTy)),
            TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
               Var("skip",CTy"conditionT"), LF, LF, Var("w",FTy 7),
               Var("a",FTy 7), Var("b",FTy 7)]),
         Rupd
           ("R",
            TP[qVar"state",
               Fupd
                 (Dest("R",ATy(FTy 7,F32),qVar"state"),Var("w",FTy 7),
                  Apply
                    (Dest("DM",ATy(FTy 10,F32),qVar"state"),
                     Mop
                       (Cast(FTy 10),
                        Apply
                          (Dest("R",ATy(FTy 7,F32),qVar"state"),
                           Var("b",FTy 7)))))]))))
;

val dfn'In_def = Def
  ("dfn'In",
   TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
      Var("skip",CTy"conditionT"), Var("w",FTy 7), Var("a",FTy 7),
      Var("b",FTy 7)],
   Close
     (qVar"state",
      Apply
        (Call
           ("norm",ATy(qTy,PTy(uTy,qTy)),
            TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
               Var("skip",CTy"conditionT"), LF, LF, Var("w",FTy 7),
               Var("a",FTy 7), Var("b",FTy 7)]),
         Rupd
           ("R",
            TP[qVar"state",
               Fupd
                 (Dest("R",ATy(FTy 7,F32),qVar"state"),Var("w",FTy 7),
                  Dest("InData",F32,qVar"state"))]))))
;

val dfn'Jump_def = Def
  ("dfn'Jump",
   TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"), Var("w",FTy 7),
      Var("a",FTy 7), Var("b",FTy 7)],
   Close
     (qVar"state",
      Let
        (qVar"s",
         Rupd
           ("R",
            TP[qVar"state",
               Fupd
                 (Dest("R",ATy(FTy 7,F32),qVar"state"),Var("w",FTy 7),
                  Mop
                    (Cast(F32),
                     Bop(Add,Dest("PC",FTy 10,qVar"state"),LW(1,10))))]),
         Let
           (TP[Var("v",FTy 10), qVar"s"],
            Let
              (TP[Var("v",F32), qVar"s"],
               Apply
                 (Call
                    ("ALU",ATy(qTy,PTy(F32,qTy)),
                     TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
                        Apply
                          (Dest("R",ATy(FTy 7,F32),qVar"s"),
                           Var("a",FTy 7)),
                        Apply
                          (Dest("R",ATy(FTy 7,F32),qVar"s"),
                           Var("b",FTy 7))]),qVar"s"),
               TP[Mop(Cast(FTy 10),Var("v",F32)), qVar"s"]),
            TP[LU, Rupd("PC",TP[qVar"s", Var("v",FTy 10)])]))))
;

val dfn'LoadConstant_def = Def
  ("dfn'LoadConstant",TP[Var("w",FTy 7), Var("imm",FTy 24)],
   Close
     (qVar"state",
      Let
        (qVar"s",
         Rupd
           ("R",
            TP[qVar"state",
               Fupd
                 (Dest("R",ATy(FTy 7,F32),qVar"state"),Var("w",FTy 7),
                  Mop(Cast(F32),Var("imm",FTy 24)))]),
         TP[LU,
            Rupd
              ("PC",
               TP[qVar"s", Bop(Add,Dest("PC",FTy 10,qVar"s"),LW(1,10))])])))
;

val dfn'ReservedInstr_def = Def
  ("dfn'ReservedInstr",qVar"state",
   Apply
     (Call
        ("raise'exception",ATy(qTy,PTy(uTy,qTy)),
         LC("Reserved",CTy"exception")),qVar"state"))
;

val Run_def = Def
  ("Run",Var("v0",CTy"instruction"),
   Close
     (qVar"state",
      CS
        (Var("v0",CTy"instruction"),
         [(Const("ReservedInstr",CTy"instruction"),
           Apply
             (Const("dfn'ReservedInstr",ATy(qTy,PTy(uTy,qTy))),
              qVar"state")),
          (Call
             ("In",CTy"instruction",
              Var
                ("v1",
                 PTy
                   (CTy"funcT",
                    PTy
                      (CTy"shiftT",
                       PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
           Apply
             (Call
                ("dfn'In",ATy(qTy,PTy(uTy,qTy)),
                 Var
                   ("v1",
                    PTy
                      (CTy"funcT",
                       PTy
                         (CTy"shiftT",
                          PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
              qVar"state")),
          (Call
             ("Jump",CTy"instruction",
              Var
                ("v2",
                 PTy
                   (CTy"funcT",
                    PTy(CTy"shiftT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))),
           Apply
             (Call
                ("dfn'Jump",ATy(qTy,PTy(uTy,qTy)),
                 Var
                   ("v2",
                    PTy
                      (CTy"funcT",
                       PTy(CTy"shiftT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))),
              qVar"state")),
          (Call
             ("LoadConstant",CTy"instruction",Var("v3",PTy(FTy 7,FTy 24))),
           Apply
             (Call
                ("dfn'LoadConstant",ATy(qTy,PTy(uTy,qTy)),
                 Var("v3",PTy(FTy 7,FTy 24))),qVar"state")),
          (Call
             ("LoadDM",CTy"instruction",
              Var
                ("v4",
                 PTy
                   (CTy"funcT",
                    PTy
                      (CTy"shiftT",
                       PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
           Apply
             (Call
                ("dfn'LoadDM",ATy(qTy,PTy(uTy,qTy)),
                 Var
                   ("v4",
                    PTy
                      (CTy"funcT",
                       PTy
                         (CTy"shiftT",
                          PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
              qVar"state")),
          (Call
             ("Normal",CTy"instruction",
              Var
                ("v5",
                 PTy
                   (CTy"funcT",
                    PTy
                      (CTy"shiftT",
                       PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
           Apply
             (Call
                ("dfn'Normal",ATy(qTy,PTy(uTy,qTy)),
                 Var
                   ("v5",
                    PTy
                      (CTy"funcT",
                       PTy
                         (CTy"shiftT",
                          PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
              qVar"state")),
          (Call
             ("Out",CTy"instruction",
              Var
                ("v6",
                 PTy
                   (CTy"funcT",
                    PTy
                      (CTy"shiftT",
                       PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
           Apply
             (Call
                ("dfn'Out",ATy(qTy,PTy(uTy,qTy)),
                 Var
                   ("v6",
                    PTy
                      (CTy"funcT",
                       PTy
                         (CTy"shiftT",
                          PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
              qVar"state")),
          (Call
             ("StoreDM",CTy"instruction",
              Var
                ("v7",
                 PTy
                   (CTy"funcT",
                    PTy
                      (CTy"shiftT",
                       PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
           Apply
             (Call
                ("dfn'StoreDM",ATy(qTy,PTy(uTy,qTy)),
                 Var
                   ("v7",
                    PTy
                      (CTy"funcT",
                       PTy
                         (CTy"shiftT",
                          PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
              qVar"state")),
          (Call
             ("StoreIM",CTy"instruction",
              Var
                ("v8",
                 PTy
                   (CTy"funcT",
                    PTy
                      (CTy"shiftT",
                       PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
           Apply
             (Call
                ("dfn'StoreIM",ATy(qTy,PTy(uTy,qTy)),
                 Var
                   ("v8",
                    PTy
                      (CTy"funcT",
                       PTy
                         (CTy"shiftT",
                          PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
              qVar"state"))])))
;

val Decode_def = Def
  ("Decode",Var("opc",F32),
   Let
     (TP[bVar"b'31", bVar"b'30", bVar"b'29", bVar"b'28", bVar"b'27",
         bVar"b'26", bVar"b'25", bVar"b'24", bVar"b'23", bVar"b'22",
         bVar"b'21", bVar"b'20", bVar"b'19", bVar"b'18", bVar"b'17",
         bVar"b'16", bVar"b'15", bVar"b'14", bVar"b'13", bVar"b'12",
         bVar"b'11", bVar"b'10", bVar"b'9", bVar"b'8", bVar"b'7",
         bVar"b'6", bVar"b'5", bVar"b'4", bVar"b'3", bVar"b'2", bVar"b'1",
         bVar"b'0"],BL(32,Var("opc",F32)),
      ITE
        (bVar"b'24",
         Call
           ("LoadConstant",CTy"instruction",
            TP[EX(Var("opc",F32),LN 31,LN 25,FTy 7),
               EX(Var("opc",F32),LN 23,LN 0,FTy 24)]),
         Let
           (Var("Rw",FTy 7),EX(Var("opc",F32),LN 31,LN 25,FTy 7),
            Let
              (Var("Rb",FTy 7),EX(Var("opc",F32),LN 16,LN 10,FTy 7),
               Let
                 (Var("Ra",FTy 7),EX(Var("opc",F32),LN 23,LN 17,FTy 7),
                  Let
                    (Var("func",CTy"funcT"),
                     Mop
                       (Cast(CTy"funcT"),
                        EX(Var("opc",F32),LN 9,LN 7,FTy 3)),
                     Let
                       (Var("shift",CTy"shiftT"),
                        Mop
                          (Cast(CTy"shiftT"),
                           EX(Var("opc",F32),LN 6,LN 5,FTy 2)),
                        Let
                          (Var("skip",CTy"conditionT"),
                           Mop
                             (Cast(CTy"conditionT"),
                              EX(Var("opc",F32),LN 4,LN 3,FTy 2)),
                           CS
                             (EX(Var("opc",F32),LN 2,LN 0,FTy 3),
                              [(LW(0,3),
                                Call
                                  ("Normal",CTy"instruction",
                                   TP[Var("func",CTy"funcT"),
                                      Var("shift",CTy"shiftT"),
                                      Var("skip",CTy"conditionT"),
                                      Var("Rw",FTy 7), Var("Ra",FTy 7),
                                      Var("Rb",FTy 7)])),
                               (LW(1,3),
                                Call
                                  ("StoreDM",CTy"instruction",
                                   TP[Var("func",CTy"funcT"),
                                      Var("shift",CTy"shiftT"),
                                      Var("skip",CTy"conditionT"),
                                      Var("Rw",FTy 7), Var("Ra",FTy 7),
                                      Var("Rb",FTy 7)])),
                               (LW(2,3),
                                Call
                                  ("StoreIM",CTy"instruction",
                                   TP[Var("func",CTy"funcT"),
                                      Var("shift",CTy"shiftT"),
                                      Var("skip",CTy"conditionT"),
                                      Var("Rw",FTy 7), Var("Ra",FTy 7),
                                      Var("Rb",FTy 7)])),
                               (LW(3,3),
                                Call
                                  ("Out",CTy"instruction",
                                   TP[Var("func",CTy"funcT"),
                                      Var("shift",CTy"shiftT"),
                                      Var("skip",CTy"conditionT"),
                                      Var("Rw",FTy 7), Var("Ra",FTy 7),
                                      Var("Rb",FTy 7)])),
                               (LW(4,3),
                                Call
                                  ("LoadDM",CTy"instruction",
                                   TP[Var("func",CTy"funcT"),
                                      Var("shift",CTy"shiftT"),
                                      Var("skip",CTy"conditionT"),
                                      Var("Rw",FTy 7), Var("Ra",FTy 7),
                                      Var("Rb",FTy 7)])),
                               (LW(5,3),
                                Call
                                  ("In",CTy"instruction",
                                   TP[Var("func",CTy"funcT"),
                                      Var("shift",CTy"shiftT"),
                                      Var("skip",CTy"conditionT"),
                                      Var("Rw",FTy 7), Var("Ra",FTy 7),
                                      Var("Rb",FTy 7)])),
                               (LW(6,3),
                                Call
                                  ("Jump",CTy"instruction",
                                   TP[Var("func",CTy"funcT"),
                                      Var("shift",CTy"shiftT"),
                                      Var("Rw",FTy 7), Var("Ra",FTy 7),
                                      Var("Rb",FTy 7)])),
                               (LW(7,3),
                                Const("ReservedInstr",CTy"instruction"))]))))))))))
;

val Next_def = Def
  ("Next",qVar"state",
   Let
     (Var("v",CTy"instruction"),
      Call
        ("Decode",CTy"instruction",
         Apply
           (Dest("IM",ATy(FTy 10,F32),qVar"state"),
            Dest("PC",FTy 10,qVar"state"))),
      ITE
        (Mop
           (Not,
            EQ
              (Var("v",CTy"instruction"),
               Const("ReservedInstr",CTy"instruction"))),
         Apply
           (Call("Run",ATy(qTy,PTy(uTy,qTy)),Var("v",CTy"instruction")),
            qVar"state"),TP[LU, qVar"state"])))
;

val enc_def = Def
  ("enc",
   TP[Var
        ("args",
         PTy
           (CTy"funcT",
            PTy
              (CTy"shiftT",
               PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))),
      Var("opc",FTy 3)],
   Let
     (TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
         Var("skip",CTy"conditionT"), Var("w",FTy 7), Var("a",FTy 7),
         Var("b",FTy 7)],
      Var
        ("args",
         PTy
           (CTy"funcT",
            PTy
              (CTy"shiftT",
               PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))),
      CC[Var("w",FTy 7), LW(0,1), Var("a",FTy 7), Var("b",FTy 7),
         Mop(Cast(FTy 3),Var("func",CTy"funcT")),
         Mop(Cast(FTy 2),Var("shift",CTy"shiftT")),
         Mop(Cast(FTy 2),Var("skip",CTy"conditionT")), Var("opc",FTy 3)]))
;

val Encode_def = Def
  ("Encode",Var("i",CTy"instruction"),
   CS
     (Var("i",CTy"instruction"),
      [(Call
          ("LoadConstant",CTy"instruction",
           TP[Var("Rw",FTy 7), Var("imm",FTy 24)]),
        CC[Var("Rw",FTy 7), LW(1,1), Var("imm",FTy 24)]),
       (Call
          ("Normal",CTy"instruction",
           Var
             ("args",
              PTy
                (CTy"funcT",
                 PTy
                   (CTy"shiftT",
                    PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
        Call
          ("enc",F32,
           TP[Var
                ("args",
                 PTy
                   (CTy"funcT",
                    PTy
                      (CTy"shiftT",
                       PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))),
              LW(0,3)])),
       (Call
          ("StoreDM",CTy"instruction",
           Var
             ("args",
              PTy
                (CTy"funcT",
                 PTy
                   (CTy"shiftT",
                    PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
        Call
          ("enc",F32,
           TP[Var
                ("args",
                 PTy
                   (CTy"funcT",
                    PTy
                      (CTy"shiftT",
                       PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))),
              LW(1,3)])),
       (Call
          ("StoreIM",CTy"instruction",
           Var
             ("args",
              PTy
                (CTy"funcT",
                 PTy
                   (CTy"shiftT",
                    PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
        Call
          ("enc",F32,
           TP[Var
                ("args",
                 PTy
                   (CTy"funcT",
                    PTy
                      (CTy"shiftT",
                       PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))),
              LW(2,3)])),
       (Call
          ("Out",CTy"instruction",
           Var
             ("args",
              PTy
                (CTy"funcT",
                 PTy
                   (CTy"shiftT",
                    PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
        Call
          ("enc",F32,
           TP[Var
                ("args",
                 PTy
                   (CTy"funcT",
                    PTy
                      (CTy"shiftT",
                       PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))),
              LW(3,3)])),
       (Call
          ("LoadDM",CTy"instruction",
           Var
             ("args",
              PTy
                (CTy"funcT",
                 PTy
                   (CTy"shiftT",
                    PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
        Call
          ("enc",F32,
           TP[Var
                ("args",
                 PTy
                   (CTy"funcT",
                    PTy
                      (CTy"shiftT",
                       PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))),
              LW(4,3)])),
       (Call
          ("In",CTy"instruction",
           Var
             ("args",
              PTy
                (CTy"funcT",
                 PTy
                   (CTy"shiftT",
                    PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7))))))),
        Call
          ("enc",F32,
           TP[Var
                ("args",
                 PTy
                   (CTy"funcT",
                    PTy
                      (CTy"shiftT",
                       PTy(CTy"conditionT",PTy(FTy 7,PTy(FTy 7,FTy 7)))))),
              LW(5,3)])),
       (Call
          ("Jump",CTy"instruction",
           TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
              Var("Rw",FTy 7), Var("Ra",FTy 7), Var("Rb",FTy 7)]),
        Call
          ("enc",F32,
           TP[TP[Var("func",CTy"funcT"), Var("shift",CTy"shiftT"),
                 LC("skipNever",CTy"conditionT"), Var("Rw",FTy 7),
                 Var("Ra",FTy 7), Var("Rb",FTy 7)], LW(6,3)])),
       (Const("ReservedInstr",CTy"instruction"),LW(7,32))]))
;

val LoadIM_def = tDef
  ("LoadIM",TP[Var("a",FTy 10), Var("i",LTy(CTy"instruction"))],
   Close
     (qVar"state",
      CS
        (Var("i",LTy(CTy"instruction")),
         [(LNL(CTy"instruction"),TP[LU, qVar"state"]),
          (LLC([Var("h",CTy"instruction")],Var("t",LTy(CTy"instruction"))),
           Apply
             (Call
                ("LoadIM",ATy(qTy,PTy(uTy,qTy)),
                 TP[Bop(Add,Var("a",FTy 10),LW(1,10)),
                    Var("t",LTy(CTy"instruction"))]),
              Rupd
                ("IM",
                 TP[qVar"state",
                    Fupd
                      (Dest("IM",ATy(FTy 10,F32),qVar"state"),
                       Var("a",FTy 10),
                       Call("Encode",F32,Var("h",CTy"instruction")))])))])),
   Close
     (Var("x",PTy(PTy(FTy 10,LTy(CTy"instruction")),qTy)),
      CS
        (Var("x",PTy(PTy(FTy 10,LTy(CTy"instruction")),qTy)),
         [(TP[TP[Var("a",FTy 10), Var("i",LTy(CTy"instruction"))],
              AVar(qTy)],Mop(Length,Var("i",LTy(CTy"instruction"))))])))

val () = Import.finish 1
